<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-确认投保信息</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body style="background: rgba(244,245,246,1);">

<jsp:include page="../../index/multi_h.jsp"/>
<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/pc/index'/>">我的账户</a></li>
	  <li class="active">信息详情</li>
	</ol>--%>
	<div class="message-war"><!-- message-war start -->
		<h2>${ dto.product_name}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5><c:if test="${ not empty dto.external_reference }">保单号码：${ dto.external_reference}</c:if><c:if test="${ empty dto.external_reference }">订单号码：${ dto.trade_serial_number}</c:if></h5>
            <div class="mess-title"><h3>推荐人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
                        <td class="col-sm-4 col-xs-4">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                        <td class="col-sm-4 col-xs-4"></td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保人基本情况</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">公司名称(中文)</td>
                        <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].name_cn}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">公司名称(英文)</td>
                        <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].name_en}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">海关代码</td>
                        <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].customs_code}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">${vo.roleSubjectList[0].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[0].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</td>
                        <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].organization_code}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
                        <td class="col-sm-4 col-xs-4">${ reg_role}${ vo.roleSubjectList[0].reg_address}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">主要联系人姓名</td>
                        <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].link_name}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">主要联系人手机</td>
                        <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].link_tel}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">主要联系人电子信箱</td>
                        <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].link_email}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">法定代表人姓名</td>
                        <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].legal_name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">法定代表人电话</td>
                        <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].legal_phone}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">企业类型</td>
                        <td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[0].com_type,"comType","")}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">经营性质</td>
                        <td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[0].com_nature,"comNature","")}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">所属行业</td>
                        <td class="col-sm-4 col-xs-4">
                            ${ vo.roleSubjectList[0].industry}
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                        <td class="col-sm-4 col-xs-4"></td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>经营情况</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">本企业从业人员（人）</td>
                        <td class="col-sm-4 col-xs-4">${ vo.person_num}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">上年报关出口总金额（美元）</td>
                        <td class="col-sm-4 col-xs-4">${ vo.export_amount}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">未收汇金额（美元）</td>
                        <td class="col-sm-4 col-xs-4">${ vo.uncollected_amount}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">&nbsp;</td>
                        <td class="col-sm-4 col-xs-4">&nbsp;</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">未收汇原因</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${ vo.uncollected_cause}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>单一买方/开证行</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">年度保险费币种</td>
                        <td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.annual_currency,"annualCurrency","")}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">单一买家最高赔付限额（美元）</td>
                        <td class="col-sm-4 col-xs-4">${vo.pay_limit}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">赔偿比例(%)</td>
                        <td class="col-sm-4 col-xs-4">${vo.pro_rata*100}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">保单最高赔偿限额（美元）</td>
                        <td class="col-sm-4 col-xs-4">${vo.insured_amount}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">预计保费（美元）</td>
                        <td class="col-sm-4 col-xs-4">${vo.gross_premium}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">&nbsp;</td>
                        <td class="col-sm-4 col-xs-4">&nbsp;</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保计划信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">保险期间</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">
                            自&nbsp;${vo.inception_date}&nbsp;零时起，至&nbsp;${vo.planned_end_date}&nbsp;二十四时止
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">司法管辖</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">中华人民共和国司法管辖（港澳台除外）</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">争议解决方式</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">
                            ${ vo.disputes eq '1' ? '仲裁':'诉讼'}
                            <c:if test="${vo.disputes eq '1'}">
                                ，仲裁机构：${vo.arbitral_institution}
                            </c:if>
                            <c:if test="${vo.disputes eq '0'}">
                                ，诉讼所在地：${reg_rule}&nbsp;${vo.lawsuit_institution}
                            </c:if>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>其它需要说明事项</h3></div>
            <div class="imnotes">
                <p>${ vo.notes}</p>
            </div>
            <c:if test="${dto.policy_status eq '15'  && not empty dto.remarks }">
                <div class="mess-title"><h3>拒保原因</h3></div>
                <div class="affirm-warr download-table" style="border-color: red;">
                    <table class="table ">
                        <tbody>
                        <tr>
                            <td class=" col-sm-1 col-xs-1">备注</td>
                            <td class="col-sm-10 col-xs-10">${ dto.remarks }</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </c:if>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end -->
    <c:if test="${ not empty dto.external_reference }">
        <div class="row next-step">
            <div class="col-sm-6 col-xs-6 text-right pull-right">
                <p>
                    <c:if test="${ not empty dto.insure_path }">
                        <a target="_blank" href="${dto.insure_path}" onclick="tis();" class="ns-btn">保单下载</a>
                    </c:if>
                    <c:if test="${ empty dto.insure_path }">
                        <a href="javascript:void(0);" onclick="tis();requestEPolicy('${ dto.oid }',this);" class="ns-btn">保单下载</a>
                    </c:if>
                </p>
            </div>
        </div>
    </c:if>
    <%--<a target="_blank" href="javascript:;" onclick="tis()" class="ns-btn">提示</a>--%>
</div><!-- container end -->
<div class="partic-right fr layer_notice" style="display: none;width: 100%;">
    <div class="hot-products rfv">
        <ul>
            <li>
                <p style="text-indent: 2em;">为了方便政府审计结算，请您打印电子投保单及承诺函并分别在两份文档右下角投保单位盖章处申请盖章及企业法人签字处申请企业法人签字，后续专业客服人员会与您联系并上门收取。<small style="color: red;">（注：部分浏览器打印可能存在页眉页脚请手动取消）</small></p>
                <a href="javascript:void(0);" onclick="showPrintPromissoryModal('${ dto.oid }')" class="project" style="float: right;">打印承诺书</a>
                <a href="javascript:void(0);" onclick="showPrintPolicyModal('${ dto.oid }')" class="project" style="float: right;margin-right: 10px;">打印投保单</a>
            </li>
        </ul>
    </div>
</div>
<!-- 内容部分  注册  结束 -->
<jsp:include page="../../index/multi_f.jsp" />

<form id="dow-now" action="<c:url value='/synopsis/sodownload'/>" method="post">
	<input name="path" id="path-dow" type="hidden">
	<input name="name" id="name-dow" type="hidden">
</form>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js'/>"></script>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	function sodownload(path,name){
		path = path.split(".com/")[1];
		$("#path-dow").val(path);
		$("#name-dow").val(name);
		$("#dow-now").submit();
	}
    function requestEPolicy(_oid,_obj){
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas('',baseUrl+'/insurance/customs/policy/requestEPolicy/${dto.product_code}/'+_oid,false,true,function(json){
            if(json.statusCode == '200') {
                $(_obj).attr("href",json.navTabId);
                $(_obj).attr("onclick","");
                window.open(json.navTabId);
            }else{
                laySomenType(1,null,json.message,0);
                dialogClose(true);
            }
        });
    }
    $(function(){
        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    console.log($(this).prev());
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });

    });
    function showPrintPolicyModal(policyId){
        layer.open({
            type: 2,
            title:'投保单预览',
            scrollbar: false,
            area : [ '70%', '90%' ],
            shade : 0.8,
            skin: 'policyModal',
            btn: ['打印','取消'],
            content: baseUrl +'/api/xyx/printPolicy/'+policyId+'?ACCESS_TOKEN=${ACCESS_TOKEN}', //iframe的url
            yes:function(indexIframe, layero){
                var iframeWin = window[layero.find('iframe')[0]['name']]; //得到iframe页的窗口对象，执行iframe页的方法：iframeWin.method();
                iframeWin.printPage();
            }
        });
    }
    function showPrintPromissoryModal(policyId){
        layer.open({
            type: 2,
            title:'承诺函预览',
            scrollbar: false,
            area : [ '70%', '90%' ],
            shade : 0.8,
            skin: 'promissoryModal',
            btn: ['打印','取消'],
            content: baseUrl +'/api/xyx/print-promissory-note/'+policyId+'?ACCESS_TOKEN=${ACCESS_TOKEN}', //iframe的url
            yes:function(indexIframe, layero){
                var iframeWin = window[layero.find('iframe')[0]['name']]; //得到iframe页的窗口对象，执行iframe页的方法：iframeWin.method();
                iframeWin.printPage();
            }
        });
    }
    function tis(){
        layer.open({
            type: 1,
            title:'提示信息',
            area: ['420px', '205px'], //宽高
            content: $('.layer_notice')
        });

    }
</script>
<script type="text/javascript" src="<c:url value='/resources/js/insuranceFirm.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
</body>
</html>