<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<div class="query-criteria">
	<div class="paging-war mt-60 clearfix">
		<span>产品属性</span>
		<a href="#property-add" data-toggle="modal">添加</a>
		<a href="#property-amend" data-toggle="modal">修改</a>
	</div> 
	<div class="query-result" id='queryResult'>
		<table class="table product-table">
			<thead>
				<tr>
					<th></th>
					<th>编码</th>
					<th>名称</th>
					<th>是否已存在</th>
					<th>是否必录</th> 
					<th>是否隐藏</th>
					<th>数据类型</th>
					<th>控件类型</th> 
					<th>控件规则</th>
					<th>排序</th>
					<th>操作</th>
				</tr>
			</thead>
			<tbody>
				<c:choose>
					<c:when test="${empty specPropertyList }">
					<tr><td colspan="11" style="text-align: center;">无查询结果</td></tr>
					</c:when>
					<c:otherwise>
						<c:forEach items="${specPropertyList }" var="specProperty">
							<tr typs="spe" rel="${specProperty.oid}" onclick="selectRadio(this)">
								<td class="rad-io">
									<input type="radio" name="radio_spe" id="id_${specProperty.oid }" />
									<label for="id_${specProperty.oid }"></label>
								</td> 
								<td>${specProperty.external }</td>
								<td title="${specProperty.name }">${specProperty.name }</td>
								<td><c:if test="${specProperty.beanProperty eq '0' }">是</c:if><c:if test="${specProperty.beanProperty eq '1' }">否</c:if></td>
								<td><c:if test="${specProperty.isRequired eq '1' }">是</c:if><c:if test="${specProperty.isRequired eq '0' }">否</c:if></td>
								<td><c:if test="${specProperty.isHidden eq '1' }">是</c:if><c:if test="${specProperty.isHidden eq '0' }">否</c:if></td>
								<td>${specProperty.dataType.name }</td>
								<td>${specProperty.fieldType.name }</td>
								<td>${specProperty.controlRule.name }</td> 
								<td>${specProperty.seq }</td> 
								<td class="cr-7f">
									<a href="javascript:void(0);" onclick="deleteRow('${specProperty.oid}','deleteSpecProperty');" ><i class="glyphicon glyphicon-trash cr-7f"></i></a>
								</td>
							</tr>
						</c:forEach>
					</c:otherwise>
				</c:choose>
			</tbody>
		</table>
	</div>
	<!-- 分页 start -->
	<nav class="text-center">
		<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
	</nav>
	<form id="queryForm">
		<input type="hidden" name="modularityOid" id="modularityOid" value="${modularityOid}">
		<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
		<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
		<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	</form>
	<!-- 分页 end -->
</div>
<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
choiseMenu("evaluation");

var totalCount = Number($('#totalCount').val()) || 0;
var showCount = $('#showCount').val() || 5;
var limit = Number($('#numPerPage').val()) || 5;

$('#callBackPager').extendPagination({
totalCount: totalCount,
showCount: showCount,
limit: limit,
callback: function (curr, limit, totalCount) {
	getListForPage();
}
});
function getListForPage(){
	var index = layer.load(0, {shade: [0.3,'#808080']});
	$.ajax({
		type : 'POST',
		url : baseUrl + "/maintain/loadSpecProperty",
		data : $("#queryForm").serialize(),
		dataType : "text",
		cache : false,
		success : function(data) {
			layer.close(index);
			$("#queryResult").html(data);
		},
		error : function(XMLHttpRequest, textStatus, errorThrown) {
			layer.close(index);
			layer.msg(textStatus);
		}
	});
}
</script>