<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户(保险 )</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	   	<script type="text/javascript">
			var baseUrl = '${pageContext.request.contextPath }';
		</script>
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<form id="companyForm">
				<input name="oid" value="${userdetail.company.oid }" type="hidden"/>
				<div class="container corporate-infor"><!-- corporate-infor strar -->
					<div class="row">
						<div class="col-sm-12 col-xs-12 coin-left">
							<div class="conin-lsub">
								<div class="conin-lstop"> 
									<div class="user-img pa-t3" data-toggle="modal" data-target="#xiv">
										<c:if test="${empty userdetail.headerPath }"><img src="<c:url value='/resources/versions-2.0/images/account/user-img.png'/>"></c:if>
										<c:if test="${not empty userdetail.headerPath }"><img src="${userdetail.headerPath }"></c:if>
									</div> 
								</div> 
								<div class="user-reva">
									<h4>${empty userdetail.company.fullName ? userdetail.userName:userdetail.company.fullName }</h4>
									<div class="ur-sub">
										<p>
											<i class="bg-0474c8">${userdetail.role.description }</i>
											<i class="bg-0474c8">${userdetail.company.accountType.name }</i>
											<i class="bg-0474c8">${userdetail.company.productType.name }</i>
											<span>${empty userdetail.name ? "":userdetail.userName }</span>
											<a style="margin-left: 8px;" href="javascript:void(0);" onclick="goChangePassword();">修改密码</a>
										</p>
									</div>
								</div>
							<div class="clear"></div>
								<div class="fillin-war"  ${userdetail.company.accountType ne 'BRANCH'?'':'style="display: none;"'}>
										<div class="tender-war">
						<div class="query-criteria">
						<div style="margin-bottom: 10px;line-height: 1.1;width: 100%;height: 46px;background-color: #eff3f6;border-radius: 4px;">
							<h4 class="pull-left" style="margin:10px 0 10px 10px;">子公司账号</h4>
							<div class="pull-right"> 
								<p style="margin-top: 0;"><a style="margin:5px 10px 10px 0px;" href="#revamp-addSubCompany" data-toggle="modal" class="conserve pull-left">添加分公司</a></p>
							</div>
						</div>
							<div class="clear"></div>
							<div class="query-result" id="userListArea">
								<table class="table">
									<thead>
										<tr>
										  <th>子公司名称</th>
										  <th>账号</th>
										  <th>添加时间</th>
										  <th>地区</th>
										  <th>账户类型</th>
										  <th>操作</th> 
										</tr>
									</thead>
									<tbody>
										<c:choose>
											<c:when test="${empty userList || userList.size() < 1 }">
												<tr><td colspan="6" style="text-align: center;">无相关数据</td></tr>
											</c:when>
											<c:otherwise>
												<c:forEach items="${userList }" var="user">
												<tr>
													<td>${user.company.fullName }</td>
													<td>${user.userName }</td>
													<td><fmt:formatDate value='${user.registerDate }' pattern='yyyy-MM-dd HH:mm:ss' /></td>
													<td>${user.company.provinceName }${user.company.cityName }${user.company.countyName }</td>
													<td>${user.company.accountType.name }</td>
													<td><a href="javascript:void(0);"onclick="showEidtUser('${user.oid}');">编辑</a></td>
												</tr>
												</c:forEach>
											</c:otherwise>
										</c:choose>
									  </tbody>
								</table>
							</div>
						</div>
					</div>
								</div>
							</div>
						</div>
					</div> 
				</div><!-- corporate-infor end --> 
				<div class="clear"></div>
				</form>
				<!-- 分页 start -->
				<nav class="text-center">
					<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
				</nav>
				 <form id="orderForm">
	            	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
	            	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
	            	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	            </form>
				<!-- 分页 end --> 
			</div><!-- mar-content 右边内容块 end -->
		</div>
		<!-- 修改登录密码 start -->
		<div class="modal fade" id="revamp-regpsd" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">修改登录密码</h4>
				  </div>
				  <form id="passwordForm">
				  	<input type="hidden" value="${userdetail.oid }" name="oid">
					  <div class="modal-body">
					  	<p>
					  		<label>当前登录密码</label>
					  		<input type="password" class="form-control" onblur="validatePwdForms(this)" placeholder="请输入登录密码" id="oldPassword" name="oldPassword"/>
					  		<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					  	</p>
					  	<p>
					  		<label>新登录密码</label>
					  		<input type="password" class="form-control" onblur="validatePwdForms(this)" placeholder="请输入新的登录密码（6-20位）" id="password" name="password"/>
					  		<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					  	</p>
					  	<p>
					  		<label>确认新登录密码</label>
					  		<input type="password" class="form-control" onblur="validatePwdForms(this)" placeholder="请再次输入新的登录密码（6-20位）" id="rePwd" name="rePwd" />
					  		<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					  	</p>
					  	<div class="mt-20">
					  		<label>验证码</label>
					  		<div class="row">
					  			<div class="col-sm-9 col-xs-9">
					  				<input type="text" id="codePwd" class="form-control" placeholder="请输入验证码" />
					  				<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  			</div>
					  			<div class="col-sm-3 col-xs-3 pl-0">
					                <label class="valibox"><img id="imagePwd" src="<c:url value='/user/image.htm'/>" onclick="changeImg(this)" width="100%"/></label>
					  			</div>
					  		</div>
					  		<div class="clear"></div>
					  	</div> 
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
							<button type="button" class="btn notarize-btn pull-right" onclick="submitForm('password');">确认</button>
<!-- 							<a href="javascript:void(0);" class="notarize-btn" onclick="submitForm('password');">确认</a> -->
						</div>
					  </div> 
				  </form> 
				</div>
		  </div> 
		</div> 
		<!-- 修改登录密码 end -->
		<!-- 添加子公司 start -->
		<div class="modal fade" id="revamp-addSubCompany" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">添加子公司</h4>
				  </div>
				  <form id="addUserForm">
					  <div class="modal-body">
					  	<p class="">
					  		<label>子公司名称</label>
					  		<input type="text" class="form-control" placeholder="请输入子公司名称" id="fullName" name="company.fullName" onblur="baseCheckInput(this,'')"/>
					  		<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  	</p>
					  	<p class="">
					  		<label>账号</label>
					  		<input type="text" class="form-control" placeholder="请输入子公司账号" id="userName" name="userName" onblur="baseCheckInput(this,'')"/>
					  		<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  	</p>
					  	<p class="">
					  		<label>密码</label>
					  		<input type="password" class="form-control" placeholder="请输入子公司密码" id="pwd" name="password" onblur="baseCheckInput(this,'')"/>
					  		<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  	</p>
					  	<p>
					  		<label>地区</label>
					  		<div class="row">
								<input type="hidden" name="company.provinceName" id="provinceName_addCompany" value="">
               					<input type="hidden" name="company.cityName" id="cityName_addCompany" value="">
               					<input type="hidden" name="company.countyName" id="countyName_addCompany" value="">
								<div class="col-sm-4 col-xs-4">
									<select name="company.provinceCode" id="provinceID_addCompany" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;" onchange="javascript:$('#provinceName_addCompany').val($('#provinceID_addCompany option:selected').text());changeDistrict('cityID_addCompany', '', '2', this,'');">
										<option value="">请选择省</option>
		                                 <c:forEach items="${provinceList }" var="list">
		                                 <option value="${list.codes }">${list.named }</option>
		                                 </c:forEach>
									</select> 
								</div>
								<div class="col-sm-4 col-xs-4">
									<select name="company.cityCode" id="cityID_addCompany" onchange="javascript:$('#cityName_addCompany').val($('#cityID_addCompany option:selected').text());changeDistrict('countyID_addCompany', '', '3', this,'');" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
										<option value="">请选择市</option>
									</select> 
								</div>
								<div class="col-sm-4 col-xs-4">
									<select name="company.countyCode" id="countyID_addCompany" onchange="javascript:$('#countyName_addCompany').val($('#countyID_addCompany option:selected').text());" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
										<option value="">请选择区县</option>
									</select> 
								</div> 
							</div>
					  	</p>
					  	<c:if test="${userdetail.company.accountType eq 'HEADQUARTERS' }">
					  	<p>
					  		<label>区域代码</label>
					  		<div class="row">
								<div class="col-sm-12 col-xs-12">
									<select name="company.areaCode" id="areaCode_addCompany" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
										<option value="">请选择区域代码</option>
		                                 <c:forEach items="${areaList }" var="area">
		                                 <option value="${area.codes }">${area.named }</option>
		                                 </c:forEach>
									</select> 
								</div>
							</div>
					  	</p>
					  	</c:if>
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
							<button type="button" class="btn notarize-btn pull-right" onclick="submitaddUserForm();">确认</button>
						</div>
					  </div> 
				  </form> 
				</div>
		  </div> 
		</div> 
		<!-- 添加子公司 end -->
		
		<!-- 修改子公司 start -->
		<div class="modal fade" id="revamp-editSubCompany" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">编辑子公司</h4>
				  </div>
				  <form id="editUserForm">
					  <div class="modal-body" id="editUserArea">
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
							<button type="button" class="btn notarize-btn pull-right" onclick="submitEditUserForm();">确认</button>
						</div>
					  </div> 
				  </form> 
				</div>
		  </div> 
		</div> 
		<!-- 修改子公司 end -->
		
		<!-- 修改头像 start -->
		<div class="modal fade" id="xiv" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">修改头像</h4>
				  </div>
				  <form>
					  <div class="modal-body"> 
					  	<div class="xiv-container">
						  <div class="imageBox">
						    <div class="thumbBox"></div>
						    <div class="spinner">选择图片</div>
						  </div>
						  <div class="action"> 
						    <div class="new-contentarea text-center"> <a href="javascript:void(0)" class="upload-img">
						      <label for="upload-file">上传图像</label>
						      </a>
						      <input type="file" class="" name="upload-file" id="upload-file" />
						    </div>
						    <input type="button" id="btnCrop"  class="Btnsty_peyton" value="预览">
						    <input type="button" id="btnZoomIn" class="Btnsty_peyton" value="+"  >
						    <input type="button" id="btnZoomOut" class="Btnsty_peyton" value="-" >
						  </div>
						  <div class="cropped"></div>
						  <input type="hidden" name="headerPath" id="headerPath64">
						</div> 
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
							<button type="button" class="btn notarize-btn pull-right" onclick="headerUpload('headerPath64')">确认</button>
						</div>
					  </div> 
				  </form> 
				</div> 
		  </div> 
		</div> 
		<!-- 修改头像 end --> 
	</body>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/v-code.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/js/myAccount.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/cropbox.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/xiv.js' />"></script>
	<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
	<script type="text/javascript">
		choiseMenu("myAccount");
		
		var totalCount = Number($('#totalCount').val()) || 0;
		var showCount = $('#showCount').val() || 5;
		var limit = Number($('#numPerPage').val()) || 10;
		$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage("orderForm","userListArea");
		}
		});

		function getListForPage(formId,contentId){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/user/getCompanyUserListForPage",
				data : $("#"+formId).serialize(),
				dataType : "text",
				success : function(data) {
					layer.close(index);
					$("#"+contentId).html(data);			
				},
				error: function(){
					layer.close(index);
				}
			});
		}
		
		
		function submitaddUserForm(){
			if(checkUserForm("addUserForm")){
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/user/addCompanyUser",
					data : $("#addUserForm").serialize(),
					dataType : "json",
					async :false,
					success : function(data) {
						layer.close(index);
						layer.msg(data.message);
						if(data.status=="200"){
							$("#revamp-addSubCompany").modal('hide');
							window.location.reload();//刷新当前页面.
						}
					},
					error : function() {
						layer.close(index);
						alert('error');
					}
				});
			}
		}
		
		function checkUserForm(formId){
			var flag = true;
			$("#"+formId+" input").each(function(a,b){
				if($(b).attr("type")!="hidden" && !baseCheckInput(b,'')){
					flag= false;
					return false;
				}
			});
			if(flag){
				var provinceID = $("#"+formId+" select[name='company.provinceCode']").val();
				if(provinceID == ""){
					layer.msg("请选择省份");
					return false;
				}
				var cityID = $("#"+formId+" select[name='company.cityCode']").val();
				if(cityID == ""){
					layer.msg("请选择城市");
					return false;
				}
				var countyID = $("#"+formId+" select[name='company.countyCode']").val();
				if(countyID == ""){
					layer.msg("请选择区县");
					return false;
				}
			}
			return flag;
		}
		
		function showEidtUser(userId){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/user/getCompanyUserByOid",
				data : {"userId":userId},
				dataType : "text",
				async :false,
				success : function(data) {
					layer.close(index);
					$("#editUserArea").html(data);
					$("#revamp-editSubCompany").modal('show');
				},
				error : function() {
					layer.close(index);
					alert('error');
				}
			});
		}
		
		function submitEditUserForm(){
			if(checkUserForm("editUserForm")){
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/user/editCompanyUser.json",
					data : $("#editUserForm").serialize(),
					dataType : "json",
					async :false,
					success : function(data) {
						layer.close(index);
						layer.msg(data.message);
						if(data.status=="200"){
							$("#revamp-editSubCompany").modal('hide');
							window.location.reload();//刷新当前页面.
						}
					},
					error : function() {
						layer.close(index);
						alert('error');
					}
				});
			}
		}
		
		function headerUpload(bs64){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/user/headerUpload",
				data :{
					"headerPath":$("#"+bs64).val()
				},
				dataType : "json",
				success : function(json) {
					layer.close(index);
					if(json.statusCode == "200") {
						layer.msg(json.resultDto.message);
						window.location.reload();//刷新当前页面.
					}else{
						layer.msg(json.resultDto.message);
					}
					
				},
				error: function(){
					layer.close(index);
				}
			});
		}
		
		function goChangePassword() {
			changeImg("#imagePwd");
			$("#revamp-regpsd").modal();
		}
	</script>
</html>

