<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-应收账款管理-选择保单</title>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="../../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<div class="container w100-mt20"><!-- container start --> 
				<div class="nav-list" >
					<div class="row">
						<div class="col-sm-4 col-sm-4 active">
							<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">选择保单</span></p>
						</div>
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">2</i><span class="pull-left">应收账款查询</span></p>
						</div>
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">3</i><span class="pull-left">收款登记</span></p>
						</div> 
					</div>
				</div>
				<div class="message-war"><!-- message-war start --> 
					<div class="w-95-auto"><!-- w-95-auto start --> 
						<div class="mess-title"><h3>请选择一张保单</h3></div>
						<div class="affirm-warr"  id="policysArea"></div> 
					</div><!-- w-95-auto end -->
				</div><!-- message-war end -->
				<div class="row next-step">
					<div class="col-sm-6 col-sm-6">
							<!-- 分页 start -->
						<nav class="text-center">
							 <form id="policyForm">
				            	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
				            	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
				            	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
				            	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
				            </form>
						</nav>
					</div>
					<c:if test="${dwzPage.totalCount > 0}">
						<div class="col-sm-6 col-xs-6 text-right pull-right">
							<p> 
								<a href="javascript:void(0);" onclick="getNext()" class="ns-btn">下一步</a>
							</p> 
						</div>
					</c:if>
				</div>
			</div><!-- container end --> 
			</div><!-- mar-content 右边内容块 end -->
		</div>
	</body>
	
</html>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript">
		choiseMenu("receiveAmounts");
		var baseUrl = '${pageContext.request.contextPath}';
		var totalCount = Number($('#totalCount').val()) || 0;
		var showCount = $('#showCount').val() || 5;
		var limit = Number($('#numPerPage').val()) || 10;
		getListForPage("policyForm","policysArea");
		$('#callBackPager').extendPagination({
			totalCount: totalCount,
			showCount: showCount,
			limit: limit,
			callback: function (curr, limit, totalCount) {
				getListForPage("policyForm","policysArea");
			}
		});
		function getListForPage(formId,contentId){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/exports/receive/accounts/getPolicyListForPage",
				data : $("#"+formId).serialize(),
				dataType : "text",
				success : function(data) {
					layer.close(index);
					$("#"+contentId).html(data);			
				},
				error: function(){
					layer.close(index);
				}
			});
		}
		function  getNext(){
			var oid = $('input[name="oid"]:checked').val();
			window.location=baseUrl+"/exports/receive/accounts/choise/"+oid+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
		}
</script>
