<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags"%>
<%@ page import="org.springframework.security.core.AuthenticationException"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
<table class="table ">
	<tbody>
		<tr>
			<td class="col-sm-1 col-xs-1">选择</td>
			<td class="col-sm-2 col-xs-2">保单号</td>
			<td class="col-sm-3 col-xs-3">投保人名称</td>
			<td class="col-sm-1 col-xs-1">投保金额</td>
			<td class="col-sm-2 col-xs-2">保费</td>
			<td class="col-sm-3 col-xs-3">起止日期</td>
		</tr>

		<c:choose>
			<c:when test="${empty policyList}">
				<tr>
					<td colspan="6" style="text-align: center;">暂无相关数据</td>
				</tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${policyList}" var="policy" varStatus="status">
					<tr>
						<td class="col-sm-1 col-xs-1">
							<p class="col-sm-2 col-xs-2 rad-io">
								<span><input type="radio" name="oid" value="${policy.oid}" <c:if test="${status.index eq 0}"> checked="checked"</c:if>  id="radio_${policy.oid}">
								<label for="radio_${policy.oid}" class="pull-left m-0-13"></label></span>
							</p>
						</td>
						<td class="col-sm-2 col-xs-2">${policy.external_reference}</td>
						<td class="col-sm-3 col-xs-3">${policy.roleMap['Applicant'].fullName}</td>
						<td class="col-sm-1 col-xs-1">${policy.insuredAmount}CNY</td>
						<td class="col-sm-2 col-xs-2">${policy.premium}CNY</td>
						<td class="col-sm-3 col-xs-3">${policy.inceptionDate}至${policy.plannedEndDate}</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</tbody>
</table>