<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" />
<meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords"
	content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
<meta name="description"
	content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
<meta name="viewport"
	content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
<title>百联保-信用险业务管理-信用限额管理</title>

<link type="text/css" rel="stylesheet"
	href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>" />
<link type="text/css" rel="stylesheet"
	href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>" />
<link type="text/css" rel="stylesheet"
	href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
<link type="text/css" rel="stylesheet"
	href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />

<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
</head>
<body>
	<div class="container-fluid">
		<jsp:include page="../../pcHeader.jsp" />
		<div class="mar-content mt-80">
			<div class="container w100-mt20">
				<!-- container start -->
				
				<div class="message-war">
					<!-- message-war start -->
					<div class="w-95-auto">
						<!-- w-95-auto start -->
						<div class="mess-title">
							<h3>查找买家-查询条件</h3>
						</div>
						<div class="clearfix">
						    <form id="buyerForm" action="<c:url value='/exports/credit/findBuyersListForPage?ACCESS_TOKEN=${ACCESS_TOKEN}'/>"  method="post">
						 	 <input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
   								<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
								<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
							 </form>
						
							<div class="affirm-warr"  id="buyerArea">
								<table class="table ">
								 
									<tbody>
										<tr>
												<td class="col-sm-1 col-xs-1">买家代码</td>
												<td class="col-sm-2 col-xs-2">买方公司名称</td>
												<td class="col-sm-1 col-xs-1">国家</td>
												<td class="col-sm-1 col-xs-1">限额类型</td>
												<td class="col-sm-2 col-xs-2">申请限额</td>
												<td class="col-sm-1 col-xs-1">批复限额</td>
												<td class="col-sm-1 col-xs-1">批复状态</td>
												<td class="col-sm-2 col-xs-2">操作选项</td>
									</tr> 
									 <c:choose>
										<c:when test="${empty blist}">
											<tr>
												<td class="col-sm-12" colspan="8" style="text-align: center;">暂无相关数据</td>
											</tr>
										</c:when>
										<c:otherwise>
											<c:forEach items="${blist}" var="buyersQuota" varStatus="status">
												<tr>
													<td class="col-sm-1 col-xs-1">${buyersQuota.code}</td>
													<td class="col-sm-2 col-xs-2">${buyersQuota.customer_name}</td>
													<td class="col-sm-1 col-xs-1">${buyersQuota.country}</td>
													<td class="col-sm-1 col-xs-1">${fns:getDictLabel (buyersQuota.limit_type,"applicationLimitType","")}</td>
													<td class="col-sm-2 col-xs-2">${buyersQuota.amount_requested}</td>
													<td class="col-sm-1 col-xs-1"><c:if test="${not empty  buyersQuota.reply_amount}">${buyersQuota.reply_amount}</c:if> <c:if test="${empty   buyersQuota.reply_amount}">0</c:if> CNY</td>
													<td class="col-sm-1 col-xs-1">${fns:getDictLabel (buyersQuota.apply_type,"applyCreditAmountType","")}</td>
													<td class="col-sm-2 col-xs-2">
													<label><a href="<c:url value='/exports/credit/getApplyAmount/${buyersQuota.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">详情</a></label>
													<%-- <c:if test="${buyersQuota.apply_type eq '0'}">
														<label><a href="<c:url value='/exports/credit/delApplyAmount/${buyersQuota.oid}'/>">取消</a></label> 
													</c:if>
													<c:if test="${buyersQuota.apply_type eq '2'}">
													<label><a href="<c:url value='/exports/credit/updApplyAmount/${buyersQuota.oid}'/>">限额</a></label>
													</c:if>
													<c:if test="${buyersQuota.apply_type eq '1' || buyersQuota.apply_type eq '3'||buyersQuota.apply_type eq '4'}">
													        <c:if  test="${ not empty buyersQuota.code}">
																<label><a href="<c:url value='/exports/credit/updApplyAmount/${buyersQuota.oid}'/>">限额</a></label>
															</c:if>
															<c:if  test="${ empty buyersQuota.code}">
																<label><a href="<c:url value='/exports/credit/addApplyAmount?oid=${buyersQuota.oid}'/>">限额</a></label>
															</c:if>
													</c:if> --%>
													</td>
												</tr>
											</c:forEach>
										</c:otherwise>
									</c:choose>			
									</tbody>
								</table>
							</div>
							<form id="CreditAmountForm" method="post">
								<input type="hidden" name="bid" value="${bid}">
							</form>
							<c:if test="${not empty blist }">
								<div class="next-step">
									<div class="col-sm-3 col-xs-3 pull-right mt-20">
										
									</div>
								</div>
							</c:if>
							
							<!-- 分页  start-->
										<div class="row next-step">
												<div class="col-sm-6 col-sm-6">
														<!-- 分页 start -->
													<nav class="text-center">
	
											            	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
											           
													</nav>
													
												</div>
												
											</div>
							<!-- 分页 end -->
						</div>
					</div>
					<!-- w-95-auto end -->
				</div>
				<!-- message-war end -->
			</div>
			<!-- container end -->
		</div>
		<!-- mar-content 右边内容块 end -->
	</div>
</body>

</html>

<script src="<c:url value='/resources/js/extendPagination.js'/>"
	type="text/javascript"></script>
<script type="text/javascript">
choiseMenu("shipping");
	var baseUrl = '${pageContext.request.contextPath }';
	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#pageNum').val() || 5;
	var limit = Number($('#numPerPage').val()) || 10;
	
	$('#callBackPager').extendPagination({
		totalCount : totalCount,
		showCount : showCount,
		limit : limit,
		callback : function(curr, limit, totalCount) {
			getListForPage();
		}
	});
	function getListForPage() {
		var  formId="buyerForm";
		var  contentId="buyerArea";
		var index = layer.load(0, {
			shade : [ 0.3, '#808080' ]
		});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/exports/findLimitAmountNoSearch",
			data : $("#" + formId).serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#" + contentId).html(data);
			},
			error : function() {
				layer.close(index);
			}
		});
	}

	

	
	

</script>

