<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-逐单申报-查询</title>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	   	
	</head>
	<body>
		<div class="container-fluid">
		<jsp:include page="../../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<div class="container w100-mt20"><!-- container start --> 
				<div class="nav-list" >
					<div class="row">
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">1</i><span class=" pull-left">选择保单</span></p>
						</div>
						<div class="col-sm-4 col-sm-4 active">
							<p><i class="glyphicon glyphicon-ok  pull-left"></i><span class="pull-left">逐单申报查询</span></p>
						</div>
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">3</i><span class="pull-left">新增/修改</span></p>
						</div> 
					</div>
				</div>

				<form id="searchForm" name="searchForm">
				<div class="message-war"><!-- message-war start --> 
						<div class="w-95-auto"><!-- w-95-auto start --> 
							<div class="mess-title"><h3>查询条件</h3></div>
							<div class="clearfix">
								<div class="clearfix">
									<div class="col-sm-4 col-xs-4">
										<p>保单号</p>
										<input type="text" id="externalReference" name="external_reference" class="form-control" value="${vo.orderFormVo.external_reference}" readonly="readonly">
									</div>
									<div class="col-sm-4 col-xs-4">
										<p>被保险人</p>
										<select id="insured" name="insured" class="form-control" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
											<option value="">-----请选择被保险人-----</option>
											<c:forEach items="${vo.insuredNameList}" var="insuredList">
			                                 <option value="${insuredList}">${insuredList}</option>
			                                </c:forEach>
										</select> 
									</div>
									<div class="col-sm-4 col-xs-4">
										<p>申报类型</p> 
										<div class="col-sm-12 col-xs-12">
										<div class="row">
											<div class="col-sm-12 col-xs-12 rad-io">
												<span><input type="radio" name="declare_type" id="declare_type" value="0" checked="checked" readonly="readonly">
												<label for="radio_tb" class="pull-left"></label><strong class="pull-left lh-17">投保出运</strong></span>
											</div>
										</div>
									</div>
									</div> 
								</div>
								<div class="clearfix">
									<div class="col-sm-4 col-xs-4">
										<p>国家</p>
										<select name="country" id="country" class="form-control" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
											<option value="">-----请选择-----</option>
											<c:forEach items="${vo.countryList}" var="countrylist">
			                                 <option value="${countrylist}">${countrylist}</option>
			                                </c:forEach>
										</select>
									</div> 
									<div class="col-sm-4 col-xs-4">
										<p>买家名称</p>
										<input type="text" id="buyer_name" name="buyer_name" class="form-control" placeholder="请输入买家名称">
									</div>
									<div class="col-sm-4 col-xs-4">
										<p>出运期间</p> 
										<div class="row fs-lh34">
											<div class="col-sm-5 col-xs-5">
												<label class="pull-left"><input id="startDate" name="startDate" class="laydate-icon form-control"></label>
											</div>
											<div class="col-sm-1 col-xs-1">到</div>
											<div class="col-sm-5 col-xs-5">
												<input placeholder="" id="endDate" name="endDate" class="laydate-icon form-control">
											</div>
										</div>
									</div> 
									<div class="next-step">
										<div class="col-sm-3 col-xs-3 pull-right mt-20"> 
											<a href="javascript:void(0);" onclick="doSearch()" class="ns-btn">查询</a> 
										</div>
									</div>
								</div> 
							</div>
						</div><!-- w-95-auto end -->
					</div><!-- message-war end -->
				</form>

				<!-- 以下供查询使用 -->
				<div class="message-war"><!-- message-war start --> 
					<div class="w-95-auto"><!-- w-95-auto start --> 
						<div class="mess-title"><h3>查询结果</h3></div>
						<div class="affirm-warr"  id="policysArea"></div> 
					</div><!-- w-95-auto end -->
				</div><!-- message-war end -->
				<div class="row next-step">
					<div class="col-sm-6 col-sm-6">
						<!-- 分页 start -->
						<nav class="text-center">
							 <form id="policyForm">
				            	<input type="hidden" name="pageNum" id="pageNum" value="${page.pageNum}">
				            	<input type="hidden" name="numPerPage" id="numPerPage" value="${page.numPerPage}">
				            	<input type="hidden" name="totalCount" id="totalCount" value="${page.totalCount}">
				            	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
				            </form>
						</nav>
					</div>
					<div class="col-sm-6 col-xs-6 pull-right">
						<p> 
							<a href="javascript:void(0);" onclick="addDeclare('${vo.orderFormVo.oid}')" class="ns-btn">新增投保出运</a> 
							<a href="javascript:void(0);" onclick="goBack()" class="ns-btn">上一步</a> 
						</p> 
					</div>
				</div>
				
			</div><!-- container end --> 
			</div><!-- mar-content 右边内容块 end -->
		</div>
	</body>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js'/>"></script>
		<script type="text/javascript" src="<c:url value='/resources/js/extendPagination.js'/>" ></script>
		<script type="text/javascript">
		choiseMenu("declare");
		var baseUrl = '${pageContext.request.contextPath}';
		var totalCount = Number($('#totalCount').val()) || 0;
		var showCount = $('#showCount').val() || 5;
		var limit = Number($('#numPerPage').val()) || 10;
		
		getListForPage("policyForm","policysArea");
		$('#callBackPager').extendPagination({
			totalCount: totalCount,
			showCount: showCount,
			limit: limit,
			callback: function (curr, limit, totalCount) {
				getListForPage("policyForm","policysArea");
			}
		});
		
		function getListForPage(formId,contentId){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/ship/declare/getDeclareByPolicyIdForPage/"+'${orderFormId}',
				data : $("#"+formId).serialize(),
				dataType : "text",
				success : function(data) {
					layer.close(index);
					$("#"+contentId).html(data);			
				},
				error: function(){
					layer.close(index);
				}
			});
		}
		
		 function doSearch(){
			getListForPage2("policyForm","policysArea");
			
			var totalCountBack = $("#totalCount").val();
			var numPerPageBack = $("#numPerPage").val();
			alert(totalCountBack+""+numPerPageBack);
			
			
			$('#callBackPager').extendPagination({
				totalCount: totalCountBack,
				showCount: showCount,
				limit: numPerPageBack,
				callback: function (curr, limit, totalCount) {
					getListForPage2("policyForm","policysArea");
				}
			});
			function getListForPage2(formId,contentId){
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/ship/declare/getDeclareByPolicyIdForPage/"+'${orderFormId}',
					data : {pageNum:$('#pageNum').val(),
							numPerPage:$('#numPerPage').val(),
							totalCount:$('#totalCount').val(),
							insured:$('#insured').val(),
							declare_type:$('#declare_type').val(),
							country:$('#country').val(),
							buyer_name:$('#buyer_name').val(),
							startDate:$('#startDate').val(),
							endDate:$('#endDate').val()},
					dataType : "text",
					success : function(data) {
						layer.close(index);
						$("#"+contentId).html(data);
						var totalCountBack = $("#totalCountBack").val();
						var numPerPageBack = $("#numPerPageBack").val();
						var pageNumBack = $("#pageNumBack").val();
						$("#pageNum").val(pageNumBack);
						$("#numPerPage").val(numPerPageBack);
						$("#totalCount").val(totalCountBack);
					},
					error: function(){
						layer.close(index);
					}
				});
			}
		} 
		 
		function goModify(declareId,invoice_id){
			var externalReference = '${vo.orderFormVo.external_reference}';
			window.location = baseUrl + "/ship/declare/goDeclareDetail/" + "2" + "/" + declareId + "/" + invoice_id + "/" + externalReference+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
		}
		
		function goDetail(declareId,invoice_id){
			var externalReference = '${vo.orderFormVo.external_reference}';
			window.location = baseUrl + "/ship/declare/goDeclareDetail/" + "1" + "/" + declareId + "/" + invoice_id + "/" + externalReference+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
		}
		
		function goBack(){
			window.location = baseUrl + "/ship/declare/index?ACCESS_TOKEN=${ACCESS_TOKEN}";
		}
		
		
		function goDelete(shipDeclareId,invoice_id){
			layer.confirm('确定删除此出运订单？', {
				  skin: 'confirmTip',
				  btn: ['确定','取消'] //按钮
				}, function(){
					layer.closeAll();
					var index = layer.load(0, {shade: [0.3,'#808080']});
					$.ajax({
						type : 'POST',
						url:baseUrl + "/ship/declare/deleteShipDeclareById/"+shipDeclareId+"/"+invoice_id,
						dataType : "json",
						success : function(data) {
							if(data.statusCode == "200"){
								layer.msg(data.message);
								//刷新当前页面
								window.location.reload();
							}
						},
						error: function(){
							layer.msg("数据出错，请联系管理员！");
							window.location.reload();
						}
					});
				});
			}
		
		function addDeclare(orderFormId) {
			window.location = baseUrl + "/ship/declare/addDeclare/" + orderFormId+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
		}
		
		//日期范围限制-放开限制 -liuminda
		var startDate = {
		    elem: '#startDate',
		    format: 'YYYY-MM-DD',
		    min: '2015-01-01', //设定最小日期为当前日期
		    max: '2099-06-16', //最大日期
		    istime: true,
		    istoday: false,
		  /*   choose: function(datas){
		        endDate.min = datas; //开始日选好后，重置结束日的最小日期
		        endDate.startDate = datas //将结束日的初始值设定为开始日
				endDate.max = time1;
		    } */
		};
		var endDate = {
		    elem: '#endDate',
		    format: 'YYYY-MM-DD',
		    min: '2015-01-01',
		    max: '2099-06-16',
		    istime: true,
		    istoday: false,
		    /* choose: function(datas){
		        startDate.max = datas; //结束日选好后，充值开始日的最大日期
		    } */
		};
		Date.prototype.Format = function (fmt) { //author: meizz 
		    var o = {
		        "M+": this.getMonth() + 1, //月份 
		        "d+": this.getDate(), //日 
		        "h+": this.getHours(), //小时 
		        "m+": this.getMinutes(), //分 
		        "s+": this.getSeconds(), //秒 
		        "q+": Math.floor((this.getMonth() + 3) / 3), //季度 
		        "S": this.getMilliseconds() //毫秒 
		    };
		    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
		    for (var k in o)
		    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
		    return fmt;
		}
		laydate(startDate);
		laydate(endDate);
	</script>
</html>




