<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-逐单申报-选择买家</title>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
		<jsp:include page="../../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<div class="container w100-mt20"><!-- container start --> 
				<div class="nav-list" >
					<div class="row">
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">1</i><span class=" pull-left">选择保单</span></p>
						</div>
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">2</i><span class="pull-left">逐单申报查询</span></p>
						</div>
						<div class="col-sm-4 col-sm-4 active">
							<p><i class="glyphicon glyphicon-ok  pull-left"></i><span class="pull-left">新增/修改</span></p>
						</div> 
					</div>
				</div>

				<form id="searchForm" name="searchForm">
				<div class="message-war"><!-- message-war start --> 
						<div class="w-95-auto"><!-- w-95-auto start --> 
							<div class="mess-title"><h3>查找买家-查询条件</h3></div>
							<div class="clearfix">
								<div class="clearfix">
									<div class="col-sm-4 col-xs-4">
										<p>请选择国家</p>
										<select id="countrySearch" name="countrySearch" class="form-control" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
											<option value="">-----请选择国家-----</option>
											<c:forEach items="${vo.countryList}" var="countryList">
			                                 <option value="${countryList}">${countryList}</option>
			                                </c:forEach>
										</select> 
									</div>
									<div class="col-sm-4 col-xs-4">
										<p>买家公司名称</p>
										<input type="text" id="companySearch" name="companySearch" class="form-control">
									</div>
									<div class="col-sm-4 col-xs-4">
										<div class="next-step">
											<div class="col-sm-3 col-xs-3 pull-right mt-20"> 
												<a href="javascript:void(0);" onclick="doSearch()" class="ns-btn">查询</a> 
											</div>
										</div>
									</div>
								</div>
							</div>
						</div><!-- w-95-auto end -->
					</div><!-- message-war end -->
				</form>

				<!-- 以下供查询使用 -->
				<div class="message-war"><!-- message-war start --> 
					<div class="w-95-auto"><!-- w-95-auto start --> 
						<div class="mess-title"><h3>查询结果</h3></div>
						<div class="affirm-warr"  id="policysArea"></div> 
					</div><!-- w-95-auto end -->
				</div><!-- message-war end -->
				<div class="row next-step">
					<div class="col-sm-6 col-sm-6">
							<!-- 分页 start -->
						<nav class="text-center">
							 <form id="policyForm">
				            	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
				            	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
				            	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
				            	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
				            </form>
						</nav>
					</div>
					<c:choose>
						<c:when test="${empty modifyType}">
							<div class="col-sm-6 col-xs-6 pull-right">
								<p> 
									<a href="javascript:void(0);" onclick="goSure('${orderFormId}')" class="ns-btn">确认</a> 
									<a href="javascript:void(0);" onclick="goBack('${orderFormId}')" class="ns-btn">上一步</a> 
								</p> 
							</div>
						</c:when>
						<c:when test="${not empty modifyType}">
							<div class="col-sm-6 col-xs-6 pull-right">
								<p> 
									<a href="javascript:void(0);" onclick="goSureWithModify('${orderFormId}','${declareId}','${invoiceId}','${externalReference}')" class="ns-btn">确认</a>
									<a href="javascript:void(0);" onclick="goBackWithModify()" class="ns-btn">上一步</a> 
								</p> 
							</div>
						</c:when>
					</c:choose>
					
				</div>
				
			</div><!-- container end --> 
			</div><!-- mar-content 右边内容块 end -->
		</div>
	</body> 
</html>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/extendPagination.js'/>" ></script>
<script type="text/javascript">
	choiseMenu("declare");
	var baseUrl = '${pageContext.request.contextPath}';
	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 10;
	getListForPage("policyForm","policysArea");
	$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage("policyForm","policysArea");
		}
	});
	
	function getListForPage(formId,contentId){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/ship/declare/findBuyersByOrderFormId/"+'${orderFormId}',
			data : $("#"+formId).serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#"+contentId).html(data);			
			},
			error: function(){
				layer.close(index);
			}
		});
	}
	
	
	function goSure(orderFormId){
		var ins_top_buyers_id = $('input[name="ins_top_buyers_id"]:checked').val();
		var codeId = "#code_" + ins_top_buyers_id;
		var code = $(codeId).val();
		var insured = '${insured}';
		if(insured != null && insured != ""){
			/*window.location = baseUrl + "/ship/declare/addDeclareWithBuyers/" + orderFormId + "/" + ins_top_buyers_id + "/" + code + "?insured=" + insured;*/
			window.location = baseUrl + "/ship/declare/addDeclareWithBuyers/" + orderFormId + "/" + ins_top_buyers_id + "?insured=" + insured+"&ACCESS_TOKEN=${ACCESS_TOKEN}";
		}else{
			/*window.location = baseUrl + "/ship/declare/addDeclareWithBuyers/" + orderFormId + "/" + ins_top_buyers_id + "/" + code;*/
			window.location = baseUrl + "/ship/declare/addDeclareWithBuyers/" + orderFormId + "/" + ins_top_buyers_id+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
		}
	}
	
	function goSureWithModify(orderFormId,declareId,invoiceId,externalReference){
		var ins_top_buyers_id = $('input[name="ins_top_buyers_id"]:checked').val();
		var codeId = "#code_" + ins_top_buyers_id;
		var code = $(codeId).val();
		window.location = baseUrl + "/ship/declare/modifyDeclareWithBuyers/" + orderFormId + "/" + ins_top_buyers_id + "/" + code + "/" + declareId + "/" + invoiceId + "/" + externalReference+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
	
	function goBack(orderFormId){
		window.location = baseUrl + "/ship/declare/addDeclare/" + orderFormId+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
	
	function goBackWithModify(){
		var declareId = '${declareId}';
		var invoiceId = '${invoiceId}';
		var externalReference = '${externalReference}';
		window.location = baseUrl + "/ship/declare/goDeclareDetail/" + "2" + "/" + declareId + "/" + invoiceId + "/" + externalReference+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
	
	
	 function doSearch(){
			getListForPage2("policyForm","policysArea");
			$('#callBackPager').extendPagination({
				totalCount: totalCount,
				showCount: showCount,
				limit: limit,
				callback: function (curr, limit, totalCount) {
					getListForPage2("policyForm","policysArea");
				}
			});
			function getListForPage2(formId,contentId){
				var countrySearch = $('#countrySearch').val();
				var companySearch = $('#companySearch').val();
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/ship/declare/findBuyersByOrderFormId/"+'${orderFormId}'+"?countrySearch="+countrySearch+"&companySearch="+companySearch,
					data : {pageNum:$('#pageNum').val(),
							numPerPage:$('#numPerPage').val(),
							totalCount:$('#totalCount').val()},
					dataType : "text",
					success : function(data) {
						layer.close(index);
						$("#"+contentId).html(data);			
					},
					error: function(){
						layer.close(index);
					}
				});
			}
		} 
	
</script>


