<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<table class="table ">
	<tbody>
		<tr>
			<td class="col-sm-2 col-xs-2">发票号</td>
			<td class="col-sm-2 col-xs-2">买方公司名称</td>
			<td class="col-sm-1 col-xs-1">国家</td>
			<td class="col-sm-1 col-xs-1">结算方式</td>
			<td class="col-sm-2 col-xs-2">发票金额</td>
			<td class="col-sm-2 col-xs-2">出运日期</td>
			<td class="col-sm-1 col-xs-1">申报类型</td>
			<td class="col-sm-2 col-xs-2">操作选项</td>
		</tr>
		<c:choose>
			<c:when test="${empty voList}">
				<tr>
					<td colspan="8" style="text-align: center;">暂无相关数据</td>
				</tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${voList}" var="vo" varStatus="status">
					<tr>
						<td class="col-sm-2 col-xs-2">${vo.invoice_no}</td>
						<td class="col-sm-2 col-xs-2">${vo.company}</td>
						<td class="col-sm-1 col-xs-1">${vo.country}</td>
						<td class="col-sm-1 col-xs-1">${vo.payment_terms}</td>
						<td class="col-sm-2 col-xs-2">${vo.invoice_amounts}USD</td>
						<td class="col-sm-2 col-xs-2"><fmt:formatDate pattern="yyyy-MM-dd hh:mm:ss" value="${vo.delivery_time}"/></td>
						<td class="col-sm-1 col-xs-1">${vo.declare_type}</td>
						<td class="col-sm-2 col-xs-2">
							<c:choose>
								<c:when test="${vo.view_type eq '0'}">
									<label><a href="javascript:;" onclick="goModify('${vo.declare_id}','${vo.invoice_id}')" id="Modify" name="Modify">修改</a></label>
								</c:when>
								<c:when test="${vo.view_type eq '1'}">
									<label><a href="javascript:;" onclick="goDetail('${vo.declare_id}','${vo.invoice_id}')" id="Ddetail" name="Ddetail">详情</a></label>
								</c:when>
								<c:otherwise>
									<label><a href="javascript:;" id="Other" name="Other">--</a></label>
								</c:otherwise>
							</c:choose>
							<label><a href="javascript:;">|</a></label> 
							<label><a href="javascript:;" onclick="goDelete('${vo.declare_id}','${vo.invoice_id}')" id="Dcancle" name="Dcancle">取消申报</a></label>
						</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</tbody>
</table>

