<div id="totalDelete"><!-- 包含全部，方便搜索是全部替换 -->
<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
<div class="affirm-warr"  id="pageResult">
<table class="table">
	<tbody>
		<tr>
			<td class="col-sm-2 col-xs-2">发票号</td>
			<td class="col-sm-2 col-xs-2">买方公司名称</td>
			<td class="col-sm-1 col-xs-1">国家</td>
			<td class="col-sm-1 col-xs-1">结算方式</td>
			<td class="col-sm-2 col-xs-2">发票金额</td>
			<td class="col-sm-2 col-xs-2">出运日期</td>
			<td class="col-sm-1 col-xs-1">申报类型</td>
			<td class="col-sm-2 col-xs-2">操作选项</td>
		</tr>
		<c:choose>
			<c:when test="${empty voList}">
				<tr>
					<td colspan="8" style="text-align: center;">暂无相关数据</td>
				</tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${voList}" var="vo" varStatus="status">
					<tr>
						<td class="col-sm-2 col-xs-2">${vo.invoice_no}</td>
						<td class="col-sm-2 col-xs-2">${vo.company}</td>
						<td class="col-sm-1 col-xs-1">${vo.country}</td>
						<td class="col-sm-1 col-xs-1">${vo.payment_terms}</td>
						<td class="col-sm-2 col-xs-2">${vo.invoice_amounts}USD</td>
						<td class="col-sm-2 col-xs-2"><fmt:formatDate pattern="yyyy-MM-dd hh:mm:ss" value="${vo.delivery_time}"/></td>
						<td class="col-sm-1 col-xs-1">${vo.declare_type}</td>
						<td class="col-sm-2 col-xs-2">
							<c:choose>
								<c:when test="${vo.view_type eq '0'}">
									<label><a href="javascript:;" onclick="goModify('${vo.declare_id}','${vo.invoice_id}')" id="Modify" name="Modify">修改</a></label>
								</c:when>
								<c:when test="${vo.view_type eq '1'}">
									<label><a href="javascript:;" onclick="goDetail('${vo.declare_id}','${vo.invoice_id}')" id="Ddetail" name="Ddetail">详情</a></label>
								</c:when>
								<c:otherwise>
									<label><a href="javascript:;" id="Other" name="Other">--</a></label>
								</c:otherwise>
							</c:choose>
							<label><a href="javascript:;">|</a></label> 
							<label><a href="javascript:;" onclick="goDelete('${vo.declare_id}','${vo.invoice_id}')" id="Dcancle" name="Dcancle">取消申报</a></label>
						</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</tbody>
</table>
</div>


<div class="row next-step" id="forDelete">
	<div class="col-sm-6 col-sm-6">
		<!-- 分页 start -->
		<nav class="text-center">
			<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
		</nav>
	</div>
	<div class="col-sm-6 col-xs-6 pull-right">
		<p>
			<a href="javascript:void(0);" onclick="addDeclare('${orderFormId}')" class="ns-btn">新增投保出运</a>
			<a href="javascript:void(0);" onclick="goBack()" class="ns-btn">上一步</a>
		</p>
	</div>
</div>

<script>
	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 5;
	$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage();
		}
	});
	function getListForPage(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/ship/declare/getDeclareByPolicyIdForPage_new/"+'${orderFormId}',
			data : {pageNum:$('#pageNum').val(),
					numPerPage:$('#numPerPage').val(),
					totalCount:$('#totalCount').val()},
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#pageResult").html(data);
			},
			error: function(){
				layer.close(index);
			}
		});
	}
	
	function goBack(){
		window.location = baseUrl + "/ship/declare/index?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
	
	function goModify(declareId,invoiceId){
		var externalReference = '${externalReference}';
		window.location = baseUrl + "/ship/declare/goDeclareDetail/" + "2" + "/" + declareId + "/" + invoiceId + "/" + externalReference+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
	
	function goDetail(declareId,invoiceId){
		var externalReference = '${externalReference}';
		window.location = baseUrl + "/ship/declare/goDeclareDetail/" + "1" + "/" + declareId + "/" + invoiceId + "/" + externalReference+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
	
	function goDelete(shipDeclareId,invoiceId){
		layer.confirm('确定删除此出运订单？', {
			  btn: ['确定','取消'] //按钮
			}, function(){
				layer.closeAll();
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url:baseUrl + "/ship/declare/deleteShipDeclareById/"+shipDeclareId+"/"+invoiceId,
					dataType : "json",
					success : function(data) {
						if(data.statusCode == "200"){
							layer.msg(data.message);
							//刷新当前页面
							window.location.reload();
						}
					},
					error: function(){
						layer.msg("数据出错，请联系管理员！");
						window.location.reload();
					}
				});
			});
		}
	
	function addDeclare(orderFormId) {
		window.location = baseUrl + "/ship/declare/addDeclare/" + orderFormId+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
</script>

</div>