<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" />
<meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords"
	content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
<meta name="description"
	content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
<meta name="viewport"
	content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
<title>百联保-信用险业务管理-信用限额管理</title>

<link type="text/css" rel="stylesheet"
	href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>" />
<link type="text/css" rel="stylesheet"
	href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>" />
<link type="text/css" rel="stylesheet"
	href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
<link type="text/css" rel="stylesheet"
	href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />

<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
</head>
<body>
	<div class="container-fluid">
		<jsp:include page="../../pcHeader.jsp" />
		<div class="mar-content mt-80">
			<div class="container w100-mt20">
				<!-- container start -->
				<div class="nav-list">
					<div class="row">
						<div class="col-sm-4 col-sm-4 active">
							<p>
								<i class="glyphicon glyphicon-ok pull-left "></i><span
									class=" pull-left">选择保单</span>
							</p>
						</div>
						<div class="col-sm-4 col-sm-4 active">
							<p>
								<i class="glyphicon glyphicon-ok pull-left"></i><span
									class="pull-left">限额查询</span>
							</p>
						</div>
						<div class="col-sm-4 col-sm-4 active">
							<p>
								<i class="glyphicon glyphicon-ok pull-left"></i><span
									class="pull-left">申请/修改</span>
							</p>
						</div>
					</div>
				</div>
				<div class="message-war">
					<!-- message-war start -->
					<div class="w-95-auto">
						<!-- w-95-auto start -->
						<div class="mess-title">
							<h3>查找买家-查询条件</h3>
						</div>
						<div class="clearfix">
						    <form id="buyerForm" action="<c:url value='/exports/credit/findBuyersListForPage?ACCESS_TOKEN=${ACCESS_TOKEN}'/>"  method="post">
						  <input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
   								<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
								<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>州/地区</p>
									<input type="text" name="address" class="form-control" placeholder="">

								</div>
								<div class="col-sm-4 col-xs-4">
									<p>请选择国家</p>
									<select name="" class="form-control"
										style="background: url(images/public/select-btn.jpg) 97% no-repeat #fafafc;">
										<c:forEach items="${countryList}"  var="c">
											<option value="${c.value}" >${c.value}</option>
										</c:forEach>
									
									</select>
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>所在城市</p>
									<input type="text" name="city" class="form-control" placeholder="">
								</div>
							</div>
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>买家代码</p>
									<input type="text" class="form-control" name="code" id="code" placeholder="">
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>证件号码</p>
									<label class="col-sm-5 col-xs-5 pl-0"> <select
										class="form-control"
										style="background: url(images/public/select-btn.jpg) 97% no-repeat #fafafc;">
<%--
											<option>身份证</option>
--%>

										  <option value="4">组织机构代码证</option>
									</select>
									</label> <label class="col-sm-7 col-xs-7"> <input type="text"
										class="form-control" placeholder="">
									</label>
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>买家名称</p>
									<input type="text" class="form-control" name="customer_name"  placeholder="">
								</div>
							</div>
							
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>电话号码</p>
									<input type="text" class="form-control" name="phone" placeholder="">
								</div>
								<div class="next-step">
									<div class="col-sm-3 col-xs-3 pull-right mt-20">
										<a onclick="doSearch()" class="ns-btn">查询</a>
									</div>
								</div>
							</div>
							 </form>
							<div class="mess-title">
								<h3>查询结果</h3>
							</div>
							<div class="affirm-warr"  id="buyerArea">
								<table class="table ">
								 
									<tbody>
										<tr>
											<td class="col-sm-1 col-xs-1">选择</td>
											<td class="col-sm-2 col-xs-2">买家代码</td>
											<td class="col-sm-3 col-xs-3">买方公司名称</td>
											<td class="col-sm-1 col-xs-1">国家</td>
											<td class="col-sm-2 col-xs-2">城市</td>
											<td class="col-sm-3 col-xs-3">操作选项</td>
										</tr>
										<c:forEach items="${blist}" var="buyer" varStatus="status">
											<tr>
												<td class="col-sm-1 col-xs-1">
													<p class="col-sm-2 col-xs-2 rad-io">
														<span><input type="radio" name="code"
															id="radio_${buyer.code}" value="${buyer.code}"><label
															for="radio_${buyer.code}" class="pull-left m-0-13"></label></span>
													</p>
												</td>
												<td class="col-sm-2 col-xs-2">${buyer.code}</td>
												<td class="col-sm-3 col-xs-3">${buyer.customer_name}</td>
												<td class="col-sm-1 col-xs-1">${buyer.country}</td>
												<td class="col-sm-2 col-xs-2">${buyer.city}</td>
												<td class="col-sm-3 col-xs-3"><a onclick="getBuyerDetatils('${buyer.code}')">详情</a></td>
											</tr>
										</c:forEach>
									</tbody>
								</table>
							</div>
							<form id="CreditAmountForm" method="post">
								<input type="hidden" name="bid" value="${bid}">
							</form>
							<c:if test="${not empty blist }">
								<div class="next-step">
									<div class="col-sm-3 col-xs-3 pull-right mt-20">
										<a onclick="tijiao('1')" class="ns-btn">确认</a> <a
											href="<c:url value='/exports/credit/limitQuery/${buyerdto.vo.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="ns-btn">返回</a> <a
											href="<c:url value='/exports/credit/addApplyAmount?ACCESS_TOKEN=${ACCESS_TOKEN}'/>"
											class="ns-btn">新增买家</a>
									</div>
								</div>
							</c:if>
							<c:if test="${empty blist }">

								<div class="col-sm-12 col-xs-12">
									<p class="pull-right">在全球买家库中，没有搜索到您需要的信息。您可以选择重新搜索，也可以申请新增买家信息。</p>
								</div>
								<div class="next-step">
									<div class="col-sm-3 col-xs-3 pull-right mt-20">
										<a href="<c:url value='/exports/credit/addApplyAmount?ACCESS_TOKEN=${ACCESS_TOKEN}'/>"
											class="ns-btn">新增买家</a> <a href="resetSerach()"
											class="ns-btn">重新搜索</a>
									</div>
								</div>
							</c:if>
							<!-- 分页  start-->
										<div class="row next-step">
												<div class="col-sm-6 col-sm-6">
														<!-- 分页 start -->
													<nav class="text-center">
	
											            	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
											           
													</nav>
													
												</div>
												
											</div>
							<!-- 分页 end -->
						</div>
					</div>
					<!-- w-95-auto end -->
				</div>
				<!-- message-war end -->
			</div>
			<!-- container end -->
		</div>
		<!-- mar-content 右边内容块 end -->
	</div>
</body>

</html>

<script src="<c:url value='/resources/js/extendPagination.js'/>"
	type="text/javascript"></script>
<script type="text/javascript">
choiseMenu("shipping01");
	var baseUrl = '${pageContext.request.contextPath }';
	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#pageNum').val() || 5;
	var limit = Number($('#numPerPage').val()) || 10;
	$('#callBackPager').extendPagination({
		totalCount : totalCount,
		showCount : showCount,
		limit : limit,
		callback : function(curr, limit, totalCount) {
			getListForPage();
		}
	});
	function getListForPage() {
		var  formId="buyerForm";
		var  contentId="buyerArea";
		var index = layer.load(0, {
			shade : [ 0.3, '#808080' ]
		});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/exports/credit/findBuyersListForPage",
			data : $("#" + formId).serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#" + contentId).html(data);
			},
			error : function() {
				layer.close(index);
			}
		});
	}

	function doSearch(){
		getListForPage2("buyerForm","buyerArea");
		$('#callBackPager').extendPagination({
			totalCount: totalCount,
			showCount: showCount,
			limit: limit,
			callback: function (curr, limit, totalCount) {
				getListForPage2("buyerForm","buyerArea");
			}
		});
		function getListForPage2(formId,contentId){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/exports/credit/findBuyersListForPage",
				data : {pageNum:$('#pageNum').val(),
						numPerPage:$('#numPerPage').val(),
						totalCount:$('#totalCount').val(),
						code:$('#code').val()
						},
				dataType : "text",
				success : function(data) {
					layer.close(index);
					$("#"+contentId).html(data);			
				},
				error: function(){
					layer.close(index);
				}
			});
		}
	} 
	
	
	
	function resetSerach() {
		alert('重置所有的 搜搜条件')
	}
	function tijiao(type) {

		var code = $('input[name="code"]:checked').val();
		if (type == '1') {
			$("#CreditAmountForm").attr("action",
					baseUrl + "/exports/credit/getBuyers/" + code);
			$("#CreditAmountForm").submit();
		}
		if (type == '0') {
			alert('返回页面');
		}

	}
	function getBuyerDetatils(code) {
		layer.open({
			type : 2,
			title : false,
			area : [ '1200px', '600px' ],
			shade : 0.8,
			closeBtn : 0,
			shadeClose : true,
			content : baseUrl + "/exports/credit/getBuyersDetatils/" + code
		});
	}
	

</script>

