<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户（招标和律师）</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js'/>"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js'/>"></script>
	   	<![endif]-->
	   	<script type="text/javascript">
			var baseUrl = '${pageContext.request.contextPath }';
		</script>
		<style type="text/css">
		.layui-layer-btn{
			text-align: center;
			background-color: #eff3f6;
		}
		.layui-layer-btn a{
			border-radius: 5px;
			height: auto;
		}
		</style>
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<form id="companyForm"  method="post" enctype="multipart/form-data" action='<c:url value="/user/editCompanyInfo.json?ACCESS_TOKEN=${ACCESS_TOKEN}"/>'>
				<input name="oid" value="${userdetail.company.oid }" type="hidden"/>
				<div class="container corporate-infor"><!-- corporate-infor strar -->
					<div class="row">
						<div class="col-sm-12 col-xs-12 coin-left">
							<div class="conin-lsub">
								<div class="conin-lstop"> 
									<div class="user-img pa-t3" data-toggle="modal" data-target="#xiv"><c:if test="${empty userdetail.headerPath }"><img src="<c:url value='/resources/versions-2.0/images/account/user-img.png'/>"></c:if><c:if test="${not empty userdetail.headerPath }"><img src="${userdetail.headerPath }"></c:if></div> 
								</div> 
								<div class="user-reva">
<%-- 									<h4>${empty userdetail.name ? userdetail.userName:userdetail.name }</h4> --%>
										<h4>${userdetail.userName }</h4>
									<div class="ur-sub">
										<p>
											<i class="bg-0474c8">${userdetail.role.description }</i>
											<i class="bg-45b854" id="identStatus">${userdetail.company.identification.name }</i>
											<span>${userdetail.email }</span>
											<a style="margin-left: 8px;" href="javascript:void(0);" onclick="goChangeMail();">修改邮箱</a>
											<a style="margin-left: 8px;" href="javascript:void(0);" onclick="goChangePassword();">修改密码</a>
<%-- 											<span>${userdetail.email }</span> --%>
<!-- 											<a href="#revamp-regemail" data-toggle="modal">修改邮箱</a> -->
<!-- 											<a href="#revamp-regpsd" data-toggle="modal">修改密码</a> -->
										</p>
									</div>
								</div>
								<div class="fillin-war">
									<div class="row w-98-auto"><!-- w-98-auto start -->
										<div class="col-sm-3 col-xs-3">
											<p>*企业名称</p>
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请填写企业全称" id="fullName" name="fullName" value="${userdetail.company.fullName }"/>
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-3 col-xs-3">
											<p>*地区</p>
											<div class="row">
												<input type="hidden" name="provinceName" id="provinceName" value="${userdetail.company.provinceName }">
                   								<input type="hidden" name="cityName" id="cityName" value="${userdetail.company.cityName }">
												<div class="col-sm-6 col-xs-6">
													<select name="provinceCode" id="provinceID" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;" onchange="javascript:$('#provinceName').val($('#provinceID option:selected').text());changeDistrict('cityID', '', '2', this,'${ userdetail.company.cityCode}');">
														<option value="">请选择省</option>
						                                 <c:forEach items="${provinceList }" var="list">
						                                 <option value="${list.codes }" ${list.codes eq userdetail.company.provinceCode ?"selected='selected'":"" }>${list.named }</option>
						                                 </c:forEach>
													</select> 
												</div>
												<div class="col-sm-6 col-xs-6">
													<select name="cityCode" id="cityID" onchange="javascript:$('#cityName').val($('#cityID option:selected').text());" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
														<option value="">请选择市</option>
													</select> 
												</div> 
											</div>
										</div>
										<div class="col-sm-6 col-xs-6">
											<p>*详细地址</p>
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请输入详细地址" id="address" name="address" value="${userdetail.company.address }"/>
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="clear"></div>
										<div class="col-sm-3 col-xs-3">
											<p>*法人姓名</p> 
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请输入法人姓名" id="legalName" name="legalName" value="${userdetail.company.legalName }" >
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-3 col-xs-3">
											<p>*统一社会信用码/注册号/组织机构代码证号</p>
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请输入统一社会信用码/注册号/组织机构代码证号" id="idNumber" name="idNumber" value="${userdetail.company.idNumber }"/>
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div> 
										<div class="col-sm-3 col-xs-3">
											<p>*企业电话</p>
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请输入企业电话，如：区号-电话号码" id="bidPhone" name="bidPhone" value="${userdetail.company.bidPhone }" />
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="clear"></div>
										<div class="bb-mt-e7"></div>
										<div class="col-sm-3 col-xs-3">
											<p>*企业银行账户名</p> 
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请输入企业银行账户名" id="accountName" name="accountName" value="${userdetail.company.accountName }" >
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-3 col-xs-3">
											<p>*企业银行账户开户行</p>
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请输入企业银行账户开户行" id="bankName" name="bankName"  value="${userdetail.company.bankName }" />
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div> 
										<div class="col-sm-3 col-xs-3">
											<p>*企业银行账户账号</p>
											<input type="text" onblur="checkInput(this,'');" maxlength="30" class="form-control" placeholder="请输入企业银行账户账号" id="bankCard" name="bankCard"  value="${userdetail.company.bankCard }" />
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="clear"></div>
										<p>&nbsp;&nbsp;&nbsp;&nbsp;为了验证所填企业信息的有效性，请用上方所填企业银行账户汇款1元至 <strong><span style="color:red; font-size:14px">开户银行名称：中国工商银行厦门美仁宫支行&nbsp;&nbsp;&nbsp;&nbsp;银行账号：4100 0213 0920 0096 076</span></strong></p>
										<div class="bb-mt-e7"></div>
										<div class="col-sm-3 col-xs-3">
											<p>*联系人姓名</p> 
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请输入联系人姓名" id="linkman" name="linkman" value="${userdetail.company.linkman }" >
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-3 col-xs-3">
											<p>*联系人电话</p>
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请输入联系人电话" id="linkphone" name="linkphone" value="${userdetail.company.linkphone }" />
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div> 
										<div class="col-sm-3 col-xs-3">
											<p>*联系人邮箱</p>
											<input type="text" onblur="checkInput(this,'');" class="form-control" placeholder="请输入联系人邮箱" id="linkEmail" name="linkEmail" value="${userdetail.company.linkEmail }"  />
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="clear"></div>
										<div class="bb-mt-e7"></div> 
										<div class="col-sm-4 col-xs-4" id="businessPath_isHidden">
											<input value="${userdetail.company.organizingPath }" id="businessPath" type="hidden" >
											<p>*营业执照<a href="#open" data-toggle="modal"  data-dismiss="modal">（样例）</a></p> 
											<div data-toggle="popover" data-trigger="hover" title="上传说明" data-content="如果贵公司已办理三证合一，仅需上传营业执照，组织机构代码和税务登记证无需上传。">
												<input data-drawview="${userdetail.company.businessPath }" name="businessPath_file" id="businessPath_file-5" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
											</div>
											<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
										</div>
										<div class="col-sm-4 col-xs-4" id="organizingPath_isHidden">
											<p>组织机构代码证<a href="#org" data-toggle="modal"  data-dismiss="modal">（样例）</a></p> 
											<div>
												<input data-drawview="${userdetail.company.organizingPath }" name="organizingPath_file" id="organizingPath_file-5" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
											</div>
											<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
										</div>
										<div class="col-sm-4 col-xs-4" id="taxPath_isHidden">
											<p>税务登记证<a href="#tax" data-toggle="modal"  data-dismiss="modal">（样例）</a></p> 
											<div>
												<input data-drawview="${userdetail.company.taxPath }" name="taxPath_file" id="taxPath_file-5" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
											</div>
											<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
										</div>
									</div><!-- w-98-auto end -->
								</div>
							</div>
						</div>
					</div> 
				</div><!-- corporate-infor end --> 
				<div class="clear"></div>
				<div class="btn-bottom pull-right"> 
					<p><a href="javascript:void(0);" class="undo pull-left">取消</a><a onclick="submitCompanyForm();" href="javascript:void(0);" class="conserve pull-left">保存</a></p>
				</div>
				</form>
			</div><!-- mar-content 右边内容块 end -->
		</div>
		
		<!-- 营业执照 start -->
		<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">营业执照</h4>
				  </div> 
				  <div class="modal-body">
				  	<img src="<c:url value='/resources/versions-2.0/images/product/open.jpg'/>" class="img-responsive ml-14">
				  </div> 
				</div> 
		  </div> 
		</div> 
		<!-- 营业执照 end -->
		<!-- 组织机构代码证 start -->
		<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">组织机构代码证</h4>
				  </div> 
				  <div class="modal-body">
				  	<img src="<c:url value='/resources/versions-2.0/images/product/org.jpg'/>" class="img-responsive">
				  </div> 
				</div> 
		  </div> 
		</div> 
		<!-- 组织机构代码证 end --> 
		<!-- 税务登记证 start -->
		<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">税务登记证</h4>
				  </div> 
				  <div class="modal-body">
				  	<img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg'/>" class="img-responsive">
				  </div> 
				</div> 
		  </div> 
		</div> 
		<!-- 税务登记证 end --> 
		
		<!-- 修改登录邮箱 start -->
		<div class="modal fade" id="revamp-regemail" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">修改登录邮箱</h4>
				  </div>
				  <form id="emailForm1">
					  <div class="modal-body">
					  	<p>
					  		<label>邮箱地址</label>
					  		<input type="text" id="oldEmail" class="form-control bg-f2f4f8" value="${userdetail.email }" readonly="readonly"/>
					  	</p>
					  	<div  class="mt-20">
					  		<label>验证码</label>
					  		<div class="row">
					  			<div class="col-sm-9 col-xs-9">
					  			<input type="text" class="form-control" placeholder="请输入验证码" id="codeEmail1"/>
					  			<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  			</div>
					  			<div class="col-sm-3 col-xs-3 pl-0">
					  				<label class="valibox"><img id="imageEmail1" src="<c:url value='/user/image.htm'/>" onclick="changeImg(this)" width="100%"/></label>
					  			</div>
					  		</div>
					  	</div>
					  	<div class="mt-20">
					  		<label>邮件验证码</label>
					  		<div class="row">
					  			<div class="col-sm-7 col-xs-7">
					  			<input type="text" id="emailCode1" class="form-control" placeholder="请输入验证码" />
					  			<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  			</div>
					  			<div class="col-sm-5 col-xs-5 pl-0"> 
									<input type="button" class="v-code" value="获取验证码" onclick="getCheckCodeByEmail('oldEmail',this);"/>
					  			</div>
					  		</div>
					  	</div> 
					  </div>
					  <!-- 点击下一点弹出新邮箱输入框 -->
					  <div class="modal-footer">
						<div class="mofo-sub">
							<a href="javascript:void(0);" class="nstep-btn" onclick="nextStep();">下一步</a>
						</div>
					  </div> 
				  </form> 
				  <!-- 点击下一步出显的内容块 默认隐藏 -->
				  <form class="d-none" id="emailForm2">
					  <div class="modal-body">
					  	<div class="mt-20">
					  		<label>新邮箱地址</label>
					  		<input type="text" class="form-control" onblur="checkExistEmail(this)" placeholder="请输入新邮箱地址" name="email" id="newEmail"/>
					  		<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  	</div>
					  	<div class="mt-20">
					  		<label>验证码</label>
					  		<div class="row">
					  			<div class="col-sm-9 col-xs-9">
					  			<input type="text" class="form-control" placeholder="请输入验证码" id="codeEmail2" />
					  			<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  			</div>
					  			<div class="col-sm-3 col-xs-3 pl-0">
					  				<label class="valibox"><img id="imageEmail2" src="<c:url value='/user/image.htm'/>" onclick="changeImg(this)" width="100%"/></label>
					  			</div>
					  		</div>
					  	</div>
					  	<div  class="mt-20">
					  		<label>邮件验证码</label>
					  		<div class="row">
					  			<div class="col-sm-7 col-xs-7">
					  			<input type="text" id="emailCode2" class="form-control" placeholder="请输入验证码" />
					  			<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  			</div>
					  			<div class="col-sm-5 col-xs-5 pl-0"> 
									<input type="button" class="v-code" value="获取验证码" onclick="getCheckCodeByEmail('newEmail',this);"/>
					  			</div>
					  		</div>
					  	</div> 
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<a href="javascript:void(0);" class="nstep-btn" onclick="submitForm('email');">确认</a>
						</div>
					  </div> 
				  </form> 
				</div>
		  </div> 
		</div> 
		<!-- 修改登录邮箱 end -->
		<!-- 修改登录密码 start -->
		<div class="modal fade" id="revamp-regpsd" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">修改登录密码</h4>
				  </div>
				  <form id="passwordForm">
				  	<input type="hidden" value="${userdetail.oid }" name="oid">
					  <div class="modal-body">
					  	<p>
					  		<label>当前登录密码</label>
					  		<input type="password" class="form-control" onblur="validatePwdForms(this)" placeholder="请输入登录密码" id="oldPassword" name="oldPassword"/>
					  		<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					  	</p>
					  	<p>
					  		<label>新登录密码</label>
					  		<input type="password" class="form-control" onblur="validatePwdForms(this)" placeholder="请输入新的登录密码（6-20位）" id="password" name="password"/>
					  		<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					  	</p>
					  	<p>
					  		<label>确认新登录密码</label>
					  		<input type="password" class="form-control" onblur="validatePwdForms(this)" placeholder="请再次输入新的登录密码（6-20位）" id="rePwd" name="rePwd" />
					  		<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					  	</p>
					  	<div class="mt-20">
					  		<label>验证码</label>
					  		<div class="row">
					  			<div class="col-sm-9 col-xs-9">
					  				<input type="text" id="codePwd" class="form-control" placeholder="请输入验证码" />
					  				<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
					  			</div>
					  			<div class="col-sm-3 col-xs-3 pl-0">
					                <label class="valibox"><img id="imagePwd" src="<c:url value='/user/image.htm'/>" onclick="changeImg(this)" width="100%"/></label>
					  			</div>
					  		</div>
					  		<div class="clear"></div>
					  	</div> 
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
							<button type="button" class="btn notarize-btn pull-right" onclick="submitForm('password');">确认</button>
<!-- 							<a href="javascript:void(0);" class="notarize-btn" onclick="submitForm('password');">确认</a> -->
						</div>
					  </div> 
				  </form> 
				</div>
		  </div> 
		</div> 
		<!-- 修改登录密码 end -->
		<!-- 修改头像 start -->
		<div class="modal fade" id="xiv" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header bg-1f96ef">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">修改头像</h4>
				  </div>
				  <form>
					  <div class="modal-body"> 
					  	<div class="xiv-container">
						  <div class="imageBox">
						    <div class="thumbBox"></div>
						    <div class="spinner">选择图片</div>
						  </div>
						  <div class="action"> 
						    <div class="new-contentarea text-center"> <a href="javascript:void(0)" class="upload-img">
						      <label for="upload-file">上传图像</label>
						      </a>
						      <input type="file" class="" name="upload-file" id="upload-file" />
						    </div>
						    <input type="button" id="btnCrop"  class="Btnsty_peyton" value="预览">
						    <input type="button" id="btnZoomIn" class="Btnsty_peyton" value="+"  >
						    <input type="button" id="btnZoomOut" class="Btnsty_peyton" value="-" >
						  </div>
						  <div class="cropped"></div>
						  <input type="hidden" name="headerPath" id="headerPath64">
						</div> 
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
							<button type="button" class="btn notarize-btn pull-right" onclick="headerUpload('headerPath64')">确认</button>
						</div>
					  </div> 
				  </form> 
				</div> 
		  </div> 
		</div> 
		<!-- 修改头像 end --> 
	</body>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/v-code.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/cropbox.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/xiv.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/js/myAccount.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
	
	<script type="text/javascript">
		choiseMenu("myAccount");
		
		$(function(){
			$("#provinceID").trigger("change");
			$("#cityID").trigger("change");
			checkAuthority();
		});
		
		function headerUpload(bs64){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/user/headerUpload",
				data :{
					"headerPath":$("#"+bs64).val()
				},
				dataType : "json",
				success : function(json) {
					layer.close(index);
					if(json.statusCode == "200") {
						layer.msg(json.resultDto.message);
						window.location.reload();//刷新当前页面.
					}else{
						layer.msg(json.resultDto.message);
					}
					
				},
				error: function(){
					layer.close(index);
				}
			});
		}
		function checkAuthority(){
			var identification = '${userdetail.company.identification}';
			var authentication = '${userdetail.company.authentication}';
			if( authentication == "false" && identification=="UNSTART"){
				layer.alert('您的资料未认证，请填写资料后提交审核', {
				    skin: 'agreementTip'
				    ,closeBtn: 0
				    ,shift: 4 //动画类型
				  });
			}else if(authentication == "false" && identification=="PROCESS"){
				layer.alert('您的资料审核中，请耐心等待审核结果', {
				    skin: 'agreementTip'
				    ,closeBtn: 0
				    ,shift: 1 //动画类型
				  });
			}else if(authentication == "false" && identification=="FAIL"){
				layer.alert('您的资料认证失败，请修改资料后重新提交审核', {
				    skin: 'agreementTip'
				    ,closeBtn: 0
				    ,shift: 1 //动画类型
				  });
			}
			else if(authentication == "false" && identification =="SUCCESS")
			layer.open({
				  type: 2,
				  title:'平台合作服务协议',
				  scrollbar: false,
				  area : [ '70%', '90%' ],
				  shade : 0.8,
				  skin: 'agreementModal',
				  btn: ['同意','不同意'],
				  content: baseUrl +'/user/userAgreement'+'?ACCESS_TOKEN=${ACCESS_TOKEN}', //iframe的url
				  yes:function(indexIframe, layero){
					  agree();
				  }
			});
		}
		
		function agree(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/user/agreeAgreement.json",
				dataType : "json",
				async :false,
				success : function(data) {
					layer.close(index);
	 				layer.msg(data.message);
					if(data.status=="200"){
						setTimeout("reload()",2000);
					}
				},
				error : function() {
					layer.close(index);
					alert('error');
				}
			});
		}
		
		function checkExistEmail(obj){
			if(obj.value == "") {
				loser_has(obj);
				$(obj).focus();
				return false;
			}if(checkEmail(obj.value) == false && obj.value != ""){
				loser_has(obj);
				$(obj).focus();
				layer.msg("请输入正确的邮箱");
				return false;
		    } else{
				if(obj.value != $(obj).attr("defaultValue")) {
		    		$.ajax({
		    			type: 'POST',
		    			url: baseUrl + "/user/register/checkEmail",
		    			data:{'email': obj.value},
		    			dataType:"json",
		    			async: false,
		    			success: function(json){
		    				if(json.statusCode == '1') {
		    					loser_has(obj);
		    					$(obj).focus();
		    					layer.msg("此邮箱已经注册过了！");
		    					return false;
		    				}else{
		    					success_has(obj);
		    				}
		    			}
		    		}); 
		    	}else{
					success_has(obj);
				}
			}
		}
		
		function reload(){
			layer.closeAll();
			window.location.reload();//刷新当前页面.
		}
		function goChangeMail() {
			changeImg("#imageEmail1");
			$("#emailForm1").show();
			$("#emailForm2").hide();
			$("#codeEmail1").val('');
			$("#emailCode1").val('');
			resetTime();
			$("#revamp-regemail").modal();
		}
		function goChangePassword() {
			changeImg("#imagePwd");
			$("#revamp-regpsd").modal();
		}
		

	</script>

</html>

