<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="pcHeader.jsp"/>
			<div class="mar-content mt-80"><!-- mar-content 右边内容块 start -->
				<!-- 产品管理 start -->
				<div class="container-fluid">
					<div class="tender-war">
						<div class="query-criteria">
<!-- 							<h4 class="fs16">产品管理</h4> -->
							<div class="qucr-sub clearfix">
								<div class="w-98-auto">
									<div class="col-sm-3 col-xs-3">
										<p>选择产品类</p>
										<select class="form-control" id="grounSelect" onchange="clearContent();getLoadProduct(this,'productSelect')" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
											<option>请选择选择产品类</option>
											<c:forEach items="${groupTypeList }" var="list">
											<option value="${list }">${list.disc }</option>
			                                </c:forEach>
										</select> 
									</div>
									<div class="col-sm-3 col-xs-3">
										<p>选择产品</p>
										<select class="form-control" id="productSelect" onchange="clearContentByProduct();getLoadPage(this,'page_modal');setProductOid(this);" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
											<option>请选择产品</option>
										</select> 
									</div> 
								</div>
							</div> 
						</div>
					</div> 
					<div class="tender-war" id="page_modal"> 
						
					</div> 
					<div class="tender-war" id="modularity_modal"> 
						
					</div> 
					<div class="tender-war" id="specProperty_modal"> 
						
					</div>
				</div>
				<!-- 产品管理 end -->
			
				
			</div><!-- mar-content 右边内容块 end -->
		</div>
			<!-- 分页修改 start -->
			<div class="modal fade" id="page-add" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
			   <div class="modal-dialog" role="document">
					<div class="modal-content">
					  <div class="modal-header bg-1f96ef">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title">分页修改</h4>
					  </div> 
					  <form id="save_pageSetup_form">
					  <input type="hidden" name="productOid" value="" />
					  <div class="modal-body">
					  	<p>
					  		<label>界面分配页</label>
					  		<input type="text" name="pageView" class="form-control" placeholder="" />
					  	</p>
					  	<p>
					  		<label>页名</label>
					  		<input type="text" name="pageName" class="form-control" placeholder="" />
					  	</p>
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
							<button type="button" class="btn notarize-btn pull-right" onclick="save_pageSetup_form()" data-dismiss="modal">确认</button>
						</div>
					  </div> 
				  </form> 
					</div> 
			  </div> 
			</div> 
			<!-- 分页修改 end -->
			<!-- 分页修改 start -->
			<div class="modal fade" id="page-amend" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
			   <div class="modal-dialog" role="document">
					<div class="modal-content">
					  <div class="modal-header bg-1f96ef">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title">分页修改</h4>
					  </div> 
					  
					</div> 
			  </div> 
			</div> 
			<!-- 分页修改 end -->
			<!-- 模块项修改 start -->
			<div class="modal fade" id="module-add" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
			   <div class="modal-dialog" role="document">
					<div class="modal-content">
					  <div class="modal-header bg-1f96ef">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title">模块项修改</h4>
					  </div> 
					  <form id="save_modularity_form">
					  <input type="hidden" name="productOid" value="" />
					  <div class="modal-body">
					  	<p>
					  		<label>所属页</label>
					  		<input type="text" name="pageView" class="form-control" placeholder="" />
					  	</p>
					  	<p>
					  		<label>模块名称</label>
					  		<input type="text" name="name" class="form-control" placeholder="" />
					  	</p>
					  	<p class="clearfix">
					  		<label>模块类型</label>
					  		<select class="form-control" name="specModule" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
								<c:forEach items="${specModuleList }" var="list">
								<option value="${list }">${list.name }</option>
				                </c:forEach>
							</select>
					  	</p>
					  	<p>
					  		<label>排序</label>
					  		<input type="text" name="process" class="form-control" placeholder="" />
					  	</p>
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
							<button type="button" class="btn notarize-btn pull-right" onclick="save_modularity_form()" data-dismiss="modal">确认</button>
						</div>
					  </div> 
				  </form> 
					</div> 
			  </div> 
			</div> 
			<!-- 模块添加 end -->
			<!-- 模块项修改 start -->
			<div class="modal fade" id="module-amend" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
			   <div class="modal-dialog" role="document">
					<div class="modal-content">
					  <div class="modal-header bg-1f96ef">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title">模块项修改</h4>
					  </div>
					   
					</div> 
			  </div> 
			</div> 
			<!-- 模块添加 end -->
			<!-- 产品属性修改 start -->
			<div class="modal fade product-prop" id="property-add" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
			   <div class="modal-dialog" role="document">
					<div class="modal-content">
					  <div class="modal-header bg-1f96ef">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title">产品属性修改</h4>
					  </div> 
					  <form id="save_specProperty_form">
					  <input type="hidden" name="productOid" value="" />
					  <input type="hidden" name="modularityOid" id="modularityOid-save" value="" />
					  <div class="modal-body">
					  	<div class="row">
					  		<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>编码</label>
							  		<input type="text" name="external" class="form-control" placeholder="" />
							  	</p>
					  		</div>
					  		<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>名称</label>
							  		<input type="text" name="name" class="form-control" placeholder="" />
							  	</p>
					  		</div> 
					  		<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>特殊包含字段</label>
							  		<input type="text" name="inducles" class="form-control" placeholder="" />
							  	</p>
					  		</div>
					  		<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>输入格式提示</label>
							  		<input type="text" name="placeholderValue" class="form-control" placeholder="" />
							  	</p>
					  		</div>
					  		<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>录入的有效值</label>
							  		<input type="text" name="allowedValues" class="form-control" placeholder="" />
							  	</p>
					  		</div>
					  		<div class="col-sm-6 col-xs-6">
					  		<p>
						  		<label>js方法</label>
						  		<input type="text" name="jsMethod" class="form-control" placeholder="" />
						  	</p>
					  	</div>
					  	<div class="col-sm-6 col-xs-6">
					  		<p>
						  		<label>提示信息</label>
						  		<input type="text" name="hintMsg" class="form-control" placeholder="" />
						  	</p> 
					  	</div>
					  	<div class="col-sm-6 col-xs-6">
					  		<p class="clearfix">
						  		<label>数据类型</label>
						  		<select class="form-control" name="dataType" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
									<c:forEach items="${dataTypeList }" var="list">
									<option value="${list }">${list.name }</option>
					                </c:forEach>
									
								</select>
						  	</p>
					  	</div>
					  	<div class="col-sm-6 col-xs-6">
					  		<p class="clearfix">
						  		<label>控件类型</label>
						  		<select class="form-control" name="fieldType" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
									<c:forEach items="${fieldTypeList }" var="list">
									<option value="${list }">${list.name }</option>
					                </c:forEach>
								</select>
						  	</p>
					  	</div>
					  	<div class="col-sm-6 col-xs-6">
					  		<p class="clearfix">
						  		<label>控件规则</label>
						  		<select class="form-control" name="controlRule" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
									<c:forEach items="${controlRuleList }" var="list">
									<option value="${list }">${list.name }</option>
					                </c:forEach>
								</select>
						  	</p>
					  	</div>
					  	<div class="col-sm-6 col-xs-6">
					  		<p class="clearfix">
						  		<label>页面展示模块</label>
						  		<select class="form-control" name="showSpecModule" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
									<c:forEach items="${specModuleList }" var="list">
									<option value="${list }">${list.name }</option>
					                </c:forEach>
								</select>
						  	</p>
					  	</div>
					  	<div class="col-sm-6 col-xs-6">
					  		<p class="clearfix">
						  		<label>后台匹配模块</label>
						  		<select class="form-control" name="logicSpecModule" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
									<c:forEach items="${specModuleList }" var="list">
									<option value="${list }">${list.name }</option>
					                </c:forEach>
								</select>
						  	</p>
					  	</div> 
					  	<div class="col-sm-6 col-xs-6">
					  		<p>
						  		<label>排序</label>
						  		<input type="text" name="seq" class="form-control" placeholder="" />
						  	</p>
					  	</div> 
					  	<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>是否存在字段</label> 
							  		<div class="rad-io pull-left">
							  			<input type="radio" name="beanProperty" value="0" id="beanProperty_1" checked="checked"/>
							  			<label for="beanProperty_1"></label>
							  			<span>是</span>
							  		</div>
							  		<div class="rad-io pull-left ml-14">
							  			<input type="radio" name="beanProperty" value="1" id="beanProperty_2"/>
							  			<label for="beanProperty_2"></label>
							  			<span>否</span>
							  		</div>
							  	</p>
					  		</div>
					  		<div class="clear"></div>
					  		<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>是否必录</label> 
							  		<div class="rad-io pull-left">
							  			<input type="radio" name="isRequired" value="1" id="isRequired_1" checked="checked"/>
							  			<label for="isRequired_1"></label>
							  			<span>是</span>
							  		</div>
							  		<div class="rad-io pull-left ml-14">
							  			<input type="radio" name="isRequired" value="0" id="isRequired_2"/>
							  			<label for="isRequired_2"></label>
							  			<span>否</span>
							  		</div>
							  	</p>
					  		</div>
					  		<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>是否展示</label> 
							  		<div class="rad-io pull-left">
							  			<input type="radio" name="isHidden" value="0" id="isHidden_1" checked="checked"/>
							  			<label for="isHidden_1"></label>
							  			<span>是</span>
							  		</div>
							  		<div class="rad-io pull-left ml-14">
							  			<input type="radio" name="isHidden" value="1" id="isHidden_2"/>
							  			<label for="isHidden_2"></label>
							  			<span>否</span>
							  		</div>
							  	</p>
					  		</div>
					  		<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>是否提示</label> 
							  		<div class="rad-io pull-left">
							  			<input type="radio" name="isHint" value="1" id="isHint_1" checked="checked"/>
							  			<label for="isHint_1"></label>
							  			<span>是</span>
							  		</div>
							  		<div class="rad-io pull-left ml-14">
							  			<input type="radio" name="isHint" value="0" id="isHint_2"/>
							  			<label for="isHint_2"></label>
							  			<span>否</span>
							  		</div>
							  	</p>
					  		</div> 
					  		<div class="col-sm-6 col-xs-6">
					  			<p>
							  		<label>是否特殊行</label> 
							  		<div class="rad-io pull-left">
							  			<input type="radio" name="isSpecial" value="1" id="isSpecial_1" checked="checked"/>
							  			<label for="isSpecial_1"></label>
							  			<span>是</span>
							  		</div>
							  		<div class="rad-io pull-left ml-14">
							  			<input type="radio" name="isSpecial" value="0" id="isSpecial_2"/>
							  			<label for="isSpecial_2"></label>
							  			<span>否</span>
							  		</div>
							  	</p>
					  		</div>
					  	</div> 
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub">
							<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
							<button type="button" class="btn notarize-btn pull-right" onclick="save_specProperty_form()" data-dismiss="modal">确认</button>
						</div>
					  </div> 
				  </form> 
					</div> 
			  </div> 
			</div> 
			<!-- 产品属性修改 end -->
			<!-- 产品属性修改 start -->
			<div class="modal fade product-prop" id="property-amend" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
			   <div class="modal-dialog" role="document">
					<div class="modal-content">
					  <div class="modal-header bg-1f96ef">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title">产品属性修改</h4>
					  </div> 
					   
					</div> 
			  </div> 
			</div> 
			<!-- 产品属性修改 end -->
	</body>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js'/>"></script>
	<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
	<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
	<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	choiseMenu("insureConfig");
	
		function getLoadProduct(o,_id){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/loadProduct.json",
				data : {
					status:o.value
				},
				dataType : "json",
				cache : false,
				success : function(data) {
					layer.close(index);
					var appendStr = "<option value=''>请选择产品</option>";
					var vls = data + "";
					$.each(data, function(index, json) {
						var vl = json + "";
						vl = vl.trim();
						
						for(var i=0;i<vl.split(",").length;i++){
							var vn_ = vl.split(",")[i];
							appendStr = appendStr + "<option value='" + vn_.split("#")[0] + "' ";
							appendStr = appendStr + ">" + vn_.split("#")[1] + "</option>";
						}
						$("#" + _id).append(appendStr);
					})
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		
		
		function getLoadPage(o,_id){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/loadPageSetup",
				data : {"productOid":o.value},
				dataType : "html",
				cache : false,
				success : function(data) {
					layer.close(index);
					$("#"+_id).html(data);
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		
		function getLoadModularity(o,_id){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/loadModularity",
				data : {"pageOid":$(o).attr("data-vals")},
				dataType : "html",
				cache : false,
				success : function(data) {
					layer.close(index);
					$("#"+_id).html(data);
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		
		function getLoadSpecProperty(o,_id){
			$("#modularityOid-save").val($(o).attr("data-vals"));
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/loadSpecProperty",
				data : {"modularityOid":$(o).attr("data-vals")},
				dataType : "html",
				cache : false,
				success : function(data) {
					layer.close(index);
					$("#"+_id).html(data);
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		
		function selectRadio(obj){
			$(obj)
				.find(':radio').attr('checked',true);
			var url = "";
			var signs = $(obj).attr("typs");
			if(signs == "pag"){
				url = baseUrl + "/maintain/update_pageSetup/"+$(obj).attr("rel");
			}else if(signs == "spe"){
				url = baseUrl + "/maintain/update_specProperty/"+$(obj).attr("rel");
			}else if(signs == "mod"){
				url = baseUrl + "/maintain/update_modularity/"+$(obj).attr("rel");
			}
			$.ajax({
				type : 'POST',
				url : url,
				dataType : "html",
				cache : false,
				success : function(data) {
					
					if(signs == "pag"){
						$("#page-amend form").remove();
						$("#page-amend").children().children().children().after(data);
					}else if(signs == "spe"){
						$("#property-amend form").remove();
						$("#property-amend").children().children().children().after(data);
					}else if(signs == "mod"){
						$("#module-amend form").remove();
						$("#module-amend").children().children().children().after(data);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.msg(textStatus);
				}
			});
		}
		function update_pageSetup_form(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/saveOrUpdatePageSetup",
				data : $("#update_pageSetup_form").serialize(),
				dataType : "json",
				cache : false,
				success : function(data) {
					layer.close(index);
					if(data.statusCode == "200") {
						layer.msg(data.resultDto.message);
					}
					if(data.statusCode == "300") {
						layer.msg(data.resultDto.message);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		function save_pageSetup_form(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/saveOrUpdatePageSetup",
				data : $("#save_pageSetup_form").serialize(),
				dataType : "json",
				cache : false,
				success : function(data) {
					layer.close(index);
					if(data.statusCode == "200") {
						layer.msg(data.resultDto.message);
					}
					if(data.statusCode == "300") {
						layer.msg(data.resultDto.message);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		function update_modularity_form(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/saveOrUpdateModularity",
				data : $("#update_modularity_form").serialize(),
				dataType : "json",
				cache : false,
				success : function(data) {
					layer.close(index);
					if(data.statusCode == "200") {
						layer.msg(data.resultDto.message);
					}
					if(data.statusCode == "300") {
						layer.msg(data.resultDto.message);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		function save_modularity_form(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/saveOrUpdateModularity",
				data : $("#save_modularity_form").serialize(),
				dataType : "json",
				cache : false,
				success : function(data) {
					layer.close(index);
					if(data.statusCode == "200") {
						layer.msg(data.resultDto.message);
					}
					if(data.statusCode == "300") {
						layer.msg(data.resultDto.message);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		function update_specProperty_form(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/saveOrUpdateSpecProperty",
				data : $("#update_specProperty_form").serialize(),
				dataType : "json",
				cache : false,
				success : function(data) {
					layer.close(index);
					if(data.statusCode == "200") {
						layer.msg(data.resultDto.message);
					}
					if(data.statusCode == "300") {
						layer.msg(data.resultDto.message);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		function save_specProperty_form(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/maintain/saveOrUpdateSpecProperty",
				data : $("#save_specProperty_form").serialize(),
				dataType : "json",
				cache : false,
				success : function(data) {
					layer.close(index);
					if(data.statusCode == "200") {
						layer.msg(data.resultDto.message);
					}
					if(data.statusCode == "300") {
						layer.msg(data.resultDto.message);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		function setProductOid(o){
			$("input[name='productOid']").each(function(){
				$(this).val(o.value);
			});
		}
		function clearContent(){
			
			$("#productSelect").find("option").remove();
			$("#page_modal").html('');
			$("#modularity_modal").html('');
			$("#specProperty_modal").html('');
		}
		function clearContentByProduct(o){
			if($(o).val() == ''){
				$("#page_modal").html('');
				$("#modularity_modal").html('');
				$("#specProperty_modal").html('');
			}
		}
		
		function deleteRow(oid,delMethod){
			layer.confirm('确定删除该行数据？', {
			  skin: 'confirmTip',
			  btn: ['确定','取消'] //按钮
			}, function(){
				var index = layer.load(0, {shade: [0.3,'#808080']});
				var _url = baseUrl + "/maintain/"+delMethod;
				$.ajax({
					type : 'POST',
					url : _url,
					data : {
						'oid':oid
					},
					dataType : "json",
					cache : false,
					success : function(data) {
						layer.close(index);
						layer.msg(data.resultDto.message);
					},
					error : function(XMLHttpRequest, textStatus, errorThrown) {
						layer.close(index);
						layer.msg(textStatus);
					}
				});
			});
		}
	</script>
</html>

