<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
	<!--[if lt IE 9]>
	<script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	<script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	<![endif]-->
</head>
<body>
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container"><!-- container start -->
	<ol class="breadcrumb" id="bread_crumbs">
	</ol>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<div class="message-war"><!-- message-war start -->
		<h2>${ dto.product_name}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5>订单号码：${ dto.trade_serial_number}</h5>
			<div class="mess-title"><h3>推荐人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
						<td class="col-sm-4 col-xs-4">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
						<td class="col-sm-4 col-xs-4"></td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保单位信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保单位</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].name_cn}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">所属行业</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].industry}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
						<td class="col-sm-4 col-xs-4">
							<c:forEach items="${natureList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[0].com_nature}">
									${list.name}
								</c:if>
							</c:forEach>
							<c:forEach items="${natureList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[0].nature_two}">
									${list.name}
								</c:if>
							</c:forEach>
						</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
						<td class="col-sm-4 col-xs-4">
							<c:forEach items="${typeList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
									${list.name}
								</c:if>
							</c:forEach>
						</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].organization_code}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">企业总人数</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].total_emp}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件有效期类型</td>
						<td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[0].id_option,"idOption","")}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">有效期起止</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].id_star_date} ~ ${vo.roleSubjectList[0].id_end_date}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
						<td class="col-sm-4 col-xs-4">
							${reg_role}
							${vo.roleSubjectList[0].reg_address}
						</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">办公地址</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].do_business_address}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">办公电话</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].phone}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_name}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_tel}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_email}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系部门</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_section}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮政编码</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].zip_code}</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>被保险人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">序号</td>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">被保险人姓名</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人证件类型</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人证件号码</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人出生日期</td>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">被保险人性别</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人职业</td>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">被保险人手机</td>
					</tr>
					<c:if test="${vo.roleSubjectList!=null}">
						<c:forEach begin="2" end="${ vo.roleSubjectList.size() }" varStatus="index">
							<c:set var="doIndex" value="${index.index-1}"/>
							<tr>
								<td class="col-sm-1 col-xs-1">${doIndex}</td>
								<td class="col-sm-1 col-xs-1">${ vo.roleSubjectList[doIndex].name_cn}</td>
								<td class="col-sm-2 col-xs-2">
									<c:forEach items="${typeList }" var="list">
										<c:if test="${list.value eq vo.roleSubjectList[doIndex].id_type}">
											${list.name}
										</c:if>
									</c:forEach>
								</td>
								<td class="col-sm-2 col-xs-2">${ vo.roleSubjectList[doIndex].organization_code}</td>
								<td class="col-sm-2 col-xs-2">${ vo.roleSubjectList[doIndex].birth_date}</td>
								<td class="col-sm-1 col-xs-1">${empty vo.roleSubjectList[doIndex].sex ? '':vo.roleSubjectList[doIndex].sex eq '1'?'男':'女'}</td>
								<td class="col-sm-2 col-xs-2">
										${ vo.roleSubjectList[doIndex].major_group eq '1' ? '内勤人员' : vo.roleSubjectList[doIndex].major_group eq '2' ? '保安人员' : '武装押运人员'}
								</td>
								<%--<td class="col-sm-2 col-xs-2">${ vo.roleSubjectList[doIndex].major_group}</td>--%>
								<td class="col-sm-1 col-xs-1">${ vo.roleSubjectList[doIndex].mobile}</td>
							</tr>
						</c:forEach>
					</c:if>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>身故受益人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">受益人</td>
						<td colspan="3" class="col-sm-10 col-xs-10">法定继承人</td>
					</tr>
					</tbody>
				</table>
			</div>
			<c:if test="${fn:contains(dto.product_code, 'TYX-QH-DQ')||fn:contains(dto.product_code, 'TYX-HT-DQ')}">
				<div class="mess-title"><h3>投保基本信息</h3></div>
				<div class="affirm-warr">
					<table class="table ">
						<tbody>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动名称</td>
							<td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.name}</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动时间</td>
							<td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.star_time} ~ ${vo.specialExhibitionVo.end_time}</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动举办地址</td>
							<td class="col-sm-10 col-xs-10" colspan="3">${ex_pca}${vo.specialExhibitionVo.ex_address}</td>
						</tr>
						</tbody>
					</table>
				</div>
			</c:if>
			<div class="mess-title"><h3>投保计划信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<c:if test="${!fn:contains(dto.product_code, 'TYX-QH-DQ')&&!fn:contains(dto.product_code, 'TYX-HT-DQ')}">
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">起保日期</td>
							<td class="col-sm-4 col-xs-4">${ vo.inception_date }</td>
						</c:if>
						<c:if test="${fn:contains(dto.product_code, 'TYX-QH-DQ')||fn:contains(dto.product_code, 'TYX-HT-DQ')}">
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">保障日期</td>
							<td class="col-sm-4 col-xs-4">自${ vo.inception_date }零时起 至${vo.planned_end_date}二十四时止</td>
						</c:if>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">保费</td>
						<td class="col-sm-4 col-xs-4">${dto.gross_premium}</td>
					</tr>
					<c:if test="${fn:contains(dto.product_code, 'TYX-PAS')}">
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">客户识别授权书</td>
							<td class="col-sm-4 col-xs-4"><a href="${ vo.accredit_path }" target="_blank">查看</a></td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
							<td class="col-sm-4 col-xs-4"></td>
						</tr>
					</c:if>
					<%--<c:choose>
						<c:when test="${'TYX-RB-3' eq dto.product_code||'TYX-RB-4' eq dto.product_code||'TYX-RB-5' eq dto.product_code||'TYX-RB-6' eq dto.product_code}">
							<tr>
								<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案确认</td>
								<td colspan="3" class="col-sm-10 col-xs-10">
									<table class="table ">
										<tbody>
										<tr>
											<td class="col-sm-4 col-xs-4"></td>
											<td class="col-sm-4 col-xs-4">保障责任</td>
											<td class="col-sm-4 col-xs-4">保障金额</td>
										</tr>
										<tr>
											<td class="col-sm-4 col-xs-4" rowspan="5">固定保障</td>
											<td class="col-sm-4 col-xs-4">意外身故/残疾</td>
											<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 30 : dto.product_code eq 'TYX-RB-4' ? 40 : dto.product_code eq 'TYX-RB-5' ? 50 : dto.product_code eq 'TYX-RB-6' ? 60 : 0 } 万元</td>
										</tr>
										<tr>
											<td class="col-sm-4 col-xs-4">意外医疗</td>
											<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 3 : dto.product_code eq 'TYX-RB-4' ? 4 : dto.product_code eq 'TYX-RB-5' ? 5 : dto.product_code eq 'TYX-RB-6' ? 6 : 0 } 万元</td>
										</tr>
										<tr>
											<td class="col-sm-4 col-xs-4">意外住院津贴</td>
											<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 100 : dto.product_code eq 'TYX-RB-4' ? 100 : dto.product_code eq 'TYX-RB-5' ? 150 : dto.product_code eq 'TYX-RB-6' ? 200 : 0 } 元/天</td>
										</tr>
										<tr>
											<td class="col-sm-4 col-xs-4">猝死（身故）</td>
											<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 10 : dto.product_code eq 'TYX-RB-4' ? 20 : dto.product_code eq 'TYX-RB-5' ? 20 : dto.product_code eq 'TYX-RB-6' ? 20 : 0 } 万元</td>
										</tr>
										<tr>
											<td class="col-sm-4 col-xs-4">救护车费用</td>
											<td class="col-sm-4 col-xs-4">1000 元</td>
										</tr>
										<c:if test="${vo.is_contain_repo eq '1'||vo.is_contain_repo eq '3'}">
											<tr>
												<td class="col-sm-4 col-xs-4" rowspan="1">可选保障一</td>
												<td class="col-sm-4 col-xs-4">疾病身故/全残</td>
												<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 15 : dto.product_code eq 'TYX-RB-4' ? 20 : dto.product_code eq 'TYX-RB-5' ? 25 : dto.product_code eq 'TYX-RB-6' ? 30 : 0 } 万元</td>
											</tr>
										</c:if>
										<c:if test="${vo.is_contain_repo eq '2'||vo.is_contain_repo eq '3'}">
											<tr>
												<td class="col-sm-4 col-xs-4" rowspan="1">可选保障二</td>
												<td class="col-sm-4 col-xs-4">重大疾病</td>
												<td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 15 : dto.product_code eq 'TYX-RB-4' ? 20 : dto.product_code eq 'TYX-RB-5' ? 25 : dto.product_code eq 'TYX-RB-6' ? 30 : 0 } 万元</td>
											</tr>
										</c:if>
										</tbody>
									</table>
								</td>
							</tr>
						</c:when>
						<c:otherwise>
							<tr>
								<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案确认</td>
								<td colspan="3" class="col-sm-10 col-xs-10">
									<table class="table ">
										<tbody>
										<tr>
											<td class="col-sm-6 col-xs-6">保障责任</td>
											<td class="col-sm-6 col-xs-6">保障金额</td>
										</tr>
										<c:forEach items="${ dto.responsibilityVoList }" var="irp">
											<tr>
												<td class="col-sm-6 col-xs-6" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>${irp.name}</td>
												<td class="col-sm-6 col-xs-6" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>${irp.fcy}${empty irp.compensation_days ? '元' : '元/天'}</td>
											</tr>
										</c:forEach>
										</tbody>
									</table>
								</td>
							</tr>
						</c:otherwise>
					</c:choose>--%>
					<tr>
						<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案</td>
						<td colspan="3" class="col-sm-10 col-xs-10">
							<table class="table ">
								<tbody>
								<tr>
									<td class="col-sm-4 col-xs-4">保障责任</td>
									<td class="col-sm-2 col-xs-2">
										<c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
										<c:choose>
											<c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
												保险金额
											</c:when>
											<c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
												赔偿限额
											</c:when>
											<c:otherwise>
												保险金额
											</c:otherwise>
										</c:choose>
									</td>
									<td class="col-sm-2 col-xs-2">免赔额</td>
									<td class="col-sm-2 col-xs-2">赔付比例</td>
									<td class="col-sm-2 col-xs-2">免赔天数</td>
								</tr>
								<c:forEach items="${ vo.responsibilityVoList }" var="irp">
									<tr <c:choose>
										<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
											hidden
										</c:when>
										<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
											hidden
										</c:when>
										<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
											hidden
										</c:when>
										<c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
											hidden
										</c:when>
										<c:otherwise>

										</c:otherwise>
									</c:choose>>
										<td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
										<td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
											<c:choose>
												<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
												</c:when>
												<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
												</c:when>
												<c:otherwise>
													<span>-</span>
												</c:otherwise>
											</c:choose>
										</td>
										<td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
										<td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
										<td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
									</tr>
								</c:forEach>
								</tbody>
							</table>
						</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>退保账户信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">开户名</td>
						<td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[0].account_name}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">账户开户行</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_name}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">银行账号</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_account}</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保声明</h3></div>
			<div class="affirm-warr">
				<p class="mt30" style="font-weight: bold">1、投保人通过合法途径获得团体授权，向保险人投保本险种，所有投保操作和内容已获得认可，所有被保险人均为与投保单位有劳动关系的劳动者，该产品的保障内容以及保险金额已向被保险人进行了明确说明，并征得其同意。</p>
				<p style="font-weight: bold">2、投保人已就保险事宜与全部被保险人进行了宣导和沟通，凡参与该保险的全部被保险人均符合险种条款所约定（包括但不限于责任免除、投保人被保险人义务、保险金申请与给付等）的投保条件，并了解保障内容且同意由投保人统一办理投保事项，投保人已认真阅读并正确理解条款和投保须知的所有内容，并接受上述内容，同意以此作为订立保险合同的依据。</p>
				<p class="mb30" style="font-weight: bold">3、本产品投保填写以及所附的被保险人清单中的各项事实均属实，并作为本保险合同的组成部分，如有隐瞒或不实告知，投保人愿承担由此带来的法律后果，保险人有权解除保险合同，对于合同解除前发生的任何事故，保险人可不承担任何责任。</p>
			</div>
			<div class="mess-title"><h3>保险条款</h3></div>
			<div class="affirm-warr">
				<p class="mb30" style="font-weight: bold"></p>
				<c:forEach items="${fn:split(pd.pro_clauses, '#')}" var="pcs">
					<p class="mt30" style="margin-top: 0;font-weight: bold"><a target="_blank" href="<c:url value='/weixin/product/clause/${fn:split(pcs, "::")[0]}' />">${fn:split(pcs, "::")[1]}</a></p>
				</c:forEach>
				<p class="mb30" style="font-weight: bold"></p>
			</div>
		</div><!-- w-95-auto end -->
		<c:if test="${fn:contains(dto.product_code,'TYX-PAC')}">
			<div class="w-95-auto" style="height: 80px">
				<div class="col-sm-12 col-xs-12">
					<p style="font-weight: bold;">*付款通道</p>
					<div class="row">
						<div class="col-sm-2 col-xs-2 rad-io">
							<span><input name="pay_channel" type="radio" id="checkbox1_dg" value="0" checked><label for="checkbox1_dg" class="pull-left"></label><strong  class="pull-left">线下对公转账</strong></span>
						</div>
						<%--<div class="col-sm-2 col-xs-2 rad-io">
							<span><input name="pay_channel" type="radio" id="checkbox2_dg" value="1"><label for="checkbox2_dg" class="pull-left"></label><strong  class="pull-left">线上在线支付</strong></span>
						</div>--%>
					</div>
				</div>
			</div>
		</c:if>
		<c:if test="${fn:contains(dto.product_code,'TYX-CA')||fn:contains(dto.product_code,'TYX-QH')||fn:contains(dto.product_code,'TYX-HT')}">
			<div class="w-95-auto" style="height: 80px">
				<div class="col-sm-12 col-xs-12">
					<p style="font-weight: bold;">*付款通道</p>
					<div class="row">
						<%--<div class="col-sm-2 col-xs-2 rad-io">
							<span><input name="pay_channel" type="radio" id="checkbox1_dg" value="0" checked><label for="checkbox1_dg" class="pull-left"></label><strong  class="pull-left">线下对公转账</strong></span>
						</div>--%>
						<div class="col-sm-2 col-xs-2 rad-io">
							<span><input name="pay_channel" type="radio" id="checkbox2_dg" value="1"><label for="checkbox2_dg" class="pull-left"></label><strong  class="pull-left">线上在线支付</strong></span>
						</div>
					</div>
				</div>
			</div>
		</c:if>
	</div><!-- message-war end -->
	<div class="row next-step">
		<div class="col-sm-6 col-sm-6">
			<div class="insure-check">
				<span class="check-box pull-left">
					<input type="checkbox" id="checkbox1_ss" />
					<label for="checkbox1_ss"></label>
				</span>
				<span class="pull-left">本企业已阅读并接受以上投保声明及保险条款</span><br />
			</div>
			<p class="fs-20-cl">保费<strong class="fs-26"> ￥${ dto.gross_premium}</strong></p>
		</div>
		<div class="col-sm-3 col-xs-3 text-right pull-right">
			<p>
				<a href="<c:url value='/insurance/tyx/policy/policy/${vo.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="save">返回修改</a>
				<a href="javascript:void(0);" onclick="validateChecked('${vo.oid}');" id="validatePost" class="ns-btn">确认申请</a>
			</p>
			<!--确认投保单详情<p>
				<a href="javascript:;" class="save">下载保单</a>
				<a href="javascript:;" class="save ml-35">下载保函</a>
			</p>-->
		</div>
	</div>
</div><!-- container end -->
<jsp:include page="../../../index/multi_f.jsp" />
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>
<!-- script -->
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
	window.onload = function () {
		//以后优化 频繁变更水印
		watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
	}
    var baseUrl = '${pageContext.request.contextPath }';
    var win_sign = 0;//0本站内嵌，1它站内嵌
    <c:if test="${fn:contains(userdetail.web_type, 'ARS')||fn:contains(userdetail.web_type, 'SAAS')||fn:contains(userdetail.web_type, 'PASP')}">
    win_sign = 1;
    </c:if>
    $(function(){
        changeFrameSet(1,"");
        changeFrameSet(0,'');

        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });
		document.onmousedown = function(ev){
			ev = ev || window.event;
			var x=ev.clientX;
			var y=ev.clientY;
			insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息确认');
			<%--insOperation2('${vo.oid}','','投保信息确认',x,y);--%>
		}

    });
    function validateChecked(_id){
        var index = laySomenType(0,null,'',0);
        if($("#checkbox1_ss").is(':checked')){
			var pay_channel = $("input[name='pay_channel']:checked").val();
			if(pay_channel == undefined || pay_channel == ''){
				laySomenType(2,index,'',0);
				laySomenType(1,null,"请选择“付款通道”！",2000);
				insOperation('${vo.oid}','','投保信息确认');
				return;
			}
			laySomenType(1,null,"核保过程可能需要1-2分钟，请勿关闭浏览！",5000);
			$.ajax({
                type: 'POST',
                timeout:120000,
                url:baseUrl + '/insurance/tyx/transaction/API_Underwriting',
                data:{
                    'policyId':_id
                },
                dataType:"json",
                success: function(json){
                    if(json.statusCode == '200') {
                        var status = '4';
                        if(pay_channel == '0'){
                            status = '3';
                        }
                        $.ajax({
                            type: 'POST',
                            url:baseUrl + '/insurance/tyx/policy/updateOrderFormStatus',
                            data:{
                                'order_id':_id,
                                'status':status
                            },
                            dataType:"json",
                            success: function(json){
                                if(json.statusCode == '200') {
									<c:if test="${!fn:contains(dto.product_code,'TYX-CA')}">
									insOperation('${vo.oid}','','投保信息确认');
									laySomenType(2,index,'',0);
									window.location.href = baseUrl + '/insurance/tyx/policy/policyPayment/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
									/*var _t = setInterval(function () {
										if(_tong==1){
											clearInterval(_t);
											laySomenType(2,index,'',0);
											window.location.href = baseUrl + '/insurance/tyx/policy/policyPayment/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
										}
									},300);*/
									</c:if>
									<c:if test="${fn:contains(dto.product_code,'TYX-CA')}">
									insOperation('${vo.oid}','','投保信息确认');
									laySomenType(2,index,'',0);
									window.location.href = baseUrl + '/insurance/gmr/policy/payment_iframe/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
									/*var _t = setInterval(function () {
										if(_tong==1){
											clearInterval(_t);
											laySomenType(2,index,'',0);
											window.location.href = baseUrl + '/insurance/gmr/policy/payment_iframe/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
										}
									},300);*/
									</c:if>
                                }else{
									laySomenType(2,index,'',0);
                                    laySomenType(1,null,json.resultDto.message,2000);
                                }
                            },
                            error : function(XMLHttpRequest, textStatus, errorThrown) {
                                laySomenType(2,index,'',0);
                                laySomenType(1,null,"（APP-TYX-051）订单数据丢失，请联系管理员！",2000);
                            }
                        });
                    }
                    if(json.statusCode == '300') {
                        laySomenType(2,index,'',0);
                        laySomenType(1,null,json.message,2000);
                    }
                },
                error:function(jqXHR, textStatus, errorThrown){
                    laySomenType(2,index,'',0);
                    if(textStatus=="timeout"){
                        laySomenType(1,null,"（APP-TYX-052）加载超时，请重试",2000);
                    }else{
                        laySomenType(1,null,"（APP-TYX-053）订单信息处理失败，请联系客服人员！",2000);
                    }
                }
            });
        }else{
            laySomenType(1,null,"请勾选“本企业已阅读并接受以上投保声明及保险条款”！",2000);
            laySomenType(2,index,'',0);
        }

    }
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
</body>
</html>