<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>

<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-确认投保信息</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body style="background: rgba(244,245,246,1);">

<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">投保确认</li>
	</ol>--%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">投保信息审核</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<div class="message-war"><!-- message-war start -->
		<h2>${ dto.product_name}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5>订单号码：${ dto.trade_serial_number}</h5>
			<div class="mess-title"><h3>推荐人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
						<td class="col-sm-4 col-xs-4">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
						<td class="col-sm-4 col-xs-4"></td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保人基本情况</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
                       	 <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">公司名称(中文)</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].name_cn}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">公司名称(英文)</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].name_en}</td>
                        </tr>
						 <tr>
							 <td class="tablebg_f5f8fa col-sm-2 col-xs-2">海关代码</td>
							 <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].customs_code}</td>
							 <td class="tablebg_f5f8fa col-sm-2 col-xs-2">${vo.roleSubjectList[0].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[0].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</td>
							 <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].organization_code}</td>
						 </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
                            <td class="col-sm-4 col-xs-4">${ reg_role}${ vo.roleSubjectList[0].reg_address}</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">主要联系人姓名</td>
							<td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].link_name}</td>
                        </tr>
						 <tr>
							 <td class="tablebg_f5f8fa col-sm-2 col-xs-2">主要联系人手机</td>
							 <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].link_tel}</td>
							 <td class="tablebg_f5f8fa col-sm-2 col-xs-2">主要联系人电子信箱</td>
							 <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].link_email}</td>
						 </tr>
						<tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">法定代表人姓名</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].legal_name}</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">法定代表人电话</td>
							<td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].legal_phone}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">企业类型</td>
                            <td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[0].com_type,"comType","")}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">经营性质</td>
                            <td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[0].com_nature,"comNature","")}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">所属行业</td>
                            <td class="col-sm-4 col-xs-4">
								${ vo.roleSubjectList[0].industry}
                            </td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                            <td class="col-sm-4 col-xs-4"></td>
                        </tr> 
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>经营情况</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">本企业从业人员（人）</td>
                            <td class="col-sm-4 col-xs-4">${ vo.person_num}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">上年报关出口总金额（美元）</td>
                            <td class="col-sm-4 col-xs-4">${ vo.export_amount}</td>
                        </tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">未收汇金额（美元）</td>
							<td class="col-sm-4 col-xs-4">${ vo.uncollected_amount}</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">&nbsp;</td>
							<td class="col-sm-4 col-xs-4">&nbsp;</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">未收汇原因</td>
							<td class="col-sm-10 col-xs-10" colspan="3">${ vo.uncollected_cause}</td>
						</tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>单一买方/开证行</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">年度保险费币种</td>
                            <td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.annual_currency,"annualCurrency","")}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">单一买家最高赔付限额（美元）</td>
                            <td class="col-sm-4 col-xs-4">${vo.pay_limit}</td>
                        </tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">赔偿比例(%)</td>
							<td class="col-sm-4 col-xs-4">${vo.pro_rata*100}</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">保单最高赔偿限额（美元）</td>
							<td class="col-sm-4 col-xs-4">${vo.insured_amount}</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">预计保费（美元）</td>
							<td class="col-sm-4 col-xs-4">${vo.gross_premium}</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">&nbsp;</td>
							<td class="col-sm-4 col-xs-4">&nbsp;</td>
						</tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保计划信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">保险期间</td>
						<td class="col-sm-10 col-xs-10" colspan="3">
							自&nbsp;${vo.inception_date}&nbsp;零时起，至&nbsp;${vo.planned_end_date}&nbsp;二十四时止
						</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">司法管辖</td>
						<td class="col-sm-10 col-xs-10" colspan="3">中华人民共和国司法管辖（港澳台除外）</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">争议解决方式</td>
						<td class="col-sm-10 col-xs-10" colspan="3">
							${ vo.disputes eq '1' ? '仲裁':'诉讼'}
							<c:if test="${vo.disputes eq '1'}">
								，仲裁机构：${vo.arbitral_institution}
							</c:if>
							<c:if test="${vo.disputes eq '0'}">
								，诉讼所在地：${reg_rule}&nbsp;${vo.lawsuit_institution}
							</c:if>
						</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>其它需要说明事项</h3></div>
			<div class="imnotes">
				<p>${ vo.notes}</p>
			</div>
			
			<div class="mess-title"><h3>声明与保证事项</h3></div>
			<div class="affirm-warr">
				<p class="mt30">（一）我公司郑重声明已经详读《小微企业短期出口信用综合保险条款》，对上述保险条款，<strong>尤其是涉及免除或限制保险人责任的黑体字部分的条款内容，</strong>中国太平洋财产保险股份有限公司已向我公司进行了明确的提示和说明，我公司也已充分理解并无异议，并在此基础上填写本《投保单》。我公司保证向中国太平洋财产保险股份有限公司提供的一切情况准确无误，并保证按照保险单规定全面履行我们的各项义务。</p>
				<p>（二）我公司承诺，一旦贵公司全额收到本保单下年度保险费，即视为我公司对本保险单全部内容已经充分理解并全部接受中国太平洋财产保险股份有限公司出具的保险单的全部内容，<strong>特别是免除或限制保险人责任的黑体字部分的条款内容以及《保险单明细表》内容。</strong></p>
				<p>（三）我公司保证投保的全部出口业务的销售合同真实、合法、有效。</p>
				<p>（四）我公司保证未经中国太平洋财产保险股份有限公司书面同意，不向除我公司开户银行以外的任何机构、买方或其他人披露本保险关系的存在或其他内容。</p>
				<p>（五）我公司保证本《投保单》中所填写的内容均是真实的，无隐瞒任何与本保险有关的重要情况，并同意以此作为贵公司承担保险责任的先决条件。</p>
				<p class="mb30"><strong>附件：</strong><a href="<c:url value='/synopsis/clause/xm01' />" target="_blank">《小微企业短期出口信用综合保险条款》</a></p>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end -->
	<div class="row next-step">
		<div class="col-sm-6 col-sm-6">
			<div class="insure-check">
				<span class="check-box pull-left">
					<input type="checkbox" id="checkbox1_ss" />
					<label for="checkbox1_ss"></label>
				</span>
				<span class="pull-left">我已仔细阅读并同意以上声明与保证事项及<a target="_blank" href="<c:url value='/synopsis/clause/my01'/>">《小微企业短期出口信用综合保险条款》</a></span><br /> 
			</div> 
		</div>
		<div class="col-sm-3 col-xs-3 text-right pull-right">
			<p>
				<a href="<c:url value='/insurance/customs/policy/${vo.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="save">返回修改</a>
				<a href="javascript:void(0);" onclick="validateChecked('${vo.oid}');" id="validatePost" class="ns-btn">确认申请</a>
			</p>
		</div>
	</div>
</div><!-- container end --> 

<!-- 内容部分  注册  结束 -->
<jsp:include page="../../../index/multi_f.jsp" />
<form id="dow-now" action="<c:url value='/synopsis/sodownload'/>" method="post">
	<input name="path" id="path-dow" type="hidden">
	<input name="name" id="name-dow" type="hidden">
</form>
<!-- script -->
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
    $(function(){
        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });

    });
	function validateMsg(){
		layer.msg("请先打印投保单将其盖上贵公司公章并通过“上传投保单”按钮上传盖公章后的投保单方可申请！");
	}
    function validateChecked(_id){
        if($("#checkbox1_ss").is(':checked')){
            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas({'policyId':_id},baseUrl+'/api/xyx/transaction/API_Underwriting',false,true,function(data){
                if(data.statusCode == '200') {
                    //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
                    setParamDatas({'order_id':_id,'status':'5'},baseUrl+'/insurance/customs/policy/updateOrderFormStatus',false,true,function(json){
                        if(json.statusCode == '200') {
                            window.location.href = baseUrl + '/insurance/customs/policy/policyPayment/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                        }else{
                            laySomenType(1,null,json.message,0);
                            dialogClose(true);
                        }
                    });
                }
                if(data.statusCode == '300') {
                    dialogClose(true);
                    laySomenType(1,null,data.message,0);
                }
            });
        }else{
            layer.msg("请勾选“我已仔细阅读并同意以上声明与保证事项及《小微企业短期出口信用综合保险条款》”！");
        }

    }
	/*function validateChecked(_id){
		if($("#checkbox1_ss").is(':checked')){
			var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
			$.ajax({
				type: 'POST',
				url:baseUrl + '/insurance/customs/policy/updateOrderFormStatus',
				data:{
					'order_id':_id,
					'status':'2'
				},
				dataType:"json",
				success: function(json){
					layer.close(index);
					if(json.statusCode == '200') {
						window.location.href = baseUrl + '/insurance/customs/policy/policyPayment/'+json.navTabId;
					}else{
						layer.msg(json.message);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}else{
			layer.msg("请勾选“我已仔细阅读并同意以上声明与保证事项及《小微企业短期出口信用综合保险条款》”！");
		}
			
	}*/
	function sodownload(path,name){
		path = path.split(".com/")[1];
		$("#path-dow").val(path);
		$("#name-dow").val(name);
		$("#dow-now").submit();
	}
	function showInsureModal(){
		$("#insureModal").modal("show");
	}
	
	function showPrintPolicyModal(policyId){
		layer.open({
			  type: 2,
			  title:'投保单预览',
			  scrollbar: false,
			  area : [ '70%', '90%' ],
			  shade : 0.8,
			  skin: 'agreementModal',
			  btn: ['打印','取消'],
			  content: baseUrl +'/insurance/transaction/printPolicy/'+policyId+'?ACCESS_TOKEN=${ACCESS_TOKEN}', //iframe的url
			  yes:function(indexIframe, layero){
			    var iframeWin = window[layero.find('iframe')[0]['name']]; //得到iframe页的窗口对象，执行iframe页的方法：iframeWin.method();
			    iframeWin.printPage();
			  }
		});
	}
	function uploadInsure(){
		var policyId = $("#policyId").val();
		var insurePath = $("#insurePath_file-5").val();
		if(insurePath ==""){
			layer.msg("请选择投保单");
		}else{
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$("#insureForm").ajaxSubmit({
				success : function(data) {
					layer.close(index);
					layer.msg(data.message);
					if(data.status == "200"){
						$("#insureModal").modal("hide");
						$("#validatePost").attr("href","javascript:validateChecked(${vo.oid});");
					}
				},
				error : function() {
					layer.close(index);
					alert('error');
				}
			});
		}
	}
</script>
<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
</body>
</html>