<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-填写投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
	</head>
<body style="background: rgba(244,245,246,1);">
<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<ol class="breadcrumb">

	</ol>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-3">
				<p><i class="pull-left">3</i><span class="pull-left">投保信息审核</span></p>
			</div>
			<div class="col-sm-3 col-sm-3 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left"> 缴费通知</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item"  action="<c:url value='/insurance/customs/policy/mi_confirmPage?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
        <input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
		<input type="hidden" name="product_id" id="product_oid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>推荐人信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-4 col-xs-4">
					<p>推荐人的手机号或编号</p>
					<input type="text" name="recommend_code" id="recommendCode" data-relate="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
				</div>
				<div class="col-sm-4 col-xs-4">
				</div>
				<div class="col-sm-4 col-xs-4">
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3 id="cy_lxr">投保单位信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<input type="hidden" name="roleSubjectList[0].oid" id="appRoleID" value="${vo.roleSubjectList[0].oid}"/>
				<input type="hidden" name="roleSubjectList[0].kind" id="kind" value="3"/>
				<input type="hidden" name="roleSubjectList[0].role_type" id="roleType" value="1"/>
				<div class="col-sm-3 col-xs-4">
					<p>*公司名称(中文)</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].name_cn" id="name_cn" value="${vo.roleSubjectList[0].name_cn}" class="form-control" placeholder="" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*海关编码</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].customs_code" id="customsCode" value="${vo.roleSubjectList[0].customs_code}" class="form-control" placeholder="" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*证件类型</p>
					<select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_type" id="id_type" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="1" <c:if test="${vo.roleSubjectList[0].id_type eq '1' }"> selected="selected"</c:if>>组织机构代码证</option>
						<option value="2" <c:if test="${vo.roleSubjectList[0].id_type eq '2' }"> selected="selected"</c:if>>统一社会信用代码证</option>
					</select>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*证件号码</p>
					<input Data-Val="Required" title="证件号码" type="text" GIST-ID="id_type" id="app_organizingCode" name="roleSubjectList[0].organization_code" value="${vo.roleSubjectList[0].organization_code}" class="form-control" placeholder="对应证件类型的证件号" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*公司名称(英文)</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].name_en" id="name_en" value="${vo.roleSubjectList[0].name_en}" class="form-control" placeholder="" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-9 col-xs-9">
					<p>*注册地址</p>
					<div class="row">
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
								<option value="">请选择省</option>
								<c:forEach items="${provinceList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
								<option value="">请选择市</option>
								<c:forEach items="${reg_cityList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
								<option value="">请选择县</option>
								<c:forEach items="${reg_areaList }" var="list">
									<option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-6 col-xs-6">
							<input Data-Val="Required" title="详细地址" type="text" name="roleSubjectList[0].reg_address" id="app_address" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" onblur="validateForms(this)" />
							<span class="glyphicon form-control-feedback" style="top: 0;" aria-hidden="true"></span>
						</div>
					</div>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-3 col-xs-3">
					<p>*联系人</p>
					<input Data-Val="Required" title="联系人" type="text" id="app_linkman" name="roleSubjectList[0].link_name" value="${vo.roleSubjectList[0].link_name}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*手机号码</p>
					<input Data-Val="Num Required" title="手机号码" type="text" id="app_tel" name="roleSubjectList[0].link_tel" value="${vo.roleSubjectList[0].link_tel}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*邮箱</p>
					<input Data-Val="Required" title="邮箱" type="text" id="app_email" name="roleSubjectList[0].link_email" value="${vo.roleSubjectList[0].link_email}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-3 col-xs-3">
					<p>*法人代表姓名</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].legal_name" id="legalName" value="${vo.roleSubjectList[0].legal_name}" class="form-control" placeholder="" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*联系电话</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].legal_phone" id="legalPhone" value="${vo.roleSubjectList[0].legal_phone}" class="form-control"  placeholder="例：010-0000000" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-4 col-xs-4">
					<p>*营业执照<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
					<input Data-Val="Required" type="hidden" title="" name="roleSubjectList[0].app_business_path" id="app_businessPath" value="${vo.roleSubjectList[0].app_business_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_business_path }" name="app_businessPath_file" id="app_businessPath_file-5" data-drawview="${vo.roleSubjectList[0].app_business_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>*法人身份证复印件(正)</p>
					<input type="hidden" title="" name="roleSubjectList[0].app_idcard_path" id="app_idcardPath" value="${vo.roleSubjectList[0].app_idcard_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_idcard_path }" name="app_idcardPath_file" id="app_idcardPath_file-5" data-drawview="${vo.roleSubjectList[0].app_idcard_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>*法人身份证复印件（反）</p>
					<input type="hidden" title="" name="roleSubjectList[0].app_idcard_versa_path" id="app_idcard_versaPath" value="${vo.roleSubjectList[0].app_idcard_versa_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_idcard_versa_path }" name="app_idcard_versaPath_file" id="app_idcard_versaPath_file-5" data-drawview="${vo.roleSubjectList[0].app_idcard_versa_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>企业基本信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3">
					<p>*企业类型</p>
					<select Data-Val="Required" class="form-control" name="roleSubjectList[0].com_type" id="com_type" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<c:forEach items="${listComType }" var="list">
							<option value="${list.value}" <c:if test="${vo.roleSubjectList[0].com_type eq list.value }"> selected="selected"</c:if>>${list.label}</option>
						</c:forEach>
					</select>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*经营性质</p>
					<select Data-Val="Required" class="form-control" name="roleSubjectList[0].com_nature" id="com_nature" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<c:forEach items="${listComNature }" var="list">
							<option value="${list.value}" <c:if test="${vo.roleSubjectList[0].com_nature eq list.value }"> selected="selected"</c:if>>${list.label}</option>
						</c:forEach>
					</select>
				</div>
				<div class="col-sm-3 col-xs-3" id="s_yui">
					<p>*所属行业</p>
					<input Data-Val="Other Required" type="text" name="roleSubjectList[0].industry" id="industry" DATA-HELP="industry_down" value="${vo.roleSubjectList[0].industry}" class="form-control"/>
					<div class="select_set_down" id="industry_down">
						<ul>
							<c:forEach items="${listIndustry }" var="list">
								<li><span>${list.label }</span></li>
							</c:forEach>
						</ul>
					</div>
				</div>
				<div class="clear"></div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>经营情况</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3">
					<p>*本企业从业人员（人）</p>
					<input Data-Val="Num Required" type="text" name="person_num" id="personNum" value="${vo.person_num}" class="form-control" placeholder="" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*上年报关出口总金额（美元）</p>
					<input disabled type="text" id="exportAmountFake" value="${vo.export_amount}" class="form-control" placeholder="" />
					<input Data-Val="Point Required" type="hidden" name="export_amount" id="exportAmount" value="${vo.export_amount}" />
				</div>
				<%--<div class="col-sm-3 col-xs-3">
					<p>*本年预计出口金额（美元）</p>
					 <input Data-Val="Point Required" type="text" name="export_amount" id="exportAmount" value="${vo.export_amount}" class="form-control" placeholder="" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*主要出口商品</p>
					 <input Data-Val="Required" type="text" name="commodities" id="commodities" value="${vo.commodities}" class="form-control" placeholder="" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>--%>
				<div class="col-sm-12 col-xs-12 mt-20">上年出口未收汇情况</div>
				<div class="col-sm-3 col-xs-3">
					<p>*未收汇金额（美元）</p>
					<input Data-Val="Point Required" type="text" name="uncollected_amount" id="uncollectedAmount" value="${vo.uncollected_amount}" class="form-control" placeholder="" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-12 col-xs-12">
					<p>未收汇原因</p>
					<textarea name="uncollected_cause" id="uncollectedCause" class="text-w form-control">${ vo.uncollected_cause}</textarea>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>单一买方/开证行</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<input type="hidden" id="proRule" />
				<div class="col-sm-3 col-xs-3">
					<p>*年度保险费币种</p>
					<select Data-Val="Required" class="form-control" name="annual_currency" id="annualCurrency" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="0">美元</option>
						<%--<c:forEach items="${listAnnualCurrency }" var="list">
							<option value="${list.value}" <c:if test="${vo.annual_currency eq list.value }"> selected="selected"</c:if>>${list.label}</option>
						</c:forEach>--%>
					</select>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*预计保费（美元）</p>
					<input disabled type="text" id="grossPremiumFake" value="${vo.gross_premium}" class="form-control" placeholder="" />
					<input Data-Val="Point Required" type="hidden" name="gross_premium" id="grossPremium" value="${vo.gross_premium}" />
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*单一买家最高赔付限额（美元）</p>
					<input disabled type="text" id="payLimitFake" value="${vo.pay_limit}" class="form-control" placeholder="" />
					<input Data-Val="Point Required" type="hidden" name="pay_limit" id="payLimit" value="${vo.pay_limit}" />
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*赔偿比例(%)</p>
					<input disabled type="text" id="proRataFake" value="${vo.pro_rata*100}" class="form-control" />
					<input Data-Val="Point Required" type="hidden" name="pro_rata" id="proRata" value="${vo.pro_rata}" />
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*保单最高赔偿限额（美元）</p>
					<input disabled type="text" id="insuredAmountFake" value="${vo.insured_amount}" class="form-control" placeholder="" />
					<input Data-Val="Point Required" type="hidden" name="insured_amount" id="insuredAmount" value="${vo.insured_amount}" />
				</div>

			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>投保计划信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-9 col-xs-9">
					<p>*保险期间</p>
					<div class="row fs-lh34">
						<div class="col-sm-4 col-xs-4"><label class="mr-5 pull-left">自</label><label class="pull-left"><input name="inception_date" readonly id="inceptionDate" value="${vo.inception_date}" class="laydate-icon form-control"></label> </div>
						<div class="col-sm-2 col-xs-2">零时起</div>
						<div class="col-sm-4 col-xs-4"><label class="mr-5 pull-left">至</label><label class="pull-left"><input readonly name="planned_end_date" id="plannedEndDate" value="${vo.planned_end_date}" class="laydate-icon form-control"></label></div>
						<div class="col-sm-2 col-xs-2">二十四时止</div>
					</div>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-12 col-xs-12">
					<p>司法管辖</p>
					<div><span>中华人民共和国司法管辖（港澳台除外）</span></div>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-12 col-xs-12">
					<p>争议处理</p>
					<div><span>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：</span></div>
					<div class="row">
						<div class="col-sm-12 col-xs-12">
							<div class="row">
								<div class="col-sm-2 col-xs-2 rad-io mt-20">
									<span><input type="radio" value="0" name="disputes" id="dispute_radio1" onclick="checkToradio('dispute_radio1','radio');" <c:if test="${ empty vo.disputes || vo.disputes eq '0' }"> checked="checked" </c:if>><label for="dispute_radio1" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio1','radio');">诉讼</strong></span>
								</div>
								<div class="col-sm-2 col-xs-2 rad-io mt-20">
									<span><input type="radio" value="1" name="disputes" id="dispute_radio2" onclick="checkToradio('dispute_radio2','radio');"  <c:if test="${vo.disputes eq '1' }"> checked="checked" </c:if>><label for="dispute_radio2" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio2','radio');">仲裁</strong></span>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-sm-12 col-xs-12" id="lawsuitItem" <c:if test="${vo.disputes eq '1' }"> style="display: none;" </c:if>>
					<div class="row">
						<div class="col-sm-9 col-xs-9">
							<p>*诉讼地址</p>
							<div class="row">
								<div class="col-sm-2 col-xs-2">
									<select<c:if test="${empty vo.disputes ? true : vo.disputes eq '0'}"> Data-Val="Required"</c:if> title="省" name="lawsuit_province" id="lawsuitProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('lawsuitCity', '', '2', this);">
										<option value="">请选择省</option>
										<c:forEach items="${provinceList }" var="list">
											<option value="${list.codes }" <c:if test="${list.codes eq vo.lawsuit_province }"> selected="selected"</c:if>>${list.named }</option>
										</c:forEach>
									</select>
								</div>
								<div class="col-sm-2 col-xs-2">
									<select<c:if test="${empty vo.disputes ? true : vo.disputes eq '0'}"> Data-Val="Required"</c:if> title="市" name="lawsuit_city" id="lawsuitCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('lawsuitArea', '', '3', this);">
										<option value="">请选择市</option>
										<c:forEach items="${reg_cityList }" var="list">
											<option value="${list.codes }" <c:if test="${list.codes eq vo.lawsuit_city}"> selected="selected"</c:if>>${list.named }</option>
										</c:forEach>
									</select>
								</div>
								<div class="col-sm-2 col-xs-2">
									<select<c:if test="${empty vo.disputes ? true : vo.disputes eq '0'}"> Data-Val="Required"</c:if> title="县" name="lawsuit_area" id="lawsuitArea" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
										<option value="">请选择县</option>
										<c:forEach items="${reg_areaList }" var="list">
											<option value="${list.codes }" <c:if test="${vo.lawsuit_area eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
										</c:forEach>
									</select>
								</div>
								<div class="col-sm-6 col-xs-6">
									<input<c:if test="${empty vo.disputes ? true : vo.disputes eq '0'}"> Data-Val="Required"</c:if> title="详细地址" type="text" name="lawsuit_address" id="lawsuitAddress" value="${vo.lawsuit_address}" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" onblur="validateForms(this)" />
									<span class="glyphicon form-control-feedback" style="top: 0;" aria-hidden="true"></span>
								</div>
							</div>
						</div>
						<div class="col-sm-3 col-xs-3">
							<p>*诉讼机构</p>
							<input<c:if test="${empty vo.disputes ? true : vo.disputes eq '0'}"> Data-Val="Required"</c:if> type="text" name="lawsuit_institution" id="lawsuitInstitution" value="${vo.lawsuit_institution }" class="form-control"/>
							<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
						</div>
					</div>
				</div>

				<div class="col-sm-4 col-xs-4" id="s_yui" <c:if test="${empty vo.disputes ? true : vo.disputes eq '0' }"> style="display: none;" </c:if>>
					<p>*仲裁机构</p>
					<input<c:if test="${vo.disputes eq '1' }"> Data-Val="Other Required"</c:if> type="text" name="arbitral_institution" id="arbitralInstitution" DATA-HELP="arbitralInstitution_down" value="${vo.arbitral_institution }" class="form-control su-lo"/>
					<span class="glyphicon form-control-feedback pa-27" aria-hidden="true"></span>
					<div class="select_set_down" id="arbitralInstitution_down" style="top: 60px;">
						<ul>
							<li><span>中国国际经济贸易仲裁委员会上海分会</span></li>
							<li><span>中国国际经济贸易仲裁委员会北京分会</span></li>
							<li><span>中国国际经济贸易仲裁委员会华南分会</span></li>
						</ul>
					</div>
				</div>
				<div class="clear"></div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>*其他需要说明事项</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-12 col-xs-12 mt-15">
					<div class="col-sm-12 col-xs-12">
						<div class="row">
							<div class="col-sm-12 col-xs-12">
								<textarea name="notes" id="notes" class="text-w form-control">${ vo.notes}</textarea>
							</div>
						</div>
					</div>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>单证信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3 mt-20">
                    <span class="pull-left check-box">
                        <input type="checkbox" value="1" name="mailPolicyVo.need_insur_bill" id="need_insur_bill" <c:if test="${not empty vo.mailPolicyVo.need_insur_bill && vo.mailPolicyVo.need_insur_bill eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_insur_bill"></label>
                    </span>
					<span class="pull-left lhml5">需要纸质保单</span>
				</div>
				<div class="clear"></div>
				<div id="mod_1" <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> style="display: none;"</c:if>>
					<div class="col-sm-3 col-xs-3">
						<p>*收件人名称</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_name" id="receiverName" value="${ vo.mailPolicyVo.receiver_name}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill ? true : vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收件人手机</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_mobile" id="receiverMobile" value="${ vo.mailPolicyVo.receiver_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-6 col-xs-6">
						<p>*收件人地址</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_address_detail" id="receiverAddressDetail" value="${ vo.mailPolicyVo.receiver_address_detail}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
				</div>
				<div class="col-sm-3 col-xs-3 mt-20">
                    <span class="pull-left check-box">
                        <input type="checkbox" name="mailPolicyVo.need_receipt" value="1" id="need_receipt" <c:if test="${not empty vo.mailPolicyVo.need_receipt && vo.mailPolicyVo.need_receipt eq '1'}"> checked="checked"</c:if> />
                        <label for="need_receipt"></label>
                        <%--<input type="hidden" name="mailPolicyVo.need_receipt" value="1" />--%>
                    </span>
					<span class="pull-left lhml5">需要纸质发票</span>
				</div>
				<div class="clear"></div>
				<div id="mod_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
					<div class="col-sm-12 col-xs-12">
						<p>发票种类</p>
						<div class="row">
							<div class="col-sm-12 col-xs-12">
								<div class="row">
									<div class="col-sm-2 col-xs-2 rad-io">
										<span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_1" value="0" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> checked="checked"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> checked="checked"</c:if>><label for="invoice_type_1" class="pull-left"></label><strong  class="pull-left">增值税普通发票</strong></span>
									</div>
									<div class="col-sm-2 col-xs-2 rad-io">
										<span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_2" value="1" <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1' }"> checked="checked"</c:if>><label for="invoice_type_2" class="pull-left"></label><strong  class="pull-left">增值税专用发票</strong></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-sm-12 col-xs-12 reminder" id="mod_2_1" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
					<label>温馨提示：请认真填写下述信息，确保信息真实准确，以免因开票信息错误给贵司带来损失。提交信息后，我司将在1-2个工作日完成审核，请及时关注审核结果。</label>
				</div>
				<div id="mod_2_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
					<div class="col-sm-3 col-xs-3">
						<p>*单位名称</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receipt_head" id="receipt_head" value="${ vo.mailPolicyVo.receipt_head}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收票人姓名</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taker_name" id="takerName" value="${ vo.mailPolicyVo.taker_name}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收票人手机</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taker_mobile" id="takerMobile" value="${ vo.mailPolicyVo.taker_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收票人地址</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taker_address_detail" id="takerAddressDetail" value="${ vo.mailPolicyVo.taker_address_detail}" class="form-control" placeholder="企业营业执照上的全称"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3" <c:if test="${vo.mailPolicyVo.invoice_type eq '1'}"> style="display: none;"</c:if>>
						<p>*纳税人识别号</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice_1" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.invoice_type eq '1'}"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
				</div>
				<div id="mod_2_3" <c:if test="${empty mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
					<div class="col-sm-3 col-xs-3">
						<p>*纳税人识别号</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*注册地址</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.register_address_invoice" id="registerAddressInvoice" value="${ vo.mailPolicyVo.register_address_invoice}" class="form-control" placeholder="企业营业执照上的注册地址"  <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*电话</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receipt_phone" id="receiptPhone" value="${ vo.mailPolicyVo.receipt_phone}" class="form-control" placeholder="企业联系电话"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*开户银行省</p>
						<select Data-Val="Required" title="省" name="mailPolicyVo.bank_province" id="bankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bankCity', '', '2', this);" <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
							<option value="">请选择省</option>
							<c:forEach items="${provinceList }" var="list">
								<option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_province }"> selected="selected"</c:if>>${list.named }</option>
							</c:forEach>
						</select>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*开户银行市</p>
						<select title="市" name="mailPolicyVo.bank_city" id="bankCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
							<option value="">请选择市</option>
							<c:forEach items="${bankCityList }" var="list">
								<option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_city}"> selected="selected"</c:if>>${list.named }</option>
							</c:forEach>
						</select>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*开户银行</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.bank_invoice" id="bankInvoice" value="${ vo.mailPolicyVo.bank_invoice}" class="form-control" placeholder="企业银行开户许可证上的开户银行"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*银行账号</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.bank_account_invoice" id="bankAccountInvoice" value="${ vo.mailPolicyVo.bank_account_invoice}" class="form-control" placeholder="企业开户许可证上的银行账号"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
					<div class="col-sm-4 col-xs-4">
						<p>税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
						<input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
						<div>
							<input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>一般纳税人证明</p>
						<input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
						<div>
							<input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>银行开户许可证</p>
						<input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
						<div>
							<input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>营业执照副本<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
						<input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
						<div>
							<input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>增票授权委托书（个人支付时需提供此委托书<a href="<c:url value='/resources/files/增票授权委托书.doc' />" target="_blank">下载</a>）</p>
						<input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
						<div>
							<input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		</form>
		<div class="row next-step">
			<div class="col-sm-12 col-xs-12 text-right pull-right">
				<p>
					<a href="javascript:void(0);" onclick="saveMicroInfo();" id="pendingInfo" class="save">暂存本页</a>
					<a href="javascript:void(0);" onclick="save_policy_mi();" class="ns-btn">下一步</a>
				</p>
			</div>
		</div>
	</div><!-- container end -->
<input id="fileKeyName" type="hidden" value=""><!-- 上传文件的key，重要！ -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">营业执照</h4>
		  </div>
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
		  </div>
		</div>
  </div>
</div>
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">组织机构代码证</h4>
		  </div>
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
		  </div>
		</div>
  </div>
</div>
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">税务登记证</h4>
		  </div>
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
		  </div>
		</div>
  </div>
</div>
<!-- 税务登记证 end -->
<jsp:include page="../../../index/multi_f.jsp" />
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script src="<c:url value='/resources/commonJS/con-common.js'/>" type="text/javascript"></script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/customs_enterBasicInfo.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/json2.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>

<script>
	$(function () {
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/company/query',false,false,function(json){
            var str = "";
            if (json.length > 0){
                for (var i = 0; i < json.length; i++) {
                    str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].company_name + '</p></li>';
                }
            }
            if(str != ""){
                var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用联系人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                $('body').append(lxr_html);
                $("#userList").html(str);
                addCylxr();
            }
        });
		function addCylxr(){
			//点击联系人
			$('.contacts_modal ul li').click(function () {
				$('.contacts_modal ul li').removeClass('active');
				$(this).addClass('active');
				if(!$('.contacts-bottom .sure').hasClass('sure_color')){
					$('.contacts-bottom span.sure').addClass('sure_color');
				}
			});
			//点击取消
			$('.contacts-bottom .cancel').click(function () {
				$('.contacts_modal').hide();
				$('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
			});
			$('.contacts_modal .title-cancel').click(function () {
				$('.contacts_modal').hide();
				$('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
			});
			//点击填入
			$('.contacts-bottom .sure').click(function () {
				if($(this).hasClass('sure_color')){
					setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
					$('.contacts_modal').hide();
					$('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
				}else{
					//没有点击选择联系人
					// alert('请选择一个联系人！');
				}
			})
			var _html = '投保单位信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals()">选择常用投保人</a>';
			$("#cy_lxr").html(_html);
		}
		function setTBR(_json){
			var _tp = '${userdetail.terminal_type}';
			var json = eval("(" + _json + ")");
			console.log(json);
            $("#name_cn").val(json.company_name);//企业名称
            $("#id_type").val(json.certificate_type);//证件类型
            if(json.certificate_code != ''){
                var cccode = json.certificate_code;
                if(json.certificate_type == '1'){
                    cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                }
                $("#app_organizingCode").val(cccode);//证件号码
            }
            $("#app_address").val(json.address);//详细地址
            $("#regProvince").val(json.province);//省
            $("#regProvince").change();
            setTimeout(function(){
                $("#regCity").val(json.city);//市
                $("#regCity").change();
                setTimeout(function(){
                    $("#regDistrict").val(json.district);//区
                },1000);
            },1000);
            $("#app_linkman").val(json.user_name);//联系人
            $("#app_tel").val(json.telephone);//手机
            $("#app_email").val(json.email);//邮箱
		}

		//配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
		setParamDatas('','/pc/tb-mail-address/${userdetail.oid}',false,false,function(json){
			if(json != undefined && json != null){
				if('${dto.oid}' == ''){
					$('#need_insur_bill').on('click',function(){//纸质发票
						if($(this).is(":checked")){
							$("#receiverName").val(json.user_name);
							$("#receiverMobile").val(json.telephone);
							$("#receiverAddressDetail").val(json.address);
						}
					});
					$('#need_receipt').on('click',function(){//电子发票
						if($(this).is(":checked")){
							$("#takerName").val(json.user_name);
							$("#takerMobile").val(json.telephone);
							$("#takerAddressDetail").val(json.address);
						}
					});
				}
			}

		});

	})
	//点击弹窗出现
	function showContractsModals() {
		$('.contacts_modal').show();
		$('.black-mask').show();
	}

</script>
<script type="text/javascript">

	$('#industry').focus(function () {
	    var down_id = $(this).attr('DATA-HELP');
        var _id = this.id;
        $('#'+down_id).css({"display":"block"});
        $('#'+down_id).find('li').each(function(){
            $(this).bind("click", function(){
                $('#'+_id).val($(this).children().html());
			});
        });
    }).blur(function () {
        var _id = this.id;
        setTimeout(function(){
            var down_id = $('#'+_id).attr('DATA-HELP');
            $('#'+down_id).css({"display":"none"});
		},200);
    });
	$('#arbitralInstitution').focus(function () {
	    var down_id = $(this).attr('DATA-HELP');
        var _id = this.id;
        $('#'+down_id).css({"display":"block"});
        $('#'+down_id).find('li').each(function(){
            $(this).bind("click", function(){
                $('#'+_id).val($(this).children().html());
			});
        });
    }).blur(function () {
        var _id = this.id;
        setTimeout(function(){
            var down_id = $('#'+_id).attr('DATA-HELP');
            $('#'+down_id).css({"display":"none"});
		},200);
    });
var baseUrl = '${pageContext.request.contextPath }';
function openImgView(img_url){
    top.layer.open({
        type: 1,
        skin: 'layui-layer-rim', //加上边框
        area: ['420px', '350px'], //宽高
        content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
    });
}
var count = 2;
$(function(){
    if($("#need_insur_bill").is(':checked')){
        $("#mod_1").fadeIn(1000);
    }else{
        $("#mod_1").fadeOut(1000);
    }
    if($("#need_receipt").is(':checked')){
        var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        $("#mod_2").fadeIn(1000);
        if(_invoice_val == "0"){//普通发票
            $("#mod_2_1").fadeIn(1000);
        }else{//专用发票,VATINVOICE
            $("#mod_2_1").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_3").fadeIn(1000);
        }
    }else{
        $("#mod_2").fadeOut(1000);
        $("#mod_2_1").fadeOut(1000);
        $("#mod_2_2").fadeOut(1000);
        $("#mod_2_3").fadeOut(1000);
    }
    $("input[id=need_insur_bill]").on("click",function(){
        if($(this).is(':checked')){
            $("#mod_1").fadeIn(1000);
            $("#mod_1").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_1").fadeOut(1000);
            $("#mod_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
                $(this).val('');
            });
        }
    });
    $("input[id=need_receipt]").on("click",function(){
        if($(this).is(':checked')){
            $("#mod_2").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_2_3").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2").fadeOut(1000);
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
        }
    });
    $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
        if($(this).val() == "1"){
            $("#taxpayerNumberInvoice_1").parent().hide();
            $("#mod_2_1").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_3").fadeIn(1000);
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#taxpayerNumberInvoice_1").attr("data-status","hidden");
        }else{
            $("#taxpayerNumberInvoice_1").parent().show();
            $("#mod_2_3").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#taxpayerNumberInvoice_1").attr("data-status","");
        }
    });

    $("input[Data-Val]").each(function(){
        var dataVal = $(this).attr("Data-Val");
        if(dataVal == "Required"||dataVal == "Point Required"||dataVal == "Num Required") {
            $(this).on("blur",function() {
                var _val = $(this).val();
                var o = this;
                if (_val == '') {
                    loser_has(o);
                    return;
                }else{
                    if( o.id == "name_cn"|| o.id == "customsCode"){
                        var _name = $('#name_cn').val(),_code = $('#customsCode').val();
                        if(_name != ''&&_code != ''){
                            var n = 0;
                            $.ajax({
                                type: 'POST',
                                url: baseUrl + "/insurance/product/identityCheck.json",
                                data:{
                                    'company_name':_name,
                                    'customs_code':_code
								},
                                dataType:"json",
                                async: false,
                                success: function(json){
                                    if(json.statusCode == '200') {
                                        n=1;
                                        $('#exportAmountFake').val(json.navTabId);
                                        $('#exportAmount').val(json.navTabId);
                                        getRuleXWCK();
                                    }else{
                                        layer.msg(json.message, {time: 3000});
                                    }
                                }
                            });
                            if(n == 1){
                                success_has('name_cn');
                                success_has('customsCode');
                                return;
                            }else{
                                loser_has('name_cn');
                                loser_has('customsCode');
                                $('#name_cn').val('');
                                $('#customsCode').val('');
                                return;
							}
                        }
                    }
                    if( o.id == "receiverMobile"|| o.id == "takerMobile"){
                        if(checkMobile(_val) == false){
                            loser_has(o);
                            $(o).val('');
                            return;
                        }
                    }
                    if( o.id == "takerZipCode"){
                        if(checkZipCode(_val) == false){
                            loser_has(o);
                            $(o).val('');
                            return;
                        }
                    }
                    if( o.id == "receiptPhone"){
                        var isPhone=/^((0\d{2,3})-)?(\d{7,8})(-(\d{3,}))?$/;
                        if(!isPhone.test(_val)){
                            loser_has(o);
                            $(o).val('');
                            return;
                        }
                    }
                    if( o.id == "reg_address"){
                        if(_val.length<8){
                            loser_has(o);
                            layer.msg("请正确填写地址信息（包含：镇、乡或街道）");
                            $(o).val('');
                            return;
                        }
                    }
                    if( o.id == "bankAccountInvoice"){
                        if(checkCardId(_val) == false){
                            loser_has(o);
                            $(o).val('');
                            return;
                        }
                    }
                    if(o.id == "app_email"){
                        if(checkEmail(_val) == false){
                            loser_has(o);
                            $(o).val('');
                            return;
                        }
                    }
                    if(o.id == "app_tel"){
                        var isTel = /^1[2|3|4|5|6|7|8|9][0-9]\d{4,8}$/;
                        if(!isTel.test(_val)){
                            loser_has(o);
                            $(o).val('');
                            return;
                        }
                        if(checkMobile(_val) == false){
                            loser_has(o);
                            return;
                        }
                    }
                    if(o.id == "exportAmount"||o.id == "taking"||o.id == "uncollectedAmount"){
                        if(isNaN(_val)){
                            loser_has(o);
                            $(o).val('');
                            layer.msg("请正确填写金额！");
                            return;
						}
                    }
                    if(o.id == "personNum"){
                        if(!(/(^[1-9]\d*$)/.test(_val))){
                            loser_has(o);
                            $(o).val('');
                            layer.msg("请正确填写人数！");
                            return;
                        }
                    }
                    if(o.id == "legalPhone"){
                        var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
                        if(!isPhone.test(_val)){
                            loser_has(o);
                            $(o).val('');
                            return;
                        }else{
                            var arrs = _val.split("-");

                            if(arrs.length>1){
                                if(arrs.length == 2){
                                    if(isSameNumber(arrs[0])||isSameNumber(arrs[1])){
                                        loser_has(o);
                                        $(o).val('');
                                        return;
                                    }
                                }else if(arrs.length == 3){
                                    if(isSameNumber(arrs[0])||isSameNumber(arrs[1])||isSameNumber(arrs[2])){
                                        loser_has(o);
                                        $(o).val('');
                                        return;
                                    }
                                }
                            }else{
                                if(isSameNumber(arrs[0])){
                                    loser_has(o);
                                    $(o).val('');
                                    return;
                                }
                            }
                        }
                    }
                    if(o.id == "app_organizingCode"){
                        var idt = $("#"+o.id).attr('GIST-ID');
                        var csg = 0;
                        if(idt != ''){
                            if($("#"+idt).val() == '1'){//组织机构代码
                                if(_val.length < 9 || _val.length > 10){//!checkOrganizingCode(thisValue)
                                    loser_has(o);
                                    $(o).val('');
                                    return;
                                }
                            }else{
                                csg = 1;
                            }
                        }else{
                            csg = 1;
                        }
                        if(csg == 1){
                            csg = 0;
                            if(_val.length != 18){//!checkOrganizingCode(thisValue)
                                loser_has(o);
                                $(o).val('');
                                return;
                            }
                        }
                    }
                    success_has(o);
				}
            });
        }
    });
});
    function mailSet(){
        var invoice_type_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        if(invoice_type_val == "0"){
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
            $("#mod_2_3").find("select").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_insur_bill").is(':checked')){
            $("#mod_1").find("input").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_receipt").is(':checked')){
            $("#mod_2_2").find("input").each(function(){
                $(this).val('');
            });
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
        }
    }
function changeDistrict(districtID, areaID, level, obj) {
    var code = obj.value;
    if(districtID == 'regDistrict'||districtID == 'regCity'){
        if(level == '2'&&code != '350000'){
            layer.msg("该产品目前仅支持福建省厦门地区小微企业投保");
            return;
        }
        if(level == '3'&&code != '350200'){
            layer.msg("该产品目前仅支持福建省厦门地区小微企业投保");
            return
        }
        if(level == '3'){
            getRuleXWCK();
        }
    }
    $("#" + districtID).empty();
    if(areaID != '') {
        $("#" + areaID).empty();
        $("#" + areaID).append("<option value=''>--请选择区县--</option>");
    }
    $.ajax({
        type: 'POST',
        url: baseUrl + '/synopsis/findCity.json',
        data:{"codeLevel":level,"parentCode":code},
        dataType:"json",
        async: false,
        success: function(json) {
            if(level == '2') {
                $("#" + districtID).append("<option value=''>请选择市</option>");
            } else if(level == '3') {
                $("#" + districtID).append("<option value=''>请选择区／县</option>");
            } else {
                $("#" + districtID).append("<option value=''>--请选择--</option>");
            }
            for(var i = 0; i < json.length; i++) {
                var obj = json[i];
                var appendStr = "<option value='" + obj.codes + "' ";
                appendStr = appendStr + ">" + obj.named + "</option>"
                $("#" + districtID).append(appendStr);
            }
        }
    });
}
function getRuleXWCK(){
    var code = $('#regCity').val();
    if(code != ''){
        $.ajax({
            type: 'POST',
            url: baseUrl + '/insurance/customs/policy/getRuleXWCKVo/${pd.oid}/'+code,
            dataType:"json",
            success: function(data) {
                $('#proRule').val(JSON.stringify(data));
                computationalCosts();
            }
        });
    }
}
function computationalCosts(){
    var _proRule = $('#proRule').val();
    var _exportAmount = $('#exportAmount').val();
    if(_proRule == ''||_exportAmount == ''){
        return;
	}
    var data=eval('(' + _proRule + ')');;
    var _pay_limit = Number(data.pay_limit);//单一最高
    var _rate = Number(data.rate);//费率
    var _compensation_multiple = Number(data.compensation_multiple);//倍数
    var _pro_rata = Number(data.pro_rata) * 100;//比例
    var gross_premium = 500;
    if(Number(_exportAmount)>0){
        gross_premium = (Number(_exportAmount) * _rate).toFixed(2);//预计保费
        if(gross_premium<500){
            gross_premium = 500;
        }
	}
	var insured_amount = (gross_premium * _compensation_multiple).toFixed(2);
	$('#grossPremium').val(gross_premium);
	$('#grossPremiumFake').val(gross_premium);
    $('#insuredAmount').val(insured_amount);
    $('#insuredAmountFake').val(insured_amount);
    $('#proRata').val(Number(data.pro_rata));
    $('#proRataFake').val(_pro_rata);
    $('#payLimit').val(_pay_limit);
    $('#payLimitFake').val(_pay_limit);
}
function save_policy_mi(){
	if(customsVerify()){
		var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
		$.ajax({
			type: 'POST',
			url:baseUrl + '/insurance/customs/policy/pendingMicroExportPolicy',
			data:$("#policyInfoForm").serialize(),
			dataType:"json",
			success: function(json){
				layer.close(index);
				if(json.statusCode == '200') {
					window.location.href = baseUrl + '/insurance/customs/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
				}else{
					layer.msg(json.message);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.close(index);
				layer.msg(textStatus);
			}
		});
	}
}
    function checkToradio(_id, type){
        var o = $("#"+_id);
        if(type=="radio"){
            o.prop('checked',true);
            //console.log(o.val());
            if(o.val() == "1"){
                $("#arbitralInstitution").parent().show();
                $("#arbitralInstitution").attr('Data-Val','Other Required');

                $("#lawsuitInstitution").val('');
                $("#lawsuitAddress").val('');
                $("#lawsuitInstitution").attr('Data-Val','');
                $("#lawsuitAddress").attr('Data-Val','');
                $("#lawsuitProvince").attr('Data-Val','');
                $("#lawsuitCity").attr('Data-Val','');
                $("#lawsuitArea").attr('Data-Val','');
                loser_sty('lawsuitInstitution');
                loser_sty('lawsuitAddress');
                $("#lawsuitItem").hide();
            }else if(o.val() == "0"){
                $("#lawsuitItem").show();
                $("#lawsuitInstitution").attr('Data-Val','Required');
                $("#lawsuitAddress").attr('Data-Val','Required');
                $("#lawsuitProvince").attr('Data-Val','Required');
                $("#lawsuitCity").attr('Data-Val','Required');
                $("#lawsuitArea").attr('Data-Val','Required');

                $("#arbitralInstitution").val('');
                $("#arbitralInstitution").attr('Data-Val','');
                loser_sty('arbitralInstitution');
                $("#arbitralInstitution").parent().hide();
            }else if(o.val() == "VATINVOICE"||o.val() == "ORDINARYINVOICE"){
                invoiceToHide(_id);
            }else{
                o.click();
            }
        }else if(type=="checkbox"){

            if($("#"+_id).attr('checked')) {
                o.attr('checked', false);
                //o.parents('.checkbox').find('span').removeClass('checked');
            } else {
                o.attr('checked', true);
                //o.parents('.checkbox').find('span').addClass('checked');
            }
            o.click();
        }
    }
function customsVerify(){
	var flag = true;
	$("input[Data-Val]").each(function(){
		var dataVal = $(this).attr("Data-Val");
		if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
			if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Other Required"){
				if($(this).val() == ''){
					document.getElementById(this.id).scrollIntoView();
					layer.msg("必填项不能为空！");
					$(this).focus();
					flag = false;
					return true;
				}else{
                    if($(this).val().length>60){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("长度超出限制！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }
				}

			}

		}
        if(dataVal == "Required"){
            if(this.id == 'app_businessPath'){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("请上传营业执照！");
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
            if(this.id == 'app_idcardPath'){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("请上传法人身份证！");
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
        }
	});
    if(flag){
        $("input[Data-Val]").each(function() {
            var dataVal = $(this).attr("Data-Val");
            if ($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden") {
                if (dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required") {
                    $(this).blur();
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        flag = false;
                        return true;
                    }
                }
            }
        });
        if(!flag){
            layer.msg("请正确填写相关信息！");
        }
    }
	if(flag){
		$("select[Data-Val]").each(function(){
			var dataVal = $(this).attr("Data-Val");
			if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
				if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
					if($(this).val() == ''){
						document.getElementById(this.id).scrollIntoView();
						layer.msg("必填项不能为空！");
						$(this).focus();
						flag = false;
						return true;
					}

				}
			}
		});
		if(flag){
			$("textarea[Data-Val]").each(function(){
				var dataVal = $(this).attr("Data-Val");
				if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
					if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
						if($(this).val() == ''){
							document.getElementById(this.id).scrollIntoView();
							layer.msg("必填项不能为空！");
							$(this).focus();
							flag = false;
							return true;
						}else{
                            if($(this).val().length>150){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("长度超出限制(150字符)！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }
                        }

					}
				}
			});

		}
	}
    mailSet();
	return flag;
}
function createSH(_val,_id){
	if(_val == '7'){
		$("#"+_id).show();
	}else{
		$("#"+_id).hide();
	}
}
</script>
</html>