<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-完成投保</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body style="background: rgba(244,245,246,1);">

<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">投保</li>
	</ol>--%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right active">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div> 
	<div class="message-war"><!-- message-war start --> 
		<div class="row w-95-auto"><!-- w-95-auto start --> 
			<div class="playsuc-war">
				<c:if test="${code eq '200'}">
				<p class="succeed-bg text-center"><i class="glyphicon glyphicon-ok text-center"></i></p>
				<p class="text-center fscl-247">${msg}</p>
				<ul>
					<li><a href="<c:url value='/pc/order/exportDetailByOrderID/${dto.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}' />">保单详情 </a><i>|</i></li>
					<li><a href="javascript:void(0);" onclick="sodownload('电子保单','${dto.oid }','1')">保单下载 </a><i>|</i></li>
					<li><a href="javascript:void(0);" onclick="sodownload('电子保函','${dto.oid }','2')"> 保函下载 </a></li>
				</ul>
				</c:if>
				<c:if test="${code eq '300'}">
				<p class="loser-bg text-center"><i class="glyphicon glyphicon-remove"></i></p>
				<p class="text-center fscl-247">${msg}</p>
				<ul>
					<li style="float: none;"><a href="javascript:;" onclick="modileThis();">重新支付 </a></li>
				</ul>
				</c:if>
				<c:if test="${code eq '301'}">
				<p class="loser-bg text-center"><i class="glyphicon glyphicon-remove"></i></p>
				<p class="text-center fscl-247">${msg}</p>
				<ul>
					<li style="float: none;"><a href="<c:url value="/insurance/build/policy/policyPayment/${dto.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}" />">重新支付 </a></li>
				</ul>
				</c:if>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end --> 
</div><!-- container end --> 

<!-- 立即支付 start -->
<div class="modal fade" id="paysThis" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="flushThis();"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">状态更新</h4><%-- <c:url value='/insurance/build/transaction/policyVerify' /> --%>
		  </div> 
		  <div class="modal-body">
		  	<p class="text-center"><span>确认是否已完成支付？</span></p>
		  </div>
		  <div class="modal-footer">
			<div class="mofo-sub">
				<button type="button" class="btn notarize-btn pull-right" style="width: 100px;" onclick="flushThis();">刷新页面</button>
			</div>
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 立即支付 end -->
<form id="ndow-now" action="<c:url value='/synopsis/dedownload'/>" method="post">
	<input name="path" id="path-dow1" type="hidden">
	<input name="name" id="name-dow1" type="hidden">
</form>
<jsp:include page="../../../index/multi_f.jsp" />

<!-- script -->
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	function sodownload(name,pno,signs){
		//layer.msg("提示：初次请求下载速度较慢预计耗时：60秒，请耐心等待！");
        var index = layer.load(0, {shade: [0.3,'#808080']});
		var up = baseUrl + '/synopsis/saveFileToPDF.json';
		$.ajax({
			type : 'POST',
			url : up.trim(),
			data : {
				"pno":pno,
				"num":signs
			},
			dataType : "json",
			async :false,
			success : function(data) {
				/*$("#path-dow1").val(data.message);
                $("#name-dow1").val(name);
                $("#ndow-now").submit();*/
				window.open(data.message);
                layer.close(index);
            },
			error : function() {
				layer.close(index);
				layer.msg("请重新点击下载！");
			}
		});
		
	}
	function modileThis(){
		//paysThis
        var index = layer.load(0, {shade: [0.3,'#808080']});
        $.ajax({
            type : 'POST',
            url : baseUrl + "/insurance/build/transaction/lastPolicyVerify/${dto.oid}",
            dataType : "json",
            async :false,
            success : function(result) {
                layer.close(index);
                if(result.statusCode == '200'){
                    flushThis();
                }else if(result.statusCode == '300'){
                    window.open(result.navTabId);
                    $('#paysThis').modal({backdrop: 'static', keyboard: false});
                }else if(result.statusCode == '301'){
                    location.href = '<c:url value="/insurance/build/policy/policyPayment/${dto.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}" />';
                }
            },
            error : function() {
                layer.close(index);
                layer.msg("请重新点击下载！");
            }
        });

	}
	function flushThis(){
		window.location.reload();
	}
</script>
</body>
</html>