<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-填写投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
	</head>
<body>
<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">投保</li>
	</ol>  --%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item"  action="<c:url value='/insurance/build/policy/confirm?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
		<input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
		<input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>


		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>保险信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3">
					<p>*保证金额度（单位：元）</p>
					<input Data-Val="Point Required" title="保证金额度（单位：元）" data-isrequired="1" type="text" id="insuredAmount" name="insured_amount" value="${vo.insured_amount}" class="form-control" placeholder="" onblur="insuredAmountEQ();">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>

				<div class="col-sm-3 col-xs-3">
					<p>保费</p>
					<div class="wait-price"><span>等待保险公司给出报价</span></div>
				</div>

				<div class="clear"></div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3 id="cy_lxr">投保单位信息</h3></div>
			<input type="hidden" name="roleSubjectList[0].oid" id="appRoleID" value="${vo.roleSubjectList[0].oid}"/>
			<input type="hidden" name="roleSubjectList[0].kind" id="kind" value="1"/>
			<input type="hidden" name="roleSubjectList[0].role_type" id="roleType" value="1"/>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3">
					<p>*投保人名称</p>
					<input Data-Val="Required" title="投保人名称" type="text" id="app_fullName" name="roleSubjectList[0].name_cn" value="${vo.roleSubjectList[0].name_cn}" class="form-control" placeholder="请填写企业名称" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*证件类型</p>
					<select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_type" id="id_type" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="1" <c:if test="${vo.roleSubjectList[0].id_type eq '1' }"> selected="selected"</c:if>>组织机构代码证</option>
						<option value="2" <c:if test="${vo.roleSubjectList[0].id_type eq '2' }"> selected="selected"</c:if>>统一社会信用代码证</option>
					</select>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*证件号码</p>
					<input Data-Val="Required" title="证件号码" type="text" GIST-ID="id_type" id="app_organizingCode" name="roleSubjectList[0].organization_code" value="${vo.roleSubjectList[0].organization_code}" class="form-control" placeholder="对应证件类型的证件号" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*联系电话</p>
					<input Data-Val="Required" title="联系电话" type="text" id="app_phone" name="roleSubjectList[0].phone" value="${vo.roleSubjectList[0].phone}" class="form-control" placeholder="注：区号-电话号码-转接号" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-9 col-xs-9">
					<p>*联系地址</p>
					<div class="row">
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
								<option value="">请选择省</option>
								<c:forEach items="${provinceList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
								<option value="">请选择市</option>
								<c:forEach items="${reg_cityList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
								<option value="">请选择县</option>
								<c:forEach items="${reg_areaList }" var="list">
									<option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-6 col-xs-6">
							<input Data-Val="Required" title="联系地址" type="text" name="roleSubjectList[0].reg_address" id="app_address" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" onblur="validateForms(this)" />
							<span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
						</div>
					</div>
				</div>
				<%--<div class="col-sm-6 col-xs-6">
					<p>*联系地址</p>
					<input Data-Val="Required" title="联系地址" type="text" id="app_address" name="roleSubjectList[0].address" value="${vo.roleSubjectList[0].address}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>--%>

				<div class="col-sm-3 col-xs-3">
					<p>*邮编</p>
					<input Data-Val="Required" title="邮编" type="text" id="app_zipcode" name="roleSubjectList[0].zip_code" value="${vo.roleSubjectList[0].zip_code}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-3 col-xs-3">
					<p>*联系人</p>
					<input Data-Val="Required" title="联系人" type="text" id="app_linkman" name="roleSubjectList[0].link_name" value="${vo.roleSubjectList[0].link_name}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*手机号码</p>
					<input Data-Val="Required" title="手机号码" type="text" id="app_tel" name="roleSubjectList[0].link_tel" value="${vo.roleSubjectList[0].link_tel}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*邮箱</p>
					<input Data-Val="Required" title="邮箱" type="text" id="app_email" name="roleSubjectList[0].link_email" value="${vo.roleSubjectList[0].link_email}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-4 col-xs-4">
					<p>*营业执照<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
					<input Data-Val="Required" type="hidden" title="" name="roleSubjectList[0].app_business_path" id="app_businessPath" value="${vo.roleSubjectList[0].app_business_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_business_path }" name="app_businessPath_file" id="app_businessPath_file-5" data-drawview="${vo.roleSubjectList[0].app_business_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>*组织机构代码证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/org.jpg')">（样例）</a></p>
					<input type="hidden" title="" name="roleSubjectList[0].app_organizing_path" id="app_organizingPath" value="${vo.roleSubjectList[0].app_organizing_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_organizing_path }" name="app_organizingPath_file" id="app_organizingPath_file-5" data-drawview="${vo.roleSubjectList[0].app_organizing_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>*税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
					<input type="hidden" title="" name="roleSubjectList[0].app_tax_path" id="app_taxPath" value="${vo.roleSubjectList[0].app_tax_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_tax_path }" name="app_taxPath_file" id="app_taxPath_file-5" data-drawview="${vo.roleSubjectList[0].app_tax_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3 id="cy_lxr_bb">被保险人基本信息</h3></div>
			<input type="hidden" name="roleSubjectList[1].oid" value="${vo.roleSubjectList[1].oid}"/>
			<input type="hidden" name="roleSubjectList[1].kind" value="2"/>
			<input type="hidden" name="roleSubjectList[1].role_type" value="1"/>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3">
					<p>*被保险人名称</p>
					<input Data-Val="Required" title="被保险人名称" type="text" id="ins_fullName" name="roleSubjectList[1].name_cn" value="${vo.roleSubjectList[1].name_cn}" class="form-control" placeholder="请填写企业名称" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*证件类型</p>
					<select Data-Val="Required" class="form-control" name="roleSubjectList[1].id_type" id="ins_id_type" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="1" <c:if test="${vo.roleSubjectList[1].id_type eq '1' }"> selected="selected"</c:if>>组织机构代码证</option>
						<option value="2" <c:if test="${vo.roleSubjectList[1].id_type eq '2' }"> selected="selected"</c:if>>统一社会信用代码证</option>
					</select>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*证件号码</p>
					<input Data-Val="Required" title="证件号码" type="text" GIST-ID="ins_id_type" id="ins_organizingCode" name="roleSubjectList[1].organization_code" value="${vo.roleSubjectList[1].organization_code}" class="form-control" placeholder="对应证件类型的证件号" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-6 col-xs-6">
					<p>*联系地址</p>
					<input Data-Val="Required" title="联系地址" placeholder="请填写详细地址（包含：省、市、区、街道）" type="text" id="ins_address" name="roleSubjectList[1].address" value="${vo.roleSubjectList[1].address}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*联系电话</p>
					<input Data-Val="Required" title="联系电话" type="text" id="ins_phone" name="roleSubjectList[1].phone" value="${vo.roleSubjectList[1].phone}" class="form-control" placeholder="注：区号-电话号码-转接号" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*邮编</p>
					<input title="邮编" type="text" id="ins_zipcode" name="roleSubjectList[1].zip_code" value="${vo.roleSubjectList[1].zip_code}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-3 col-xs-3">
					<p>*联系人</p>
					<input Data-Val="Required" title="联系人" type="text" id="ins_linkman" name="roleSubjectList[1].link_name" value="${vo.roleSubjectList[1].link_name}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*手机号码</p>
					<input Data-Val="Required" title="手机号码" type="text" id="ins_tel" name="roleSubjectList[1].link_tel" value="${vo.roleSubjectList[1].link_tel}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>

			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>投保基本信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3">
					<p>*项目名称及标段</p>
					<input Data-Val="Required" title="项目名称及标段" type="text" id="projectName" name="project_name" value="${vo.project_name}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*招标文件编号</p>
					<input Data-Val="Required" title="招标文件编号" type="text" id="invitationCode" name="invitation_code" value="${vo.invitation_code}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*工程造价（元）</p>
					<input Data-Val="Required" title="工程造价（元）" type="text" id="predictCost" name="predict_cost" value="${vo.predict_cost}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*计划工期</p>
					<input Data-Val="Required" title="计划工期" type="text" id="projectTime" name="project_time" value="${vo.project_time}" class="form-control" placeholder="举例：六个月、一年" onchange="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-6 col-xs-6">
					<p>*工程建设地点</p>
					<input Data-Val="Required" title="工程建设地点" type="text" id="projectAddress" name="project_address" value="${vo.project_address}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-9 col-xs-9">
					<p>*保险期间</p>
					<div class="row fs-lh34">
						<div class="col-sm-1 col-xs-1">自</div>
						<div class="col-sm-3 col-xs-3"><input Data-Val="Required" placeholder="" name="inception_date" id="inceptionDate" value="${vo.inception_date}" class="laydate-icon form-control"> </div>
						<div class="col-sm-2 col-xs-2">零时起</div>
						<div class="col-sm-1 col-xs-1">至</div>
						<div class="col-sm-3 col-xs-3"><input Data-Val="Required" placeholder="" name="planned_end_date" id="plannedEndDate" value="${vo.planned_end_date}" class="laydate-icon form-control"></div>
						<div class="col-sm-2 col-xs-2">二十四时止</div>
					</div>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-12 col-xs-12">
					<p>司法管辖</p>
					<div><span>中华人民共和国司法管辖（港澳台除外）</span></div>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-12 col-xs-12">
					<p>争议处理</p>
					<div><span>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：</span></div>
					<div class="row">
						<div class="col-sm-12 col-xs-12">
							<div class="row">
								<div class="col-sm-2 col-xs-2 rad-io mt-20">
									<span><input type="radio" value="0" name="dispute" id="dispute_radio1" onclick="checkToradio('dispute_radio1','radio');" <c:if test="${ empty vo.dispute || vo.dispute eq '0' }"> checked="checked" </c:if>><label for="dispute_radio1" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio1','radio');">诉讼</strong></span>
								</div>
								<div class="col-sm-2 col-xs-2 rad-io mt-20">
									<span><input type="radio" value="1" name="dispute" id="dispute_radio2" onclick="checkToradio('dispute_radio2','radio');"  <c:if test="${vo.dispute eq '1' }"> checked="checked" </c:if>><label for="dispute_radio2" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio2','radio');">仲裁，仲裁机构</strong></span>
								</div>
								<div class="col-sm-3 col-xs-3" <c:if test="${empty vo.dispute ? true : vo.dispute eq '0' }"> style="display: none;" </c:if>>
									<input type="text" name="arbitral_institution" id="arbitralInstitution" value="${vo.arbitral_institution }" class="form-control su-lo">
									<span class="glyphicon form-control-feedback pa-27" aria-hidden="true"></span>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>单证信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3 mt-20">
                    <span class="pull-left check-box">
                        <input type="checkbox" value="1" name="mailPolicyVo.need_insur_bill" id="need_insur_bill" <c:if test="${not empty vo.mailPolicyVo.need_insur_bill && vo.mailPolicyVo.need_insur_bill eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_insur_bill"></label>
                    </span>
					<span class="pull-left lhml5">需要纸质保单和保函</span>
				</div>
				<div class="clear"></div>
				<div id="mod_1" <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> style="display: none;"</c:if>>
					<div class="col-sm-3 col-xs-3">
						<p>*收件人名称</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_name" id="receiverName" value="${ vo.mailPolicyVo.receiver_name}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill ? true : vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收件人手机</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_mobile" id="receiverMobile" value="${ vo.mailPolicyVo.receiver_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-6 col-xs-6">
						<p>*收件人地址</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_address_detail" id="receiverAddressDetail" value="${ vo.mailPolicyVo.receiver_address_detail}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
				</div>
				<div class="col-sm-3 col-xs-3 mt-20">
                    <span class="pull-left check-box">
                        <input type="checkbox" value="1" name="mailPolicyVo.need_receipt" id="need_receipt" <c:if test="${not empty vo.mailPolicyVo.need_receipt && vo.mailPolicyVo.need_receipt eq '1'}"> checked="checked"</c:if> />
                        <label for="need_receipt"></label>
                    </span>
					<span class="pull-left lhml5">需要纸质发票</span>
				</div>
				<div class="clear"></div>
				<div id="mod_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
					<div class="col-sm-12 col-xs-12">
						<p>发票种类</p>
						<div class="row">
							<div class="col-sm-12 col-xs-12">
								<div class="row">
									<div class="col-sm-2 col-xs-2 rad-io">
										<span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_1" value="0" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> checked="checked"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> checked="checked"</c:if>><label for="invoice_type_1" class="pull-left"></label><strong  class="pull-left">增值税普通发票</strong></span>
									</div>
									<div class="col-sm-2 col-xs-2 rad-io">
										<span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_2" value="1" <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1' }"> checked="checked"</c:if>><label for="invoice_type_2" class="pull-left"></label><strong  class="pull-left">增值税专用发票</strong></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-sm-12 col-xs-12 reminder" id="mod_2_1" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
					<label>温馨提示：请认真填写下述信息，确保信息真实准确，以免因开票信息错误给贵司带来损失。提交信息后，我司将在1-2个工作日完成审核，请及时关注审核结果。</label>
				</div>
				<div id="mod_2_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
					<div class="col-sm-3 col-xs-3">
						<p>*单位名称</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receipt_head" id="receipt_head" value="${ vo.mailPolicyVo.receipt_head}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收票人姓名</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taker_name" id="takerName" value="${ vo.mailPolicyVo.taker_name}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收票人手机</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taker_mobile" id="takerMobile" value="${ vo.mailPolicyVo.taker_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收票人地址</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taker_address_detail" id="takerAddressDetail" value="${ vo.mailPolicyVo.taker_address_detail}" class="form-control" placeholder="企业营业执照上的全称"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3" <c:if test="${vo.mailPolicyVo.invoice_type eq '1'}"> style="display: none;"</c:if>>
						<p>*纳税人识别号</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice_1" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.invoice_type eq '1'}"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
				</div>
				<div id="mod_2_3" <c:if test="${empty mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
					<div class="col-sm-3 col-xs-3">
						<p>*纳税人识别号</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*注册地址</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.register_address_invoice" id="registerAddressInvoice" value="${ vo.mailPolicyVo.register_address_invoice}" class="form-control" placeholder="企业营业执照上的注册地址"  <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*电话</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receipt_phone" id="receiptPhone" value="${ vo.mailPolicyVo.receipt_phone}" class="form-control" placeholder="企业联系电话"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*开户银行省</p>
						<select Data-Val="Required" title="省" name="mailPolicyVo.bank_province" id="bankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bankCity', '', '2', this);" <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
							<option value="">请选择省</option>
							<c:forEach items="${provinceList }" var="list">
								<option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_province }"> selected</c:if>>${list.named }</option>
							</c:forEach>
						</select>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*开户银行市</p>
						<select title="市" name="mailPolicyVo.bank_city" id="bankCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
							<option value="">请选择市</option>
							<c:forEach items="${bankCityList }" var="list">
								<option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_city}"> selected</c:if>>${list.named }</option>
							</c:forEach>
						</select>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*开户银行</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.bank_invoice" id="bankInvoice" value="${ vo.mailPolicyVo.bank_invoice}" class="form-control" placeholder="企业银行开户许可证上的开户银行"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*银行账号</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.bank_account_invoice" id="bankAccountInvoice" value="${ vo.mailPolicyVo.bank_account_invoice}" class="form-control" placeholder="企业开户许可证上的银行账号"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
					<div class="col-sm-4 col-xs-4">
						<p>税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
						<input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
						<div>
							<input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>一般纳税人证明</p>
						<input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
						<div>
							<input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>银行开户许可证</p>
						<input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
						<div>
							<input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>营业执照副本<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
						<input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
						<div>
							<input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>增票授权委托书（个人支付时需提供此委托书<a href="<c:url value='/resources/files/增票授权委托书.doc' />" target="_blank">下载</a>）</p>
						<input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
						<div>
							<input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
					</div>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->

		</form>
		<div class="row next-step">
			<div class="col-sm-12 col-xs-12 text-right pull-right">
				<p>
					<a href="javascript:void(0);" onclick="saveSPFInfo('2');" id="pendingInfo" dataWait="0" class="save">暂存本页</a>
					<a href="javascript:void(0);" id="next_policy" onclick="save_policy_spf('3');" class="ns-btn">下一步</a>
					<a href="javascript:void(0);" onclick="save_policy_spf_pre('1');" class="ns-btn">上一步</a>
				</p>
			</div>
		</div>
	</div><!-- container end -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">营业执照</h4>
		  </div> 
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">组织机构代码证</h4>
		  </div> 
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">税务登记证</h4>
		  </div> 
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 税务登记证 end --> 
<jsp:include page="../../../index/multi_f.jsp" />
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>

	<script>
        $(function () {
            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/company/query',false,false,function(json){
                var str = "";
                if (json.length > 0){
                    for (var i = 0; i < json.length; i++) {
                        str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].company_name + '</p></li>';
                    }
                }
                if(str != ""){
                    var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用投保人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                    $('body').append(lxr_html);
                    $("#userList").html(str);
                    addCylxr();
                }
            });
            function addCylxr(){
                //点击联系人
                $('.contacts_modal ul li').click(function () {
                    $('.contacts_modal ul li').removeClass('active');
                    $(this).addClass('active');
                    if(!$('.contacts-bottom .sure').hasClass('sure_color')){
                        $('.contacts-bottom span.sure').addClass('sure_color');
                    }
                });
                //点击取消
                $('.contacts-bottom .cancel').click(function () {
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
                });
                $('.contacts_modal .title-cancel').click(function () {
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
                });
                //点击填入
                $('.contacts-bottom .sure').click(function () {
                    if($(this).hasClass('sure_color')){
                        setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
                        $('.contacts_modal').hide();
                        $('.black-mask').hide();
                        $('.contacts_modal ul li').removeClass('active');
                    }else{
                        //没有点击选择联系人
                        // alert('请选择一个联系人！');
                    }
                })
                var _html = '投保单位信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals(\'1\')">选择常用投保人</a>';
                var _html_bb = '被保险人基本信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals(\'2\')">选择常用投保人</a>';
                $("#cy_lxr").html(_html);
                $("#cy_lxr_bb").html(_html_bb);
            }
            function setTBR(_json){
                var _sg = $('.contacts-bottom .sure').attr('data-sg');
                var json = eval("(" + _json + ")");
                if(_sg == '1'){//设置投保人
                    $("#app_fullName").val(json.company_name);//企业名称
                    $("#id_type").val(json.certificate_type);//证件类型
                    if(json.certificate_code != ''){
                        var cccode = json.certificate_code;
                        if(json.certificate_type == '1'){
                            cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                        }
                        $("#app_organizingCode").val(cccode);//证件号码
                    }
                    $("#app_address").val(json.address);//详细地址
                    $("#regProvince").val(json.province);//省
                    $("#regProvince").change();
                    setTimeout(function(){
                        $("#regCity").val(json.city);//市
                        $("#regCity").change();
                        setTimeout(function(){
                            $("#regDistrict").val(json.district);//区
                        },1000);
                    },1000);
                    $("#app_linkman").val(json.user_name);//联系人
                    $("#app_tel").val(json.telephone);//手机
                    $("#app_email").val(json.email);//邮箱
                }else if(_sg == '2') {//设置被保险人
                    $("#ins_fullName").val(json.company_name);//企业名称
                    $("#ins_id_type").val(json.certificate_type);//证件类型
                    if(json.certificate_code != ''){
                        var cccode = json.certificate_code;
                        if(json.certificate_type == '1'){
                            cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                        }
                        $("#ins_organizingCode").val(cccode);//证件号码
                    }
                    $("#ins_address").val(json.address);//详细地址
                    $("#ins_linkman").val(json.user_name);//联系人
                    $("#ins_tel").val(json.telephone);//手机
                }

            }

            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas('','/pc/tb-mail-address/${userdetail.oid}',false,false,function(json){
                if(json != undefined && json != null){
                    if(!$('#need_insur_bill').is(":checked")) {
                        $('#need_insur_bill').on('click', function () {//纸质发票
                            if ($(this).is(":checked")) {
                                $("#receiverName").val(json.user_name);
                                $("#receiverMobile").val(json.telephone);
                                $("#receiverAddressDetail").val(json.address);
                            }
                        });
                    }
                    if(!$('#need_receipt').is(":checked")) {
                        $('#need_receipt').on('click',function(){//电子发票
                            if($(this).is(":checked")){
                                $("#takerName").val(json.user_name);
                                $("#takerMobile").val(json.telephone);
                                $("#takerAddressDetail").val(json.address);
                            }
                        });
                    }
                }

            });

        })
        //点击弹窗出现
        function showContractsModals(_sg) {
            $('.contacts_modal').show();
            $('.black-mask').show();
            $('.contacts-bottom .sure').attr('data-sg',_sg);
        }

	</script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
function insuredAmountEQ(){
    var iam = $("#insuredAmount").val();
    if(iam == ''){
        loser_has("insuredAmount");
        $("#insuredAmount").val('');
        $("#insuredAmount").focus();
        return;
    }
    if(!isNaN(iam)){
        if(parseInt(iam) < 1){
            loser_has("insuredAmount");
            $("#insuredAmount").val('');
            $("#insuredAmount").focus();
            return;
        }
    }else{
        loser_has("insuredAmount");
        $("#insuredAmount").val('');
        $("#insuredAmount").focus();
        return;
    }
    success_has("insuredAmount");
}
function openImgView(img_url){
    top.layer.open({
        type: 1,
        skin: 'layui-layer-rim', //加上边框
        area: ['420px', '350px'], //宽高
        content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
    });
}
var count = 2;
$(function(){
    if($("#need_insur_bill").is(':checked')){
        $("#mod_1").fadeIn(1000);
    }else{
        $("#mod_1").fadeOut(1000);
    }
    if($("#need_receipt").is(':checked')){
        var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        $("#mod_2").fadeIn(1000);
        if(_invoice_val == "0"){//普通发票
            $("#mod_2_1").fadeIn(1000);
        }else{//专用发票,VATINVOICE
            $("#mod_2_1").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_3").fadeIn(1000);
        }
    }else{
        $("#mod_2").fadeOut(1000);
        $("#mod_2_1").fadeOut(1000);
        $("#mod_2_2").fadeOut(1000);
        $("#mod_2_3").fadeOut(1000);
    }

});
function save_policy_spf(_page){
    if(customsVerify()){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        $.ajax({
            type: 'POST',
            url:baseUrl + '/insurance/build/policy/pendingSpecialPerformance_2VoPolicy',
            data:$("#policyInfoForm").serialize(),
            dataType:"json",
            success: function(json){
                layer.close(index);
                if(json.statusCode == '200') {
                    window.location.href = baseUrl + '/insurance/build/policy/pg_policy/'+json.navTabId+'/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                }else{
                    layer.msg(json.message);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }
}
function customsVerify(){
    var flag = true;
    $("input[Data-Val]").each(function(){
        var dataVal = $(this).attr("Data-Val");
        if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
            if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("必填项不能为空！");
                    $(this).focus();
                    flag = false;
                    return true;
                }else{
                    if($(this).val().length>40){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("长度超出限制！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }
                }

            }
        }
        if(dataVal == "Required"){
            if(this.id == 'app_businessPath'){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("请上传营业执照！");
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
        }
    });
    if(flag){
        $("input[Data-Val]").each(function() {
            var dataVal = $(this).attr("Data-Val");
            if ($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden") {
                if (dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required") {
                    $(this).blur();
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        flag = false;
                        return true;
                    }
                }
            }
        });
        if(!flag){
            layer.msg("请正确填写相关信息！");
        }
    }
    if(flag){
        $("select[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("必填项不能为空！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }

                }
            }
        });
        if(flag){
            $("textarea[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            layer.msg("必填项不能为空！");
                            $(this).focus();
                            flag = false;
                            return true;
                        }else{
                            if($(this).val().length>100){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("长度超出限制(100字符)！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }
                        }

                    }
                }
            });

        }
    }
    mailSet();
    return flag;
}
function save_policy_spf_pre(_page){
    var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
    window.location.href = baseUrl + '/insurance/build/policy/pg_policy/${dto.oid}/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
}
function saveSPFInfo(page){
    mailSet();
    if(isAllNull() == 1){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        $.ajax({
            type: 'POST',
            url:baseUrl + '/insurance/build/policy/pendingSpecialPerformance_'+page+'VoPolicy',
            data:$("#policyInfoForm").serialize(),
            dataType:"json",
            success: function(json){
                layer.close(index);
                layer.msg(json.message);
                if(json.statusCode == '200') {
                    window.location.href = baseUrl + '/insurance/build/policy/pg_policy/'+json.navTabId+'/'+page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }else{
        layer.msg("表单未检索到数据，请完善信息后暂存！");
    }
}
function mailSet(){
    var invoice_type_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
    if(invoice_type_val == "0"){
        $("#mod_2_3").find("input").each(function(){
            if($(this).attr("type") == "hidden"){
                if($(this).val() != ''){
                    $(this).next().find(".fileinput-remove-button").click();
                }
            }
            loser_sty(this.id);
        });
        $("#mod_2_3").find("select").each(function(){
            $(this).val('');
        });
    }
    if(!$("#need_insur_bill").is(':checked')){
        $("#mod_1").find("input").each(function(){
            $(this).val('');
        });
    }
    if(!$("#need_receipt").is(':checked')){
        $("#mod_2_2").find("input").each(function(){
            $(this).val('');
        });
        $("#mod_2_3").find("input").each(function(){
            if($(this).attr("type") == "hidden"){
                if($(this).val() != ''){
                    $(this).next().find(".fileinput-remove-button").click();
                }
            }
            loser_sty(this.id);
        });
    }
}
function isAllNull(){
    var values, index;
    values = $("#policyInfoForm").serializeArray();
    for (index = 0; index < values.length; ++index){
        var controls=document.getElementsByName(values[index].name);
        for(var i=0;i<controls.length;i++){
            if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
            }
        }
    }
    return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
}
$(function(){
    $("input[id=need_insur_bill]").on("click",function(){
        if($(this).is(':checked')){
            $("#mod_1").fadeIn(1000);
            $("#mod_1").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_1").fadeOut(1000);
            $("#mod_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
                $(this).val('');
            });
        }
    });
    $("input[id=need_receipt]").on("click",function(){
        if($(this).is(':checked')){
            $("#mod_2").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_2_3").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2").fadeOut(1000);
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
        }
    });
    $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
        if($(this).val() == "1"){
            $("#taxpayerNumberInvoice_1").parent().hide();
            $("#mod_2_1").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_3").fadeIn(1000);
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#taxpayerNumberInvoice_1").attr("data-status","hidden");
        }else{
            $("#taxpayerNumberInvoice_1").parent().show();
            $("#mod_2_3").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","hiden");
            });
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#taxpayerNumberInvoice_1").attr("data-status","");
        }
    });

    $("#recommend_code").on("blur",function(){
        var rCode = $(this).val();
        var pID = $(this).attr("data-relate");
        if(rCode != '' && pID != ''){
            if( pID != ''){
                $.ajax({
                    type: 'POST',
                    url:baseUrl + '/insurance/build/policy/isFeeByrecommend_codeAndProductID.json',
                    data:{
                        'productID':pID,
                        'recommend_code':rCode
                    },
                    dataType:"json",
                    success: function(json){
                        layer.msg(json.message);
                        if(json.statusCode != '200') {
                            $(this).val('');
                        }
                    },
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                        layer.msg(textStatus);
                    }
                });
            }else{
                layer.msg("数据丢失，请刷新页面重试！");
            }

        }

    });
});
function changeDistrict(districtID, areaID, level, obj) {
    $("#" + districtID).empty();
    if(areaID != '') {
        $("#" + areaID).empty();
        $("#" + areaID).append("<option value=''>--请选择区县--</option>");
    }
    var code = obj.value;
    $.ajax({
        type: 'POST',
        url: baseUrl + '/synopsis/findCity.json',
        data:{"codeLevel":level,"parentCode":code},
        dataType:"json",
        async: false,
        success: function(json) {
            if(level == '2') {
                $("#" + districtID).append("<option value=''>请选择市</option>");
            } else if(level == '3') {
                $("#" + districtID).append("<option value=''>请选择区／县</option>");
            } else {
                $("#" + districtID).append("<option value=''>--请选择--</option>");
            }
            for(var i = 0; i < json.length; i++) {
                var obj = json[i];
                var appendStr = "<option value='" + obj.codes + "' ";
                appendStr = appendStr + ">" + obj.named + "</option>"
                $("#" + districtID).append(appendStr);
            }
        }
    });
}
function clearBase64Byinput(_el){
    var _file_id = _el.id;
    _file_id = _file_id.substring(0,_file_id.length-7);
    if($("#"+_file_id).val() != ''){
        ajaxFormDataDelete(_file_id);
    }
    $("#"+_file_id).val('');
}
function base64convert(_el,_file){
    var flag = false;
    var fileName = _file.name;
    var type = fileName.split(".")[fileName.split(".").length-1];

    var fileKeyName = "/policy/"+fileName;
    var _file_id = _el.attr("name").replace("_file","").trim();
    if($("#"+_file_id).val() != ''){
        ajaxFormDataDelete(_file_id);
    }
    ajaxFormDataLoad(_file,_file_id,"policy/",type);
    flag = true;
    return flag;
}

function ajaxFormDataLoad(file,_id,directoryName,fileType){
    var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
    var _myData = new Date();
    var _times = _myData.getTime();
    var name = "/"+directoryName+_times+"."+fileType;
    var formData = new FormData();
    formData.append('file', file);
    formData.append('fileName', _times+"."+fileType);
    formData.append('directoryName', directoryName);
    var uul = baseUrl + '/file/ajaxFormDataLoad';
    $.ajax({
        type: 'POST',
        url: uul,
        dataType:"json",
        data: formData,
        processData: false,
        contentType: false,
        success: function(result){
            layer.close(index);
            if(result.statusCode == '200'){
                $("#"+_id).val(result.message);
            }else{
                layer.msg(result.message);
            }
        }
    });
}

function ajaxFormDataDelete(_id){
    var formData = new FormData();
    formData.append('url', $("#"+_id).val());
    var uul = baseUrl + '/file/ajaxFormDataDelete';
    $.ajax({
        url: uul,
        type: 'POST',
        cache: false,
        data: formData,
        processData: false,
        contentType: false
    }).done(function(res) {
        $("#"+_id).val('');
    }).fail(function(res) {

    });
}
Date.prototype.pattern=function(fmt) {
    var o = {
        "M+" : this.getMonth()+1, //月份
        "d+" : this.getDate(), //日
        "h+" : this.getHours()%12 == 0 ? 12 : this.getHours()%12, //小时
        "H+" : this.getHours(), //小时
        "m+" : this.getMinutes(), //分
        "s+" : this.getSeconds(), //秒
        "q+" : Math.floor((this.getMonth()+3)/3), //季度
        "S" : this.getMilliseconds() //毫秒
    };
    var week = {
        "0" : "/u65e5",
        "1" : "/u4e00",
        "2" : "/u4e8c",
        "3" : "/u4e09",
        "4" : "/u56db",
        "5" : "/u4e94",
        "6" : "/u516d"
    };
    if(/(y+)/.test(fmt)){
        fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
    }
    if(/(E+)/.test(fmt)){
        fmt=fmt.replace(RegExp.$1, ((RegExp.$1.length>1) ? (RegExp.$1.length>2 ? "/u661f/u671f" : "/u5468") : "")+week[this.getDay()+""]);
    }
    for(var k in o){
        if(new RegExp("("+ k +")").test(fmt)){
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
        }
    }
    return fmt;
}
var curDate = new Date();
var date = new Date((curDate/1000+86400)*1000);
var nextDate = date.pattern("yyyy-MM-dd");
//日期范围限制
var _star = {
    elem: '#inceptionDate',
    format: 'YYYY-MM-DD',
    min: nextDate, //设定最小日期为当前日期
    max: '2099-06-16', //最大日期
    istoday: false,
    choose: function(datas){

    }
};
var _end = {
    elem: '#plannedEndDate',
    format: 'YYYY-MM-DD',
    min: nextDate,
    max: '2099-06-16',
    istoday: false,
    choose: function(datas){

    }
};

laydate(_star);
laydate(_end);
function checkToradio(_id, type){
    var o = $("#"+_id);
    if(type=="radio"){
        o.prop('checked',true);
        //console.log(o.val());
        if(o.val() == "1"){
            $("#arbitralInstitution").parent().show();
        }else if(o.val() == "0"){
            $("#arbitralInstitution").val('');
            $("#arbitralInstitution").parent().hide();
        }else if(o.val() == "VATINVOICE"||o.val() == "ORDINARYINVOICE"){
            invoiceToHide(_id);
        }else{
            o.click();
        }
    }else if(type=="checkbox"){

        if($("#"+_id).attr('checked')) {
            o.attr('checked', false);
            //o.parents('.checkbox').find('span').removeClass('checked');
        } else {
            o.attr('checked', true);
            //o.parents('.checkbox').find('span').addClass('checked');
        }
        o.click();
    }
}
function validateForms(o){
    var thisValue=$("#"+o.id).val();
    if(thisValue != ""){
        if( o.id == "receiverMobile"|| o.id == "takerMobile"){
            if(checkMobile(thisValue) == false){
                loser_has_ts(o);
                return;
            }
        }
        if( o.id == "takerZipCode"){
            if(checkZipCode(thisValue) == false){
                loser_has_ts(o);
                return;
            }
        }
        if( o.id == "receiptPhone"){
            var isPhone=/^((0\d{2,3})-)?(\d{7,8})(-(\d{3,}))?$/;
            if(!isPhone.test(thisValue)){
                loser_has_ts(o);
                return;
            }
        }
        if( o.id == "bankAccountInvoice"){
            if(checkCardId(thisValue) == false){
                loser_has_ts(o);
                return;
            }
        }
        if( o.id == "app_address"){
            if(thisValue.length<8){
                loser_has_ts(o);
                layer.msg("请正确填写地址信息（包含：镇、乡或街道）");
                $('#'+o.id).val('');
                return;
            }
        }
        if( o.id == "ins_address"){
            if(thisValue.length<10){
                loser_has_ts(o);
                layer.msg("请正确填写地址信息（包含：省、市、区、街道）");
                $('#'+o.id).val('');
                return;
            }
        }
        if( o.id == "debtRatio" ||  o.id == "bidding" || o.id == "predictCost"){
            if(checkInt1(thisValue) == false && checkDouble1(thisValue) == false){
                loser_has_ts(o);
                return;
            }
        }

        if(o.id == "bidName"){
            if($("#fuzzy_query ul").find("li").length == 0){
                $("#fuzzy_query").hide();
            }
        }
        if(o.id == "app_idcard"){
            if(!validateIdent.IdentityCodeValid(thisValue)){
                loser_has_ts(o);
                return;
            }
        }
        if(o.id == "app_email"){
            if(checkEmail(thisValue) == false){
                loser_has_ts(o);
                return;
            }
        }
        if(o.id == "app_zipcode"||o.id == "ins_zipcode"){
            if(checkZipCode(thisValue) == false){
                loser_has_ts(o);
                return;
            }
        }
        if(o.id == "app_tel"||o.id == "ins_tel" ){
            if(checkMobile(thisValue) == false){
                loser_has_ts(o);
                return;
            }
        }
        if(o.id == "app_phone" || o.id == "ins_phone"){
            var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
            if(!isPhone.test(thisValue)){
                loser_has_ts(o);
                return;
            }else{
                var arrs = thisValue.split("-");

                if(arrs.length>1){
                    if(arrs.length == 2){
                        if(isSameNumber(arrs[0])||isSameNumber(arrs[1])){
                            loser_has_ts(o);
                            return;
                        }
                    }else if(arrs.length == 3){
                        if(isSameNumber(arrs[0])||isSameNumber(arrs[1])||isSameNumber(arrs[2])){
                            loser_has_ts(o);
                            return;
                        }
                    }
                }else{
                    if(isSameNumber(arrs[0])){
                        loser_has_ts(o);
                        return;
                    }
                }
            }
        }
        if(o.id == "app_organizingCode" || o.id == "ins_organizingCode"){
            var idt = $("#"+o.id).attr('GIST-ID');
            var csg = 0;
            if(idt != ''){
                if($("#"+idt).val() == '1'){//组织机构代码
                    if(thisValue.length < 9 || thisValue.length > 10){//!checkOrganizingCode(thisValue)
                        loser_has_ts(o);
                        return;
                    }
                }else{
                    csg = 1;
                }
            }else{
                csg = 1;
            }
            if(csg == 1){
                csg = 0;
                if(thisValue.length != 18){//!checkOrganizingCode(thisValue)
                    loser_has_ts(o);
                    return;
                }
            }
        }

        if(o.id == "bidPeriod"){
            if(thisValue != ''){
                var regu = "^[0-9]*[1-9][0-9]*$";
                var re = new RegExp(regu);
                if(thisValue.search(re)!=0){
                    loser_has(o);
                    $(o).val('');
                    $(o).focus();
                    return;
                }
                $.ajax({
                    type: 'POST',
                    url:baseUrl + '/insurance/build/policy/requestPlanEndTime',
                    data:{
                        "bidtime":$("#bidtime").val(),
                        "bidPeriod":$("#bidPeriod").val()
                    },
                    dataType:"json",
                    cache: false,
                    success: function(json){
                        if(json.statusCode == '200') {
                            $("#inceptionDate").val($("#bidtime").val());
                            $("#plannedEndDate").val(json.message);
                        }
                        if(json.statusCode == '300') {
                            layer.msg(json.message);
                        }
                        if(json.statusCode == '301') {
                            loser_has($("#bidtime"));
                        }
                        if(json.statusCode == '302') {
                            loser_has($("#bidPeriod"));
                        }
                    }
                });
            }
        }

    }
    if(thisValue == ""){
        loser_has(o);
        if(o.id == "bidName"){
            $("#fuzzy_query").hide();
        }
        return;
    }

    success_has(o);
}
function isSameNumber(vals){
    var count = 1;
    var flag = false;
    for(var i = 1; i< vals.length; i++){
        if(vals.charAt(0) == vals.charAt(i)){
            count ++;
        }
    }
    if(count == vals.length){
        flag = true;
    }
    return flag;
}
</script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
</html>