<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-填写投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
	</head>
<body style="background: rgba(244,245,246,1);">
<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/product/productInfo/${pd.oid}'/>">产品详情</a></li>
	  <li class="active">投保</li>
	</ol>  --%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item"  action="<c:url value='/insurance/build/policy/confirm?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
		<input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
		<input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>推荐人信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-4 col-xs-4">
					<p>推荐人的手机号或编号</p>
					<input type="text" name="recommend_code" id="recommendCode" data-relate="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
				</div>
				<div class="col-sm-4 col-xs-4">
				</div>
				<div class="col-sm-4 col-xs-4">
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>产品信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-9 col-xs-9">
					<p>地区</p>
					<div class="row">
						<div class="col-sm-3 col-xs-3">
							<select title="省" name="province" id="provinceID" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="changeDistrict('cityID', '', '2', this);">
								<option value="">请选择省</option>
								<c:forEach items="${provinceList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.province }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-3 col-xs-3">
							<select title="市" name="city" id="cityID" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="changeDistrict('areaID', '', '3', this);">
								<option value="">请选择市</option>
								<c:forEach items="${cityList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.city}"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-3 col-xs-3">
							<select Data-Val="Required" title="县" name="area_code" id="areaID" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
								<option value="">请选择县</option>
								<c:forEach items="${areaList }" var="list">
									<option value="${list.codes }" <c:if test="${vo.area_code eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
					</div>
				</div>
				<div class="clear"></div>
				<div class="col-sm-3 col-xs-3">
					<p>*工程类型</p>
					<select Data-Val="Required" title="工程类型" class="form-control" name="type" id="type" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="">--请选择工程类型--</option>
						<option value="1"<c:if test="${vo.type eq '1' }"> selected</c:if>>国家重点工程</option>
						<option value="2"<c:if test="${vo.type eq '2' }"> selected</c:if>>省重点工程</option>
						<option value="3"<c:if test="${vo.type eq '3' }"> selected</c:if>>市重点工程</option>
						<option value="4"<c:if test="${vo.type eq '4' }"> selected</c:if>>其他</option>
					</select>
				</div>

				<div class="col-sm-3 col-xs-3">
					<p>*计划工期</p>
					<input Data-Val="Required" title="计划工期" type="text" id="projectTime_com" name="project_time_com" value="${vo.project_time_com }" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>

				<div class="col-sm-3 col-xs-3">
					<p>*中标价（万元）</p>
					<input Data-Val="Point Required" title="中标价（万元）" type="text" id="bidding" name="bidding" value="${vo.bidding }" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-3 col-xs-3">
					<p>*企业资质类别</p>
					<select Data-Val="Required" title="企业资质类别" class="form-control" name="aptitude_type" id="aptitudeType" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="">--请选择企业资质类别--</option>
						<option value="1"<c:if test="${vo.aptitude_type eq '1' }"> selected</c:if>>施工总承包</option>
						<option value="2"<c:if test="${vo.aptitude_type eq '2' }"> selected</c:if>>施工专业承包</option>
						<option value="3"<c:if test="${vo.aptitude_type eq '3' }"> selected</c:if>>设计</option>
						<option value="4"<c:if test="${vo.aptitude_type eq '4' }"> selected</c:if>>监理</option>
					</select>
				</div>

				<div class="col-sm-3 col-xs-3">
					<p>*企业资质等级</p>
					<select Data-Val="Required" title="企业资质等级" class="form-control" name="aptitude_level" id="aptitudeLevel" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="">--请选择企业资质等级--</option>
						<option value="1"<c:if test="${vo.aptitude_level eq '1' }"> selected</c:if>>特级</option>
						<option value="2"<c:if test="${vo.aptitude_level eq '2' }"> selected</c:if>>一级</option>
						<option value="3"<c:if test="${vo.aptitude_level eq '3' }"> selected</c:if>>二级</option>
						<option value="4"<c:if test="${vo.aptitude_level eq '4' }"> selected</c:if>>三级</option>
					</select>
				</div>

				<div class="col-sm-3 col-xs-3">
					<p>*企业性质</p>
					<select Data-Val="Required" title="企业性质" class="form-control" name="nature_type" id="natureType" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="">--请选择企业性质--</option>
						<option value="1"<c:if test="${vo.nature_type eq '1' }"> selected</c:if>>央企</option>
						<option value="2"<c:if test="${vo.nature_type eq '2' }"> selected</c:if>>省属国企</option>
						<option value="3"<c:if test="${vo.nature_type eq '3' }"> selected</c:if>>市属国企</option>
						<option value="4"<c:if test="${vo.nature_type eq '4' }"> selected</c:if>>县属及以下国企</option>
						<option value="5"<c:if test="${vo.nature_type eq '5' }"> selected</c:if>>民营企业</option>
						<option value="6"<c:if test="${vo.nature_type eq '6' }"> selected</c:if>>事业单位</option>
						<option value="7"<c:if test="${vo.nature_type eq '7' }"> selected</c:if>>外资企业</option>
					</select>
				</div>

				<div class="col-sm-3 col-xs-3" id="debtRatio_isHidden">
					<p>*企业资产负债率（％）</p>
					<input Data-Val="Point Required" title="企业资产负债率（％）" type="text" id="debtRatio" name="debt_ratio" value="${vo.debt_ratio }" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>

				<div class="col-sm-3 col-xs-3" id="creditLevel_isHidden">
					<p>*信用等级</p>
					<input Data-Val="Required" title="信用等级" type="text" id="creditLevel" name="credit_level" value="${vo.credit_level }" class="form-control" placeholder="指企业在银行的信用等级" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<!-- 分块与块字段匹配 -->
				<div class="col-sm-3 col-xs-3">
					<p>*受益人性质</p>
					<select Data-Val="Required" title="受益人性质" class="form-control" name="favoree_type" id="favoreeType" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="">--请选择受益人性质--</option>
						<option value="1"<c:if test="${vo.favoree_type eq '1' }"> selected</c:if>>政府机关</option>
						<option value="2"<c:if test="${vo.favoree_type eq '2' }"> selected</c:if>>国有企业</option>
						<option value="3"<c:if test="${vo.favoree_type eq '3' }"> selected</c:if>>民营企业</option>
						<option value="4"<c:if test="${vo.favoree_type eq '4' }"> selected</c:if>>外资企业</option>
					</select>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->

		</form>
		<div class="row next-step">
			<div class="col-sm-12 col-xs-12 text-right pull-right">
				<p>
					<a href="javascript:void(0);" onclick="saveSPFInfo('1');" id="pendingInfo" dataWait="0" class="save">暂存本页</a>
					<a href="javascript:void(0);" id="next_policy" onclick="save_policy_spf();" class="ns-btn">下一步</a>
				</p>
			</div>
		</div>
	</div><!-- container end -->

<jsp:include page="../../../index/multi_f.jsp" />
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script src="<c:url value='/resources/commonJS/con-common.js'/>" type="text/javascript"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';

var count = 2;
$(function(){
    if($("#need_insur_bill").is(':checked')){
        $("#mod_1").fadeIn(1000);
    }else{
        $("#mod_1").fadeOut(1000);
    }
    if($("#need_receipt").is(':checked')){
        var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        $("#mod_2").fadeIn(1000);
        if(_invoice_val == "0"){//普通发票
            $("#mod_2_1").fadeIn(1000);
        }else{//专用发票,VATINVOICE
            $("#mod_2_1").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_3").fadeIn(1000);
        }
    }else{
        $("#mod_2").fadeOut(1000);
        $("#mod_2_1").fadeOut(1000);
        $("#mod_2_2").fadeOut(1000);
        $("#mod_2_3").fadeOut(1000);
    }

});
function validateForms(o) {
    var thisValue = $("#" + o.id).val();
    if (thisValue != "") {
        if(o.id == "debtRatio"||o.id == "bidding"){
            if(!isNaN(thisValue)){

            }else{
                loser_has_ts(o);
                $(o).val('');
                return;
            }
        }
    }else{
        loser_has_ts(o);
        $(o).val('');
        return;
    }
    success_has(o);
}
function save_policy_spf(){
    if(customsVerify()){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        $.ajax({
            type: 'POST',
            url:baseUrl + '/insurance/build/policy/pendingSpecialPerformance_1VoPolicy',
            data:$("#policyInfoForm").serialize(),
            dataType:"json",
            success: function(json){
                layer.close(index);
                if(json.statusCode == '200') {
                    window.location.href = baseUrl + '/insurance/build/policy/pg_policy/'+json.navTabId+'/2'+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                }else{
                    layer.msg(json.message);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }
}
function customsVerify(){
    var flag = true;
    $("input[Data-Val]").each(function(){
        var dataVal = $(this).attr("Data-Val");
        if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
            if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("必填项不能为空！");
                    $(this).focus();
                    flag = false;
                    return true;
                }else{
                    if($(this).val().length>40){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("长度超出限制！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }
                }

            }
        }
    });
    if(flag){
        $("select[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("必填项不能为空！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }

                }
            }
        });
        if(flag){
            $("textarea[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            layer.msg("必填项不能为空！");
                            $(this).focus();
                            flag = false;
                            return true;
                        }else{
                            if($(this).val().length>100){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("长度超出限制(100字符)！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }
                        }

                    }
                }
            });

        }
    }
    return flag;
}
function saveSPFInfo(page){
    if(isAllNull() == 1){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        $.ajax({
            type: 'POST',
            url:baseUrl + '/insurance/build/policy/pendingSpecialPerformance_'+page+'VoPolicy',
            data:$("#policyInfoForm").serialize(),
            dataType:"json",
            success: function(json){
                layer.close(index);
                layer.msg(json.message);
                if(json.statusCode == '200') {
                    window.location.href = baseUrl + '/insurance/build/policy/pg_policy/'+json.navTabId+'/'+page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
	}else{
        layer.msg("表单未检索到数据，请完善信息后暂存！");
	}
}
function isAllNull(){
    var values, index;
    values = $("#policyInfoForm").serializeArray();
    for (index = 0; index < values.length; ++index){
        var controls=document.getElementsByName(values[index].name);
        for(var i=0;i<controls.length;i++){
            if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
            }
        }
	}
    return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
}
$(function(){
    $("input[id=need_insur_bill]").on("click",function(){
        if($(this).is(':checked')){
            $("#mod_1").fadeIn(1000);
            $("#mod_1").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_1").fadeOut(1000);
            $("#mod_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
                $(this).val('');
            });
        }
    });
    $("input[id=need_receipt]").on("click",function(){
        if($(this).is(':checked')){
            $("#mod_2").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_2_3").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2").fadeOut(1000);
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
        }
    });
    $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
        if($(this).val() == "1"){
            $("#mod_2_1").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_3").fadeIn(1000);
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_2_3").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
        }
    });

    $("#recommend_code").on("blur",function(){
        var rCode = $(this).val();
        var pID = $(this).attr("data-relate");
        if(rCode != '' && pID != ''){
            if( pID != ''){
                $.ajax({
                    type: 'POST',
                    url:baseUrl + '/insurance/build/policy/isFeeByrecommend_codeAndProductID.json',
                    data:{
                        'productID':pID,
                        'recommend_code':rCode
                    },
                    dataType:"json",
                    success: function(json){
                        layer.msg(json.message);
                        if(json.statusCode != '200') {
                            $(this).val('');
                        }
                    },
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                        layer.msg(textStatus);
                    }
                });
            }else{
                layer.msg("数据丢失，请刷新页面重试！");
            }

        }

    });
});
function changeDistrict(districtID, areaID, level, obj) {
    $("#" + districtID).empty();
    if(areaID != '') {
        $("#" + areaID).empty();
        $("#" + areaID).append("<option value=''>--请选择区县--</option>");
    }
    var code = obj.value;
    $.ajax({
        type: 'POST',
        url: baseUrl + '/synopsis/findCity.json',
        data:{"codeLevel":level,"parentCode":code},
        dataType:"json",
        async: false,
        success: function(json) {
            if(level == '2') {
                $("#" + districtID).append("<option value=''>请选择市</option>");
            } else if(level == '3') {
                $("#" + districtID).append("<option value=''>请选择区／县</option>");
            } else {
                $("#" + districtID).append("<option value=''>--请选择--</option>");
            }
            for(var i = 0; i < json.length; i++) {
                var obj = json[i];
                var appendStr = "<option value='" + obj.codes + "' ";
                appendStr = appendStr + ">" + obj.named + "</option>"
                $("#" + districtID).append(appendStr);
            }
        }
    });
}
function clearBase64Byinput(_el){
    var _file_id = _el.id;
    _file_id = _file_id.substring(0,_file_id.length-7);
    if($("#"+_file_id).val() != ''){
        ajaxFormDataDelete(_file_id);
    }
    $("#"+_file_id).val('');
}
function base64convert(_el,_file){
    var flag = false;
    var fileName = _file.name;
    var type = fileName.split(".")[fileName.split(".").length-1];

    var fileKeyName = "/policy/"+fileName;
    var _file_id = _el.attr("name").replace("_file","").trim();
    if($("#"+_file_id).val() != ''){
        ajaxFormDataDelete(_file_id);
    }
    ajaxFormDataLoad(_file,_file_id,"policy/",type);
    flag = true;
    return flag;
}

function ajaxFormDataLoad(file,_id,directoryName,fileType){
    var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
    var _myData = new Date();
    var _times = _myData.getTime();
    var name = "/"+directoryName+_times+"."+fileType;
    var formData = new FormData();
    formData.append('file', file);
    formData.append('fileName', _times+"."+fileType);
    formData.append('directoryName', directoryName);
    var uul = baseUrl + '/file/ajaxFormDataLoad';
    $.ajax({
        type: 'POST',
        url: uul,
        dataType:"json",
        data: formData,
        processData: false,
        contentType: false,
        success: function(result){
            layer.close(index);
            if(result.statusCode == '200'){
                $("#"+_id).val(result.message);
            }else{
                layer.msg(result.message);
            }
        }
    });
}

function ajaxFormDataDelete(_id){
    var formData = new FormData();
    formData.append('url', $("#"+_id).val());
    var uul = baseUrl + '/file/ajaxFormDataDelete';
    $.ajax({
        url: uul,
        type: 'POST',
        cache: false,
        data: formData,
        processData: false,
        contentType: false
    }).done(function(res) {
        $("#"+_id).val('');
    }).fail(function(res) {

    });
}
</script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>