<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<ul class="order-num wed-num">
	<li class="width-s3 ss-width">
		<span>案件号</span>
	</li>
	<li class="width-s3 ss-width">
		<span>保单号</span>
	</li>
	<li class="width-s3">
		<span>出险时间</span>
	</li>
	<li class="width-s3">
		<span>理赔金额（元）</span>
	</li>
	<li class="width-s3">
		<span>案件状态</span>
	</li>
	<li class="width-s3">
		<span>结案时间</span>
	</li>
	<li class="width-s3">
		<span>报案时间</span>
	</li>
	<li class="width-s3">
		<span>操作</span>
	</li>
</ul>
<ul class="tab-body">
	<c:choose>
		<c:when test="${empty reportList }">
			<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
				暂无记录！！
			</li>
		</c:when>
		<c:otherwise>
			<c:forEach items="${reportList }" var="report">
				<li class="clearfix">
					<div class="no-cont ss-width">
						<span>${empty report.report_no ? '-' : report.report_no }</span>
					</div>
					<div class="no-cont ss-width">
						<span>${report.policy_no }</span>
					</div>
					<div class="no-cont">
						<span class="ss-line">${empty report.accident_date ? '-' : report.accident_date }</span>
					</div>
					<div class="no-cont">
						<span>${empty report.check_loss_sum ? '-' : report.check_loss_sum }</span>
					</div>
					<div class="no-cont">
						<span>${fns:getDictLabel (report.status,"reportStatus","")}</span>
					</div>
					<div class="no-cont">
						<span class="ss-line">${empty report.end_case_date ? '-' : report.end_case_date }</span>
					</div>
					<div class="no-cont">
						<span class="ss-line">${empty report.report_date ? '-' : report.report_date }</span>
					</div>
					<div class="no-cont">
						<c:choose>
							<c:when test="${report.status eq '0' }">
								<a href="<c:url value='/pc/report/continueReport/${report.ins_common_report_id }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="a-progress">继续填写</a>
								<a href="javascript:;" onclick="deleteReport('${report.ins_common_report_id }');" class="pro-delete">删除</a>
							</c:when>
							<c:otherwise>
								<a href="<c:url value='/pc/report/getInsCommonReportByReportId/${report.ins_common_report_id }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="a-progress">详情</a>
							</c:otherwise>
						</c:choose>
					</div>
				</li>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</ul>
<script>
    $('.no-cont .po-details').click(function () {
        $('.details-popover').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
        var s = $('.popo-tbody').height();
        if(s <= 400){

            $('.details-popover .popo-content').css({"overflow":"hidden"})
        }
    });
    /*$('.no-cont .progress').click(function () {
        $('.payment-voucher').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
    });*/
    $('.con-s2 .tab-content .tab-body .no-cont:first-child span').each(function () {
        var s_length = $(this).text().length;
        if(s_length > 12){
            $(this).css({"line-height":"24px","margin-top":"25px"});
        }
    });
    $('.con-s2 .tab-content .tab-body .no-cont:nth-child(2) span').each(function () {
        var s_length = $(this).text().length;
        if(s_length > 8){
            $(this).css({"line-height":"24px","margin-top":"25px"});
        }
    });
</script>