<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<div class="correcting-content">
	<c:if test="${iprVo.revise_status eq '3'}">
		<h2>部份被保险人信息不通过，请删除信息有问题的被保险人并再次提交。删除的被保险人在确认信息后，可用新的批改单再次提交。</h2>
	</c:if>
	<input type="hidden" name="recordId" id="recordId" value="${iprVo.oid }">
	<div class="correcting-text">
		<ul class="clearfix">
			<li>
				<p>保单号: <span>${iprVo.external_reference }</span></p>
				<p>暂批改单号: <span>${iprVo.revise_serial_number }</span></p>
			</li>
			<li>
				<p>保全费用: <span>${empty iprVo.total_premium ? '-' : iprVo.total_premium }${empty iprVo.total_premium ? '' : '元' }</span></p>
				<p>批改类型: <span>${fns:getDictLabel (iprVo.revise_type,"revise_type","")}</span></p>
			</li>
			<li>
				<p>提交时间: <span>${iprVo.start_time }</span></p>
				<p>生效时间: <span>${iprVo.inception_date }</span></p>
			</li>
		</ul>
		<c:if test="${iprVo.revise_status eq '4' || iprVo.revise_status eq '5'}">
			<ul class="clearfix" style="float: right;">
				<li style="width: 200px;">
					<p style="text-align: right;margin: inherit"><a href="/api/preservation/down_preservation_detail/${iprVo.oid }">导出人员清单</a></p>
				</li>
			</ul>
		</c:if>
		<c:if test="${iprVo.revise_status eq '3' && fn:contains(orderVo.product_code,'GZZRX-CA')}">
			<p style="margin-bottom: 0px;color: red">失败原因：${iprVo.remark }</p>
		</c:if>
	</div>
	<div class="correcting-tab">
		<div class="correcting-tab-head">
			<ul class="clearfix">
				<li style="width: 13%">姓名</li>
				<li style="width: 13%">证件类型</li>
				<li style="width: 24%;">证件号</li>
				<li style="width: 14%;">手机号</li>
				<li style="width: 9%;">工种</li>
				<%--<li style="width: 9%;">方案</li>--%>
				<li style="width: 7%;">性别</li>
				<li style="width: 13%;">生日</li>
				<li style="width: 7%;">操作</li>
			</ul>
		</div>
		<div class="correcting-tab-body">
			<ul id="correcting-tab-wed">
				<c:choose>
					<c:when test="${empty detailList }">
						<li style="float: none">
							<p style="text-align: center">暂无记录！！</p>
						</li>
					</c:when>
					<c:otherwise>
						<c:forEach items="${detailList }" var="ipdVo">
							<li class="clearfix${ipdVo.status eq '1' ? ' pp-error' : ''}">
								<div class="correcting-sd correcting-s1">
									<span>${empty ipdVo.name ? '-' : ipdVo.name}</span>
								</div>
								<div class="correcting-sd correcting-s1">
									<span>
										<c:if test="${empty ipdVo.id_type}">-</c:if>
										${fns:getDictLabel (ipdVo.id_type,"idType","")}
									</span>
								</div>
								<div class="correcting-sd correcting-s2">
									<span>${empty ipdVo.id_card ? '-' : ipdVo.id_card}</span>
								</div>
								<div class="correcting-sd correcting-s3">
									<span>${empty ipdVo.tel ? '-' : ipdVo.tel}</span>
								</div>
								<div class="correcting-sd correcting-s4">
									<span>
										${ipdVo.career eq '1' ? '内勤人员' : ipdVo.career eq '2' ? '保安人员' : ipdVo.career eq '3' ? '武装押运人员' : ipdVo.career eq '4' ? '保洁人员' : '-'}
									</span>
								</div>
								<%--<div class="correcting-sd correcting-s4">
									<span>${empty ipdVo.scheme ? '-' : ipdVo.scheme}</span>
								</div>--%>
								<div class="correcting-sd correcting-s5">
									<span>${empty ipdVo.sex ? '-' : ipdVo.sex eq '1' ? '男' : '女'}</span>
								</div>
								<div class="correcting-sd correcting-s6">
									<span>${empty ipdVo.birthday ? '-' : ipdVo.birthday}</span>
								</div>
								<div class="correcting-sd correcting-s7">
									<c:if test="${iprVo.revise_status eq '3'&&ipdVo.status eq '1'}"><span onclick="deleteRecordDetail('${ipdVo.oid}','${iprVo.oid}');">删除</span></c:if>
									<c:if test="${iprVo.revise_status != '1' && ipdVo.status != '1'}"><span>-</span></c:if>
								</div>
								<!--如果有错误-->
								<c:if test="${ipdVo.status eq '1'}">
								<div class="correcting-error">
									<p>${ipdVo.remark}</p>
								</div>
								</c:if>
							</li>
						</c:forEach>
					</c:otherwise>
				</c:choose>
			</ul>
		</div>
	</div>
</div>
<div class="correcting-foot">
	<span class="correcting-close">关闭</span>
	<%--<c:if test="${iprVo.revise_status eq '3' && not empty detailList}">
		<span class="correcting-commit" onclick="againRecord()">再次提交</span>
	</c:if>--%>
</div>

<script type="text/javascript">
    $(function(){
        $('ul#correcting-tab-wed li').each(function () {
            if($(this).hasClass('pp-error')){
                $(this).css('padding-bottom','36px');
            }
        });
	});
    $('.correcting-foot .correcting-close').click(function () {
        $('.correcting-details').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
        $('.black-mask').hide();
    });
</script>
