<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<div class="query-result w-99-auto" style="width: 1600px;">
	<table class="table">
		<thead>
			<tr> 
			  <th>保单号</th>
			  <th>保险公司</th>
			  <th>保险产品</th>
			  <th>投保人</th>
			  <th>账单状态</th>
			  <th>批改单量</th>
			  <th>增员</th>
			  <th>减员</th>
			  <th>替换</th>
			  <th>预缴金额</th>
			  <th>实缴金额</th>
			  <th>结算开始时间</th>
			  <th>结算结束时间</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
		<c:when test="${empty payList }">
			<td colspan="14" class="text-center">暂无记录！</td>
		</c:when>
		<c:otherwise>
		<c:forEach items="${payList }" var="pay">
			<tr>
				<td>${pay.external_reference }</td>
				<td>${pay.company_name }</td>
				<td>${pay.insurance_name }</td>
				<td>${pay.app_role_name }</td>
				<td>${fns:getDictLabel(pay.pay_status,"payStatus","")}</td>
				<td><a href="javascript:;" onclick="openPayDetail('${pay.oid }');" class="po-details">${pay.record_count }</a></td>
				<td>${pay.add_count }</td>
				<td>${pay.minus_count }</td>
				<td>${pay.replace_count }</td>
				<td>${pay.predict_total_amount }</td>
				<td>${pay.fact_total_amount }</td>
				<td>${pay.star_pay_time }</td>
				<td>${pay.end_pay_time }</td>
			</tr>
		</c:forEach>
		</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>