<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-我的账户</title>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
	<link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/laydate.css' />">
	<link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/animate.min.css' />">
	<link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/applicant.css' />">
	<style>
		.query-result table tbody tr td{
			vertical-align:inherit;
		}
	</style>
</head>

<body style="position: relative;min-width: 900px">
<%--<div class="container">--%>
	<div class="tab-query tab-order my-order" style="margin: 10px">
		<div class="tab-con" id="tab-con">
			<div class="sdf">
				<div class="con-srt con-s2" style="display: block;">
					<div class="s-head clearfix">
						<div class="head-input fl">
							<span>关键字</span>
							<input type="text" id="keyword_it" value="${keyword}" placeholder="请填写账单号/投保人/保单号/保全单数">
						</div>
						<div class="head-time fl">
							<span>账单时间</span>
							<input type="text" value="${start_time}" id="start-s2">
							<span class="sdf">至</span>
							<input type="text" value="${end_time}" id="end-s2">
						</div>
						<div class="head-status fl">
							<span>状态</span>
							<div class="status fr">
								<p id="status-xuan-s2" data-status="${pay_status }" style="margin:0">
									<c:if test="${empty pay_status}">请选择</c:if>
									<c:if test="${pay_status eq '1'}">待支付</c:if>
									<c:if test="${pay_status eq '5'}">支付中</c:if>
									<c:if test="${pay_status eq '3'}">已支付</c:if>
								</p>
								<ul class="status-select" id="drag-s2" style="z-index: 1;">
									<li<c:if test="${empty pay_status}"> class="active"</c:if> data-status="">请选择</li>
									<li<c:if test="${pay_status eq '1'}"> class="active"</c:if> data-status="1">待支付</li>
									<li<c:if test="${pay_status eq '5'}"> class="active"</c:if> data-status="5">支付中</li>
									<li<c:if test="${pay_status eq '3'}"> class="active"</c:if> data-status="3">已支付</li>
								</ul>
							</div>
						</div>
						<div class="head-button fr" onclick="searchList()">
							<p>搜索</p>
						</div>
					</div>
                    <div class="s-head clearfix" style="margin-top: 10px;">
                        <button type="button" class="btn btn-warning" onclick="exportExcel()" style="width: 70px;height: 30px;">
                            <i class="glyphicon glyphicon-upload"></i><span> 导出</span>
                        </button>
						<c:if test="${isPart eq '0' && insPreservationPayVo.pay_status != 3}">
                        <button type="button" class="btn btn-warning" onclick="uploadSubmit()" style="width: 70px;height: 30px;">
                            <i class="glyphicon glyphicon-download"></i><span> 导入</span>
                        </button>
                        <button type="button" class="btn btn-warning" onclick="createPartBill()" style="height: 30px;">
                            <span>生成部分账单</span>
                        </button>
						</c:if>
                    </div>
					<div class="tab-content" id="preservationPaysArea" style="margin-top: 10px;overflow: auto;">
						<div class="query-result w-99-auto" style="width: 1600px;">
							<table class="table">
								<thead>
								<tr>
									<th></th>
									<th>保单号</th>
									<th>保险公司</th>
									<th>保险产品</th>
									<th>投保人</th>
									<th>账单状态</th>
									<th>批改单量</th>
									<th>增员</th>
									<th>减员</th>
									<th>替换</th>
									<th>预缴金额</th>
									<th>实缴金额</th>
									<th>结算开始时间</th>
									<th>结算结束时间</th>
								</tr>
								</thead>
								<tbody>
								<c:choose>
									<c:when test="${empty payList }">
										<td colspan="14" class="text-center">暂无记录！</td>
									</c:when>
									<c:otherwise>
										<c:forEach items="${payList }" var="pay">
											<tr>
												<td><c:if test="${pay.is_part eq '0' && pay.pay_status != 3}"><input type="checkbox" name="billId" value="${pay.oid }"></c:if></td>
												<td>${pay.external_reference }</td>
												<td>${pay.company_name }</td>
												<td>${pay.insurance_name }</td>
												<td>${pay.app_role_name }</td>
												<td>${fns:getDictLabel(pay.pay_status,"payStatus","")}</td>
												<td><a href="javascript:;" onclick="openPayDetail('${pay.oid }');" class="po-details">${pay.record_count }</a></td>
												<td>${pay.add_count }</td>
												<td>${pay.minus_count }</td>
												<td>${pay.replace_count }</td>
												<td>${pay.predict_total_amount }</td>
												<td>${pay.fact_total_amount }</td>
												<td>${pay.star_pay_time }</td>
												<td>${pay.end_pay_time }</td>
											</tr>
										</c:forEach>
									</c:otherwise>
								</c:choose>
								</tbody>
							</table>
						</div>
					</div>
					<!--分页-->
					<ul class="paper-num" style="padding: 0;padding-top: 20px;">
						<div class="filter-pagination">
							<div id="callBackPager"></div>
						</div>
					</ul>
				</div>
			</div>
		</div>
	</div>

	<div class="clearfix"></div>
	<form id="preservationPayForm" action="<c:url value='/api/preservation/pay/billList?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post">
		<input type="hidden" id="start_time" name="start_time" value="${start_time }"/>
		<input type="hidden" id="end_time" name="end_time" value="${end_time }"/>
		<input type="hidden" id="keyword" name="keyword" value="${keyword }"/>
		<input type="hidden" id="parentPayId" name="parentPayId" value="${parentPayId }"/>
		<input type="hidden" id="pay_status" name="pay_status" value="${pay_status }"/>
		<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
		<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
		<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	</form>
<%--</div>--%>


<!--人员变更提示弹窗-->
<div class="personnel-changes animated" style="position: absolute!important;">
	<div class="payment-head">
		<span>提示</span>
		<a href="javascript:;" id="personnel-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<div class="personnel-cont">
		<p>
			如有企业人员变动（如，员工离职、新员工入职等）<br/>
			可在“我的订单”中查询对应的保险，<br/>
			点击“保全”进入保单中的人员增减操作！
		</p>
	</div>
	<div class="personnel-butt">
		<span class="personnel-bibi">关闭</span>
		<span class="personnel-wed" onclick="openPolicy()">进入“我的订单”</span><%--<c:url value='/pc/order/myOrder'/>--%>
	</div>
</div>

<!--详情弹窗-->
<div class="details-popover animated" style="position: absolute!important;">
	<div class="popover-cont">
		<div class="popo-head">
			<span>保全列表</span>
			<a href="javascript:;" id="popo-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="loadRecordDetail">

		</div>
	</div>
</div>

<!--黑色蒙版-->
<div class="black-mask"></div>
<!--黑色蒙版2-->
<div class="black-mask-more"></div>
<script type="text/javascript" src="<c:url value='/resources/script/jquery-1.10.2.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/idangerous.swiper2.7.6.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.nav.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/clipboard.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/layer/layer.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>

<script src="<c:url value='/resources/versions-2.0.2/js/jquery.zoom.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>
<script src="<c:url value='/resources/versions-2.0.2/js/corrections.js?1' />"></script>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    $(function () {
        function mouse(even, stat, iconA, iconB) {
            $('.order-detail').on(even, '.guar', function () {
                $(this).siblings('.guar-list').css('display',stat);
                $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
            });
        }
        //鼠标移动到元素上显示
        mouse('mouseenter', 'block', 'down-icon', 'up-icon');
        //鼠标移出元素
        mouse('mouseleave', 'none', 'up-icon', 'down-icon');
    })
    var totalCount = Number($('#totalCount').val()) || 0;
    var showCount = $('#showCount').val() || 5;
    var limit = Number($('#numPerPage').val()) || 5;

    $('#callBackPager').extendPagination({
        totalCount: totalCount,
        showCount: showCount,
        limit: limit,
        callback: function (curr, limit, totalCount) {
            getListForPage("preservationPayForm","preservationPaysArea");
        }
    });
    function uploadPay(_id){
        // $("#payId").val(_id);
		payUploadShow();
    }
	function getFP(_id){
		$.ajax({
			type: 'POST',
			url:baseUrl + '/api/preservation/pay/getFP/'+_id,
			dataType:"json",
			async:false,
			success: function(json){
				if(json.retType == '0') {//支付成功
					window.open(json.data);
				}else{
					layer.msg(json.msg);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.msg(textStatus);
			}
		});
	}

    function loadCanvas(_img){
        clearCanvas();
        var c=document.getElementById("cvs");
        var cxt=c.getContext("2d");
        var img=new Image()
        img.src=baseUrl + _img;
        img.onload = function () //确保图片已经加载完毕
        {
            cxt.drawImage(img, 0, 0, 440, 260);
        }
        payUploadShow();
    }
    function payUploadShow () {
        $('.payment-voucher').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
    }

    function clearCanvas(){
        var c=document.getElementById("cvs");
        var cxt=c.getContext("2d");
        cxt.clearRect(0,0,c.width,c.height);
    }

    function uploadFilePay(_form){
        if($("#upload").val() == ''){
            return false;
        }
        var index = layer.load(0, {shade: [0.3,'#808080']});
        var formData = new FormData(document.forms.namedItem(_form));
        $.ajax({
            type: 'POST',
            url:baseUrl + '/api/preservation/pay/uploadFilePay',
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(json){
                layer.msg(json.message);
                $('.payment-voucher').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                $('.black-mask').hide();
                clearCanvas();
                getListForPage("preservationPayForm","preservationPaysArea");
                layer.close(index);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }

    function openPayDetail(_id){
		layer.open({
			type: 2,
			area: ['900px', '500px'],
			title: "保全列表",
			skin:'lay-bak',
			closeBtn: 1,
			shadeClose: false,
			scrollbar: false,
			shade:0.4,
			fix: false,
			content: baseUrl + '/api/preservation/pay/getInsPreservationPayByPayId/'+_id+'?ACCESS_TOKEN=${ACCESS_TOKEN}'
		});
        /*$.ajax({
            type : 'POST',
            url : baseUrl + "/pc/preservation/pay/getInsPreservationPayByPayId/"+_id,
            dataType : "html",
            success : function(data) {
                $("#loadRecordDetail").html(data);
            },
            error: function(){
            }
        });*/
    }

    function searchList(){
        $("#start_time").val($("#start-s2").val());
        $("#end_time").val($("#end-s2").val());
        $("#keyword").val($("#keyword_it").val());
        $("#pageNum").val(1);
        $("#numPerPage").val(5);
        $("#totalCount").val(0);
        $("#pay_status").val($('.con-s2 #status-xuan-s2').attr('data-status'));
        // $("#preservationPayForm").submit();
		getListForPage("preservationPayForm","preservationPaysArea");
    }
    function exportExcel(){
        var start_time = $("#start-s2").val();
        var end_time = $("#end-s2").val();
        var keyword = $("#keyword_it").val();
        var parentPayId = $("#parentPayId").val();
        var pay_status = $('.con-s2 #status-xuan-s2').attr('data-status');

        var index = layer.confirm('该操作将根据搜索条件导出数据，是否继续？',{btn: ['导出','取消']}, function(){
            location.href=baseUrl + '/api/preservation/pay/downChildBillPay?keyword='+keyword+'&parentPayId='+parentPayId+'&pay_status='+pay_status+'&start_time='+start_time+'&end_time='+end_time;
            layer.close(layer.index);
        });
    }
    function createPartBill(){
        var checkboxes = document.querySelectorAll('input[name="billId"]:checked'),
            values = [];

        checkboxes.forEach((checkbox) => {
            values.push(checkbox.value);
        });
        if(values.length == 0){
            layer.msg('请勾选账单');
            return false;
        }
        var index = layer.confirm('是否根据已勾选记录生成部分账单汇总？',{btn: ['生成','取消']}, function(){
            $.ajax({
                type:'POST',
                dataType:'json',
                url:baseUrl + '/api/preservation/pay/createPartBill',
                data:{'isSummaryBill':'0','payIds':values.join(',')},
                success:function(result){
                    layer.close(index);
                    if(result.status=='200'){
                        layer.msg(result.msg,{icon:1,time:1000});
                    }else{
                        layer.alert(result.msg, {icon: 2});
                    }
                }
            })
        });
    }

    function uploadSubmit(){
        var str = "<div style='width: 300px;'>" +
            "<p style='padding-bottom: 5px;'><textarea class=\"form-control\" rows=6 id=\"pdNo\" placeholder=\"请输入保单号（多个“,”隔开）\" style=\"width: 100%\"></textarea></p>" +
            "</div>";
        var index = layer.confirm(str,{btn: ['提交','取消'], title: "生成部分账单"}, function(){
            var pdNo = $('#pdNo').val();
            if(pdNo == undefined){
                layer.msg("请输入保单号！", {icon: 2, time: 2000});
                return;
            }
            pdNo = pdNo.replace('，',',').replace(' ','');
            $.ajax({
                type:'POST',
                dataType:'json',
                url:baseUrl + '/api/preservation/pay/createPartBillByNo',
                data:{'isSummaryBill':'0','payNos':pdNo},
                success:function(result){
                    if(result.status=='200'){
                        layer.msg(result.msg,{icon:1,time:1000});
                        layer.close(index);
                    }else{
                        layer.alert(result.msg, {icon: 2});
                    }
                }
            })
        });
    }

    function loadDataAndPage(){
        totalCount = Number($('#totalCount').val()) || 0;
        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("preservationPayForm","preservationPaysArea");
            }
        });
    };


    function getListForPage(formId,contentId){
        var index = layer.load(0, {shade: [0.3,'#808080']});
        $.ajax({
            type : 'POST',
            url : baseUrl + "/api/preservation/pay/getBillListForPage",
            data : $("#"+formId).serialize(),
            dataType : "text",
            success : function(data) {
                layer.close(index);
                $("#"+contentId).html(data);
            },
            error: function(){
                layer.close(index);
            }
        });
    }

    function choisePolicyStatus(policyStatus,totalCount,obj){
        $(".order-list li").removeClass("active");
        $(obj).addClass("active");
        $("#policyStatus").val(policyStatus);
        $('#totalCount').val(totalCount);
        $('#pageNum').val("1");
        loadDataAndPage();
        getListForPage("preservationPayForm","preservationPaysArea");
    }

    function deletePreservationRecord(preservationId){
        layer.confirm('确定删除此订单？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/api/preservation/deleteInsPreservationRecord",
                data : {
                    "oid":preservationId,
                },
                dataType : "json",
                success : function(data) {
                    layer.close(index);
                    layer.msg(data.message);
                    if(data.status =="200"){
                        getListForPage("preservationPayForm","preservationPaysArea");
                    }
                },
                error: function(){
                    layer.close(index);
                }
            });
        });
    }

    function refreshTotal(){
        var total = Number($("#"+id).html());
        var totalCount = total -1;
        var numPerPage = Number($('#numPerPage').val());
        var pageNum = Number($("#pageNum").val());
        if(totalCount%numPerPage ==0)
            pageNum = pageNum -1;

        $("#"+id).html(totalCount);
        $('#totalCount').val(totalCount);
        $('#pageNum').val(pageNum);
        loadDataAndPage();

        $("#callBackPager li").each(function(){
            $(this).removeClass('active');
            if ($(this).find('a').html() == pageNum) {
                $(this).addClass('active');
            }
        });

        getListForPage("preservationPayForm","preservationPaysArea");
    }
</script>
</body>
</html>

<script>
    $('ul.aside-list li').removeClass('on');
    $("#myPreservation").addClass('on');
</script>