<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html>
<head>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
	<link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/applicant.css' />">

	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>我的账户</title>
</head>

<body>

<div class="container">
	<ul class="order-list">
		<li ${ policyStatus eq '25'?'class="active"':'' } onclick="choisePolicyStatus('25','${empty policyTotals['ALL'] ? '0' : policyTotals['ALL'] }',this);">全部订单（${empty policyTotals['ALL'] ? '0' : policyTotals['ALL'] }）</li>
		<li ${ policyStatus eq '1'?'class="active"':'' } onclick="choisePolicyStatus('1','${empty policyTotals['INSSUM'] ? '0' : policyTotals['INSSUM'] }',this);">投保中（${empty policyTotals['INSSUM'] ? '0' : policyTotals['INSSUM'] }）</li>
		<li ${ policyStatus eq '2'?'class="active"':'' } onclick="choisePolicyStatus('2','${empty policyTotals['AUDITSUM'] ? '0' : policyTotals['AUDITSUM'] }',this);">待核保（${empty policyTotals['AUDITSUM'] ? '0' : policyTotals['AUDITSUM'] }）</li>
		<li ${ policyStatus eq '22'?'class="active"':'' } onclick="choisePolicyStatus('22','${empty policyTotals['NOPAYSUM'] ? '0' : policyTotals['NOPAYSUM'] }',this);">待支付（${empty policyTotals['NOPAYSUM'] ? '0' : policyTotals['NOPAYSUM'] }）</li>
		<li ${ policyStatus eq '5'?'class="active"':'' } onclick="choisePolicyStatus('5','${empty policyTotals['TOBEINSURED'] ? '0' : policyTotals['TOBEINSURED'] }',this);">待承保（${empty policyTotals['TOBEINSURED'] ? '0' : policyTotals['TOBEINSURED'] }）</li>
		<li ${ policyStatus eq '23'?'class="active"':'' } onclick="choisePolicyStatus('23','${empty policyTotals['DOPAY'] ? '0' : policyTotals['DOPAY'] }',this);">已购买（${empty policyTotals['DOPAY'] ? '0' : policyTotals['DOPAY'] }）</li>
		<li ${ policyStatus eq '21'?'class="active"':'' } onclick="choisePolicyStatus('21','${empty policyTotals['UNDERWRITESUM'] ? '0' : policyTotals['UNDERWRITESUM'] }',this);">保障中（${empty policyTotals['UNDERWRITESUM'] ? '0' : policyTotals['UNDERWRITESUM'] }）</li>
		<li ${ policyStatus eq '24'?'class="active"':'' } onclick="choisePolicyStatus('24','${empty policyTotals['TORENEW'] ? '0' : policyTotals['TORENEW'] }',this);">已失效（${empty policyTotals['TORENEW'] ? '0' : policyTotals['TORENEW'] }）</li>
	</ul>
	<div class="tab-query tab-order my-order wed-ert">
		<div id="policysArea">
			<ul class="tab-title">
				<li class="wid-220">基本信息</li>
				<li>被保险人</li>
				<li>保障时间</li>
				<li>份数</li>
				<li>保费（元）</li>
				<li>状态</li>
				<li>操作</li>
			</ul>
			<div class="tab-content">
				<c:choose>
					<c:when test="${empty orderList }">
						<div class="order-detail">
							<ul class="order-num">
								<li style="float: none">
									<p style="text-align: center">暂无订单！！</p>
								</li>
							</ul>
						</div>
					</c:when>
					<c:otherwise>
						<c:forEach items="${orderList }" var="policy">
							<div class="order-detail">
								<ul class="order-num">
									<li>
										<span  class="num-name">订单号：</span>
										<span>${policy.trade_serial_number}</span>
									</li>
									<li>
										<c:choose>
											<c:when test="${empty policy.external_reference && not empty policy.policy_serial_number}">
												<span  class="num-name">投保单号：</span>
												<span>${policy.policy_serial_number}</span>
											</c:when>
											<c:otherwise>
												<span  class="num-name">保单号：</span>
												<span>${policy.external_reference}</span>
											</c:otherwise>
										</c:choose>
									</li>
									<li class="order-time">
										创建时间：${policy.start_time}
									</li>
								</ul>
								<ul class="tab-body">
									<li class="wid-220 two">
										<c:if test="${fn:contains(policy.product_code, 'TYX')}">
											<a href="<c:url value='/api/gmr/product/productInfo/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insu">${policy.product_name }</a>
										</c:if>
										<c:if test="${fn:contains(policy.product_code, 'GZZRX')}">
											<a href="<c:url value='/insurance/gzzrx/product/productInfo/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insu">${policy.product_name }</a>
										</c:if>
										<c:if test="${fn:contains(policy.product_code, 'GZX-HT')}">
											<a href="<c:url value='/api/afr/productInit/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insu">${policy.product_name }</a>
										</c:if>
										<c:if test="${fn:contains(policy.product_code, 'GZX-PAC')}">
											<a href="<c:url value='/insurance/gzx/product/productInfo/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insu">${policy.product_name }</a>
										</c:if>
									</li>
									<li>
										<span>
											<c:choose>
												<c:when test="${fn:contains(policy.product_code, 'TYX')||fn:contains(policy.product_code, 'GZZRX') }">
													团体
												</c:when>
												<c:otherwise>
													${policy.insured_role}
												</c:otherwise>
											</c:choose>
										</span>
									</li>
									<li class="three">
										<div class="qoi">${policy.inception_date}</div>
										<div>至</div>
										<div>${policy.planned_end_date}</div>
									</li>
									<li>
										<span>
											1份
										</span>
									</li>
									<li>
										<span>
											￥${policy.gross_premium}
										</span>
									</li>
									<li class="pay">
										<span>
												${fns:getDictLabel (policy.policy_status,"order_status","")}
										</span>
									</li>
									<li class="pay-delete">
										<c:if test="${policy.policy_status != '1' }">
											<a href="<c:url value='/api/order/orderDetailByOrderID/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">查看${ empty policy.external_reference ? '投保单':'保单'}</a>
										</c:if>
										<c:if test="${policy.policy_status eq '1' }">
											<c:if test="${fn:contains(policy.product_code, 'TYX') }">
												<a href="<c:url value='/api/gmr/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a>
											</c:if>
											<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a href="<c:url value='/api/gzx/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
											<c:if test="${fn:contains(policy.product_code, 'ZZX-HT') }"><a href="<c:url value='/api/lote/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
											<c:if test="${fn:contains(policy.product_code, 'GZX-PAC') }"><a href="<c:url value='/api/gzx/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
											<c:if test="${fn:contains(policy.product_code, 'GZZRX') }"><a href="<c:url value='/api/gzzrx/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
										</c:if>
										<c:if test="${policy.policy_status eq '3'}">
											<c:choose>
												<c:when test="${fn:contains(policy.product_code, 'TYX-PAC') }">
													<a href="<c:url value='/api/gmr/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
												</c:when>
												<c:when test="${fn:contains(policy.product_code, 'GZZRX-ZH') }">
													<a href="<c:url value='/api/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
												</c:when>
												<c:when test="${fn:contains(policy.product_code, 'TYX-CA') }">
													<a href="<c:url value='/api/gmr/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
												</c:when>
												<c:when test="${fn:contains(policy.product_code, 'GZZRX-CA') }">
													<a href="<c:url value='/insurance/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
												</c:when>
												<c:otherwise>
													<a target="_blank" href="<c:url value='/insurance/customs/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">确认报价</a>
												</c:otherwise>
											</c:choose>
										</c:if>
										<c:if test="${policy.policy_status eq '4'}">
											<c:if test="${fn:contains(policy.product_code, 'TYX') }">
												<a href="<c:url value='/api/gmr/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a>
											</c:if>
											<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a href="<c:url value='/api/gzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a></c:if>
											<c:if test="${fn:contains(policy.product_code, 'ZZX-HT') }"><a href="<c:url value='/api/lote/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a></c:if>
											<c:if test="${fn:contains(policy.product_code, 'GZX-PAC') }"><a href="<c:url value='/api/gzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a></c:if>
											<c:if test="${fn:contains(policy.product_code, 'GZZRX') }"><a href="<c:url value='/api/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a></c:if>
										</c:if>
										<c:if test="${policy.policy_status eq '6' && (fn:contains(policy.product_code, 'TYX') || fn:contains(policy.product_code, 'GZZRX')) }">
											<a href="<c:url value='/api/preservation/resultSet/resultSetList?policyId=${policy.oid }&ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">保全</a>
										</c:if>
										<c:if test="${policy.policy_status eq '6' && fn:contains(policy.product_code, 'TYX-PAC') }">
											<a href="https://icore-cmss.pingan.com.cn/html/visitor/AHI/index.html#/applyTips?systemPageSource=thirdParty" class="again-pay">理赔申请</a>
										</c:if>
										<c:if test="${policy.policy_status eq '6' && (fn:contains(policy.product_code, 'GZZRX-PAC')||fn:contains(policy.product_code, 'GZZRX-ZH')||fn:contains(policy.product_code, 'GZZRX-CA')||fn:contains(policy.product_code, 'TYX-CA')) }">
											<a href="<c:url value='/api/report/reportInit/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">理赔申请</a>
										</c:if>
										<c:if test="${ policy.policy_status eq '16' && fn:contains(policy.product_code, 'GZZRX-PAC')}">
											<a href="<c:url value='/api/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
										</c:if>
										<c:if test="${policy.policy_status eq '3' || policy.policy_status eq '4' }">
											<div class="again-pay" onclick="copyOrder('${policy.oid }');">复制</div>
										</c:if>
										<c:if test="${policy.policy_status eq '1' || policy.policy_status eq '4' }">
											<div class="delete" onclick="deleteOrder('${policy.oid }','${policy.policy_status }');">删除</div>
										</c:if>
									</li>
								</ul>
							</div>
						</c:forEach>
					</c:otherwise>
				</c:choose>
			</div>
		</div>
		<div class="filter-pagination">
			<div id="callBackPager"></div>
		</div>
	</div>		<!--右边部分介绍-->

	<div class="clearfix"></div>
	<form id="orderForm">
		<input type="hidden" id="businessType" name="businessType" value="${businessType }"/>
		<input type="hidden" id="policyStatus" name="policyStatus" value="${policyStatus }"/>
		<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
		<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
		<input type="hidden" name="totalCount" id="totalCount" value="${empty dwzPage.totalCount ? 0 : dwzPage.totalCount}">
	</form>
</div>

</body>
<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script src="<c:url value='/resources/js/extendPagination.js?'/>${fns:getTime()}" type="text/javascript"></script>
<jsp:include page="../../index/multi_init_param.jsp"/>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    $(function () {
        function mouse(even, stat, iconA, iconB) {
            $('.order-detail').on(even, '.guar', function () {
                $(this).siblings('.guar-list').css('display',stat);
                $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
            });
        }
        //鼠标移动到元素上显示
        mouse('mouseenter', 'block', 'down-icon', 'up-icon');
        //鼠标移出元素
        mouse('mouseleave', 'none', 'up-icon', 'down-icon');
    })
    var totalCount = Number($('#totalCount').val()) || 0;
    var showCount = $('#showCount').val() || 5;
    var limit = Number($('#numPerPage').val()) || 5;

    $('#callBackPager').extendPagination({
        totalCount: totalCount,
        showCount: showCount,
        limit: limit,
        callback: function (curr, limit, totalCount) {
            getListForPage("orderForm","policysArea");
        }
    });


    function loadDataAndPage(){
        totalCount = Number($('#totalCount').val()) || 0;
        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("orderForm","policysArea");
            }
        });
    };


    function getListForPage(formId,contentId){
        var index = layer.load(0, {shade: [0.3,'#808080']});
        $.ajax({
            type : 'POST',
            url : baseUrl + "/api/order/getOrderListForPage?ACCESS_TOKEN=${ACCESS_TOKEN}",
            data : $("#"+formId).serialize(),
            dataType : "text",
            success : function(data) {
                layer.close(index);
                $("#"+contentId).html(data);
            },
            error: function(){
                layer.close(index);
            }
        });
    }

    function choisePolicyStatus(policyStatus,totalCount,obj){
        $(".order-list li").removeClass("active");
        $(obj).addClass("active");
        $("#policyStatus").val(policyStatus);
        $('#totalCount').val(totalCount);
        $('#pageNum').val("1");
        loadDataAndPage();
        tabTotal(policyStatus);
        getListForPage("orderForm","policysArea");
    }

    function tabTotal(policyStatus){
        $.ajax({
            type : 'POST',
            url : baseUrl + "/api/order/tabTotal?ACCESS_TOKEN=${ACCESS_TOKEN}",
            data : {
                'policyStatus':policyStatus,
                'businessType':$('#businessType').val()
            },
            dataType : "text",
            success : function(data) {
                $(".order-list").html(data);
            }
        });
    }

	function copyOrder(policyId){
		layer.confirm('确定复制此订单？（注：可以依当前订单复制一份信息一样的“投保中”状态订单，在“投保中”列表第一条可以点击“继续投保”。）', {
			btn: ['确定','取消'] //按钮
		}, function(){
			layer.closeAll();
			if(policyId != ''){
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/api/order/copyOrder?ACCESS_TOKEN=${ACCESS_TOKEN}",
					data : {
						"order_id":policyId,
					},
					dataType : "json",
					success : function(data) {
						layer.close(index);
						layer.msg(data.message);
						if(data.statusCode == '200') {
							tabTotal("1");
							getListForPage("orderForm","policysArea");
						}
					},
					error: function(){
						layer.close(index);
					}
				});
			}
		});
	}

	function deleteOrder(policyId,policyStatus){
        layer.confirm('确定删除此订单？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            if(policyId != ''){
                var index = layer.load(0, {shade: [0.3,'#808080']});
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/api/order/deleteOrder?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : {
                        "order_id":policyId,
                    },
                    dataType : "json",
                    success : function(data) {
                        layer.close(index);
                        layer.msg(data.message);
                        if(data.status =="200"){
                            tabTotal(policyStatus);
//                            refreshTotal(policyStatus);
                            getListForPage("orderForm","policysArea");
                        }
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            }
        });
    }

    function refreshTotal(policyStatus){
        var id="";
        if(policyStatus =="1"){
            id = "INSSUM";
        }else if(policyStatus =="4"){
            id = "NOPAYSUM";
        }

        var total = Number($("#"+id).html());
        var totalCount = total -1;
        var numPerPage = Number($('#numPerPage').val());
        var pageNum = Number($("#pageNum").val());
        if(totalCount%numPerPage ==0)
            pageNum = pageNum -1;

        $("#"+id).html(totalCount);
        $('#totalCount').val(totalCount);
        $('#pageNum').val(pageNum);
        loadDataAndPage();

        $("#callBackPager li").each(function(){
            $(this).removeClass('active');
            if ($(this).find('a').html() == pageNum) {
                $(this).addClass('active');
            }
        });

        getListForPage("orderForm","policysArea");
    }

    window.onload = function(){
        var l_length = $('.pagination').width();
        var l = parseInt((l_length)/2)
        $('.pagination').css({"right":"0"});
    }

    $('ul.order-list li').click(function () {
        var l_length = $('.pagination').width();
        var l = parseInt((l_length)/2)
        $('.pagination').css({"right":"0"});
    })
</script>
</html>
<script>
    $('ul.aside-list li').removeClass('on');
    $("#myOrder").addClass('on');
</script>

