<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
</head>
<body>

<div class="container"><!-- container start -->

    <ol class="breadcrumb" id="bread_crumbs">
        <li>当前位置： </li>
        <li><a href="<c:url value='/api/order/myOrder?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我的订单</a></li>
        <li><a href="<c:url value='/api/gmr/product/productInfo/${pd.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">产品详情</a></li>
        <li class="active">投保</li>
    </ol>
    <div class="nav-list">
        <div class="row w-80-auto">
            <div class="col-sm-3 col-sm-4 active">
                <p><i class="pull-left">1</i><span class=" pull-left">填写保险信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-4">
                <p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-3">
                <p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
            </div>
            <div class="col-sm-3 col-sm-3 pull-right">
                <p><i class="pull-left">4</i><span class="pull-left"> 完成投保</span></p>
            </div>
        </div>
    </div>
    <form class="form-horizontal form-create-item" method="post" id="policyInfoForm">
        <input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
        <input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>推荐人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-4 col-xs-4">
                    <p>推荐人的手机号或编号</p>
                    <input type="text" name="recommend_code" id="recommend_code" data-relate="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
                    <input type="hidden" name="sigId" value="${dto.trade_serial_number}"/>
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[0].oid" id="role_appRoleID_0" value="${vo.roleSubjectList[0].oid}"/>
            <input type="hidden" name="roleSubjectList[0].kind" id="role_kind_0" value="1"/>
            <input type="hidden" name="roleSubjectList[0].roleType" id="role_roleType_0" value="1"/>
            <div class="title-war"><h3>投保单位信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*投保人名称<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称，个人不能作为投保单位"></i></p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].name_cn" id="role_namecn_0" value="请填写与营业执照相一致的单位名称到返回到返回" class="form-control" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>

                <div class="col-sm-3 col-xs-3">
                    <p>*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_type" id="role_idType_0" value="${vo.roleSubjectList[0].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${comTypeList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件号码</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].organization_code" id="role_organizationCode_0" GIST-ID="role_idType_0" value="12345678-9" class="form-control" data-toggle="tooltip" data-placement="top" title="组织机构代码：只能包含数字或英文大写字母，必须用连字符“-”隔开；营业执照：只能为15位数字；税务登记证：只能为15位数字，或20位数字，或19位数字与字母X组合；三证合一统一信用代码：由数字或大写英文字母组成，共18位"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-9 col-xs-9">
                    <p>*注册地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${cityList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${areaList }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="roleSubjectList[0].reg_address" id="role_regAddress_0" value="请填写与营业执照相一致的单位名称" class="form-control" placeholder="请填写详细地址" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人姓名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_name" id="role_linkName_0" value="特工" class="form-control" placeholder="请填写联系人名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人手机</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_tel" id="role_linkTel_0" value="18965192886" class="form-control" placeholder="请填写联系人手机号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人email</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_email" id="role_linkEmail_0" value="384023074@qq.com" class="form-control" placeholder="请填写联系人邮箱" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[1].oid" id="role_oid_1" value="${vo.roleSubjectList[1].oid}"/>
            <input type="hidden" name="roleSubjectList[1].kind" id="role_kind_1" value="2"/>
            <div class="title-war"><h3>被保险人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*被保险人名称</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].name_cn" id="role_namecn_1" value="请填写与营业执照相一致的单位名称" class="form-control" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>

                <div class="col-sm-3 col-xs-3">
                    <p>*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[1].id_type" id="role_idType_1" value="${vo.roleSubjectList[1].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${comTypeList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件号码</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].organization_code" id="role_organizationCode_1" GIST-ID="role_idType_1" value="12345678-9" class="form-control" data-toggle="tooltip" data-placement="top" title="组织机构代码：只能包含数字或英文大写字母，必须用连字符“-”隔开；营业执照：只能为15位数字；税务登记证：只能为15位数字，或20位数字，或19位数字与字母X组合；三证合一统一信用代码：由数字或大写英文字母组成，共18位"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人姓名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_name" id="role_linkName_1" value="干哈" class="form-control" placeholder="请填写联系人名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人手机</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_tel" id="role_linkTel_1" value="18965192886" class="form-control" placeholder="请填写联系人手机号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*详细地址</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].reg_address" id="role_regAddress_1" value="请填写详细地址请填写详细地址请填写详细地址" class="form-control" placeholder="请填写详细地址" />
                    <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="specialExhibitionVo.oid" id="special_oid_0" value="${vo.specialExhibitionVo.oid}"/>
            <div class="title-war"><h3>投保基本信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*展会名称</p>
                    <input Data-Val="Required" type="text" name="specialExhibitionVo.name" id="special_name" value="请填写详细地址请填写详细地址" class="form-control" data-toggle="tooltip" data-placement="top" title="请填写展会活动的具体名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>

                <div class="col-sm-8 col-xs-8">
                    <p>*保障时间</p>
                    <div class="row">
                        <div class="col-sm-4 col-xs-4">
                            <input Data-Val="Date Required" type="text" name="specialExhibitionVo.star_time" id="special_star_time" value="2017-10-25" class="laydate-icon form-control">
                            <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                        </div>
                        <div class="col-sm-4 col-xs-4">
                            <input Data-Val="Date Required" type="text" name="specialExhibitionVo.end_time" id="special_end_time" value="2017-10-30" class="laydate-icon form-control">
                            <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="col-sm-9 col-xs-9">
                    <p>*展会举办地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="specialExhibitionVo.ex_province" id="special_ex_province" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('special_ex_city', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.specialExhibitionVo.ex_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="specialExhibitionVo.ex_city" id="special_ex_city" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('special_ex_county', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${exCityList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.specialExhibitionVo.ex_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="specialExhibitionVo.ex_county" id="special_ex_county" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${exAreaList }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.specialExhibitionVo.ex_county eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="specialExhibitionVo.ex_address" id="special_ex_address" value="请填写详细地址请填写详细地址请填写详细地址" class="form-control" placeholder="请填写详细地址" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*展位号</p>
                    <input Data-Val="Num Required" type="text" name="specialExhibitionVo.ex_no" id="special_ex_no" value="66" class="form-control" placeholder="请填写展会活动的具体名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>


                <div class="col-sm-3 col-xs-3">
                    <p>搭建公司名称</p>
                    <input type="text" name="specialExhibitionVo.build_com_name" id="special_ex_build_com_name" value="法规和符合法规回复" class="form-control" placeholder="请填写主要搭建公司名称，如无可不填" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>转包单位</p>
                    <input type="text" name="specialExhibitionVo.subcontracting_units" id="special_ex_subcontracting_units" value="非结构化价格将根据" class="form-control" placeholder="请填写转包单位名称，如无可不填" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*展位面积（平米）</p>
                    <input Data-Val="Point Required" type="text" name="specialExhibitionVo.ex_acreage" id="special_ex_acreage" value="5" onblur="validateForms(this)" class="form-control" placeholder="请填写整数的展位面积" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*雇员总人数</p>
                    <input Data-Val="Num Required" type="text" name="specialExhibitionVo.ex_emp_num" id="special_ex_emp_num" value="12" onblur="validateForms(this)" class="form-control" placeholder="请填写展位雇员总人数" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-12 col-xs-12" id="sifa_text_1_isHidden">
                    <p>司法管辖</p>
                    <div><span>中华人民共和国司法管辖（港澳台除外）</span></div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-12 col-xs-12">
                    <p>争议处理</p>
                    <div><span>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：</span></div>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span><input type="radio" value="0" name="specialExhibitionVo.dispute" id="dispute_radio1" onclick="checkToradio('dispute_radio1','radio');" <c:if test="${ empty vo.specialExhibitionVo.dispute || vo.specialExhibitionVo.dispute eq '0' }"> checked="checked" </c:if>><label for="dispute_radio1" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio1','radio');">诉讼</strong></span>
                                </div>
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span><input type="radio" value="1" name="specialExhibitionVo.dispute" id="dispute_radio2" onclick="checkToradio('dispute_radio2','radio');"  <c:if test="${vo.specialExhibitionVo.dispute eq '1' }"> checked="checked" </c:if>><label for="dispute_radio2" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio2','radio');">仲裁，仲裁机构</strong></span>
                                </div>
                                <div class="col-sm-3 col-xs-3" <c:if test="${empty vo.specialExhibitionVo.dispute ? true : vo.specialExhibitionVo.dispute eq '0' }"> style="display: none;" </c:if>>
                                    <input type="text" name="specialExhibitionVo.arbitral_institution" id="arbitralInstitution" value="${vo.specialExhibitionVo.arbitral_institution }" class="form-control su-lo">
                                    <span class="glyphicon form-control-feedback pa-27" aria-hidden="true"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>保费</p>
                        <strong class="d-l-36" id="mPremium">${pd.premium_min}.00元</strong>
                        <input type="hidden" name="premium" id="premium" value="${pd.premium_min}"/>
                    </div>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>单证信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3 mt-20">
                    <span class="pull-left check-box">
                        <input type="checkbox" value="1" name="mailPolicyVo.need_insur_bill" id="need_insur_bill" <c:if test="${not empty vo.mailPolicyVo.need_insur_bill && vo.mailPolicyVo.need_insur_bill eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_insur_bill"></label>
                    </span>
                    <span class="pull-left lhml5">需要纸质保单</span>
                </div>
                <div class="clear"></div>
                <div id="mod_1" <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收件人名称</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_name" id="receiverName" value="${ vo.mailPolicyVo.receiver_name}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill ? true : vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收件人手机</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_mobile" id="receiverMobile" value="${ vo.mailPolicyVo.receiver_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-6 col-xs-6">
                        <p>*收件人地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_address_detail" id="receiverAddressDetail" value="${ vo.mailPolicyVo.receiver_address_detail}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                </div>
                <div class="col-sm-3 col-xs-3 mt-20">
                    <span class="pull-left check-box">
                        <input type="checkbox" name="mailPolicyVo.need_receipt" value="1" id="need_receipt" <c:if test="${not empty vo.mailPolicyVo.need_receipt && vo.mailPolicyVo.need_receipt eq '1'}"> checked="checked"</c:if> />
                        <label for="need_receipt"></label>
                        <%--<input type="hidden" name="mailPolicyVo.need_receipt" value="${vo.mailPolicyVo.need_receipt}" />--%>
                    </span>
                    <span class="pull-left lhml5">需要纸质发票</span>
                </div>
                <div class="clear"></div>
                <div id="mod_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-12 col-xs-12">
                        <p>发票种类</p>
                        <div class="row">
                            <div class="col-sm-12 col-xs-12">
                                <div class="row">
                                    <div class="col-sm-3 col-xs-3 rad-io">
                                        <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_1" value="0" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> checked="checked"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> checked="checked"</c:if>><label for="invoice_type_1" class="pull-left"></label><strong  class="pull-left">增值税普通发票（电子发票）</strong></span>
                                    </div>
                                    <div class="col-sm-3 col-xs-3 rad-io">
                                        <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_2" value="1" <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1' }"> checked="checked"</c:if>><label for="invoice_type_2" class="pull-left"></label><strong  class="pull-left">增值税专用发票（纸质发票）</strong></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12 reminder" id="mod_2_1" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
                    <label>温馨提示：请认真填写下述信息，确保信息真实准确，以免因开票信息错误给贵司带来损失。提交信息后，我司将在1-2个工作日完成审核，请及时关注审核结果。</label>
                </div>
                <div id="mod_2_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*单位名称</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_head" id="receipt_head" value="${ vo.mailPolicyVo.receipt_head}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人姓名</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_name" id="takerName" value="${ vo.mailPolicyVo.taker_name}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人手机</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_mobile" id="takerMobile" value="${ vo.mailPolicyVo.taker_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_address_detail" id="takerAddressDetail" value="${ vo.mailPolicyVo.taker_address_detail}" class="form-control" placeholder="企业营业执照上的全称"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*纳税人识别号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice_1" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                </div>
                <div id="mod_2_3" <c:if test="${empty mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*纳税人识别号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*注册地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.register_address_invoice" id="registerAddressInvoice" value="${ vo.mailPolicyVo.register_address_invoice}" class="form-control" placeholder="企业营业执照上的注册地址"  <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*电话</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_phone" id="receiptPhone" value="${ vo.mailPolicyVo.receipt_phone}" class="form-control" placeholder="企业联系电话"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行省</p>
                        <select Data-Val="Required" title="省" name="mailPolicyVo.bank_province" id="bankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bankCity', '', '2', this);" <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                            <option value="">请选择省</option>
                            <c:forEach items="${provinceList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_province }"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行市</p>
                        <select title="市" name="mailPolicyVo.bank_city" id="bankCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                            <option value="">请选择市</option>
                            <c:forEach items="${bankCityList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_city}"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.bank_invoice" id="bankInvoice" value="${ vo.mailPolicyVo.bank_invoice}" class="form-control" placeholder="企业银行开户许可证上的开户银行"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*银行账号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.bank_account_invoice" id="bankAccountInvoice" value="${ vo.mailPolicyVo.bank_account_invoice}" class="form-control" placeholder="企业开户许可证上的银行账号"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                    <div class="col-sm-4 col-xs-4">
                        <p>税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
                        <input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>一般纳税人证明</p>
                        <input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>银行开户许可证</p>
                        <input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>营业执照副本<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
                        <input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>增票授权委托书（个人支付时需提供此委托书<a href="<c:url value='/resources/files/增票授权委托书.doc' />" target="_blank">下载</a>）</p>
                        <input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
    </form>
    <div class="row next-step">
        <div class="col-sm-12 col-xs-12 text-right pull-right">
            <p>
                <a href="javascript:void(0);" onclick="saveLOTEInfo();" id="pendingInfo" class="save">暂存本页</a>
                <a href="javascript:void(0);" onclick="save_policy_lote();" class="ns-btn">下一步</a>
            </p>
        </div>
    </div>
</div><!-- container end -->
<input id="fileKeyName" type="hidden" value=""><!-- 上传文件的key，重要！ -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">营业执照</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
            </div>
        </div>
    </div>
</div>
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">组织机构代码证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">税务登记证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>


<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    var topWindow;
    var win_sign = 1;//0本站内嵌，1它站内嵌
    function changeFrameHeight(){
        for(topWindow=window;topWindow.parent!=null && topWindow.parent!=topWindow;topWindow=topWindow.parent){
            for(var i=0;i<topWindow.parent.frames.length;i++){
                var tObj = topWindow.parent.frames[i];
                if(tObj.window.document==topWindow.document){
                    var tName = tObj.name;
                    if(tName != ''){
                        if(tName.indexOf('frame3d')!=-1){
                            win_sign = 0;
                            parent.document.getElementById("frame3d").height=topWindow.document.body.offsetHeight+60;
                        }
                    }
                }
            }
        }
    }

    function openImgView(img_url){
        top.layer.open({
            type: 1,
            skin: 'layui-layer-rim', //加上边框
            area: ['420px', '350px'], //宽高
            content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
        });
    }
    var count = 2;
    $(function(){
        for(topWindow=window;topWindow.parent!=null && topWindow.parent!=topWindow;topWindow=topWindow.parent){
            for(var i=0;i<topWindow.parent.frames.length;i++){
                if(topWindow.parent.frames[i].window.document==topWindow.document){
                    var tName = topWindow.parent.frames[i].name;
                    if(tName != ''){
                        var bread_crumbs;
                        if(tName.indexOf('layui-layer-iframe')==-1){
                            $("ol[class*='breadcrumb']").each(function(){
                                $(this).html('');
                            });
                            <%--bread_crumbs = "<li>当前位置: <a href='<c:url value="/" />'>首页</a> </li><li> <a target='_blank' href='<c:url value="/synopsis/product/productAllView?pro_type=TYX" />'>产品列表</a> </li><li> <a target='_blank' href='<c:url value="/insurance/product/productInfo/${pd.oid}" />'>产品详情</a> </li><li> <span id='place'>填写投保单</span></li>";--%>
                        }else{
                            bread_crumbs = "<li>当前位置: 保障服务 </li><li> <a href='<c:url value="/api/lote/product/productAllView?ACCESS_TOKEN=${ACCESS_TOKEN}" />'>产品列表</a> </li><li> <a href='<c:url value="/api/gmr/product/productInfo/${pd.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}" />'>产品详情</a> </li><li> <span id='place'>填写投保单</span></li>";
                        }
                        $("#bread_crumbs").html(bread_crumbs);
                    }
                }
            }
        }
        if($("#need_insur_bill").is(':checked')){
            $("#mod_1").fadeIn(1000);
        }else{
            $("#mod_1").fadeOut(1000);
        }
        if($("#need_receipt").is(':checked')){
            var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
            $("#mod_2").fadeIn(1000);
            if(_invoice_val == "0"){//普通发票
                $("#mod_2_1").fadeIn(1000);
            }else{//专用发票,VATINVOICE
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
            }
        }else{
            $("#mod_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_3").fadeOut(1000);
        }
        changeFrameHeight();//加载当前内容高度并重置iframe
    });
    function validateForms(_obj){
        var _val = $(_obj).val();
        if(_obj.id == 'special_ex_emp_num'){
            if(Number(_val)>20||Number(_val)<1){
                laySomenType(1,null,"雇员人数在1~20人之间！",0);
                $(_obj).val('');
            }
        }
        if(_obj.id == 'special_ex_acreage'){
            if(!/^[0-9]*[1-9][0-9]*$/.test(_val)){
                laySomenType(1,null,"请输整平方数的展位面积！",0);
                $(_obj).val('');
            }else{
                var pCode = '${pd.product_code}';//mPremium
                var _area = Number(_val);
                if(pCode.indexOf('PAC-1')!=-1){
                    if(_area>36||_area<1){
                        laySomenType(1,null,"该方案展位面积在1~36平米之间！",0);
                        $(_obj).val('');
                    }else{
                        $("#mPremium").html("${pd.premium_min}.00元");
                        $("#premium").val("${pd.premium_min}");
                    }
                }else if(pCode.indexOf('PAC-2')!=-1){
                    if(_area>100||_area<1){
                        laySomenType(1,null,"该方案展位面积在1~100平米之间！",0);
                        $(_obj).val('');
                    }else{
                        if(_area>36){//38-100
                            $("#mPremium").html("340.00元");
                            $("#premium").val("340");
                        }else if(_area<=36){//1-37
                            $("#mPremium").html("240.00元");
                            $("#premium").val("240");
                        }
                    }
                }else if(pCode.indexOf('PAC-3')!=-1){
                    if(_area<1){
                        laySomenType(1,null,"展位面积在1平米以上！",0);
                        $(_obj).val('');
                    }else{
                        if(_area>36 && _area<=100){//37-100
                            $("#mPremium").html("400.00元");
                            $("#premium").val("400");
                        }else if(_area<=36){//<37
                            $("#mPremium").html("300.00元");
                            $("#premium").val("300");
                        }else if(_area>100){//>100
                            $("#mPremium").html("490.00元");
                            $("#premium").val("490");
                        }
                    }
                }else{
                    if(_area>108||_area<1){
                        laySomenType(1,null,"展位面积在1~108平米之间！",0);
                        $(_obj).val('');
                    }
                }

            }
        }
    }

    function save_policy_lote(){
        //如果校验没问题
        if(customsVerify()){
            //index是遮罩层，layer.load弹出层
            var index = laySomenType(0,null,'',0);
            $.ajax({
                type: 'POST',
                //ajax动态调用pendingGMRPolicyVoPolicy方法，都会保存订单
                url:baseUrl + '/api/lote/policy/pendingLOTEPolicyVoPolicy',
                //表单所有信息
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    //关闭遮罩
                    laySomenType(2,index,'',0);
                    //保存订单信息成功状态码
                    if(json.statusCode == '200') {
                        //页面跳转
                        window.location.href = baseUrl + '/api/lote/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }else{
                        //关闭遮罩
                        laySomenType(1,null,json.message,0);
                    }
                },
                //返回错误
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    //关闭遮罩
                    laySomenType(2,index,'',0);
                    //返回错误信息在遮罩层上
                    laySomenType(1,null,textStatus,0);
                }
            });
        }
    }
    function customsVerify(){
        var flag = true;
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required"){
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        laySomenType(1,null,"必填项不能为空！",0);
                        $(this).focus();
                        flag = false;
                        return true;
                    }else{
                        if($(this).val().length>40){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"长度超出限制！",0);
                            $(this).focus();
                            flag = false;
                            return true;
                        }else{
                            var _val = $(this).val();
                            var _id = this.id;
                            if(_id == 'role_doBusinessAddress_0'||_id == 'role_regAddress_0'){
                                if(_val.length<8||_val.length>60){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"内容长度不能少于8位！",0);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }

                }
            }
            if(dataVal == "FILE Required"){//FILE Required
                if($(this).val() == ''){
                    document.getElementById(this.id+'_file-5').scrollIntoView();
                    laySomenType(1,null,"上传文件不能为空！",0);
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
        });
        if(flag){
            $("select[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"必填项不能为空！",0);
                            $(this).focus();
                            flag = false;
                            return true;
                        }

                    }
                }
            });
            if(flag){
                $("textarea[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                laySomenType(1,null,"必填项不能为空！",0);
                                $(this).focus();
                                flag = false;
                                return true;
                            }else{
                                if($(this).val().length>100){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"长度超出限制(100字符)！",0);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }
                });

            }
        }
        mailSet();
        return flag;
    }
    function saveLOTEInfo(){
        mailSet();
        if(isAllNull() == 1){
            var index = laySomenType(0,null,'',0);
            $.ajax({
                type: 'POST',
                url:baseUrl + '/api/lote/policy/pendingLOTEPolicyVoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,json.message,0);
                    if(json.statusCode == '200') {
                        window.location.href = baseUrl + '/api/lote/policy/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,textStatus,0);
                }
            });
        }else{
            laySomenType(1,null,"表单未检索到数据，请完善信息后暂存！",0);
        }
    }
    function mailSet(){
        var invoice_type_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        if(invoice_type_val == "0"){
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
            $("#mod_2_3").find("select").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_insur_bill").is(':checked')){
            $("#mod_1").find("input").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_receipt").is(':checked')){
            $("#mod_2_2").find("input").each(function(){
                $(this).val('');
            });
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
        }
    }
    function isAllNull(){
        var values, index;
        values = $("#policyInfoForm").serializeArray();
        for (index = 0; index < values.length; ++index){
            var controls=document.getElementsByName(values[index].name);
            for(var i=0;i<controls.length;i++){
                if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                    return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
                }
            }
        }
        return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
    }
    $(function(){
        $('[data-toggle="tooltip"]').tooltip();
        $("input[id=need_insur_bill]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_1").fadeIn(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_1").fadeOut(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                    $(this).val('');
                });
            }
            setTimeout('changeFrameHeight()',1000);//加载当前内容高度并重置iframe
        });
        $("input[id=need_receipt]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
            }
            setTimeout('changeFrameHeight()',1000);//加载当前内容高度并重置iframe
        });
        $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
            if($(this).val() == "1"){
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
            }
            setTimeout('changeFrameHeight()',1000);//加载当前内容高度并重置iframe
        });
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required"){
                var _class = $(this).attr("class");
                if(_class.indexOf('laydate-icon')!=-1){

                }else{
                    $(this).on("blur",function(){
                        var _val = $(this).val();
                        var _id = this.id;
                        if(_val == ''){
//                        被保险人信息的6个输入框匹配id字段
                            if(_id == 'role_namecn_0'){
                                laySomenType(1,null,"投保单位名称不能为空！",0);
                            } else if(_id == 'role_organizationCode_0'){
                                laySomenType(1,null,"投保单位证件号码不能为空！",0);
                            } else if(_id == 'role_totalEmp_0'){
                                laySomenType(1,null,"企业总人数不能为空！",0);
                            } else if(_id == 'role_doBusinessAddress_0'){
                                laySomenType(1,null,"办公地址不能为空！",0);
                            } else if(_id == 'role_phone_0'){
                                laySomenType(1,null,"办公电话不能为空！",0);
                            } else if(_id == 'role_linkName_0'){
                                laySomenType(1,null,"联系人姓名不能为空！",0);
                            } else if(_id == 'role_linkTel_0'){
                                laySomenType(1,null,"联系人手机不能为空！",0);
                            } else if(_id == 'role_linkEmail_0'){
                                laySomenType(1,null,"联系人email不能为空！",0);
                            } else if(_id == 'role_zipCode_0'){
                                laySomenType(1,null,"邮政编码不能为空！",0);
                            } else if(_id == 'role_regAddress_0'){
                                laySomenType(1,null,"注册详细地址不能为空！",0);
                            } else if(_id == 'role_namecn_1'){
                                laySomenType(1,null,"被保险人名称不能为空！",0);
                            } else if(_id == 'role_organizationCode_1'){
                                laySomenType(1,null,"被保险人证件号码不能为空！",0);
                            } else if(_id == 'special_name'){
                                laySomenType(1,null,"展会名称不能为空！",0);
                            } else if(_id == 'special_star_time' || _id == 'special_end_time'){
                                laySomenType(1,null,"展会时间不能为空！",0);
                            } else if(_id == 'special_ex_province' || _id == 'special_ex_city' || _id == 'special_ex_county' || _id == 'special_ex_address'){
                                laySomenType(1,null,"展会举办地址不能为空！",0);
                            } else if(_id == 'special_ex_no'){
                                laySomenType(1,null,"展位号不能为空！",0);
                            } else if(_id == 'special_ex_acreage'){
                                laySomenType(1,null,"展位面积不能为空！",0);
                            } else if(_id == 'receiptHead'){
                                laySomenType(1,null,"单位名称不能为空！",0);
                            } else if(_id == 'takerName'){
                                laySomenType(1,null,"收票人姓名不能为空！",0);
                            } else if(_id == 'takerMobile'){
                                laySomenType(1,null,"收票人手机不能为空！",0);
                            } else if(_id == 'takerAddressDetail'){
                                laySomenType(1,null,"收票人地址不能为空！",0);
                            } else if(_id == 'receiverName'){
                                laySomenType(1,null,"收件人名称不能为空！",0);
                            } else if(_id == 'receiverMobile'){
                                laySomenType(1,null,"收件人手机不能为空！",0);
                            } else if(_id == 'receiverAddressDetail'){
                                laySomenType(1,null,"收件人地址不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice_1'){
                                laySomenType(1,null,"纳税人识别号不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice'){
                                laySomenType(1,null,"纳税人识别号不能为空！",0);
                            } else if(_id == 'registerAddressInvoice'){
                                laySomenType(1,null,"注册地址不能为空！",0);
                            } else if(_id == 'receiptPhone'){
                                laySomenType(1,null,"企业电话不能为空！",0);
                            } else if(_id == 'bankProvince'){
                                laySomenType(1,null,"开户银行省不能为空！",0);
                            } else if(_id == 'bankCity'){
                                laySomenType(1,null,"开户银行市不能为空！",0);
                            } else if(_id == 'bankInvoice'){
                                laySomenType(1,null,"开户银行不能为空！",0);
                            } else if(_id == 'bankAccountInvoice'){
                                laySomenType(1,null,"企业银行账号不能为空！",0);
                            }else {
                                laySomenType(1,null,"该项为必填字段,不能为空！",0);
                            }
                            if(_id.indexOf('_0')!=-1){
                                loser_has(this);
                            }else{
                                loser_has_ins(this);
                            }
                        }else{
                            if(_val.length>32){
                                laySomenType(1,null,"超过最长限制长度！",0);
                                loser_has(this);
                                $(this).val('');
                            }else{
                                if(_id.indexOf("role_namecn")!=-1){
                                    if(_val.length<10){
                                        laySomenType(1,null,Number(_id.split("_")[2]) == 0 ? '请填写完整的投保人名称！' : '请填写完整的被保险人名称！',0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }
                                if(_id.indexOf("role_namecn")!=-1){
                                    var isCN = new RegExp("[\\u4E00-\\u9FFF]+","g");
                                    if(isCN.test(_val)){//中文
                                        if(_val.indexOf('(') > -1 || _val.indexOf(')') > -1){
                                            laySomenType(1,null,"中文企业名称中的括号必须使用中文！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else{
                                        if(_val.indexOf('（') > -1 || _val.indexOf('）') > -1){
                                            laySomenType(1,null,"英文企业名称中的括号必须使用英文！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }
                                }else if(_id == 'role_linkName_0'||_id == 'role_linkName_1'){
                                    var isName=/[\u4E00-\u9FA5]{2,5}(?:·[\u4E00-\u9FA5]{2,8})*/;
                                    if(!isName.test(_val)||_val.length>13){
                                        laySomenType(1,null,"请输入正确姓名！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }

                                }else if(_id == 'role_phone_0'){
                                    var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
                                    if(!isPhone.test(_val)){
                                        laySomenType(1,null,"格式错误，请输入格式如0592-1234567！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkTel_0'||_id == 'role_linkTel_1'){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_doBusinessAddress_0'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的办公详细地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_regAddress_0'||_id == 'role_doBusinessAddress_0'||_id == 'role_regAddress_1'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的注册地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_zipCode_0'){
                                    if(checkZipCode(_val) == false){
                                        laySomenType(1,null,"请输入正确的邮政编码！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id.indexOf('role_mobile')!=-1){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                    }else{
                                        success_has_ins(this);
                                    }
                                }else if(_id == 'role_linkEmail_0'){
                                    if(checkEmail(_val) == false){
                                        laySomenType(1,null,"电子邮箱格式不正确，格式参考：blbservice@baichuanxin.com！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'taxpayerNumberInvoice_1'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }
                                }else if(_id == 'taxpayerNumberInvoice'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }
                                }else if(_id.indexOf('role_organizationCode')!=-1){
                                    if(_id == 'role_organizationCode_0' || _id == 'role_organizationCode_1'){
                                        var _idVal = $(this).attr("GIST-ID");
                                        var _gistVal = $("#"+_idVal).val();
                                        if(_gistVal == '1'){//组织机构代码证校验
                                            if(checkOrganizingCode(_val) == 0){
                                                laySomenType(1,null,"只能包含数字或英文大写字母，必须用连字符“-”隔开！",0);
                                                loser_has(this);
                                                $(this).val('');
                                            }else{
                                                success_has(this);
                                            }
                                        }else if(_gistVal == '2'){//三证合一信用代码证校验
                                            if(doValidCreditCode(_val) == 0){
                                                laySomenType(1,null,"由数字或大写英文字母组成，共18位！",0);
                                                loser_has(this);
                                                $(this).val('');
                                            }else{
                                                success_has(this);
                                            }
                                        }else if(_gistVal == '6'){//税务登记证校验
                                            var flass = false;
                                            var reg= /^[A-Za-z]+$/;
                                            if(_val.length == 15&&checkInt1(_val)){
                                                flass = true;
                                            }else if(_val.length == 20&&(checkInt1(_val)||(checkInt1(_val.substring(0,_val.length-1))&&reg.test(_val.substring(_val.length-1,_val.length))))){
                                                flass = true;
                                            }else{
                                                if(doValidCreditCode(_val) == 0){

                                                }else{
                                                    flass = true;
                                                }
                                            }
                                            if(flass){
                                                success_has(this);
                                            }else{
                                                laySomenType(1,null,"请输入正确的税务登记证或信用代码证代码！",0);
                                                loser_has(this);
                                                $(this).val('');
                                            }
                                        }else if(_gistVal == '7'){//营业执照校验
                                            var reg= /^\d{15}$/;
                                            if(!reg.test(_val)){
                                                laySomenType(1,null,"只能为15位数字！",0);
                                                loser_has(this);
                                                $(this).val('');
                                            }else{
                                                success_has(this);
                                            }
                                        }else{
                                            laySomenType(1,null,"请先选择证件类型！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }
                                    }else{//被保险人证件号校验

                                    }
                                }else{
                                    if(_id.indexOf('_0')!=-1){
                                        success_has(this);
                                    }else{
                                        success_has_ins(this);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            if(dataVal == "Date Required"){
                $(this).on("change",function(){
                    console.log(this.id);
                    if($(this).val() == ''){
                        laySomenType(1,null,"请选择起保日期！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
            if(dataVal == "Point"||dataVal == "Point Required"){
                $(this).on("keyup",function(){
                    var regm = /^[0-9]+.?[0-9]*$/;
                    if(isNaN($(this).val())){
                        laySomenType(1,null,"请输入正确的数字格式！",0);
                        $(this).val('');
                    }
                });
            }
            if(dataVal == "Num"||dataVal == "Num Required"){
                $(this).on("blur",function(){
                    var regm = /^[0-9]*[0-9][0-9]*$/;
                    if(!regm.test($(this).val())){
                        laySomenType(1,null,"请输入正确的数量格式！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
        });
        $("select[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required") {
                $(this).on("change", function () {
                    var _val = $(this).val();
                    var _id = this.id;
                    if (_val == '') {
                        if(_id == 'role_comNature_0'){
                            laySomenType(1,null,"请选择营业性质！",0);
                        } else if(_id == 'role_idType_0' || _id == 'role_idType_1'){
                            laySomenType(1,null,"请选择证件类型！",0);
                        }  else if(_id == 'inceptionDate'){
                            laySomenType(1,null,"起保日期不能为空！",0);
                        } else if(_id == 'regProvince' || _id == 'regCity' || _id == 'regDistrict'){
                            laySomenType(1,null,"注册地址不能为空！",0);
                        } else if(_id == 'special_ex_province' || _id == 'special_ex_city' || _id == 'special_ex_county'){
                            laySomenType(1,null,"展会举办地址不能为空！",0);
                        }else {
                            laySomenType(1,null,"该项为必填项，不能为空！",0);
                        }
                        if (_id.indexOf('_0') != -1) {
                            loser_has(this);
                        } else {
                            loser_has_ins(this);
                        }
                        $(this).val('');
                    } else {
                        success_has_ins(this);
                    }
                });
            }
        });

    });

    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity.json',
            data:{"codeLevel":level,"parentCode":code},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }

    function checkToradio(_id, type){
        var o = $("#"+_id);
        if(type=="radio"){
            o.prop('checked',true);
            if(o.val() == "1"){
                $("#arbitralInstitution").parent().show();
            }else if(o.val() == "0"){
                $("#arbitralInstitution").val('');
                $("#arbitralInstitution").parent().hide();
            }else{
                o.click();
            }
        }else if(type=="checkbox"){

            if($("#"+_id).attr('checked')) {
                o.attr('checked', false);
            } else {
                o.attr('checked', true);
            }
            o.click();
        }
    }

    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
    var special_star_time = {
        elem: '#special_star_time',
        format: 'YYYY-MM-DD',
        min: laydate.now(+1), //设定最小日期为当前日期
        max: '2099-06-16', //最大日期
        istime: true,
        istoday: false,
        choose: function(datas){
            special_end_time.min = datas; //开始日选好后，重置结束日的最小日期
//            special_end_time.start = datas //将结束日的初始值设定为开始日
            special_end_time.max = dateAddDays(datas,14);
        }
    };

    //日期加天数的方法
    //dataStr日期字符串
    //dayCount 要增加的天数
    //return 增加n天后的日期字符串
    function dateAddDays(dataStr,dayCount) {
        var strdate=dataStr; //日期字符串
        var isdate = new Date(strdate.replace(/-/g,"/"));  //把日期字符串转换成日期格式
        isdate = new Date((isdate/1000+(86400*dayCount))*1000);  //日期加1天
        var pdate = isdate.getFullYear()+"-"+(isdate.getMonth()+1)+"-"+(isdate.getDate());   //把日期格式转换成字符串

        return pdate;
    }

    var special_end_time = {
        elem: '#special_end_time',
        format: 'YYYY-MM-DD',
        min: '1900-01-01',
        max: '2099-06-16',
        istime: true,
        istoday: false,
        choose: function(datas){
            /*start.max = datas; //结束日选好后，充值开始日的最大日期
            bidtimeS.max = datas;*/
        }
    };
    laydate(special_star_time);
    laydate(special_end_time);
    function laySomenType(ty,idx,msg,times){//ty:layer类型，如0打开遮盖，1消息提示，2关闭遮盖层；win_sign:当前0内嵌或1外嵌
        if(win_sign == 0){//本站内嵌
            if(ty==0){//打开遮盖
                return parent.layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    parent.layer.msg(msg);
                }else{
                    parent.layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                parent.layer.close(idx);
            }
        }else{//它站内嵌
            if(ty==0){//打开遮盖
                return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    layer.msg(msg);
                }else{
                    layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                layer.close(idx);
            }
        }
        return null;
    }
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>