<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
</head>
<body>

<div class="container"><!-- container start -->

    <ol class="breadcrumb" id="bread_crumbs">
        <%--<li>当前位置： </li>
        <li><a href="<c:url value='/api/order/myOrder' />">我的订单</a></li>
        <li><a href="<c:url value='/api/gyx/product/productInfo/${pd.oid}'/>">产品详情</a></li>
        <li class="active">投保</li>--%>
    </ol>
    <div class="nav-list">
        <div class="row w-80-auto">
            <div class="col-sm-3 col-sm-4 active">
                <p><i class="pull-left">1</i><span class=" pull-left">填写保险信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-4">
                <p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-3">
                <p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
            </div>
            <div class="col-sm-3 col-sm-3 pull-right">
                <p><i class="pull-left">4</i><span class="pull-left"> 完成投保</span></p>
            </div>
        </div>
    </div>
    <form class="form-horizontal form-create-item"  action="<c:url value='/api/gyx/policy/gyx_confirmPage?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
        <input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
        <input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>推荐人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-4 col-xs-4">
                    <p>推荐人的手机号或编号</p>
                    <input type="text" name="recommend_code" id="recommend_code" data-relate="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
                    <input type="hidden" name="sigId" value="${dto.trade_serial_number}"/>
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[0].oid" id="role_appRoleID_0" value="${vo.roleSubjectList[0].oid}"/>
            <input type="hidden" name="roleSubjectList[0].kind" id="role_kind_0" value="3"/>
            <input type="hidden" name="roleSubjectList[0].roleType" id="role_roleType_0" value="1"/>
            <div class="title-war"><h3 id="cy_lxr">投/被保人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*名称</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].name_cn" id="app_namecn_0" value="${vo.roleSubjectList[0].name_cn}" class="form-control" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_type" id="app_idType_0" value="${vo.roleSubjectList[0].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="0" selected="selected">身份证</option>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件号码</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].organization_code" id="app_organizationCode_0" GIST-ID="app_idType_0" value="${vo.roleSubjectList[0].organization_code}" class="form-control"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>*性别</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].sex" GIST-ID="app_organizationCode_0" id="app_sex_0" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <option value="1" <c:if test="${vo.roleSubjectList[0].sex eq '1' }"> selected="selected"</c:if> >男</option>
                        <option value="2" <c:if test="${vo.roleSubjectList[0].sex eq '2' }"> selected="selected"</c:if> >女</option>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*出生日期</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].birth_date" GIST-ID="app_organizationCode_0" id="app_birthDate_0" value="${ vo.roleSubjectList[0].birth_date}" class="laydate-icon form-control" onclick="laydate({elem: '#app_birthDate_0',format: 'YYYY-MM-DD'});" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*手机号码</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].mobile" id="app_mobile_0" value="${ vo.roleSubjectList[0].mobile}" class="form-control" placeholder="" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*电子邮箱</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].email" id="app_email_0" value="${ vo.roleSubjectList[0].email}" class="form-control" placeholder="" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-9 col-xs-9">
                    <p>*联系地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${reg_cityList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${reg_areaList }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" title="联系地址" type="text" name="roleSubjectList[0].reg_address" id="role_regAddress_0" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>受益人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>受益人<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="《继承法》规定的法定继承人范围是：第一顺序继承人为配偶、子女、父母；第二顺序继承人为兄弟姐妹、祖父母、外祖父母。"></i></p>
                    <input type="text" value="法定继承人" disabled class="form-control"/>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>投保计划信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-9 col-xs-9">
                    <p>*保险期间</p>
                    <div class="row fs-lh34">
                        <div class="col-sm-1 col-xs-1">自</div>
                        <div class="col-sm-3 col-xs-3"><input Data-Val="Required" placeholder="" name="inception_date" id="inceptionDate" autocomplete="off" value="${vo.inception_date}" class="laydate-icon form-control"> </div>
                        <div class="col-sm-2 col-xs-2">零时起</div>
                        <div class="col-sm-1 col-xs-1">至</div>
                        <div class="col-sm-3 col-xs-3"><input Data-Val="Required" placeholder="" name="planned_end_date" id="plannedEndDate" autocomplete="off" value="${vo.planned_end_date}" class="laydate-icon form-control"></div>
                        <div class="col-sm-2 col-xs-2">二十四时止</div>
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12">
                    <p>争议处理</p>
                    <div><span>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：</span></div>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span><input type="radio" value="0" name="dispute" id="dispute_radio1" onclick="checkToradio('dispute_radio1','radio');" <c:if test="${ empty vo.dispute || vo.dispute eq '0' }"> checked="checked" </c:if>><label for="dispute_radio1" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio1','radio');">诉讼</strong></span>
                                </div>
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span><input type="radio" value="1" name="dispute" id="dispute_radio2" onclick="checkToradio('dispute_radio2','radio');"  <c:if test="${vo.dispute eq '1' }"> checked="checked" </c:if>><label for="dispute_radio2" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio2','radio');">仲裁，仲裁机构</strong></span>
                                </div>
                                <div class="col-sm-3 col-xs-3" <c:if test="${empty vo.dispute ? true : vo.dispute eq '0' }"> style="display: none;" </c:if>>
                                    <input type="text" name="arbitral_institution" id="arbitralInstitution" value="${vo.arbitral_institution }" class="form-control su-lo">
                                    <span class="glyphicon form-control-feedback pa-27" aria-hidden="true"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>保费</p>
                    <strong class="d-l-36" id="mPremium">${empty dto.gross_premium ? pd.premium_min : dto.gross_premium}元</strong>
                </div>

            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>单证信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-12 col-xs-12">
                    <p>*本产品仅提供电子保单和电子发票（普票）。</p>
                    <p>*投保成功后电子保单及电子发票将发送至投/被保险人邮箱。</p>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
    </form>
    <div class="row next-step">
        <div class="col-sm-12 col-xs-12 text-right pull-right">
            <p>
                <a href="javascript:void(0);" onclick="saveGYXInfo();" id="pendingInfo" class="save">暂存本页</a>
                <a href="javascript:void(0);" onclick="save_policy_gyx();" class="ns-btn">下一步</a>
            </p>
            <%--<p>
                <a href="javascript:void(0);" onclick="saveGMRInfo();" id="pendingInfo" class="save">暂存本页</a>
                <a href="javascript:void(0);" onclick="save_policy_gmr();" class="ns-btn">下一步</a>
            </p>--%>
        </div>
    </div>
</div><!-- container end -->
<input id="fileKeyName" type="hidden" value=""><!-- 上传文件的key，重要！ -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">营业执照</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
            </div>
        </div>
    </div>
</div>
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">组织机构代码证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">税务登记证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>
<script src="/static/weChat/js/weixin_g.js"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
    window.onload = function () {
        //以后优化 频繁变更水印
        watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
    }
    $(function () {
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/person/query',false,false,function(json){
            var str = "";
            if (json.length > 0){
                for (var i = 0; i < json.length; i++) {
                    str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].user_name + '</p></li>';
                }
            }
            if(str != ""){
                var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用投保人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                $('body').append(lxr_html);
                $("#userList").html(str);
                addCylxr();
            }
        });
        function addCylxr(){
            //点击联系人
            $('.contacts_modal ul li').click(function () {
                $('.contacts_modal ul li').removeClass('active');
                $(this).addClass('active');
                if(!$('.contacts-bottom .sure').hasClass('sure_color')){
                    $('.contacts-bottom span.sure').addClass('sure_color');
                }
            });
            //点击取消
            $('.contacts-bottom .cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
            });
            $('.contacts_modal .title-cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
            });
            //点击填入
            $('.contacts-bottom .sure').click(function () {
                if($(this).hasClass('sure_color')){
                    setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                }else{
                    //没有点击选择联系人
                    // alert('请选择一个联系人！');
                }
            })
            var _html = '投/被保人信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals()">选择常用投保人</a>';
            $("#cy_lxr").html(_html);
        }
        function setTBR(_json){
            var json = eval("(" + _json + ")");
            $("#regProvince").val(json.province);//省
            $("#role_regAddress_0").val(json.address);//详细地址
            $("#regProvince").change();
            setTimeout(function(){
                $("#regCity").val(json.city);//市
                $("#regCity").change();
                setTimeout(function(){
                    $("#regDistrict").val(json.district);//区
                },1000);
            },1000);
            $("#app_namecn_0").val(json.user_name);//名称
            $("#app_idType_0").val(json.certificate_type);//证件类型
            $("#app_organizationCode_0").val(json.certificate_code);//证件号码
            $("#app_sex_0").val(json.sex);//性别
            $("#app_birthDate_0").val(json.birthday);//出生日期
            $("#app_mobile_0").val(json.telephone);//手机号码
            $("#app_email_0").val(json.email);//电子邮箱
        }
        document.onmousedown = function(ev){
            ev = ev || window.event;
            var nr = '已阅读并同意 roleSubjectList[0].reg_address appOrganizingPath_file roleSubjectList[1].reg_address appOrganizingPath1_file 【批量上传】 inception_date roleSubjectList[0].bank_account mailPolicyVo.taxpayer_number_invoice 暂存本页 下一步 ';
            var x=ev.clientX;
            var y=ev.clientY;
            if((ev.target.childNodes[0]!=undefined && nr.indexOf(ev.target.childNodes[0].data)!=-1) || nr.indexOf(ev.target.name)!=-1 ){
                if(ev.target.name=='inception_date'){
                    //到这里需要整个页面都截图一次
                    <%--insOperation('${dto.oid}','${sigId}','投保信息提交');--%>
                }
                insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息提交');
            }
        }
    })
    //点击弹窗出现
    function showContractsModals() {
        $('.contacts_modal').show();
        $('.black-mask').show();
    }

</script>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    var win_sign = 1;//0本站内嵌，1它站内嵌

    var count = 2;
    $(function(){
        changeFrameSet(0,'');
        if($("#need_insur_bill").is(':checked')){
            $("#mod_1").fadeIn(1000);
        }else{
            $("#mod_1").fadeOut(1000);
        }
        if($("#need_receipt").is(':checked')){
            var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
            $("#mod_2").fadeIn(1000);
            if(_invoice_val == "0"){//普通发票
                $("#mod_2_1").fadeIn(1000);
            }else{//专用发票,VATINVOICE
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
            }
        }else{
            $("#mod_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_3").fadeOut(1000);
        }
//        changeFrameHeight();//加载当前内容高度并重置iframe
    });
    var countdown=5;

    function save_policy_gyx(){
        //如果校验没问题
        if(customsVerify()){
            //index是遮罩层，layer.load弹出层
            var index = laySomenType(0,null,'',0);
            $.ajax({

                type: 'POST',
                //ajax动态调用pendingGMRPolicyVoPolicy方法，都会保存订单
                url:baseUrl + '/api/gyx/policy/pendingGYXPolicyVoPolicy',
                //表单所有信息
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    //关闭遮罩
                    laySomenType(2,index,'',0);
                    //保存订单信息成功状态码
                    if(json.statusCode == '200') {
                        insOperation(json.navTabId,'${dto.trade_serial_number}','投保信息提交');
                        window.location.href = baseUrl + '/api/gyx/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                        /*var _t = setInterval(function () {
                            if(_tong==1){
                                clearInterval(_t);
                                window.location.href = baseUrl + '/api/gyx/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                            }
                        },300);*/
                    }else{
                        //关闭遮罩
                        laySomenType(1,null,json.message,0);
                        insOperation('','${dto.trade_serial_number}','投保信息提交');
                    }
                },
                //返回错误
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    //关闭遮罩
                    laySomenType(2,index,'',0);
                    //返回错误信息在遮罩层上
                    laySomenType(1,null,textStatus,0);
                }
            });
        }
    }
    function customsVerify(){
        var flag = true;
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required"){
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        laySomenType(1,null,"必填项不能为空！",0);
                        loser_has(this);
                        flag = false;
                        return true;
                    }else{
                        if($(this).val().length>40){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"长度超出限制！",0);
                            loser_has(this);
                            flag = false;
                            return true;
                        }else{
                            var _val = $(this).val();
                            var _id = this.id;
                            if(_id == 'role_regAddress_0'){
                                if(_val.length<8||_val.length>60){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"请填写具体地址（包含：镇、乡或街道）！",0);
                                    loser_has(this);
                                    flag = false;
                                    return true;
                                }
                            }
                            if(_id.indexOf('app_organizationCode_0')!=-1){
                                var _idVal = $(this).attr("GIST-ID");
                                var _gistVal = $("#"+_idVal).val();
                                if(_gistVal == '0'){//身份证校验
                                    var age_c = Number(getAgeByAge(_val));
                                    if(!validateIdent.IdentityCodeValid(_val)){
                                        document.getElementById(this.id).scrollIntoView();
                                        laySomenType(1,null,"请输入正确证件号！",0);
                                        loser_has(this);
                                        flag = false;
                                        return true;
                                    }else if(age_c<18||age_c>65){
                                        document.getElementById(this.id).scrollIntoView();
                                        laySomenType(1,null,"被保险人年龄(18-65周岁)超出限制！",0);
                                        loser_has(this);
                                        flag = false;
                                        return true;
                                    }
                                }else if(_gistVal == '3'){//护照校验
                                    if(!checkProtection(_val)){
                                        document.getElementById(this.id).scrollIntoView();
                                        laySomenType(1,null,"请输入正确护照号！",0);
                                        loser_has(this);
                                        flag = false;
                                        return true;
                                    }
                                }else if(_gistVal == '4'){//台胞证校验
                                    if(!checkCompatriotsCard(_val)){
                                        document.getElementById(this.id).scrollIntoView();
                                        laySomenType(1,null,"请输入正确台胞证号！",0);
                                        loser_has(this);
                                        flag = false;
                                        return true;
                                    }
                                }else if(_gistVal == '5'){//返乡证校验
                                    if(!checkHomeCard(_val)){
                                        document.getElementById(this.id).scrollIntoView();
                                        laySomenType(1,null,"请输入正确返乡证号！",0);
                                        loser_has(this);
                                        flag = false;
                                        return true;
                                    }
                                }else{
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"请先选择证件类型！",0);
                                    loser_has(this);
                                    flag = false;
                                    return true;
                                }
                            }
                            if(flag) {
                                if (_id == 'app_mobile_0') {
                                    if (checkMobile(_val) == false) {
                                        document.getElementById(this.id).scrollIntoView();
                                        laySomenType(1, null, "手机号格式不正确，格式参考13800138000", 0);
                                        loser_has(this);
                                        flag = false;
                                        return true;
                                    }
                                }
                            }
                            if(flag){
                                if(_id.indexOf('app_birthDate')!=-1){
                                    var _idVal = $(this).attr("GIST-ID");
                                    var _gistVal = $("#"+_idVal).val();
                                    if(_gistVal == ""){
                                        document.getElementById(this.id).scrollIntoView();
                                        laySomenType(1,null,"证件号码不能为空！",0);
                                        loser_has(this);
                                        flag = false;
                                        return true;
                                    }else{
                                        var _idTy = $("#"+_idVal).attr("GIST-ID");
                                        var _gistTy = $("#"+_idTy).val();
                                        if(_gistTy == "0"){
                                            if(_val != getBirthdayFromIDNo(_gistVal)){
                                                document.getElementById(this.id).scrollIntoView();
                                                laySomenType(1,null,"该日期与身份证不匹配！",0);
                                                loser_has(this);
                                                flag = false;
                                                return true;
                                            }
                                        }else{
                                            var age_b = Number(getbirthDayByAge(_val));
                                            if(age_b<16||age_b>65){
                                                document.getElementById(this.id).scrollIntoView();
                                                laySomenType(1,null,"被保险人年龄(16-65周岁)超出限制！",0);
                                                loser_has(this);
                                                flag = false;
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                }
            }
            success_has(this);
            if(dataVal == "FILE Required"){//FILE Required
                if($(this).val() == ''){
                    document.getElementById(this.id+'_file-5').scrollIntoView();
                    laySomenType(1,null,"上传文件不能为空！",0);
                    flag = false;
                    return true;
                }
            }
        });
        if(flag){
            $("input[Data-Val]").each(function() {
                var dataVal = $(this).attr("Data-Val");
                if ($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden") {
                    if (dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required") {
                        $(this).blur();
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"请正确填写相关信息！",0);
                            flag = false;
                            return true;
                        }else{
                            if(this.id == 'inceptionDate'){
                                if(Gdate.getDaysDiff($(this).val(), Gdate.curtime())<=0){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"起保日期必须大于今天！",0);
                                    flag = false;
                                    return true;
                                }
                            }
                        }
                    }
                }
            });
        }
        if(flag){
            $("select[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"必填项不能为空！",0);
                            flag = false;
                            return true;
                        }else{
                            var _val = $(this).val();
                            var _id = this.id;
                            if(_id.indexOf('app_sex')!=-1){
                                var _idVal = $(this).attr("GIST-ID");
                                var _gistVal = $("#"+_idVal).val();
                                if(_gistVal == ""){
                                    document.getElementById(_id).scrollIntoView();
                                    laySomenType(1,null,"请先完善证件号码！",0);
                                    flag = false;
                                    return true;
                                }else{
                                    var _idTy = $("#"+_idVal).attr("GIST-ID");
                                    var _gistTy = $("#"+_idTy).val();
                                    if(_gistTy == "0"){
                                        var _sex = "M";
                                        if($(this).val() == "2"){
                                            _sex = "F";
                                        }
                                        if( _sex != getSexFromIDNo(_gistVal)){
                                            document.getElementById(_id).scrollIntoView();
                                            laySomenType(1,null,"该性别与身份证不匹配！",0);
                                            flag = false;
                                            return true;
                                        }
                                    }
                                }
                            }
                        }

                    }
                }
            });
            if(flag){
                $("textarea[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                laySomenType(1,null,"必填项不能为空！",0);
                                flag = false;
                                return true;
                            }else{
                                if($(this).val().length>100){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"长度超出限制(100字符)！",0);
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }
                });

            }
        }
        mailSet();
        return flag;
    }

    function saveGYXInfo(){
        mailSet();
        if(isAllNull() == 1){
            var index = laySomenType(0,null,'',0);
            $.ajax({
                type: 'POST',
                url:baseUrl + '/api/gyx/policy/pendingGYXPolicyVoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,json.message,0);
                    if(json.statusCode == '200') {
                        window.location.href = baseUrl + '/api/gyx/policy/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,textStatus,0);
                }
            });
        }else{
            laySomenType(1,null,"表单未检索到数据，请完善信息后暂存！",0);
        }
    }
    function mailSet(){
        var invoice_type_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        if(invoice_type_val == "0"){
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
            $("#mod_2_3").find("select").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_insur_bill").is(':checked')){
            $("#mod_1").find("input").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_receipt").is(':checked')){
            $("#mod_2_2").find("input").each(function(){
                $(this).val('');
            });
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
        }
    }
    function isAllNull(){
        var values, index;
        values = $("#policyInfoForm").serializeArray();
        for (index = 0; index < values.length; ++index){
            var controls=document.getElementsByName(values[index].name);
            for(var i=0;i<controls.length;i++){
                if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                    return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
                }
            }
        }
        return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
    }

    function initID_Date(){
        var idOption = '${vo.roleSubjectList[0].id_option}';
        if(idOption == "1"){
            $("#role_idStarDate_0").parent().show();
            $("#role_idEndDate_0").parent().show();
        }
    }
    $(function(){
        initID_Date();
        $('[data-toggle="tooltip"]').tooltip();

        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required"){
                var _class = $(this).attr("class");
                if(_class.indexOf('laydate-icon')!=-1){
                    $(this).on("change",function(){
                        var _val = $(this).val();
                        var _id = this.id;
                        if(_id.indexOf('role_birthDate')!=-1){
                            var _idVal = $(this).attr("GIST-ID");
                            var _gistVal = $("#"+_idVal).val();
                            if(_gistVal == ""){
                                laySomenType(1,null,"请先完善证件号码！",0);
                                loser_has(this);
                                $(this).val('');
                            }else{
                                var _idTy = $("#"+_idVal).attr("GIST-ID");
                                var _gistTy = $("#"+_idTy).val();
                                if(_gistTy == "0"){
                                    if(_val != getBirthdayFromIDNo(_gistVal)){
                                        laySomenType(1,null,"该日期与身份证不匹配！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else{
                                    var age_b = Number(getbirthDayByAge(_idVal));
                                    if(age_b<16||age_b>65){
                                        laySomenType(1,null,"被保险人年龄(16-65周岁)超出限制！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }
                            }
                        }
                    });
                }else{
                    $(this).on("blur",function(){
                        var _val = $(this).val();
                        var _id = this.id;
                        if(_val == ''){
                            if(_id == 'app_namecn_0'){
                                laySomenType(1,null," 姓名不能为空！",0);
                            } else if(_id == 'app_organizationCode_0'){
                                laySomenType(1,null," 证件号码不能为空！",0);
                            } else if(_id == 'app_mobile_0'){
                                laySomenType(1,null," 手机号码不能为空！",0);
                            } else if(_id == 'app_email_0'){
                                laySomenType(1,null," 电子邮箱不能为空！",0);
                            } else if(_id == 'role_regAddress_0'){
                                laySomenType(1,null," 请填写具体地址（包含：镇、乡或街道）！",0);
                            }
                            loser_has(this);
                        }else{
                            if(_val.length>32){
                                laySomenType(1,null,"超过最长限制长度！",0);
                                loser_has(this);
                                $(this).val('');
                            }else{
                                if(_id == 'app_namecn_0'){
                                    var isName=/[\u4E00-\u9FA5]{2,5}(?:·[\u4E00-\u9FA5]{2,8})*/;
                                    if(!isName.test(_val)||_val.length>13){
                                        laySomenType(1,null,"请输入正确的投保人姓名！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else if(_val.length!=_val.trim().length){
                                        laySomenType(1,null,"请输入正确姓名！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                    return;
                                }else if(_id == 'app_mobile_0'){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                    return;
                                }else if(_id == 'role_regAddress_0'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请填写具体地址（包含：镇、乡或街道）！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                    return;
                                }else if(_id == 'app_email_0'){
                                    if(checkEmail(_val) == false){
                                        laySomenType(1,null,"电子邮箱格式不正确，格式参考：blbservice@baichuanxin.com",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                    return;
                                }else if(_id.indexOf('app_organizationCode_0')!=-1){
                                    var _idVal = $(this).attr("GIST-ID");
                                    var _gistVal = $("#"+_idVal).val();
                                    if(_gistVal == '0'){//身份证校验
                                        var age_c = Number(getAgeByAge(_val));
                                        if(!validateIdent.IdentityCodeValid(_val)){
                                            laySomenType(1,null,"请输入正确证件号！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else if(age_c<18||age_c>65){
                                            laySomenType(1,null,"被保险人年龄(18-65周岁)超出限制！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            var _thr = _id.split("_")[2];
                                            $("#app_birthDate_"+_thr).val(getBirthdayFromIDNo(_val));
                                            $("#app_sex_"+_thr).val(getSexFromIDNo(_val) == 'M'?'1':'2');
                                            success_has(this);
                                        }
                                    }else if(_gistVal == '3'){//护照校验
                                        if(!checkProtection(_val)){
                                            laySomenType(1,null,"请输入正确护照号！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else if(_gistVal == '4'){//台胞证校验
                                        if(!checkCompatriotsCard(_val)){
                                            laySomenType(1,null,"请输入正确台胞证号！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else if(_gistVal == '5'){//返乡证校验
                                        if(!checkHomeCard(_val)){
                                            laySomenType(1,null,"请输入正确返乡证号！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else{
                                        laySomenType(1,null,"请先选择证件类型！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }
                                    return;
                                }else{
                                    success_has(this);
                                }
                            }
                        }
                    });
                }
            }
            if(dataVal == "Date Required"){
                $(this).on("change",function(){
                    if($(this).val() == ''){
                        laySomenType(1,null,"请选择起保日期！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
            if(dataVal == "Point"||dataVal == "Point Required"){
                $(this).on("keyup",function(){
                    var regm = /^[0-9]+.?[0-9]*$/;
                    if(isNaN($(this).val())){
                        laySomenType(1,null,"请输入正确的数字格式！",0);
                        $(this).val('');
                    }
                });
            }
            if(dataVal == "Num"||dataVal == "Num Required"){
                $(this).on("blur",function(){
                    var regm = /^[0-9]*[0-9][0-9]*$/;
                    if(!regm.test($(this).val())){
                        laySomenType(1,null,"请输入正确的数量格式！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
        });
        $("select[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required") {
                $(this).on("change", function () {
                    var _val = $(this).val();
                    var _id = this.id;
                    if (_val == '') {
                        if(_id == 'app_idType_0'){
                            laySomenType(1,null," 请选择证件类型！",0);
                        } else if(_id == 'app_sex_0'){
                            laySomenType(1,null," 请选择性别！",0);
                        } else if(_id == 'inceptionDate'){
                            laySomenType(1,null," 起保日期不能为空！",0);
                        } else if(_id == 'regProvince' || _id == 'regCity' || _id == 'regDistrict'){
                            laySomenType(1,null," 联系地址不能为空！",0);
                        } else {
                            laySomenType(1,null," 该项为必填项，不能为空！",0);
                        }
                        loser_has(this);
                        $(this).val('');
                    } else {
                        success_has(this);
                        if (_id.indexOf('app_sex') != -1) {
                            var _idVal = $(this).attr("GIST-ID");
                            var _gistVal = $("#" + _idVal).val();
                            if (_gistVal == "") {
                                laySomenType(1,null,"请先完善证件号码！",0);
                                loser_has(this);
                                $(this).val('');
                            } else {

                                var _idTy = $("#"+_idVal).attr("GIST-ID");
                                var _gistTy = $("#"+_idTy).val();
                                if(_gistTy == "0"){
                                    var _sex = "M";
                                    if (_val == "2") {
                                        _sex = "F";
                                    }
                                    if (_sex != getSexFromIDNo(_gistVal)) {
                                        laySomenType(1,null,"该性别与身份证不匹配！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    } else {
                                        success_has(this);
                                    }
                                }else{
                                    success_has(this);
                                }
                            }
                        }
                    }
                });
            }
        });

    });
    Date.prototype.pattern=function(fmt) {
        var o = {
            "M+" : this.getMonth()+1, //月份
            "d+" : this.getDate(), //日
            "h+" : this.getHours()%12 == 0 ? 12 : this.getHours()%12, //小时
            "H+" : this.getHours(), //小时
            "m+" : this.getMinutes(), //分
            "s+" : this.getSeconds(), //秒
            "q+" : Math.floor((this.getMonth()+3)/3), //季度
            "S" : this.getMilliseconds() //毫秒
        };
        var week = {
            "0" : "/u65e5",
            "1" : "/u4e00",
            "2" : "/u4e8c",
            "3" : "/u4e09",
            "4" : "/u56db",
            "5" : "/u4e94",
            "6" : "/u516d"
        };
        if(/(y+)/.test(fmt)){
            fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
        }
        if(/(E+)/.test(fmt)){
            fmt=fmt.replace(RegExp.$1, ((RegExp.$1.length>1) ? (RegExp.$1.length>2 ? "/u661f/u671f" : "/u5468") : "")+week[this.getDay()+""]);
        }
        for(var k in o){
            if(new RegExp("("+ k +")").test(fmt)){
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
            }
        }
        return fmt;
    }
    var curDate = new Date();
    var date = new Date((curDate/1000+86400)*1000);
    var nextDate = date.pattern("yyyy-MM-dd");
    //日期范围限制
    var _star = {
        elem: '#inceptionDate',
        format: 'YYYY-MM-DD',
        min: nextDate, //设定最小日期为当前日期
        max: '2099-06-16', //最大日期
        choose: function(datas){
            _end.min = datas; //开始日选好后，重置结束日的最小日期
            var startDate = new Date(datas);
            startDate = +startDate + 1000*60*60*24*29;
            startDate = new Date(startDate);
            var nextDate1 = startDate.getFullYear()+"-"+(startDate.getMonth()+1)+"-"+startDate.getDate();
            _end.max = nextDate1;
        }
    };
    var _end = {
        elem: '#plannedEndDate',
        format: 'YYYY-MM-DD',
        min: nextDate,
        max: '2099-06-16',
        choose: function(datas){
            getPremium();
        }
    };
    laydate(_star);
    laydate(_end);
    function getPremium(){
        var itd = $('#inceptionDate').val();
        var ped = $('#plannedEndDate').val();
        if(itd != ''&&ped != ''){
            var sDay = DateDiff(itd,ped);
            var allPr = 10;
            if(sDay<2){
                allPr = 10;
            }else if(sDay>1&&sDay<8){
                allPr = 20;
            }else if(sDay>7&&sDay<16){
                allPr = 30;
            }else if(sDay>15&&sDay<31){
                allPr = 50;
            }
            $("#mPremium").html(allPr.toFixed(2)+"元");
        }
    }
    //计算两个日期天数差的函数，通用
    function DateDiff(sDate1, sDate2) {  //sDate1和sDate2是yyyy-MM-dd格式
        var aDate, oDate1, oDate2, iDays;
        aDate = sDate1.split("-");
        oDate1 = new Date(aDate[1] + '-' + aDate[2] + '-' + aDate[0]);  //转换为yyyy-MM-dd格式
        aDate = sDate2.split("-");
        oDate2 = new Date(aDate[1] + '-' + aDate[2] + '-' + aDate[0]);
        iDays = parseInt(Math.abs(oDate1 - oDate2) / 1000 / 60 / 60 / 24); //把相差的毫秒数转换为天数
        return iDays+1;  //返回相差天数
    }
    function natureChange(_this,_id){
        var code = _this.value;
        if(code != ""){
            $.ajax({
                type: 'POST',
                url: baseUrl + '/api/gyx/natureChange.json',
                data:{"nID":code},
                dataType:"json",
                async: false,
                success: function(json) {
                    $("#" + _id).empty();
                    var t = 0;
                    $("#" + _id).append("<option value=''>-请选择-</option>");
                    for (var prop in json) {
                        if (json.hasOwnProperty(prop)) {
                            t ++;
                            var appendStr = "<option value='" + prop + "' ";
                            appendStr = appendStr + ">" + json[prop] + "</option>"
                            $("#" + _id).append(appendStr);
                        }
                    }
                    if(t > 0){
                        $("#"+_id).parent().show();
                    }else{
                        $("#"+_id).parent().hide();
                    }

                }
            });
        }else{
            $("#"+_id).parent().hide();
        }
    }
    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity.json',
            data:{"codeLevel":level,"parentCode":code},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function checkToradio(_id, type){
        var o = $("#"+_id);
        if(type=="radio"){
            o.prop('checked',true);
            if(o.val() == "1"){
                $("#arbitralInstitution").parent().show();
            }else if(o.val() == "0"){
                $("#arbitralInstitution").val('');
                $("#arbitralInstitution").parent().hide();
            }else{
                o.click();
            }
        }else if(type=="checkbox"){

            if($("#"+_id).attr('checked')) {
                o.attr('checked', false);
            } else {
                o.attr('checked', true);
            }
            o.click();
        }
    }

    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
    function laySomenType(ty,idx,msg,times){//ty:layer类型，如0打开遮盖，1消息提示，2关闭遮盖层；win_sign:当前0内嵌或1外嵌
        if(win_sign == 0){//本站内嵌
            if(ty==0){//打开遮盖
                return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    layer.msg(msg);
                }else{
                    layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                layer.close(idx);
            }
        }else{//它站内嵌
            if(ty==0){//打开遮盖
                return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    layer.msg(msg);
                }else{
                    layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                layer.close(idx);
            }
        }
        return null;
    }
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>