<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
	<title>${productDto.product_name}</title>
</head>
<body>

<!--产品详情页内容-->
<div class="product-particulars sqe">
	<div class="partic-place">
		<p id="bread_crumbs">
		</p>
		<ul class="clearfix" id="nav">
			<li class="current">
				<a href="#section-1">产品详情</a>
			</li>
			<li>
				<a href="#section-2">投保须知</a>
			</li>
			<li>
				<a href="#section-3">典型案例</a>
			</li>
			<li>
				<a href="#section-4">保险条款</a>
			</li>
			<li>
				<a href="#section-5">理赔流程</a>
			</li>
			<li>
				<a href="#section-6">常见问题</a>
			</li>
		</ul>
	</div>
	<div class="partic-content clearfix">
		<div class="partic-left fl">
			<div class="sed insur-content" id="section-1">
				<!--<div class="insur-logo">-->
				<!--<img src="<c:url value='/resources/version_new/images/taikang-green.png' />">-->
				<!--</div>-->
				<div class="insur-head clearfix">
					<p class="fl">${productDto.product_name}</p>
					<div class="insur-share fr">
                        <span class="fl">
                            <i>￥</i>
                            <em><fmt:formatNumber type="number" value="${productDto.premium_min/3 }" maxFractionDigits="0"/></em>
                        </span>
						<a href="javascript:;" class="share-more fl copyPathToShare">立即分享</a>
						<c:if test="${productDto.p_status eq '0'}">
							<a href="javascript:;" onclick="layer.alert('该产品目前已下架，请选择其它产品！', {skin: 'layui-layer-lan',closeBtn: 0,anim: 4});" class="insur-buy fl insur-buy-gray">立即购买</a>
						</c:if>
						<c:if test="${productDto.p_status eq '1'}">
                        	<a href="<c:url value='/api/gmr/policyInit/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl">立即购买</a>
						</c:if>
					</div>
				</div>
				<input type="hidden" id="fe_text" value=""/>
				<ul class="insur-label clearfix">
					<c:if test="${fn:contains(productDto.product_label,',')}">
						<c:forEach items="${fn:split(productDto.product_label,',')}" var="lables">
							<li>${lables}</li>
						</c:forEach>
					</c:if>
					<c:if test="${fn:contains(productDto.product_label,' ')}">
						<c:forEach items="${fn:split(productDto.product_label,' ')}" var="lables">
							<li>${lables}</li>
						</c:forEach>
					</c:if>
				</ul>
				<p class="insur-p" id="insur-p-p">
				</p>
				<table cellspacing="0" cellpadding="0" class="wed">
					<tbody>
					<tr>
						<td>
							<span>保险公司</span>
						</td>
						<td>
							<span class="grey">${productDto.insurance_name}</span>
						</td>
						<td>
							<span>保险金额</span>
						</td>
						<td>
							<span class="grey">30万元</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>适用范围</span>
						</td>
						<td>
							<span class="grey">${productDto.scope}</span>
						</td>
						<td>
							<span>限购份数</span>
						</td>
						<td>
							<span class="grey">1份</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>保单形式</span>
						</td>
						<td>
							<span class="grey">${productDto.from_of_policy}</span>
						</td>
						<td>
							<span>缴费期间</span>
						</td>
						<td>
							<span class="grey">${productDto.payment_way eq '1' ? '一次性' : productDto.payment_way eq '2' ? '分期' : productDto.payment_way eq '1,2' ? '一次性或分期' : '-'}</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>保障期限</span>
						</td>
						<td>
							<span class="grey">一年</span>
						</td>
						<td>
							<span>保费</span>
						</td>
						<td>
							<span class="grey"><fmt:formatNumber type="number" value="${productDto.premium_min/3 }" maxFractionDigits="0"/>元/人</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>承保年龄</span>
						</td>
						<td colspan="3">
							<span class="grey">18-65周岁</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>承保职业</span>
						</td>
						<td colspan="3">
							<span class="grey">保安服务业</span>
						</td>
					</tr>
					<%--<tr>
						<td>
							<span>性别</span>
						</td>
						<td colspan="3">
							<span class="grey">男/女</span>
						</td>
					</tr>--%>
					</tbody>
				</table>
				<div class="insur-plan clearfix">
                    <span class="fl plan">
                        保险计划
                    </span>
					<ul class="clearfix fl" id="bx_jh">
					</ul>
				</div>
				<div class="security-content">
					<p class="clearfix">
						<i class="fl"></i>
						<span class="fl">保障内容</span>
					</p>
					<table cellspacing="0" cellpadding="0">
						<thead>
						<tr>
							<th>
								<span>保障责任</span>
							</th>
							<th width="320">
								<span>保障说明</span>
							</th>
							<th>
								<c:set var="irp_1" value="${ productDto.responsibilityVoList[0] }"></c:set>
								<c:choose>
									<c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
										<span>保险金额</span>
									</c:when>
									<c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
										<span>赔偿限额</span>
									</c:when>
									<c:otherwise>
										<span>保险金额</span>
									</c:otherwise>
								</c:choose>
							</th>
							<th>
								<span>免赔额</span>
							</th>
							<th>
								<span>赔付比例</span>
							</th>
							<th>
								<span>免赔天数</span>
							</th>
						</tr>
						</thead>
						<tbody>
						<c:forEach items="${ productDto.responsibilityVoList }" var="irp">
							<tr class="bg-3f">
								<td class="ert">${irp.name}</td>
								<td class="text">
									<span>${irp.explain_product}</span>
								</td>
								<td>
									<c:choose>
										<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
										</c:when>
										<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
										</c:when>
										<c:otherwise>
											<span>-</span>
										</c:otherwise>
									</c:choose>
								</td>
								<td>
									<span>${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</span>
								</td>
								<td>
									<span>${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</span>
								</td>
								<td>
									<span>${empty irp.deductible_days ? '-' : irp.deductible_days}</span>
								</td>
							</tr>
						</c:forEach>
						</tbody>
					</table>
				</div>
			</div>
			<div class="sed insur-informa" id="section-2">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">投保须知</span>
				</h2>
				<p id="section-p-2">
					<c:if test="${fn:contains(productDto.notice_mod,'<p>')}">
						${fn:replace(fn:replace(fn:replace(fn:replace(fn:replace(productDto.notice_mod, '<br>', ''), '<br/>', ''), '<p></p>', ''), '<p>', ''), '</p>', '<br/>')}
					</c:if>
					<c:if test="${fn:contains(productDto.notice_mod,'<div>')}">
						${fn:replace(fn:replace(fn:replace(fn:replace(fn:replace(productDto.notice_mod, '<br>', ''), '<br/>', ''), '<div></div>', ''), '<div>', ''), '</div>', '<br/>')}
					</c:if>
				</p>
			</div>
			<div class="sed insur-case" id="section-3">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">典型案例</span>
				</h2>
				${productDto.sample_mod}
			</div>
			<div class="sed insur-clause" id="section-4">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">保险条款</span>
				</h2>
				<ul>
					<h2 style="font-size: 14px">特别提醒：保险责任请参考以下条款，并敬请特别留意条款中的<span style="color: red ;font-size: 14px" >"责任免除"</span>部分。</h2>
					<c:if test="${not empty productDto.pro_clauses}">
						<c:forEach items="${fn:split(productDto.pro_clauses, '#')}" var="pcs">
							<li>
								<a target="_blank" href="<c:url value='/weixin/product/clause/${fn:split(pcs, "::")[0]}' />">${fn:split(pcs, "::")[1]}</a>
								<div class="clause-cic"></div>
							</li>
						</c:forEach>
					</c:if>
				</ul>
			</div>
			<div class="sed claims-process" id="section-5">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">理赔流程</span>
				</h2>
				<div class="claims-content">
					<div class="content-img">
						<img src="<c:url value='/resources/version_new/images/claims.png'/>" alt="理赔流程图">
					</div>
					<ul class="clearfix">
						<li>
							<p>拨打报案电话</p>
							<span>根据保单信息拨打相应保险公司报案电话或拨打平台报案电话400-662-9696或根据平台要求在线填写信息</span>
						</li>
						<li class="wer">
							<p>准备材料</p>
							<span>根据服务人员告知的资料清单准备理赔资料</span>
						</li>
						<li class="wed">
							<p>理赔办理</p>
							<span>前往保险公司提交理赔资料</span>
						</li>
						<li>
							<p>审核</p>
							<span>保险公司审核理赔材料</span>
						</li>
						<li class="jie">
							<p>结案</p>
							<span>确属保险责任范围的事故，保险公司将在约定时效内赔付</span>
						</li>
					</ul>
				</div>
			</div>
			<div class="sed common-problems" id="section-6">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">常见问题</span>
				</h2>
				<ul id="section-6-p">
					${productDto.faq_mod}
					<%--<li>
						<h3>有必要给保安人员买团体意外险吗？</h3>
						<p>首先，国务院颁布的《保安服务管理条例》中，第二十条明确规定“保安从业单位应当根据保安服务岗位的风险程度为保安员投保意外伤害保险。”同时，保安工作较一般工作风险性高，为保安人员投保团体意外险，即可保障保安人员人身损伤，又可转移保安从业单位的管理风险。</p>
					</li>
					<li>
						<h3>电子保单靠谱吗？</h3>
						<p>根据《中华人民共和国合同法》第十一条规定，数据电文是合法的合同表现形式，电子保单与纸质保单具有同等法律效力。</p>
					</li>
					<li>
						<h3>最少可以多少人起投保？</h3>
						<p>该产品最低投保人数为3人。</p>
					</li>
					<li>
						<h3>如何查询验证保单？</h3>
						<p>投保完成后,您可在账户内查看下载电子保单。为保证您的合法权益,您可通过访问泰康在线保险网址<a href="http://www.tk.cn" target="_blank">http://www.tk.cn</a>或拨打客户服务热线4000095522,对您所投保保单的相关信息进行查询。</p>
					</li>
					<li>
						<h3>信息或人员变化后能够在线修改？</h3>
						<p>在保险期间内，我们提供在线变更投保信息及人员增、减、替换服务，您可在保单服务里提交批改申请，由保险公司后台快速审核通过。</p>
					</li>
					<li>
						<h3>可以在什么医院就诊？</h3>
						<p>保险公司指定医院或国家卫生部医院等级分类中的二级或二级以上的医院,但不包括主要作为康复、护理、疗养、戒酒、戒毒或相类似的医疗机构。</p>
					</li>--%>
				</ul>
			</div>

		</div>
		<div class="partic-right fr">
			<jsp:include page="../../../index/multi_ins_intro.jsp"/>
			<jsp:include page="../../../index/multi_hot_product_iframe.jsp"/>
		</div>
	</div>
</div>

<!--滚动轴滚动一定距离后出现固定导航栏-->
<div class="product-wed">
	<div class="wed-content">
		<ul class="clearfix" id="nav-more">
			<li class="current">
				<a href="#section-1">产品详情</a>
			</li>
			<li>
				<a href="#section-2">投保须知</a>
			</li>
			<li>
				<a href="#section-3">典型案例</a>
			</li>
			<li>
				<a href="#section-4">保险条款</a>
			</li>
			<li>
				<a href="#section-5">理赔流程</a>
			</li>
			<li>
				<a href="#section-6">常见问题</a>
			</li>
		</ul>
		<div class="share-buy fr">
            <span class="fl">
                 <i>保费</i>
                 <b>￥</b>
                 <em><fmt:formatNumber type="number" value="${productDto.premium_min/3 }" maxFractionDigits="0"/></em>
            </span>
			<a href="javascript:;" class="share-more fl copyPathToShare">立即分享</a>
			<c:if test="${productDto.p_status eq '0'}">
				<a href="javascript:;" onclick="layer.alert('该产品目前已下架，请选择其它产品！', {skin: 'layui-layer-lan',closeBtn: 0,anim: 4});" class="insur-buy fl insur-buy-gray">立即购买</a>
			</c:if>
			<c:if test="${productDto.p_status eq '1'}">
				<c:choose>
					<c:when test="${not empty userdetail ? ('BLB' eq userdetail.web_type) : true }">
						<a href="<c:url value='/insurance/gmr/policy/policyInit_iframe/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl iframe-buy">立即购买</a>
					</c:when>
					<c:otherwise>
						<a href="<c:url value='/api/gmr/policyInit/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl">立即购买</a>
					</c:otherwise>
				</c:choose>
			</c:if>
		</div>
	</div>
</div>

<!--产品链接复制弹出框-->
<div class="link-share">
	<h2 class="clearfix">提示
		<span id="link-close">
            <img src="<c:url value='/resources/version_new/images/link-close.png' />">
        </span>
	</h2>
	<div class="link-success">
		<p>
			<img src="<c:url value='/resources/version_new/images/link-success.png' />">
			<span>产品链接已复制！您可以将它分享给其他人。</span>
		</p>
		<a href="javascript:;" id="link-zhi">我知道了</a>
	</div>
</div>

<!--弹出框透明蒙板-->
<div class="link-mask"></div>

<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/login.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.nav.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/clipboard.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script>
    $(function(){

        //计划的切换
        $('.insur-plan ul li').click(function () {
            $('.insur-plan ul li').removeClass('on');
            $(this).addClass('on');
        });
        //点击复制链接
        var s_url = '${sharePath }';

        var clipboard = new Clipboard('.copyPathToShare', {
            text: function() {
                return s_url;
            }
        });

        clipboard.on('success', function(e) {
            $('.link-share').show();
            $('.link-mask').show();
        });
        $('#link-close').click(function () {
            $('.link-share').hide();
            $('.link-mask').hide();
        });

        $('#link-zhi').click(function () {
            $('.link-share').hide();
            $('.link-mask').hide();
        });
        $("#insur-p-p").html('· '+'${productDto.intro}'.replace(/<.*?>/ig,''));
        $("#section-3").find("p").each(function(){
            $(this).html($(this).html().replace(/<.*?>/ig,''));
            $(this).attr("class","case-one");
        });
        $("#section-6-p").html(function(){
            var c=1;
            var lis = '';
            $("#section-6-p").find("p").each(function(){
                var htl = $(this).html().replace(/<.*?>/ig,'');
                if(htl != '' && htl != '&nbsp;' && htl != ' '){
                    if(c % 2 == 1){
                        lis = lis + '<li><h3>'+htl+'</h3>';
                    }else{
                        lis = lis + '<p>'+htl+'</p></li>';
                    }
                    c++;
                }
            });
            return lis;
        });
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas('',baseUrl+'/synopsis/product/productListByCode/TYX-TK',true,false,function(data){
            var _hs = '';
            $.each(data, function(i, obj){
                if(obj.product_code != ''&&obj.product_code!=null&&obj.product_code!=undefined){
                    if(obj.product_code.indexOf('TYX-TK')!=-1){
                        var sg = obj.product_code.split('-')[obj.product_code.split('-').length-1];
                        var _u = baseUrl + "/api/gmr/product/productInfo/" + obj.oid;
                        var _liC;
                        if('${productDto.oid}' == obj.oid){
                            _liC = "class='on'";
                        }else{
                            _liC = "onclick='javascript:location.href=\""+_u+"\";'";
                        }
                        _hs = _hs + "<li "+_liC+"><span>"+ getName(sg) +"</span><div class='plan-gou'></div></li>";
                    }
                }
            });
            if(_hs != ''){
                $("#bx_jh").html(_hs);
            }
        });
    });
    function getName(_num){
        return _num == '1' ? '计划一' : _num == '2' ? '计划二' : _num == '3' ? '计划三' : _num == '4' ? '计划四' : _num == '5' ? '计划五' : _num == '6' ? '计划六' : _num == '7' ? '计划七' : _num == '8' ? '计划八' : _num == '9' ? '计划九' : '';
    }
</script>
</body>
</html>
