<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
	<title>${productDto.product_name}</title>
</head>
<body style="overflow-y: hidden">

<!--产品详情页内容-->
<div class="product-particulars sqe">
	<div class="partic-place">
		<p>			当前位置: <a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />">首页</a> > <a target="_blank" href="<c:url value='/synopsis/product/productAllView?ACCESS_TOKEN=${ACCESS_TOKEN}' />">产品列表</a> > <span id="place">产品详情</span>
        </p>
		<ul class="clearfix" id="nav">
			<li class="current">
				<a href="#section-1">产品详情</a>
			</li>
			<li>
				<a href="#section-2">投保须知</a>
			</li>
			<li>
				<a href="#section-3">典型案例</a>
			</li>
			<li>
				<a href="#section-4">保险条款</a>
			</li>
			<li>
				<a href="#section-5">理赔流程</a>
			</li>
			<li>
				<a href="#section-6">常见问题</a>
			</li>
		</ul>
	</div>
	<div class="partic-content clearfix">
		<div class="partic-left fl">
			<div class="insur-content sed" id="section-1">
				<!--<div class="insur-logo">-->
				<!--<img src="<c:url value='/resources/version_new/images/taikang-green.png' />">-->
				<!--</div>-->
				<div class="insur-head clearfix">
					<p class="fl">${productDto.product_name}</p>
					<div class="insur-share fr">
                        <span class="fl">
                            <i>￥</i>
                            <em>${productDto.premium_min } 起</em>
                        </span>
						<a href="javascript:;" class="share-more fl copyPathToShare">立即分享</a>
						<c:if test="${ not empty userdetail}">
							<a href="<c:url value='/api/afr/policyInit/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl">立即购买</a>
						</c:if>
						<c:if test="${empty userdetail}">
							<a href="#"  onclick="parent.reloadLogin('${url}')" data-pro-id="${productDto.oid }" class="insur-buy fl">立即购买</a>
						</c:if>
					</div>
				</div>
				<input type="hidden" id="fe_text" value=""/>
				<ul class="insur-label clearfix">
					<c:if test="${fn:contains(productDto.product_label,',')}">
						<c:forEach items="${fn:split(productDto.product_label,',')}" var="lables">
							<li>${lables}</li>
						</c:forEach>
					</c:if>
					<c:if test="${fn:contains(productDto.product_label,' ')}">
						<c:forEach items="${fn:split(productDto.product_label,' ')}" var="lables">
							<li>${lables}</li>
						</c:forEach>
					</c:if>
				</ul>
				<p class="insur-p" id="insur-p-p">
				</p>
				<table cellspacing="0" cellpadding="0" class="wed">
					<tbody>
					<tr>
						<td>
							<span>保险公司</span>
						</td>
						<td>
							<span class="grey">${productDto.insurance_name}</span>
						</td>
						<td>
							<span>保险金额</span>
						</td>
						<td>
							<span class="grey">视情况而定</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>适用范围</span>
						</td>
						<td>
							<span class="grey">${productDto.scope}</span>
						</td>
						<td>
							<span>限购份数</span>
						</td>
						<td>
							<span class="grey">1份</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>保单形式</span>
						</td>
						<td>
							<span class="grey">纸质保单/电子保单</span>
						</td>
						<td>
							<span>缴费期间</span>
						</td>
						<td>
							<span class="grey">${productDto.payment_way eq '1' ? '一次性' : productDto.payment_way eq '2' ? '分期' : productDto.payment_way eq '1,2' ? '一次性或分期' : '-'}</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>保障期限</span>
						</td>
						<td>
							<span class="grey">视情况而定</span>
						</td>
						<td>
							<span>保费</span>
						</td>
						<td>
							<span class="grey">视情况而定</span>
						</td>
					</tr>
					<%--<tr>
						<td>
							<span>承保年龄</span>
						</td>
						<td colspan="3">
							<span class="grey">18-65岁</span>
						</td>
					</tr>--%>
				<%--	<tr>
						<td>
							<span>承保职业</span>
						</td>
						<td colspan="3">
							<span class="grey">保安服务业</span>
						</td>
					</tr>--%>
					<%--<tr>
                        <td>
                            <span>性别</span>
                        </td>
                        <td colspan="3">
                            <span class="grey">男/女</span>
                        </td>
                    </tr>--%>
					</tbody>
				</table>

				<div class="security-content">
					<p class="clearfix">
						<i class="fl"></i>
						<span class="fl">保障内容</span>
					</p>
					<table cellspacing="0" cellpadding="0">
						<thead>
						<tr>
							<th>
								<span>保障责任</span>
							</th>
							<th width="190">
								<span>保障说明</span>
							</th>
							<th width="320">
								<span>保险金额</span>
							</th>
							<th width="100">
								<span>免赔额</span>
							</th>
							<th width="60">
								<span>赔付比例</span>
							</th>
							<th width="60">
								<span>免赔天数</span>
							</th>
						</tr>
						</thead>
						<tbody>
						<c:forEach items="${ productDto.responsibilityVoList }" var="irp">
							<tr class="bg-3f">
								<td class="ert" style="font-size: 14px;">${irp.name}</td>
								<td class="text">
									<span style="font-size: 14px;">${irp.explain_product}</span>
								</td>
								<td style="text-align: left">
									<span style="font-size: 14px;">

										活动人数≤5000人
										<br>
										每人每次赔偿限额：25万
										<br>
										每次事故及累计限额：人民币500万≤累计赔偿限额＜人民币1000万
										<br>
										活动人数：5001-10000
										<br>
										每人每次赔偿限额：25万
										<br>
										每次事故及累计限额：人民币1000万≤累计赔偿限额＜人民币1500万
										<br>
										活动人数：10001-50000
										<br>
										每人每次赔偿限额：25万
										<br>
										每次事故及累计限额：人民币1500万≤累计赔偿限额＜人民币2000万
										<br>
										活动人数：50000以上
										<br>
										每人每次赔偿限额：25万
										<br>
										每次事故及累计限额：人民币2000万≤累计赔偿限额＜人民币3500万
									</span>
								</td>
								<td>
									<span style="font-size: 14px;">财产损失500元免赔，人身伤害0免赔</span>
								</td>
								<td>
									<span style="font-size: 14px;">100.0%</span>
								</td>
								<td>
									<span style="font-size: 14px;">-</span>
								</td>
							</tr>
						</c:forEach>
						</tbody>
					</table>
				</div>
			</div>
			<div class="insur-informa sed" id="section-2">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">投保须知</span>
				</h2>
				<p>
					1. 本产品由华泰财产保险有限公司承保,目前该公司在北京、上海、天津、重庆、
					江苏、广东、陕西、四川、云南、辽宁、浙江、河北、湖南、湖北、安徽、
					山西、福建、山东、广西、河南、江西、深圳、青岛、大连、宁波、贵州、
					内蒙古、厦门、黑龙江、新疆设有分支机构。客户从本平台购买,后续理赔等
					相关事务均可由我们协助您办理。<br>
					2. 本产品为网络销售的保险产品组合计划，网上投保、网上支付、网上即时核保并出具保险凭证，您可拨打
					华泰保险公司电话4006095509查询、验真。<br>
					3. 本产品提供电子保单，也可根据客户需要提供纸质保单。<br>
					4. 本产品在网上投保申请后，最早次日零时生效。<br>
					5. 造成受害人人身伤害的，应提供二级以上（含二级）医疗机构出具的受害人
					的病历、诊断证明、医疗费等医疗单据。<br>
					6. 本产品项下免赔额为：财产损失500元，人身伤害无免赔。<br>
					7. 文艺演出类活动一般指面对观众的现场表演活动，通常是音乐、演唱、舞蹈的表演，包括演唱会、巡回音乐会、新年音乐会等。<br>
					8. 投保人所填写及告知内容，将作为保险公司签发保险单的依据及列为保险合
					同的组成部分，须保证属实。如投保人有隐瞒或者告知不实，保险公司有权
					解除保险合同，并不承担任何责任。<br>
				</p>
			</div>
			<div class="insur-case sed" id="section-3">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">典型案例</span>
				</h2>
				<p class="case-one">
					上海某传媒公司在上海体育中心主办明星演唱会，考虑到演唱会期间人多且流动性大存在一定风险，于是在平台购买了一份华泰文艺演出类公众责任险，保费3000元，在保险期间内，被保险人享有以下保障权益：</br>
					每人每次事故赔偿限额25万</br>
					每次事故及累计限额：人民币500万≤累计赔偿限额＜人民币1000万</br>
					在保险期间内活动现场发生人员踩踏，造成观众A某（41岁）重伤住院10天，在合理用药范围内花费医疗费用3万元，且治疗结束后被鉴定为9级伤残（赔偿比例20%），根据上海城镇居民人均可支配收入、伤残鉴定标准等评定需给付残疾赔偿金54305元*20年*20%=217220元；观众B某中度受伤住院5天。以上损失经依法认定应由上海某传媒公司承担赔偿。</br>
					保险公司经核实符合保险责任范围，做出如下赔付：重伤人员A某获赔伤残补偿（9级，伤残比例20%）21.722万，医疗费用3万以及误工费用0.2万，合计24.922万元（未超过每人每次赔偿限额）；受伤人员B某获赔医疗费用1万以及误工费用0.1万，合计1.1万元；保险公司总计赔付26.022万元。</br>
			</div>
			<div class="insur-clause sed" id="section-4">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">保险条款</span>
				</h2>
				<ul>
					<h2 style="font-size: 14px">特别提醒：保险责任请参考以下条款，并敬请特别留意条款中的<span style="color: red ;font-size: 14px" >"责任免除"</span>部分。</h2>
					<li>
						<a target="_blank" href="<c:url value='/resources/files/华泰公众责任险条款.pdf' />">华泰公责险保险条款</a>
						<div class="clause-cic"></div>
					</li>
				</ul>
			</div>
			<div class="claims-process sed" id="section-5">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">理赔流程</span>
				</h2>
				<div class="claims-content">
					<div class="content-img">
						<img src="<c:url value='/resources/version_new/images/claims.png'/>" alt="理赔流程图">
					</div>
					<ul class="clearfix">
						<li>
							<p>拨打报案电话</p>
							<span>根据保单信息拨打相应保险公司报案电话或拨打平台报案电话400-662-9696或根据平台要求在线填写信息</span>
						</li>
						<li class="wer">
							<p>准备材料</p>
							<span>根据服务人员告知的资料清单准备理赔资料</span>
						</li>
						<li class="wed">
							<p>理赔办理</p>
							<span>提交理赔资料</span>
						</li>
						<li>
							<p>审核</p>
							<span>保险公司审核理赔材料</span>
						</li>
						<li class="jie">
							<p>结案</p>
							<span>确属保险责任范围的事故，保险公司将在约定时效内赔付</span>
						</li>
					</ul>
				</div>
			</div>
			<div class="common-problems sed" id="section-6">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">常见问题</span>
				</h2>
				<ul>
					<li>
						<h3>有必要买大型活动公众责任保险吗？</h3>
						<p>大型活动存在人员踩踏风险（因参加人数多诱发）、火灾风险（因消防措施不严密等造成）、临建倒塌风险（因临建设施不牢固等导致）、施工人员意外风险（因操作失误或其它意外导致），作为活动主办方或承办方，对于这些风险可能造成的损失有不可推卸的赔偿责任，而大型活动公众责任保险则可有效转嫁主办方或承办方的赔偿风险。目前多个省市公安机关已发文要求或鼓励大型群众性活动承办者投保公众责任险等保险。</p>
					</li>
					<li>
						<h3>如何查询验证保单？</h3>
						<p>投保完成后,您可在账户内查看下载保单扫描件。为保证您的合法权益,您可拨打客户服务热线4006095509,对您所投保保单的相关信息进行查询。 </p>
					</li>
					<li>
						<h3>保障时间仅为活动举办期间么？</h3>
						<p>客户可自由选择保障期限：既可按照活动举办期间投保；也可自活动临建设施搭建时起保至活动结束临建设施拆卸完毕终止，覆盖整个大型活动期间。</p>
					</li>
					<li>
						<h3>保障是否包含火灾、爆炸、急救责任呢？</h3>
						<p>该保险除对生产、经营等活动以及由于意外事故造成的第三者的人身/财产损失、合理必要费用进行保障外，还附加了交叉责任条款、罢工、暴乱、民众骚动及恶意破坏条款、火灾和爆炸责任条款、急救费用条款、广告及装饰装置责任条款，为大型活动承办方提供全方位的保障。</p>
					</li>
					<li>
						<h3>每人每次事故赔偿限额25万元，医疗与财产损失是否有限额？</h3>
						<p>每人每次事故赔偿限额25万是指每人每次事故人伤与财产损失赔偿金合计以25万元为限，医疗或财产损失赔偿金没有单独限制，这样能更好地根据实际情况充分利用赔偿限额，使被保险人利益最大化，充分转移大型活动承办方的风险。</p>
					</li>
				</ul>
			</div>

		</div>
		<div class="partic-right fr">
			<jsp:include page="../../../index/multi_ins_intro.jsp"/>
			<jsp:include page="../../../index/multi_hot_product_iframe.jsp"/>
		</div>
	</div>
</div>

<!--滚动轴滚动一定距离后出现固定导航栏-->
<div class="product-wed">
	<div class="wed-content">
		<ul class="clearfix" id="nav-more">
			<li class="current">
				<a href="#section-1">产品详情</a>
			</li>
			<li>
				<a href="#section-2">投保须知</a>
			</li>
			<li>
				<a href="#section-3">典型案例</a>
			</li>
			<li>
				<a href="#section-4">保险条款</a>
			</li>
			<li>
				<a href="#section-5">理赔流程</a>
			</li>
			<li>
				<a href="#section-6">常见问题</a>
			</li>
		</ul>
		<div class="share-buy fr">
            <span class="fl">
                 <i>保费</i>
                 <b>￥</b>
                 <em>${productDto.premium_min }</em>
            </span>
			<a href="javascript:;" class="share-more fl copyPathToShare">立即分享</a>
			<c:if test="${ not empty userdetail}">
				<a href="<c:url value='/api/afr/productInitIframe?url=/api/afr/policyInit/${productDto.oid }%3FrecommendCode=${recommendCode}&product_id=${productDto.oid }' />" class="insur-buy fl">立即购买</a>
			</c:if>
			<c:if test="${empty userdetail}">
				<a href="#"  onclick="parent.reloadLogin('${url}')" data-pro-id="${productDto.oid }" class="insur-buy fl">立即购买</a>
			</c:if>

		</div>
	</div>
</div>

<!--产品链接复制弹出框-->
<div class="link-share">
	<h2 class="clearfix">提示
		<span id="link-close">
            <img src="<c:url value='/resources/version_new/images/link-close.png' />">
        </span>
	</h2>
	<div class="link-success">
		<p>
			<img src="<c:url value='/resources/version_new/images/link-success.png' />">
			<span>产品链接已复制！您可以将它分享给其他人。</span>
		</p>
		<a href="javascript:;" class="link-zhi">我知道了</a>
	</div>
</div>

<!--弹出框透明蒙板-->
<div class="link-mask"></div>

<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/login.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.nav.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/clipboard.min.js' />"></script>

<script>
	window.onload = function () {
		var s = $('.product-particulars').height();
		var sd = s + 60;
		$('#frame3d',parent.document).css("height",sd+'px');
	}
</script>
</body>
</html>
