package com.bcxin.ins.weixin.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.weixin.order.service.WeiXinOrderService;
import com.bcxin.ins.weixin.util.CTLUtil;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/***/
@Controller
@RequestMapping("${weixin}/order")
@Lazy(false)
public class WeiXinOrderController extends BaseController {

	private static Logger log = LoggerFactory.getLogger("");
	/** */
	private static final String INDEX = getViewPath("weixin/order/");
	private static final String DETAIL = getViewPath("weixin/order/order_detail");

	@Autowired
	private WeiXinOrderService weiXinOrderService;
	@Autowired
	private InsTransactionAPIService insTransactionAPIService;

	/** 统一页面 */
	@RequestMapping(value = "/{index}")
	public String login(Model model, @RequestParam Map<Object,Object> params , @PathVariable String index) {
		model.addAttribute("p",params); return INDEX+index;
	}

	/** 订单详情页面 */
	@RequestMapping(value = "/detail")
	public  String detail(Model model, @RequestParam Map<Object,Object> params ) {
		Map<Object,Object> p = CTLUtil.initWX(getRequest(),params);
		model.addAttribute("p",params);
		model.addAttribute("row",weiXinOrderService.queryDetailVoBySlipID(p,getRequest()));
		return DETAIL;
	}


	/** 展责险系列投保订单页面 */
	@RequestMapping(value = "/zzx/{jsppage}")
	public String writeOrder1(Model model, @RequestParam Map<Object,Object> params ,  @PathVariable String jsppage) {
		Map<Object,Object> p = CTLUtil.initWX(getRequest(),params);
		if(p.get("ins_insurance_slip_id")!=null || "".equals(String.valueOf(p.get("ins_insurance_slip_id")).trim())){
			Map<Object, Object> row = weiXinOrderService.queryDetailVoBySlipID(p, getRequest());
			model.addAttribute("row", row);
			Map special = (Map)row.get("special");
			String ai = (String)special.get("activity_id");
			if(getRequest().getSession().getAttribute("ywzc_activity_info") == null && StringUtils.isNotEmpty(ai)){
				//发起request请求，获取参数
				String result = HttpUtil.get(String.valueOf(GlobalResources.map.get("YWZC_URL"))+"/weixin/no/getActivity?id="+ai);
				Map localParam = JSON.parseObject(result,Map.class);
				logger.info("获得的参数"+JSON.toJSONString(localParam));
				getRequest().getSession().setAttribute("ywzc_activity_info", localParam);//保存分享链接的参数
			}

//			logger.info("得到的订单数据是："+JSON.toJSONString(obj));
		}else{
			Object obj = getRequest().getSession().getAttribute("ins_insurance_slip_id");
			if(obj!=null) p.put("ins_insurance_slip_id",obj);
		}
		model.addAttribute("p", p);
		model.addAttribute("ywzc_activity_info",getRequest().getSession().getAttribute("ywzc_activity_info"));
		return INDEX+"zzx/"+jsppage;
	}

	/** */
	@RequestMapping("/query")
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , Model model){
		CTLUtil.out(weiXinOrderService.query(CTLUtil.initWX(getRequest(),params)),getResponse()); return null;
	}

	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_ORDER,title ="【请求】微信-订单投保")
	@RequestMapping("/save/applicant")
	public @ResponseBody Object applicant(@RequestParam Map<Object,Object> params, Model model) {
		return weiXinOrderService.applicant(CTLUtil.initWX(getRequest(),params),getRequest());
	}
	@RequestMapping("/save/insurant")
	public @ResponseBody Object saveInsurant(@RequestParam Map<Object,Object> params, Model model) {
		return weiXinOrderService.saveInsurant(CTLUtil.initWX(getRequest(),params),getRequest());
	}
	@RequestMapping("/save/special")
	public @ResponseBody Object saveSpecial(@RequestParam Map<Object,Object> params, Model model) {
		return weiXinOrderService.saveSpecial(CTLUtil.initWX(getRequest(),params),getRequest());
	}
	/** 发票 、 纸质保单*/
	@RequestMapping("/save/insMailPolicy")
	public @ResponseBody Object insMailPolicy(@RequestParam Map<Object,Object> params, Model model) {
		return weiXinOrderService.insMailPolicy(CTLUtil.initWX(getRequest(),params),getRequest());
	}

	/** 获取电子保单 */
	@RequestMapping(value = "/queryDZBD")
	public @ResponseBody Object queryDZBD(Model model, @RequestParam Map<Object,Object> params  ) {
		Map<Object,Object> p = CTLUtil.initWX(getRequest(),params);
		CTLUtil.out(weiXinOrderService.queryDZBDBySlipID(p),getResponse());
		return null;
	}

	/** 测试用 */
	@RequestMapping(value = "/detail/debug")
	public @ResponseBody Object detailDebug(Model model, @RequestParam Map<Object,Object> params  ) {
		Map<Object,Object> p = CTLUtil.initWX(getRequest(),params);
		CTLUtil.out(weiXinOrderService.queryDetailVoBySlipID(p,getRequest()),getResponse());
		return null;
	}

	/**
	 * <b> 平安财展责险，跳转支付页面方法 </b>
	 * @author ZXF
	 * @create 2018/01/03 0003 13:55
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping(value = "/zzx/payment_pac/{oid}")
	public  String detail(Model model, @PathVariable("oid") String oid ) {
		model.addAttribute("oid",oid);
		return INDEX+"zzx/policyPayment_PAC";
	}
	/**
	 * <b> 永安展责险，跳转支付页面方法 </b>
	 * @author ZXF
	 * @create 2018/01/03 0003 13:55
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping(value = "/zzx/payment_ya/{oid}")
	public  String payment_ya(Model model, @PathVariable("oid") long oid ) {
		List<InsTransaction> tList = insTransactionAPIService.selectInsTransactionByInsOrderForm(oid);
		if(tList.size()>0){
			String du = tList.get(0).getDeal_url();
			model.addAttribute("deal_url",du);
		}
		return INDEX+"zzx/policy_payment_ya";
	}


	////weixin/order/zzx/transaction/API_Underwriting（核保方法），/zaCheckstand（支付接口）
	/** 平安财展责险系列投保订单页面保存 */
	@RequestMapping("/save/saveLOTEOrder")
	public @ResponseBody Object saveLOTEOrder(LOTEPolicyVo vo, Model model) {
		return weiXinOrderService.pendingLOTEPolicyVoPolicy(vo, ConstProp.BLANK_CHAR);
	}

	/** 平安财展责险系列投保订单页面 */
	@RequestMapping(value = "/orderPage/{jsppage}")
	public String orderPage(Model model, @RequestParam Map<Object,Object> params ,  @PathVariable String jsppage) {
		Map<Object,Object> p = CTLUtil.initWX(getRequest(),params);
		if(p.get("ins_insurance_slip_id")!=null || "".equals(String.valueOf(p.get("ins_insurance_slip_id")).trim())){
			model.addAttribute("row", weiXinOrderService.queryDetailVoBySlipID(p,getRequest()));
		}else{
			Object obj = getRequest().getSession().getAttribute("ins_insurance_slip_id");
			if(obj!=null) p.put("ins_insurance_slip_id",obj);
		}
		model.addAttribute("p", p);
		model.addAttribute("ywzc_activity_info",getRequest().getSession().getAttribute("ywzc_activity_info"));
		return INDEX+"orderPage/"+jsppage;
	}

}