package com.bcxin.ins.weixin.util.weixin.process;


import com.bcxin.ins.weixin.util.weixin.entity.ReceiveXmlEntity;
import com.bcxin.ins.weixin.util.weixin.service.WeiXinService;
import com.bcxin.ins.weixin.util.weixin.util.AccessToken;
import com.bcxin.ins.weixin.util.weixin.util.MessageUtil;
import com.bcxin.ins.weixin.util.weixin.util.msg.Resp.Article;
import com.bcxin.mybatisplus.mapper.EntityWrapper;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 微信xml消息处理流程逻辑类
 *
 * @author 科帮网
 */
public class WechatProcess {


    /**
     * 解析处理xml、获取智能回复结果（通过图灵机器人api接口）
     *
     * @param xml 接收到的微信数据
     * @param weiXinService
     *@param
     */
    public String processWechatMag(String xml, WeiXinService weiXinService) {
        /** 解析xml数据 */
        ReceiveXmlEntity xmlEntity = new ReceiveXmlProcess().getMsgEntity(xml);
        /** 以文本消息为例，调用图灵机器人api接口，获取回复内容 */
        String result = "您好，欢迎关注百川信。百川信（厦门）网络信息服务有限公司是一家专注于风险管理领域的互联网公司，目前主要产品有：安全管理服务平台（PSS）、保安服务监管平台（百保盾）、金融保险（百联保）。欢迎致电客服热线 400-662-9696，了解更多服务。";
        result = new FormatXmlProcess().formatXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(), result);
        return result;
        /** 此时，如果用户输入的是“你好”，在经过上面的过程之后，result为“你也好”类似的内容
         *  因为最终回复给微信的也是xml格式的数据，所有需要将其封装为文本类型返回消息
         * */

    }
}
