package com.bcxin.ins.supply.owner.taibao.xiaowei.ybenum;

import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;

/**
 * <b> 邮编枚举，市级 </b>
 * @author ZXF
 * @create 2018/02/27 0027 16:01
 * @version
 * @注意事项 </b>
 */
public enum YbCity {

    C_010000 ("010000", "呼和浩特市", "IM"),
    C_012000 ("012000", "集宁市", "IM"),
    C_012600 ("012600", "二连浩特市", "IM"),
    C_014000 ("014000", "包头市", "IM"),
    C_015000 ("015000", "临河市", "IM"),
    C_016000 ("016000", "乌海市", "IM"),
    C_017000 ("017000", "东胜市", "IM"),
    C_021000 ("021000", "海拉尔市", "IM"),
    C_021400 ("021400", "满洲里市", "IM"),
    C_022150 ("022150", "牙克石市", "IM"),
    C_024000 ("024000", "赤峰市", "IM"),
    C_026000 ("026000", "锡林浩特市", "IM"),
    C_028000 ("028000", "通辽市", "IM"),
    C_029200 ("029200", "霍林郭勒市", "IM"),
    C_030000 ("030000", "太原市", "SX"),
    C_030200 ("030200", "古交市", "SX"),
    C_030600 ("030600", "榆次市", "SX"),
    C_033000 ("033000", "吕梁市", "SX"),
    C_034000 ("034000", "忻州市", "SX"),
    C_037000 ("037000", "大同市", "SX"),
    C_038500 ("038500", "朔州市", "SX"),
    C_041000 ("041000", "临汾市", "SX"),
    C_043000 ("043000", "侯马市", "SX"),
    C_044000 ("044000", "运城市", "SX"),
    C_045000 ("045000", "阳泉市", "SX"),
    C_046000 ("046000", "长治市", "SX"),
    C_048000 ("048000", "晋城市", "SX"),
    C_050000 ("050000", "石家庄市", "HB"),
    C_052360 ("052360", "辛集市", "HB"),
    C_053000 ("053000", "衡水市", "HB"),
    C_054000 ("054000", "邢台市", "HB"),
    C_054100 ("054100", "沙河市", "HB"),
    C_055750 ("055750", "南宫市", "HB"),
    C_056000 ("056000", "邯郸市", "HB"),
    C_056300 ("056300", "武安市", "HB"),
    C_061000 ("061000", "沧州市", "HB"),
    C_062150 ("062150", "泊头市", "HB"),
    C_062550 ("062550", "任丘市", "HB"),
    C_063000 ("063000", "唐山市", "HB"),
    C_065000 ("065000", "廊坊市", "HB"),
    C_066000 ("066000", "秦皇岛市", "HB"),
    C_066100 ("066100", "北戴河", "HB"),
    C_067000 ("067000", "承德市", "HB"),
    C_071000 ("071000", "保定市", "HB"),
    C_072750 ("072750", "涿州市", "HB"),
    C_073000 ("073000", "定州市", "HB"),
    C_074000 ("074000", "高碑店市", "HB"),
    C_075000 ("075000", "张家口市", "HB"),
    C_100000 ("100000", "北京市", "BJ"),
    C_110000 ("110000", "沈阳市", "LN"),
    C_111000 ("111000", "辽阳市", "LN"),
    C_112000 ("112000", "铁岭市", "LN"),
    C_112300 ("112300", "开原市", "LN"),
    C_112700 ("112700", "铁法市", "LN"),
    C_113000 ("113000", "抚顺市", "LN"),
    C_114000 ("114000", "鞍山市", "LN"),
    C_114200 ("114200", "海城市", "LN"),
    C_115000 ("115000", "营口市", "LN"),
    C_116000 ("116000", "大连市", "LN"),
    C_116300 ("116300", "瓦房店市", "LN"),
    C_117000 ("117000", "本溪市", "LN"),
    C_118000 ("118000", "丹东市", "LN"),
    C_121000 ("121000", "锦州市", "LN"),
    C_121200 ("121200", "凌海市", "LN"),
    C_121300 ("121300", "北宁市", "LN"),
    C_122000 ("122000", "朝阳市", "LN"),
    C_122100 ("122100", "北票市", "LN"),
    C_123000 ("123000", "阜新市", "LN"),
    C_124000 ("124000", "盘锦市", "LN"),
    C_125000 ("125000", "葫芦岛市", "LN"),
    C_125100 ("125100", "兴城市", "LN"),
    C_130000 ("130000", "长春市", "JL"),
    C_130500 ("130500", "九台市", "JL"),
    C_131200 ("131200", "扶余市", "JL"),
    C_131300 ("131300", "大安市", "JL"),
    C_132000 ("132000", "吉林市", "JL"),
    C_132400 ("132400", "桦甸市", "JL"),
    C_133000 ("133000", "延吉市", "JL"),
    C_133100 ("133100", "图们市", "JL"),
    C_133300 ("133300", "珲春市", "JL"),
    C_133400 ("133400", "龙井市", "JL"),
    C_133700 ("133700", "敦化市", "JL"),
    C_134000 ("134000", "通化市", "JL"),
    C_134200 ("134200", "集安市", "JL"),
    C_134300 ("134300", "浑江市", "JL"),
    C_134600 ("134600", "临江市", "JL"),
    C_135000 ("135000", "梅河口市", "JL"),
    C_136000 ("136000", "四平市", "JL"),
    C_136100 ("136100", "公主岭市", "JL"),
    C_136200 ("136200", "辽源市", "JL"),
    C_137000 ("137000", "白城市", "JL"),
    C_137100 ("137100", "洮南市", "JL"),
    C_137400 ("137400", "乌兰浩特市", "IM"),
    C_138000 ("138000", "松原市", "JL"),
    C_150000 ("150000", "哈尔滨市", "HLJ"),
    C_150100 ("150100", "双城市", "HLJ"),
    C_150300 ("150300", "阿城市", "HLJ"),
    C_150600 ("150600", "尚志市", "HLJ"),
    C_151100 ("151100", "肇东市", "HLJ"),
    C_151400 ("151400", "安达市", "HLJ"),
    C_152000 ("152000", "绥化市", "HLJ"),
    C_152300 ("152300", "海伦市", "HLJ"),
    C_152500 ("152500", "铁力市", "HLJ"),
    C_153000 ("153000", "伊春市", "HLJ"),
    C_154000 ("154000", "佳木斯市", "HLJ"),
    C_154100 ("154100", "鹤岗市", "HLJ"),
    C_154600 ("154600", "七台河市", "HLJ"),
    C_155100 ("155100", "双鸭山市", "HLJ"),
    C_156100 ("156100", "富锦市", "HLJ"),
    C_156400 ("156400", "同江市", "HLJ"),
    C_157000 ("157000", "牡丹江市", "HLJ"),
    C_157300 ("157300", "绥芬河市", "HLJ"),
    C_158100 ("158100", "鸡西市", "HLJ"),
    C_158300 ("158300", "密山市", "HLJ"),
    C_161000 ("161000", "齐齐哈尔市", "HLJ"),
    C_162650 ("162650", "扎兰屯市", "IM"),
    C_163000 ("163000", "大庆市", "HLJ"),
    C_164000 ("164000", "北安市", "HLJ"),
    C_164100 ("164100", "五大连池市", "HLJ"),
    C_164300 ("164300", "黑河市", "HLJ"),
    C_200000 ("200000", "上海市", "SH"),
    C_210000 ("210000", "南京市", "JS"),
    C_211400 ("211400", "仪征市", "JS"),
    C_212000 ("212000", "镇江市", "JS"),
    C_212300 ("212300", "丹阳市", "JS"),
    C_213000 ("213000", "常州市", "JS"),
    C_214000 ("214000", "无锡市", "JS"),
    C_214200 ("214200", "宜兴市", "JS"),
    C_214400 ("214400", "江阴市", "JS"),
    C_215000 ("215000", "苏州市", "JS"),
    C_215200 ("215200", "吴江市", "JS"),
    C_215300 ("215300", "昆山市", "JS"),
    C_215400 ("215400", "太仓市", "JS"),
    C_215500 ("215500", "常熟市", "JS"),
    C_215600 ("215600", "张家港市", "JS"),
    C_221000 ("221000", "徐州市", "JS"),
    C_222000 ("222000", "连云港市", "JS"),
    C_223000 ("223000", "淮阴市", "JS"),
    C_223200 ("223200", "淮安市", "JS"),
    C_223800 ("223800", "宿迁市", "JS"),
    C_224000 ("224000", "盐城市", "JS"),
    C_224200 ("224200", "东台市", "JS"),
    C_225000 ("225000", "扬州市", "JS"),
    C_225300 ("225300", "泰州市", "JS"),
    C_225700 ("225700", "兴化市", "JS"),
    C_226000 ("226000", "南通市", "JS"),
    C_230000 ("230000", "合肥市", "AH"),
    C_232000 ("232000", "淮南市", "AH"),
    C_233000 ("233000", "蚌埠市", "AH"),
    C_234000 ("234000", "宿州市", "AH"),
    C_235000 ("235000", "淮北市", "AH"),
    C_236000 ("236000", "阜阳市", "AH"),
    C_236800 ("236800", "亳州市", "AH"),
    C_237000 ("237000", "六安市", "AH"),
    C_238000 ("238000", "巢湖市", "AH"),
    C_239000 ("239000", "滁州市", "AH"),
    C_241000 ("241000", "芜湖市", "AH"),
    C_242000 ("242000", "宣州市", "AH"),
    C_242700 ("242700", "黄山区", "AH"),
    C_243000 ("243000", "马鞍山市", "AH"),
    C_244000 ("244000", "铜陵市", "AH"),
    C_245000 ("245000", "黄山市", "AH"),
    C_246000 ("246000", "安庆市", "AH"),
    C_247100 ("247100", "贵池市", "AH"),
    C_250000 ("250000", "济南市", "SD"),
    C_252000 ("252000", "聊城市", "SD"),
    C_252600 ("252600", "临清市", "SD"),
    C_253000 ("253000", "德州市", "SD"),
    C_253600 ("253600", "乐陵市", "SD"),
    C_255000 ("255000", "淄博市", "SD"),
    C_256600 ("256600", "滨州市", "SD"),
    C_257000 ("257000", "东营市", "SD"),
    C_261000 ("261000", "潍坊市", "SD"),
    C_261400 ("261400", "莱州市", "SD"),
    C_262200 ("262200", "诸城市", "SD"),
    C_262500 ("262500", "青州市", "SD"),
    C_264000 ("264000", "烟台市", "SD"),
    C_264200 ("264200", "威海市", "SD"),
    C_264300 ("264300", "荣成市", "SD"),
    C_264400 ("264400", "文登市", "SD"),
    C_265200 ("265200", "莱阳市", "SD"),
    C_265700 ("265700", "龙口市", "SD"),
    C_266000 ("266000", "青岛市", "SD"),
    C_266200 ("266200", "即墨市", "SD"),
    C_266300 ("266300", "胶州市", "SD"),
    C_271000 ("271000", "泰安市", "SD"),
    C_271100 ("271100", "莱芜市", "SD"),
    C_271200 ("271200", "新泰市", "SD"),
    C_272100 ("272100", "济宁市", "SD"),
    C_273100 ("273100", "曲阜市", "SD"),
    C_274000 ("274000", "荷泽市", "SD"),
    C_276000 ("276000", "临沂市", "SD"),
    C_276800 ("276800", "日照市", "SD"),
    C_277100 ("277100", "枣庄市", "SD"),
    C_277500 ("277500", "滕州市", "SD"),
    C_300000 ("300000", "天津市", "TJ"),
    C_310000 ("310000", "杭州市", "ZJ"),
    C_311200 ("311200", "萧山市", "ZJ"),
    C_312000 ("312000", "绍兴市", "ZJ"),
    C_313000 ("313000", "湖州市", "ZJ"),
    C_314000 ("314000", "嘉兴市", "ZJ"),
    C_314500 ("314500", "桐乡市", "ZJ"),
    C_315000 ("315000", "宁波市", "ZJ"),
    C_315300 ("315300", "慈溪市", "ZJ"),
    C_315500 ("315500", "奉化市", "ZJ"),
    C_316000 ("316000", "舟山市", "ZJ"),
    C_317000 ("317000", "临海市", "ZJ"),
    C_317700 ("317700", "椒江市", "ZJ"),
    C_318000 ("318000", "台州市", "ZJ"),
    C_321000 ("321000", "金华市", "ZJ"),
    C_321100 ("321100", "兰溪市", "ZJ"),
    C_322000 ("322000", "义乌市", "ZJ"),
    C_322100 ("322100", "东阳市", "ZJ"),
    C_323000 ("323000", "丽水市", "ZJ"),
    C_324000 ("324000", "衢州市", "ZJ"),
    C_325000 ("325000", "温州市", "ZJ"),
    C_325100 ("325100", "永嘉县", "ZJ"),
    C_325200 ("325200", "瑞安市", "ZJ"),
    C_325300 ("325300", "文成县", "ZJ"),
    C_325400 ("325400", "平阳县", "ZJ"),
    C_325500 ("325500", "泰顺县", "ZJ"),
    C_325600 ("325600", "乐清市", "ZJ"),
    C_325700 ("325700", "洞头县", "ZJ"),
    C_325800 ("325800", "苍南县", "ZJ"),
    C_330000 ("330000", "南昌市", "JX"),
    C_331100 ("331100", "丰城市", "JX"),
    C_331200 ("331200", "樟树市", "JX"),
    C_332000 ("332000", "九江市", "JX"),
    C_333000 ("333000", "景德镇市", "JX"),
    C_334000 ("334000", "上饶市", "JX"),
    C_335000 ("335000", "鹰潭市", "JX"),
    C_336000 ("336000", "宜春市", "JX"),
    C_336500 ("336500", "新余市", "JX"),
    C_337000 ("337000", "萍乡市", "JX"),
    C_341000 ("341000", "赣州市", "JX"),
    C_343000 ("343000", "吉安市", "JX"),
    C_343600 ("343600", "井冈山市", "JX"),
    C_344000 ("344000", "抚州地区", "JX"),
    C_344100 ("344100", "临川市", "JX"),
    C_350000 ("350000", "福州市", "FJ"),
    C_351100 ("351100", "莆田市", "FJ"),
    C_352100 ("352100", "宁德市", "FJ"),
    C_353000 ("353000", "南平市", "FJ"),
    C_354000 ("354000", "邵武市", "FJ"),
    C_361000 ("361000", "厦门市", "FJ"),
    C_362000 ("362000", "泉州市", "FJ"),
    C_362700 ("362700", "石狮市", "FJ"),
    C_363000 ("363000", "漳州市", "FJ"),
    C_364000 ("364000", "龙岩市", "FJ"),
    C_365000 ("365000", "三明市", "FJ"),
    C_366000 ("366000", "永安市", "FJ"),
    C_400000 ("400000", "重庆市", "CQ"),
    C_410000 ("410000", "长沙市", "HUN"),
    C_411100 ("411100", "湘潭市", "HUN"),
    C_411400 ("411400", "湘乡市", "HUN"),
    C_412000 ("412000", "株洲市", "HUN"),
    C_412200 ("412200", "醴陵市", "HUN"),
    C_413000 ("413000", "益阳市", "HUN"),
    C_413100 ("413100", "沅江市", "HUN"),
    C_414000 ("414000", "岳阳市", "HUN"),
    C_414400 ("414400", "汨罗市", "HUN"),
    C_415000 ("415000", "常德市", "HUN"),
    C_415400 ("415400", "津市市", "HUN"),
    C_416000 ("416000", "吉首市", "HUN"),
    C_416600 ("416600", "大庸市", "HUN"),
    C_417000 ("417000", "娄底市", "HUN"),
    C_417100 ("417100", "涟源市", "HUN"),
    C_417500 ("417500", "冷水江市", "HUN"),
    C_418000 ("418000", "怀化市", "HUN"),
    C_418200 ("418200", "洪江市", "HUN"),
    C_421000 ("421000", "衡阳市", "HUN"),
    C_422000 ("422000", "邵阳市", "HUN"),
    C_423000 ("423000", "郴州市", "HUN"),
    C_423400 ("423400", "资兴市", "HUN"),
    C_425000 ("425000", "永州市", "HUN"),
    C_425100 ("425100", "冷水滩市", "HUN"),
    C_427000 ("427000", "张家界市", "HUN"),
    C_430000 ("430000", "武汉市", "HUB"),
    C_431600 ("431600", "麻城市", "HUB"),
    C_431700 ("431700", "天门市", "HUB"),
    C_432100 ("432100", "孝感市", "HUB"),
    C_432400 ("432400", "应城市", "HUB"),
    C_432600 ("432600", "安陆市", "HUB"),
    C_432700 ("432700", "广水市", "HUB"),
    C_433000 ("433000", "仙桃市", "HUB"),
    C_433100 ("433100", "潜江市", "HUB"),
    C_433200 ("433200", "洪湖市", "HUB"),
    C_434000 ("434000", "沙市市", "HUB"),
    C_434100 ("434100", "荆州市", "HUB"),
    C_434400 ("434400", "石首市", "HUB"),
    C_435000 ("435000", "黄石市", "HUB"),
    C_436000 ("436000", "鄂州市", "HUB"),
    C_436400 ("436400", "武穴市", "HUB"),
    C_437000 ("437000", "咸宁市", "HUB"),
    C_437300 ("437300", "蒲圻市", "HUB"),
    C_438000 ("438000", "黄冈市", "HUB"),
    C_441000 ("441000", "襄樊市", "HUB"),
    C_441200 ("441200", "枣阳市", "HUB"),
    C_441300 ("441300", "随州市", "HUB"),
    C_441800 ("441800", "老河口市", "HUB"),
    C_441900 ("441900", "丹江口市", "HUB"),
    C_442000 ("442000", "十堰市", "HUB"),
    C_443000 ("443000", "宜昌市", "HUB"),
    C_443300 ("443300", "枝城市", "HUB"),
    C_444100 ("444100", "当阳市", "HUB"),
    C_445000 ("445000", "恩施市", "HUB"),
    C_445400 ("445400", "利川市", "HUB"),
    C_448000 ("448000", "荆门市", "HUB"),
    C_450000 ("450000", "郑州市", "HN"),
    C_453000 ("453000", "新乡市", "HN"),
    C_453100 ("453100", "卫辉市", "HN"),
    C_453600 ("453600", "辉县市", "HN"),
    C_454000 ("454000", "焦作市", "HN"),
    C_454650 ("454650", "济源市", "HN"),
    C_455000 ("455000", "安阳市", "HN"),
    C_456500 ("456500", "林州市", "HN"),
    C_457000 ("457000", "濮阳市", "HN"),
    C_458000 ("458000", "鹤壁市", "HN"),
    C_461000 ("461000", "许昌市", "HN"),
    C_461670 ("461670", "禹州市", "HN"),
    C_462000 ("462000", "漯河市", "HN"),
    C_463000 ("463000", "驻马店地区", "HN"),
    C_464000 ("464000", "信阳市", "HN"),
    C_466000 ("466000", "周口地区", "HN"),
    C_467000 ("467000", "平顶山市", "HN"),
    C_467500 ("467500", "汝州市", "HN"),
    C_471000 ("471000", "洛阳市", "HN"),
    C_472000 ("472000", "三门峡市", "HN"),
    C_472300 ("472300", "义马市", "HN"),
    C_473000 ("473000", "南阳市", "HN"),
    C_474150 ("474150", "邓州市", "HN"),
    C_475000 ("475000", "开封市", "HN"),
    C_476000 ("476000", "商丘市", "HN"),
    C_510000 ("510000", "广州市", "GD"),
    C_511500 ("511500", "清远市", "GD"),
    C_511700 ("511700", "东莞市", "GD"),
    C_512000 ("512000", "韶关市", "GD"),
    C_514000 ("514000", "梅州市", "GD"),
    C_515000 ("515000", "汕头市", "GD"),
    C_515300 ("515300", "揭阳市", "GD"),
    C_516000 ("516000", "惠州市", "GD"),
    C_516600 ("516600", "汕尾市", "GD"),
    C_517000 ("517000", "河源市", "GD"),
    C_518000 ("518000", "深圳市", "GD"),
    C_519000 ("519000", "珠海市", "GD"),
    C_521000 ("521000", "潮州市", "GD"),
    C_524000 ("524000", "湛江市", "GD"),
    C_525000 ("525000", "茂名市", "GD"),
    C_526000 ("526000", "肇庆市", "GD"),
    C_527300 ("527300", "云浮市", "GD"),
    C_528000 ("528000", "佛山市", "GD"),
    C_528400 ("528400", "中山市", "GD"),
    C_529000 ("529000", "江门市", "GD"),
    C_529500 ("529500", "阳江市", "GD"),
    C_530000 ("530000", "南宁市", "GX"),
    C_532600 ("532600", "凭祥市", "GX"),
    C_533000 ("533000", "百色市", "GX"),
    C_535000 ("535000", "钦州市", "GX"),
    C_536000 ("536000", "北海市", "GX"),
    C_537000 ("537000", "玉林市", "GX"),
    C_537100 ("537100", "贵港市", "GX"),
    C_538000 ("538000", "防城港市", "GX"),
    C_538100 ("538100", "东兴市", "GX"),
    C_541000 ("541000", "桂林市", "GX"),
    C_543000 ("543000", "梧州市", "GX"),
    C_545000 ("545000", "柳州市", "GX"),
    C_546500 ("546500", "合山市", "GX"),
    C_547000 ("547000", "河池市", "GX"),
    C_550000 ("550000", "贵阳市", "GZ"),
    C_553000 ("553000", "六盘水市", "GZ"),
    C_554300 ("554300", "铜仁市", "GZ"),
    C_556000 ("556000", "凯里市", "GZ"),
    C_558000 ("558000", "都匀市", "GZ"),
    C_561000 ("561000", "安顺市", "GZ"),
    C_562400 ("562400", "兴义市", "GZ"),
    C_563000 ("563000", "遵义市", "GZ"),
    C_570000 ("570000", "海口市", "HAIN"),
    C_571100 ("571100", "琼山市", "HAIN"),
    C_571200 ("571200", "定安县", "HAIN"),
    C_571300 ("571300", "文昌市", "HAIN"),
    C_571400 ("571400", "琼海市", "HAIN"),
    C_571500 ("571500", "万宁市", "HAIN"),
    C_571600 ("571600", "屯昌县", "HAIN"),
    C_571700 ("571700", "儋州市", "HAIN"),
    C_571800 ("571800", "临高县", "HAIN"),
    C_571900 ("571900", "澄迈县", "HAIN"),
    C_572000 ("572000", "三亚市", "HAIN"),
    C_572200 ("572200", "五指山市", "HAIN"),
    C_572300 ("572300", "保亭黎族苗族自治县", "HAIN"),
    C_572400 ("572400", "陵水黎族自治县", "HAIN"),
    C_572500 ("572500", "乐东黎族自治县", "HAIN"),
    C_572600 ("572600", "东方市", "HAIN"),
    C_572700 ("572700", "昌江黎族自治县", "HAIN"),
    C_572800 ("572800", "白沙黎族自治县", "HAIN"),
    C_572900 ("572900", "琼中黎族苗族自治县", "HAIN"),
    C_573100 ("573100", "西南中沙群岛", "HAIN"),
    C_610000 ("610000", "成都市 ", "SC"),
    C_614000 ("614000", "乐山市 ", "SC"),
    C_615000 ("615000", "凉山州", "SC"),
    C_617000 ("617000", "攀枝花市 ", "SC"),
    C_618000 ("618000", "德阳市 ", "SC"),
    C_620000 ("620000", "眉山市 ", "SC"),
    C_621000 ("621000", "绵阳市 ", "SC"),
    C_624000 ("624000", "阿坝州 ", "SC"),
    C_625000 ("625000", "雅安市 ", "SC"),
    C_626000 ("626000", "甘孜州 ", "SC"),
    C_628000 ("628000", "广元市 ", "SC"),
    C_629000 ("629000", "遂宁市 ", "SC"),
    C_635000 ("635000", "达州市 ", "SC"),
    C_636600 ("636600", "巴中市 ", "SC"),
    C_637000 ("637000", "南充市 ", "SC"),
    C_638000 ("638000", "广安市 ", "SC"),
    C_641000 ("641000", "内江市 ", "SC"),
    C_641300 ("641300", "资阳市 ", "SC"),
    C_643000 ("643000", "自贡市 ", "SC"),
    C_644000 ("644000", "宜宾市 ", "SC"),
    C_646000 ("646000", "泸州市 ", "SC"),
    C_650000 ("650000", "昆明市", "YN"),
    C_653100 ("653100", "玉溪市", "YN"),
    C_654100 ("654100", "东川市", "YN"),
    C_655000 ("655000", "曲靖市", "YN"),
    C_657000 ("657000", "昭通市", "YN"),
    C_661000 ("661000", "开远市", "YN"),
    C_661400 ("661400", "个旧市", "YN"),
    C_663000 ("663000", "文山县", "YN"),
    C_665000 ("665000", "普洱市", "YN"),
    C_666100 ("666100", "景洪市", "YN"),
    C_671000 ("671000", "大理市", "YN"),
    C_674100 ("674100", "丽江市", "YN"),
    C_675000 ("675000", "楚雄市", "YN"),
    C_678000 ("678000", "保山市", "YN"),
    C_678400 ("678400", "德宏州", "YN"),
    C_678500 ("678500", "畹町市", "YN"),
    C_710000 ("710000", "西安市", "SHX"),
    C_712000 ("712000", "咸阳市", "SHX"),
    C_714000 ("714000", "渭南市", "SHX"),
    C_715400 ("715400", "韩城市", "SHX"),
    C_716000 ("716000", "延安市", "SHX"),
    C_719000 ("719000", "榆林市", "SHX"),
    C_721000 ("721000", "宝鸡市", "SHX"),
    C_723000 ("723000", "汉中市", "SHX"),
    C_725000 ("725000", "安康市", "SHX"),
    C_726000 ("726000", "商州市", "SHX"),
    C_727000 ("727000", "铜川市", "SHX"),
    C_730000 ("730000", "兰州市", "GS"),
    C_730900 ("730900", "白银市", "GS"),
    C_731100 ("731100", "临夏回族自治州", "GS"),
    C_733000 ("733000", "武威市", "GS"),
    C_734000 ("734000", "张掖市", "GS"),
    C_735000 ("735000", "酒泉市", "GS"),
    C_735100 ("735100", "嘉峪关市", "GS"),
    C_735200 ("735200", "玉门市", "GS"),
    C_736200 ("736200", "敦煌市", "GS"),
    C_737100 ("737100", "金昌市", "GS"),
    C_741000 ("741000", "天水市", "GS"),
    C_743000 ("743000", "定西市", "GS"),
    C_744000 ("744000", "平凉市", "GS"),
    C_745000 ("745000", "庆阳市", "GS"),
    C_746000 ("746000", "陇南市", "GS"),
    C_747000 ("747000", "甘南藏族自治州", "GS"),
    C_750000 ("750000", "银川市", "NX"),
    C_750306 ("750306", "阿拉善盟", "IM"),
    C_751100 ("751100", "吴忠市", "NX"),
    C_751600 ("751600", "青铜峡市", "NX"),
    C_753000 ("753000", "石咀山市", "NX"),
    C_754000 ("754000", "dd市", "NX"),
    C_810000 ("810000", "西宁市", "QH"),
    C_816000 ("816000", "格尔木市", "QH"),
    C_817000 ("817000", "德令哈市", "QH"),
    C_830000 ("830000", "乌鲁木齐市", "XJ"),
    C_831100 ("831100", "昌吉市", "XJ"),
    C_832000 ("832000", "石河子市", "XJ"),
    C_833200 ("833200", "奎屯市", "XJ"),
    C_833400 ("833400", "博乐市", "XJ"),
    C_834000 ("834000", "克拉玛依市", "XJ"),
    C_834700 ("834700", "塔城市", "XJ"),
    C_835000 ("835000", "伊宁市", "XJ"),
    C_836500 ("836500", "阿勒泰市", "XJ"),
    C_838000 ("838000", "吐鲁番市", "XJ"),
    C_839000 ("839000", "哈密市", "XJ"),
    C_841000 ("841000", "库尔勒市", "XJ"),
    C_843000 ("843000", "阿克苏市", "XJ"),
    C_844000 ("844000", "喀什市", "XJ"),
    C_845350 ("845350", "阿图什市", "XJ"),
    C_848000 ("848000", "和田市", "XJ"),
    C_850000 ("850000", "拉萨市", "TB"),
    C_850700 ("850700", "山南地区", "TB"),
    C_852000 ("852000", "那曲地区", "TB"),
    C_854000 ("854000", "昌都地区", "TB"),
    C_857000 ("857000", "日喀则市", "TB"),
    C_859100 ("859100", "阿里地区", "TB"),
    C_860000 ("860000", "林芝地区", "TB"),
    C_999077 ("999077", "香港特别行政区", "");

    private final String value;
    private final String name;
    private final String parent;
    
    YbCity(final String value, final String name, final String parent){
        this.value = value;
        this.name = name;
        this.parent = parent;
    }
    public String getValue() {
        return this.value;
    }
    public String getName() {
        return this.name;
    }
    public String getParent() {
        return this.parent;
    }

    /**
     * 根据类型的名称，返回类型的枚举实例。
     *
     * @param cityCode 城市代码
     */
    public static YbCity fromYBCity(String cityCode) {
        String name = RegionUtils.getRegionNameByCode(cityCode);
        if(StringUtils.isNotEmpty(name)){
            for (YbCity yc : YbCity.values()){
                if(yc.getName().contains(name)){
                    return yc;
                }
            }
        }
        return null;
    }

    /**
     * <b> 获取城市代码对应的省代码 </b>
     * @param cityCode 城市代码
     * @author ZXF
     * @create 2018/04/11 0011 9:36
     * @version
     * @注意事项 </b>
     */
    public static String fromCode(String cityCode) {
        String ybc = ConstProp.BLANK_CHAR;
        YbCity city = fromYBCity(cityCode);
        if(city != null){
            ybc = city.getParent();
        }
        return ybc;
    }

    public static void main(String[] args){
//        System.out.println(fromCode("呼和浩特市"));
        /*String a = "010000#呼和浩特市#IM;" +
                "012000#集宁市#IM;" +
                "012600#二连浩特市#IM;" +
                "014000#包头市#IM;" +
                "015000#临河市#IM;" +
                "016000#乌海市#IM;" +
                "017000#东胜市#IM;" +
                "021000#海拉尔市#IM;" +
                "021400#满洲里市#IM;" +
                "022150#牙克石市#IM;" +
                "024000#赤峰市#IM;" +
                "026000#锡林浩特市#IM;" +
                "028000#通辽市#IM;" +
                "029200#霍林郭勒市#IM;" +
                "030000#太原市#SX;" +
                "030200#古交市#SX;" +
                "030600#榆次市#SX;" +
                "033000#吕梁市#SX;" +
                "034000#忻州市#SX;" +
                "037000#大同市#SX;" +
                "038500#朔州市#SX;" +
                "041000#临汾市#SX;" +
                "043000#侯马市#SX;" +
                "044000#运城市#SX;" +
                "045000#阳泉市#SX;" +
                "046000#长治市#SX;" +
                "048000#晋城市#SX;" +
                "050000#石家庄市#HB;" +
                "052360#辛集市#HB;" +
                "053000#衡水市#HB;" +
                "054000#邢台市#HB;" +
                "054100#沙河市#HB;" +
                "055750#南宫市#HB;" +
                "056000#邯郸市#HB;" +
                "056300#武安市#HB;" +
                "061000#沧州市#HB;" +
                "062150#泊头市#HB;" +
                "062550#任丘市#HB;" +
                "063000#唐山市#HB;" +
                "065000#廊坊市#HB;" +
                "066000#秦皇岛市#HB;" +
                "066100#北戴河#HB;" +
                "067000#承德市#HB;" +
                "071000#保定市#HB;" +
                "072750#涿州市#HB;" +
                "073000#定州市#HB;" +
                "074000#高碑店市#HB;" +
                "075000#张家口市#HB;" +
                "100000#北京市#BJ;" +
                "110000#沈阳市#LN;" +
                "111000#辽阳市#LN;" +
                "112000#铁岭市#LN;" +
                "112300#开原市#LN;" +
                "112700#铁法市#LN;" +
                "113000#抚顺市#LN;" +
                "114000#鞍山市#LN;" +
                "114200#海城市#LN;" +
                "115000#营口市#LN;" +
                "116000#大连市#LN;" +
                "116300#瓦房店市#LN;" +
                "117000#本溪市#LN;" +
                "118000#丹东市#LN;" +
                "121000#锦州市#LN;" +
                "121200#凌海市#LN;" +
                "121300#北宁市#LN;" +
                "122000#朝阳市#LN;" +
                "122100#北票市#LN;" +
                "123000#阜新市#LN;" +
                "124000#盘锦市#LN;" +
                "125000#葫芦岛市#LN;" +
                "125100#兴城市#LN;" +
                "130000#长春市#JL;" +
                "130500#九台市#JL;" +
                "131200#扶余市#JL;" +
                "131300#大安市#JL;" +
                "132000#吉林市#JL;" +
                "132400#桦甸市#JL;" +
                "133000#延吉市#JL;" +
                "133100#图们市#JL;" +
                "133300#珲春市#JL;" +
                "133400#龙井市#JL;" +
                "133700#敦化市#JL;" +
                "134000#通化市#JL;" +
                "134200#集安市#JL;" +
                "134300#浑江市#JL;" +
                "134600#临江市#JL;" +
                "135000#梅河口市#JL;" +
                "136000#四平市#JL;" +
                "136100#公主岭市#JL;" +
                "136200#辽源市#JL;" +
                "137000#白城市#JL;" +
                "137100#洮南市#JL;" +
                "137400#乌兰浩特市#IM;" +
                "138000#松原市#JL;" +
                "150000#哈尔滨市#HLJ;" +
                "150100#双城市#HLJ;" +
                "150300#阿城市#HLJ;" +
                "150600#尚志市#HLJ;" +
                "151100#肇东市#HLJ;" +
                "151400#安达市#HLJ;" +
                "152000#绥化市#HLJ;" +
                "152300#海伦市#HLJ;" +
                "152500#铁力市#HLJ;" +
                "153000#伊春市#HLJ;" +
                "154000#佳木斯市#HLJ;" +
                "154100#鹤岗市#HLJ;" +
                "154600#七台河市#HLJ;" +
                "155100#双鸭山市#HLJ;" +
                "156100#富锦市#HLJ;" +
                "156400#同江市#HLJ;" +
                "157000#牡丹江市#HLJ;" +
                "157300#绥芬河市#HLJ;" +
                "158100#鸡西市#HLJ;" +
                "158300#密山市#HLJ;" +
                "161000#齐齐哈尔市#HLJ;" +
                "162650#扎兰屯市#IM;" +
                "163000#大庆市#HLJ;" +
                "164000#北安市#HLJ;" +
                "164100#五大连池市#HLJ;" +
                "164300#黑河市#HLJ;" +
                "200000#上海市#SH;" +
                "210000#南京市#JS;" +
                "211400#仪征市#JS;" +
                "212000#镇江市#JS;" +
                "212300#丹阳市#JS;" +
                "213000#常州市#JS;" +
                "214000#无锡市#JS;" +
                "214200#宜兴市#JS;" +
                "214400#江阴市#JS;" +
                "215000#苏州市#JS;" +
                "215200#吴江市#JS;" +
                "215300#昆山市#JS;" +
                "215400#太仓市#JS;" +
                "215500#常熟市#JS;" +
                "215600#张家港市#JS;" +
                "221000#徐州市#JS;" +
                "222000#连云港市#JS;" +
                "223000#淮阴市#JS;" +
                "223200#淮安市#JS;" +
                "223800#宿迁市#JS;" +
                "224000#盐城市#JS;" +
                "224200#东台市#JS;" +
                "225000#扬州市#JS;" +
                "225300#泰州市#JS;" +
                "225700#兴化市#JS;" +
                "226000#南通市#JS;" +
                "230000#合肥市#AH;" +
                "232000#淮南市#AH;" +
                "233000#蚌埠市#AH;" +
                "234000#宿州市#AH;" +
                "235000#淮北市#AH;" +
                "236000#阜阳市#AH;" +
                "236800#亳州市#AH;" +
                "237000#六安市#AH;" +
                "238000#巢湖市#AH;" +
                "239000#滁州市#AH;" +
                "241000#芜湖市#AH;" +
                "242000#宣州市#AH;" +
                "242700#黄山区#AH;" +
                "243000#马鞍山市#AH;" +
                "244000#铜陵市#AH;" +
                "245000#黄山市#AH;" +
                "246000#安庆市#AH;" +
                "247100#贵池市#AH;" +
                "250000#济南市#SD;" +
                "252000#聊城市#SD;" +
                "252600#临清市#SD;" +
                "253000#德州市#SD;" +
                "253600#乐陵市#SD;" +
                "255000#淄博市#SD;" +
                "256600#滨州市#SD;" +
                "257000#东营市#SD;" +
                "261000#潍坊市#SD;" +
                "261400#莱州市#SD;" +
                "262200#诸城市#SD;" +
                "262500#青州市#SD;" +
                "264000#烟台市#SD;" +
                "264200#威海市#SD;" +
                "264300#荣成市#SD;" +
                "264400#文登市#SD;" +
                "265200#莱阳市#SD;" +
                "265700#龙口市#SD;" +
                "266000#青岛市#SD;" +
                "266200#即墨市#SD;" +
                "266300#胶州市#SD;" +
                "271000#泰安市#SD;" +
                "271100#莱芜市#SD;" +
                "271200#新泰市#SD;" +
                "272100#济宁市#SD;" +
                "273100#曲阜市#SD;" +
                "274000#荷泽市#SD;" +
                "276000#临沂市#SD;" +
                "276800#日照市#SD;" +
                "277100#枣庄市#SD;" +
                "277500#滕州市#SD;" +
                "300000#天津市#TJ;" +
                "310000#杭州市#ZJ;" +
                "311200#萧山市#ZJ;" +
                "312000#绍兴市#ZJ;" +
                "313000#湖州市#ZJ;" +
                "314000#嘉兴市#ZJ;" +
                "314500#桐乡市#ZJ;" +
                "315000#宁波市#ZJ;" +
                "315300#慈溪市#ZJ;" +
                "315500#奉化市#ZJ;" +
                "316000#舟山市#ZJ;" +
                "317000#临海市#ZJ;" +
                "317700#椒江市#ZJ;" +
                "318000#台州市#ZJ;" +
                "321000#金华市#ZJ;" +
                "321100#兰溪市#ZJ;" +
                "322000#义乌市#ZJ;" +
                "322100#东阳市#ZJ;" +
                "323000#丽水市#ZJ;" +
                "324000#衢州市#ZJ;" +
                "325000#温州市#ZJ;" +
                "325100#永嘉县#ZJ;" +
                "325200#瑞安市#ZJ;" +
                "325300#文成县#ZJ;" +
                "325400#平阳县#ZJ;" +
                "325500#泰顺县#ZJ;" +
                "325600#乐清市#ZJ;" +
                "325700#洞头县#ZJ;" +
                "325800#苍南县#ZJ;" +
                "330000#南昌市#JX;" +
                "331100#丰城市#JX;" +
                "331200#樟树市#JX;" +
                "332000#九江市#JX;" +
                "333000#景德镇市#JX;" +
                "334000#上饶市#JX;" +
                "335000#鹰潭市#JX;" +
                "336000#宜春市#JX;" +
                "336500#新余市#JX;" +
                "337000#萍乡市#JX;" +
                "341000#赣州市#JX;" +
                "343000#吉安市#JX;" +
                "343600#井冈山市#JX;" +
                "344000#抚州地区#JX;" +
                "344100#临川市#JX;" +
                "350000#福州市#FJ;" +
                "351100#莆田市#FJ;" +
                "352100#宁德市#FJ;" +
                "353000#南平市#FJ;" +
                "354000#邵武市#FJ;" +
                "361000#厦门市#FJ;" +
                "362000#泉州市#FJ;" +
                "362700#石狮市#FJ;" +
                "363000#漳州市#FJ;" +
                "364000#龙岩市#FJ;" +
                "365000#三明市#FJ;" +
                "366000#永安市#FJ;" +
                "400000#重庆市#CQ;" +
                "410000#长沙市#HUN;" +
                "411100#湘潭市#HUN;" +
                "411400#湘乡市#HUN;" +
                "412000#株洲市#HUN;" +
                "412200#醴陵市#HUN;" +
                "413000#益阳市#HUN;" +
                "413100#沅江市#HUN;" +
                "414000#岳阳市#HUN;" +
                "414400#汨罗市#HUN;" +
                "415000#常德市#HUN;" +
                "415400#津市市#HUN;" +
                "416000#吉首市#HUN;" +
                "416600#大庸市#HUN;" +
                "417000#娄底市#HUN;" +
                "417100#涟源市#HUN;" +
                "417500#冷水江市#HUN;" +
                "418000#怀化市#HUN;" +
                "418200#洪江市#HUN;" +
                "421000#衡阳市#HUN;" +
                "422000#邵阳市#HUN;" +
                "423000#郴州市#HUN;" +
                "423400#资兴市#HUN;" +
                "425000#永州市#HUN;" +
                "425100#冷水滩市#HUN;" +
                "427000#张家界市#HUN;" +
                "430000#武汉市#HUB;" +
                "431600#麻城市#HUB;" +
                "431700#天门市#HUB;" +
                "432100#孝感市#HUB;" +
                "432400#应城市#HUB;" +
                "432600#安陆市#HUB;" +
                "432700#广水市#HUB;" +
                "433000#仙桃市#HUB;" +
                "433100#潜江市#HUB;" +
                "433200#洪湖市#HUB;" +
                "434000#沙市市#HUB;" +
                "434100#荆州市#HUB;" +
                "434400#石首市#HUB;" +
                "435000#黄石市#HUB;" +
                "436000#鄂州市#HUB;" +
                "436400#武穴市#HUB;" +
                "437000#咸宁市#HUB;" +
                "437300#蒲圻市#HUB;" +
                "438000#黄冈市#HUB;" +
                "441000#襄樊市#HUB;" +
                "441200#枣阳市#HUB;" +
                "441300#随州市#HUB;" +
                "441800#老河口市#HUB;" +
                "441900#丹江口市#HUB;" +
                "442000#十堰市#HUB;" +
                "443000#宜昌市#HUB;" +
                "443300#枝城市#HUB;" +
                "444100#当阳市#HUB;" +
                "445000#恩施市#HUB;" +
                "445400#利川市#HUB;" +
                "448000#荆门市#HUB;" +
                "450000#郑州市#HN;" +
                "453000#新乡市#HN;" +
                "453100#卫辉市#HN;" +
                "453600#辉县市#HN;" +
                "454000#焦作市#HN;" +
                "454650#济源市#HN;" +
                "455000#安阳市#HN;" +
                "456500#林州市#HN;" +
                "457000#濮阳市#HN;" +
                "458000#鹤壁市#HN;" +
                "461000#许昌市#HN;" +
                "461670#禹州市#HN;" +
                "462000#漯河市#HN;" +
                "463000#驻马店地区#HN;" +
                "464000#信阳市#HN;" +
                "466000#周口地区#HN;" +
                "467000#平顶山市#HN;" +
                "467500#汝州市#HN;" +
                "471000#洛阳市#HN;" +
                "472000#三门峡市#HN;" +
                "472300#义马市#HN;" +
                "473000#南阳市#HN;" +
                "474150#邓州市#HN;" +
                "475000#开封市#HN;" +
                "476000#商丘市#HN;" +
                "510000#广州市#GD;" +
                "511500#清远市#GD;" +
                "511700#东莞市#GD;" +
                "512000#韶关市#GD;" +
                "514000#梅州市#GD;" +
                "515000#汕头市#GD;" +
                "515300#揭阳市#GD;" +
                "516000#惠州市#GD;" +
                "516600#汕尾市#GD;" +
                "517000#河源市#GD;" +
                "518000#深圳市#GD;" +
                "519000#珠海市#GD;" +
                "521000#潮州市#GD;" +
                "524000#湛江市#GD;" +
                "525000#茂名市#GD;" +
                "526000#肇庆市#GD;" +
                "527300#云浮市#GD;" +
                "528000#佛山市#GD;" +
                "528400#中山市#GD;" +
                "529000#江门市#GD;" +
                "529500#阳江市#GD;" +
                "530000#南宁市#GX;" +
                "532600#凭祥市#GX;" +
                "533000#百色市#GX;" +
                "535000#钦州市#GX;" +
                "536000#北海市#GX;" +
                "537000#玉林市#GX;" +
                "537100#贵港市#GX;" +
                "538000#防城港市#GX;" +
                "538100#东兴市#GX;" +
                "541000#桂林市#GX;" +
                "543000#梧州市#GX;" +
                "545000#柳州市#GX;" +
                "546500#合山市#GX;" +
                "547000#河池市#GX;" +
                "550000#贵阳市#GZ;" +
                "553000#六盘水市#GZ;" +
                "554300#铜仁市#GZ;" +
                "556000#凯里市#GZ;" +
                "558000#都匀市#GZ;" +
                "561000#安顺市#GZ;" +
                "562400#兴义市#GZ;" +
                "563000#遵义市#GZ;" +
                "570000#海口市#HAIN;" +
                "571100#琼山市#HAIN;" +
                "571200#定安县#HAIN;" +
                "571300#文昌市#HAIN;" +
                "571400#琼海市#HAIN;" +
                "571500#万宁市#HAIN;" +
                "571600#屯昌县#HAIN;" +
                "571700#儋州市#HAIN;" +
                "571800#临高县#HAIN;" +
                "571900#澄迈县#HAIN;" +
                "572000#三亚市#HAIN;" +
                "572200#五指山市#HAIN;" +
                "572300#保亭黎族苗族自治县#HAIN;" +
                "572400#陵水黎族自治县#HAIN;" +
                "572500#乐东黎族自治县#HAIN;" +
                "572600#东方市#HAIN;" +
                "572700#昌江黎族自治县#HAIN;" +
                "572800#白沙黎族自治县#HAIN;" +
                "572900#琼中黎族苗族自治县#HAIN;" +
                "573100#西南中沙群岛#HAIN;" +
                "610000#成都市 #SC;" +
                "614000#乐山市 #SC;" +
                "615000#凉山州#SC;" +
                "617000#攀枝花市 #SC;" +
                "618000#德阳市 #SC;" +
                "620000#眉山市 #SC;" +
                "621000#绵阳市 #SC;" +
                "624000#阿坝州 #SC;" +
                "625000#雅安市 #SC;" +
                "626000#甘孜州 #SC;" +
                "628000#广元市 #SC;" +
                "629000#遂宁市 #SC;" +
                "635000#达州市 #SC;" +
                "636600#巴中市 #SC;" +
                "637000#南充市 #SC;" +
                "638000#广安市 #SC;" +
                "641000#内江市 #SC;" +
                "641300#资阳市 #SC;" +
                "643000#自贡市 #SC;" +
                "644000#宜宾市 #SC;" +
                "646000#泸州市 #SC;" +
                "650000#昆明市#YN;" +
                "653100#玉溪市#YN;" +
                "654100#东川市#YN;" +
                "655000#曲靖市#YN;" +
                "657000#昭通市#YN;" +
                "661000#开远市#YN;" +
                "661400#个旧市#YN;" +
                "663000#文山县#YN;" +
                "665000#普洱市#YN;" +
                "666100#景洪市#YN;" +
                "671000#大理市#YN;" +
                "674100#丽江市#YN;" +
                "675000#楚雄市#YN;" +
                "678000#保山市#YN;" +
                "678400#德宏州#YN;" +
                "678500#畹町市#YN;" +
                "710000#西安市#SHX;" +
                "712000#咸阳市#SHX;" +
                "714000#渭南市#SHX;" +
                "715400#韩城市#SHX;" +
                "716000#延安市#SHX;" +
                "719000#榆林市#SHX;" +
                "721000#宝鸡市#SHX;" +
                "723000#汉中市#SHX;" +
                "725000#安康市#SHX;" +
                "726000#商州市#SHX;" +
                "727000#铜川市#SHX;" +
                "730000#兰州市#GS;" +
                "730900#白银市#GS;" +
                "731100#临夏回族自治州#GS;" +
                "733000#武威市#GS;" +
                "734000#张掖市#GS;" +
                "735000#酒泉市#GS;" +
                "735100#嘉峪关市#GS;" +
                "735200#玉门市#GS;" +
                "736200#敦煌市#GS;" +
                "737100#金昌市#GS;" +
                "741000#天水市#GS;" +
                "743000#定西市#GS;" +
                "744000#平凉市#GS;" +
                "745000#庆阳市#GS;" +
                "746000#陇南市#GS;" +
                "747000#甘南藏族自治州#GS;" +
                "750000#银川市#NX;" +
                "750306#阿拉善盟#IM;" +
                "751100#吴忠市#NX;" +
                "751600#青铜峡市#NX;" +
                "753000#石咀山市#NX;" +
                "754000#dd市#NX;" +
                "810000#西宁市#QH;" +
                "816000#格尔木市#QH;" +
                "817000#德令哈市#QH;" +
                "830000#乌鲁木齐市#XJ;" +
                "831100#昌吉市#XJ;" +
                "832000#石河子市#XJ;" +
                "833200#奎屯市#XJ;" +
                "833400#博乐市#XJ;" +
                "834000#克拉玛依市#XJ;" +
                "834700#塔城市#XJ;" +
                "835000#伊宁市#XJ;" +
                "836500#阿勒泰市#XJ;" +
                "838000#吐鲁番市#XJ;" +
                "839000#哈密市#XJ;" +
                "841000#库尔勒市#XJ;" +
                "843000#阿克苏市#XJ;" +
                "844000#喀什市#XJ;" +
                "845350#阿图什市#XJ;" +
                "848000#和田市#XJ;" +
                "850000#拉萨市#TB;" +
                "850700#山南地区#TB;" +
                "852000#那曲地区#TB;" +
                "854000#昌都地区#TB;" +
                "857000#日喀则市#TB;" +
                "859100#阿里地区#TB;" +
                "860000#林芝地区#TB;" +
                "999077#香港特别行政区#";
        String[] ar = a.split(";");
        int count = 0;
//        String c = "{";
        String d = ",";
        for(String b : ar){
            String[] br = b.split("#");
            String r = "";
            if(br.length == 3){
                r = br[2];
            }
            String c = "C_"+br[0]+" (\"" + br[0] + "\", \""+br[1]+"\", \"" + r + "\")"+d;
            System.out.println(c);
//            if(ar.length == (count+1)){
//                d = "";
//            }
//            c = c + "\""+br[1]+"\""+d;
            count++;
        }
//        c = c + "}";
//        System.out.println(c);
*/
    }
    



}
