package com.bcxin.ins.supply.business.impl;

import com.bcxin.ins.supply.SupplyType;
import com.bcxin.ins.supply.business.BizStrategy;
import com.bcxin.ins.supply.business.entity.InsureCommonView;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ResultDto;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

/**
 * 阳光保险
 * @author hzp
 * @date 2018/06/12
 */
@Component
@SupplyType(type = SupplyType.SupplyTypeEnum.YANG_GUANG_CAI)
public class BizStrategyYangGuang implements BizStrategy {

    @Override
    public ResultDto calcInsuranceEndDate(String startTime, Integer limitDays) {
        try {
            //1.计算一年后的时间
            Date planTimeNextYear = DateUtil.convertStringToDate(DateUtil.dateAdd(DateUtil.DATATYPE_YEAR, startTime, 1));

            //2.计算投标日期+投标有效期+28天后的日期
            int limitFinalDays = limitDays + 28;
            //不加28天
            Date planTimeWithLimit = DateUtil.convertStringToDate(DateUtil.dateAdd(DateUtil.DATATYPE_DAY,startTime,limitDays));
            //加28天
            Date planTimeWithFinalLimit = DateUtil.convertStringToDate(DateUtil.dateAdd(3,startTime,limitFinalDays));

            //3.比较planTimeWithLimit的日期是否大于planTime，是就超出一年期限
            if (DateUtil.calculateTwoDateDvalue(planTimeNextYear,planTimeWithLimit)<0) {
                return new ResultDto("保险期间大于一年，请重新设置投标有效期！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            //如果按+28天的日期来比较超出1年的限制就直接按一年算
            if (DateUtil.calculateTwoDateDvalue(planTimeNextYear,planTimeWithFinalLimit)<0) {
                planTimeWithFinalLimit = DateUtil.convertStringToDate(DateUtil.dateAdd(DateUtil.DATATYPE_DAY,DateUtil.dateAdd(DateUtil.DATATYPE_YEAR,startTime,1),-1));
            }

            if (planTimeWithFinalLimit != null) {
                String plannedEnd = DateUtil.convertDateToString(planTimeWithFinalLimit, DateUtil.FORMAT2);
                return new ResultDto(plannedEnd, ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            } else {
                return new ResultDto("获取失效日期失败", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        }catch (Exception e){
            e.printStackTrace();
            return new ResultDto("", "301", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }
    }

    @Override
    public InsureCommonView getInsureCommonView(Map<String, Object> map) {
        return null;
    }

    @Override
    public String createRequestMessage(Map<String, Object> map, String templateName) {
        return null;
    }
}
