package com.bcxin.ins.coninsweb.product.controller;

import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 建筑产品相关业务逻辑处理（不包括后台产品配置）
 * @author zxf
 *
 */
@Controller
public class InsuranceProduct_Build_Controller extends BaseController {

	@Autowired
	private InsProductAPIService insProductAPIService;
	@Autowired
	private ProductService productService;


	/**
	 * <b>前台页面产品详情 </b> 
	 * 
	 * @param request
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2016年12月21日 下午1:39:31
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/build/product/productInfo/{oid}")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】前台页面建筑产品-产品详情")
	public ModelAndView productInfo(HttpServletRequest request, @PathVariable long oid) {
		ModelAndView view = new ModelAndView();
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ProductVo pd = productService.getProduct(oid);
		if(StringUtils.isNotEmpty(pd.getOid())){
			view.addObject(ConstProp.SHAREPATH,productService.setSharePath(oid,userdetail));
		}else{
			return null;
		}
		if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_TB_GCTB.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/build_tb_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_YG_GCTB.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/build_yg_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_DB_GCTB.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/build_db_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_GCLY.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/productInfo_ly");
		}
		view.addObject(ConstProp.PRODUCTDTO, pd);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}

}
