package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 继续投保、返回修改等渲染页面时获取订单数据策略
 * @author zxf
 * @date 2018/08/30
 * @说明 策略方案提议及案例提供人：hzp 2018/06/12
 */
@Component
@OrderSupplyType(type = OrderSupplyType.OrderSupplyTypeEnum.GET_POLICY)
public class StragegyGetPolicy implements OrderSupplyStrategy {

    @Autowired
    private PolicyService policyService;

    @Autowired
    private ProductService productService;

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        return null;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        ModelAndView view = new ModelAndView();
        //订单基础信息
        OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
        //产品基础信息
        ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.XYX_DQCK)){
            dqckGet(order_id, page, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.XYX_XWCK)){
            xwckGet(order_id, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.BZX_SSBQ)){
            ssbqGet(order_id, page, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZX)){
            gzxGet(dto, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX)){
            tyxGet(order_id, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX)){
            gzzrxGet(order_id, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX)){
            zzxGet(order_id, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GCTB)){
            view.addObject("otList", OfficeType.listT(pd.getProduct_code().contains("DB")?"DB":"OT"));
            gctbGet(order_id, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GCLY)){
            gclyGet(order_id, page, view);
        }
        view.addObject(ConstProp.PD,pd);
        view.addObject(ConstProp.DTO,dto);
        return view;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        return null;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        return null;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        return null;
    }

    private void dqckGet(Long order_id, int page, ModelAndView view){
        if(page == 1){
            view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_1");
            //第一页内容存储
            CommonExportVo_1 vo = policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
            view.addObject(ConstProp.VO,vo);
            view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
            //投保人地址
            if(vo.getRoleSubjectList().size()>0){
                if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
                    view.addObject(ConstProp.REG_CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
                }
                if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
                    view.addObject(ConstProp.REG_AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
                }
            }
        }else if(page == 2){
            view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_2");
            //第二页内容存储
            view.addObject(ConstProp.VO,policyService.accordingToOrderIDToGetCommonExportVo_2(order_id));
        }else if(page == 3){
            view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_3");
            //第三页内容存储
            view.addObject(ConstProp.VO,policyService.accordingToOrderIDToGetCommonExportVo_3(order_id));
        }
        view.addObject("listType", SysDictUtils.getDictList("organizationType"));
        view.addObject("listCurrency", SysDictUtils.getDictList("currencyRequired"));
        view.addObject("listPaymentTerms", SysDictUtils.getDictList("paymentTerms"));
    }

    private void xwckGet(Long order_id, ModelAndView view){
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
        MicroExportVo vo = policyService.accordingToOrderIDToGetMicroExportVo(order_id);

        //投保人地址
        if(vo.getRoleSubjectList().size()>0){
            if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
                view.addObject(ConstProp.REG_CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
            }
            if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
                view.addObject(ConstProp.REG_AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
            }
        }
        view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_mi");
        setDay(vo);
        view.addObject(ConstProp.VO,vo);
    }

    private void setDay(MicroExportVo vo){
        String tom = DateUtil.getTomorrow();
        String nextOne = ConstProp.BLANK_CHAR;
        try {
            nextOne = DateUtil.dateAdd(1,tom,1);
            nextOne = DateUtil.dateAdd(3,nextOne,-1);
        } catch (Exception e) {
            e.printStackTrace();
        }
        vo.setInception_date(tom);
        vo.setPlanned_end_date(nextOne);
    }

    private void ssbqGet(Long order_id, int page, ModelAndView view){
        if(page == 1){
            view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_1");
            //第一页内容存储
            SpecialLitigationVo_1 vo = policyService.accordingToOrderIDToGetSpecialLitigationVo_1(order_id);
            view.addObject(ConstProp.VO,vo);
            view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
            if(StringUtils.isNotEmpty(vo.getProvince())){
                view.addObject(ConstProp.CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getProvince()));
            }
            if(StringUtils.isNotEmpty(vo.getProvince())){
                view.addObject(ConstProp.AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getCity()));
            }
            //投保人地址
            if(vo.getRoleSubjectList().size()>0){
                //投保人地址
                if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
                    view.addObject(ConstProp.REG_CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
                }
                if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
                    view.addObject(ConstProp.REG_AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
                }
            }
        }else if(page == 2){
            view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_2");
            //第二页内容存储
            SpecialLitigationVo_2 vo = policyService.accordingToOrderIDToGetSpecialLitigationVo_2(order_id);
            view.addObject(ConstProp.VO,vo);
            view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
            view.addObject(ConstProp.BANKCITYLIST,RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getMailPolicyVo().getBank_province()));
        }else if(page == 3){
            view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_3");
            //第三页内容存储
            view.addObject(ConstProp.VO,policyService.accordingToOrderIDToGetSpecialLitigationVo_3(order_id));
        }
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
    }

    private void gzxGet(OrderFormVo dto, ModelAndView view){
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("comTypeList", IdType.comList());
        SpecialPublicDutyVo vo = policyService.accordingToOrderIDToGetSpecialPublicDutyVo(Long.parseLong(dto.getOid()));
        if(StringUtils.isNotEmpty(userdetail.getWeb_type())){
            if(userdetail.getWeb_type().contains(ConstProp.PSS)){
                List<BLBCommunicationDto> actList = policyService.getBLBCommunicationDtoByUserID_PSSAPI(userdetail.getWeb_id(),dto.getProduct_code().split(ConstProp.MINUS)[2],userdetail.getWeb_type(),vo.getThr_order_id());
                view.addObject("acts", actList);
            }
        }
        view.addObject(ConstProp.VO,vo);
        view.setViewName("/coninsweb/api/gzx/policy/gzx_enterBasicInfo");
        if(vo == null){
            return;
        }
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
        if(vo.getRoleSubjectList() != null){
            view.addObject(ConstProp.CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
            view.addObject(ConstProp.AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
            //被保险人地址
            view.addObject(ConstProp.REG_CITY_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(1).getReg_province()));
            view.addObject(ConstProp.REG_AREA_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(1).getReg_city()));
        }
        if(vo.getMailPolicyVo() != null){
            if(StringUtils.isNotEmpty(vo.getMailPolicyVo().getBank_province())){
                view.addObject(ConstProp.BANKCITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getMailPolicyVo().getBank_province()));
            }
        }
    }

    private void tyxGet(Long order_id, ModelAndView view){
        GMRPolicyVo vo = policyService.accordingToOrderIDToGetGMRPolicyVo(order_id);
        view.setViewName("/coninsweb/api/gmr/policy/gmr_enterBasicInfo");
        view.addObject(ConstProp.VO,vo);
        view.addObject("comTypeList", IdType.comList());
        view.addObject("personTypeList", IdType.personList());
        view.addObject("natureList", NatureLinkage.getListByProvince(ConstProp.BLANK_CHAR));
        view.addObject("idOptionList", SysDictUtils.getDictList("idOption"));
        view.addObject("businessAreaList", SysDictUtils.getDictList("businessArea"));
        if(vo == null){
            return;
        }
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
        if(vo.getMailPolicyVo() != null&&StringUtils.isNotEmpty(vo.getMailPolicyVo().getBank_province())){
            view.addObject(ConstProp.BANKCITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getMailPolicyVo().getBank_province()));
        }
        if(vo.getRoleSubjectList() == null){
            return;
        }
        if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getNature_two())
                &&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getCom_nature())){
            view.addObject("natureTwoList", NatureLinkage.getListByProvince(vo.getRoleSubjectList().get(0).getCom_nature()));
        }
        if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
            view.addObject(ConstProp.CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
        }
        if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
            view.addObject(ConstProp.AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
        }
    }

    private void gzzrxGet(Long order_id, ModelAndView view){
        SpecialHirelingVo vo = policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
        view.setViewName("/coninsweb/api/gzzrx/policy/gzzrx_enter_basic_info");
        view.addObject(ConstProp.VO,vo);
        view.addObject("comTypeList", IdType.comList());
        view.addObject("personTypeList", IdType.personList());
        view.addObject("natureList", NatureLinkage.getListByProvince(""));
        view.addObject("idOptionList", SysDictUtils.getDictList("idOption"));
        view.addObject("businessAreaList", SysDictUtils.getDictList("businessArea"));
        if(vo == null){
            return;
        }
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
        if(vo.getMailPolicyVo() != null
                &&StringUtils.isNotEmpty(vo.getMailPolicyVo().getBank_province())){
            view.addObject(ConstProp.BANKCITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getMailPolicyVo().getBank_province()));
        }
        if(vo.getRoleSubjectList() == null){
            return;
        }
        if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getNature_two())
                &&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getCom_nature())){
            view.addObject("natureTwoList", NatureLinkage.getListByProvince(vo.getRoleSubjectList().get(0).getCom_nature()));
        }
        if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
            view.addObject(ConstProp.CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
        }
        if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
            view.addObject(ConstProp.AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
        }
    }

    private void zzxGet(Long order_id, ModelAndView view){
        LOTEPolicyVo vo = policyService.accordingToOrderIDToGetLOTEPolicyVo(order_id);
        view.setViewName("/coninsweb/api/lote/policy/lote_enterBasicInfo");
        view.addObject(ConstProp.VO,vo);
        view.addObject("comTypeList", IdType.comList());
        if(vo == null){
            return;
        }
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
        if(vo.getRoleSubjectList() != null){
            if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
                view.addObject(ConstProp.CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
            }
            if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
                view.addObject(ConstProp.AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
            }
            //被保险人地址
            if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getReg_province())) {
                view.addObject(ConstProp.REG_CITY_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(1).getReg_province()));
            }
            if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getReg_city())) {
                view.addObject(ConstProp.REG_AREA_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(1).getReg_city()));
            }
        }
        if(vo.getSpecialExhibitionVo() != null){
            if(StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getEx_province())){
                view.addObject("exCityList", RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getSpecialExhibitionVo().getEx_province()));
            }
            if(StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getEx_city())){
                view.addObject("exAreaList", RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getSpecialExhibitionVo().getEx_city()));
            }
        }
        if(vo.getMailPolicyVo() != null){
            if(StringUtils.isNotEmpty(vo.getMailPolicyVo().getBank_province())){
                view.addObject(ConstProp.BANKCITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getMailPolicyVo().getBank_province()));
            }
        }
    }

    private void gctbGet(Long order_id, ModelAndView view){
        SpecialBidVo vo = policyService.accordingToOrderIDToGetSpecialBidVo(order_id);
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
        //保单投保地址
        if (StringUtils.isNotEmpty(vo.getProvince())) {
            view.addObject(ConstProp.CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getProvince()));
        }
        if (StringUtils.isNotEmpty(vo.getCity())) {
            view.addObject(ConstProp.AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getCity()));
        }
        //投保人地址
        if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())) {
            view.addObject(ConstProp.REG_CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
        }
        if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())) {
            view.addObject(ConstProp.REG_AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
        }
        if (StringUtils.isNotEmpty(vo.getMailPolicyVo().getBank_province())) {
            view.addObject(ConstProp.BANKCITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getMailPolicyVo().getBank_province()));
        }
        //被保险人地址
        if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getReg_province())) {
            view.addObject(ConstProp.REG_CITY_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(1).getReg_province()));
        }
        if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getReg_city())) {
            view.addObject(ConstProp.REG_AREA_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(1).getReg_city()));
        }
        view.addObject(ConstProp.VO, vo);
        view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_bd");
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
    }

    private void gclyGet(Long order_id, int page, ModelAndView view){
        if (page == 1) {
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_1");
            //第一页内容存储
            SpecialPerformanceVo_1 vo = policyService.accordingToOrderIDToGetSpecialPerformanceVo_1(order_id);

            view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
            if (StringUtils.isNotEmpty(vo.getProvince())) {
                view.addObject(ConstProp.CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getProvince()));
            }
            if (StringUtils.isNotEmpty(vo.getProvince())) {
                view.addObject(ConstProp.AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getCity()));
            }
            view.addObject(ConstProp.VO, vo);
        } else if (page == 2) {
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_2");
            //第二页内容存储
            SpecialPerformanceVo_2 vo = policyService.accordingToOrderIDToGetSpecialPerformanceVo_2(order_id);
            view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
            if (StringUtils.isNotEmpty(vo.getMailPolicyVo().getBank_province())) {
                view.addObject(ConstProp.BANKCITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getMailPolicyVo().getBank_province()));
            }
            view.addObject(ConstProp.VO, vo);

            if (vo.getRoleSubjectList().size() <= 0) {
                return;
            }
            //投保人地址
            if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())) {
                view.addObject(ConstProp.REG_CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
            }
            if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())) {
                view.addObject(ConstProp.REG_AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
            }
            //被保险人地址
            if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getReg_province())) {
                view.addObject(ConstProp.REG_CITY_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(1).getReg_province()));
            }
            if (StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getReg_city())) {
                view.addObject(ConstProp.REG_AREA_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(1).getReg_city()));
            }
        } else if (page == 3) {
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_3");
            //第三页内容存储
            SpecialPerformanceVo_3 vo = policyService.accordingToOrderIDToGetSpecialPerformanceVo_3(order_id);
            view.addObject(ConstProp.VO, vo);
        }
    }
}
