package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 加载订单确认页页面数据渲染业务策略
 * @author zxf
 * @date 2018/08/30
 * @说明 策略方案提议及案例提供人：hzp 2018/06/12
 */
@Component
@OrderSupplyType(type = OrderSupplyType.OrderSupplyTypeEnum.CONFIRM_POLICY)
public class StragegyConfirmPolicy implements OrderSupplyStrategy {

    @Autowired
    private PolicyService policyService;

    @Autowired
    private ProductService productService;

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        return null;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        return null;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        ModelAndView view = new ModelAndView();
        //订单基础信息
        OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
        //产品基础信息
        ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.XYX_DQCK)){
            dqckConfirm(dto, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.XYX_XWCK)){
            xwckConfirm(dto, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.BZX_SSBQ)){
            ssbqConfirm(dto, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZX)){
            gzxConfirm(dto, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX)){
            tyxConfirm(dto, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX)){
            gzzrxConfirm(dto, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX)){
            zzxConfirm(dto, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GCTB)){
            gctbConfirm(dto, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GCLY)){
            gclyConfirm(dto, view);
        }
        view.addObject(ConstProp.PD,pd);
        view.addObject(ConstProp.DTO,dto);
        return view;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        return null;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        return null;
    }

    private void dqckConfirm(OrderFormVo dto, ModelAndView view){
        view.setViewName("/coninsweb/insurance/customs/policy/policyConfirm_my");
        long order_id = Long.parseLong(dto.getOid());
        CommonExportVo_1 vo1 = policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
        CommonExportVo_2 vo2 = policyService.accordingToOrderIDToGetCommonExportVo_2(order_id);
        CommonExportVo_3 vo3 = policyService.accordingToOrderIDToGetCommonExportVo_3(order_id);
        view.addObject(ConstProp.VO1,vo1);
        view.addObject(ConstProp.VO2,vo2);
        view.addObject(ConstProp.VO3,vo3);
        view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo1.getRoleSubjectList().get(0).getReg_province(),vo1.getRoleSubjectList().get(0).getReg_city(),vo1.getRoleSubjectList().get(0).getReg_district()));
    }
    private void xwckConfirm(OrderFormVo dto, ModelAndView view){
        view.setViewName("/coninsweb/insurance/customs/policy/policyConfirm_mi");
        MicroExportVo vo = policyService.accordingToOrderIDToGetMicroExportVo(Long.parseLong(dto.getOid()));
        view.addObject(ConstProp.VO,vo);
        view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
        view.addObject(ConstProp.REG_RULE, RegionUtils.getRegionNameByALLCode(vo.getLawsuit_province(),vo.getLawsuit_city(),vo.getLawsuit_area())+vo.getLawsuit_address());
    }

    private void ssbqConfirm(OrderFormVo dto, ModelAndView view){
        view.setViewName("/coninsweb/insurance/lawsuit/policy/policyConfirm_ss");
        long order_id = Long.parseLong(dto.getOid());
        SpecialLitigationVo_1 vo1 = policyService.accordingToOrderIDToGetSpecialLitigationVo_1(order_id);
        SpecialLitigationVo_2 vo2 = policyService.accordingToOrderIDToGetSpecialLitigationVo_2(order_id);
        SpecialLitigationVo_3 vo3 = policyService.accordingToOrderIDToGetSpecialLitigationVo_3(order_id);
        view.addObject(ConstProp.VO1,vo1);
        view.addObject(ConstProp.VO2,vo2);
        view.addObject(ConstProp.VO3,vo3);
        view.addObject(ConstProp.REG_POLICY, RegionUtils.getRegionNameByALLCode(vo1.getProvince(),vo1.getCity(),vo1.getArea_code()));
        view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo1.getRoleSubjectList().get(0).getReg_province(),vo1.getRoleSubjectList().get(0).getReg_city(),vo1.getRoleSubjectList().get(0).getReg_district()));
    }

    private void gzxConfirm(OrderFormVo dto, ModelAndView view){
        view.addObject("comTypeList", IdType.comList());
        view.setViewName("/coninsweb/api/gzx/policy/policyConfirm");
        SpecialPublicDutyVo vo = policyService.accordingToOrderIDToGetSpecialPublicDutyVo(Long.parseLong(dto.getOid()));
        view.addObject(ConstProp.VO,vo);
        view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
        view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
    }

    private void tyxConfirm(OrderFormVo dto, ModelAndView view){
        view.setViewName("/coninsweb/api/gmr/policy/policyConfirm");
        GMRPolicyVo vo = policyService.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(dto.getOid()));
        List<NatureLinkage> natureList = NatureLinkage.doList();
        List<IdType> typeList = IdType.doList();
        view.addObject(ConstProp.VO,vo);
        view.addObject("typeList",typeList);
        view.addObject("natureList",natureList);
        view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
    }

    private void gzzrxConfirm(OrderFormVo dto, ModelAndView view){
        view.setViewName("/coninsweb/api/gzzrx/policy/policy_confirm");
        SpecialHirelingVo vo = policyService.accordingToOrderIDToGetSpecialHirelingVo(Long.parseLong(dto.getOid()));
        List<NatureLinkage> natureList = NatureLinkage.doList();
        List<IdType> typeList = IdType.doList();
        view.addObject(ConstProp.VO,vo);
        view.addObject("typeList",typeList);
        view.addObject("natureList",natureList);
        view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
    }

    private void zzxConfirm(OrderFormVo dto, ModelAndView view){
        view.addObject("comTypeList", IdType.comList());
        view.setViewName("/coninsweb/api/lote/policy/policyConfirm");
        LOTEPolicyVo vo = policyService.accordingToOrderIDToGetLOTEPolicyVo(Long.parseLong(dto.getOid()));
        view.addObject(ConstProp.VO,vo);
        view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
        view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
        view.addObject("ex_pca", RegionUtils.getRegionNameByALLCode(vo.getSpecialExhibitionVo().getEx_province(),vo.getSpecialExhibitionVo().getEx_city(),vo.getSpecialExhibitionVo().getEx_county()));
    }

    private void gctbConfirm(OrderFormVo dto, ModelAndView view){
        view.setViewName("/coninsweb/insurance/build/policy/policyConfirm_bd");
        SpecialBidVo vo = policyService.accordingToOrderIDToGetSpecialBidVo(Long.parseLong(dto.getOid()));
        view.addObject("otList", OfficeType.listT(dto.getProduct_code().contains("DB")?"DB":"OT"));
        view.addObject(ConstProp.VO, vo);
        view.addObject(ConstProp.REG_POLICY, RegionUtils.getRegionNameByALLCode(vo.getProvince(), vo.getCity(), vo.getArea_code()));
        view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(), vo.getRoleSubjectList().get(0).getReg_city(), vo.getRoleSubjectList().get(0).getReg_district()));
        view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
    }

    private void gclyConfirm(OrderFormVo dto, ModelAndView view){
        view.setViewName("/coninsweb/insurance/build/policy/policyConfirm_ly");
        long order_id = Long.parseLong(dto.getOid());
        SpecialPerformanceVo_1 vo1 = policyService.accordingToOrderIDToGetSpecialPerformanceVo_1(order_id);
        SpecialPerformanceVo_2 vo2 = policyService.accordingToOrderIDToGetSpecialPerformanceVo_2(order_id);
        SpecialPerformanceVo_3 vo3 = policyService.accordingToOrderIDToGetSpecialPerformanceVo_3(order_id);
        view.addObject(ConstProp.VO1, vo1);
        view.addObject(ConstProp.VO2, vo2);
        view.addObject(ConstProp.VO3, vo3);
        view.addObject(ConstProp.REG_POLICY, RegionUtils.getRegionNameByALLCode(vo1.getProvince(), vo1.getCity(), vo1.getArea_code()));
        view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo2.getRoleSubjectList().get(0).getReg_province(), vo2.getRoleSubjectList().get(0).getReg_city(), vo2.getRoleSubjectList().get(0).getReg_district()));
    }
}
