package com.bcxin.ins.coninsweb.order.controller.transation;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

/**
 * 订单交易结果
 * @author zxf
 *
 */
@Controller
@RequestMapping("/transaction")
public class TransactionController extends BaseController {

	@Autowired
	private PolicyService policyService;
	@Autowired
	private InsTransactionAPIService transactionService;



	/**
	 * 正常回调地址
	 * 暂时支持常规的结果成功失败展示页面，不包含如：泰康缴费通知页，诉讼待核保页，众安展责，阳光投标结果页给对方配置。
	 * 已配：人保团意险，
	 * @param oid 订单id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/common-syntony/{oid}")
	public ModelAndView commonSyntony(@PathVariable("oid") String oid) {
		logger.info("正常回调页面展示-star");
		logger.info("正常回调页面展示-common-syntony：oid:"+oid);
		ModelAndView view = new ModelAndView();
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(oid));
		if(StringUtils.isNotEmpty(dto.getProduct_code()) && (ConstProp.GYX.equals(dto.getProduct_code().split("-")[0])
				||ConstProp.BZX_DB_GCTB.equals(dto.getProduct_code())
				||ConstProp.ZZX_ZA.equals(dto.getProduct_code())
				||ConstProp.BZX_YG_GCTB.equals(dto.getProduct_code()))){
			//不在iframe中，页面含有头部底部：个意险，投标都邦
			view.setViewName("/coninsweb/api/transaction/finish_pay_no_iframe");
		}else{
			//在iframe中：平安、人保团意险，公责，展责，雇主
			view.setViewName("/coninsweb/api/transaction/finish_pay_iframe");
		}
		view.addObject(ConstProp.DTO,dto);
		logger.info("正常回调页面展示-end");
		setTokenByApi(view);
		return view;
	}

	/*  以下方法场景：当对接方（保险公司）支付方式为返回微信支付地址需我方转成二维码供用户支付，或者对接方直接返回二维码图供用户支付，
	 *	这时我们的支付页面需要不断通过下列方法用于判断保险公司是否推送承保信息（支付对象为保险公司我方无法确定用户是否支付）
	 *	star--*/

	/**
	 * <b> 判断是否支付 </b>
	 * @author ZXF
	 * @create 2018/08/30 0030 11:28
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/isPaySuccess/{oid}")
	public @ResponseBody String isPaySuccess(@PathVariable long oid){
		JSONObject json = new JSONObject();
		List<InsTransaction> tranList = transactionService.selectInsTransactionByInsOrderForm(oid);
		String status = ConstProp.CODE_FAILURE;
		if(tranList.size()>0){
			InsTransaction it = tranList.get(0);
			if(DictConst.PAY_STATUS_YZF.equals(it.getTransaction_status())){
				status = ConstProp.CODE_SUCCESS;
			}
		}
		json.put("status", status);
		return json.toJSONString();
	}

	/**
	 * <b> 判断是否承保 </b>
	 * @author ZXF
	 * @create 2018/08/30 0030 11:29
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/isPolicyUnderwrite/{oid}")
	public @ResponseBody String isPolicyUnderwrite(@PathVariable long oid){
		JSONObject json = new JSONObject();
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(oid);
		String status = ConstProp.CODE_FAILURE;
		if(orderVo != null){
			if(ConstProp.DIGIT_SIX.equals(orderVo.getPolicy_status())){
				status = ConstProp.CODE_SUCCESS;
			}
		}
		json.put("status", status);
		return json.toJSONString();
	}

	/*	end--*/



}
