package com.bcxin.ins.coninsweb.order.controller.insurance.gzzrx;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.third.gzzrx.changan.GZZRX_CARequestService;
import com.bcxin.ins.third.gzzrx.pingancai.GZZRX_PACRequestService;
import com.bcxin.ins.third.gzzrx.qianhai.GZZRX_QHRequestService;
import com.bcxin.ins.third.gzzrx.renbao.GZZRX_RBRequestService;
import com.bcxin.ins.third.gzzrx.taibao.GZZRX_TBRequestService;
import com.bcxin.ins.third.gzzrx.zhonghua.GZZRX_ZHRequestService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 投保流程结束后，交易流程处理
 * @author zxf
 *
 */
@Controller
@RequestMapping("/insurance/gzzrx/transaction")
public class GZZRXTransactionController extends BaseController {

	@Autowired
	private GZZRX_RBRequestService gZZRX_RBRequestService;
	@Autowired
	private GZZRX_ZHRequestService gZZRX_ZHRequestService;
	@Autowired
	private GZZRX_PACRequestService gZZRX_PACRequestService;
	@Autowired
	private GZZRX_CARequestService gZZRX_CARequestService;
	@Autowired
	private GZZRX_QHRequestService gZZRX_QHRequestService;
	@Autowired
	private GZZRX_TBRequestService gZZRX_TBRequestService;
	@Autowired
	private ProductService productService;
	@Autowired
	private PolicyService policyService;
	@Autowired
	private InsTransactionAPIService transactionService;
	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipAPIService;

	/**
	 * 雇主责任险核保接口
	 * @param request 参数policyId 订单id
	 * @param response
	 * @return 返回200成功，300失败
	 * @throws Exception
	 */
	@LoginRequired
	@RequestMapping("/API_Underwriting")
	@ResponseBody
	public ResultDto API_Underwriting(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String oid = request.getParameter("policyId");
		String isPayFee = request.getParameter("isPayFee");
		if(StringUtils.isEmpty(oid)){
			return new ResultDto("（APP-GZZRX-008）数据丢失！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return getResultDto(oid, isPayFee);
	}

	private ResultDto getResultDto(String oid, String isPayFee) throws Exception {

		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(oid));
		if(dto == null){
			return new ResultDto("（APP-GZZRX-009）未匹配到有效订单！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		//设置是否见费，默认见费
		insInsuranceSlipAPIService.updateIsPolicyBeforePayFee(StringUtils.isEmpty(isPayFee)?1:Integer.parseInt(isPayFee),Long.parseLong(oid));
		String result;
		//前海接口
		if(dto.getProduct_code().contains(ConstProp.GZZRX_QH)){
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			result = gZZRX_QHRequestService.request_qh_gzzrx(Long.parseLong(oid),ConstProp.DIGIT_ONE,null);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])){
				return new ResultDto(strs[1], ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(StringUtils.isEmpty(strs[1])){
				return new ResultDto("（APP-GZZRX-009）数据丢失！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			String payNo = String.valueOf(idWorker.nextId());
			String payPath = strs[2];
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setPolicy_id(oid);
			//设置投保单号
			pvo.setPolicy_serial_number(strs[1]);
			pvo.setDeal_url(payPath);
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			//支付方式
			pvo.setPay_type(DictConst.PAY_TYPE_XS);
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
			pvo.setTransaction_status(DictConst.PAY_STATUS_WZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			pvo.setPay_order_number(payNo);
			pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
			policyService.saveTransaction(pvo);
			return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		//人保接口
		if(dto.getProduct_code().contains(ConstProp.GZZRX_RB)){
			result = gZZRX_RBRequestService.request_rb_gzzrx(Long.parseLong(oid),ConstProp.DIGIT_ONE,null);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])){
				return new ResultDto(strs[1], ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(StringUtils.isEmpty(strs[1])){
				return new ResultDto("（APP-GZZRX-009）数据丢失！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			String payNo = strs[2].split(",")[0].split("：")[1];
			String payPath = strs[2].split(",")[1].split("：")[1];
			if(StringUtils.isNotEmpty(payPath)){
				payPath = payPath
						.replace("<![CDATA[",ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR)
						.replace("&lt;![CDATA[",ConstProp.BLANK_CHAR).replace("]]&gt;",ConstProp.BLANK_CHAR);
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setPolicy_id(oid);
			//设置投保单号
			pvo.setPolicy_serial_number(strs[1]);
			pvo.setDeal_url(payPath);
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			//支付方式
			pvo.setPay_type(DictConst.PAY_TYPE_WX);
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
			pvo.setTransaction_status(DictConst.PAY_STATUS_WZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			pvo.setPay_order_number(payNo);
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
			policyService.saveTransaction(pvo);
			return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(dto.getProduct_code().contains(ConstProp.GZZRX_ZH)||dto.getProduct_code().contains(ConstProp.GZZRX_XZH)){//中华接口
			result = gZZRX_ZHRequestService.request_zh_gzzrx(Long.parseLong(oid),ConstProp.DIGIT_ONE,null);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])){
				return new ResultDto(strs[1], ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(StringUtils.isNotEmpty(strs[1])){
				PolicyTransactionVo pvo= new PolicyTransactionVo();
				pvo.setPolicy_id(oid);
				pvo.setPolicy_serial_number(strs[1]);//设置投保单号
				policyService.saveTransaction(pvo);
				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("（APP-GZZRX-009）数据丢失！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}
		//长安接口
		if(dto.getProduct_code().contains(ConstProp.GZZRX_CA)){
			result = gZZRX_CARequestService.request_ca_gzzrx(Long.parseLong(oid), TransTypeEnum.HB.getValue(),null);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])){
				return new ResultDto(strs[1], ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(StringUtils.isEmpty(strs[1])){
				return new ResultDto("（APP-GZZRX-009）数据丢失！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			//见费
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setPolicy_id(oid);
			pvo.setPolicy_serial_number(strs[1]);//设置投保单号
			policyService.saveTransaction(pvo);
			return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		//平安财接口
		if(dto.getProduct_code().contains(ConstProp.GZZRX_PAC)){
			result = gZZRX_PACRequestService.requestPAC(Long.parseLong(oid),ConstProp.DIGIT_ONE,null);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])){
				return new ResultDto(strs[1], ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(StringUtils.isEmpty(strs[1])){
				return new ResultDto("（APP-GZZRX-009）数据丢失！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			//见费
			if(DictConst.PAY_FEE_JF.equals(isPayFee)){
				PolicyTransactionVo pvo= new PolicyTransactionVo();
				pvo.setPolicy_id(oid);
				pvo.setPolicy_serial_number(strs[1]);//设置投保单号
				pvo.setNotice_no(strs[5]);//通知单号
				policyService.saveTransaction(pvo);
			}else{
				IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
				PolicyTransactionVo pvo= new PolicyTransactionVo();
				pvo.setPolicy_id(oid);
				pvo.setPolicy_serial_number(strs[1]);//设置投保单号
				pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));//设置交易流水号
				pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
				pvo.setPayment_method(ConstProp.DIGIT_ONE);
				pvo.setPay_type(DictConst.PAY_TYPE_XX);//支付方式，线下支付
				pvo.setPolicy_id(dto.getOid());
				pvo.setTransaction_status(DictConst.PAY_STATUS_WZF);
				pvo.setPath_sign(ConstProp.DIGIT_ONE);
				pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
				policyService.saveTransaction(pvo);
				//承保后支付业务
				policyService.HTTP_PAC_GZZRX_CB(Long.parseLong(oid),strs[2]);
			}
			return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		//太保接口
		if(dto.getProduct_code().contains(ConstProp.GZZRX_TB)){
			result = gZZRX_TBRequestService.request_tb_gzzrx(Long.parseLong(oid),TransTypeEnum.HB.getValue(),null);
			//{"subPolicyList":[{"plcSumInsured":1500000,"payApplyNo":"702405198651","plcApplyNo":"ABEJ60037124FM00001C","plcStatus":"08","plcType":"A","payUrl":"https://mpaysit.cpic.com.cn/mpayweb/payWebPc?6c5e645e45042d0ca00090e047c44b1bd5ce60ca9712cecef7299a8755b82892ac37b5968676320ec2e87faa6aa057dfb79335c4c105d00129cb8b1d31fcdb1630feb7b806198d27ac6d1796368091ca38abc55bc1a4947d45d4ee8fb4c5bd133a69c6f9e84dcdb87087bb2c9cddc19687f63578f13e0dd73580dc510245b22a848050db8c84c806feb091c885ce5c7c0487f987e1ec0b6ca92bc5ab84ba37760b8af964e6b2b7d654cfa6ba1e6ce9ff9bb7795d0f8fe77fb185f3b15943c371717af3500254f470986aa81e7b045682dbd23a24bb02af5a409d1ff6f2dd9093b531e432fa7fde6d0af5abce78dc14af8f342b091ddf55a2c2383235a6184a537d4cb18ec13445505f15ce4ac336b7b43ae485f5633e399940848e40901ce9396f71f9d4ecd46b0afb215d0fe1c61663692c3aa8e71cbf245ec5df40d9b7dbcf39c4961633822cebbbf5f14af4d39e65","plcPremium":885.00,"plcPolicyNo":""}],"message":"处理成功","plcOrderNo":"1762043301424394240","plcBusinessNo":"1773519583030931456","code":"000000"}
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])){
				return new ResultDto(strs[1], ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(StringUtils.isEmpty(strs[1])){
				return new ResultDto("（APP-GZZRX-009）数据丢失！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setPolicy_id(oid);
			//设置投保单号
			pvo.setPolicy_serial_number(strs[1]);
			pvo.setDeal_url(strs[6]);
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			//支付方式
			pvo.setPay_type(DictConst.PAY_TYPE_WX);
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
			pvo.setTransaction_status(DictConst.PAY_STATUS_WZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			pvo.setPay_order_number(strs[5]);
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
			policyService.saveTransaction(pvo);
			return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return  new ResultDto("（APP-GZZRX-010）未匹配到产品编码！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
	}

	@RequestMapping("/failMessage")
	public ModelAndView failMessage(HttpServletRequest request) {
//		String msg = request.getParameter("msg");
		ModelAndView view = new ModelAndView("/coninsweb/insurance/gzzrx/transaction/failMessage");
		setTokenByApi(view);
//		view.addObject("msg", msg);
		return view;
	}

	/**
	 * 雇主责任险回调地址
	 * @param oid 订单id
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/syntony-service/{oid}")
	public ModelAndView syntonyService(@PathVariable("oid") String oid,HttpServletRequest request) {
		logger.info("雇主责任险承保完成后页面展示-star");
		logger.info("雇主责任险承保完成后页面展示-syntony-service：oid:"+oid);
		ModelAndView view = new ModelAndView("/coninsweb/insurance/gzzrx/transaction/finishPay");
		if(StringUtils.isNotEmpty(oid)){
			OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(oid));
			ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
			view.addObject(ConstProp.PD,pd);
			view.addObject(ConstProp.DTO,dto);
			logger.info("雇主责任险承保完成后页面展示-OrderFormVo："+dto.toString());
		}
		view.addObject("oid",oid);
		logger.info("雇主责任险承保完成后页面展示-end");
		setTokenByApi(view);
		return view;
	}

	/**
	 * 雇主责任险回调地址
	 * @param oid 订单id
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/syntony-service-record/{oid}")
	public ModelAndView syntonyServiceRecord(@PathVariable("oid") String oid,HttpServletRequest request) {
		ModelAndView view = new ModelAndView("/coninsweb/insurance/gzzrx/transaction/finishPayClose");
		return view;
	}

	@RequestMapping("/isPaySuccess/{oid}")
	public @ResponseBody String isPaySuccess(@PathVariable long oid){
		JSONObject json = new JSONObject();
		List<InsTransaction> tranList = transactionService.selectInsTransactionByInsOrderForm(oid);
		String status = ConstProp.CODE_FAILURE;
		if(tranList.size()>0){
			InsTransaction it = tranList.get(0);
			if(DictConst.PAY_STATUS_YZF.equals(it.getTransaction_status())){
				status = ConstProp.CODE_SUCCESS;
			}
		}
		json.put("status", status);
		return json.toJSONString();
	}

	@RequestMapping("/isPolicyUnderwrite/{oid}")
	public @ResponseBody String isPolicyUnderwrite(@PathVariable long oid){
		JSONObject json = new JSONObject();
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(oid);
		String status = ConstProp.CODE_FAILURE;
		if(orderVo != null){
			if(DictConst.ORDER_STATUS_YCB.equals(orderVo.getPolicy_status())){
				status = ConstProp.CODE_SUCCESS;
			}
		}
		json.put("status", status);
		return json.toJSONString();
	}

	/**
	 * 雇主责任险支付完成页面-都邦
	 * @param oid 订单id
	 * @param request
	 * @return
	 */
	@RequestMapping("/policyUnderwrite/{oid}")
	public ModelAndView policyUnderwrite(@PathVariable("oid") String oid,HttpServletRequest request) {
		logger.info("雇主责任险承保完成后页面展示-star");
		logger.info("雇主责任险承保完成后页面展示-policyUnderwrite：oid:"+oid);
		ModelAndView view = new ModelAndView("/coninsweb/insurance/gzzrx/transaction/finishPay");
		if(StringUtils.isNotEmpty(oid)){
			OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(oid));
			ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
			view.addObject(ConstProp.PD,pd);
			view.addObject(ConstProp.DTO,dto);
			logger.info("雇主责任险承保完成后页面展示-OrderFormVo："+dto.toString());
		}
		view.addObject("oid",oid);
		logger.info("雇主责任险承保完成后页面展示-end");
		setTokenByApi(view);
		return view;
	}

	@RequestMapping("/uploadPayMentFile")
	@ResponseBody
	public ResultDto uploadPayMentFile(HttpServletRequest request){
		String doPayments = request.getParameter("doPayments");
		String payAmount = request.getParameter("payAmount");
		String oid = request.getParameter("oid");
		String paymentPath = request.getParameter("paymentPath");
		if(StringUtils.isEmpty(doPayments) || StringUtils.isEmpty(payAmount) || StringUtils.isEmpty(oid)|| StringUtils.isEmpty(paymentPath)){
			return new ResultDto("数据丢失，操作失败！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		String orderID = policyService.uploadPayMentFileToTranction(paymentPath, oid, doPayments, payAmount);
		if(StringUtils.isNotEmpty(orderID)){
			//完成上传后异步发送邮件
			new Thread(()->{
				policyService.JFPZ_SendEmail(Long.parseLong(oid),paymentPath);
			}).start();
			return new ResultDto("上传成功！", ConstProp.CODE_SUCCESS, "true", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("数据存储失败！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b> 打印投保单 </b>
	 * @author ZXF
	 * @create 2021/03/26 0026 11:23
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/printPolicy/{order_id}")
	public ModelAndView printPolicy(@PathVariable Long order_id) {
		ModelAndView view = new ModelAndView();
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
		view.addObject(ConstProp.PD,pd);
		view.addObject(ConstProp.DTO,dto);
		if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains("GZZRX")){
			view.setViewName("/coninsweb/insurance/gzzrx/policy/policyPrint");
			SpecialHirelingVo vo = policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
			List<NatureLinkage> natureList = NatureLinkage.doList();
			List<IdType> typeList = IdType.doList();
			view.addObject(ConstProp.VO,vo);
			view.addObject("typeList",typeList);
			view.addObject("natureList",natureList);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(),vo.getRoleSubjectList().get(1).getReg_city(),vo.getRoleSubjectList().get(1).getReg_district()));
		}
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b> 保存盖章投保单 </b>
	 * @author ZXF
	 * @create 2021/03/26 0026 11:30
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/saveSealInsuranceApplication")
	@ResponseBody
	public ResultDto saveSealInsuranceApplication(InsureVo insInsuranceSlip){
		InsInsuranceSlip oldPolicy = insInsuranceSlipAPIService.selectById(insInsuranceSlip.getIns_insurance_slip_id());
		if(StringUtils.isNotEmpty(insInsuranceSlip.getUser_insure_path())){
			oldPolicy.setUser_insure_path(insInsuranceSlip.getUser_insure_path());
			insInsuranceSlipAPIService.updateById(oldPolicy);
			//在保订单修改后需要清理缓存，以便下次加载到最新数据
			JedisUtils.batchDel(ConstProp.REDIS_HEAD_POLICY_ID+oldPolicy.getIns_insurance_slip_id());
			return new ResultDto("上传成功！", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		} else {
			return new ResultDto("上传失败！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}
}
