package com.bcxin.ins.coninsweb.order.controller.insurance.afr;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 负责前台公责险投保流程的业务逻辑处理
 *
 * @author zxf
 */
@Controller
@RequestMapping("/insurance/afr/product")
public class AFRProductController extends BaseController{
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;

    @RequestMapping("/pro_afr_info/{product_id}")
    public ModelAndView proAfrInfo( @PathVariable Long product_id) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/pro_afr_info");
        view.addObject("product_id",String.valueOf(product_id));
        return view;
    }


    /**
     *
     * <b>产品中心，各分类产品列表 </b>
     *
     * @param oid
     * @return
     * @author ZXF
     * @date 2016年12月14日 下午5:22:29
     * @注意事项 </b>
     * <b>
     */
    @LoginRequired(methodParamKey={"0#oid"}, redirectUrl = "insurance/afr/policy/policy_iframe/{oid}")
    @RequestMapping("/policy/policy_iframe/{oid}")
    public ModelAndView policy_iframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/order_afr_info");
        OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(oid);
        view.addObject(ConstProp.ORDER_ID, dto.getOid());
        view.addObject("product_id", dto.getProduct_oid());
        setTokenByApi(view);
        return view;
    }

    /**
     *
     * <b>跳转到投保界面 </b>
     *
     * @param oid
     * @return
     * @author ZXF
     * @date 2016年12月14日 下午5:22:29
     * @注意事项 </b>
     * <b>
     */
    @LoginRequired(methodParamKey={"0#oid"}, redirectUrl = "insurance/afr/policy/payment_iframe/{oid}")
    @RequestMapping("/policy/payment_iframe/{oid}")
    public ModelAndView payment_iframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/order_afr_pay");
        view.addObject(ConstProp.ORDER_ID, String.valueOf(oid));
        setTokenByApi(view);
        return view;
    }

    /**
     * 初始化购买页面
     *
     */
    @RequestMapping("/productInit/{oid}")
    public ModelAndView productInit(HttpServletRequest request, @PathVariable Long oid, ModelMap model) {
        ModelAndView view = new ModelAndView();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ProductVo pd = productService.getProduct(oid);
        if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(pd.getOid())){
            view.addObject(ConstProp.SHAREPATH,productService.setSharePath(oid,userdetail));
        }else{
            return null;
        }
        if(com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZX_HT)){
            view.setViewName("/coninsweb/insurance/afr/product/gzx_ht_product_info");
        }
        view.addObject(ConstProp.PRODUCTDTO, pd);
        view.addObject(ConstProp.USERDETAIL,userdetail);
        setTokenByApi(view);
        return view;
    }
}
