package com.bcxin.ins.coninsweb.order.controller.export.web;


import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysDict;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.entity.common.ComBuyers;
import com.bcxin.ins.entity.policy_core.*;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.service.order.*;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.*;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Controller
@RequestMapping("/ship/declare")
public class ShipDeclareAPIController extends BaseController {

    @Autowired
    private ShipDeclareAPIService shipDeclareService;

    @Autowired
    private InsBuyersAPIService insBuyersService;

    @Autowired
    private InsTopBuyersAPIService insTopBuyersService;

    @Autowired
    private ShipInvoicesAPIService shipInvoicesService;

    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;


    @Autowired
    private ShipReceiveAPIService shipReceiveService;


    //
//    //出运申报首页
    @RequestMapping(value = {"/", "/index"})
    public ModelAndView getReceiveAccountsCenter(HttpServletRequest request, ModelMap model, DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/index");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
        } else {
            view.addObject(ConstProp.USERDETAIL, userdetail);
            //初始化Page相关参数。
            page.setNumPerPage(6);
            List<OrderFormVo> lis = shipDeclareService.getCanShipDeclareList(Long.parseLong(userdetail.getOid()), page);
            view.addObject("orderFormVoList", lis);
        }
        return view;
    }

    //
//    // 出运申报首页获取的可出运订单列表 --已重构完成
    @SuppressWarnings("unchecked")
    @RequestMapping(value = "/getPolicyListForPage")
    public ModelAndView getPolicyListForPage(DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/policyList_table");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject(ConstProp.USERDETAIL, userdetail);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userdetail.getOid());
        map.put("page", page);
        List<OrderFormVo> lis = shipDeclareService.getCanShipDeclareList(Long.parseLong(userdetail.getOid()), page);
        if (lis != null) {
            view.addObject("orderFormVoList", lis);
        }
        return view;
    }

    //
//    //根据用户选择的订单跳转到查询页面   --已重构完成
    @RequestMapping("/choise/{orderFormId}")
    public ModelAndView getPolicyListForPage(@PathVariable Long orderFormId, DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/searchResult");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("orderFormId", orderFormId);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject(ConstProp.USERDETAIL, userdetail);
        //获取页面上搜索的准备信息
        page.setNumPerPage(6);

        OrderFormVo orderFormVo = shipDeclareService.getOrderFormVoByOrderFormId(orderFormId);

        if (orderFormVo == null) {
            return view;
        }
        // 初始化页面VO 设置订单VO 取保单号等使用
        ShipDeclareStepTwoVo shipDeclareStepTwoVo = new ShipDeclareStepTwoVo();
        shipDeclareStepTwoVo.setOrderFormVo(orderFormVo);
        // 设置被保险人列表
        List<String> insuredNameList = shipDeclareService.getInsureNameList(orderFormId);
        if (null != insuredNameList) {
            shipDeclareStepTwoVo.setInsuredNameList(rmDuplication(insuredNameList));
        }
        // 查詢该订单下已申请的出运列表
        List<InsShipDeclare> shipDeclareList = shipDeclareService.getShipDeclareByInsOrderFormId(orderFormId, null);
        if (null != shipDeclareList) {
            List<String> countryList2 = new ArrayList<String>();
            for (InsShipDeclare shipDeclare : shipDeclareList) {
                Long insTopBuyersId = shipDeclare.getSt_top_buyers_id();
                // 一个出运对应一个买家
                StTopBuyers insTopBuyers = insTopBuyersService.selectById(insTopBuyersId);
                ComBuyers comBuyers = insBuyersService.selectById(insTopBuyers.getCom_buyer().getCom_buyer_id());
                String country = insTopBuyers.getCom_buyer().getCountry();
                countryList2.add(country);
            }
            shipDeclareStepTwoVo.setCountryList(rmDuplication(countryList2));
        }
        //初始化分页参数
        List<ShipDeclareMultipleVo> lis = shipDeclareService.getShipDeclareVoByInsOrderFormId(orderFormId, page);
        view.addObject(ConstProp.VO, shipDeclareStepTwoVo);
        view.addObject("page", page);
        return view;
    }


    private List<String> rmDuplication(List<String> list) {
        List<String> listReturn = new ArrayList<String>();
        for (String s : list) {
            if (Collections.frequency(listReturn, s) < 1) {
                listReturn.add(s);
            }
        }
        return listReturn;
    }

    //
//
//    //--------------------------------------------------------
//
//    //根据用户选择的订单跳转到查询页面   --已重构完成 --搜索改版中
    @RequestMapping("/choise_new/{orderFormId}")
    public ModelAndView getDetailSearch(@PathVariable Long orderFormId, DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/choiseDetailSearch_new");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("orderFormId", orderFormId);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject(ConstProp.USERDETAIL, userdetail);
        // 获取页面上搜索的准备信息
        page.setNumPerPage(6);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("orderFormId", orderFormId);
        map.put("page", page);
        ShipDeclareStepTwoVo shipDeclareStepTwoVo = new ShipDeclareStepTwoVo();
        OrderFormVo orderFormVo = shipDeclareService.getOrderFormVoByOrderFormId(orderFormId);
        shipDeclareStepTwoVo.setOrderFormVo(orderFormVo);
        // 设置被保险人列表
        List<String> insuredNameList = shipDeclareService.getInsureNameList(orderFormId);
        if (null != insuredNameList) {
            shipDeclareStepTwoVo.setInsuredNameList(rmDuplication(insuredNameList));
        }
        // 查詢该订单下已申请的出运列表
        List<InsShipDeclare> shipDeclareList = shipDeclareService.getShipDeclareByInsOrderFormId(orderFormId, null);
        if (null != shipDeclareList) {
            List<String> countryList2 = new ArrayList<String>();
            for (InsShipDeclare shipDeclare : shipDeclareList) {
                Long insTopBuyersId = shipDeclare.getSt_top_buyers_id();
                // 一个出运对应一个买家
                StTopBuyers insTopBuyers = insTopBuyersService.selectById(insTopBuyersId);
                ComBuyers comBuyers = insBuyersService.selectById(insTopBuyers.getCom_buyer().getCom_buyer_id());
                String country = comBuyers.getCountry();
                countryList2.add(country);
            }
            shipDeclareStepTwoVo.setCountryList(rmDuplication(countryList2));
        }
        //初始化分页参数
        //List<ShipDeclareMultipleVo> lis = shipDeclareService.getShipDeclareVoByInsOrderFormId(orderFormId, page);
        map.put("shipDeclareStepTwoVo", shipDeclareStepTwoVo);
        map.put("page", page);
        view.addObject("shipDeclareStepTwoVo", shipDeclareStepTwoVo);
        return view;
    }

    //
//
//    //根据保单ID获取所有的出运信息  --已重构完成
    @SuppressWarnings("unchecked")
    @RequestMapping("/getDeclareByPolicyIdForPage_new/{orderFormId}")
    public ModelAndView getDeclaration_noSearch(@PathVariable Long orderFormId, DwzPage page, ShipDeclareStepTwoSearchVo searchVo, String searchType) {
        //根据page的totalCount参数判断是否为第一次请求后台
        ModelAndView view = null;
        if (voIsEmpty(searchVo)) {
            if (StringUtils.isBlank(searchType)&&page.getTotalCount() > 0) {
                view = new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table_only_new");
            } else {
                view = new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table_new");
            }
        } else {
            if (StringUtils.isNotBlank(searchType) && searchType.equals("search2")) {
                view = new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table_only_new");
            } else {
                page.setPageNum(1);
                view = new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table_search_new");
            }
        }
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject(ConstProp.USERDETAIL, userdetail);
        // 获取保单所有的出运信息
        page.setNumPerPage(3);
        List<ShipDeclareMultipleVo> lis = null;
        if (searchVo == null) {
            lis = shipDeclareService.getShipDeclareVoByInsOrderFormId(orderFormId, page);
        } else {
            lis = shipDeclareService.getShipDeclareVoByInsOrderFormIdAndVo(orderFormId, searchVo, page);
        }
        if (lis != null&&lis.size()>0) {
            view.addObject("externalReference", lis.get(0).getExternal_reference());
            view.addObject("voList", lis);
        }
        view.addObject("orderFormId", orderFormId);
        return view;
    }

    private boolean voIsEmpty(ShipDeclareStepTwoSearchVo searchVo) {
        boolean flag = false;
        if (StringUtils.isBlank(searchVo.getBuyer_name())
                && StringUtils.isBlank(searchVo.getCountry())
                && StringUtils.isBlank(searchVo.getEnd_date())
                && StringUtils.isBlank(searchVo.getInsured())
                && StringUtils.isBlank(searchVo.getStart_date())) {
            flag = true;
        }
        return flag;
    }

    //
//
//
//    //--------------------------------------------------------
//
//
//
//
//
//    //根据保单ID获取所有的出运信息  --已重构完成
    @SuppressWarnings("unchecked")
    @RequestMapping("/getDeclareByPolicyIdForPage/{orderFormId}")
    public ModelAndView getDeclaration(@PathVariable Long orderFormId, DwzPage page, ShipDeclareStepTwoSearchVo searchVo) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject(ConstProp.USERDETAIL, userdetail);
        //获取保单所有的出运信息
        List<ShipDeclareMultipleVo> lis = null;
        if (searchVo == null) {
            lis = shipDeclareService.getShipDeclareVoByInsOrderFormId(orderFormId, page);
        } else {
            lis = shipDeclareService.getShipDeclareVoByInsOrderFormIdAndVo(orderFormId, searchVo, page);
        }
        view.addObject("pageBack", page);
        view.addObject("numPerPage", 9);
        if (lis != null) {
            view.addObject(ConstProp.VO, lis);
        }
        return view;
    }

    //
//
//    //删除出运和发票
    @RequestMapping("/deleteShipDeclareById/{shipDeclareId}/{invoiceId}")
    public ResultDto deleteShipDeclare(@PathVariable Long shipDeclareId, @PathVariable Long invoiceId) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("shipDeclareId", shipDeclareId);
        map.put("invoiceId", invoiceId);
        map.put("userId", userdetail.getOid());
        InsShipDeclare shipDeclare = shipDeclareService.selectById(shipDeclareId);
        Long insTopBuyersIdBefore = shipDeclare.getSt_top_buyers_id();
        StTopBuyers insTopBuyers = insTopBuyersService.selectById(insTopBuyersIdBefore);
        List<InsShipInvoices> lis = shipInvoicesService.getShipInvoicesByShipDeclareId(shipDeclareId);
        if (lis.size() == 1) {
            InsShipInvoices shipInvoices = lis.get(0);
            shipInvoices.setStatus(1);
            BigDecimal amount = shipInvoices.getInvoice_amounts();
            if (!insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.parseLong(userdetail.getOid()), 2L, amount)) {
                MessageUtils.returnFailMessage(map, response);
                return null;
            }
            boolean invoices = shipInvoicesService.updateById(shipInvoices);
            if (!invoices) {
                MessageUtils.returnFailMessage(map, response);
                return null;
            }
            shipDeclare.setStatus(1);
            boolean declare = shipDeclareService.updateById(shipDeclare);
            if (!declare) {
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            } else {
                return new ResultDto("取消申报成功！", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        } else if (lis.size() > 1) {
            InsShipInvoices shipInvoices = shipInvoicesService.selectById(invoiceId);
            shipInvoices.setStatus(1);
            BigDecimal amount = shipInvoices.getInvoice_amounts();
            if (!insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.parseLong(userdetail.getOid()), 2L, amount)) {
                MessageUtils.returnFailMessage(map, response);
                return null;
            }
            boolean invoices = shipInvoicesService.updateById(shipInvoices);
            if (!invoices) {
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            } else {
                return new ResultDto("取消申报成功！", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        }

        return null;

    }

    //
//
//
//
//    */
///**
//     * <b>新增出运申报页面</b>
//     * @return
//     * @author liumd
//     * @throws Exception
//     * @date 2016年12月19日 下午2:37:42
//     * @注意事项 </b>
//     * <b>
//     *//*
//
    @SuppressWarnings("unchecked")
    @RequestMapping("/addDeclare/{orderFormId}")
    public ModelAndView addDeclarationPage(@PathVariable Long orderFormId) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/addDeclare");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("orderFormId", orderFormId);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject(ConstProp.USERDETAIL, userdetail);
        view.addObject("orderFormId", orderFormId);
        // 获取被保险人列表
        InsuredListAndBD vo = new InsuredListAndBD();
        List<String> insuredNameList = shipDeclareService.getInsureNameList(orderFormId);
        if (insuredNameList != null) {
            vo.setInsuredList(rmDuplication(insuredNameList));
        }
        view.addObject("insuredListAndBd", vo);
        view.addObject("paymentTermsList", SysDictUtils.getDictList("paymentTerms"));
        view.addObject("transportTypeList", SysDictUtils.getDictList("transportType"));
        return view;
    }

    //
//
//
//    */
///**
//     * <b>新增出运申报页面带买家代码</b>
//     * @return
//     * @author liumd
//     * @throws Exception
//     * @date 2016年12月19日 下午2:37:42
//     * @注意事项 </b>
//     * <b>
//     *//*
//
    @SuppressWarnings("unchecked")
    @RequestMapping("/addDeclareWithBuyers/{orderFormId}/{insTopBuyersId}")
    public ModelAndView addDeclareWithBuyers(@PathVariable Long orderFormId, @PathVariable String insTopBuyersId, String insured) throws Exception {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/addDeclare");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("insured", insured);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        if (StringUtils.isNotBlank(insTopBuyersId) && !"undefined".equals(insTopBuyersId)) {
            StTopBuyers insTopBuyers = insTopBuyersService.packagingInsTopBuyers(Long.parseLong(insTopBuyersId));
            TopBuyersVo vo = insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(insTopBuyers);
            view.addObject("topBuyersVo", vo);
        }
        OrderFormVo orderFormVo = shipDeclareService.getOrderFormVoByOrderFormId(orderFormId);
        // 获取被保险人列表
        InsuredListAndBD vo = new InsuredListAndBD();
        List<String> insuredNameList = shipDeclareService.getInsureNameList(orderFormId);
        if (insuredNameList != null) {
            vo.setInsuredList(rmDuplication(insuredNameList));
        }
        vo.setExternal_reference(orderFormVo.getExternal_reference());
        view.addObject("insuredListAndBd", vo);
        view.addObject("paymentTermsList", SysDictUtils.getDictList("paymentTerms"));
        view.addObject("transportTypeList", SysDictUtils.getDictList("transportType"));
        view.addObject(ConstProp.USERDETAIL, userdetail);
        view.addObject("ins_top_buyers_id", insTopBuyersId);
        return view;
    }

    //
//
//
//    */
///**
//     * <b>修改出运页面带新的买家代码</b>
//     * @return
//     * @author liumd
//     * @throws Exception
//     * @date 2016年12月19日 下午2:37:42
//     * @注意事项 </b>
//     * <b>
//     *//*
//
    @SuppressWarnings("unchecked")
    @RequestMapping("/modifyDeclareWithBuyers/{orderFormId}/{insTopBuyersId}/{code}/{declareId}/{invoiceId}/{externalReference}")
    public ModelAndView modifyDeclareWithBuyers(@PathVariable Long orderFormId, @PathVariable String insTopBuyersId, @PathVariable String code, @PathVariable Long declareId, @PathVariable Long invoiceId, @PathVariable String externalReference) throws Exception {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/addDeclare_Modify_NewBuyers");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        StTopBuyers insTopBuyers = insTopBuyersService.packagingInsTopBuyers(Long.parseLong(insTopBuyersId));
        TopBuyersVo vo = insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(insTopBuyers);
        view.addObject("topBuyersVo", vo);

        Map<String, Object> map2 = new HashMap<String, Object>();
        map2.put("declareId", declareId);
        map2.put("invoiceId", invoiceId);

        ShipDeclareVo shipDeclareVo = new ShipDeclareVo();
        InsShipDeclare shipDeclare = shipDeclareService.selectById(declareId);
        InsShipInvoices shipInvoices = shipInvoicesService.selectById(invoiceId);
        BeanUtils.copyProperties(shipDeclare,shipDeclareVo);
        shipDeclareVo.setInvoice_amounts(shipInvoices.getInvoice_amounts());
        shipDeclareVo.setInvoice_no(shipInvoices.getInvoice_no());
        shipDeclareVo.setInsuredNameList(this.getInsuredNameList(shipDeclare.getIns_order_form_id()));
        view.addObject("paymentTermsList", SysDictUtils.getDictList("paymentTerms"));
        view.addObject("transportTypeList", SysDictUtils.getDictList("transportType"));
        view.addObject(ConstProp.USERDETAIL, userdetail);
        view.addObject("externalReference", externalReference);
        view.addObject("shipDeclareVo", shipDeclareVo);
        view.addObject("insTopBuyersId", insTopBuyersId);
        view.addObject("orderFormId", orderFormId);
        view.addObject("code", code);
        view.addObject("declareId", declareId);
        view.addObject("invoiceId", invoiceId);
        return view;
    }


    private List<String> getInsuredNameList(Long orderFormId) {
        InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsOrderForm(orderFormId);
        //获取被保险人列表
        List<InsRoleInpolicy> insRoleInpolicy = insInsuranceSlip.getRolesOfKind("1");
        List<String> insuredNameList = new ArrayList<String>();
        if (insRoleInpolicy != null) {
            for (InsRoleInpolicy role : insRoleInpolicy) {
                insuredNameList.add(role.getName_cn());
            }
        }
        return insuredNameList.size() > 0 ? insuredNameList : null;
    }

    //
//
//    */
///**
//     * <b>查找买家第一步</b>
//     * @return
//     * @author liumd
//     * @throws Exception
//     * @date 2016年12月19日 下午2:37:42
//     * @注意事项 </b>
//     * <b>
//     *//*
//
    @RequestMapping("/findBuyers/{orderFormId}")
    public ModelAndView findBuyers(@PathVariable Long orderFormId, DwzPage page, String modifyType, Long declareId, Long invoiceId, String externalReference) throws Exception {
        page.setNumPerPage(10);
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/findBuyers_one");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        if (StringUtils.isNotBlank(modifyType) && "1".equals(modifyType)) {
            view.addObject("modifyType", modifyType);
            view.addObject("declareId", declareId);
            view.addObject("invoiceId", invoiceId);
            view.addObject("externalReference", externalReference);
        }
        view.addObject(ConstProp.USERDETAIL, userdetail);
        List<StTopBuyers> lis = insTopBuyersService.getInsTopBuyersByOrderFormId(orderFormId, page);
        List<String> countryList = new ArrayList<String>();
        BuyersVo_one vo = new BuyersVo_one();
        //生成买家国家列表
        if (lis == null) {
            return view;
        }
        for (StTopBuyers insTopBuyers : lis) {
            if (insTopBuyers == null || insTopBuyers.getCom_buyer() == null) {
                continue;
            }
            if (StringUtils.isNotBlank(insTopBuyers.getCom_buyer().getCountry())) {
                countryList.add(insTopBuyers.getCom_buyer().getCountry());
            }
        }
        if (countryList.size() > 0) {
            vo.setCountryList(rmDuplication(countryList));
            view.addObject(ConstProp.VO, vo);
        }
        return view;
    }

    //
//
//    */
///**
//     * <b>查找买家第一步</b>
//     * 		此接口提供给新增出运时已选择被保险人之后再点击选择买家使用
//     * @return
//     * @author liumd
//     * @throws Exception
//     * @date 2016年12月19日 下午2:37:42
//     * @注意事项 </b>
//     * <b>
//     *//*
//
    @RequestMapping("/findBuyers2/{orderFormId}")
    public ModelAndView findBuyers2(@PathVariable Long orderFormId, DwzPage page, String insured) throws Exception {
        page.setNumPerPage(10);
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/findBuyers_one");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("insured", insured);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject(ConstProp.USERDETAIL, userdetail);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("orderFormId", orderFormId);
        map.put("page", page);
        List<StTopBuyers> lis = insTopBuyersService.getInsTopBuyersByOrderFormId(orderFormId, page);
        List<String> countryList = new ArrayList<String>();
        BuyersVo_one vo = new BuyersVo_one();
        //生成买家国家列表
        if (lis == null) {
            return view;
        }
        for (StTopBuyers insTopBuyers : lis) {
            if (insTopBuyers == null || insTopBuyers.getCom_buyer() == null) {
                continue;
            }
            if (StringUtils.isNotBlank(insTopBuyers.getCom_buyer().getCountry())) {
                countryList.add(insTopBuyers.getCom_buyer().getCountry());
            }
        }
        if (countryList.size() > 0) {
            vo.setCountryList(rmDuplication(countryList));
            view.addObject(ConstProp.VO, vo);
        }
        return view;
    }

    //
//
//
//    */
///**
//     * <b>根据保单ID获取所有的买家</b>
//     * @return
//     * @author liumd
//     * @throws Exception
//     * @date 2016年12月19日 下午2:37:42
//     * @注意事项 </b>
//     * <b>
//     *//*
//
    @SuppressWarnings("unchecked")
    @RequestMapping("/findBuyersByOrderFormId/{orderFormId}")
    public ModelAndView findBuyersByOrderFormId(@PathVariable Long orderFormId, DwzPage page, String countrySearch, String companySearch) throws Exception {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/findBuyers_table");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject(ConstProp.USERDETAIL, userdetail);
        //获取保单所有的出运信息
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("orderFormId", orderFormId);
        map.put("page", page);
        if (StringUtils.isBlank(countrySearch) && StringUtils.isBlank(companySearch)) {
            List<BuyersVo_two> lis = insTopBuyersService.getBuyersVoTwoByOrderFormId(orderFormId, page);
            view.addObject("buyersVoList", lis);
            return view;
        }
        if (StringUtils.isNotBlank(countrySearch)) {
            map.put("countrySearch", countrySearch);
        } else {
            map.put("countrySearch", "");
        }
        if (StringUtils.isNotBlank(companySearch)) {
            map.put("companySearch", companySearch);
        } else {
            map.put("companySearch", "");
        }
        List<BuyersVo_two> lis = insTopBuyersService.findBuyersListByOrderFormIdAndSearch(orderFormId, page, countrySearch, companySearch);
        view.addObject("buyersVoList", lis);
        return view;
    }

    //
//    //新增一个出运
    @RequestMapping("/addShipDeclare/{orderFormId}")
    @ResponseBody
    public ResultDto addShipDeclare(@PathVariable Long orderFormId, ShipDeclareAddVo shipDeclareAddVo) throws Exception {
        Map<String, Object> map = new HashMap<String, Object>();
        if (msgNotFull(shipDeclareAddVo)) {
            return new ResultDto("数据不完整，请重新填写并重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        map.put("shipDeclareAddVo", shipDeclareAddVo);
        map.put("userId", userdetail.getOid());
        map.put("orderFormId", orderFormId);

        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        InsShipDeclare sd = new InsShipDeclare();

        // 获取原先的买家信息
        StTopBuyers insTopBuyers = insTopBuyersService.selectById(shipDeclareAddVo.getIns_top_buyers_id());
        BigDecimal invoiceAmountNow = new BigDecimal(shipDeclareAddVo.getInvoice_amount());
        if (!insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.parseLong(userdetail.getOid()), 1L, invoiceAmountNow)) {
            return new ResultDto("该买家信用额度不足！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }
        sd.setIns_order_form_id(orderFormId);
        sd.setInsured(shipDeclareAddVo.getInsured());
        sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
        try {
            sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
            sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        sd.setTrade_name(shipDeclareAddVo.getTrade_name());
        sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
        sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
        sd.setPack_num(shipDeclareAddVo.getPack_num());
        sd.setRatio(shipDeclareAddVo.getRatio());
        sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
        sd.setContract_days(shipDeclareAddVo.getContract_days());
        sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
        sd.setDeclare_type(ConstProp.DIGIT_ZERO);
        sd.setTransport_type(shipDeclareAddVo.getTransport_type());
        sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
        sd.setSt_top_buyers_id(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id()));
        sd.setStatus(ConstProp.INT_NUMBER_ZERO);
        sd.setCreate_time(DateUtil.getTimestamp());
        boolean sdinsert = shipDeclareService.insert(sd);
        if (!sdinsert) {
            return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }
        InsShipInvoices si = new InsShipInvoices();
        si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
        si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
        si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
        si.setStatus(0);
        boolean siinsert = shipInvoicesService.insert(si);
        if (!siinsert) {
            return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }
        //-- 新增出运的同时，新增一个应收。
        InsShipReceive sr = new InsShipReceive();
        sr.setIns_ship_declare_id(sd.getIns_ship_declare_id());
        sr.setCreate_time(DateUtil.getTimestamp());
        sr.setOver_due_status(ConstProp.DIGIT_ZERO);
        sr.setReceive_status(ConstProp.DIGIT_ZERO);
        try {
            sr.setPay_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        sr.setStatus(ConstProp.INT_NUMBER_ZERO);
        sr.setTotal_amounts(invoiceAmountNow);
        sr.setUn_received_amounts(invoiceAmountNow);
        sr.setReceived_amounts(new BigDecimal(ConstProp.DIGIT_ZERO));
        boolean srinsert = shipReceiveService.insert(sr);
        if (!srinsert) {
            return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        } else {
            return new ResultDto("添加出运成功！", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }
    }

    @SuppressWarnings("unchecked")
    @RequestMapping("/goDeclareDetail/{type}/{declareId}/{invoiceId}/{externalReference}")
    public ModelAndView goDeclareDetail(@PathVariable Long declareId,@PathVariable Long invoiceId,@PathVariable String externalReference,@PathVariable String type) {
        ModelAndView view = new ModelAndView();
        if("1".equals(type)){
            view.setViewName("/coninsweb/personalCenter/exports/declare/addDeclare_ReadOnly");
        }else if("2".equals(type)){
            view.setViewName("/coninsweb/personalCenter/exports/declare/addDeclare_Modify");
        }
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if(userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("declareId", declareId);
        map.put("invoiceId", invoiceId);
        ShipDeclareVo shipDeclareVo = new ShipDeclareVo();
        InsShipDeclare shipDeclare = shipDeclareService.selectById(declareId);
        InsShipInvoices shipInvoices = shipInvoicesService.selectById(invoiceId);
        BeanUtils.copyProperties(shipDeclare, shipDeclareVo);
        shipDeclareVo.setInvoice_amounts(shipInvoices.getInvoice_amounts());
        shipDeclareVo.setInvoice_no(shipInvoices.getInvoice_no());
        shipDeclareVo.setInsuredNameList(this.getInsuredNameList(shipDeclare.getIns_order_form_id()));
        Long insTopBuyersId = shipDeclare.getSt_top_buyers_id();
        StTopBuyers insTopBuyers = insTopBuyersService.selectById(insTopBuyersId);
        ComBuyers  buyerscode = insBuyersService.selectById(insTopBuyers.getCom_buyer().getCom_buyer_id());
        String code = buyerscode.getCode();
        //获取买家详情 -- 记号 -- 待改 -- 原先
        TopBuyersVo buyers  = insTopBuyersService.getBuyersVoById(insTopBuyersId);
        if("1".equals(type)){
            for (SysDict sysDict : SysDictUtils.getDictList("paymentTerms")) {
                if(shipDeclareVo.getPayment_terms().equals(sysDict.getValue())){
                    shipDeclareVo.setPayment_terms(sysDict.getLabel());
                }
            }
            for (SysDict sysDict : SysDictUtils.getDictList("transportType")) {
                if(shipDeclareVo.getTransport_type().equals(sysDict.getValue())){
                    shipDeclareVo.setTransport_type(sysDict.getLabel());
                }
            }
        }
        view.addObject("paymentTermsList", SysDictUtils.getDictList("paymentTerms"));
        view.addObject("transportTypeList", SysDictUtils.getDictList("transportType"));
        view.addObject("shipDeclareVo", shipDeclareVo);
        view.addObject("topBuyersVo", buyers);
        view.addObject("code", code);
        view.addObject("externalReference", externalReference);
        view.addObject("invoiceId", invoiceId);
        view.addObject("ins_top_buyers_id", insTopBuyersId);
        view.addObject("declareId", declareId);
        view.addObject("orderFormId", shipDeclare.getIns_order_form_id());
        return view;
    }
//


    /**
     *
     * 修改c出运
     */
    @RequestMapping("/modifyShipDeclare/{declareId}/{invoiceId}")
    @ResponseBody
    public ResultDto modifyShipDeclare(@PathVariable Long declareId,@PathVariable Long invoiceId, ShipDeclareAddVo shipDeclareAddVo) throws Exception {
        Map<String, Object> map = new HashMap<String, Object>();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        map.put("shipDeclareAddVo", shipDeclareAddVo);
        map.put("declareId", declareId);
        map.put("invoiceId", invoiceId);
        map.put("userId", userdetail.getOid());

        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        InsShipDeclare sd = shipDeclareService.selectById(declareId);
        Long insTopBuyersIdBefore = sd.getSt_top_buyers_id();
        InsShipInvoices si = shipInvoicesService.selectById(invoiceId);
        // 获取原先的买家信息insTopBuyersService.updTopFreeAmount(topBuyersVo.getOid(),userId,status,amount); 1减少2增加
        StTopBuyers insTopBuyers = insTopBuyersService.selectById(insTopBuyersIdBefore);
        BigDecimal invoiceAmountBefore = si.getInvoice_amounts();
        BigDecimal invoiceAmountNow = new BigDecimal(shipDeclareAddVo.getInvoice_amount());
        BigDecimal result = invoiceAmountNow.subtract(invoiceAmountBefore);
        //修改前后买家不变
        if(shipDeclareAddVo.getIns_top_buyers_id().equals(String.valueOf(insTopBuyers.getSt_top_buyers_id()))){
            return buyersNotChange(shipDeclareAddVo, map, userdetail, format, sd, si, insTopBuyers, invoiceAmountBefore, invoiceAmountNow, result);
        }
        //修改前后买家变了 先增加旧买家的额度，再减少新买家的额度
        if(insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyersIdBefore), Long.parseLong(userdetail.getOid()), 2L, invoiceAmountBefore)){
            sd.setInsured(shipDeclareAddVo.getInsured());
            sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
            try {
                sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
                sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
            } catch (ParseException e) {
                e.printStackTrace();
            }
            sd.setTrade_name(shipDeclareAddVo.getTrade_name());
            sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
            sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
            sd.setPack_num(shipDeclareAddVo.getPack_num());
            sd.setRatio(shipDeclareAddVo.getRatio());
            sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
            sd.setContract_days(shipDeclareAddVo.getContract_days());
            sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
            sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
            sd.setTransport_type(shipDeclareAddVo.getTransport_type());
            sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
            sd.setSt_top_buyers_id(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id()));
            sd.setStatus(0);
            sd.setUpdate_time(DateUtil.getTimestamp());
            boolean sdinsert = shipDeclareService.updateById(sd);
            if(!sdinsert){
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
            si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
            si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
            si.setStatus(0);
            boolean siinsert = shipInvoicesService.updateById(si);
            if(!siinsert){
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }else{
                return new ResultDto("修改出运成功！", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        }
        if(!insTopBuyersService.updTopFreeAmount(shipDeclareAddVo.getIns_top_buyers_id(), Long.parseLong(userdetail.getOid()), 1L, invoiceAmountNow)){
            return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }
        sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
        sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
        try {
            sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
            sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        sd.setTrade_name(shipDeclareAddVo.getTrade_name());
        sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
        sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
        sd.setPack_num(shipDeclareAddVo.getPack_num());
        sd.setRatio(shipDeclareAddVo.getRatio());
        sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
        sd.setContract_days(shipDeclareAddVo.getContract_days());
        sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
        sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
        sd.setTransport_type(shipDeclareAddVo.getTransport_type());
        sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
        sd.setSt_top_buyers_id(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id()));
        sd.setStatus(0);
        sd.setUpdate_time(DateUtil.getTimestamp());

        boolean sdinsert = shipDeclareService.updateById(sd);
        if(!sdinsert){
            return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }
        si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
        si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
        si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
        si.setStatus(0);
        boolean siinsert = shipInvoicesService.updateById(si);
        if(!siinsert){
            return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }else{
            return new ResultDto("修改出运成功！", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }
    }

    /**
     * <b> 修改前后买家不变 </b>
     * @author ZXF
     * @create 2020/09/27 0027 17:34
     * @version
     * @注意事项 </b>
     */
    private ResultDto buyersNotChange(ShipDeclareAddVo shipDeclareAddVo, Map<String, Object> map, ClientUserVo userdetail, DateFormat format, InsShipDeclare sd, InsShipInvoices si, StTopBuyers insTopBuyers, BigDecimal invoiceAmountBefore, BigDecimal invoiceAmountNow, BigDecimal result) {
        if(!(result.compareTo(BigDecimal.ZERO) < 0)){
            //新发票额度比旧发票额度大
            BigDecimal addAmount = invoiceAmountNow.subtract(invoiceAmountBefore);
            if(!insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.parseLong(userdetail.getOid()), 1L, addAmount)){
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            sd.setInsured(shipDeclareAddVo.getInsured());
            sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
            try {
                sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
                sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
            } catch (ParseException e) {
                e.printStackTrace();
            }
            sd.setTrade_name(shipDeclareAddVo.getTrade_name());
            sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
            sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
            sd.setPack_num(shipDeclareAddVo.getPack_num());
            sd.setRatio(shipDeclareAddVo.getRatio());
            sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
            sd.setContract_days(shipDeclareAddVo.getContract_days());
            sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
            sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
            sd.setTransport_type(shipDeclareAddVo.getTransport_type());
            sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
            sd.setSt_top_buyers_id(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id()));
            sd.setStatus(0);
            sd.setUpdate_time(DateUtil.getTimestamp());
            boolean sdinsert = shipDeclareService.updateById(sd);
            if(!sdinsert){
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
            si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
            si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
            si.setStatus(0);
            boolean siinsert = shipInvoicesService.updateById(si);
            if(!siinsert){
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }else{
                return new ResultDto("修改出运成功！", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        }else if(result.compareTo(BigDecimal.ZERO) < 0){
            //新发票额度比旧发票额度小
            BigDecimal downAmount = invoiceAmountBefore.subtract(invoiceAmountNow);
            if(!insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.parseLong(userdetail.getOid()), 2L, downAmount)){
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            sd.setInsured(shipDeclareAddVo.getInsured());
            sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
            try {
                sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
                sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
            } catch (ParseException e) {
                e.printStackTrace();
            }
            sd.setTrade_name(shipDeclareAddVo.getTrade_name());
            sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
            sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
            sd.setPack_num(shipDeclareAddVo.getPack_num());
            sd.setRatio(shipDeclareAddVo.getRatio());
            sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
            sd.setContract_days(shipDeclareAddVo.getContract_days());
            sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
            sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
            sd.setTransport_type(shipDeclareAddVo.getTransport_type());
            sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
            sd.setSt_top_buyers_id(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id()));
            sd.setStatus(0);
            sd.setUpdate_time(DateUtil.getTimestamp());
            boolean sdinsert = shipDeclareService.updateById(sd);
            if(!sdinsert){
                MessageUtils.returnFailMessage(map, response);
                return new ResultDto("数据出错，请联系管理员！", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
            si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
            si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
            si.setStatus(0);
            boolean siinsert = shipInvoicesService.updateById(si);
            if(!siinsert){
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }else{
                return new ResultDto("修改出运成功！", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        }else{
            sd.setInsured(shipDeclareAddVo.getInsured());
            sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
            try {
                sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
                sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
            } catch (ParseException e) {
                e.printStackTrace();
            }
            sd.setTrade_name(shipDeclareAddVo.getTrade_name());
            sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
            sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
            sd.setPack_num(shipDeclareAddVo.getPack_num());
            sd.setRatio(shipDeclareAddVo.getRatio());
            sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
            sd.setContract_days(shipDeclareAddVo.getContract_days());
            sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
            sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
            sd.setTransport_type(shipDeclareAddVo.getTransport_type());
            sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
            sd.setSt_top_buyers_id(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id()));
            sd.setStatus(0);
            sd.setUpdate_time(DateUtil.getTimestamp());
            boolean sdinsert = shipDeclareService.updateById(sd);
            if(!sdinsert){
                MessageUtils.returnFailMessage(map, response);
                return new ResultDto("数据出错，请联系管理员！", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
            si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
            si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
            si.setStatus(0);
            boolean siinsert = shipInvoicesService.updateById(si);
            if(!siinsert){
                return new ResultDto("数据出错，请联系管理员！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }else{
                return new ResultDto("修改出运成功！", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        }
    }

    //
//    */
///** 判断新增出运时信息是否填写完整*//*
//
    private boolean msgNotFull(ShipDeclareAddVo shipDeclareAddVo) {
        boolean flag = false;//先不校验 数据
//        if (StringUtils.isBlank(shipDeclareAddVo.getIns_top_buyers_id())
//                || StringUtils.isBlank(shipDeclareAddVo.getExternalReference())
//                || StringUtils.isBlank(shipDeclareAddVo.getBuyers_code())
//                || StringUtils.isBlank(shipDeclareAddVo.getInvoice_no())
//                || StringUtils.isBlank(shipDeclareAddVo.getInvoice_amount())
//                || StringUtils.isBlank(shipDeclareAddVo.getInsured())
//                || StringUtils.isBlank(shipDeclareAddVo.getCoverage())
//                || StringUtils.isBlank(shipDeclareAddVo.getDelivery_time())
//                || StringUtils.isBlank(shipDeclareAddVo.getPay_expire_time())
//                || StringUtils.isBlank(shipDeclareAddVo.getTrade_name())
//                || StringUtils.isBlank(shipDeclareAddVo.getShip_trade_no())
//                || StringUtils.isBlank(shipDeclareAddVo.getShip_trade_name())
//                || StringUtils.isBlank(shipDeclareAddVo.getPack_num())
//                || StringUtils.isBlank(shipDeclareAddVo.getIssuing_swift())
//                || StringUtils.isBlank(shipDeclareAddVo.getContract_days())
//                || StringUtils.isBlank(shipDeclareAddVo.getDeclaration_no())
//                || StringUtils.isBlank(shipDeclareAddVo.getDeclare_type())
//                || StringUtils.isBlank(shipDeclareAddVo.getTransport_type())
//                || StringUtils.isBlank(shipDeclareAddVo.getPayment_terms())) {
//            flag = true;
//        }
        return flag;
    }


}
