package com.bcxin.ins.coninsweb.order.controller.export.web;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.service.order.InsAreaAPIService;
import com.bcxin.ins.service.order.InsBuyersAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsTopBuyersAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.dto.BuyerDto;
import com.bcxin.ins.dto.CountryDto;
import com.bcxin.ins.entity.common.ComBuyers;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <b> 信用额度管理 （接口--对接保函网的数据）</b>
 * 
 * @author liyongqiang
 * @date 2017年1月10日 下午1:27:14
 * @注意事项 </b> <b>
 */
//@RestController
@Controller
@SessionAttributes("buyerdto")//
@RequestMapping(value = "exports/credit")
public class InsBuyersAPIController extends BaseController {

	@Autowired
	private InsBuyersAPIService insBuyersService;
//
	@Autowired
	private InsTopBuyersAPIService insTopBuyersService;
    @Autowired
    private InsAreaAPIService insAreaAPIService;
//
//	@Autowired
//	private InsOrderFormAPIService insOrderFormService;// 订单的service



    @Autowired
	private InsInsuranceSlipAPIService  insInsuranceSlipAPIService;
	/**
	 * <b> 根据前台用户 和承保状态 查询 订单（保单） 还有 产品类型（小微）</b>
	 *
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月10日 下午2:10:27
	 * @注意事项 </b> <b>
	 */
	@RequestMapping("/policyChange")
	public ModelAndView policyChange(HttpServletRequest request, ModelMap model, DwzPage page) {

        page.setNumPerPage(5);
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/index");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/credit/policyChange");
        }
        String keyword = getRequest().getParameter("keyword");
        String starDate = getRequest().getParameter("starDate");
        String endDate = getRequest().getParameter("endDate");
        view.addObject(ConstProp.USERDETAIL,userdetail);
        try{
            InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),"21",ConstProp.BLANK_CHAR, keyword, starDate, endDate, ConstProp.BLANK_CHAR,page);
            List<OrderFormVo> olist=insInsuranceSlipAPIService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(search);
            view.addObject("policyList",olist);
        }catch (Exception ex){
            ex.printStackTrace();
        }

        model.put("dwzPage", page);
        return view;

	}

    /**
     *
     * 选择保单分页列表
     * @param page
     * @return
     */
    @RequestMapping("getPolicyListForPage")
    public ModelAndView getPolicyListForPage(DwzPage page){
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/policyList_table");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/credit/getPolicyListForPage");
        }
        String keyword = getRequest().getParameter("keyword");
        String starDate = getRequest().getParameter("starDate");
        String endDate = getRequest().getParameter("endDate");
        InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),"21",ConstProp.BLANK_CHAR, keyword, starDate, endDate, ConstProp.BLANK_CHAR,page);
        List<OrderFormVo>olist= insInsuranceSlipAPIService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(search);
        view.addObject("policyList",olist);
        view.addObject(ConstProp.USERDETAIL,userdetail);
        return view;
    }


    /**
     * <b>限额类表 </b>
     */
    @RequestMapping("/limitQuery/{oid}")
    public ModelAndView limitQuery(HttpServletRequest request, @PathVariable Long oid , ModelMap model,DwzPage page ) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/limitQuery");
        List<CountryDto> list = insAreaAPIService.getCountryList();
        view.addObject("countryList", list);
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/credit/limitQuery/"+oid);
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        BuyerDto	buyerdto =new BuyerDto();
        //远程调用接口
        InsInsuranceSlip insOrderForm= insInsuranceSlipAPIService.packagingInsOrderForm(oid);
        OrderFormVo order=insInsuranceSlipAPIService.willInsOrderFormSetUpOrderFormVo(insOrderForm);
        if(order==null){
            return new ModelAndView("redirect:/exports/credit/policyChange");
        }
        buyerdto.setVo(order);
        Long special_id = insOrderForm.getSpecial_id();
			if (special_id != null) {
				TopBuyersVo topBuyersVo = new TopBuyersVo();
				topBuyersVo.setSpecial_id(special_id);
                List<StTopBuyers> blist = insTopBuyersService.selectInsTopBuyersListBySpecialID(page, topBuyersVo);
                Map<String, Object> map = new HashMap<String, Object>();
				if (blist != null) {
					List<TopBuyersVo> buyList = new ArrayList<TopBuyersVo>();
					for (StTopBuyers tb : blist) {
						TopBuyersVo tbv = insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(tb);
						tbv.setSpecial_id(special_id);
						buyList.add(tbv);
					}
					map.put("page", page);
					map.put("buyList", buyList);
					map.put("vostatus", ConstProp.DIGIT_ONE);
				} else {
					map.put("vostatus", ConstProp.DIGIT_ZERO);
				}
				map.put("special_id", special_id);

		}
        buyerdto.setSpecial_id(special_id);
        model.put("special_id", special_id);
        model.put("dwzPage", page);
        model.put("buyerdto", buyerdto);
        return view;
    }




    /**
     * <b>买家列表分页</b>
     *
     * @param page
     * @param model
     * @param topBuyersVo
     * @return
     * @author liyongqiang
     * @date 2017年1月19日 下午4:00:36
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("findBuyerBySearchLlimit")
    public ModelAndView findBuyerBySearch(DwzPage page,ModelMap model,TopBuyersVo  topBuyersVo){

        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/order_buyerList_table");
        List<CountryDto> list = insAreaAPIService.getCountryList();
        view.addObject("countryList", list);
        try {
            BuyerDto    dto= (BuyerDto) model.get("buyerdto");
            if(dto==null){
                return new ModelAndView("redirect:/exports/credit/policyChange");
            }
            topBuyersVo.setSpecial_id(dto.getSpecial_id());
            page.setNumPerPage(5);
//        List<TopBuyersVo> buylist=insTopBuyersService.selectInsTopBuyersListBySpecialID(page, topBuyersVo);
            List<StTopBuyers> blist  = insTopBuyersService.selectInsTopBuyersListBySpecialID(page,topBuyersVo);
            List<TopBuyersVo> buyList = new ArrayList<TopBuyersVo>();
            if (blist != null) {
                for (StTopBuyers tb : blist) {
                    TopBuyersVo tbv = insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(tb);
                    tbv.setSpecial_id(dto.getSpecial_id());
                    buyList.add(tbv);
                }
            }
            model.put("buyList", buyList);
            //申请限额类型
            model.put("ApplicationLimitTypes", SysDictUtils.getDictList("applicationLimitType"));
        }catch ( Exception ex){
            ex.printStackTrace();
        }


        return view;
    }


    /**
     * <b>申请 额度 addApplyAmount</b>
     * 适用于不存在买家代码      新增 /再申请
     * 查找带回只对这个方法有效
     * @param request
     * @param model
     * @return
     * @author liyongqiang
     * @date 2016年12月21日 下午5:02:11
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("/addApplyAmount")
    public ModelAndView addApplyAmountAgain(HttpServletRequest request, Long oid,String code, ModelMap model) {

        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/addApplyAmount");
        List<CountryDto> list = insAreaAPIService.getCountryList();
        view.addObject("countryList", list);
        BuyerDto    dto= (BuyerDto) model.get("buyerdto");
        if(dto==null){
            return new ModelAndView("redirect:/exports/credit/policyChange");
        }
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/credit/addApplyAmount?oid="+oid+"&code="+code);
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        TopBuyersVo buyser=null;
        if(oid!=null){
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("oid",oid);
            StTopBuyers  insTopBuyers= insTopBuyersService.packagingInsTopBuyers(oid);
             buyser =insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(insTopBuyers);
            model.put("buyersQuota",buyser);
        }
//		//查找带回
        if(StringUtils.isNotEmpty(code)){
			view = new ModelAndView("/personalCenter/exports/credit/addApplyAmount_buyer");
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("code",code);
            ComBuyers insBuyers= insBuyersService.selectInsBuyersByCode(code);
            if(insBuyers!=null){
                TopBuyersVo buyers=insTopBuyersService.accordingToInsBuyersIntoTopBuyersVo(insBuyers);
                buyers.setCode(code);
            }
            if(insBuyers==null){
                buyser= new TopBuyersVo();
            }
           // buildTopBuyersVo(buyser,insBuyers);
            model.put("buyersQuota",buyser);


        }
        //申请限额类型
        model.put("ApplicationLimitTypes", SysDictUtils.getDictList("applicationLimitType"));
        //结算方式
        model.put("SettlementTypes", SysDictUtils.getDictList("paymentTerms"));


        return view;
    }

    private void buildTopBuyersVo(TopBuyersVo buyser, TopBuyersVo codeBuyser) {

        buyser.setCustomer_name(codeBuyser.getCustomer_name());
        buyser.setAddress(codeBuyser.getAddress());
        buyser.setCountry(codeBuyser.getCountry());
        buyser.setCity(codeBuyser.getCity());
        buyser.setId_type(codeBuyser.getId_type());
        buyser.setId_no(codeBuyser.getId_no());
        buyser.setStreet(codeBuyser.getStreet());
        buyser.setHouse_num(codeBuyser.getHouse_num());
        buyser.setVideo_level(codeBuyser.getVideo_level());
        buyser.setVocation(codeBuyser.getVocation());
        buyser.setCapital(codeBuyser.getCapital());
        buyser.setEmp_num(codeBuyser.getEmp_num());
        buyser.setLinkman(codeBuyser.getLinkman());
        buyser.setPhone(codeBuyser.getPhone());
        buyser.setCode(codeBuyser.getCode());


    }

    /**
     * <b>限额修改页面 </b>
     * 适用于已经有 买家代码  的限额再申请
     * @param oid
     * @param model
     * @return
     * @author liyongqiang
     * @date 2016年12月19日 下午4:05:07
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("/updApplyAmount/{oid}")
    public ModelAndView updApplyAmount(@PathVariable Long oid,ModelMap model) {

        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/addApplyAmount");
         List<CountryDto> list = insAreaAPIService.getCountryList();
        view.addObject("countryList", list);
        BuyerDto    dto= (BuyerDto) model.get("buyerdto");
        if(dto==null){
            return new ModelAndView("redirect:/exports/credit/policyChange");
        }
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/credit/updApplyAmount/"+oid);
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);

        //申请限额类型
        model.put("ApplicationLimitTypes", SysDictUtils.getDictList("applicationLimitType"));
        //结算方式
        model.put("SettlementTypes", SysDictUtils.getDictList("paymentTerms"));
        //修改的内容
        //申请限额类型
        model.put("ApplicationLimitTypes", SysDictUtils.getDictList("applicationLimitType"));
        //结算方式
        model.put("SettlementTypes", SysDictUtils.getDictList("paymentTerms"));
        StTopBuyers  insTopBuyers= insTopBuyersService.packagingInsTopBuyers(oid);
        TopBuyersVo   vo =insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(insTopBuyers);
        model.put("buyersQuota", vo);

        return view;
    }



    /**
     * <b>取消申请记录(ok) </b>
     */
    @RequestMapping("/delApplyAmount/{oid}")
    public ModelAndView delApplyAmount(@PathVariable Long oid,ModelMap model) {

        BuyerDto    dto= (BuyerDto) model.get("buyerdto");
        if(dto==null){
            return new ModelAndView("redirect:/exports/credit/policyChange");
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("oid",oid);
        boolean flag= insTopBuyersService.updateTopBuyerForDelStatus(oid);

        //	creditAmountService.deleteCreditAmount(buyersQuota,policy);//保存操作记录
        return new ModelAndView("redirect:/exports/credit/limitQuery/"+dto.getVo().getOid());


    }



    /**
     * <b>申请限额详情页面</b>
     *
     * @param oid
     * @param model
     * @return
     * @author liyongqiang
     * @date 2016年12月19日 下午4:08:00
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("/getApplyAmount/{oid}")
    public ModelAndView getApplyAmount(@PathVariable Long oid,ModelMap model) {

        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/getApplyAmount");
        List<CountryDto> list = insAreaAPIService.getCountryList();
        view.addObject("countryList", list);
        BuyerDto    dto= (BuyerDto) model.get("buyerdto");
        if(dto==null){
            return new ModelAndView("redirect:/exports/credit/policyChange");
        }
        view.addObject(ConstProp.DTO,dto);
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/credit/getApplyAmount/"+oid);
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);

        //申请限额类型
        model.put("ApplicationLimitTypes", SysDictUtils.getDictList("applicationLimitType"));
        //结算方式
        model.put("SettlementTypes", SysDictUtils.getDictList("paymentTerms"));
        StTopBuyers  insTopBuyers= insTopBuyersService.packagingInsTopBuyers(oid);
        TopBuyersVo   vo =insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(insTopBuyers);
        model.put("buyersQuota", vo);
        return view;
    }



    /**
     * <b>保存限额 </b>
     * @param model
     * @return
     * @author liyongqiang
     * @date 2016年12月19日 下午1:51:01
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("/saveCreditAmount")
    public ModelAndView saveCreditAmount( TopBuyersVo buyersQuota,ModelMap model) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation());
        }
        BuyerDto    dto= (BuyerDto) model.get("buyerdto");
        if(dto==null){
            return new ModelAndView("redirect:/exports/credit/policyChange");
        }

        if(buyersQuota.getCode()!=null&&!buyersQuota.getCode().equals("")){
            ComBuyers insBuyers= insBuyersService.selectInsBuyersByCode(buyersQuota.getCode());
            if(insBuyers!=null){
                TopBuyersVo     buyers=insTopBuyersService.accordingToInsBuyersIntoTopBuyersVo(insBuyers);
                buyers.setCode(buyersQuota.getCode());
            }else{
                buyersQuota.setCode(null);
            }
        }
        buyersQuota.setUser_id(Long.parseLong(userdetail.getOid()));
        buyersQuota.setSpecial_id(dto.getSpecial_id());
        insTopBuyersService.accordingToTheTopBuyersVoSetUpInsTopBuyers(buyersQuota,buyersQuota.getSpecial_id());
        //creditAmountService.saveCreditAmount(buyersQuota,policy,flag);//保存记录
        return new ModelAndView("redirect:/exports/credit/limitQuery/"+dto.getVo().getOid());
    }



    /**
     * <b>查找所有买家   去除保单已经有的有效买家 </b>
     * <b>
     */
    @RequestMapping("/findBuyers")
    public ModelAndView findBuyers(HttpServletRequest request, Long  bid,ModelMap model ,DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/findBuyers");
        BuyerDto    dto= (BuyerDto) model.get("buyerdto");
        if(dto==null){
            return new ModelAndView("redirect:/exports/credit/policyChange");
        }
        List<CountryDto> list = insAreaAPIService.getCountryList();
        view.addObject("countryList", list);
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/credit/findBuyers?bid="+bid);
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        //查询所有的全球买家  去除该保单已经去除的
        if(page == null){
            page = new DwzPage();
        }
        page.setNumPerPage(8);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("page", page);//页数
        TopBuyersVo topBuyersVo = new TopBuyersVo();
        topBuyersVo.setSpecial_id(dto.getSpecial_id());
        List<TopBuyersVo> blist= insBuyersService.findListNotOid(topBuyersVo,page);
        view.addObject("blist", blist);
        view.addObject("bid", bid);
        return view;
    }


    /**
     * <b>分页数据</b>
     */
    @RequestMapping("findBuyersListForPage")
    public ModelAndView findBuyersListForPage(DwzPage page,ModelMap model,TopBuyersVo topBuyersVo){
        page.setNumPerPage(8);
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/quanqiu_buyerList_table");
        BuyerDto    dto= (BuyerDto) model.get("buyerdto");
        if(dto==null){
            return new ModelAndView("redirect:/exports/credit/policyChange");
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("page", page);//页数
        topBuyersVo.setSpecial_id(dto.getSpecial_id());
        map.put("topBuyersVo", topBuyersVo);
        List<TopBuyersVo> blist= insBuyersService.findListNotOid(topBuyersVo,page);
        view.addObject("blist", blist);

        return view;
    }


    /**
     * <b>查找带回 </b>
     *
     */
    @RequestMapping("/getBuyers/{code}")
    public ModelAndView getBuyers(@PathVariable String code,Long bid, ModelMap model ) {
        String url="redirect:/exports/credit/addApplyAmount?code="+code+"&oid=";
        if(bid==null||bid==0){
        }else{
            url=url+bid;
        }
        return new ModelAndView(url);
    }


    /**
     * <b>获取全球买家详情 </b>
     *
     * @param model
     * @return
     * @author liyongqiang
     * @date 2016年12月23日 上午10:35:27
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("/getBuyersDetatils/{code}")
    public ModelAndView getBuyersDetatils(@PathVariable String code,ModelMap model ) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/credit/getBuyersDetails");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/credit/getBuyersDetatils/"+code);
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("code",code);
        //申请限额类型
        model.put("ApplicationLimitTypes", SysDictUtils.getDictList("applicationLimitType"));
        //结算方式
        model.put("SettlementTypes", SysDictUtils.getDictList("paymentTerms"));

        ComBuyers insBuyers= insBuyersService.selectInsBuyersByCode(code);
        if(insBuyers!=null){
            TopBuyersVo buyers=insTopBuyersService.accordingToInsBuyersIntoTopBuyersVo(insBuyers);
            buyers.setCode(code);
            model.put("buyersQuota",buyers);
        }

        return view;
    }

//	/**
//	 * <b>获取订单信息 </b>
//	 *
//	 * @param model
//	 * @param data
//	 * @author liyongqiang
//	 * @date 2017年1月13日 上午11:19:10
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/getOrderFormByOid")
//	public void getOrderFormByOid(ModelMap model, String data) {
//		// 根据 id 查询 保单列表
//		Long oid=null;
//		oid = MessageUtils.getLongValueByKey(data,"oid");
//		if (oid!=null&&oid!=0) {
//			InsOrderForm insOrderForm= insOrderFormService.packagingInsOrderForm(oid);
//			try{
//				OrderFormVo  orderFormVo  =insOrderFormService.willInsOrderFormSetUpOrderFormVo(insOrderForm);
//				ReturnJsonUtil.buildJson(orderFormVo,response);
//			}catch (Exception e) {
//				e.printStackTrace();
//			}
//		} else{
//			ReturnJsonUtil.getJsonError(response);
//		}
//	}
//
//	/**
//	 * <b>查询保单下的买家列表</b>
//	 * oid  为  订单的id
//	 * @param model
//	 * @return
//	 * @author liyongqiang
//	 * @date 2017年1月10日 下午2:10:27
//	 * @注意事项 </b> <b>
//	 */
//	@RequestMapping("/findTopBuyerByOrderId")
//	public void findTopBuyerByOrderId(ModelMap model, String data,DwzPage page ) {
//		page.setNumPerPage(10);
//		Long oid=null;
//		oid = MessageUtils.getLongValueByKey(data, "oid");
//		if (oid != null) {
//			InsOrderForm insOrderForm = insOrderFormService.packagingInsOrderForm(oid);
//			Long special_id = insOrderForm.getInsuranceSlipg().getSpecial_id();
//			if (special_id != null) {
//				TopBuyersVo topBuyersVo = new TopBuyersVo();
//				topBuyersVo.setSpecial_id(special_id);
//				List<InsTopBuyers> blist = insTopBuyersService.selectInsTopBuyersListBySpecialID(page, topBuyersVo);
//				Map<String, Object> map = new HashMap<String, Object>();
//				if (blist != null) {
//					List<TopBuyersVo> buyList = new ArrayList<TopBuyersVo>();
//					for (InsTopBuyers tb : blist) {
//						TopBuyersVo tbv = insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(tb);
//						tbv.setSpecial_id(special_id);
//						buyList.add(tbv);
//					}
//					map.put("page", page);
//					map.put("vo", buyList);
//					map.put("vostatus", ConstProp.DIGIT_ONE);
//				} else {
//					map.put("vostatus", ConstProp.DIGIT_ZERO);
//				}
//				map.put("special_id", special_id);
//				ReturnJsonUtil.buildJson(map, response);
//				return;
//			}
//		}
//		ReturnJsonUtil.getJsonError(response);
//	}
//
//	/**
//	 * <b>买家列表 分页+自定义搜搜 </b>
//	 *
//	 * @param model
//	 * @param data
//	 * @author liyongqiang
//	 * @date 2017年1月19日 下午3:00:42
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/findTopBuyerListByOrderId")
//	public void findTopBuyerListByOrderId(ModelMap model, String data,DwzPage page) {
//		page= MessageUtils.getObject(data, DwzPage.class, "page");
//		TopBuyersVo vo=  MessageUtils.getObject(data, TopBuyersVo.class, "topBuyersVo");
//		List<InsTopBuyers> blist  = insTopBuyersService.selectInsTopBuyersListBySpecialID(page,vo);
//		Map<String, Object> map= new HashMap<String, Object>();
//		if(blist!=null){
//			List<TopBuyersVo> buyList= new ArrayList<TopBuyersVo>();
//			for(InsTopBuyers tb:blist){
//				TopBuyersVo  tbv= insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(tb);
//				tbv.setSpecial_id(vo.getSpecial_id());
//				buyList.add(tbv);
//			}
//			map.put("page", page);
//			map.put("vo", buyList);
//			map.put("vostatus", ConstProp.DIGIT_ONE);
//			ReturnJsonUtil.buildJson(map,response);
//		}else{
//			map.put("vostatus", ConstProp.DIGIT_ZERO);
//			ReturnJsonUtil.getJsonError(response);
//		}
//	}
//
//	/**
//	 * <b>根据oid查询全球买家id </b>
//	 *
//	 * @param model
//	 * @param data
//	 * @return
//	 * @author liyongqiang
//	 * @date 2017年1月11日 上午11:01:11
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/getBuyerByOid")
//	public void getBuyerByOid(ModelMap model, String data) {
//		Long oid=0l;
//			oid = MessageUtils.getObject(data, Long.class,"oid");
//		if (oid!=0) {
//			InsBuyers buyers= insBuyersService.selectById(oid);
//			ReturnJsonUtil.buildJson(buyers,response);
//		}
//		ReturnJsonUtil.getJsonError(response);
//	}
//
//	/**
//	 * <b>根据oid查询top买家id </b>
//	 *
//	 * @param model
//	 * @param data
//	 * @return
//	 * @author liyongqiang
//	 * @date 2017年1月11日 上午11:01:11
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/getTopBuyerByOid")
//	public void getTopBuyerByOid(ModelMap model, String data) {
//		Long oid=0l;
//			oid = MessageUtils.getLongValueByKey(data,"oid");
//		if (oid!=0) {
//
//				InsTopBuyers  insTopBuyers= insTopBuyersService.packagingInsTopBuyers(oid);
//				TopBuyersVo   vo =insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(insTopBuyers);
//				ReturnJsonUtil.buildJson(vo, response);
//		}
//		ReturnJsonUtil.getJsonError(response);
//	}
//
//	/**
//	 * <b>保存买家信息</b>
//	 *
//	 * @param model
//	 * @param data
//	 * @return
//	 * @author liyongqiang
//	 * @date 2017年1月11日 下午2:13:12
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/saveTopBuyer")
//	public void saveTopBuyer(ModelMap model, String data) {
//		SysUser user= SysUserUtils.getUser();
//		if(user!=null){
//			try{
//				TopBuyersVo topBuyersVo=MessageUtils.getObject(data,TopBuyersVo.class , "topBuyersVo");
//				topBuyersVo.setUserId(user.getId());
//				insTopBuyersService.accordingToTheTopBuyersVoSetUpInsTopBuyers(topBuyersVo,topBuyersVo.getSpecial_id());
//				ReturnJsonUtil.getJsonSuccess(response);
//			}catch (Exception e) {
//				ReturnJsonUtil.getJsonError(response);
//				e.printStackTrace();
//			}
//		}else{
//			ReturnJsonUtil.getJsonError(response);
//		}
//	}
//
//	/**
//	 * <b>根据买家id删除该买家 </b>
//	 *
//	 * @param model
//	 * @param data
//	 * @return
//	 * @author liyongqiang
//	 * @date 2017年1月11日 上午11:01:11
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/deleteTopBuyerByOid")
//	public void deleteTopBuyerByOid(ModelMap model, String data) {
//		Long oid=0l;
//			oid = MessageUtils.getLongValueByKey(data,"oid");
//		if (oid!=0) {
//			boolean flag= insTopBuyersService.deleteById(oid);
//			if(flag){
//				ReturnJsonUtil.getJsonSuccess(response);
//			}
//		} else{
//			ReturnJsonUtil.getJsonError(response);
//		}
//	}
//
//	/**
//	 * <b>取消申请记录 </b>
//	 *
//	 * @param model
//	 * @param data
//	 * @author liyongqiang
//	 * @date 2017年1月16日 下午1:42:23
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/updDelTopBuyerByOid")
//	public void updDelTopBuyerByOid(ModelMap model, String data) {
//		Long oid=0l;
//			oid = MessageUtils.getLongValueByKey(data,"oid");
//		if (oid!=0) {
//			boolean flag= insTopBuyersService.updateTopBuyerForDelStatus(oid);
//			if(flag){
//				ReturnJsonUtil.getJsonSuccess(response);
//			}
//		} else{
//			ReturnJsonUtil.getJsonError(response);
//		}
//	}
//
//	/**
//	 * <b>跟据code 查询全球买家是否为空</b>
//	 *
//	 * @param model
//	 * @param data
//	 * @author liyongqiang
//	 * @date 2017年1月16日 下午4:03:51
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/getBuyerByCode")
//	public void getBuyerByCode(ModelMap model, String data) {
//	    String  code="";
//			code = MessageUtils.getStringValueByKey(data,"code");
//		if (StrUtil.isNotBlank(code)) {
//			InsBuyers insBuyers= insBuyersService.selectInsBuyersByCode(code);
//			if(insBuyers!=null){
//				TopBuyersVo buyers=insTopBuyersService.accordingToInsBuyersIntoTopBuyersVo(insBuyers);
//				buyers.setCode(code);
//				ReturnJsonUtil.buildJson(buyers,response);
//			}
//		} else{
//			ReturnJsonUtil.getJsonError(response);
//		}
//	}
//
//	/**
//	 * <b>去除该保单已经去除的 所有买家列表</b>
//	 *
//	 * @param model
//	 * @param data
//	 * @author liyongqiang
//	 * @date 2017年1月16日 下午7:44:37
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/findBuyerList")
//	public void findBuyerList(ModelMap model, String data) {
//		try {
//			DwzPage  page=  MessageUtils.getObject(data, DwzPage.class, "page");
//			TopBuyersVo  topBuyersVo=MessageUtils.getObject(data, TopBuyersVo.class, "topBuyersVo");
//			Map<String,Object> map  = new HashMap<String ,Object>();
//			List<TopBuyersVo> blist= insBuyersService.findListNotOid(topBuyersVo,page);
//			map.put("vo", blist);
//			map.put("page", page);
//			ReturnJsonUtil.buildJson(map, response);
//			return;
//		} catch (Exception e) {
//			e.printStackTrace();
//			ReturnJsonUtil.getJsonError(response);
//		}
//	}
//	/**
//	 * <b>去除该表单 所有买家   分页 加  自定义搜搜 </b>
//	 *
//	 * @param model
//	 * @param data
//	 * @author liyongqiang
//	 * @date 2017年1月19日 下午7:20:08
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/findBuyerListSerach")
//	public void findBuyerListSerach(ModelMap model, String data) {
//		try {
//			TopBuyersVo topBuyersVo  = MessageUtils.getObject(data,TopBuyersVo.class ,"topBuyersVo");
//			DwzPage  page=  MessageUtils.getObject(data, DwzPage.class, "page");
//			Map<String,Object> map  = new HashMap<String ,Object>();
//			List<TopBuyersVo> blist= insBuyersService.findListNotOid(topBuyersVo,page);
//			map.put("vo", blist);
//			map.put("page", page);
//			ReturnJsonUtil.buildJson(map, response);
//			return;
//		} catch (Exception e) {
//			e.printStackTrace();
//			ReturnJsonUtil.getJsonError(response);
//		}
//	}
//
//	/**
//	 * 买家是否可以新增
//	 * @param model
//	 * @param data
//	 */
	@RequestMapping("/findBuyersBySerach")
    @ResponseBody
	public JSONObject findBuyersBySerach(ModelMap model, TopBuyersVo  topBuyersVo ) {
		try {
            JSONObject json = new JSONObject();
			Long num = insTopBuyersService.findTopBuyersBySerach(topBuyersVo.getCountry(),topBuyersVo.getCity(),topBuyersVo.getCustomer_name(),topBuyersVo.getSpecial_id()+"",topBuyersVo.getOid());
            if(num>0){
                json.put("message", Constant.FAIL);
                json.put("code", Constant.FAIL_CODE);
            }else{
                json.put("message", Constant.SUCCESS);
                json.put("code", Constant.SUCCESS_CODE);
			}
			return json;
		} catch (Exception e) {
			e.printStackTrace();
		}
        return  null;
	}
//
//	/**
//	 * <b>修改可用额度 </b>
//	 *
//	 * @param model
//	 * @param data
//	 * @author liyongqiang
//	 * @date 2017年1月20日 上午10:14:00
//	 * @注意事项 </b>
//	 * <b>
//	 */
//	@RequestMapping("/updTopBuyerReplyAmount")
//	public void updTopBuyerReplyAmount(ModelMap model, String data) {
//		try {
//			TopBuyersVo topBuyersVo  = MessageUtils.getObject(data,TopBuyersVo.class ,"topBuyersVo");
//			Long  userId =MessageUtils.getLongValueByKey(data, "userId");
//			Long  status= MessageUtils.getLongValueByKey(data, "status");
//			BigDecimal  amount = MessageUtils.getBigDecimalValueByKey(data, "amount");
//			boolean flag=insTopBuyersService.updTopFreeAmount(topBuyersVo.getOid(),userId,status,amount);
//			if(flag){
//				ReturnJsonUtil.getJsonSuccess(response);
//				return;
//			}
//		} catch (Exception e) {
//			ReturnJsonUtil.getJsonError(response);
//			e.printStackTrace();
//		}
//	}
}
