package com.bcxin.ins.coninsweb.order.controller.api.gzzrx.zhonghua;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.third.gzzrx.zhonghua.GZZRX_ZHRequestService;
import com.bcxin.ins.third.gzzrx.zhonghua.security.ZHOfflineSendInfoVo;
import com.bcxin.ins.third.gzzrx.zhonghua.security.ZHSendInfoVo;
import com.bcxin.ins.third.gzzrx.zhonghua.security.ZHSendMailInfoVo;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.Date;


/**
 * <b>中华-雇主责任险接口Controller控制器，用于回调</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Controller
public class GZZRX_ZH_API_Controller extends BaseController {


	@Autowired
	private InsTransactionAPIService insTransactionAPIService;
	@Autowired
	private PolicyService policyService;
	@Autowired
	private InsPreservationPayAPIService insPreservationPayAPIService;
	@Autowired
	private GZZRX_ZHRequestService gZZRX_ZHRequestService;

	/**
	 * 保单接口回调
	 * @param xml 请求报文
	 */
	@RequestMapping(value = "/ZH-API/GZZRX/callback-policy")
	public void callbackPolicy(@RequestBody String xml) throws UnsupportedEncodingException {
		HttpServletRequest request = getRequest();
		if(xml.contains("%3C%")){
			xml = URLDecoder.decode(xml, ConstProp.ENCODE_UTF8);
		}
		logger.info("保单生效接口回调-callback-policy-ZH-GZZRX：请求报文-"+xml);
		ZHSendInfoVo zhvo = new ZHSendInfoVo();
		zhvo.analysisXML(xml);
		String r = zhvo.returnResult("1111","接收失败");
		if(StringUtils.isEmpty(xml)){
			renderString(response, r, "text/xml; charset=GBK");
			logger.info("保单生效接口回调-callback-policy-ZH-GZZRX：业务结束：end");
			return;
		}
		if(!"0000".equals(zhvo.getPayresult())){
			renderString(response, r, "text/xml; charset=GBK");
			logger.info("保单生效接口回调-callback-policy-ZH-GZZRX：业务结束：end");
			return;
		}
		OrderFormVo orderVo = policyService.getPolicyDtoByRcptNo(zhvo.getAppno());
		if(orderVo == null){
			renderString(response, r, "text/xml; charset=GBK");
			logger.info("保单生效接口回调-callback-policy-ZH-GZZRX：业务结束：end");
			return;
		}
		if(StringUtils.isEmpty(orderVo.getExternal_reference())){
			PolicyTransactionVo vo= new PolicyTransactionVo();
			vo.setTrade_serial_number(zhvo.getSerialnumber());//交易流水号
			vo.setPay_amount(new BigDecimal(zhvo.getPayamt()));
			vo.setStart_time(DateUtil.convertString2Date(zhvo.getTransdate()));
			vo.setEnd_time(new Date());
			vo.setPayment_method(ConstProp.DIGIT_ONE);
			vo.setPay_type(payType(zhvo.getPaymenttype()));
			vo.setPolicy_id(orderVo.getOid());
			vo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			vo.setPath_sign(ConstProp.DIGIT_ONE);
			vo.setUser_id(Long.parseLong(orderVo.getUser_oid()));
			insTransactionAPIService.saveTransaction(vo);
			logger.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			//保存保单号
			vo.setPolicy_number(zhvo.getPolno());
			insTransactionAPIService.savePolicyExternalReference(vo);
			if(StringUtils.isNotEmpty(zhvo.getEurl())){
				//保存保单地址
				vo.setInsure_path(zhvo.getEurl());//保单地址
				insTransactionAPIService.savePolicyOther(vo);
			}
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					policyService.returnsAnOrderToTheSpecifiedPlatform(orderVo.getOid());
				} catch(Exception e) {
					logger.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			}).start();
		}
		r = zhvo.returnResult("0000","接收成功");
		renderString(response, r, "text/xml; charset=GBK");
		logger.info("保单生效接口回调-callback-policy-ZH-GZZRX：业务结束：end");
	}

	/**
	 * 线下支付保单信息回调
	 * @param xml 请求报文
	 */
	@RequestMapping(value = "/ZH-API/GZZRX/offline-callback-policy")
	public void offlineCallbackPolicy(@RequestBody String xml) throws UnsupportedEncodingException {
		HttpServletRequest request = getRequest();
		if(xml.contains("%3C%")){
			xml = URLDecoder.decode(xml, ConstProp.ENCODE_UTF8);
		}
		logger.info("线下支付保单信息回调-offline-callback-policy-ZH-GZZRX：请求报文-"+xml);
		ZHOfflineSendInfoVo zhvo = new ZHOfflineSendInfoVo();
		zhvo.analysisXML(xml);
		String r = zhvo.returnResult("1111","接收失败");
		if(StringUtils.isEmpty(xml)){
			renderString(response, r, "text/xml; charset=GBK");
			logger.info("线下支付保单信息回调-offline-callback-policy-ZH-GZZRX：业务结束：end");
			return;
		}
		if(!ConstProp.DIGIT_ONE.equals(zhvo.getStatus())){
			renderString(response, r, "text/xml; charset=GBK");
			logger.info("线下支付保单信息回调-offline-callback-policy-ZH-GZZRX：业务结束：end");
			return;
		}
		OrderFormVo orderVo = policyService.getPolicyDtoByRcptNo(zhvo.getAppno());
		if(orderVo == null){
			renderString(response, r, "text/xml; charset=GBK");
			logger.info("线下支付保单信息回调-offline-callback-policy-ZH-GZZRX：业务结束：end");
			return;
		}
		if(StringUtils.isEmpty(orderVo.getExternal_reference())){
			PolicyTransactionVo vo= new PolicyTransactionVo();
			vo.setTrade_serial_number(zhvo.getSerialnumber());//交易流水号
			vo.setPay_amount(new BigDecimal(zhvo.getPremium()));
			vo.setStart_time(DateUtil.convertString2Date(zhvo.getTransrdate()));
			vo.setEnd_time(new Date());
			vo.setPayment_method(ConstProp.DIGIT_ONE);
			vo.setPay_type(DictConst.PAY_TYPE_XX);
			vo.setPolicy_id(orderVo.getOid());
			vo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			vo.setPath_sign(ConstProp.DIGIT_ONE);
			vo.setUser_id(Long.parseLong(orderVo.getUser_oid()));
			insTransactionAPIService.saveTransaction(vo);
			logger.info("线下支付保单信息回调-offline-callback-policy-ZH-GZZRX：接收成功-支付信息处理完成");
			//保存保单号
			vo.setPolicy_number(zhvo.getPolno());
			insTransactionAPIService.savePolicyExternalReference(vo);
			if(StringUtils.isNotEmpty(zhvo.getEurl())){
				//保存保单地址
				vo.setInsure_path(zhvo.getEurl());//保单地址
				insTransactionAPIService.savePolicyOther(vo);
			}
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					policyService.returnsAnOrderToTheSpecifiedPlatform(orderVo.getOid());
				} catch(Exception e) {
					logger.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			}).start();
		}
		r = zhvo.returnResult("0000","接收成功");
		renderString(response, r, "text/xml; charset=GBK");
		logger.info("线下支付保单信息回调-offline-callback-policy-ZH-GZZRX：业务结束：end");
	}

	/**
	 * <b> 电子发票回调 </b>
	 * @author ZXF
	 * @create 2019/09/29 0029 10:36
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping(value = "/ZH-API/GZZRX/callback-invoice")
	public void callbackInvoice(@RequestBody String xml) throws UnsupportedEncodingException {
		HttpServletRequest request = getRequest();
		if(xml.contains("%3C%")){
			xml = URLDecoder.decode(xml, ConstProp.ENCODE_UTF8);
		}
		logger.info("电子发票接口回调-callback-invoice-ZH-GZZRX：请求报文-"+xml);
		ZHSendMailInfoVo zhvo = new ZHSendMailInfoVo();
		zhvo.analysisXML(xml);
		String r = zhvo.returnResult("1111","接收失败");
		if(StringUtils.isNotEmpty(zhvo.getEinvoicedl())){
			OrderFormVo orderVo = policyService.getPolicyDtoByRcptNo(zhvo.getAppno());
			if(orderVo != null){
				//保存电子发票地址
				policyService.updateUrlByExternalreference(zhvo.getEinvoicedl(),zhvo.getPolno());
				r = zhvo.returnResult("0000","接收成功");
			}
		}
		renderString(response, r, "text/xml; charset=GBK");
		logger.info("电子发票接口回调-callback-invoice-ZH-GZZRX：业务结束：end");
	}

	/**
	 * <b> 手动查询支付结果并完成承保流程相关业务 </b>
	 * 适用场景：当用户已成功支付，由于保险公司平台异常未将支付信息推送过来时，技术人员手动调用该接口主动向保险公司平台获取保单信息完成承保业务
	 * @param oid 订单id
	 * @author ZXF
	 * @create 2019/04/09 0009 11:14
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping(value = "/ZH-API/GZZRX/callback-help/{oid}")
	public void callbackHelp(@PathVariable long oid) throws Exception {
		String xml = gZZRX_ZHRequestService.request_zh_gzzrx(oid,"6",null);
		logger.info("保单生效接口回调-callback-help-ZH-GZZRX：请求报文-"+xml);
		ZHSendInfoVo zhvo = new ZHSendInfoVo();
		zhvo.analysisXML(xml);
		String r = zhvo.returnResult("1111","接收失败");
		if(StringUtils.isEmpty(xml)){
			renderString(response, r, "text/xml; charset=GBK");
			logger.info("保单生效接口回调-callback-help-ZH-GZZRX：业务结束：end");
			return;
		}
		if(!"0000".equals(zhvo.getPayresult())){
			renderString(response, r, "text/xml; charset=GBK");
			logger.info("保单生效接口回调-callback-help-ZH-GZZRX：业务结束：end");
			return;
		}
		OrderFormVo orderVo = policyService.getPolicyDtoByRcptNo(zhvo.getAppno());
		if(orderVo == null){
			renderString(response, r, "text/xml; charset=GBK");
			logger.info("保单生效接口回调-callback-help-ZH-GZZRX：业务结束：end");
			return;
		}
		if(StringUtils.isEmpty(orderVo.getExternal_reference())){
			PolicyTransactionVo vo= new PolicyTransactionVo();
			vo.setTrade_serial_number(zhvo.getSerialnumber());//交易流水号
			vo.setPay_amount(new BigDecimal(zhvo.getPayamt()));
			vo.setStart_time(DateUtil.convertString2Date(zhvo.getTransdate()));
			vo.setEnd_time(new Date());
			vo.setPayment_method(ConstProp.DIGIT_ONE);
			vo.setPay_type(DictConst.PAY_TYPE_XX);//线下支付
			vo.setPolicy_id(orderVo.getOid());
			vo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			vo.setPath_sign(ConstProp.DIGIT_ONE);
			vo.setUser_id(Long.parseLong(orderVo.getUser_oid()));
			insTransactionAPIService.saveTransaction(vo);
			logger.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			//保存保单号
			vo.setPolicy_number(zhvo.getPolno());
			insTransactionAPIService.savePolicyExternalReference(vo);
			if(StringUtils.isNotEmpty(zhvo.getEurl())){
				//保存保单地址
				vo.setInsure_path(zhvo.getEurl());//保单地址
				insTransactionAPIService.savePolicyOther(vo);
			}
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					policyService.returnsAnOrderToTheSpecifiedPlatform(orderVo.getOid());
				} catch(Exception e) {
					logger.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			}).start();
		}
		r = zhvo.returnResult("0000","接收成功");
		renderString(response, r, "text/xml; charset=GBK");
		logger.info("保单生效接口回调-callback-help-ZH-GZZRX：业务结束：end");
	}

	@RequestMapping(value = "/ZH-API/GZZRX/callback-help-insure-path/{oid}")
	public void callbackHelpUpdateInsurePath(@PathVariable long oid) throws Exception {
		String xml = gZZRX_ZHRequestService.request_zh_gzzrx(oid,"6",null);
		logger.info("查询支付结果-callback-help-insure-path-ZH-GZZRX：返回报文-"+xml);
		ZHSendInfoVo zhvo = new ZHSendInfoVo();
		zhvo.analysisXML(xml);
		String r = zhvo.returnResult("1111","接口请求失败");
		if(StringUtils.isNotEmpty(xml)){
			if(StringUtils.isNotEmpty(zhvo.getPolno())&&StringUtils.isNotEmpty(zhvo.getEurl())){
				PolicyTransactionVo vo= new PolicyTransactionVo();
				vo.setPolicy_id(String.valueOf(oid));
				//保存保单地址
				vo.setInsure_path(zhvo.getEurl());//保单地址
				insTransactionAPIService.savePolicyOther(vo);
				r = zhvo.returnResult("0000","保单设置成功");
			}else{
				r = zhvo.returnResult("0000","接口未返回保单信息");
			}
		}
		renderString(response, r, "text/xml; charset=GBK");
		logger.info("保单生效接口回调-callback-help-ZH-GZZRX：业务结束：end");
	}

	private String payType(String pt){
		if("5".equals(pt)){
			return "1";
		}else if("7".equals(pt)){
			return "2";
		}else if("1".equals(pt)){
			return "3";
		}else {
			return "7";
		}
	}

	/**
	 * <b> 中华雇主非见费出单补承保业务方法 </b>
	 * @param payamt 保费
	 * @param appno 投保单号
	 * @param polno 保单号
	 * @param eurl 电子保单地址
	 * @author ZXF
	 * @create 2019/06/03 0003 10:09
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping(value = "/ZH-API/GZZRX/callbackHelpTest")
	@ResponseBody
	public String callbackHelpTest(ZHSendInfoVo zhvo) throws Exception {
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		String resultCode = "1111";
		String errInfo = "未找到匹配订单！";
		OrderFormVo orderVo = policyService.getPolicyDtoByRcptNo(zhvo.getAppno());
		if(orderVo == null){
			logger.info("保单生效接口回调-callback-help-ZH-GZZRX：业务结束：end");
			JSONObject json = new JSONObject();
			json.put("resultCode",resultCode);
			json.put("errInfo",errInfo);
			return json.toJSONString();
		}
		if(StringUtils.isEmpty(orderVo.getExternal_reference())){
			PolicyTransactionVo vo= new PolicyTransactionVo();
			vo.setTrade_serial_number(String.valueOf(idWorker.nextId()));//交易流水号
			vo.setPay_amount(new BigDecimal(zhvo.getPayamt()));
			vo.setStart_time(new Date());
			vo.setEnd_time(new Date());
			vo.setPayment_method(ConstProp.DIGIT_ONE);
			vo.setPay_type(payType(zhvo.getPaymenttype()));
			vo.setPolicy_id(orderVo.getOid());
			vo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			vo.setPath_sign(ConstProp.DIGIT_ONE);
			vo.setUser_id(Long.parseLong(orderVo.getUser_oid()));
			insTransactionAPIService.saveTransaction(vo);
			logger.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			//保存保单号
			vo.setPolicy_number(zhvo.getPolno());
			insTransactionAPIService.savePolicyExternalReference(vo);
			if(StringUtils.isNotEmpty(zhvo.getEurl())){
				//保存保单地址
				vo.setInsure_path(zhvo.getEurl());//保单地址
				insTransactionAPIService.savePolicyOther(vo);
			}
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					policyService.returnsAnOrderToTheSpecifiedPlatform(orderVo.getOid());
				} catch(Exception e) {
					logger.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			}).start();
		}
		resultCode = "0000";
		errInfo = "补承保业务已执行！";
		logger.info("保单生效接口回调-callback-help-ZH-GZZRX：业务结束：end");
		JSONObject json = new JSONObject();
		json.put("resultCode",resultCode);
		json.put("errInfo",errInfo);
		return json.toJSONString();
	}

	/**
	 * <b> 申请电子发票 </b>
	 * @author ZXF
	 * @create 2019/11/01 0001 10:38
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/ZH-API/GZZRX/PRINT_INVOICE/{oid}")
	@ResponseBody
	public ResultDto printInvoice(@PathVariable long oid) throws Exception {
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(oid);
		if(dto == null || !ConstProp.DIGIT_SIX.equals(dto.getPolicy_status())){
			return new ResultDto("无法获取发票！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		String result = gZZRX_ZHRequestService.request_zh_gzzrx(oid, TransTypeEnum.DZFP.getValue(),null);
		if(StringUtils.isEmpty(result)){
			return new ResultDto("获取电子发票接口异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		//第一次请求成功没有电子发票地址需要重新请求（以下为，如果接口成功返回但是没有地址就重新请求一遍）
		if(StringUtils.isEmpty(result.replace("200#",ConstProp.BLANK_CHAR))){
			result = gZZRX_ZHRequestService.request_zh_gzzrx(oid, TransTypeEnum.DZFP.getValue(),null);
		}
		String[] strs = result.split(ConstProp.POUND_SIGN);
		if(!ConstProp.CODE_SUCCESS.equals(strs[0])){
			return new ResultDto(strs[1], ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(StringUtils.isNotEmpty(strs[1])){
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
//						policyService.updateUrlByExternalreference(strs[1],dto.getExternal_reference());
				return new ResultDto(strs[1], ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("未获取到保单号！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("发票生成中！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	public static void main(String[] args) {
//		String b = "<?xml version=\"1.0\" encoding=\"GBK\"?>\n" +
//				"<INSUREQ>\n" +
//				"\t<MAIN>\n" +
//				"\t\t<TRANSRNO>2017</TRANSRNO>\n" +
//				"\t\t<SERIALNUMBER>157621872969796319983</SERIALNUMBER>\n" +
//				"\t\t<TRANSRDATE>2019-12-13 14:32:49</TRANSRDATE>\n" +
//				"\t</MAIN>\t\n" +
//				"\t<BODY>\n" +
//				"\t\t\t<BODY_LIST>\n" +
//				"\t\t\t\t<APPNO>051985170010043U000048</APPNO>\n" +
//				"\t\t\t\t<POLNO>011985170010043U000065</POLNO>\n" +
//				"\t\t\t\t<AMOUNT>72000000</AMOUNT>\n" +
//				"\t\t\t\t<PREMIUM>2240</PREMIUM>\n" +
//				"\t\t\t\t<STATUS>1</STATUS>\n" +
//				"\t\t\t\t<EURL></EURL>\n" +
//				"\t\t\t</BODY_LIST>\n" +
//				"\t</BODY>\n" +
//				"</INSUREQ>";
//		String a = HttpUtil.post("http://www.bailianbao.cn/ZH-API/GZZRX/offline-callback-policy",b);
//		System.out.println(a);

//		String xml = "<?xml version=\"1.0\" encoding=\"GBK\"?>\n" +
//				"<INSUREQ>\n" +
//				"\t<HEAD>\n" +
//				"\t\t<TRANSRNO>1002</TRANSRNO>\n" +
//				"\t\t<PARTNERCODE>BCXWL</PARTNERCODE>\n" +
//				"\t\t<PARTNERSUBCODE>BCXWL</PARTNERSUBCODE>\n" +
//				"\t</HEAD>\n" +
//				"\t<MAIN>\n" +
//				"\t\t<BASE>\n" +
//				"\t\t\t<SERIALNUMBER>4200000431201912045652385904</SERIALNUMBER>\n" +
//				"\t\t\t<TRANSDATE>2019-12-04 14:30:09</TRANSDATE>\n" +
//				"\t\t\t<PAYRESULT>0000</PAYRESULT>\n" +
//				"\t\t\t<PAYREMARK>成功</PAYREMARK>\n" +
//				"\t\t\t<PAYMENTTYPE>7</PAYMENTTYPE>\n" +
//				"\t\t\t<PAYDATE>2019-12-04 14:30:09</PAYDATE>\n" +
//				"\t\t\t<PAYAMT>1440.00</PAYAMT>\n" +
//				"\t\t\t<PAYID>BCXWL201903010000005337</PAYID>\n" +
//				"\t\t\t<PAYNO>T0785000120190301000001</PAYNO>\n" +
//				"\t\t</BASE>\n" +
//				"\t\t<POLICYLIST>\n" +
//				"\t\t\t<POLICY>\n" +
//				"\t\t\t\t<APPNO>051985170010043U000036</APPNO>\n" +
//				"\t\t\t\t<POLNO>011985170010043U000049</POLNO>\n" +
//				"\t\t\t\t<EURL></EURL>\n" +
//				"\t\t\t\t<RECEIPT_URL></RECEIPT_URL>\n" +
//				"\t\t\t\t<POLICYTYPE>2</POLICYTYPE>\n" +
//				"\t\t\t</POLICY>\n" +
//				"\t\t</POLICYLIST>\n" +
//				"\t</MAIN>\n" +
//				"</INSUREQ>";
//		String a = HttpUtil.post("http://www.bailianbao.cn/ZH-API/GZZRX/callback-policy",xml);
//		System.out.println(a);
//		ZHSendInfoVo zhvo = new ZHSendInfoVo();
//		zhvo.analysisXML(xml);
//		System.out.println(zhvo.toString());
//		System.out.println(GZZRX_PackageMessageZhongHua.unloading_bd("011985170001043U000024","http://ptn.cic.cn/facade/print/epolicy?polno=011985170001043U000024%26sign=DE00F141367FFDAD23CEE4B6BD90B08F"));
	}
}

