package com.bcxin.ins.coninsweb.order.controller.api.build.dubang;

import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.third.build.dubang.DBBuildAPIService;
import com.bcxin.ins.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * <b>都邦-工程投标险接口Controller控制器，用于回调</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Controller
public class Build_DB_API_Controller extends BaseController {


	@Autowired
	private DBBuildAPIService dBBuildAPIService;

	/**
	 * 支付接口回调
	 * @param response
	 */
	@RequestMapping(value = "/DB-API/Build/callbackPay")
	public void  callbackPay(HttpServletResponse response, @RequestBody String xml) throws UnsupportedEncodingException {
		if(xml.contains("%3C%")){
			xml = URLDecoder.decode(xml, ConstProp.ENCODE_UTF8);
		}
		logger.info("支付接口回调-callbackPay-DB-Build：请求报文-"+xml);
		response.setCharacterEncoding(ConstProp.ENCODE_UTF8);
		response.setContentType(ConstProp.ENCODE_UTF8_TEXT);
		String result = dBBuildAPIService.callbackPay(xml);
		logger.info("支付接口回调-callbackPay-DB-Build：接口返回数据-"+result);
		MessageUtils.returnMessage(result,response);
		logger.info("支付接口回调-callbackPay-DB-Build：业务结束：end");
	}

	/**
	 * 保单接口回调
	 * @param response
	 */
	@RequestMapping(value = "/DB-API/Build/callbackPolicy")
	public void  callbackPolicy(HttpServletResponse response, @RequestBody String xml) throws UnsupportedEncodingException {
		if(xml.contains("%3C%")){
			xml = URLDecoder.decode(xml, ConstProp.ENCODE_UTF8);
		}
		logger.info("保单生效接口回调-callbackPolicy-DB-Build：请求报文-"+xml);
		response.setCharacterEncoding(ConstProp.ENCODE_UTF8);
		response.setContentType(ConstProp.ENCODE_UTF8_TEXT);
		String result = dBBuildAPIService.callbackPolicy(xml);
		logger.info("保单生效接口回调-callbackPolicy-DB-Build：接口返回数据-"+result);
		MessageUtils.returnMessage(result,response);
		logger.info("保单生效接口回调-callbackPolicy-DB-Build：业务结束：end");
	}
}

