package com.bcxin.ins.coninsweb.news.controller;

import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.InfoNews;
import com.bcxin.ins.core.entity.InfoNewsPageResult;
import com.bcxin.ins.core.service.InfoNewsService;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.google.common.collect.Maps;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 建筑产品相关业务逻辑处理（不包括后台产品配置）
 * @author zxf
 *
 */
@Controller
public class InformationNewsController extends BaseController {
	@Autowired
	private InfoNewsService infoNewsService;
	/**
	 * <b>前台页面新闻资讯详情 </b>
	 *
	 * @param request
	 * @param oid
	 * @return
	 * @author ZXF\
	 * @date 2016年12月21日 下午1:39:31
	 * @注意事项 </b>
	 * <b>
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】新闻资讯列表-详情")
	@RequestMapping("/infoNews/infoNewsInfo/{oid}")
	public ModelAndView productInfo(HttpServletRequest request, HttpServletResponse response,@PathVariable long oid, @RequestParam(value = "recommendCode", required = false) String recommendCode) {
		ModelAndView view = new ModelAndView("/coninsweb/news/newsInfo");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		view.addObject(ConstProp.USERDETAIL, userdetail);

		Map<String,Object> m1 = Maps.newHashMap();
		Map<Object, Object> m2 = Maps.newHashMap();
		m1.put("info_news_id",oid);
//		CTLUtil.out(infoNewsService.selectByMap(m).get(0),response);

		InfoNews infoNews=infoNewsService.selectByMap(m1).get(0);

		view.addObject("infoNewsInfo",infoNews);
		//阅读数每次点击增加一次
		int i =Integer.parseInt(infoNewsService.selectByMap(m1).get(0).getRead_real_number())+1;
		infoNews.setRead_real_number(String.valueOf(i));
		infoNewsService.insertOrUpdate(infoNews);//保存到数据库

		SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd ");
		view.addObject("update_time",sdf.format(infoNews.getUpdate_time()));
		view.addObject("number",Integer.parseInt(infoNews.getRead_number())+Integer.parseInt(infoNews.getRead_real_number()));

//		String json = JSON.toJSONStringWithDateFormat(infoNews, "yyyy-MM-dd HH:mm:ss");
//		view.addObject("row",json);

		//根据专题资讯的label查询推荐新闻
		String label = infoNewsService.selectByMap(m1).get(0).getLabel();
		m2.put("info_news_id",oid);
		if (label!=null){
			List<String> list= Arrays.asList(label.split("，"));
			m2.put("label",list);
			view.addObject("InfoNewsListByLabel",infoNewsService.InfoNewsListByLabel(m2));
		}
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>新闻资讯列表 </b>
	 */
	@RequestMapping("/news/newsALLView")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】新闻资讯列表")
	public ModelAndView newsALL(HttpServletRequest req, @RequestParam Map<Object,Object> params, HttpServletResponse resp,DwzPage page){
		ModelAndView view = new ModelAndView("/coninsweb/news/newsAll");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		view.addObject(ConstProp.USERDETAIL, userdetail);
		params.put("limit",8);
		params.put("offset",(page.getPageNum()-1)*page.getNumPerPage());
		InfoNewsPageResult infoNewsPageResult =infoNewsService.InfoNewsQuery(params);
		view.addObject("infoNews",infoNewsPageResult);
		page.setNumPerPage(8);
		page.setTotalCount(infoNewsPageResult.getTotal());
		view.addObject("info_news_type",params.get("info_news_type"));
		setTokenByApi(view);
		return view;
	}


	@RequestMapping("/infoNews/query")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【数据请求】新闻资讯列表-分页查询")
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp,DwzPage page) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		params.put("limit",8);
//		params.put("limit", page.getNumPerPage());
		params.put("offset", (page.getPageNum() - 1) * page.getNumPerPage());
		InfoNewsPageResult infoNewsPageResult =infoNewsService.InfoNewsQuery(params);
		Map<Object,Object> map =new HashedMap();
		page.setNumPerPage(8);
		page.setTotalCount(infoNewsPageResult.getTotal());
		map.put("rendering",params.get("rendering"));
		map.put("infoNewsPageResult",infoNewsPageResult);
		map.put("page",page);
		CTLUtil.out(map,resp);
		return null;
	}
}
