package com.bcxin.ins.coninsweb.common.controller;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.core.service.ComBankCodeService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.third.zzx.yongan.ZZX_YARequestService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.*;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.common.ComBlogroll;
import com.bcxin.ins.entity.common.ComPartners;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.*;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.util.*;

/**
 * <b>专门用来对不需要登录的应用功能进行处理，如：关于我们，调处服务，理赔相关等 </b>
 * 
 * @author zxf
 * @date 2016年12月14日 下午4:34:34
 * @注意事项 </b>
 * <b>
 */
@Controller
@RequestMapping("/synopsis")
public class SynopsisController extends BaseController {

	@Autowired
	private InsInsuranceSlipAPIService insurancePolicyService;
	
	@Autowired
	private ComPartnersAPIService comPartnersAPIService;
	
	@Autowired
	private ComBlogrollAPIService comBlogrollAPIService;
	
	@Autowired
	private ProductService productService;

	@Autowired
	private InsTransactionAPIService policyTransactionService;
	@Autowired
	private PolicyService policyService;
	@Autowired
	private InsTransactionAPIService insTransactionService;
	@Autowired
	private ClientUserService clientUserService;
	@Autowired
	private InsProductAPIService insProductAPIService;
	@Autowired
	private InsAgreementAPIService insAgreementAPIService;
	@Autowired
	private ComDeployConfigService comDeployConfigService;
	@Autowired
	private ComBankCodeService comBankCodeService;

	@Autowired
	private InsPreservationPayAPIService insPreservationPayAPIService;

	private Logger log =  LoggerFactory.getLogger(SynopsisController.class);

	/**
	 * localhost:8080/conins/synopsis/testAPI/880336672393015296
	 * @param oid
	 * @return
	 */
	@RequestMapping("testAPI/{oid}")
	public ModelAndView testAPI(@PathVariable Long oid) {
		ModelAndView view = new ModelAndView("/synopsis/loseView");
		/*OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(oid);
		InsInsuranceSlip insPolicy = insurancePolicyService.selectById(oid);
		String flag = OrderSupportUtil.receiveOrderFormData(dto,insPolicy,insPolicy.getInsTransaction().get(0));*/
//		OrderSupportUtil.cancellationOrder(String.valueOf(oid));
//		System.out.println(flag);
		return view;
	}

	@RequestMapping("/testFile")
	@ResponseBody
	public String testFile() throws Exception {
		String p = "http://tapi.yaic.com.cn/yaicservice/apppdfServlet?user=BCX&policyno=23306000010021180000074&sign=2e307fe1797015668581891b4b4ee239";
		String u = ZZX_YARequestService.unloading_ya(p);
		return u;
	}

	@RequestMapping("loseView")
	public ModelAndView loseView() {
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/loseView");
		return view;
	}

	@RequestMapping("unSession")
	public ModelAndView unSession() {
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/unSession");
		return view;
	}

	/**
	 * <b>保险小常识 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:40:13
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("commonSense/init")
	public ModelAndView commonSense() {
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/commonSense");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	} 
	
	/**
	 * <b>用户服务协议 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:49:58
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("protocol/init")
	public ModelAndView protocol() {
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/protocol");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>获取用户如果存在就放入ModelAndView </b> 
	 * 
	 * @param view 页面路径
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:50:34
	 * @注意事项 </b>
	 * <b>
	 */
	private void sessionUser(ModelAndView view) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		view.addObject(ConstProp.USERDETAIL,userdetail);
	}
	
	/**
	 * <b>疑难解答 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:52:07
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="questions/init")
	public ModelAndView questions(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/questions");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>小微企业出口贸易短期信用险条款 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:52:30
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="clause/xm01")
	public ModelAndView xm01(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/tradeInsurance_xw");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>出口贸易信用保险（短期）条款 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:52:36
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="clause/my01")
	public ModelAndView my01(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/tradeInsurance_my");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>关于我们 </b> 
	 * 
	 * @param type 模块类型
	 */
	@RequestMapping("us/init/{type}")
	public ModelAndView us(@PathVariable String type) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/us");
//		view.addObject("partners", comPartnersAPIService.findComPartnersList(null, null));
//		view.addObject("blogroll", comBlogrollAPIService.findComBlogrollList(null, null));
//		view.addObject("policies", comPoliciesAPIService.findComPoliciesList(null, null));
		view.addObject("type", type);
		view.addObject(ConstProp.USERDETAIL, userdetail);
//		sessionUser(view);
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>oss下载方法 </b> 
	 * 
	 * @param request 获取path，name
	 * @param response
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:53:48
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("sodownload")
	public void sodownload(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
		String key = request.getParameter("path");
		String name = request.getParameter("name");
		name = new String(name.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		String type = getType(key);
		try {
			OSSFileUtil.ossFileDownload(key, name+"."+type, response);
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	/**
	 * <b>这对获取到的下载地址判断是否为oss区分不同下载方法 </b> 
	 * 
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:54:40
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("dedownload")
	public void dedownload(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String name = request.getParameter("name");
		String url = request.getParameter("path");
		name = new String(name.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		String keyH = "";
		if(url.indexOf(".com/") == -1){
			keyH = url;
			policyService.downloadAttachment(keyH, name, response);
		}else{
			keyH = url.split(".com/")[1];
			OSSFileUtil.ossFileDownload(keyH, name+".pdf", response);
		}
	}
	
	/**
	 * <b>根据保单ID获取保函文件地址并对其添加二维码后生产新的文件并保存到保单表 </b> 
	 * 
	 * @param request
	 * @param response
	 * @return 返回生产新文件的下载地址及操作状态
	 * @throws Exception
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:55:43
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("saveFileToPDF")
	@ResponseBody
	public ResultDto saveFileToPDF(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String pno = request.getParameter("pno");
		String num = request.getParameter("num");
		String url = "";
		InsInsuranceSlip policy = insurancePolicyService.selectById(Long.parseLong(pno));
//		policyService.policyToPDF(policy, num);
		PolicyTransactionVo vo= new PolicyTransactionVo();
		vo.setPolicy_id(pno);//设置订单id
		if("1".equals(num)){//抛电子保单法到后台
            if(StringUtils.isNotEmpty(policy.getInsure_path())){

            }else{
                policyService.policyToPDF(policy, num);
                vo.setInsure_path(policy.getInsure_path());//保单地址
                policyService.savePolicyOther(vo);
//                policy = insurancePolicyService.selectById(policy.getIns_insurance_slip_id());
            }
			url = policy.getInsure_path();

		}else if("2".equals(num)){
			if(StringUtils.isNotEmpty(policy.getLg_path())){
				url = policy.getLg_path();
			}else{
                policyService.policyToPDF(policy, num);
				String pathPolic_1 = GlobalResources.COM_IMG_RE;
				String codePath = pathPolic_1 + "/EWM" + DateUtil.generatorRadomNumber() +".png";
				String pathPolic_s = pathPolic_1 + "/BH" + DateUtil.generatorRadomNumber() +".pdf";
				String pathPolic_n = pathPolic_1 + "/BH" + DateUtil.generatorRadomNumber() +".pdf";
				ErweimaUtil.compound(pno, policy.getBh_initial(), codePath, pathPolic_s);
				File filess = new File(pathPolic_s);
				writeLinux(filess, pathPolic_n);
				url = OSSFileUtil.huaweiLocalFileUpload(filess, DateUtil.getCurrentDate(), "original");
//				Map<String, String> map = OSSFileUtil.ossFileUpload_sync(filess, "policy", true, "");
//				String bhPath = map.get("url");
				//抛电子保函到后台
//				url = bhPath;
				vo.setLg_path(url);//保函地址
				policyService.savePolicyOther(vo);
			}
		}
		return new ResultDto(url, "");
	}
	
	/**
	 * <b>写文件流方法 </b> 
	 * 
	 * @param file 文件信息
	 * @param path 写入地址
	 * @throws IOException
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:58:32
	 * @注意事项 </b>
	 * <b>
	 */
	private void writeLinux(File file, String path) throws IOException{

		try(FileOutputStream fileOutputStream = new FileOutputStream(new File(path));
			BufferedOutputStream bos=new BufferedOutputStream(fileOutputStream);){
			byte[] repByte = getContent(file);
			for(int h=0;h<repByte.length;h++){
				bos.write(repByte[h]);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	/**
	 * <b>将文件转成流方法 </b> 
	 * 
	 * @param file 文件
	 * @return
	 * @throws IOException
	 * @author ZXF 
	 * @date 2016年12月14日 下午4:59:38
	 * @注意事项 </b>
	 * <b>
	 */
	public byte[] getContent(File file) throws IOException {
		if(file == null){
			return null;
		}

		try(FileInputStream stream = new FileInputStream(file);
			ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);){
			byte[] b = new byte[1000];
			for (int n;(n = stream.read(b)) != -1;) {
				bos.write(b, 0, n);
				bos.flush();
			}
			return bos.toByteArray();
		}catch (Exception e){
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * <b>获取文件类型 </b> 
	 * 
	 * @param key 文件名称
	 * @return 返回文件后缀字符串
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:00:14
	 * @注意事项 </b>
	 * <b>
	 */
	private String getType(String key) {
		int i = key.split("\\.").length-1;
		String type = key.split("\\.")[i];
		return type;
	} 
	
	/**
	 * <b>页面底部合作伙伴列表展示 </b> 
	 * 
	 * @return 返回合作伙伴列表
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:00:59
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("footer_partners/init")
	public List<ComPartners> footer_partners() {
		ComPartners partners = new ComPartners();
		partners.setActive("Y");
		List<ComPartners> partnersList = comPartnersAPIService.findComPartnersList(partners, null);
		return partnersList;
	} 
	
	/**
	 * <b>页面底部友情链接列表 </b> 
	 * 
	 * @return 友情链接列表
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:02:23
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("footer_blogroll/init")
	public List<ComBlogroll> footer_blogroll() {
		ComBlogroll blogroll = new ComBlogroll();
		blogroll.setActive("Y");
		List<ComBlogroll> blogrollList = comBlogrollAPIService.findComBlogrollList(blogroll, null);
		return blogrollList;
	} 
	
	/**
	 * <b>扫描二维码后访问的方法，该方法为校验保单是否出自我司 </b> 
	 * 
	 * @param request pno加密的保单号
	 * @return
	 * @throws Exception
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:03:00
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("verifyToPno")
	public ModelAndView verifyToPno(HttpServletRequest request) throws Exception {
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/order/policyDetail_bd");
		String external = request.getParameter("pno");
		//external = URLDecoder.decode(external,ConstProp.ENCODE_UTF8);
		external = DesUtil.desDecodeCBC(ConstProp.REPORT_KEY, external);
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(external));
		SpecialBidVo vo = policyService.accordingToOrderIDToGetSpecialBidVo(Long.parseLong(orderVo.getOid()));
		view.addObject("otList", OfficeType.listT(orderVo.getProduct_code().contains("DB")?"DB":"OT"));
		view.addObject(ConstProp.VO,vo);
		setTokenByApi(view);
		return view;
	} 
	
	/**
	 * <b>合作伙伴页面跳转 </b> 
	 * 
	 * @param oid 合作伙伴ID
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:04:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("partners/init/{oid}")
	public ModelAndView partners(@PathVariable Long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/partner");
		if(oid==13729792){
		//太平洋
			 view = new ModelAndView("/coninsweb/synopsis/partner_cpic");
		}
		if(oid==13729793){
			//阳光
			view = new ModelAndView("/coninsweb/synopsis/partner_sun");
		}
		if(oid==22020096){
			//易安
			view = new ModelAndView("/coninsweb/synopsis/partner_yian");
		}
		if(oid==22020097){
			//中华
			view = new ModelAndView("/coninsweb/synopsis/partner_zhonghua");
		}
        if(oid==1){
            //中国大地财产保险股份
            view = new ModelAndView("/coninsweb/synopsis/partner_dadi");
        }
        if(oid==2){
            //华泰财产保险有限公司
            view = new ModelAndView("/coninsweb/synopsis/partner_huatai");
        }
        if(oid==5){
            //人保
            view = new ModelAndView("/coninsweb/synopsis/partner_renbao");
        }
        if(oid==6){
            //长安
            view = new ModelAndView("/coninsweb/synopsis/partner_changan");
        }
        /*if(oid==3){
            //泰康在线财产保险股份有限公司
            view = new ModelAndView("/coninsweb/synopsis/partner_taikang");
        }*/
        if(oid==4){
            //平安
            view = new ModelAndView("/coninsweb/synopsis/partner_pingan");
        }
		sessionUser(view);
		setTokenByApi(view);
		return view;
	} 
	
//	@RequestMapping("partners/init/{type}")
//	public ModelAndView partners(@PathVariable String type) {
//		ModelAndView view = new ModelAndView("synopsis/partner_"+type);
//		return view;
//	} 
	
	@RequestMapping("clausedetail/{type}")
	public ModelAndView clausedetail(@PathVariable String type) {
		ModelAndView view = new ModelAndView(ConstProp.SLASH);
		if(StringUtils.isNotEmpty(type)){
			view = new ModelAndView("/coninsweb/synopsis/"+type);
			sessionUser(view);
		}
		setTokenByApi(view);
		return view;
	} 
	
	/**
	 * <b>前台页面政策法规 </b> 
	 * 
	 * @param type
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:05:07
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("policies/{type}")
	public ModelAndView policies(@PathVariable String type) {
		ModelAndView view = new ModelAndView(ConstProp.SLASH);
		if(StringUtils.isNotEmpty(type)){
			view = new ModelAndView("/coninsweb/synopsis/policies/"+type);
			sessionUser(view);
		}
		setTokenByApi(view);
		return view;
	} 
	

	/**
	 * <b>保单查验页面 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:05:52
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="policy/examineView")
	public ModelAndView examineView(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/policy/examineView");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	
	/**
	 * <b>保单验真 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:06:07
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="policy/policyUpload")
	public ModelAndView policyUpload(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/policy/policyUpload");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>调处服务页面 (弃用)</b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:06:51
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="/mediateService")
	public ModelAndView mediateService(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/mediate");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>调处服务页面 （在用）</b> 
	 * 
	 * @param type
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:07:13
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="/insuranceService/{type}")
	public ModelAndView insuranceService(@PathVariable String type){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/insuranceService");
		view.addObject("type", type);
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	@RequestMapping(value="/clause/{oid}")
	public ModelAndView clauseView(@PathVariable long oid){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/clause");
		view.addObject("content", productService.getProduct(oid));
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>保单查询页面 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:07:58
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="policy/policySearch")
	public ModelAndView policySearch(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/policy/policySearch");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	
	/**
	 * <b>保单查询校验返回保单信息 </b> 
	 * 
	 * @param request
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:08:22
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/search/policySearch")
	public ModelAndView rePay(HttpServletRequest request) {
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/policy/searchMsg");
		String policySerialNumber = request.getParameter("policySerialNumber");
		String name = request.getParameter("name");
		Map map = null;
		if(StringUtils.isNotEmpty(policySerialNumber)&& StringUtils.isNotEmpty(name) ){
			map = insurancePolicyService.selectOrderByExAndName(policySerialNumber,name);
		}
		view.addObject("policy", map);
		setTokenByApi(view);
		return view;
	}

	/**
	 * 初始化页面，个人中心保单详情
	 * @param oid
	 * @return
	 */
	@RequestMapping(value = "policy/policyDetails/{oid}")
	public ModelAndView policyDetail(@PathVariable long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/user/transaction/policyDetails");
		/*view.addObject("policySaleForm", (InsurancePolicy)insurancePolicyService.findPolicyByOid(oid));
		sessionUser(view);*/
		setTokenByApi(view);
		return view;
	}
	
	@RequestMapping(value = "report/applyClaim")
    public ModelAndView claimsCenter(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/report/applyClaim");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>初始化申请理赔界面 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:20:01
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="report/addReport/init")
	public ModelAndView addReport(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/report/addReport");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}

	@RequestMapping(value="report/addClaims/init")
	public ModelAndView addClaims(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/report/addClaims");
		sessionUser(view);
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * 
	 * <b>申请理赔 </b> 
	 * 
	 * @param request
	 * @param dto 理赔信息接收辅助类
	 * @return
	 * @throws Exception
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:21:39
	 * @注意事项 </b>
	 * <b>
	 */
	/*@RequestMapping(value = "report/addClaims")
    public ResultDto uploadIndentImage(
            HttpServletRequest request, ClaimsDto dto
    ) throws Exception{
		UserVo userdetail= userManagerService.getSessionUser();
		if (  userdetail == null ) {
			return new ResultDto("请先登录！", "300",ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		InsurancePolicy policy = insurancePolicyService.findPolicyByExternal(dto.getPolicySerialNumber());
		if(policy != null){
			ClaimsCase claims = claimsService.claims(dto);
			claims.setReportTime(new Date());
			claims.setPolicy(policy);
			claims.setDownPath(dto.getDownPath());
			if(claimsService.saveOrUpdate(claims)){
				return new ResultDto("您的理赔申请已提交，三个工作日内客服人员会与您联系", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("理赔申请失败", "300",ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("平台未找到对应保单", "301",ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
    }*/

	/**
	 *
	 * <b>产品中心，各分类产品列表 </b> 
	 *
	 * @param request
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/product/productAllView")
	public ModelAndView productAll(HttpServletRequest request,DwzPage page) {
		ModelAndView view = new ModelAndView("/coninsweb/insurance/productAll");
		String pro_type = request.getParameter("pro_type");
		String condition = request.getParameter("condition");
		String recommendCode = request.getParameter("recommendCode");
		if(StringUtils.isEmpty(pro_type)){
			pro_type = "";
		}
		if(StringUtils.isEmpty(condition)){
			condition = "+"+ConstProp.DIGIT_ZERO;
		}
		page.setNumPerPage(5);
		List<ProductVo> listVo = null;
		try {
			listVo = productService.getProductsByConditionAndPage(pro_type,condition,page);
		}catch (Exception e){
			e.printStackTrace();
		}
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			UserSupportUtil.setCustomSession("goToUrl",GlobalResources.WEB_PRO_URL+"/synopsis/product/productAllView?pro_type="+pro_type+"&condition="+condition);
		}
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject("listVo", listVo);
		view.addObject("condition", condition);
		view.addObject("pro_type", pro_type);
		if(StringUtils.isNotEmpty(recommendCode)){
			UserSupportUtil.setRecommendCodeXH(recommendCode);
		}
		/*view.addObject("default", "0".equals(condition) ? "0" : "");//默认
		view.addObject("sales", "1".equals(condition) ? "-1" : "-1".equals(condition) ? "1" : "");//销量
		view.addObject("prices", "2".equals(condition) ? "-2" : "-2".equals(condition) ? "2" : "");//价格
		view.addObject("doTime", "3".equals(condition) ? "-3" : "-3".equals(condition) ? "3" : "");//上架时间*/
		setTokenByApi(view);
		return view;
	}

	@RequestMapping("/getroductAllForPage")
	public ModelAndView getroductAllForPage(HttpServletRequest request, DwzPage page){
		ModelAndView view = new ModelAndView("/coninsweb/insurance/productAll_table");
		String condition = request.getParameter("condition");
		String pro_type = request.getParameter("pro_type");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		view.addObject(ConstProp.USERDETAIL,userdetail);
		if(StringUtils.isEmpty(condition)){
			condition = "+"+ConstProp.DIGIT_ZERO;
		}
		List<ProductVo> listVo = productService.getProductsByConditionAndPage(pro_type,condition,page);
		view.addObject("listVo", listVo);
		setTokenByApi(view);
		return view;
	}

	@RequestMapping("/product/productList")
	@ResponseBody
	public List<ProductVo> productList() {
		List<ProductVo> listVo = productService.getProductsByOnLine("");
		return listVo;
	}

	@RequestMapping("/product/productListByCode/{code}")
	@ResponseBody
	public List<ProductVo> productListByCode(@PathVariable String code) {
		List<ProductVo> listVo = productService.getProductsByOnLine(code);
		return listVo;
	}

	/**
	 * <b> 在线咨询，发送邮件 </b>
	 * @author ZXF
	 * @create 2018/05/09 0009 10:48
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/online-consultation")
	@ResponseBody
	public String onlineConsultation(@RequestParam Map<Object,Object> params) {
		JSONObject json = new JSONObject();
		try {
			String pName = (String)params.get("pName");//产品名称
			String cName = (String)params.get("cName");//企业名称
			String name = (String)params.get("name");//联系人
			String tel = (String)params.get("tel");//手机
			String remark = (String)params.get("remark");//备注
			if(StringUtils.isNotEmpty(pName)&&StringUtils.isNotEmpty(cName)&&StringUtils.isNotEmpty(name)&&StringUtils.isNotEmpty(tel)){
				String htmlContent = "<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>Title</title></head><body><div><p style=\"font-size: 16px;color: #333\">咨询产品：<span>#pName#</span></p><p style=\"font-size: 16px;color: #333\">公司名称：<span>#cName#</span></p><p style=\"font-size: 16px;color: #333\">联系人：<span>#Name#</span></p><p style=\"font-size: 16px;color: #333\">联系电话：<span>#tel#</span></p><p style=\"font-size: 16px;color: #333\">备注：<span>#remark#</span></p></div></body></html>";
				htmlContent = htmlContent.replace("#pName#",pName);
				htmlContent = htmlContent.replace("#cName#",cName);
				htmlContent = htmlContent.replace("#tel#",tel);
				htmlContent = htmlContent.replace("#remark#",remark);
				htmlContent = htmlContent.replace("#Name#",name);
				String title = "有新的"+pName+"投保咨询，请及时处理";
				sendEmail( htmlContent, title );
				json.put("statusCode",ConstProp.CODE_SUCCESS);
				json.put("message","谢谢您的咨询，我们会尽快与您取得联系！");
			}else{
				json.put("statusCode",ConstProp.CODE_FAILURE);
				json.put("message","留言信息填写不完整！");
			}
		}catch (Exception e){
			json.put("statusCode",ConstProp.CODE_FAILURE);
			json.put("message","系统繁忙，请稍后重试！");
		}
		return json.toJSONString();
	}

	private void sendEmail(String htmlContent, String title ) {
		log.info("保全邮件发送（内容htmlContent）:"+htmlContent);
		String[] arrs = comDeployConfigService.getValueByKey("exmail").split(ConstProp.SEMICOLON);
		EmailModel emailModel = new EmailModel(title, htmlContent);
		List<String> emailList = new ArrayList<String>();
		for(int i=0;i<arrs.length;i++){
			if(StringUtils.isNotEmpty(arrs[i])&&!arrs[i].contains(ConstProp.COLON)){
				emailList.add(arrs[i].trim()); // 发送地址
				log.info("保全邮件发送（收件人Email-"+(i+1)+"）:"+arrs[i]);
			}
		}
		if(emailList.size()>0){
			emailModel.setTo(emailList);
			SendEmailAndMsgUtil.sendEmail(emailModel);
		}
	}

	@RequestMapping("proGmrList")
	public ModelAndView proGmrList(){
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/product_gmr_list");
		JedisUtils.batchDel(ConstProp.REDIS_HEAD_PROCACHE);
		String[] codes;
		String pCodes = GlobalResources.map.get("SAAS_PRO_SORT_DEFAULT");
		if(StringUtils.isNotEmpty(pCodes)){
			codes = pCodes.split(",");
		}else{
			codes = new String[]{ConstProp.GZZRX_RB,ConstProp.TYX_RB,ConstProp.TYX_PAS,ConstProp.TYX_PAC,ConstProp.TYX_TK,ConstProp.GZZRX_ZH,ConstProp.GZZRX_XZH};
		}
		view.addObject(ConstProp.LISTVO, findProByCodes(codes));
		setTokenByApi(view);

		return view;
	}
	/**
	 * <b> 根据标识数组遍历查询产品信息并汇总到list </b>
	 * @author ZXF
	 * @create 2019/04/22 0022 16:06
	 * @version
	 * @注意事项 </b>
	 */
	private List<ProductVo> findProByCodes(String[] codeArr){
		List<ProductVo> list = Lists.newArrayList();
		List<ProductVo> listVo = null;
		for(String code : codeArr){
			listVo = productService.getProductsByOnLine(code);
			if(listVo!=null){
				list.addAll(listVo);
			}
		}
		return list;
	}
	/**
	 * 
	 * <b>查询所有待支付的订单 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2016年12月14日 下午5:23:06
	 * @注意事项 </b>
	 * <b>
	 */
	/*@RequestMapping("/policy/pendingCode")
	public ResultDto pendingCode() {
		UserVo userdetail= userManagerService.getSessionUser();
		List<InsurancePolicy> pendinglist = insurancePolicyService.findPolicy(userdetail, PolicyStatus.PENDING);
		return new ResultDto(pendinglist.size()+"", "",ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
	}*/
	@RequestMapping("/findCity")
	@ResponseBody
	public List<ComRegion> findDistrictByParentCode(String codeLevel, String parentCode) {
		List<ComRegion> list = RegionUtils.findDistrictByParentCode(codeLevel, parentCode);
		return list;
	}
	@RequestMapping("/district")
	@ResponseBody
	public List<ComRegion> findDistrictByParentCode(@RequestParam Map<Object,Object> params) {
		String codeLevel = ConstProp.BLANK_CHAR;
		if(params.get("code_level") != null){
			codeLevel = (String)params.get("code_level");
		}
		String parentCode = ConstProp.BLANK_CHAR;
		if(params.get("parent_id") != null){
			parentCode = (String)params.get("parent_id");
		}
		List<ComRegion> list = RegionUtils.findDistrictByParentCode(codeLevel, parentCode);
		return list;
	}

	@RequestMapping("/findBankType")
	@ResponseBody
	public List<Map<String,String>> findBankType(String area) {
		List<Map<String,String>> list = comBankCodeService.getAllBankType(area);
		return list;
	}

	@RequestMapping("/findBankAddr")
	@ResponseBody
	public List<Map<String,String>> findBankAddr(String area,String bankName) {
		List<Map<String,String>> list = comBankCodeService.getAllBankAddr(area,bankName);
		return list;
	}
	@RequestMapping("/findTBBankAddr")
	@ResponseBody
	public List<Map<String,String>> findTBBankAddr(String area,String bankName) {
		List<Map<String,String>> list = comBankCodeService.getTBAllBankAddr(area,bankName);
		return list;
	}

	@RequestMapping("/getPolicyNumber")
	public String getPolicyNumber() {
		policyService.TYX_TK_02();
		return "forward:/api/gmr/policy/a";
	}

	@RequestMapping("/BLB-BBD/{oid}")
	public void BLB_BBD(@PathVariable long oid) throws Exception{

		String result = "200;"+ DateUtil.generatorRadomNumber()+";http://bcxin-conins-extranet-test.oss-cn-shanghai.aliyuncs.com/policy/201703211504184038.pdf";
		String[] strs = result.split(ConstProp.SEMICOLON);
		if(ConstProp.CODE_SUCCESS.equals(strs[0])&&strs.length == 3) {
			if (StringUtils.isNotEmpty(strs[1])) {
				PolicyTransactionVo vo= new PolicyTransactionVo();
				//保存保单号
				vo.setPolicy_number(strs[1]);//policy.setExternalReference();
				vo.setPolicy_id(String.valueOf(oid));
				policyTransactionService.savePolicyExternalReference(vo);
				//保存保单地址
				vo.setInsure_path(strs[2]);//保单地址
				policyTransactionService.savePolicyOther(vo);
				//如果团意险承保就推给百保盾
//				policyService.saveOrderInfo(String.valueOf(oid));
				//TODO 20180116-v2.0.4 推送保单信息到SAAS平台
				if(GlobalResources.IS_TEST_ENVI){
					policyService.saveOrderInfoPush(String.valueOf(oid));
				}
			}
		}
	}

	@RequestMapping("/TYX-PA-CB/{receiptNo}/{polNo}")
	public void TYX_PA_CB(@PathVariable String receiptNo,@PathVariable String polNo,HttpServletResponse response) throws Exception{
		OrderFormVo orderVo = policyService.getPolicyDtoByRcptNo(receiptNo);
		log.info("----------平安承保接口调用返回（TYX-PAS-CB）：SUCCESS!!-----------");
		JSONObject json = new JSONObject();
		try{
			if (StringUtils.isNotEmpty(polNo) && orderVo != null) {
				log.info("----------PAS-TYX-PolicyDto-request(oid:"+orderVo.getOid()+"，SUCCESS!!)-----------");
				PolicyTransactionVo vo= new PolicyTransactionVo();
				//保存保单号
				vo.setPolicy_number(polNo);//policy.setExternalReference();
				vo.setPolicy_id(orderVo.getOid());
				insTransactionService.savePolicyExternalReference(vo);
				SysClientUser user = clientUserService.selectById(orderVo.getUser_oid());
				log.info("----------平安承保接口调用返回更新数据库-Web_type（TYX-PAS-CB）："+user.getWeb_type()+"-----------");
				if(StringUtils.isNotEmpty(user.getWeb_type())) {
					if (user.getWeb_type().indexOf(ConstProp.ARS) != -1) {
						//如果团意险承保就推给百保盾
						policyService.saveOrderInfo(orderVo.getOid());
					}
					if (user.getWeb_type().indexOf(ConstProp.SAAS) != -1||user.getWeb_type().indexOf(ConstProp.PASP) != -1) {
						policyService.saveOrderInfoPush(orderVo.getOid());
					}
					log.info("----------平安承保接口调用返回更新数据库并推送百保盾（TYX-PAS-CB）：SUCCESS!!-----------");
				}
				log.info("----------平安承保接口调用返回更新数据库（TYX-PAS-CB）：SUCCESS!!-----------");
				json.put("status",200);
				json.put("msg","补承保成功");
			}else{
				json.put("status",300);
				json.put("msg","保单号为空或订单不存在");
				log.info("----------平安承保接口调用返回保单号（TYX-PAS-CB）：FAIL!!-----------");
			}
		}catch (Exception e){
			json.put("status",300);
			json.put("msg","补承保过程出现异常："+e);
		}
		response.setHeader("Content-type", "application/json;charset=UTF-8");
		MessageUtils.returnMessage(json.toString(),response);
	}

	@RequestMapping("/pushBLB/{oid}")
	public void pushBLB(@PathVariable long oid) throws Exception{
		policyService.pushBackOrderID(String.valueOf(oid));
	}

	/**
	 * <b> 页面验证码都存redis </b>
	 * @author ZXF
	 * @create 2019/09/05 0005 16:51
	 * @version
	 * @注意事项 </b>
	 */
	public static void setYzm(String code){
		HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
		JedisUtils.set(ConstProp.YZM_EN+IpAddress.getIpAddress(request),code,ConstProp.THREE_MINUTES_TIMEOUT_SECONDS);
		buildCode(code, request);
	}

	/**
	 * 有在用
	 * <b>业务逻辑处理，验证码校验(图片验证码) </b>
	 */
	@RequestMapping("/checkYzm")
	@ResponseBody
	public String checkYzm(@RequestParam String captcha) {
		JSONObject json = new JSONObject();
		String key = ConstProp.YZM_EN+IpAddress.getIpAddress(getRequest());
		String sessionyanz = JedisUtils.get(key);
		//用完销毁
		JedisUtils.del(key);
		if(captcha.equals(sessionyanz)){
			json.put("statusCode",ConstProp.CODE_SUCCESS);
			json.put("message","");
		} else {
			json.put("statusCode",ConstProp.CODE_FAILURE);
			json.put("message","");
		}
		return json.toJSONString();
	}

	/**
	 * <b> 小微电子保单重新获取 </b>
	 * @author ZXF
	 * @create 2018/05/16 0016 9:33
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/dzbd-xw/{oid}")
	@ResponseBody
	public void dzbdXW(@PathVariable Long oid) throws Exception {
		policyService.HTTP_TPC_XYX_DZBD(oid);
	}

	/**
	 * <b> 小微请求承保接口 </b>
	 * @author ZXF
	 * @create 2018/05/16 0016 9:33
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/cb-xw/{oid}")
	@ResponseBody
	public void cbXW(@PathVariable Long oid) throws Exception {
//		policyService.HTTP_TPC_XYX_CB(oid);
	}

	/**
	 * <b> 保单信息推送saas修复保单信息缺失的问题 </b>
	 * @author ZXF
	 * @create 2019/05/28 0028 9:36
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/push-repair-order/{oid}")
	@ResponseBody
	public Result pushRepairOrderInfo(@PathVariable String oid) throws Exception {
		return policyService.pushRepairOrderInfo(oid);
	}

	/**
	 * <b> 缓存清理 </b>
	 * @author ZXF
	 * @create 2019/07/31 0031 17:19
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/del-redis/{key}")
	@ResponseBody
	public Result delRedis(@PathVariable String key) throws Exception{
		JedisUtils.batchDel(key);
		if(key.contains("PRODUCT-PCO")){
			new Thread(()->{
				insProductAPIService.loadDefaultProducts();
			}).start();
		}
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * 获取随机公钥
	 *
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/get/public_key")
	@ResponseBody
	public Result getPublicKey() {
		return Result.success("", generateString(16));
	}

	@RequestMapping(value = "/shop/{orderId}/{type}")
	public Result sendShop(@PathVariable Long orderId,@PathVariable int type) {
		policyService.createSendOrderTask(orderId,type,"");
		return Result.success("");
	}
	@RequestMapping(value = "/push/{orderId}")
	public Result push(@PathVariable String orderId) {
		return Result.success(Result.SUCCESS_MSG,policyService.pushOrderToPSS(orderId));
	}

	@RequestMapping(value = "/createPay/{policyNo}")
	public Result createPay(@PathVariable String policyNo) throws ParseException {
		Date star = DateUtil.convertString2Date(DateUtil.convertDateToString(DateUtil.getFirstDayOfThisMonth(),DateUtil.FORMAT2)+" 00:00:00");
		Date end = DateUtil.convertString2Date(DateUtil.convertDateToString(DateUtil.getLastDayOfThisMonth(),DateUtil.FORMAT2)+" 23:59:59");
		insPreservationPayAPIService.createInsPreservationPayByThisMonth(policyNo,star,end);
		return Result.success(Result.SUCCESS_MSG);
	}

	@RequestMapping(value = "/createBill")
	public Result createBill() {
		insPreservationPayAPIService.findInsPreservationPayByPaymentType("2");
		insPreservationPayAPIService.createInsPreservationBillByThisMonth("2024-05");
		return Result.success(Result.SUCCESS_MSG);
	}

	@RequestMapping(value = "/natureChange")
	@ResponseBody
	public Map<String, String> natureChange(HttpServletRequest request) {
		String nID = request.getParameter("nID");
		if(StringUtils.isNotEmpty(nID)){
			Map<String, String> map = NatureLinkage.getMapByProvince(nID);
			return map;
		}
		return null;
	}

	/**
	 * <b> 固化保障责任补偿 </b>
	 * @author ZXF
	 * @create 2019/07/31 0031 17:19
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/bu-rety/{sign}")
	@ResponseBody
	public Result updateResponsibilityIds(@PathVariable String sign){
		if(!"vfsAW$geg345FAR$RF0E+TG327".equals(sign)){
			return Result.fail("接口已废弃!");
		}
		String productCode = getRequest().getParameter("productCode");
		String orderId = getRequest().getParameter("orderId");
		insAgreementAPIService.updateResponsibilityIds(productCode,orderId);
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * <b> 太保测试模拟支付 </b>
	 * @author ZXF
	 * @create 2025/09/26 0026 13:36
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/tbpay/{sign}/{payno}")
	@ResponseBody
	public String tbpay(@PathVariable String sign,@PathVariable String payno){
		if(!"vfsAWgeg345FAR$RF0ETG327".equals(sign)){
			return "接口已废弃!";
		}
		return HttpUtil.get("https://jttpitxsit.cpic.com.cn/tp/insurance/payService?payApplicationNo="+payno);
	}

	@RequestMapping("/proxyCashierPage")
	public ModelAndView proxyCashierPage(@RequestParam String cashier) {
		ModelAndView view = new ModelAndView("/coninsweb/synopsis/cashierProxy");
		view.addObject("cashierUrl",GlobalResources.WEB_URL+"/synopsis/cashierProxy?cashier="+cashier);
		return view;
	}

	/**
	 * 代理请求第三方收银台页面
	 * @param url 第三方收银台 URL
	 * @param response HttpServletResponse 对象
	 */
	@RequestMapping("/cashierProxy")
	public void cashierProxy(@RequestParam String cashier, HttpServletResponse response) {
		try {
			String url = new String(Base64.getDecoder().decode(cashier));
			// 发起 HTTP GET 请求获取第三方页面内容
			URL cashierUrl = new URL(url);
			HttpURLConnection connection = (HttpURLConnection) cashierUrl.openConnection();
			connection.setRequestMethod("GET");
			connection.connect();

			// 读取响应内容
			InputStream inputStream = connection.getInputStream();
			BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
			StringBuilder content = new StringBuilder();
			String line;
			while ((line = reader.readLine()) != null) {
				content.append(line).append("\n");
			}
			reader.close();
			inputStream.close();

			// 设置响应头和编码
			response.setContentType("text/html;charset=UTF-8");
			response.getWriter().write(content.toString());
		} catch (Exception e) {
			e.printStackTrace();
			try {
				response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "获取收银台页面失败");
			} catch (IOException ioException) {
				ioException.printStackTrace();
			}
		}
	}

	public static void main(String[] args) {
		String url="https://mpaysit.cpic.com.cn/mpayweb/payWebPc?a3e178015a35821990d54b8a9d2779d3a5f28abfb60d004c0ae4cdc3aefacfe38f50d965d9ab55385aa47e40f6de72d1c3e2af90e11aaee8870213cdc3510edf95a8f75d4c8faa12ff2852061474f6724644350365b75ac12dedeeea40cf5f833bd8e9fa99bd0ab2be8cef8cbeaa5724c925e5da47530500395a7b7a55fce6baad5b6535867f18803806b721c31edac55319a20c63daabdfd6a66d202315181d3ffe1b6080b0a0bb47bbc5098c222d360fa115d7a46c6d31dcc49cd77ded53859002f48163d9cafd0fdd84104e0125e20421c48cbe2195cc7d048eee45e26d52e0d349b3cc204f0c60c92c007dae10fe948f193b1b7be937e0773bf5801121869ece54c591aa7291c90bb4b9c1bfa1e89d38f8c9acc9dc8c1912ddd4457e7ea4d0e81effbfed6a18c0064cef3fc5b474b89099023bac3a62628137c40698fa0a9da22268d60ef4d609050cba4b23ae95";
		String a = Base64.getEncoder().encodeToString(url.getBytes());
		String b = new String(Base64.getDecoder().decode(a));
		System.out.println(a);
		System.out.println(b);
		System.out.println(url.equals(b));
	}

	/**
	 * 返回一个定长的随机字符串(只包含大小写字母、数字)
	 *
	 * @param length 随机字符串长度
	 * @return 随机字符串
	 */
	public static String generateString(int length) {
		String ALLCHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		StringBuffer sb = new StringBuffer();
		Random random = new Random();
		for (int i = 0; i < length; i++) {
			sb.append(ALLCHAR.charAt(random.nextInt(ALLCHAR.length())));
		}
		return sb.toString();
	}

//	@RequestMapping("/rrweb-save")
//	@ResponseBody
//	public void rrweb_save(String token,String motion) throws UnsupportedEncodingException {
//		System.out.println(motion);
//		FileHelp.byteFile(motion.getBytes("UTF-8"),"D:\\ase\\","0525.txt");
//	}
//	@RequestMapping("/rrweb-player")
//	@ResponseBody
//	public String rrweb_player() {
//		File file = new File("D:\\ase\\0525.txt");
//		StringBuffer sbf = new StringBuffer();
//		try(BufferedReader reader = new BufferedReader(new FileReader(file));) {
//			String tempStr;
//			while ((tempStr = reader.readLine()) != null) {
//				tempStr = java.net.URLDecoder.decode(tempStr, "UTF-8");
//				tempStr = tempStr.replaceAll("content: .*?;;","content: '';");
//				if(sbf.length()>0){
//					tempStr = ","+tempStr.substring(1,tempStr.length());
//					tempStr = tempStr.substring(0,tempStr.length()-1);
//				}else{
//					tempStr = tempStr.substring(0,tempStr.length()-1);
//				}
//				sbf.append(tempStr);
//			}
//			sbf.append("]");
//			return sbf.toString();
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
//		return sbf.toString();
//	}
}
