package com.bcxin.ins.aspect;

import com.bcxin.ins.service.order.ComTaskResidualAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.core.entity.SysLog;
import com.bcxin.ins.core.service.SysLogService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.ConstProp;
import com.xiaoleilu.hutool.date.DateField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.Date;

@Service
public class SchedulingService {
	
	private  static Logger logger = LoggerFactory.getLogger(SchedulingService.class);

	@Autowired
	SysLogService logS;

	@Autowired
	private PolicyService policyService;

	@Autowired
	private InsPreservationPayAPIService insPreservationPayAPIService;

	@Autowired
	private InsPreservationRecordAPIService insPreservationRecordAPIService;
	@Autowired
	private InsPreservationResultSetAPIService insPreservationResultSetAPIService;
	@Autowired
	private ComTaskResidualAPIService comTaskResidualAPIService;

	public void test(){
		System.out.println("------------定时任务开始--------------");
	}

	public void Policy_overdue() throws ParseException { //改待支付保单为已过期
		try{
			policyService.findPolicyListByLapsed();
			logS.save(getLog(null,"1","【定时任务】改待支付保单为已过期"));
		}catch (Exception ex){
			logger.error("",ex);
			logS.save(getLog(ex,"2","【定时任务】改待支付保单为已过期"));
		}
	}

	public void policyEndStatus() throws ParseException{ //对接太保：接口107002，通过投保单号查找保单号设置保单状态
		try {
			policyService.policyEndStatus("");
			logS.save(getLog(null,"1","【定时任务】对接太保：接口107002，通过投保单号查找保单号设置保单状态"));
		}catch (Exception ex){
			logger.error("【定时任务】policyEndStatus",ex);
			logS.save(getLog(ex,"2","【定时任务】对接太保：接口107002，通过投保单号查找保单号设置保单状态"));
		}
	}

	public void policyExpireInform() throws ParseException {
		try{
			policyService.policyExpireInform();
			logS.save(getLog(null,"1","定时任务-检索即将到期或已到期保单发送邮件"));
		}catch (Exception ex){
			logger.error("",ex);
			logS.save(getLog(ex,"2","定时任务-检索即将到期或已到期保单发送邮件"));
		}
	}

	public void closeCopyCount(){ //清除每天订单复制次数缓存
		JedisUtils.batchDel(ConstProp.REDIS_HEAD_CPOY);
	}

	public void TYX_TK_02() throws ParseException{ //团意险查询待支付订单列表调泰康02查询保单接口获取保单号并保存（批量处理）
	    try {
	    	policyService.TYX_TK_02();
			logS.save(getLog(null,"1","【定时任务】团意险查询待支付订单列表调泰康02查询保单接口获取保单号并保存"));
		}catch (Exception ex){
			logger.error("【定时任务】TYX_TK_02",ex);
			logS.save(getLog(ex,"2","【定时任务】团意险查询待支付订单列表调泰康02查询保单接口获取保单号并保存"));
		}
	}

	public void XYX_TB_CB() throws ParseException{ //小微信用险查询待承保订单列表调太保承保接口获取保单号并保存
	    try {
	    	policyService.XYX_TB_CB();
			logS.save(getLog(null,"1","【定时任务】小微信用险查询待承保订单列表调太保承保接口获取保单号并保存"));
		}catch (Exception ex){
			logger.error("【定时任务】XYX_TB_CB",ex);
			logS.save(getLog(ex,"2","【定时任务】小微信用险查询待承保订单列表调太保承保接口获取保单号并保存"));
		}
	}

	/**
	 * 定时次月第一天的00:00点查询暂存状态的保全缴费单列表并重置状态为待处理
	 * @throws ParseException
	 */
	public void activateInsPreservationPay_month(){
	    try {
			insPreservationPayAPIService.findInsPreservationPayByPaymentType("2");
			logS.save(getLog(null,"1","【定时任务】次月第一天的00:00点查询暂存状态的保全缴费单列表并重置状态为待处理"));
		}catch (Exception ex){
			logger.error("【定时任务】activateInsPreservationPay_month",ex);
			logS.save(getLog(ex,"2","【定时任务】次月第一天的00:00点查询暂存状态的保全缴费单列表并重置状态为待处理"));
		}
	}

	/**
	 * 定时次季度第一天的00:20点查询暂存状态的保全缴费单列表并重置状态为待处理
	 * @throws ParseException
	 */
	public void activateInsPreservationPay_quarter(){
	    try {
			insPreservationPayAPIService.findInsPreservationPayByPaymentType("3");
			logS.save(getLog(null,"1","【定时任务】次季度第一天的00:20点查询暂存状态的保全缴费单列表并重置状态为待处理"));
		}catch (Exception ex){
			logger.error("【定时任务】activateInsPreservationPay_quarter",ex);
			logS.save(getLog(ex,"2","【定时任务】次季度第一天的00:20点查询暂存状态的保全缴费单列表并重置状态为待处理"));
		}
	}

	/**
	 * 定时次半年第一天的00:40点查询暂存状态的保全缴费单列表并重置状态为待处理
	 * @throws ParseException
	 */
	public void activateInsPreservationPay_semester(){
		try {
			insPreservationPayAPIService.findInsPreservationPayByPaymentType("4");
			logS.save(getLog(null,"1","【定时任务】次半年第一天的00:40点查询暂存状态的保全缴费单列表并重置状态为待处理"));
		}catch (Exception ex){
			logger.error("【定时任务】activateInsPreservationPay_semester",ex);
			logS.save(getLog(ex,"2","【定时任务】次半年第一天的00:40点查询暂存状态的保全缴费单列表并重置状态为待处理"));
		}
	}

	/**
	 * 定时次年第一天的01:00点查询暂存状态的保全缴费单列表并重置状态为待处理
	 * @throws ParseException
	 */
	public void activateInsPreservationPay_year(){
		try {
			insPreservationPayAPIService.findInsPreservationPayByPaymentType("5");
			logS.save(getLog(null,"1","【定时任务】次年第一天的01:00点查询暂存状态的保全缴费单列表并重置状态为待处理"));
		}catch (Exception ex){
			logger.error("【定时任务】activateInsPreservationPay_month",ex);
			logS.save(getLog(ex,"2","【定时任务】次年第一天的01:00点查询暂存状态的保全缴费单列表并重置状态为待处理"));
		}
	}

	/**
	 * 每天定时跑保全申请单中已审核的单子如果生效日期小于当前日期就变更状态为已生效
	 * @throws ParseException
	 */
	public void setInsPreservationRecordStatus(){
		try {
			insPreservationRecordAPIService.setInsPreservationRecordStatus();
			logS.save(getLog(null,"1","【定时任务】每天定时跑保全申请单中已审核的单子如果生效日期小于当前日期就变更状态为已生效"));
		}catch (Exception ex){
			logger.error("【定时任务】setInsPreservationRecordStatus",ex);
			logS.save(getLog(ex,"2","【定时任务】每天定时跑保全申请单中已审核的单子如果生效日期小于当前日期就变更状态为已生效"));
		}
	}

	/**
	 * 每天定时捞结算日期大于昨天的保全记录推送商城
	 * @throws ParseException
	 */
	public void pushRecordToShop(){
		try {
			insPreservationRecordAPIService.pushRecordToShop();
			logS.save(getLog(null,"1","【定时任务】每天定时捞结算日期大于昨天的保全记录推送商城"));
		}catch (Exception ex){
			logger.error("【定时任务】pushRecordToShop",ex);
			logS.save(getLog(ex,"2","【定时任务】每天定时捞结算日期大于昨天的保全记录推送商城"));
		}
	}

	/**
	 * 一些第三方推送接口执行不成功或者有需要进行推送任务记录到表中，通过定时器半小时跑一次，进行遗留历史任务重复推送
	 * @throws ParseException
	 */
	public void disposeComTaskResidual(){
		try {
			comTaskResidualAPIService.disposeComTaskResidualList("");
			logS.save(getLog(null,"1","【定时任务】查询表记录通过各属性反射出对应方法并执行"));
		}catch (Exception ex){
			logger.error("【定时任务】disposeComTaskResidual",ex);
			logS.save(getLog(ex,"2","【定时任务】查询表记录通过各属性反射出对应方法并执行"));
		}
	}

	public void disposeComTaskResidual2() throws ParseException {
		try {
			comTaskResidualAPIService.disposeComTaskResidualList("1");
			logS.save(getLog(null,"1","定时任务-查询表记录通过各属性反射出对应方法并执行(夜间执行)"));
		}catch (Exception ex){
			logger.error("定时任务-disposeComTaskResidual2",ex);
			logS.save(getLog(ex,"2","定时任务-查询表记录通过各属性反射出对应方法并执行(夜间执行)"));
		}
	}

	public void gainDZBDByTiming() throws ParseException { //查询已承保但未获取电子保单的订单，定时跑接口查询
		try{
			policyService.gainDZBDByTiming();
			logS.save(getLog(null,"1","【定时任务】查询已承保但未获取电子保单的订单"));
		}catch (Exception ex){
			logger.error("",ex);
			logS.save(getLog(ex,"2","【定时任务】查询已承保但未获取电子保单的订单"));
		}
	}

	public void initAllOrderToResultSet() throws ParseException { //初始化有效订单的保全结果集（复制在保人员信息到结果集表）
		try{
			String[] arr = {ConstProp.TYX, ConstProp.GZZRX};
			for (int i = 0; i < arr.length; i++) {
				insPreservationResultSetAPIService.initAllOrderToResultSet(arr[i]);
			}
			logS.save(getLog(null,"1","【定时任务】初始化有效订单的保全结果集（复制在保人员信息到结果集表）"));
		}catch (Exception ex){
			logger.error("",ex);
			logS.save(getLog(ex,"2","【定时任务】初始化有效订单的保全结果集（复制在保人员信息到结果集表）"));
		}
	}

	public void initInsPreservationBillThisMonth(){
		try {
			// 当前日期
			Date currentDate = new Date();
			// 上个月的日期
			Date lastMonthDate = com.xiaoleilu.hutool.date.DateUtil.offset(currentDate, DateField.MONTH, -1);
			String lastMonth = DateUtil.formatDate(lastMonthDate,"yyyy-MM");
			insPreservationPayAPIService.createInsPreservationBillByThisMonth(lastMonth);
			logS.save(getLog(null,"1","定时任务-次月第二天的00:00点生成每月汇总分组账单，并对归属账单做标记（设置上级账单）"));
		}catch (Exception ex){
			logger.error("定时任务-initInsPreservationBillThisMonth",ex);
			logS.save(getLog(ex,"2","定时任务-次月第二天的00:00点生成每月汇总分组账单，并对归属账单做标记（设置上级账单）"));
		}
	}

	public void initInsPreservationPayThisMonth(){
		try {
			Date star = DateUtil.convertString2Date(DateUtil.convertDateToString(DateUtil.getFirstDayOfThisMonth(),DateUtil.FORMAT2)+" 00:00:00");
			Date end = DateUtil.convertString2Date(DateUtil.convertDateToString(DateUtil.getLastDayOfThisMonth(),DateUtil.FORMAT2)+" 23:59:59");
			insPreservationPayAPIService.createInsPreservationPayByThisMonth("",star,end);
			logS.save(getLog(null,"1","定时任务-次月第一天的00:10点生成保单初始月结账单记录"));
		}catch (Exception ex){
			logger.error("定时任务-initInsPreservationPayThisMonth",ex);
			logS.save(getLog(ex,"2","定时任务-次月第一天的00:10点生成保单初始月结账单记录"));
		}
	}

	private SysLog getLog(Exception ex,String type,String title) {
		SysLog sysLog = new SysLog();
		sysLog.setCreateTime(new Date());
		if (ex != null){
			sysLog.setException(ex.toString());
		}
		sysLog.setType(type);
		sysLog.setTitle(title);
		return sysLog;
	}
}
