package com.bcxin.ins.third.zzx.pingancai;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Map;


/**
 *
 * <b>平安财-展责险http接口请求业务</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Service("zZX_PACRequestService")
@Transactional
public class ZZX_PACRequestService {

	private Logger communicatorLog =  LoggerFactory.getLogger(ZZX_PACRequestService.class);

	@Autowired
	private PolicyService policyService;
	@Autowired
	private LogBusinessrequestService logBusinessrequestService;


	/**
	 * 平安请求方法
	 * 
	 * @return
	 */
	public String requestPAC(Long order_id, String transType, Map<String,String> map) throws Exception {
		communicatorLog.info("requestPAC-ZZX：star-----------------------");
		communicatorLog.info("requestPAC-ZZX：接口编码-"+transType+",订单id-"+order_id+",MAP-"+(map != null ? map.toString() : "null"));
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		LOTEPolicyVo vo = policyService.accordingToOrderIDToGetLOTEPolicyVo(Long.parseLong(dto.getOid()));
		String result = "300#（APP-PAC-ZZX-001）网络不稳定，请重新请求！";
		LogBusinessrequest lb = null;
		try {
			String json = ZZX_PackageMessagePingAnCai.marshal(vo, dto, transType, map);
			communicatorLog.info("请求报文："+json);
			String url = GlobalResources.PN_INS_URL + "/open/"+getUrlByTransType(transType)+"?access_token="+policyService.pnc_access_token();
			communicatorLog.info("请求地址："+url);
			Date bTime = new Date();
			String ret = RequestUtil.initHttp().doPostByAccept(url, json, "application/json", "UTF-8");
			lb = logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id),transType,url,json,ret,bTime,new Date(), TransTypeEnum.getAlias(transType));
			communicatorLog.info("返回报文："+ret);
			result = ZZX_PackageMessagePingAnCai.returnAnalysisJson(ret,transType);
			communicatorLog.info("返回报文处理："+result);
			logBusinessrequestService.supplementDecAndSave(lb,result.startsWith(ConstProp.CODE_FAILURE)?1:0,ConstProp.BLANK_CHAR);
		}catch (Exception ex){
			logBusinessrequestService.supplementDecAndSave(lb,2,ex.getMessage());
			ex.printStackTrace();
		}
		communicatorLog.info("requestPAC-ZZX：end-----------------------");
		return result;
	}

	/**
	 * 请求不同类型的接口相应访问地址也不同
	 * @param type
	 * @return
	 */
	private static String getUrlByTransType(String type){
		if("1".equals(type)){//核保
			return "/appsvr/property/standardGroupPropertyFeeApply";
		}else if("2".equals(type)){//承保
			return "/appsvr/property/standardGroupPropertyFeeAccept";
		}else if("3".equals(type)){//电子保单打印
//			return "/do/app/public/standardEntry";
			return "/appsvr/property/ePasElectronicPolicy";
		}
		return "";
	}

}
