package com.bcxin.ins.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.core.util.JwtUtil;
import com.bcxin.ins.core.util.TokenUtils;
import com.bcxin.ins.entity.policy_special.*;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.common.ComAreaCodeAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.*;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.common.ComAreaCode;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.entity.policy_core.*;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.third.build.dubang.Build_DBRequestService;
import com.bcxin.ins.third.build.taibao.CommunicateType;
import com.bcxin.ins.third.build.taibao.Communicator;
import com.bcxin.ins.third.build.taibao.TransType;
import com.bcxin.ins.third.build.yangguang.YGGCService;
import com.bcxin.ins.third.build.yangguang.yggc.BDYGGC;
import com.bcxin.ins.third.gyx.changan.GYX_CARequestService;
import com.bcxin.ins.third.gzx.changan.GZX_CARequestService;
import com.bcxin.ins.third.gzx.huatai.HtPolicyService;
import com.bcxin.ins.third.gzx.huatai.HttpUtil;
import com.bcxin.ins.third.gzx.pingancai.GZX_PACRequestService;
import com.bcxin.ins.third.gzzrx.changan.GZZRX_CARequestService;
import com.bcxin.ins.third.gzzrx.pingancai.GZZRX_PACRequestService;
import com.bcxin.ins.third.gzzrx.renbao.GZZRX_RBRequestService;
import com.bcxin.ins.third.tyx.changan.TYX_CARequestService;
import com.bcxin.ins.third.tyx.pingan.PARequestService;
import com.bcxin.ins.third.tyx.pingancai.PACRequestService;
import com.bcxin.ins.third.tyx.taikang.TKRequestService;
import com.bcxin.ins.third.xyx.taibao.XYX_TBRequestService;
import com.bcxin.ins.third.zzx.changan.ZZX_CARequestService;
import com.bcxin.ins.third.zzx.pingancai.ZZX_PACRequestService;
import com.bcxin.ins.third.zzx.zhongan.ZARequestService;
import com.bcxin.ins.third.zzx.zhongan.dto.CashierConstant;
import com.bcxin.ins.util.*;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.EmailMsgRecordType;
import com.bcxin.ins.util.email.EmailMsgType;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.utils.ThirdUrlConst;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.ins.vo.shop.ImportInsuranceOrderRequest;
import com.bcxin.ins.vo.shop.InsuranceOrderRequest;
import com.bcxin.ins.vo.shop.ShopResult;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pingan.iobs.sdk.repkg.com.google.gson.Gson;
import com.xiaoleilu.hutool.http.HttpRequest;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.net.URI;
import java.text.ParseException;
import java.util.*;



/**
 * <b>订单相关业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class PolicyServiceImpl implements PolicyService {

	private Logger log =  LoggerFactory.getLogger(PolicyServiceImpl.class);

	@Autowired
	private HtPolicyService htPolicyService;
	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipService;
	@Autowired
	private InsAgreementAPIService insAgreementAPIService;
	@Autowired
	private InsTransactionAPIService insTransactionService;
	@Autowired
	private ClientUserService clientUserService;
	@Autowired
	private TKRequestService tKRequestService;
	@Autowired
	private PARequestService pARequestService;
	@Autowired
	private ZARequestService zARequestService;
	@Autowired
	private ZZX_PACRequestService zZX_PACRequestService;
	@Autowired
	private GZX_PACRequestService gZX_PACRequestService;
	@Autowired
	private GZX_CARequestService gZX_CARequestService;
	@Autowired
	private ZZX_CARequestService zZX_CARequestService;
	@Autowired
	private ComAreaCodeAPIService comAreaCodeAPIService;
	@Autowired
	private InsPreservationRecordAPIService insPreservationRecordAPIService;
	@Autowired
	private InsPreservationPayAPIService insPreservationPayAPIService;
	@Autowired
	private ProductService productService;
	@Autowired
	private SpecialPublicDutyAPIService specialPublicDutyAPIService;
	@Autowired
	private Build_DBRequestService build_DBRequestService;
	@Autowired
	private ComDeployConfigService comDeployConfigService;
	@Autowired
	private InsMicroExportAPIService insMicroExportService;
	@Autowired
	private InsRoleInpolicyAPIService insRoleInpolicyService;
	@Autowired
	private InsCommonExportAPIService insCommonExportService;
	@Autowired
	private SpecialBidAPIService insSpecialBidService;
	@Autowired
	private SpecialExhibitionAPIService specialExhibitionAPIService;
	@Autowired
	private SpecialPerformanceAPIService insSpecialPerformanceService;
	@Autowired
	private InsMailPolicyAPIService insMailPolicyService;
	@Autowired
	private InsUnderwriteAPIService insUnderwriteAPIService;
	@Autowired
	private SpecialLitigationAPIService specialLitigationService;
	@Autowired
	private SpecialPublicDutyAPIService specialPublicDutyService;
	@Autowired
	private LnAccusedAPIService lnAccusedAPIService;
	@Autowired
	private InsProductResponsibilityAPIService insProductResponsibilityAPIService;
	@Autowired
	private ComTaskResidualAPIService comTaskResidualAPIService;
	@Autowired
	private XYX_TBRequestService xYX_TBRequestService;
	@Autowired
	private PACRequestService pACRequestService;
	@Autowired
	private HirelingAPIService hirelingAPIService;
	@Autowired
	private YGGCService yGGCService;
	@Autowired
	private GZZRX_RBRequestService gZZRX_RBRequestService;
	@Autowired
	private GZZRX_PACRequestService gZZRX_PACRequestService;
	@Autowired
	private GZZRX_CARequestService gZZRX_CARequestService;
	@Autowired
	private TYX_CARequestService tYX_CARequestService;
	@Autowired
	private GYX_CARequestService gYX_CARequestService;
	@Autowired
	private InsPreservationResultSetAPIService insPreservationResultSetAPIService;

	@Override
	public String getRecommendCodeByCookie(HttpServletRequest request){
		Cookie[] cookies = request.getCookies();//这样便可以获取一个cookie数组
		String result = ConstProp.BLANK_CHAR;
		if(cookies.length<=ConstProp.INT_NUMBER_ZERO){
			return result;
		}
		for(Cookie cookie : cookies){
			if ( ConstProp.RECOMMENDCODE.equals(cookie.getName()) ) {
				result = cookie.getValue();
				break;
			}
		}
		return result;
	}

	/**
	 * <b>根据产品和当前用户去后台创建订单，返回订单id </b>
	 *
	 * @param product_id
	 * @param user_id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> createOrderFormByProductOid(Long product_id, Long user_id, String recommendCode,String trade_serial_number) {
		Map<String,Object> map = new HashMap<String,Object>();
		if(StrUtil.isNotBlank(String.valueOf(product_id))&&StrUtil.isNotBlank(String.valueOf(user_id))){
			InsInsuranceSlip order = insInsuranceSlipService.initOrderForm(product_id, user_id, recommendCode,trade_serial_number);
			map.put(ConstProp.ORDER_ID, String.valueOf(order.getIns_insurance_slip_id()));
		}else{
			map = null;
		}
		return map;
	}

	/**
	 * <b>根据订单id获取投保单信息PolicyDto </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderFormVo accordingToOrderIDToGetPolicyDto(Long order_id) {
		OrderFormVo vo = null;
		if(StrUtil.isNotBlank(String.valueOf(order_id))){
			vo = insInsuranceSlipService.findOrderFormVoByID(order_id);
		}
		return vo;
	}

	/**
	 * <b>根据订单id获取第三方下单企业用户id </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String getTPUserIDByOrderID(Long order_id) {//TODO 可以优化成一个查询
		OrderFormVo vo = null;
		String result = ConstProp.BLANK_CHAR;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return result;
		}
		InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
		if(order != null){
			SysClientUser user = clientUserService.selectById(order.getRegister_user_id());
			if(user != null){
				result = user.getWeb_id()+ConstProp.SEMICOLON+user.getWeb_type();
			}
		}
		return result;
	}

	/**
	 * <b>根据订单id获取付款通知书界面元素辅助表信息AdviceNoteVo </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public AdviceNoteVo accordingToOrderIDToGetAdviceNoteVo(Long order_id) {
		AdviceNoteVo vo = null;
		if(StrUtil.isNotBlank(String.valueOf(order_id))){
			InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
			vo = insInsuranceSlipService.willInsOrderFormSetUpAdviceNoteVo(order);
		}
		return vo;
	}


	/**
	 * <b>接收MicroExportVo进行设置更新数据插入相关表 </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainMicroExportVoSetUp(MicroExportVo vo) {
		Map<String,Object> map = new HashMap<String,Object>();
		if(StrUtil.isBlank(vo.getOid())){
			return null;
		}
		try {
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			if(StringUtils.isNotEmpty(vo.getRecommend_code())){
				insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
			}
			insInsuranceSlip.setPremium(new BigDecimal(vo.getGross_premium()));
			insInsuranceSlip.setInsured_amount(new BigDecimal(vo.getInsured_amount()));
			if(StringUtils.isNotEmpty(vo.getInception_date())){
				insInsuranceSlip.setInception_date(com.bcxin.ins.util.DateUtil.convertStringToDate(vo.getInception_date()+ConstProp.DAY_00));
			}
			if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
				insInsuranceSlip.setPlanned_end_date(com.bcxin.ins.util.DateUtil.convertStringToDate(vo.getPlanned_end_date() + ConstProp.DAY_23));
			}
			insInsuranceSlipService.updateById(insInsuranceSlip);
			vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
			vo.setOrder_status(insInsuranceSlip.getOrder_status());
			insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
			insMicroExportService.accordingToTheMicroExportVoSetUpInsMicroExport(vo, insInsuranceSlip.getSpecial_id());
			insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		}catch (Exception ex){
			ex.printStackTrace();
		}
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	@Override
	public ResultDto pendingMicroExportPolicy(MicroExportVo vo, String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if (  userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = obtainMicroExportVoSetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	private String getOidByCreatePolicy(String product_id, String user_id, String recommendCode,String trade_serial_number){
		String result = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(product_id)){
			result = createOrderAndGetOrderIDByProductID(Long.parseLong(product_id),Long.parseLong(user_id),recommendCode,trade_serial_number);
		}
		return result;
	}

	/**
	 * <b>根据订单id获取投保单信息MicroExportVo </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public MicroExportVo accordingToOrderIDToGetMicroExportVo(Long order_id) {
		MicroExportVo vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new MicroExportVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		if(insInsuranceSlip.getPremium() != null){
			vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
		}
		if(insInsuranceSlip.getInsured_amount() != null){
			vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
		}
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		if(insInsuranceSlip.getPlanned_end_date() != null){
			vo.setPlanned_end_date(DateUtil.convertDateToString(insInsuranceSlip.getPlanned_end_date(),DateUtil.FORMAT2));
		}
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		insMicroExportService.getMicroExportVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}

	/**
	 * <b>根据用户查询不同状态的保单数返回map </b>
	 *
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, String> findTotalPolicyNum(InsOrderSearchVo searchVo) {
		OrderStatusCountVo vo = null;
		Map<String,String> mapSum = null;
		if(searchVo.getUserId() == null){
			return mapSum;
		}
		mapSum = new HashMap<String,String>();
		vo = insInsuranceSlipService.selectOrderStatusCountVoByUserID(searchVo);
		if(vo != null){
			try {
				mapSum = MyConverUtil.PO2Map(vo);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return mapSum;
	}

	/**
	 * <b>根据用户名及保单状态查询保单信息列表封装到PolicyDto，用于用户个人中心订单列表展示 </b>
	 *
	 * @param user 用户
	 * @param policyStatus 保单状态
	 * @param page 分页
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<OrderFormVo> findPolicyForPage(InsOrderSearchVo search){
		List<OrderFormVo> pdList = null;
		if(StrUtil.isBlank(search.getPolicyStatus())||search.getUserId() == null){
			return pdList;
		}
		pdList = insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(search);
		return pdList;
	}

	/**
	 * <b>根据保单号跟被保险人名称查询订单 </b>
	 *
	 * @param externalRefernce 保单号
	 * @param roleName 被保险人名称
	 * @author ZXF
	 * @date 2017年04月13日 上午16:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderFormVo findPolicyByExternalAndRoleName(String externalRefernce, String roleName){
		OrderFormVo dto = null;
		if(StrUtil.isNotBlank(externalRefernce)&&StrUtil.isNotBlank(roleName) ){
			dto = insInsuranceSlipService.findPolicyByExternalAndRoleName(externalRefernce, roleName);
		}
		return dto;
	}

	/**
	 * <b>根据订单id获取投保单信息MicroExportVo </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String updateOrderFormStatus(OrderFormVo vo) {
		String order_id = ConstProp.BLANK_CHAR;
		try {
			if(vo== null||StrUtil.isBlank(vo.getOid())){
				return order_id;
			}
			insInsuranceSlipService.updateOrderFormStatus(vo);
			if(DictConst.ORDER_STATUS_DSH.equals(vo.getPolicy_status())){
				InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
				insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
				//如果订单将变更为待核保状态，创建 国家分类承保条件表数据
				insInsuranceSlipService.accordingToInsTopBuyersListGainInsRiskDuty(Long.parseLong(vo.getOid()));
			}
			if(DictConst.ORDER_STATUS_YCB.equals(vo.getPolicy_status())){
				/*ThreadUtil.excAsync(()->{
					//每次有新保单触发生成保单当月初始月结账单记录(针对雇主险、团意险产品的保单)
					insPreservationPayAPIService.createInsPreservationPayByThisMonth();
				},false);*/
				new Thread(()->{
					if("1".equals(GlobalResources.map.get("IS_SEND_SHOP"))){
						//添加推送批单信息给到商城
						comTaskResidualAPIService.saveComTaskResidual("createSendOrderTask","保险订单推送商城初始化","com.bcxin.ins.service.order.PolicyService",3,"Long,int,String", vo.getOid()+",2,");
					}
				}).start();
				orderSyncZC(vo.getOid());
				//判断是否发送纸质保单、纸质发票的邮件通知客服和保险公司负责人
				ThreadUtil.excAsync(()->{
					sendZZPolicyEmail(vo.getOid());
				},false);
			}
			if(DictConst.ORDER_STATUS_YSH.equals(vo.getPolicy_status())||DictConst.ORDER_STATUS_DZF.equals(vo.getPolicy_status())||DictConst.ORDER_STATUS_HZF.equals(vo.getPolicy_status())){
				//客户下单到已核保、待支付、承保后支付状态时邮件通知客服人员
				ThreadUtil.excAsync(()->{
					sendInsureEmail(vo.getOid());
				},false);
			}
			order_id = vo.getOid();
		}catch (Exception e){
			log.error("订单状态更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return order_id;
	}

	/**
	 * <b>根据订单id获取投保单信息MicroExportVo </b>
	 *
	 * @param request
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public ResultDto updateOrderFormStatusByRequest(HttpServletRequest request) {
		String order_id = request.getParameter(ConstProp.ORDER_ID);
		String status = request.getParameter("status");
		if(StringUtils.isEmpty(order_id) || StringUtils.isEmpty(status)){
			return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		OrderFormVo vo = new OrderFormVo();
		vo.setOid(String.valueOf(order_id));
		vo.setPolicy_status(status);
		try {
			insInsuranceSlipService.updateOrderFormStatus(vo);
			if(DictConst.ORDER_STATUS_DSH.equals(vo.getPolicy_status())){
				InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
				insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
				//如果订单将变更为待核保状态，创建 国家分类承保条件表数据
				insInsuranceSlipService.accordingToInsTopBuyersListGainInsRiskDuty(Long.parseLong(vo.getOid()));
			}
			if(DictConst.ORDER_STATUS_YCB.equals(vo.getPolicy_status())){
				orderSyncZC(vo.getOid());
			}
			return new ResultDto("订单录入成功。", ConstProp.CODE_SUCCESS, order_id, ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR);
		}catch (Exception e){
			log.error("订单状态更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("错误异常："+e.getMessage(), ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b> 判断是否发送纸质保单、纸质发票的邮件通知 </b>
	 * @author ZXF
	 * @create 2019/12/16 0016 15:55
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void sendZZPolicyEmail(String order_id){
		ThreadUtil.sleep(2*60*1000);
		InsMailPolicy insMailPolicy = insMailPolicyService.getInsMailPolicyByOrderId(Long.parseLong(order_id));
		if(insMailPolicy == null){
			return;
		}
		OrderFormVo vo = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		String content = htmlContentByZZPolicyEmail(vo,insMailPolicy);
		if(StringUtils.isNotEmpty(content)){
			String pcode = StringUtils.isNotEmpty(vo.getProduct_code())&&vo.getProduct_code().contains("PAC")?vo.getProduct_code():"";
			sendMsgEmail("TBFP_EMAIL",pcode,content,"保单、发票寄送通知");
		}
	}

	/**
	 * <b> 客户下单到已核保、待支付、承保后支付状态时邮件通知客服人员 </b>
	 * @author ZXF
	 * @create 2019/12/16 0016 15:55
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void sendInsureEmail(String order_id){
		OrderFormVo vo = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		if(vo == null){
			return;
		}
		String content = htmlContentByInsureEmail(vo);
		if(StringUtils.isNotEmpty(content)){
			sendMsgEmail("exmail",ConstProp.BLANK_CHAR,content,"客户下单通知");
		}
	}

	public void sendMsgEmail(String emailType, String product_code, String htmlContent, String title ) {
		log.info("邮件发送（内容htmlContent）:"+htmlContent);
		//exmail格式：123@qq.com;333@qq.com:GZZRX-RB;413@qq.com:GZZRX-ZH
		String[] arrs = comDeployConfigService.getValueByKey(emailType).split(ConstProp.SEMICOLON);
		EmailModel emailModel = new EmailModel(title, htmlContent);
		List<String> emailList = new ArrayList<String>();
		String em;
		for(int i=0;i<arrs.length;i++){
			if(StringUtils.isEmpty(arrs[i])){
				continue;
			}
			em = ConstProp.BLANK_CHAR;
			//邮箱加产品代码 3804@qq.com:GZZRX-ZH
			if(arrs[i].contains(ConstProp.COLON)){
				String[] sigs = arrs[i].split(ConstProp.COLON);
				if(StringUtils.isNotEmpty(product_code) && product_code.contains(sigs[1])){
					em = sigs[0].trim();
				}
			}else{
				em = arrs[i].trim();
			}
			if(StringUtils.isNotEmpty(em)){
				emailList.add(em); // 发送地址
				log.info("邮件发送（收件人Email-"+(i+1)+"）:"+em);
			}
		}
		if(emailList.size()>0){
			emailModel.setTo(emailList);
			SendEmailAndMsgUtil.sendEmail(emailModel);
		}
	}

	private String htmlContentByZZPolicyEmail(OrderFormVo orderVo,InsMailPolicy insMailPolicy){
		StringBuffer htmlContent= new StringBuffer();
		try {
			if(orderVo == null){
				return ConstProp.BLANK_CHAR;
			}
			if(insMailPolicy.getNeed_insur_bill() == 0 && insMailPolicy.getNeed_receipt() == 0){
				return ConstProp.BLANK_CHAR;
			}
			htmlContent.append("<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>纸质保单、发票寄送信息</title><style type=\"text/css\">.wrap{width:500px;margin:30px auto}.wrap h1{text-align:center}.shenqing-con p strong,.shenqing-con p span{display:block;font-size:14px;line-height:24px}.shenqing-con p strong{float:left;margin-right:8px}.shenqing-con div{float:left}.shenqing-con p.mg-r{width:200px;margin-left:78px}table{width:680px}table th,table td{padding:5px}</style></head><body><div class=\"wrap\"><h1>纸质保单、发票寄送信息</h1><div class=\"shenqing-con\">");
			htmlContent.append("<p><strong>订单号：</strong><span>"+orderVo.getTrade_serial_number()+"</span></p>");
			htmlContent.append("<p><strong>保险公司：</strong><span>"+orderVo.getInsurance_name()+"</span></p>" +
					"<p><strong>保单号：</strong><span>"+orderVo.getExternal_reference()+"</span></p>" +
					"<p><strong>投保时间：</strong><span>"+orderVo.getStart_time()+"</span></p>" +
					"<p><strong>投保人：</strong><span>"+orderVo.getApplicant_name()+"</span></p>" +
					"<p><strong>保险产品：</strong><span>[产品名称："+orderVo.getProduct_name()+"]</span></p>");
			if(insMailPolicy.getNeed_insur_bill() == 1){
				htmlContent.append("<h2>纸质保单寄送信息：</h2>");
				htmlContent.append("<p><strong>收件人名称：</strong><span>"+insMailPolicy.getReceiver_name()+"</span></p>");
				htmlContent.append("<p><strong>收件人手机：</strong><span>"+insMailPolicy.getReceiver_mobile()+"</span></p>");
				htmlContent.append("<p><strong>收件人地址：</strong><span>"+insMailPolicy.getReceiver_address_detail()+"</span></p>");
			}
			if(insMailPolicy.getNeed_receipt() == 1){
				boolean isInv = ConstProp.DIGIT_ONE.equals(insMailPolicy.getInvoice_type());
				String inv = isInv?"增值税专用发票":"增值税普通发票";
				htmlContent.append("<h2>纸质"+inv+"寄送信息：</h2>");
				htmlContent.append("<p><strong>单位名称：</strong><span>"+insMailPolicy.getReceipt_head()+"</span></p>");
				htmlContent.append("<p><strong>纳税人识别号：</strong><span>"+insMailPolicy.getTaxpayer_number_invoice()+"</span></p>");
				htmlContent.append("<p><strong>收票人姓名：</strong><span>"+insMailPolicy.getTaker_name()+"</span></p>");
				htmlContent.append("<p><strong>收票人手机：</strong><span>"+insMailPolicy.getTaker_mobile()+"</span></p>");
				htmlContent.append("<p><strong>收票人地址：</strong><span>"+insMailPolicy.getTaker_address_detail()+"</span></p>");
				if(isInv){
					htmlContent.append("<p><strong>开户银行：</strong><span>"+insMailPolicy.getBank_invoice()+"</span></p>");
					htmlContent.append("<p><strong>银行账号：</strong><span>"+insMailPolicy.getBank_account_invoice()+"</span></p>");
					htmlContent.append("<p><strong>开户地址：</strong><span>"+RegionUtils.getRegionNameByALLCode(insMailPolicy.getBank_province(),insMailPolicy.getBank_city(),ConstProp.BLANK_CHAR)+"</span></p>");
				}
			}
			htmlContent.append("</div></div></body></html>");

		} catch (Exception e) {
			log.error("纸质保单、发票待寄送通知内容组装异常：",e);
			e.printStackTrace();
		}
		return htmlContent.toString();
	}

	private String htmlContentByInsureEmail(OrderFormVo orderVo){
		StringBuffer htmlContent= new StringBuffer();
		try {
			htmlContent.append("<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><style type=\"text/css\">.wrap{width:500px;margin:30px auto}.wrap h1{text-align:center}.shenqing-con p strong,.shenqing-con p span{display:block;font-size:14px;line-height:24px}.shenqing-con p strong{float:left;margin-right:8px}.shenqing-con div{float:left}.shenqing-con p.mg-r{width:200px;margin-left:78px}table{width:680px}table th,table td{padding:5px}</style></head><body><div class=\"wrap\"><h1>客户下单通知</h1><div class=\"shenqing-con\">");
			htmlContent.append("<p><strong>有新的订单产生，请及时跟进，详细信息：</strong><span></span></p></br>");
			htmlContent.append("<p><strong>订单号：</strong><span>"+orderVo.getTrade_serial_number()+"</span></p>");
			htmlContent.append("<p><strong>保险产品：</strong><span>[产品名称："+orderVo.getProduct_name()+"]</span></p>" +
					"<p><strong>投保人：</strong><span>"+orderVo.getApplicant_name()+"</span></p>" +
					"<p><strong>金额：</strong><span>"+orderVo.getGross_premium()+"</span></p>" +
					"<p><strong>下单时间：</strong><span>"+orderVo.getStart_time()+"</span></p>" +
					"<p><strong>生效日期：</strong><span>"+orderVo.getInception_date()+"</span></p>");
			htmlContent.append("</div></div></body></html>");
		} catch (Exception e) {
			log.error("新订单产生通知内容组装异常：",e);
			e.printStackTrace();
		}
		return htmlContent.toString();
	}

	/**
	 * <b>有效订单同步到支撑</b>
	 *
	 * @param oid 投保订单id（insInsuranceSlip.id）
	 * @author ZXF
	 * @date 2017年7月5日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	private void orderSyncZC(String oid){
		//承保订单传给支撑
		InsInsuranceSlip policy = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(oid));
		OrderFormVo orderVo = accordingToOrderIDToGetPolicyDto(policy.getIns_insurance_slip_id());
		InsTransaction it = null;
		if(policy.getInsTransaction()!=null && !policy.getInsTransaction().isEmpty()){
			it = policy.getInsTransaction().get(0);
		}
		SysClientUser user = clientUserService.selectById(policy.getRegister_user_id());
		String insName = ConstProp.BLANK_CHAR;
		if(ConstProp.GZX.equals(orderVo.getProduct_code().split(ConstProp.MINUS)[0])){
			SpecialPublicDutyVo vo = accordingToOrderIDToGetSpecialPublicDutyVo(Long.parseLong(orderVo.getOid()));
			insName = vo.getReport_name();
		}
		if(ConstProp.ZZX.equals(orderVo.getProduct_code().split(ConstProp.MINUS)[0])){
			LOTEPolicyVo vo = accordingToOrderIDToGetLOTEPolicyVo(Long.parseLong(orderVo.getOid()));
			insName = vo.getSpecialExhibitionVo().getName();
		}
		String sup_order_id = OrderSupportUtil.receiveOrderFormData(String.valueOf(user.getBusiness_support_id()),orderVo,policy,it,insName);
		if(StringUtils.isNotEmpty(sup_order_id)){
			policy.setOrder_zc_id(Long.parseLong(sup_order_id));
			insInsuranceSlipService.updateById(policy);
		}
		// TODO 排查下面注释为了起到什么作用
		if(it != null /*&& !DictConst.PAY_TYPE_XX.equals(it.getPay_type())*/){
			OrderSupportUtil.receiveTrancetionData(policy,it);//同步交易信息
		}
	}

	/**
	 * <b>有效保全单同步到支撑</b>
	 *
	 * @param record_id 保全单id
	 * @author ZXF
	 * @date 2017年7月5日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean recordSyncZC(String record_id){
		try {
			//休眠3秒，防止上一块业务还未写入数据库而读不到数据
			Thread.sleep(3000);
		} catch (InterruptedException e) {
			Thread.currentThread().interrupt();
		}
		InsPreservationRecordVo record = insPreservationRecordAPIService.findInsPreservationRecordVoById(Long.parseLong(record_id));
		InsInsuranceSlip policy = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(record.getIns_insurance_slip_id()));
		SysClientUser user = clientUserService.selectById(policy.getRegister_user_id());
		String record_zc_id = OrderSupportUtil.receivePreservationData(String.valueOf(user.getBusiness_support_id()),policy,record);
		if(StringUtils.isNotEmpty(record_zc_id)){
//			Map<String, Object> map = Maps.newHashMap();
//			map.put("method_name","recordSyncZC");
//			map.put("param_value_arr",record_id);
//			comTaskResidualAPIService.deleteByMap(map);
			insPreservationRecordAPIService.saveYWZCId(record_id, record_zc_id);
			return true;
		}
		return false;
	}

	/**
	 * <b>接收SpecialPerformanceVo_1进行设置更新数据插入相关表 </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainCommonExportVo_1VoSetUp(CommonExportVo_1 vo) {
		Map<String,Object> map1 = null;
		if(StrUtil.isBlank(vo.getOid())){
			return map1;
		}
		map1 = new HashMap<String,Object>();
		try {
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			if(StringUtils.isNotEmpty(vo.getRecommend_code())){
				insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
				insInsuranceSlipService.updateById(insInsuranceSlip);
			}
			insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
			insCommonExportService.accordingToTheCommonExportVo_1SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
			if(vo.getRoleSubjectList().size()>0){
				if(StrUtil.isNotBlank(vo.getRoleSubjectList().get(0).getTurnover_export())){
					insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(vo.getRoleSubjectList().get(0).getTurnover_export()), insInsuranceSlip);
				}
			}
		}catch (Exception ex){
			ex.printStackTrace();
		}
		map1.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map1;
	}

	@Override
	public ResultDto pendingCommonExportVo_1Policy(CommonExportVo_1 vo, String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = obtainCommonExportVo_1VoSetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("短期出口页一订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}
	/**
	 * <b>接收CommonExportVo_2进行设置更新数据插入相关表 </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainCommonExportVo_2VoSetUp(CommonExportVo_2 vo) {
		Map<String,Object> map = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			map = new HashMap<String,Object>();
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			insCommonExportService.accordingToTheCommonExportVo_2SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
			map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		}
		return map;
	}

	@Override
	public ResultDto pendingCommonExportVo_2Policy(CommonExportVo_2 vo){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			Map<String, Object> map = obtainCommonExportVo_2VoSetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("短期出口页二订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>接收CommonExportVo_3进行设置更新数据插入相关表 </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2037年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainCommonExportVo_3VoSetUp(CommonExportVo_3 vo) {
		Map<String,Object> map = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			map = new HashMap<String,Object>();
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			insCommonExportService.accordingToTheCommonExportVo_3SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
			insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
			map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		}
		return map;
	}

	@Override
	public ResultDto pendingCommonExportVo_3Policy(CommonExportVo_3 vo){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			Map<String, Object> map = obtainCommonExportVo_3VoSetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("短期出口页三订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>根据订单id获取投保单信息CommonExportVo_1 </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public CommonExportVo_1 accordingToOrderIDToGetCommonExportVo_1(Long order_id) {
		CommonExportVo_1 vo = null;
		if(StrUtil.isNotBlank(String.valueOf(order_id))){
			vo = new CommonExportVo_1();
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
			vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
			vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
			vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

			vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),order_id));

			vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
			insCommonExportService.getCommonExportVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		}
		return vo;
	}
	/**
	 * <b>根据订单id获取投保单信息CommonExportVo_2 </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public CommonExportVo_2 accordingToOrderIDToGetCommonExportVo_2(Long order_id) {
		CommonExportVo_2 vo = null;
		if(StrUtil.isNotBlank(String.valueOf(order_id))){
			vo = new CommonExportVo_2();
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
			vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
			insCommonExportService.getCommonExportVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		}
		return vo;
	}
	/**
	 * <b>根据订单id获取投保单信息CommonExportVo_3 </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public CommonExportVo_3 accordingToOrderIDToGetCommonExportVo_3(Long order_id) {
		CommonExportVo_3 vo = null;
		if(StrUtil.isNotBlank(String.valueOf(order_id))){
			vo = new CommonExportVo_3();
			MailPolicyVo voMP = new MailPolicyVo();
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
			vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
			insCommonExportService.getCommonExportVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
			InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
			insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
			vo.setMailPolicyVo(voMP);
		}
		return vo;
	}

	/**
	 * <b>页面获取上传支付信息等插入到分销</b>
	 *
	 * @param path_url 支付凭证上传路径
	 * @param order_id 订单id
	 * @param path_sign 支付阶段标识
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String uploadPayMentFileToTranction(String path_url, String order_id, String path_sign, String payAmount){
		String orderID = ConstProp.BLANK_CHAR;
		try {
			if(StrUtil.isBlank(order_id)||StrUtil.isBlank(path_url)||StrUtil.isBlank(payAmount)||StrUtil.isBlank(path_sign)){
				return orderID;
			}
			InsInsuranceSlip order = insInsuranceSlipService.selectById(Long.parseLong(order_id));
			if(order != null){
				insTransactionService.uploadPayMentFileToTranction(path_url, order, path_sign, payAmount,ConstProp.DIGIT_SIX);
				orderID = String.valueOf(order.getIns_insurance_slip_id());
			}
		}catch (Exception e){
			log.error("上传支付凭证更新数据库过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return orderID;
	}

	/**
	 * <b>根据订单ID获取承保信息表</b>
	 * TODO 根据订单ID获取承保信息表  后台未实现
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public UnderwriteVo accordingToOrderIDGainInsUnderwrite(Long order_id){
		UnderwriteVo vo = null;
		if(StrUtil.isNotBlank(String.valueOf(order_id))){
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsOrderForm(order_id);
			vo = insUnderwriteAPIService.accordingToInsUnderwriteIntoUnderwriteVo(insInsuranceSlip.getUnderwrite());
		}
		return vo;
	}

	/**
	 * <b>根据订单ID获取支付期标识</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String accordingToOrderIDGainPathSign( Long order_id){
		String path_sign = ConstProp.BLANK_CHAR;
		if(StrUtil.isNotBlank(String.valueOf(order_id))){
			path_sign = insTransactionService.accordingToOrderIDGainPathSign(String.valueOf(order_id));
		}
		return path_sign;
	}

	/**
	 * <b>根据用户ID获取企业信息及员工信息，请求百保盾</b>
	 *
	 * @param user_id 用户id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<RoleSubjectVo> getComAndEmpByUserID_BBDAPI( String user_id, String sign){
		log.info("(findCompnayAndPersonByUserid)百保盾人员数据，Star!");
		Map<String, String> data = new HashMap<String, String>();
		List<RoleSubjectVo> voList = null;
		List<RoleSubjectVo> list = new ArrayList<>();
		List lists = null;
		data.put("user_id", user_id);
		log.info("(findCompnayAndPersonByUserid)百保盾人员数据，user_id："+user_id);
		String url = getArsPath(sign)+ThirdUrlConst.ARS_FINDCOMPNAYANDPERSONBYUSERID;
		log.info("(findCompnayAndPersonByUserid)百保盾人员数据，url："+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RestUtil.restful(url,data);
			log.info("(findCompnayAndPersonByUserid)百保盾人员数据，result："+result);
		} catch (IOException e) {
			log.error("(findCompnayAndPersonByUserid)百保盾人员数据，请求过程事务发现异常，回滚数据",e);
			return new ArrayList<>();
		}
		if(StringUtils.isEmpty(result)){
			return voList;
		}
		AjaxResult r = null;
		try {
			r = JSON.parseObject(result , AjaxResult.class);
		} catch (Exception e) {
			log.error("(findCompnayAndPersonByUserid)百保盾人员数据，解析过程事务发现异常，回滚数据",e);
			return new ArrayList<>();
		}
		log.info("(findCompnayAndPersonByUserid)百保盾人员数据，解析："+JSONObject.toJSONString(r));
		if(!r.isSuccessful()) {
			return voList;
		}
		//数据列表
		lists = (List)r.getData();
		if(lists == null){
			return voList;
		}
		RoleSubjectVo initVo = null;
		Map<String,String> map = null;
		voList = new ArrayList<RoleSubjectVo>();
		for(Object obj : lists){
			map = (Map<String,String>)obj;
			if(map == null){
				continue;
			}
			initVo = new RoleSubjectVo();
			Map<String,String> mapn = Maps.newHashMap();
			for (String key : map.keySet()) {
				if(!"null".equals(map.get(key)) && map.get(key) != null){
					mapn.put(key,map.get(key));
				}
			}
			try {
				MyConverUtil.map2PO(mapn,initVo);
			} catch (Exception e) {
				e.printStackTrace();
			}
			voList.add(initVo);
			initVo = null;
			map = null;
		}
		if(voList.size()>0){
			if(ConstProp.DIGIT_ONE.equals(voList.get(0).getKind())){
				return voList;
			}
			RoleSubjectVo ro = null;
			for(RoleSubjectVo vo : voList){
				if(ConstProp.DIGIT_ONE.equals(voList.get(0).getKind())){
					ro = vo;
					voList.remove(vo);
				}
			}
			voList.set(0,ro);
		}else{
			RoleSubjectVo nullVo = null;
			for(int i = 0; i < 4; i++){
				nullVo = new RoleSubjectVo();
				if(i == 0){
					nullVo.setKind(ConstProp.DIGIT_ONE);
				}else{
					nullVo.setKind(ConstProp.DIGIT_TWO);
				}
				voList.add(nullVo);
				nullVo = null;
			}
		}
		log.info("(findCompnayAndPersonByUserid)百保盾人员数据，RoleSubjectVo List："+voList);
		log.info("(findCompnayAndPersonByUserid)百保盾人员数据：End!");
		return voList;
	}

	/**
	 * <b>根据用户ID获取企业信息及员工信息，请求第三方平台</b>
	 *
	 * @param user_id 用户id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<RoleSubjectVo> getComAndEmpByUserID_API( String user_id, String sign){
		log.info("(getComAndEmpByUserID_API)平台人员数据：Star!");
		Map<String, String> data = new HashMap<String, String>();
		List<RoleSubjectVo> voList = new ArrayList<>();
		List lists = null;
		data.put("comId", user_id);
		log.info("(getComAndEmpByUserID_API)平台人员数据，user_id："+user_id);
		String url = "";
		if(sign.contains(ConstProp.SAAS)){//saas参数及接口地址
			url = getArsPath(sign)+ThirdUrlConst.SAAS_FINDCOMPNAYPERSONBYUSERID;
		}else if(sign.contains(ConstProp.PASP)){//PASP参数及接口地址
			url = getArsPath(sign)+ThirdUrlConst.PASP_FINDCOMPNAYPERSONBYUSERID;
		}
		log.info("(getComAndEmpByUserID_API)平台人员数据，url："+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RequestUtil.sendGet(url,"comId="+user_id);
			log.info("(getComAndEmpByUserID_API)平台人员数据，result："+result);
		} catch (Exception e) {
			log.error("(getComAndEmpByUserID_API)平台人员数据，请求过程事务发现异常，回滚数据",e);
			return new ArrayList<>();
		}
		if(StringUtils.isEmpty(result)){
			return voList;
		}
		Result r = null;
		try {
			r = JSON.parseObject(result , Result.class);
		} catch (Exception e) {
			log.error("(getComAndEmpByUserID_API)平台人员数据，解析过程事务发现异常，回滚数据",e);
			return new ArrayList<>();
		}
		log.info("(getComAndEmpByUserID_API)平台人员数据，解析："+JSONObject.toJSONString(r));
		if(!ConstProp.DIGIT_ZERO.equals(r.getRetType())) {
			return voList;
		}
		//数据列表
		lists = (List)r.getData();
		if(lists == null){
			return voList;
		}
		RoleSubjectVo initVo = null;
		Map<String,String> map = null;
		voList = new ArrayList<RoleSubjectVo>();
		for(Object obj : lists){
			map = (Map<String,String>)obj;
			if(map == null){
				continue;
			}
			initVo = new RoleSubjectVo();
			Map<String,String> mapn = Maps.newHashMap();
			for (String key : map.keySet()) {
				if(!"null".equals(map.get(key)) && map.get(key) != null){
					mapn.put(key,map.get(key));
				}
			}
			try {
				MyConverUtil.map2PO(mapn,initVo);
			} catch (Exception e) {
				e.printStackTrace();
			}
			if(ConstProp.DIGIT_ZERO.equals(initVo.getId_type())&&StringUtils.isNotEmpty(initVo.getOrganization_code())&&initVo.getOrganization_code().length()==18){
				if(StringUtils.isEmpty(initVo.getSex())){
					initVo.setSex(IdNumberValidator.getSexFromCard(initVo.getOrganization_code()));
				}
				if(StringUtils.isEmpty(initVo.getBirth_date())){
					initVo.setBirth_date(DateUtil.convertDateToString(IdNumberValidator.idNumber2BirthDate(initVo.getOrganization_code()),DateUtil.FORMAT2));
				}
			}
			voList.add(initVo);
			initVo = null;
			map = null;
		}
		if(voList.size()<=0){
			return voList;
		}
		if(ConstProp.DIGIT_ONE.equals(voList.get(0).getKind())){
			return voList;
		}
		RoleSubjectVo ro = null;
		for(RoleSubjectVo vo : voList){
			if(ConstProp.DIGIT_ONE.equals(voList.get(0).getKind())){
				ro = vo;
				voList.remove(vo);
			}
		}
		voList.set(0,ro);
		log.info("(getComAndEmpByUserID_API)平台人员数据，RoleSubjectVo List："+voList);
		log.info("(getComAndEmpByUserID_API)平台人员数据：End!");
		return voList;
	}

	/**
	 * <b>根据缓存ID获取企业信息及员工信息，请求第三方平台</b>
	 *
	 * @param cacheId 缓存id
	 * @param sign 标识
	 * @author ZXF
	 * @date 2019年03月26日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<RoleSubjectVo> getComAndEmpByCacheId_API( String cacheId, String sign){
		log.info("(getComAndEmpByCacheId_API)平台人员数据：Star!");
		List<RoleSubjectVo> voList = new ArrayList<>();
		List lists = null;
		log.info("(getComAndEmpByCacheId_API)平台人员数据，cacheId："+cacheId);
		String url = "";
		if(sign.contains(ConstProp.SAAS)){//saas参数及接口地址
			url = getArsPath(sign)+ThirdUrlConst.SAAS_FINDCOMPNAYPERSONBYCACHEID;
		}else if(sign.contains(ConstProp.PASP)){//PASP参数及接口地址
			url = getArsPath(sign)+ThirdUrlConst.PASP_FINDCOMPNAYPERSONBYCACHEID;
		}
		log.info("(getComAndEmpByCacheId_API)平台人员数据，url："+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RequestUtil.sendGet(url,"cacheId="+cacheId);
			log.info("(getComAndEmpByCacheId_API)平台人员数据，result："+result);
		} catch (Exception e) {
			log.error("(getComAndEmpByCacheId_API)平台人员数据，请求过程事务发现异常，回滚数据",e);
			return new ArrayList<>();
		}
		if(StringUtils.isEmpty(result)){
			return voList;
		}
		Result r = null;
		try {
			r = JSON.parseObject(result , Result.class);
		} catch (Exception e) {
			log.error("(getComAndEmpByCacheId_API)平台人员数据，解析过程事务发现异常，回滚数据",e);
			return new ArrayList<>();
		}
		log.info("(getComAndEmpByCacheId_API)平台人员数据，解析："+JSONObject.toJSONString(r));
		if(!ConstProp.DIGIT_ZERO.equals(r.getRetType())) {
			return voList;
		}
		//数据列表
		lists = (List)r.getData();
		if(lists == null){
			return voList;
		}
		RoleSubjectVo initVo = null;
		Map<String,String> map = null;
		voList = new ArrayList<RoleSubjectVo>();
		for(Object obj : lists){
			map = (Map<String,String>)obj;
			if(map == null){
				continue;
			}
			initVo = new RoleSubjectVo();
			Map<String,String> mapn = Maps.newHashMap();
			for (String key : map.keySet()) {
				if(!"null".equals(map.get(key)) && map.get(key) != null){
					mapn.put(key,map.get(key));
				}
			}
			try {
				MyConverUtil.map2PO(mapn,initVo);
			} catch (Exception e) {
				e.printStackTrace();
			}
			if(ConstProp.DIGIT_ZERO.equals(initVo.getId_type())&&StringUtils.isNotEmpty(initVo.getOrganization_code())&&initVo.getOrganization_code().length()==18){
				if(StringUtils.isEmpty(initVo.getSex())){
					initVo.setSex(IdNumberValidator.getSexFromCard(initVo.getOrganization_code()));
				}
				if(StringUtils.isEmpty(initVo.getBirth_date())){
					initVo.setBirth_date(DateUtil.convertDateToString(IdNumberValidator.idNumber2BirthDate(initVo.getOrganization_code()),DateUtil.FORMAT2));
				}
			}
			voList.add(initVo);
			initVo = null;
			map = null;
		}
		if(voList.size()<=0){
			return voList;
		}
		if(ConstProp.DIGIT_ONE.equals(voList.get(0).getKind())){
			return voList;
		}
		RoleSubjectVo ro = null;
		for(RoleSubjectVo vo : voList){
			if(ConstProp.DIGIT_ONE.equals(voList.get(0).getKind())){
				ro = vo;
				voList.remove(vo);
			}
		}
		voList.set(0,ro);
		log.info("(getComAndEmpByCacheId_API)平台人员数据，RoleSubjectVo List："+voList);
		log.info("(getComAndEmpByCacheId_API)平台人员数据：End!");
		return voList;
	}

	/**
	 * <b>根据用户ID获取增员或减员的员工信息，请求百保盾</b>
	 *
	 * @param user_id 用户id
	 * @param sign 1为在职（增员），0为离职（减员）
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<InsPreservationResultSetVo> getPersonByUserID_BBDAPI( String user_id,String webType, String sign){
		Map<String, String> data = new HashMap<String, String>();

		List<InsPreservationResultSetVo> iprsVoList = new ArrayList<>();
		log.info("(requestBBD)获取百保盾人员列表，"+(ConstProp.DIGIT_ONE.equals(sign)?"增员":"减员")+"：star-----------------------");
		data.put("user_id", user_id);
		data.put("work_status", sign);
		String url = getArsPath(webType)+ThirdUrlConst.ARS_FINDPERSONBYUSERIDANDSTATUS;
		log.info("(requestBBD)获取百保盾人员列表，URL："+url);
		log.info("(requestBBD)获取百保盾人员列表，DATA："+data.toString());
		String result;
		try {
			result = RestUtil.restful(url,data);
			log.info("(requestBBD)获取百保盾人员列表，RETURE："+result.toString());
			log.info("(requestBBD)获取百保盾人员列表，RETURE-SUCCESS："+result.toString());
		} catch (IOException e) {
			log.info("(requestBBD)获取百保盾人员列表，RETURE-FAIL："+e.getMessage());
			return new ArrayList<>();
		}
		if(StringUtils.isNotEmpty(result)){
			iprsVoList = getInsPreservationResultSetVos(iprsVoList, result);
		}
		if(iprsVoList == null){
			log.info("requestBBD(获取百保盾人员列表)-EMP-LIST：null");
		}
		log.info("(requestBBD)获取百保盾人员列表，"+(ConstProp.DIGIT_ONE.equals(sign)?"增员":"减员")+"：end-----------------------");
		return iprsVoList;
	}

	/**
	 * <b> 根据用户ID获取增员或减员的员工信息结果解析 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 14:33
	 * @version
	 * @注意事项 </b>
	 */
	private List<InsPreservationResultSetVo> getInsPreservationResultSetVos(List<InsPreservationResultSetVo> iprsVoList, String result) {
		AjaxResult r = null;
		try {
            r = JSON.parseObject(result , AjaxResult.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
		if(!r.isSuccessful()) {
			return iprsVoList;
		}
		//数据列表
		List lists = (List)r.getData();
		if(lists == null){
			return iprsVoList;
		}
		RoleSubjectVo initVo = null;
		Map<String,String> map = null;
		List<RoleSubjectVo> voList = new ArrayList<RoleSubjectVo>();
		for(Object obj : lists){
			map = (Map<String,String>)obj;
			initVo = new RoleSubjectVo();
			try {
				MyConverUtil.map2PO(map,initVo);
			} catch (Exception e) {
//							e.printStackTrace();
			}
			voList.add(initVo);
			initVo = null;
			map = null;
		}
		iprsVoList = new ArrayList<InsPreservationResultSetVo>();
		InsPreservationResultSetVo iprsVo = null;
		for(RoleSubjectVo vo : voList){
			iprsVo = new InsPreservationResultSetVo();
			iprsVo.setName(vo.getName_cn());
			iprsVo.setId_card(vo.getOrganization_code());
			iprsVo.setId_type(vo.getId_type());
			iprsVo.setBirthday(vo.getBirth_date());
			iprsVo.setSex(vo.getSex());
			iprsVo.setTel(vo.getMobile());
			iprsVoList.add(iprsVo);
		}
		log.info("(requestBBD)获取百保盾人员列表，EMP-LIST："+iprsVoList.toString());
		return iprsVoList;
	}

	/**
	 * <b>承保后对接百保盾，将订单id，跟百保盾下单企业ID传过去</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean saveOrderInfo(String order_id){
		Map<String, String> data = new HashMap<String, String>();
		boolean flag = false;
		log.info("(saveOrderInfo)团意险承保后推送百保盾：star!");
		if(StringUtils.isEmpty(order_id)){
			return flag;
		}
		String userResult = getTPUserIDByOrderID(Long.parseLong(order_id));
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		String roleJson = ConstProp.BLANK_CHAR;
		if(dto.getProduct_code().contains(ConstProp.TYX)){
			roleJson = getRoleJsonByTYX(order_id, roleJson);
		}else if(dto.getProduct_code().contains(ConstProp.GZZRX)){
			roleJson = getRoleJsonByGZZRX(order_id, roleJson);
		}

		ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
		String doAmount = ConstProp.BLANK_CHAR;
		String doAmount_yy = ConstProp.BLANK_CHAR;
		doAmount = getFcyAmount(pd, doAmount);
		if(StringUtils.isNotEmpty(doAmount)){
			if(productService.api_request_sign(pd.getProduct_code())==1){
				doAmount_yy = String.valueOf((BigDecimal.valueOf(Double.parseDouble(doAmount))).multiply(BigDecimal.valueOf(Double.parseDouble("0.7"))));
			}else{
				doAmount_yy = doAmount;
			}
		}
		data.put(ConstProp.SAVEORDERINFO_DATA_IEA, doAmount_yy);
		data.put(ConstProp.SAVEORDERINFO_DATA_IA, doAmount);
		data.put(ConstProp.SAVEORDERINFO_DATA_USERID, userResult.split(ConstProp.SEMICOLON)[0]);
		data.put(ConstProp.SAVEORDERINFO_DATA_ORDERNO, order_id);
		data.put(ConstProp.SAVEORDERINFO_DATA_CARDLIST, roleJson);
		String url = getArsPath(userResult.split(ConstProp.SEMICOLON)[1]) + ThirdUrlConst.ARS_SAVEORDERINFO;
		log.info("(saveOrderInfo)团意险承保后推送百保盾，DATA："+data.toString());
		log.info("(saveOrderInfo)团意险承保后推送百保盾，URL："+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RestUtil.restful(url,data);
			log.info("(saveOrderInfo)团意险承保后推送百保盾，RESULT："+result);
		} catch (IOException e) {
			e.printStackTrace();
		}
		if(StringUtils.isNotEmpty(result)){
			AjaxResult r = JSON.parseObject(result , AjaxResult.class);
			if(r.isSuccessful()) {
				flag = true;
			}
		}
		log.info("(saveOrderInfo)团意险承保后推送百保盾，RETURN："+flag);
		log.info("(saveOrderInfo)团意险承保后推送百保盾：end!");
		return flag;
	}

	/**
	 * <b> 获取产品保额 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 14:50
	 * @version
	 * @注意事项 </b>
	 */
	private String getFcyAmount(ProductVo pd, String doAmount) {
		if(pd.getResponsibilityVoList().size()<=0){
			return doAmount;
		}
		for(ResponsibilityVo rvo : pd.getResponsibilityVoList()){
			if(ConstProp.PRODUCT_GUARANTEE_YW.equals(rvo.getName())){
				doAmount = String.valueOf(rvo.getFcy());
				break;
			}else if(ConstProp.PRODUCT_GUARANTEE_ZR.equals(rvo.getName())){
				doAmount = String.valueOf(rvo.getInsurance_amount_max());
				break;
			}
		}
		return doAmount;
	}

	/**
	 * <b> 雇主责任险根据雇员组装人员信息字符串 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 14:40
	 * @version
	 * @注意事项 </b>
	 */
	private String getRoleJsonByGZZRX(String order_id, String roleJson) {
		SpecialHirelingVo vo = accordingToOrderIDToGetSpecialHirelingVo(Long.parseLong(order_id));
		if(vo.getHirelingVoList() == null){
			return roleJson;
		}
		JSONObject jsonObject = new JSONObject();
		int count = ConstProp.INT_NUMBER_ZERO;
		jsonObject.put(ConstProp.SAVEORDERINFO_DATA_COUNT,String.valueOf(vo.getHirelingVoList().size()));
		for(HirelingVo hVo : vo.getHirelingVoList()){
			jsonObject.put(count+ConstProp.BLANK_CHAR,hVo.getId_card());
			count ++;
		}
		return jsonObject.toString();
	}

	/**
	 * <b> 团意险根据被保险人组装人员信息字符串 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 14:40
	 * @version
	 * @注意事项 </b>
	 */
	private String getRoleJsonByTYX(String order_id, String roleJson) {
		GMRPolicyVo vo = accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(order_id));
		if(vo.getRoleSubjectList() == null){
			return roleJson;
		}
		JSONObject jsonObject = new JSONObject();
		int count = ConstProp.INT_NUMBER_ZERO;
		jsonObject.put("count",String.valueOf(vo.getRoleSubjectList().size()-1));
		for(RoleSubjectVo roleVo : vo.getRoleSubjectList()){
			if(ConstProp.ROLE_INSURED.equals(roleVo.getKind())){
				jsonObject.put(count+ConstProp.BLANK_CHAR,roleVo.getOrganization_code());
				count ++;
			}
		}
		return jsonObject.toString();
	}

	/**
	 * <b>承保后对接第三方，将订单相关信息推送过去</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean saveOrderInfoPush(String order_id){
		Map<String, String> data = new HashMap<String, String>();
		boolean flag = false;
		log.info("(saveOrderInfoPush)订单推送第三方：star!");
		if(StringUtils.isEmpty(order_id)){
			return flag;
		}
		String userResult = getTPUserIDByOrderID(Long.parseLong(order_id));
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		if(StringUtils.isEmpty(dto.getExternal_reference())){
			return flag;
		}
		JSONArray jarr = new JSONArray();
		if(dto.getProduct_code().contains(ConstProp.TYX)){
			getJarrByTYX(order_id, data, jarr);
		}else if(dto.getProduct_code().contains(ConstProp.GZZRX)){
			getJarrByGZZRX(order_id, data, jarr);
		}else{
			log.info("(saveOrderInfoPush)订单推送第三方，end："+dto.getProduct_code());
			return true;
		}
		data.put("orderId", dto.getOid());
		data.put("comId", userResult.split(ConstProp.SEMICOLON)[0]);
		data.put("productName", dto.getProduct_name());
		data.put("productCode", dto.getProduct_code());
		data.put("insComName", dto.getInsurance_name());
		data.put("buyTime", dto.getStart_time());
		data.put("effectStartDate", dto.getInception_date());
		data.put("effectEndDate", dto.getPlanned_end_date());
		data.put("policyNo", dto.getExternal_reference());
		data.put("perPremiums", dto.getPremium());
		String policyUrl = "";
		if(StringUtils.isNotEmpty(dto.getInsure_path())){
			policyUrl = dto.getInsure_path().contains("http") ? dto.getInsure_path() : GlobalResources.WEB_URL+dto.getInsure_path();
		}
		data.put("policyUrl", policyUrl);
		data.put("userList", jarr.toJSONString());
		String url = "";
		if(dto.getWeb_type().contains(ConstProp.SAAS)){//saas参数及接口地址
			url = getArsPath(dto.getWeb_type())+ThirdUrlConst.SAAS_SAVEORDERINFO;
		}else if(dto.getWeb_type().contains(ConstProp.PASP)){//PASP参数及接口地址
			url = getArsPath(dto.getWeb_type())+ThirdUrlConst.PASP_SAVEORDERINFO;
		}
		log.info("(saveOrderInfoPush)订单推送第三方，url："+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			log.info("(saveOrderInfoPush)订单推送第三方，data："+data.toString());
			result = RestUtil.restful(url,data);
			log.info("(saveOrderInfoPush)订单推送第三方，result："+result);
		} catch (IOException e) {
			e.printStackTrace();
		}
		if(StringUtils.isEmpty(result)){
			return flag;
		}
		Result r = JSON.parseObject(result , Result.class);
		log.info("(saveOrderInfoPush)订单推送第三方，retType："+r.getRetType());
		log.info("(saveOrderInfoPush)订单推送第三方，msg："+r.getMsg());
		if(ConstProp.DIGIT_ZERO.equals(r.getRetType())) {
			flag = true;
		}
		log.info("(saveOrderInfoPush)订单推送第三方：end!");
		return flag;
	}

	/**
	 * <b> 团意险组装投保人员 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 14:53
	 * @version
	 * @注意事项 </b>
	 */
	private void getJarrByGZZRX(String order_id, Map<String, String> data, JSONArray jarr) {
		SpecialHirelingVo vo = accordingToOrderIDToGetSpecialHirelingVo(Long.parseLong(order_id));
		if(vo.getHirelingVoList() == null){
			return;
		}
		JSONObject jsonObject = null;
		data.put("perNum",String.valueOf(vo.getHirelingVoList().size()));
		for(HirelingVo hVo : vo.getHirelingVoList()){
			jsonObject = new JSONObject();
			jsonObject.put("idCardNo",hVo.getId_card());
			jsonObject.put("name",hVo.getName());
			jarr.add(jsonObject);
			jsonObject = null;
		}
	}

	/**
	 * <b> 团意险组装投保人员 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 14:53
	 * @version
	 * @注意事项 </b>
	 */
	private void getJarrByTYX(String order_id, Map<String, String> data, JSONArray jarr) {
		GMRPolicyVo vo = accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(order_id));
		if(vo.getRoleSubjectList() == null){
			return;
		}
		JSONObject jsonObject = null;
		if(vo.getSpecialExhibitionVo()!=null && StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getName())){
			data.put("projectName",vo.getSpecialExhibitionVo().getName());
		}
		data.put("perNum",String.valueOf(vo.getRoleSubjectList().size()-1));
		for(RoleSubjectVo roleVo : vo.getRoleSubjectList()){
			if(ConstProp.ROLE_INSURED.equals(roleVo.getKind())){
				jsonObject = new JSONObject();
				jsonObject.put("idCardNo",roleVo.getOrganization_code());
				jsonObject.put("name",roleVo.getName_cn());
				jarr.add(jsonObject);
				jsonObject = null;
			}
		}
	}

	/**
	 * <b> 保单信息推送第三方修复保单信息缺失的问题 </b>
	 * @author ZXF
	 * @create 2019/05/28 0028 9:36
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Result pushRepairOrderInfo(String order_id){
		Map<String, String> data = new HashMap<String, String>();
		log.info("(pushRepairOrderInfo)订单推送第三方：star!");
		if(StringUtils.isEmpty(order_id)){
			return Result.fail("订单id不能为空！");
		}
		String userResult = getTPUserIDByOrderID(Long.parseLong(order_id));
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		JSONArray jarr = new JSONArray();
		if(!dto.getProduct_code().contains(ConstProp.TYX)&&!dto.getProduct_code().contains(ConstProp.GZZRX)){
			log.info("(pushRepairOrderInfo)订单推送第三方，end："+dto.getProduct_code());
			return Result.fail("product_code不匹配:"+dto.getProduct_code());
		}
		List<InsPreservationResultSet> setList = insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null,Long.parseLong(order_id),"","0","","");
		if(setList.size()<=0){
			log.info("(pushRepairOrderInfo)订单推送第三方，end：未找到在保人员信息！");
			return Result.fail("未找到在保人员信息！");
		}
		if(dto.getProduct_code().contains(ConstProp.TYX)){
			GMRPolicyVo vo = accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(order_id));
			if(vo.getSpecialExhibitionVo()!=null && StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getName())){
				data.put("projectName",vo.getSpecialExhibitionVo().getName());
			}
		}
		JSONObject jsonObject = null;
		data.put("perNum",String.valueOf(setList.size()));
		for(InsPreservationResultSet set : setList){
			jsonObject = new JSONObject();
			jsonObject.put("idCardNo",set.getId_card());
			jsonObject.put("name",set.getName());
			jarr.add(jsonObject);
		}
		data.put("orderId", dto.getOid());
		data.put("comId", userResult.split(ConstProp.SEMICOLON)[0]);
		data.put("productName", dto.getProduct_name());
		data.put("productCode", dto.getProduct_code());
		data.put("insComName", dto.getInsurance_name());
		data.put("buyTime", dto.getStart_time());
		data.put("effectStartDate", dto.getInception_date());
		data.put("effectEndDate", dto.getPlanned_end_date());
		data.put("policyNo", dto.getExternal_reference());
		data.put("perPremiums", dto.getPremium());
		String policyUrl = "";
		if(StringUtils.isNotEmpty(dto.getInsure_path())){
			policyUrl = dto.getInsure_path().contains("http") ? dto.getInsure_path() : GlobalResources.WEB_URL+dto.getInsure_path();
		}
		data.put("policyUrl", policyUrl);
		data.put("userList", jarr.toJSONString());
		String url = "";
		if(dto.getWeb_type().contains(ConstProp.SAAS)){//saas参数及接口地址
			url = getArsPath(dto.getWeb_type())+ThirdUrlConst.SAAS_SAVEORDERINFO;
		}else if(dto.getWeb_type().contains(ConstProp.PASP)){//PASP参数及接口地址
			url = getArsPath(dto.getWeb_type())+ThirdUrlConst.PASP_SAVEORDERINFO;
		}
		log.info("(pushRepairOrderInfo)订单推送第三方，url："+url);
		try {
			log.info("(pushRepairOrderInfo)订单推送第三方，data："+data.toString());
			String result = RestUtil.restful(url,data);
			log.info("(pushRepairOrderInfo)订单推送第三方，result："+result);
			if(StringUtils.isNotEmpty(result)){
				Result r = JSON.parseObject(result , Result.class);
				log.info("(pushRepairOrderInfo)订单推送第三方，retType："+r.getRetType());
				log.info("(pushRepairOrderInfo)订单推送第三方，msg："+r.getMsg());
				log.info("(pushRepairOrderInfo)订单推送第三方：end!");
				return r;
			}else{
				log.info("(pushRepairOrderInfo)订单推送第三方：end!");
				return Result.fail("接口返回空！");
			}
		} catch (IOException e) {
			log.info("(pushRepairOrderInfo)订单推送第三方：end!");
			return Result.fail("pushRepairOrderInfo业务异常："+e.getMessage());
		}
	}


	/**
	 * <b> 在保人员信息推送第三方线下保单（被标识为百联保购买的保单）关联 </b>
	 * @author ZXF
	 * @create 2019/05/28 0028 9:36
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public boolean pushOfflineOrderPerson(String order_id){
		Map<String, String> data = new HashMap<String, String>();
		log.info("(pushOfflineOrderPerson)订单推送第三方：star!");
		if(StringUtils.isEmpty(order_id)){
			return false;
		}
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		JSONArray jarr = new JSONArray();
		if(!dto.getProduct_code().contains(ConstProp.TYX)&&!dto.getProduct_code().contains(ConstProp.GZZRX)){
			log.info("(pushOfflineOrderPerson)订单推送第三方，end："+dto.getProduct_code());
			return false;
		}
		List<InsPreservationResultSet> setList = insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null,Long.parseLong(order_id),"","0","","");
		if(setList.size()<=0){
			log.info("(pushOfflineOrderPerson)订单推送第三方，end：未找到在保人员信息！");
			return false;
		}
		JSONObject jsonObject = null;
		data.put("perNum",String.valueOf(setList.size()));
		for(InsPreservationResultSet set : setList){
			jsonObject = new JSONObject();
			jsonObject.put("idCardNo",set.getId_card());
			jsonObject.put("name",set.getName());
			jarr.add(jsonObject);
		}
		data.put("policyNo", dto.getExternal_reference());
		data.put("userList", jarr.toJSONString());
		String url = "";
		if(dto.getWeb_type().contains(ConstProp.PASP)){//PASP参数及接口地址
			url = getArsPath(dto.getWeb_type())+ThirdUrlConst.PASP_SAVEOFFLINEORDERPERSON;
		}
		log.info("(pushOfflineOrderPerson)订单推送第三方，url："+url);
		try {
			log.info("(pushOfflineOrderPerson)订单推送第三方，data："+data.toString());
			String result = RestUtil.restful(url,data);
			log.info("(pushOfflineOrderPerson)订单推送第三方，result："+result);
			if(StringUtils.isNotEmpty(result)){
				Result r = JSON.parseObject(result , Result.class);
				log.info("(pushOfflineOrderPerson)订单推送第三方，retType："+r.getRetType());
				log.info("(pushOfflineOrderPerson)订单推送第三方，msg："+r.getMsg());
				log.info("(pushOfflineOrderPerson)订单推送第三方：end!");
				if(Result.SUCCESS.equals(r.getRetType())){
					return true;
				}
				return false;
			}else{
				log.info("(pushOfflineOrderPerson)订单推送第三方：接口返回空 end!");
				return false;
			}
		} catch (IOException e) {
			log.info("(pushOfflineOrderPerson)订单推送第三方："+e.getMessage()+" end!");
			return false;
		}
	}

	/**
	 * <b>将电子保单地址推送给SAAS</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @create 2019/05/10 0010 14:34
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public boolean savePolicyUrlPush(String order_id){
		Map<String, String> data = new HashMap<String, String>();
		boolean flag = false;
		log.info("(savePolicyUrlPush)电子保单地址推送第三方平台：star!");
		if(StringUtils.isEmpty(order_id)){
			return flag;
		}
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		String policyUrl = "";
		if(StringUtils.isNotEmpty(dto.getInsure_path())){
			policyUrl = dto.getInsure_path().contains("http") ? dto.getInsure_path() : GlobalResources.WEB_URL+dto.getInsure_path();
		}
		if(StringUtils.isNotEmpty(policyUrl)){
			return flag;
		}
		data.put("orderId", dto.getOid());
		data.put("policyUrl", policyUrl);
		String url = "";
		if(dto.getWeb_type().contains(ConstProp.SAAS)){//saas参数及接口地址
			url = getArsPath(dto.getWeb_type())+ThirdUrlConst.SAAS_SAVEPOLICYURL;
		}else if(dto.getWeb_type().contains(ConstProp.PASP)){//PASP参数及接口地址
			url = getArsPath(dto.getWeb_type())+ThirdUrlConst.PASP_SAVEPOLICYURL;
		}
		log.info("(savePolicyUrlPush)电子保单地址推送第三方平台，url："+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			log.info("(savePolicyUrlPush)电子保单地址推送第三方平台，data："+data.toString());
			result = RestUtil.restful(url,data);
			log.info("(savePolicyUrlPush)电子保单地址推送第三方平台，result："+result);
		} catch (IOException e) {
			e.printStackTrace();
		}
		if(StringUtils.isEmpty(result)){
			log.info("(savePolicyUrlPush)电子保单地址推送第三方平台：end!");
			return flag;
		}
		Result r = JSON.parseObject(result , Result.class);
		log.info("(savePolicyUrlPush)电子保单地址推送第三方平台，retType："+r.getRetType());
		log.info("(savePolicyUrlPush)电子保单地址推送第三方平台，msg："+r.getMsg());
		if(ConstProp.DIGIT_ZERO.equals(r.getRetType())) {
			flag = true;
		}
		log.info("(savePolicyUrlPush)电子保单地址推送第三方平台：end!");
		return flag;
	}

	/**
	 * <b>请求第三方废弃保单</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @create 2019/05/10 0010 14:34
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public boolean deletePolicyPush(String order_id){
		Map<String, String> data = new HashMap<String, String>();
		boolean flag = false;
		log.info("(deletePolicyPush)请求第三方废弃保单：star!");
		if(StringUtils.isEmpty(order_id)){
			return flag;
		}
		String userResult = getTPUserIDByOrderID(Long.parseLong(order_id));
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		if(dto == null){
			return flag;
		}
		data.put("orderId", dto.getOid());
		String url = "";
		if(dto.getWeb_type().contains(ConstProp.SAAS)){//saas参数及接口地址
			url = getArsPath(dto.getWeb_type())+ThirdUrlConst.SAAS_DELETEPOLICY;
		}else if(dto.getWeb_type().contains(ConstProp.PASP)){//PASP参数及接口地址
			url = getArsPath(dto.getWeb_type())+ThirdUrlConst.PASP_DELETEPOLICY;
		}
		log.info("(deletePolicyPush)请求第三方废弃保单，url："+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			log.info("(deletePolicyPush)请求第三方废弃保单，data："+data.toString());
			result = RestUtil.restful(url,data);
			log.info("(deletePolicyPush)请求第三方废弃保单，result："+result);
		} catch (IOException e) {
			e.printStackTrace();
		}
		if(StringUtils.isEmpty(result)){
			log.info("(deletePolicyPush)请求第三方废弃保单：end!");
			return flag;
		}
		Result r = JSON.parseObject(result , Result.class);
		log.info("(deletePolicyPush)请求第三方废弃保单，retType："+r.getRetType());
		log.info("(deletePolicyPush)请求第三方废弃保单，msg："+r.getMsg());
		if(ConstProp.DIGIT_ZERO.equals(r.getRetType())) {
			flag = true;
		}
		log.info("(deletePolicyPush)请求第三方废弃保单：end!");
		return flag;
	}


	/**
	 * <b>百保盾、SAAS、PASP保全推送用统一方法（内部业务再区分） 保全申请审核通过后对接百保盾，将订单id，跟百保盾做保全人员信息组装传过去</b>
	 * @param record_id 保全申请单id
	 * @author ZXF
	 * @date 2017年9月13日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean pushRecordInfo(String record_id){
		log.info("(pushRecordInfo)保全申请审核通过后推送第三方：start!");
		log.info("(pushRecordInfo)保全申请审核通过后推送第三方，record_id："+record_id);
		Map<String, String> data = new HashMap<String, String>();
		boolean flag = false;
		String url = ConstProp.BLANK_CHAR;
		if(StringUtils.isEmpty(record_id)){
			return flag;
		}
		InsPreservationRecordVo iprVo = insPreservationRecordAPIService.findInsPreservationRecordVoById(Long.parseLong(record_id));
		String userResult = getTPUserIDByOrderID(Long.parseLong(iprVo.getIns_insurance_slip_id()));
		OrderFormVo orderVo = accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
		if(StringUtils.isNotEmpty(userResult)&&orderVo.getWeb_type().contains(ConstProp.BLB)){//如果是自己平台不做推送
			return true;
		}
		String sign = userResult.split(ConstProp.SEMICOLON)[1];
		if(sign.contains(ConstProp.ARS)){//百保盾参数及接口地址
			url = getArsPath(sign)+ThirdUrlConst.ARS_INSURANCEPRESERVATION;
			setARSParmes(data, iprVo, userResult.split(ConstProp.SEMICOLON)[0]);
		}else if(sign.contains(ConstProp.SAAS)){//saas参数及接口地址
			url = getArsPath(sign)+ThirdUrlConst.SAAS_SAVEPRESERVATIONINFO;//TODO 待修改
			setSAASParmes(data, iprVo, userResult.split(ConstProp.SEMICOLON)[0]);
		}else if(sign.contains(ConstProp.PASP)){//PASP参数及接口地址
			url = getArsPath(sign)+ThirdUrlConst.PASP_SAVEPRESERVATIONINFO;
			setPASPParmes(data, iprVo, userResult.split(ConstProp.SEMICOLON)[0]);
		}else if(StringUtils.isNotEmpty(orderVo.getWeb_type())&&orderVo.getWeb_type().contains(ConstProp.PASP)){//PASP参数及接口地址(订单上被标记上才跑这个推送)
			url = getArsPath(orderVo.getWeb_type())+ThirdUrlConst.PASP_SAVEOFFLINEPRESERVATIONINFO;
			setPASPOfflineParmes(data, iprVo);
		}else{
			return true;
		}
		if(data == null){
			log.error("(pushRecordInfo)保全申请审核通过后推送第三方，保全信息异常！，record_id："+record_id);
			return flag;
		}
		log.info("(pushRecordInfo)保全申请审核通过后推送第三方，url："+url);
		log.info("(pushRecordInfo)保全申请审核通过后推送第三方，data："+data.toString());
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RestUtil.restful(url,data);
		} catch (IOException e) {
			e.printStackTrace();
		}
		if(StringUtils.isEmpty(result)){
			log.info("(pushRecordInfo)保全申请审核通过后推送第三方，更新推送成功标识！");
			return flag;
		}
		log.info("(pushRecordInfo)保全申请审核通过后推送第三方，AjaxResult："+result);
		AjaxResult r = JSON.parseObject(result , AjaxResult.class);
		if(r.isSuccessful()) {
			insPreservationRecordAPIService.updateRecordByIsPush(iprVo.getOid());
			log.info("(pushRecordInfo)保全申请审核通过后推送第三方：end!----------");
			flag = true;
		}
		log.info("(pushRecordInfo)保全申请审核通过后推送第三方，更新推送成功标识！");
		return flag;
	}

	private void setARSParmes(Map<String, String> data, InsPreservationRecordVo iprVo, String user_id){
		String roleJson = ConstProp.BLANK_CHAR;
		if(iprVo.getInsPreservationDetailVoList() != null){
			JSONObject jsonObject = new JSONObject();
			int count = ConstProp.INT_NUMBER_ZERO;
			jsonObject.put("count",String.valueOf(iprVo.getInsPreservationDetailVoList().size()-1));
			for(InsPreservationDetailVo ipdVo : iprVo.getInsPreservationDetailVoList()){
				jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getId_card()+ConstProp.POUND_SIGN+iprVo.getRevise_type());
				count ++;
			}
			roleJson = jsonObject.toString();
		}
		data.put("user_id", user_id);
		data.put("orderNo", iprVo.getIns_insurance_slip_id());
		data.put("cardList", roleJson);
	}

	private void setSAASParmes(Map<String, String> data, InsPreservationRecordVo iprVo, String user_id){
		String roleJson = ConstProp.BLANK_CHAR;
		if(iprVo.getInsPreservationDetailVoList() == null){
			data.put("user_id", user_id);
			data.put("order_no", iprVo.getIns_insurance_slip_id());
			data.put("cardList", roleJson);
			return;
		}
		JSONObject jsonObject = new JSONObject();
		int count = ConstProp.INT_NUMBER_ZERO;
		for(InsPreservationDetailVo ipdVo : iprVo.getInsPreservationDetailVoList()){
			if("3".equals(iprVo.getRevise_type())){//替换
				if(ipdVo.getBusiness_vo() != null){
					jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getId_card()+ConstProp.POUND_SIGN+ipdVo.getName()+ConstProp.POUND_SIGN+"1");
					count ++;
					jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getBusiness_vo().getId_card()+ConstProp.POUND_SIGN+ipdVo.getBusiness_vo().getName()+ConstProp.POUND_SIGN+"2");
					count ++;
				}
			}else{
				jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getId_card()+ConstProp.POUND_SIGN+ipdVo.getName()+ConstProp.POUND_SIGN+iprVo.getRevise_type());
				count ++;
			}
		}
		if(count == ConstProp.INT_NUMBER_ZERO){
			data = null;
			return;
		}
		jsonObject.put("count",String.valueOf(count-1));
		data.put("user_id", user_id);
		data.put("order_no", iprVo.getIns_insurance_slip_id());
		data.put("cardList", jsonObject.toString());
	}

	private void setPASPParmes(Map<String, String> data, InsPreservationRecordVo iprVo, String user_id){
		String roleJson = ConstProp.BLANK_CHAR;
		if(iprVo.getInsPreservationDetailVoList() == null){
			data.put("user_id", user_id);
			data.put("order_no", iprVo.getIns_insurance_slip_id());
			data.put("cardList", roleJson);
			return;
		}
		JSONObject jsonObject = new JSONObject();
		int count = ConstProp.INT_NUMBER_ZERO;
		for(InsPreservationDetailVo ipdVo : iprVo.getInsPreservationDetailVoList()){
			if("3".equals(iprVo.getRevise_type())){//替换
				if(ipdVo.getBusiness_vo() != null){
					jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getId_card()+ConstProp.POUND_SIGN+ipdVo.getName()+ConstProp.POUND_SIGN+"1");
					count ++;
					jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getBusiness_vo().getId_card()+ConstProp.POUND_SIGN+ipdVo.getBusiness_vo().getName()+ConstProp.POUND_SIGN+"2");
					count ++;
				}
			}else{
				jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getId_card()+ConstProp.POUND_SIGN+ipdVo.getName()+ConstProp.POUND_SIGN+iprVo.getRevise_type());
				count ++;
			}
		}
		if(count == ConstProp.INT_NUMBER_ZERO){
			data = null;
			return;
		}
		jsonObject.put("count",String.valueOf(count-1));
		data.put("user_id", user_id);
		data.put("order_no", iprVo.getIns_insurance_slip_id());
		data.put("cardList", jsonObject.toString());
	}

	private void setPASPOfflineParmes(Map<String, String> data, InsPreservationRecordVo iprVo){
		String roleJson = ConstProp.BLANK_CHAR;
		if(iprVo.getInsPreservationDetailVoList() == null){
			data.put("policyNo", iprVo.getExternal_reference());
			data.put("cardList", roleJson);
			return;
		}
		JSONObject jsonObject = new JSONObject();
		int count = ConstProp.INT_NUMBER_ZERO;
		for(InsPreservationDetailVo ipdVo : iprVo.getInsPreservationDetailVoList()){
			if("3".equals(iprVo.getRevise_type())){//替换
				if(ipdVo.getBusiness_vo() != null){
					jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getId_card()+ConstProp.POUND_SIGN+ipdVo.getName()+ConstProp.POUND_SIGN+"1");
					count ++;
					jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getBusiness_vo().getId_card()+ConstProp.POUND_SIGN+ipdVo.getBusiness_vo().getName()+ConstProp.POUND_SIGN+"2");
					count ++;
				}
			}else{
				jsonObject.put(count+ConstProp.BLANK_CHAR,ipdVo.getId_card()+ConstProp.POUND_SIGN+ipdVo.getName()+ConstProp.POUND_SIGN+iprVo.getRevise_type());
				count ++;
			}
		}
		if(count == ConstProp.INT_NUMBER_ZERO){
			data = null;
			return;
		}
		jsonObject.put("count",String.valueOf(count-1));
		data.put("policyNo", iprVo.getExternal_reference());
		data.put("cardList", jsonObject.toString());
	}

	/**
	 * <b>根据cacheId获取第三方平台要做保全操作的人员信息</b>
	 *
	 * @param cacheId saas提供的标识码
	 * @param sign 平台标识
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<InsPreservationDetailVo> getPreservationDetailVoByApi( String cacheId, String sign){
		log.info("(getPreservationDetailVoByApi)保全人员请求：Star----------------------");
		Map<String, String> data = new HashMap<String, String>();
		List<InsPreservationDetailVo> voList = null;
		List lists = null;
		data.put("cacheId", cacheId);
		log.info("(getPreservationDetailVoByApi)保全人员请求参数，cacheId："+cacheId);
		//http://sn.baibaodun.cn/ars-rest
		String url = "";
		if(sign.contains(ConstProp.SAAS)){//saas参数及接口地址
			url = getArsPath(sign)+ThirdUrlConst.SAAS_FINDPERIDSBYCACHEID;
		}else if(sign.contains(ConstProp.PASP)){//PASP参数及接口地址
			url = getArsPath(sign)+ThirdUrlConst.PASP_FINDPERIDSBYCACHEID;
		}
		log.info("(getPreservationDetailVoByApi)保全人员请求地址，url："+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RequestUtil.sendGet(url,"cacheId="+cacheId);
		} catch (Exception e) {
			log.error("(getPreservationDetailVoByApi)保全人员请求过程事务发现异常，回滚数据",e);
			return null;
		}
		if(StringUtils.isEmpty(result)){
			return voList;
		}
		AjaxResult r = null;
		try {
			r = JSON.parseObject(result , AjaxResult.class);
		} catch (Exception e) {
			log.error("(getPreservationDetailVoByApi)保全人员数据解析过程事务发现异常，回滚数据",e);
			return null;
		}
		log.info("(getPreservationDetailVoByApi)保全人员数据，result："+JSONObject.toJSONString(r));
		if(!r.isSuccessful()) {
			return voList;
		}
		//数据列表
		lists = (List)r.getData();
		if(lists == null){
			return voList;
		}
		InsPreservationDetailVo initVo = null;
		Map<String,String> map = null;
		voList = new ArrayList<InsPreservationDetailVo>();
		for(Object obj : lists){
			map = (Map<String,String>)obj;
			if(map == null){
				continue;
			}
			initVo = new InsPreservationDetailVo();
			Map<String,String> mapn = Maps.newHashMap();
			for (String key : map.keySet()) {
				if(!"null".equals(map.get(key)) && map.get(key) != null){
					mapn.put(key,map.get(key));
				}
			}
			try {
				MyConverUtil.map2PO(mapn,initVo);
			} catch (Exception e) {
				e.printStackTrace();
			}
			if(ConstProp.DIGIT_ZERO.equals(initVo.getId_type())&&StringUtils.isNotEmpty(initVo.getId_card())&&initVo.getId_card().length()==18){
				if(StringUtils.isEmpty(initVo.getSex())){
					initVo.setSex(IdNumberValidator.getSexFromCard(initVo.getId_card()));
				}
				if(StringUtils.isEmpty(initVo.getBirthday())){
					initVo.setBirthday(DateUtil.convertDateToString(IdNumberValidator.idNumber2BirthDate(initVo.getId_card()),DateUtil.FORMAT2));
				}
			}
			voList.add(initVo);
			initVo = null;
			map = null;
		}
		log.info("(getPreservationDetailVoByApi)保全人员数据，RoleSubjectVoList："+voList);
		log.info("(getPreservationDetailVoByApi)保全人员数据：End------------------");
		return voList;
	}


	/**
	 * <b>承保后订单过期对接百保盾，将已过期订单id推给百保盾</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean pushBackOrderID(String order_id){
		/*Map<String, String> data = new HashMap<String, String>();
		boolean flag = false;
		if(StringUtil.isNotEmpty(order_id)){
			String user_id = getTPUserIDByOrderID(Long.parseLong(order_id));
			data.put("user_id", user_id);
			data.put("orderNo", order_id);
			String url = GlobalResources.BBDAPI_PATH+"/company/cancelOrderInfo.json";
			String result = ConstProp.BLANK_CHAR;
			try {
				result = RestUtil.restful(url,data);
			} catch (IOException e) {
				e.printStackTrace();
			}
			if(StringUtil.isNotEmpty(result)){
				AjaxResult r = JSON.parseObject(result , AjaxResult.class);
				if(r.isSuccessful()) {
					flag = true;
				}
			}
		}
		return flag;*/
		return false;
	}

	/**
	 * <b>承保后对接pss，将保单相关信息传过去</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean pushOrderToPSS(String order_id){
		log.info("(pushOrderToPSS)公责险承保推送PSS平台，开始-----------");
		log.info("(pushOrderToPSS)公责险承保推送PSS平台，order_id："+order_id);
		Map<String, String> data = new HashMap<String, String>();
		boolean flag = false;
		if(StringUtils.isEmpty(order_id)){
			return flag;
		}
		String userResult = getTPUserIDByOrderID(Long.parseLong(order_id));
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		if(StringUtils.isEmpty(dto.getExternal_reference())){
			return flag;
		}
		String invoiceURL="",insuranceObject="";
		if(dto.getProduct_code().contains(ConstProp.GZX_HT)){
			SpecialPublicDutyVo vo = accordingToOrderIDToGetSpecialPublicDutyVo(Long.parseLong(order_id));
			invoiceURL=vo.getMailPolicyVo().getE_invoice_url();
			insuranceObject=vo.getReport_name();
		}else if(dto.getProduct_code().contains(ConstProp.ZZX_HT)){
			LOTEPolicyVo vo = accordingToOrderIDToGetLOTEPolicyVo(Long.parseLong(order_id));
			invoiceURL=vo.getMailPolicyVo().getE_invoice_url();
			insuranceObject=vo.getSpecialExhibitionVo().getName();
		}else if(dto.getProduct_code().contains(ConstProp.TYX_QH_DQ)||dto.getProduct_code().contains(ConstProp.TYX_HT_DQ)){
			GMRPolicyVo vo = accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(order_id));
			invoiceURL=vo.getMailPolicyVo().getE_invoice_url();
			insuranceObject=vo.getSpecialExhibitionVo().getName();
		}
		//如果pss有提供订单号那就推送，否则不推送
		data.put("userId", userResult.split(ConstProp.SEMICOLON)[0]);//pss的用户id
		data.put("externalReference", dto.getExternal_reference());//保单号
//		String ipath = dto.getProduct_code().contains(ConstProp.GZX_PAC)?GlobalResources.DONOW_PATH+dto.getInsure_path():dto.getInsure_path();
		data.put("policyURL", dto.getInsure_path());//电子保单地址
		data.put("invoiceURL", invoiceURL);//
		data.put("blbOrderId", dto.getOid());//
		data.put("orderNo", dto.getTrade_serial_number());//
		data.put("applicantName", dto.getApplicant_name());//
		data.put("productName", dto.getProduct_name());//
		data.put("insuranceName", dto.getInsurance_name());//
		data.put("insuranceObject", insuranceObject);//
		data.put("inceptionDate", dto.getInception_date());//
		data.put("plannedEndDate", dto.getPlanned_end_date());//
		data.put("signedDate", dto.getStart_time());//
		data.put("policyStatus", "6".equals(dto.getPolicy_status())?dto.getPolicy_status():"12");//
		data.put("amount", dto.getGross_premium());//
		log.info("(pushOrderToPSS)公责险承保推送PSS平台，data："+JSON.toJSONString(data));
		String url = getArsPath(userResult.split(ConstProp.SEMICOLON)[1]) + ThirdUrlConst.PSS_FEEDBACK;
		log.info("(pushOrderToPSS)公责险承保推送PSS平台，url："+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RestUtil.restful(url,data);
			log.info("(pushOrderToPSS)公责险承保推送PSS平台，result："+result);
		} catch (IOException e) {
			e.printStackTrace();
		}
		if(StringUtils.isEmpty(result)){
			log.info("(pushOrderToPSS)公责险承保推送PSS平台，结束-----------------");
			return flag;
		}
		AjaxResult r = JSON.parseObject(result , AjaxResult.class);
		if(r.isSuccessful()) {
			log.info("(pushOrderToPSS)公责险承保推送PSS平台，isSuccessful："+r.isSuccessful());
			flag = true;
		}
		log.info("(pushOrderToPSS)公责险承保推送PSS平台，结束-----------------");
		return flag;
	}

	public static void main(String[] args) throws IOException {
		String data = "{\"amount\":\"135.00\",\"orderNo\":\"1749247337408098304\",\"insuranceObject\":\"伙食4\",\"blbOrderId\":\"1749247337563164673\",\"applicantName\":\"佳弘安防服务公司\",\"policyStatus\":\"6\",\"userId\":\"12\",\"productName\":\"华泰保安人员短期意外险计划四\",\"plannedEndDate\":\"2024-02-07\",\"externalReference\":\"PB251649722402178487\",\"policyURL\":\"https://test.pc.ehuatai.com:9003/inco-gateway/printPdf?key=E112625FC319387FF7723A39E69B542E\",\"inceptionDate\":\"2024-01-23\",\"insuranceName\":\"华泰保险集团股份有限公司\",\"signedDate\":\"2024-01-22 09:47:19\"}";
		Map<String,String> map = JSONObject.parseObject(data, Map.class);
		String url = "http://localhost:8080/communicate/blb/policy/feedback";
		System.out.println(RestUtil.restful(url,map));
	}

	/**
	 * <b>展责险承保后判断是否存在活动名称，如果存在就推送活动信息给业务支撑更新数据</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean pushZZXOrderToYWZC(String order_id){
		log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，开始-----------");
		log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，order_id："+order_id);
		Map<String, String> data = new HashMap<String, String>();
		boolean flag = false;
		if(StringUtils.isEmpty(order_id)) {
			return flag;
		}
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		LOTEPolicyVo loteVo = accordingToOrderIDToGetLOTEPolicyVo(Long.parseLong(order_id));
		if (loteVo == null) {
			return flag;
		}
		if (StringUtils.isEmpty(loteVo.getSpecialExhibitionVo().getActivity_id())) {
			return flag;
		}
		//如果存在活动id就推送给业务支撑
		data.put("activity_id", loteVo.getSpecialExhibitionVo().getActivity_id());//活动id
		data.put("exhibition_hall_pos_string", loteVo.getSpecialExhibitionVo().getEx_no());//展位号
		data.put("blb_order_id", order_id);//订单id
		data.put("blb_product_code", dto.getProduct_code());//产品标识
//					data.put("activity_id", "955712677828030465");//活动id
//					data.put("exhibition_hall_pos_string", "D1-D010,D1-D011");//展厅-展位号
		log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，data：" + data.toString());
		String url = String.valueOf(GlobalResources.map.get("YWZC_URL")) + "/api/blb/update-exhibition-ins-info";
		log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，url：" + url);
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RestUtil.restful(url, data);
			log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，result：" + result);
		} catch (IOException e) {
			log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，ERROR：方法执行发生异常-记录，等待重新执行-----------------------");
			comTaskResidualAPIService.saveComTaskResidual("pushZZXOrderToYWZC","展责险承保后推活动信息给业务支撑","com.bcxin.ins.service.order.PolicyService",1,"String",order_id);
			log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，ERROR："+e.getMessage());
//						e.printStackTrace();
		}
		if (StringUtils.isEmpty(result)) {
			log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，结束-----------------");
			return flag;
		}
		AjaxResult r = JSON.parseObject(result, AjaxResult.class);
		if (r.isSuccess()) {
			log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，isSuccessful：" + r.isSuccess());
			flag = true;
		}else{
			log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，ERROR：方法执行未返回预期结果-记录，等待重新执行-----------------------");
			comTaskResidualAPIService.saveComTaskResidual("pushZZXOrderToYWZC","展责险承保后推活动信息给业务支撑","com.bcxin.ins.service.order.PolicyService",1,"String",order_id);
		}
		log.info("(pushZZXOrderToYWZC)展责险活动推送业务支撑，结束-----------------");
		return flag;
	}

	/**
	 * <b>根据用户ID获取活动信息列表，请求PSS</b>
	 *
	 * @param user_id 用户id
	 * @param activity_type 活动标识：ZL,WY,TY,QT
	 * @param sign 平台标识：PSS
	 * @param exclude_id 排除活动id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<BLBCommunicationDto> getBLBCommunicationDtoByUserID_PSSAPI( String user_id, String activity_type, String sign, String exclude_id){
		Map<String, String> data = new HashMap<String, String>();
		List<BLBCommunicationDto> voList = null;
		data.put("activity_type", activity_type);
		data.put("user_id", user_id);
		log.info("(getBLBCommunicationDtoByUserID_PSSAPI)，data:"+data.toString());
		String url = getArsPath(sign)+ThirdUrlConst.PSS_ACTIVITYLIST;
		log.info("(getBLBCommunicationDtoByUserID_PSSAPI)，url:"+url);
		String result;
		try {
			result = RestUtil.restful(url,data);
			log.info("(getBLBCommunicationDtoByUserID_PSSAPI)，result:"+result);
		} catch (IOException e) {
			return voList;
		}
		if(StringUtils.isEmpty(result)){
			return voList;
		}
		AjaxResult r = null;
		try {
			r = JSON.parseObject(result , AjaxResult.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(!r.isSuccessful()) {
			return voList;
		}
		//数据列表
		List lists = (List)r.getData();
		if(lists == null){
			return voList;
		}
		BLBCommunicationDto initVo = null;
		Map<String,String> map = null;
		voList = new ArrayList<BLBCommunicationDto>();
		for(Object obj : lists){
			map = (Map<String,String>)obj;
			if(map == null){
				continue;
			}
			initVo = new BLBCommunicationDto();
			Map<String,String> mapn = Maps.newHashMap();
			for (String key : map.keySet()) {
				if(!"null".equals(map.get(key)) && map.get(key) != null){
					mapn.put(key,map.get(key));
				}
			}
			try {
				MyConverUtil.map2PO(mapn,initVo);
			} catch (Exception e) {
				e.printStackTrace();
			}
			if(StringUtils.isEmpty(initVo.getActivity_id())){
				initVo = null;
				map = null;
			}
			//过滤活动id为空的
			if(StringUtils.isNotEmpty(exclude_id)){//如果该id为当前单所操作的活动订单id则添加到活动选项
				if(exclude_id.equals(initVo.getActivity_id())){
					voList.add(initVo);
				}
			}
			if(!specialPublicDutyAPIService.getSpecialPublicDutyVoByThrOrderId(initVo.getActivity_id())){//过滤存在有效单的，避免同一活动重复下单
				voList.add(initVo);
			}
			initVo = null;
			map = null;
		}
		return voList;
	}

	/**
	 * <b>根据订单id获取活动信息，请求PSS</b>
	 *
	 * @param order_id 活动的订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public BLBCommunicationDto getBLBCommunicationDtoByOrderID_PSSAPI( String order_id, String sign){
		Map<String, String> data = new HashMap<String, String>();
		BLBCommunicationDto dto = null;
		data.put("activity_id", order_id);
		String url = getArsPath(sign)+ThirdUrlConst.PSS_ACTIVITYDETAIL;
		log.info("(getBLBCommunicationDtoByOrderID_PSSAPI)，data:"+data.toString());
		log.info("(getBLBCommunicationDtoByOrderID_PSSAPI)，path:"+url);
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RestUtil.restful(url,data);
			log.info("(getBLBCommunicationDtoByOrderID_PSSAPI)，result:"+result);
		} catch (IOException e) {
			return dto;
		}
		if(StringUtils.isEmpty(result)){
			return dto;
		}
		AjaxResult r = null;
		try {
			r = JSON.parseObject(result , AjaxResult.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(!r.isSuccessful()) {
			return dto;
		}
		//数据列表
		Object obj = r.getData();
		if(obj == null){
			return dto;
		}
		Map<String,String> map = (Map<String,String>)obj;
		dto = new BLBCommunicationDto();
		Map<String,String> mapn = Maps.newHashMap();
		for (String key : map.keySet()) {
			if(!"null".equals(map.get(key)) && map.get(key) != null){
				mapn.put(key,map.get(key));
			}
		}
		try {
			MyConverUtil.map2PO(mapn,dto);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return dto;
	}

	/**
	 * <b>根据用户ID获取企业信息及员工信息，请求PSS</b>
	 *
	 * @param user_id 用户id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<RoleSubjectVo> getRoleSubjectVoByUserID_PSSAPI( String user_id, String sign){
		Map<String, String> data = new HashMap<String, String>();
		List<RoleSubjectVo> voList = null;
		List<RoleSubjectVo> list = null;
		List lists = null;
		data.put("user_id", user_id);
		String url = getArsPath(sign)+ThirdUrlConst.PSS_FINDCOMPNAYANDPERSONBYUSERID;
		String result = ConstProp.BLANK_CHAR;
		try {
			result = RestUtil.restful(url,data);
		} catch (IOException e) {
			return voList;
		}
		if(StringUtils.isEmpty(result)){
			return voList;
		}
		AjaxResult r = null;
		try {
			r = JSON.parseObject(result , AjaxResult.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(!r.isSuccessful()) {
			return voList;
		}
		//数据列表
		lists = (List)r.getData();
		if(lists == null){
			return voList;
		}
		RoleSubjectVo initVo = null;
		Map<String,String> map = null;
		voList = new ArrayList<RoleSubjectVo>();
		for(Object obj : lists){
			map = (Map<String,String>)obj;
			if(map == null){
				continue;
			}
			initVo = new RoleSubjectVo();
			Map<String,String> mapn = Maps.newHashMap();
			for (String key : map.keySet()) {
				if(!"null".equals(map.get(key)) && map.get(key) != null){
					mapn.put(key,map.get(key));
				}
			}
			try {
				MyConverUtil.map2PO(mapn,initVo);
			} catch (Exception e) {
				e.printStackTrace();
			}
			voList.add(initVo);
			initVo = null;
			map = null;
		}
		if(voList.size()<=0){
			return voList;
		}
		if(ConstProp.DIGIT_ONE.equals(voList.get(0).getKind())){
			return voList;
		}
		RoleSubjectVo ro = null;
		for(RoleSubjectVo vo : voList){
			if(ConstProp.DIGIT_ONE.equals(voList.get(0).getKind())){
				ro = vo;
				voList.remove(vo);
			}
		}
		voList.set(0,ro);
		return voList;
	}

	/**
	 * <b>根据被保险人id请求删除对应条目</b>
	 *
	 * @param role_id 被保险人
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean deleteRoleInPolicyByOid(String role_id){
		boolean flag = false;
		if(StrUtil.isBlank(role_id)){
			return flag;
		}
		try{
			InsRoleInpolicy insRoleInpolicy = insRoleInpolicyService.selectById(Long.parseLong(role_id));
			if(insRoleInpolicy != null){
				insRoleInpolicyService.deleteById(role_id);
				flag = true;
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return flag;
	}

	/**
	 * <b>根据订单id删除所有被保险人记录</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean delectAllInsRole(String order_id){
		boolean flag = false;
		if(StrUtil.isNotBlank(order_id)){
			try{
				flag = insRoleInpolicyService.delectAllInsRole(Long.parseLong(order_id));
			}catch (Exception e){
				e.printStackTrace();
			}
		}
		return flag;
	}

	/**
	 * <b>根据雇员id请求删除对应条目</b>
	 * @param hire_id 雇员
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean deleteHirelingByOid(String hire_id){
		boolean flag = false;
		if(StrUtil.isNotBlank(hire_id)){
			flag = hirelingAPIService.delectHirelingByOid(Long.parseLong(hire_id));
		}
		return flag;
	}

	/**
	 * <b>根据订单id删除所有雇员记录</b>
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean delectAllHireling(String order_id){
		boolean flag = false;
		if(StrUtil.isNotBlank(order_id)){
			flag = hirelingAPIService.delectAllHireling(Long.parseLong(order_id));
		}
		return flag;
	}

	/**
	 * <b>根据投保单号获取OrderFormVo </b>
	 *
	 * @param rcptno 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderFormVo getPolicyDtoByRcptNo(String rcptno) {
		OrderFormVo vo = null;
		if(StrUtil.isNotBlank(rcptno)){
			vo = insInsuranceSlipService.getOrderFormVoByRcptNo(rcptno);
		}
		return vo;
	}

	/**
	 * 检索待支付的投保单中生效日期小于当前的条目，改状态为过期并更新数据库
	 */
	@Override
	public void findPolicyListByLapsed() throws ParseException {
		List<OrderFormVo> doesTimeList = new ArrayList<OrderFormVo>();
		//待支付列表
		List<OrderFormVo> pdto_1 = insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(InsOrderSearchVo.build(null,ConstProp.DIGIT_FOUR,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR,null));
		//承保待支付列表
		List<OrderFormVo> pdto_2 = insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(InsOrderSearchVo.build(null,"16",ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR,null));
		Date dates = new Date();
		for(OrderFormVo dto : pdto_1){
			if(StringUtils.isEmpty(dto.getPlanned_end_date())){
				continue;
			}
			if(DateUtil.parseDate(dto.getPlanned_end_date()).before(dates)){
				doesTimeList.add(dto);
			}
		}
		for(OrderFormVo dto : pdto_2){
			if(StringUtils.isEmpty(dto.getPlanned_end_date())){
				dto.setPolicy_status(ConstProp.DIGIT_THIRTEEN);
				updateOrderFormStatus(dto);
				continue;
			}
			if(DateUtil.parseDate(dto.getPlanned_end_date()).before(dates)){
				doesTimeList.add(dto);
			}
		}
		//已承保列表
		List<OrderFormVo> pdto_3 = insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(InsOrderSearchVo.build(null,ConstProp.DIGIT_SIX,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR,null));
		for(OrderFormVo dto : pdto_3){
			//清理redis保单缓存记录
			JedisUtils.del(ConstProp.REDIS_HEAD_POLICY_ID+dto.getOid());
			if(StringUtils.isEmpty(dto.getPlanned_end_date())){
				dto.setPolicy_status(ConstProp.DIGIT_THIRTEEN);
				updateOrderFormStatus(dto);
				continue;
			}
			if(DateUtil.parseDate(dto.getPlanned_end_date()).before(dates)){
				doesTimeList.add(dto);
			}
		}
		for(OrderFormVo dto : doesTimeList){
			dto.setPolicy_status(ConstProp.DIGIT_TWELVE);
			updateOrderFormStatus(dto);
			//检索团意险订单，过期单推送给百保盾

			if(StringUtils.isNotEmpty(dto.getProduct_code()) ? ConstProp.TYX.equals(dto.getProduct_code().split(ConstProp.MINUS)[0]) :false){
				pushBackOrderID(dto.getOid());
			}
		}
	}

	/**
	 * 投标对接太保的支付业务模块，从当用户选择支付方式后开始调此业务
	 * @param policyId 订单id
	 * @param payType 支付方式
	 * @param userId 用户ID
	 * @param response 打印回页面
	 */
	@Override
	public void policyPayment_bd_cpic(String policyId, String payType,String userId, HttpServletResponse response){
		try {
			log.info("requestTB(投保太保请求)：star-----------------------");
			InsInsuranceSlip policy = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(policyId));
			SpecialBidVo sVo = accordingToOrderIDToGetSpecialBidVo(Long.parseLong(policyId));
			OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.parseLong(policyId));
			PolicyTransactionVo vo= new PolicyTransactionVo();
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			vo.setTrade_serial_number(String.valueOf(idWorker.nextId()));//设置交易流水号
			String relyCO = ConstProp.BOOLEAN_Y;
			final String _init = ConstProp.BLANK_CHAR;
			String msg = _init,payforURL = _init/*,payNum = _init*/;
			Communicator communicator = new Communicator();
			vo.setPayment_method(ConstProp.DIGIT_THREE);
			if(StringUtils.isEmpty(payType)){
				response.getWriter().print("{\"statusCode\":\"300\",\"message\":\"未检索到支付类型\"}");
				return;
			}
			RegionUtils.getComRegionByCode(policy.getCity());
			ComRegion regionCity = RegionUtils.getComRegionByCode(policy.getCity());
			//先匹配市级
			String val1_ = regionCity.getNamed().substring(0, regionCity.getNamed().length()-1);
			List<ComAreaCode> tbsList = comAreaCodeAPIService.findComAreaCodeByCode(_init,_init,val1_);
			ComAreaCode tb = null;
			if(tbsList.size()>0){
				tb = tbsList.get(0);
			}
			//如果市级未匹配到就匹配省级
			if(tb == null){
				ComRegion regionPro = RegionUtils.getComRegionByCode(policy.getProvince());
				String val2_ = regionPro.getNamed().substring(0, regionPro.getNamed().length()-1);
				List<ComAreaCode> tbpList = comAreaCodeAPIService.findComAreaCodeByCode(_init,_init,val2_);
				if(tbpList.size()>0){
					tb = tbpList.get(0);
				}
			}
			log.info("requestTB(投保太保请求)/API_CODE：107001/policyId:"+policyId+";policyPaymentType:"+payType+";tb_code:"+tb.getCodes());
			String policyNumber = communicator.sendAndReturn( vo.getTrade_serial_number(),sVo,dto,tb.getCodes(), CommunicateType.TAIBAO,payType, TransType.EPIC_INS, _init);
			log.info("responseTB(返回数据)："+policyNumber);
			String[] num = policyNumber.split(ConstProp.POUND_SIGN);
			if ( ConstProp.CODE_SUCCESS.equals(num[0])) {
				if ( num.length > 2 ) {
					policy.setPolicy_serial_number(num[1]);
					payforURL = num[2];
//					if(num.length == 4){
//						payNum = num[3];
//					}
				}
			} else {
				relyCO = ConstProp.BOOLEAN_N;
				if ( num.length > 1 ) {
					msg = num[1];
				}
			}
			if (!ConstProp.BOOLEAN_Y.equals(relyCO)) {
				response.getWriter().print("{\"statusCode\":\"301\",\"message\":\""+msg+"\"}");
				return;
			}
			vo.setPay_amount(policy.getPremium());
			vo.setOut_of_pocket(policy.getPremium());
			vo.setStart_time(new Date());
			vo.setDeal_url(payforURL);
			vo.setPolicy_id(policyId);
			vo.setPayment_method(ConstProp.DIGIT_ONE);
			vo.setPath_sign(ConstProp.DIGIT_ONE);
			vo.setPay_type(DictConst.PAY_TYPE_YL);
			vo.setUser_id(Long.parseLong(userId));
			vo.setPolicy_serial_number(policy.getPolicy_serial_number());//设置投保单号
			saveTransaction(vo);
			insInsuranceSlipService.updateById(policy);
			log.info("responseTB(支付信息录入完成)：end-------------------------");
			response.getWriter().print("{\"statusCode\":\"200\",\"forwardurl\":\""+payforURL+"\"}");
		}catch (Exception e){
			log.error("投标保险订单核保过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			try {
				response.getWriter().print("{\"statusCode\":\"300\",\"message\":\"支付过程出现异常\"}");
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
	}

	/**
	 * 都邦投标保证保险核保接口请求及数据更新
	 * @param oid 订单id
	 */
	@Override
	public String HTTP_DB_BUILD_HB(String oid){
		log.info("HTTP_DB_BUILD_HB(都邦投标保险核保接口请求)：star-----------------------");
		try {
			InsInsuranceSlip policy = insInsuranceSlipService.selectById(Long.parseLong(oid));
			PolicyTransactionVo vo= new PolicyTransactionVo();
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			vo.setTrade_serial_number(String.valueOf(idWorker.nextId()));//设置交易流水号
			vo.setPayment_method(ConstProp.DIGIT_THREE);
			String policyNumber = build_DBRequestService.requestDB(Long.parseLong(oid),ConstProp.DIGIT_ONE, null);
			log.info("HTTP_DB_BUILD_HB(核保接口返回数据)，policyNumber："+policyNumber);
			String[] num = policyNumber.split(ConstProp.POUND_SIGN);
			if ( !ConstProp.CODE_SUCCESS.equals(num[0])) {
				return "300#"+num[1];
			}
			vo.setPay_amount(policy.getPremium());
			vo.setOut_of_pocket(policy.getPremium());
			vo.setStart_time(new Date());
			vo.setPolicy_id(oid);
			vo.setPayment_method(ConstProp.DIGIT_ONE);
			vo.setPath_sign(ConstProp.DIGIT_ONE);
			vo.setPay_type(DictConst.PAY_TYPE_WX);
			vo.setUser_id(policy.getRegister_user_id());
			vo.setPolicy_serial_number(num[1]);//设置投保单号
			saveTransaction(vo);
			PolicyTransactionVo ptVo= new PolicyTransactionVo();
			//保存保单号
			ptVo.setPolicy_number(num[2]);//policy.setExternalReference();
			ptVo.setPolicy_id(oid);
			insTransactionService.savePolicyExternalReferenceToDB(ptVo);
			log.info("HTTP_DB_BUILD_HB(核保信息录入完成（初始化支付订单）)：end-------------------------");
			return "200#";
		}catch (Exception e){
			log.error("都邦请求核保接口数据过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return "300#支付过程出现异常";
		}
	}

	/**
	 * <b>
	 *     阳光电子保单接口请求获取下载地址
	 * </b>
	 * @author ZXF
	 * @create 2018/06/01 0001 10:52
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public String HTTP_YG_BUILD_DZBD(String oid){
		log.info("HTTP_YG_BUILD_DZBD(阳光电子保单接口请求)：star-----------------------");
		String downloadUrl = ConstProp.BLANK_CHAR;
		try {
			OrderFormVo dto = accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
			SpecialBidVo specialBidVo = accordingToOrderIDToGetSpecialBidVo(Long.valueOf(oid));
			com.bcxin.ins.third.build.yangguang.yggc.Result result = yGGCService.underwritingHttpSend(JSON.toJSONString(BDYGGC.getDemo(dto, specialBidVo)), ConstProp.DIGIT_TWO);
			String errorCode = result.getQueryEpolicyDTO().get(0).getErrorCode();
			if ("SUCCESS00000".equals(errorCode)) {
				downloadUrl = result.getQueryEpolicyDTO().get(0).getUrl();
				PolicyTransactionVo vo= new PolicyTransactionVo();
				//保存保单号
				vo.setPolicy_id(oid);
				//保存保单地址
				vo.setInsure_path(downloadUrl);//保单地址
				insTransactionService.savePolicyOther(vo);
				log.info("HTTP_YG_BUILD_DZBD(电子保单下载地址)：" + downloadUrl);
			}
		}catch (Exception e){
			log.error("阳光电子保单接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("HTTP_YG_BUILD_DZBD(阳光电子保单接口请求)：end-----------------------");
		return downloadUrl;
	}

	/**
	 * 诉讼，履约保险上传支付凭证调用业务块
	 * @param paymentPath 支付凭证地址
	 * @param oid 订单id
	 * @return
	 */
	@Override
	public ResultDto uploadPayMentFile_com(String paymentPath, String oid){
		try {
			JSONObject json = new JSONObject();
			boolean endUpload = false;
			if(StringUtils.isEmpty(oid)&&StringUtils.isEmpty(paymentPath)){
				return new ResultDto("请重新上传！！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			InsInsuranceSlip policy = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(oid));
			OrderFormVo dto = accordingToOrderIDToGetPolicyDto(policy.getIns_insurance_slip_id());
			InsTransaction transaction = insTransactionService.getTranctionByorderIDAndStatus(policy.getIns_insurance_slip_id());
			if(StringUtils.isEmpty(paymentPath)){
				return new ResultDto("上传文件异常，请重试！！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			int count = 0;
			if(transaction == null){
				PolicyTransactionVo ptVo = new PolicyTransactionVo();
				ptVo.setPolicy_id(String.valueOf(policy.getIns_insurance_slip_id()));
				ptVo.setPay_order_url(paymentPath);
				ptVo.setUser_id(policy.getRegister_user_id());
				ptVo.setPay_amount(policy.getPremium());
				ptVo.setPay_type(DictConst.PAY_TYPE_XX);
				ptVo.setPayment_method(dto.getPay_methods());
				IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
				ptVo.setTrade_serial_number(String.valueOf(idWorker.nextId()));//设置交易流水号
				insTransactionService.saveTransaction(ptVo);
				transaction = insTransactionService.getTranctionByorderIDAndStatus(policy.getIns_insurance_slip_id());
				count = 1;
			}
			if(count == 0){
				transaction.setPay_order_url(paymentPath);
				insTransactionService.updateById(transaction);
			}
			if(StringUtils.isNotEmpty(policy.getUser_insure_path()) && StringUtils.isNotEmpty(transaction.getPay_order_url())){
				endUpload = true;
			}
			if(endUpload){
				//诉讼待支付界面上传支付凭证时传分销创建或更新交易信息记录
				saveOrUpdateTransaction_ss(String.valueOf(dto.getOid()), transaction.getPay_order_url(), String.valueOf(policy.getPremium()),transaction.getPath_sign());
			/*if(!oldPolicy.getEmt().equals(EmailMsgType.ACCOUNTPAID)){//说明已经发送邮件
				//TODO 给保险公司该业务负责人及我司该业务负责人用邮件及短信方式发送通知
				notifyService.policy_applyFor(oldPolicy,EmailMsgType.ACCOUNTPAID);
			}*/
			}
			//完成上传后异步发送邮件
			new Thread(()->{
				JFPZ_SendEmail(policy.getIns_insurance_slip_id(), paymentPath);
			}).start();
			return new ResultDto("上传成功！", ConstProp.CODE_SUCCESS, endUpload+ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}catch (Exception e){
			log.error("订单复印件上传过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("上传文件更新过程出现异常，请重试！！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}


	@Override
	public void policyToPDF(InsInsuranceSlip policy, String sign){
		if (StringUtils.isEmpty(policy.getPolicy_serial_number())) {
			return;
		}
		Communicator communicator = new Communicator();
		SpecialBidVo sVo = accordingToOrderIDToGetSpecialBidVo(policy.getIns_insurance_slip_id());
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(policy.getIns_insurance_slip_id());
		List<InsTransaction> tList = insTransactionService.selectInsTransactionByInsOrderForm(Long.parseLong(dto.getOid()));
		if(tList == null && tList.size()<=0){
			return;
		}
		if(ConstProp.DIGIT_ONE.equals(sign)){
			sign1Server(policy, sign, communicator, sVo, dto, tList);
		}
		if(ConstProp.DIGIT_TWO.equals(sign)){
			sign2Server(policy, sign, communicator, sVo, dto, tList);
		}
	}

	/**
	 * <b> sign=2的业务 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 15:54
	 * @version
	 * @注意事项 </b>
	 */
	private void sign2Server(InsInsuranceSlip policy, String sign, Communicator communicator, SpecialBidVo sVo, OrderFormVo dto, List<InsTransaction> tList) {
		if (StringUtils.isNotEmpty(policy.getLg_path())) {
			return;
		}
		log.debug("b ready to communicator ");
		String policyNumber03 = communicator.sendAndReturn(tList.get(0).getTrade_serial_number(),sVo,dto, ConstProp.BLANK_CHAR, CommunicateType.TAIBAO,ConstProp.BLANK_CHAR, TransType.EPIC_EPOLICY,sign);
		log.debug("b communicator finish get policyNumber:"+policyNumber03);
		String[] numbers = policyNumber03.split(ConstProp.POUND_SIGN);
		if(ConstProp.CODE_SUCCESS.equals(numbers[0])){
			policy.setBh_initial(numbers[1]);
			insInsuranceSlipService.updateById(policy);
		}
		log.debug("b save compelte");
	}

	/**
	 * <b> sign=1的业务 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 15:54
	 * @version
	 * @注意事项 </b>
	 */
	private void sign1Server(InsInsuranceSlip policy, String sign, Communicator communicator, SpecialBidVo sVo, OrderFormVo dto, List<InsTransaction> tList) {
		if (StringUtils.isNotEmpty(policy.getInsure_path())) {
			return;
		}
		log.debug("b ready to communicator ");
		String policyNumber03 = communicator.sendAndReturn(tList.get(0).getTrade_serial_number(),sVo,dto, ConstProp.BLANK_CHAR, CommunicateType.TAIBAO,ConstProp.BLANK_CHAR, TransType.EPIC_EPOLICY,sign);
		log.debug("b communicator finish get policyNumber:"+policyNumber03);
		String[] numbers = policyNumber03.split(ConstProp.POUND_SIGN);
		if(ConstProp.CODE_SUCCESS.equals(numbers[0])){
			policy.setInsure_path(numbers[1]);
			insInsuranceSlipService.updateById(policy);
		}
		log.debug("b save compelte");
	}

	@Override
	public void policyEndStatus(String userId){
		Long uid = StringUtils.isEmpty(userId) ? null : Long.parseLong(userId);
		InsOrderSearchVo search = InsOrderSearchVo.build(uid,ConstProp.DIGIT_FOUR, ConstProp.DIGIT_THREE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR,null);
		List<OrderFormVo> listVo = findPolicyForPage(search);
		if(listVo == null){
			return;
		}
		for (OrderFormVo vo : listVo) {
			if(StringUtils.isNotEmpty(vo.getProduct_code()) ? ConstProp.BZX_TB_GCTB.equals(vo.getProduct_code()) :false){
				port_107002(vo);
			}
		}
	}

	@Override
	public void port_107002(OrderFormVo dto) {

		if (StringUtils.isEmpty(dto.getPolicy_serial_number()) || StringUtils.isNotEmpty(dto.getExternal_reference()) ) {
			return;
		}
		SpecialBidVo sVo = accordingToOrderIDToGetSpecialBidVo(Long.parseLong(dto.getOid()));
		List<InsTransaction> tList = insTransactionService.selectInsTransactionByInsOrderForm(Long.parseLong(dto.getOid()));
		if(tList == null || tList.size()<=0){
			return;
		}
		Communicator communicator = new Communicator();
		String policyNumber = communicator.sendAndReturn( tList.get(0).getTrade_serial_number(),sVo,dto,ConstProp.BLANK_CHAR, CommunicateType.TAIBAO,ConstProp.BLANK_CHAR, TransType.EPIC_QUERY, ConstProp.BLANK_CHAR);
		String sign = policyNumber.split(ConstProp.POUND_SIGN)[0];
		String num = ConstProp.BLANK_CHAR;
		if(policyNumber.split(ConstProp.POUND_SIGN).length>1){
			num = policyNumber.split(ConstProp.POUND_SIGN)[1];
		}
		if(!ConstProp.CODE_SUCCESS.equals(sign)){
			return;
		}
		if(StringUtils.isNotEmpty(num)){
			//存保单号policy.getOid(),num
			PolicyTransactionVo vo= new PolicyTransactionVo();
			vo.setPolicy_number(num);
			vo.setPolicy_id(dto.getOid());
			saveExternalReference(vo);
		}
	}

	/**
	 * 平安财-展责险-承保接口
	 * @param oid
	 * @param map
	 * @return
	 */
	@Override
	public boolean HTTP_PAC_ZZX_CB(Long oid, Map<String,String> map){
		boolean flag = true;
		try {
			log.info("----------平安承保接口调用（HTTP_PAC_ZZX_CB）：star-----------");
			String result = zZX_PACRequestService.requestPAC(oid,ConstProp.DIGIT_TWO, map);
			log.info("----------PA-ZZX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				flag = false;
				log.info("----------平安承保接口调用返回（HTTP_PAC_ZZX_CB）：FAIL!!-----------");
				log.info("----------平安承保接口调用（HTTP_PAC_ZZX_CB）：end-----------");
				return flag;
			}
			log.info("----------平安承保接口调用返回（HTTP_PAC_ZZX_CB）：SUCCESS!!-----------");
			if (StringUtils.isEmpty(strs[1])) {
				flag = false;
				log.info("----------平安承保接口调用返回保单号（HTTP_PAC_ZZX_CB）：FAIL!!-----------");
				log.info("----------平安承保接口调用（HTTP_PAC_ZZX_CB）：end-----------");
				return flag;
			}
			log.info("----------PA-ZZX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			log.info("----------平安承保接口调用返回更新数据库（HTTP_PAC_ZZX_CB）：SUCCESS!!-----------");
			pushZZXOrderToYWZC(String.valueOf(oid));
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		log.info("----------平安承保接口调用（HTTP_PAC_ZZX_CB）：end-----------");
		return flag;
	}

	/**
	 * 平安财-展责险-支付信息保存
	 * @param map
	 * @return
	 */
	@Override
	public boolean  PAC_ZZX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = insInsuranceSlipService.getOrderFormVoByNoticeNo(map.get("businessNo"));
			if(dto == null && StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			//设置交易流水号
			pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
			pvo.setOut_of_pocket(new BigDecimal(map.get("paymentSum")));
			pvo.setStart_time(DateUtil.convertString2Date(map.get("paymentDate")));
			pvo.setEnd_time(new Date());
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			//支付方式
			pvo.setPay_type(DictConst.PAY_TYPE_XS);
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_PAC_ZZX_CB(Long.parseLong(dto.getOid()), map);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
		}catch (Exception e){
			log.error("平安团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	/**
	 * 平安财承保后，查询电子保单地址设置到数据库
	 */
	@Override
	public String HTTP_PAC_ZZX_DZBD(Long oid){
		String path = ConstProp.BLANK_CHAR;
		try {
			String result = zZX_PACRequestService.requestPAC(oid,"3", null);
			log.info("----------PAC-ZZX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])||StringUtils.isEmpty(strs[1])) {
				return path;
			}
			log.info("----------PAC-ZZX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_id(String.valueOf(oid));
			//保存保单地址
			vo.setInsure_path(strs[1]);
			insTransactionService.savePolicyOther(vo);
			path = strs[1];
		}catch (Exception e){
			log.error("平安财展责险获取电子保单接口调用过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return path;
	}

	/**
	 * 平安财-公责险-承保接口
	 * @param oid
	 * @param map
	 * @return
	 */
	@Override
	public boolean HTTP_PAC_GZX_CB(Long oid, Map<String,String> map){
		boolean flag = true;
		try {
			log.info("----------平安承保接口调用（HTTP_PAC_GZX_CB）：star-----------");
			String result = gZX_PACRequestService.requestPAC(oid,ConstProp.DIGIT_TWO, map);
			log.info("----------PA-GZX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				flag = false;
				log.info("----------平安承保接口调用返回（HTTP_PAC_GZX_CB）：FAIL!!-----------");
				log.info("----------平安承保接口调用（HTTP_PAC_GZX_CB）：end-----------");
				return flag;
			}
			log.info("----------平安承保接口调用返回（HTTP_PAC_GZX_CB）：SUCCESS!!-----------");
			if (StringUtils.isEmpty(strs[1])) {
				flag = false;
				log.info("----------平安承保接口调用返回保单号（HTTP_PAC_GZX_CB）：FAIL!!-----------");
				log.info("----------平安承保接口调用（HTTP_PAC_GZX_CB）：end-----------");
				return flag;
			}
			log.info("----------PA-GZX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//返回订单给指定平台 TODO 过滤，如果没有pss的订单id不执行下面这句 带完善该业务
			returnsAnOrderToTheSpecifiedPlatform( String.valueOf(oid));
			log.info("----------平安承保接口调用返回更新数据库（HTTP_PAC_GZX_CB）：SUCCESS!!-----------");
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		log.info("----------平安承保接口调用（HTTP_PAC_GZX_CB）：end-----------");
		return flag;
	}

	/**
	 * 平安财-公责险-支付信息保存
	 * @param map
	 * @return
	 */
	@Override
	public boolean  PAC_GZX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = insInsuranceSlipService.getOrderFormVoByNoticeNo(map.get("businessNo"));
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			//设置交易流水号
			pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
			pvo.setOut_of_pocket(new BigDecimal(map.get("paymentSum")));
			pvo.setStart_time(DateUtil.convertString2Date(map.get("paymentDate")));
			pvo.setEnd_time(new Date());
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			//支付方式
			pvo.setPay_type(DictConst.PAY_TYPE_XS);
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_PAC_GZX_CB(Long.parseLong(dto.getOid()), map);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
		}catch (Exception e){
			log.error("平安团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	/**
	 * 平安财承保后，查询电子保单地址设置到数据库
	 */
	@Override
	public void HTTP_PAC_GZX_DZBD(Long oid, Map<String,String> map, OrderFormVo ofVo){
		try {
			String result = gZX_PACRequestService.requestPAC(oid,ConstProp.DIGIT_THREE, map);
			log.info("----------PAC-GZX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				return;
			}
			if (StringUtils.isEmpty(strs[1])) {
				return;
			}
			log.info("----------PAC-GZX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_id(String.valueOf(oid));
			//保存保单地址
			vo.setInsure_path(strs[1]);
			insTransactionService.savePolicyOther(vo);
			ofVo.setInsure_path(strs[1]);
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			}).start();
		}catch (Exception e){
			log.error("平安财公责险获取电子保单接口调用过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
	}

	/**
	 * 平安财-团意险-承保接口
	 * @param oid
	 * @param map
	 * @return
	 */
	@Override
	public boolean HTTP_PAC_TYX_CB(Long oid, Map<String,String> map){
		boolean flag = false;
		try {
			log.info("----------平安承保接口调用（HTTP_PAC_TYX_CB）：star-----------");
			if(StringUtils.isEmpty(map.get("policyNo"))){
				return flag;
			}
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(map.get("policyNo"));
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			String result = pACRequestService.requestPAC(oid,ConstProp.DIGIT_EIGHT, null);
			log.info("----------PA-TYX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				log.info("----------平安财承保接口调用返回（HTTP_PAC_TYX_CB）：FAIL!!-----------");
				log.info("----------平安财承保接口调用（HTTP_PAC_TYX_CB）：end-----------");
				return flag;
			}
			log.info("----------平安财承保接口调用返回（HTTP_PAC_TYX_CB）：SUCCESS!!-----------");
			if (StringUtils.isEmpty(strs[1])) {
				log.info("----------平安财承保接口调用返回保单号（HTTP_PAC_TYX_CB）：FAIL!!-----------");
				log.info("----------平安财承保接口调用（HTTP_PAC_TYX_CB）：end-----------");
				return flag;
			}
			log.info("----------PA-TYX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			//保存保单地址
			vo.setInsure_path(strs[1]);//保单地址
			insTransactionService.savePolicyOther(vo);
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------团意险推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------平安财承保接口调用返回更新数据库（HTTP_PAC_TYX_CB）：SUCCESS!!-----------");
			flag = true;
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("----------平安财承保接口调用（HTTP_PAC_TYX_CB）：end-----------");
		return flag;
	}

	/**
	 * 平安财-雇主责任险线下-承保接口
	 * @return
	 */
	@Override
	public boolean HTTP_PAC_GZZRX_CB(Long oid, String policyNo){
		boolean flag = false;
		try {
			log.info("----------平安承保接口调用（HTTP_PAC_GZZRX_CB）：star-----------");
			if(StringUtils.isEmpty(policyNo)){
				return flag;
			}
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(policyNo);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference_16(vo);
			String result = gZZRX_PACRequestService.requestPAC(oid,ConstProp.DIGIT_EIGHT, null);
			log.info("----------PAC-GZZRX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(ConstProp.CODE_SUCCESS.equals(strs[0])) {
				if (StringUtils.isNotEmpty(strs[1])) {
					//保存保单地址
					vo.setInsure_path(strs[1]);
					insTransactionService.savePolicyOther(vo);
				}
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------团意险推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------平安财承保接口调用返回更新数据库（HTTP_PAC_GZZRX_CB）：SUCCESS!!-----------");
			flag = true;
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("----------平安财承保接口调用（HTTP_PAC_GZZRX_CB）：end-----------");
		return flag;
	}

	/**
	 * 平安财-雇主责任险线上-承保接口
	 * @param oid
	 * @param map
	 * @return
	 */
	@Override
	public boolean HTTP_PAC_GZZRX_XS_CB(Long oid, Map<String,String> map){
		boolean flag = false;
		try {
			log.info("----------平安承保接口调用（HTTP_PAC_GZZRX_XS_CB）：star-----------");
			if(StringUtils.isEmpty(map.get("policyNo"))){
				return flag;
			}
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(map.get("policyNo"));
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			String result = gZZRX_PACRequestService.requestPAC(oid,ConstProp.DIGIT_EIGHT, null);
			log.info("----------PAC-GZZRX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				log.info("----------平安财承保接口调用返回（HTTP_PAC_GZZRX_XS_CB）：FAIL!!-----------");
				log.info("----------平安财承保接口调用（HTTP_PAC_GZZRX_XS_CB）：end-----------");
				return flag;
			}
			log.info("----------平安财承保接口调用返回（HTTP_PAC_GZZRX_XS_CB）：SUCCESS!!-----------");
			if (StringUtils.isEmpty(strs[1])) {
				log.info("----------平安财承保接口调用返回保单号（HTTP_PAC_GZZRX_XS_CB）：FAIL!!-----------");
				log.info("----------平安财承保接口调用（HTTP_PAC_GZZRX_XS_CB）：end-----------");
				return flag;
			}
			log.info("----------PAC-GZZRX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			//保存保单地址
			vo.setInsure_path(strs[1]);//保单地址
			insTransactionService.savePolicyOther(vo);
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------团意险推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------平安财承保接口调用返回更新数据库（HTTP_PAC_GZZRX_XS_CB）：SUCCESS!!-----------");
			flag = true;
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("----------平安财承保接口调用（HTTP_PAC_GZZRX_XS_CB）：end-----------");
		return flag;
	}

	/**
	 * 平安财-雇主责任险-电子保单接口
	 * @param dto oid
	 * @return
	 */
	@Override
	public void HTTP_PAC_GZZRX_DZBD(OrderFormVo dto){
		try {
			log.info("----------平安电子保单接口调用（HTTP_PAC_GZZRX_DZBD）：star-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			vo.setPolicy_id(dto.getOid());
			String result = gZZRX_PACRequestService.requestPAC(Long.parseLong(dto.getOid()),ConstProp.DIGIT_EIGHT, null);
			log.info("----------PA-GZZRX-PolicyDto-request(oid:"+dto.getOid()+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				log.info("----------平安财电子保单接口调用返回（HTTP_PAC_GZZRX_DZBD）：FAIL!!-----------");
				log.info("----------平安财电子保单接口调用（HTTP_PAC_GZZRX_DZBD）：end-----------");
				return;
			}
			log.info("----------平安财电子保单接口调用返回（HTTP_PAC_GZZRX_DZBD）：SUCCESS!!-----------");
			if (StringUtils.isEmpty(strs[1])) {
				log.info("----------平安财电子保单接口调用返回地址（HTTP_PAC_GZZRX_DZBD）：FAIL!!-----------");
				log.info("----------平安财电子保单接口调用（HTTP_PAC_GZZRX_DZBD）：end-----------");
				return;
			}
			log.info("----------PA-GZZRX-PolicyDto-request(oid:"+dto.getOid()+"，SUCCESS!!)-----------");
			//保存保单地址
			vo.setInsure_path(strs[1]);//保单地址
			dto.setInsure_path(strs[1]);
			insTransactionService.savePolicyOther(vo);
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(dto.getOid());
				} catch(Exception e) {
					log.error("------------团意险推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------平安财电子保单接口调用返回更新数据库（HTTP_PAC_GZZRX_DZBD）：SUCCESS!!-----------");
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("----------平安财电子保单接口调用（HTTP_PAC_GZZRX_DZBD）：end-----------");
	}

	/**
	 * 长安-雇主责任险-承保接口
	 * @param oid
	 * @return
	 */
	@Override
	public boolean HTTP_CA_GZZRX_CB(Long oid){
		boolean flag = false;
		try {
			log.info("----------长安承保接口调用（HTTP_CA_GZZRX_CB）：star-----------");
			if(oid == null){
				return flag;
			}
			String result = gZZRX_CARequestService.request_ca_gzzrx(oid, TransTypeEnum.CBQR.getValue(),null);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				log.info("----------长安承保接口调用返回（HTTP_CA_GZZRX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_GZZRX_CB）：end-----------");
				return flag;
			}
			if (StringUtils.isEmpty(strs[1])) {
				log.info("----------长安承保接口调用返回保单号（HTTP_CA_GZZRX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_GZZRX_CB）：end-----------");
				return flag;
			}
			log.info("----------CA-GZZRX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(strs[4])) {
				vo.setInsure_path(strs[4]);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------雇主险推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------长安承保接口调用返回更新数据库（HTTP_CA_GZZRX_CB）：SUCCESS!!-----------");
			flag = true;
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("----------长安承保接口调用（HTTP_CA_GZZRX_CB）：end-----------");
		return flag;
	}

	@Override
	public boolean BU_HTTP_CA_GZZRX_CB(Long oid,String policyNo,String eUrl){
		boolean flag = false;
		try {
			if(oid == null){
				return flag;
			}
			if (StringUtils.isEmpty(policyNo)) {
				return flag;
			}
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(policyNo);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(eUrl)) {
				vo.setInsure_path(eUrl);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
				}
			}).start();
			flag = true;
		}catch (Exception e){
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return flag;
	}

	/**
	 * 长安-雇主责任险-支付信息保存
	 * @param map
	 * @return
	 */
	@Override
	public boolean  CA_GZZRX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_CA_GZZRX_CB(Long.parseLong(dto.getOid()));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("平安财团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean BU_CA_GZZRX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(dto==null || StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = BU_HTTP_CA_GZZRX_CB(Long.parseLong(dto.getOid()),map.get("policyNo"),map.get("eUrl"));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("平安财团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	private String payTypeConV(String payType){
		if("Alipay".equals(payType)){
			return DictConst.PAY_TYPE_ZFB;
		}else if("wechat".equals(payType)){
			return DictConst.PAY_TYPE_WX;
		}else if("unionPay".equals(payType)){
			return DictConst.PAY_TYPE_YL;
		}else if("netSilver".equals(payType)){
			return DictConst.PAY_TYPE_WY;
		}else if("yeepay".equals(payType)){
			return DictConst.PAY_TYPE_XS;
		}else if("offlinepay".equals(payType)){
			return DictConst.PAY_TYPE_XX;
		}
		return "";
	}

	/**
	 * 长安-雇主责任险-承保接口
	 * @param oid
	 * @return
	 */
	@Override
	public boolean HTTP_CA_TYX_CB(Long oid){
		boolean flag = false;
		try {
			log.info("----------长安承保接口调用（HTTP_CA_TYX_CB）：star-----------");
			if(oid == null){
				return flag;
			}
			String result = tYX_CARequestService.request_ca_tyx(oid, TransTypeEnum.CBQR.getValue(),null);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				log.info("----------长安承保接口调用返回（HTTP_CA_TYX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_TYX_CB）：end-----------");
				return flag;
			}
			if (StringUtils.isEmpty(strs[1])) {
				log.info("----------长安承保接口调用返回保单号（HTTP_CA_TYX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_TYX_CB）：end-----------");
				return flag;
			}
			log.info("----------CA-TYX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(strs[4])) {
				vo.setInsure_path(strs[4]);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------雇主险推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------长安承保接口调用返回更新数据库（HTTP_CA_TYX_CB）：SUCCESS!!-----------");
			flag = true;
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("----------长安承保接口调用（HTTP_CA_TYX_CB）：end-----------");
		return flag;
	}

	@Override
	public boolean BU_HTTP_CA_TYX_CB(Long oid,String policyNo,String eUrl){
		boolean flag = false;
		try {
			if(oid == null){
				return flag;
			}
			if (StringUtils.isEmpty(policyNo)) {
				return flag;
			}
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(policyNo);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(eUrl)) {
				vo.setInsure_path(eUrl);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
				}
			}).start();
			flag = true;
		}catch (Exception e){
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return flag;
	}

	/**
	 * 长安-雇主责任险-支付信息保存
	 * @param map
	 * @return
	 */
	@Override
	public boolean  CA_TYX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_CA_TYX_CB(Long.parseLong(dto.getOid()));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("平安财团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean BU_CA_TYX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(dto==null || StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = BU_HTTP_CA_TYX_CB(Long.parseLong(dto.getOid()),map.get("policyNo"),map.get("eUrl"));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("平安财团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}


	/**
	 * 长安-个人意外险-承保接口
	 * @param oid
	 * @return
	 */
	@Override
	public boolean HTTP_CA_GYX_CB(Long oid){
		boolean flag = false;
		try {
			log.info("----------长安承保接口调用（HTTP_CA_GYX_CB）：star-----------");
			if(oid == null){
				return flag;
			}
			String result = gYX_CARequestService.request_ca_gyx(oid, TransTypeEnum.CBQR.getValue());
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				log.info("----------长安承保接口调用返回（HTTP_CA_GYX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_GYX_CB）：end-----------");
				return flag;
			}
			if (StringUtils.isEmpty(strs[1])) {
				log.info("----------长安承保接口调用返回保单号（HTTP_CA_GYX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_GYX_CB）：end-----------");
				return flag;
			}
			log.info("----------CA-GYX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(strs[4])) {
				vo.setInsure_path(strs[4]);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------个意险推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------长安承保接口调用返回更新数据库（HTTP_CA_GYX_CB）：SUCCESS!!-----------");
			flag = true;
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("----------长安承保接口调用（HTTP_CA_GYX_CB）：end-----------");
		return flag;
	}

	@Override
	public boolean BU_HTTP_CA_GYX_CB(Long oid,String policyNo,String eUrl){
		boolean flag = false;
		try {
			if(oid == null){
				return flag;
			}
			if (StringUtils.isEmpty(policyNo)) {
				return flag;
			}
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(policyNo);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(eUrl)) {
				vo.setInsure_path(eUrl);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
				}
			}).start();
			flag = true;
		}catch (Exception e){
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return flag;
	}

	/**
	 * 长安-雇主责任险-支付信息保存
	 * @param map
	 * @return
	 */
	@Override
	public boolean  CA_GYX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_CA_GYX_CB(Long.parseLong(dto.getOid()));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("长安个人意外险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean BU_CA_GYX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(dto==null || StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = BU_HTTP_CA_GYX_CB(Long.parseLong(dto.getOid()),map.get("policyNo"),map.get("eUrl"));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("长安个人意外险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	/**
	 * 长安-公众责任险-承保接口
	 * @param oid
	 * @return
	 */
	@Override
	public boolean HTTP_CA_GZX_CB(Long oid){
		boolean flag = false;
		try {
			log.info("----------长安承保接口调用（HTTP_CA_GZX_CB）：star-----------");
			if(oid == null){
				return flag;
			}
			String result = gZX_CARequestService.request_ca_gzx(oid, TransTypeEnum.CBQR.getValue());
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				log.info("----------长安承保接口调用返回（HTTP_CA_GZX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_GZX_CB）：end-----------");
				return flag;
			}
			if (StringUtils.isEmpty(strs[1])) {
				log.info("----------长安承保接口调用返回保单号（HTTP_CA_GZX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_GZX_CB）：end-----------");
				return flag;
			}
			log.info("----------CA-GZZRX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(strs[4])) {
				vo.setInsure_path(strs[4]);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------长安承保接口调用返回更新数据库（HTTP_CA_GZZRX_CB）：SUCCESS!!-----------");
			flag = true;
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("----------长安承保接口调用（HTTP_CA_GZZRX_CB）：end-----------");
		return flag;
	}

	@Override
	public boolean BU_HTTP_CA_GZX_CB(Long oid,String policyNo,String eUrl){
		boolean flag = false;
		try {
			if(oid == null){
				return flag;
			}
			if (StringUtils.isEmpty(policyNo)) {
				return flag;
			}
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(policyNo);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(eUrl)) {
				vo.setInsure_path(eUrl);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
				}
			}).start();
			flag = true;
		}catch (Exception e){
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return flag;
	}

	/**
	 * 长安-公众责任险-支付信息保存
	 * @param map
	 * @return
	 */
	@Override
	public boolean  CA_GZX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_CA_GZX_CB(Long.parseLong(dto.getOid()));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("长安公众责任险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean BU_CA_GZX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(dto==null || StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = BU_HTTP_CA_GZX_CB(Long.parseLong(dto.getOid()),map.get("policyNo"),map.get("eUrl"));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("长安公众责任险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}


	/**
	 * 长安-展会责任险-承保接口
	 * @param oid
	 * @return
	 */
	@Override
	public boolean HTTP_CA_ZZX_CB(Long oid){
		boolean flag = false;
		try {
			log.info("----------长安承保接口调用（HTTP_CA_ZZX_CB）：star-----------");
			if(oid == null){
				return flag;
			}
			String result = zZX_CARequestService.request_ca_zzx(oid, TransTypeEnum.CBQR.getValue());
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				log.info("----------长安承保接口调用返回（HTTP_CA_ZZX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_ZZX_CB）：end-----------");
				return flag;
			}
			if (StringUtils.isEmpty(strs[1])) {
				log.info("----------长安承保接口调用返回保单号（HTTP_CA_ZZX_CB）：FAIL!!-----------");
				log.info("----------长安承保接口调用（HTTP_CA_ZZX_CB）：end-----------");
				return flag;
			}
			log.info("----------CA-ZZX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(strs[4])) {
				vo.setInsure_path(strs[4]);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------长安承保接口调用返回更新数据库（HTTP_CA_ZZX_CB）：SUCCESS!!-----------");
			flag = true;
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		log.info("----------长安承保接口调用（HTTP_CA_ZZX_CB）：end-----------");
		return flag;
	}

	@Override
	public boolean BU_HTTP_CA_ZZX_CB(Long oid,String policyNo,String eUrl){
		boolean flag = false;
		try {
			if(oid == null){
				return flag;
			}
			if (StringUtils.isEmpty(policyNo)) {
				return flag;
			}
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(policyNo);
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			if (StringUtils.isNotEmpty(eUrl)) {
				vo.setInsure_path(eUrl);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
				}
			}).start();
			flag = true;
		}catch (Exception e){
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return flag;
	}

	/**
	 * 长安-展会责任险-支付信息保存
	 * @param map
	 * @return
	 */
	@Override
	public boolean  CA_ZZX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_CA_ZZX_CB(Long.parseLong(dto.getOid()));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("长安展会责任险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean BU_CA_ZZX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = getPolicyDtoByRcptNo(map.get("orderNo"));
			if(dto==null || StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
//			pvo.setStart_time(DateUtil.parseDate(map.get("payTime")));
			pvo.setEnd_time(DateUtil.convertStringToDate(map.get("payTime")));
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(payTypeConV(map.get("payType")));//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = BU_HTTP_CA_ZZX_CB(Long.parseLong(dto.getOid()),map.get("policyNo"),map.get("eUrl"));
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			if(!flag){
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			}
		}catch (Exception e){
			log.error("长安展会责任险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	/**
	 * 平安财-雇主责任险-支付信息保存
	 * @param map
	 * @return
	 */
	@Override
	public boolean  PAC_GZZRX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = insInsuranceSlipService.getOrderFormVoByNoticeNo(map.get("noticeNo"));
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(map.get("paymentSum")));
			pvo.setStart_time(new Date());
			pvo.setEnd_time(new Date());
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(DictConst.PAY_TYPE_XS);//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_PAC_GZZRX_XS_CB(Long.parseLong(dto.getOid()), map);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
		}catch (Exception e){
			log.error("平安财团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	/**
	 * 平安财-团意险-支付信息保存
	 * @param map
	 * @return
	 */
	@Override
	public boolean  PAC_TYX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = insInsuranceSlipService.getOrderFormVoByNoticeNo(map.get("noticeNo"));
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get("tradeNo"));//设置交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));// tradeNo
			pvo.setOut_of_pocket(new BigDecimal(map.get("paymentSum")));
			pvo.setStart_time(new Date());
			pvo.setEnd_time(new Date());
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(DictConst.PAY_TYPE_XS);//支付方式
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_PAC_TYX_CB(Long.parseLong(dto.getOid()), map);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
		}catch (Exception e){
			log.error("平安财团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	/**
	 * TODO 平安承保，查询保单号跟电子保单地址设置到数据库
	 */
	@Override
	public boolean HTTP_PAS_TYX_CB(Long oid, Map<String,String> map){
		boolean flag = true;
		try {
			log.info("----------平安承保接口调用（HTTP_PAS_TYX_CB）：star-----------");
			String result = pARequestService.requestPA(oid,"5", map);
			log.info("----------PAS-TYX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				flag = false;
				log.info("----------平安承保接口调用返回（HTTP_PAS_TYX_CB）：FAIL!!-----------");
				log.info("----------平安承保接口调用（HTTP_PAS_TYX_CB）：end-----------");
				return flag;
			}
			log.info("----------平安承保接口调用返回（HTTP_PAS_TYX_CB）：SUCCESS!!-----------");
			if (StringUtils.isEmpty(strs[1])) {
				flag = false;
				log.info("----------平安承保接口调用返回保单号（HTTP_PAS_TYX_CB）：FAIL!!-----------");
				log.info("----------平安承保接口调用（HTTP_PAS_TYX_CB）：end-----------");
				return flag;
			}
			log.info("----------PAS-TYX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);//policy.setExternalReference();
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			if(strs.length == 3){
				//保存保单地址
				vo.setInsure_path(strs[2]);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------平安承保接口调用返回更新数据库（HTTP_PAS_TYX_CB）：SUCCESS!!-----------");
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		log.info("----------平安承保接口调用（HTTP_PAS_TYX_CB）：end-----------");
		return flag;
	}

	@Override
	public boolean HTTP_PAS_TYX_CB_TEMPORARY(Long oid, Map<String,String> map){
		boolean flag = true;
		try {
			log.info("----------平安承保接口调用（HTTP_PAS_TYX_CB）：star-----------");
			String result = "200#"+map.get("policy");
			log.info("----------PAS-TYX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				flag = false;
				log.info("----------平安承保接口调用返回（HTTP_PAS_TYX_CB）：FAIL!!-----------");
				log.info("----------平安承保接口调用（HTTP_PAS_TYX_CB）：end-----------");
				return flag;
			}
			log.info("----------平安承保接口调用返回（HTTP_PAS_TYX_CB）：SUCCESS!!-----------");
			if (StringUtils.isEmpty(strs[1])) {
				flag = false;
				log.info("----------平安承保接口调用返回保单号（HTTP_PAS_TYX_CB）：FAIL!!-----------");
				log.info("----------平安承保接口调用（HTTP_PAS_TYX_CB）：end-----------");
				return flag;
			}
			log.info("----------PAS-TYX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);//policy.setExternalReference();
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			if(strs.length == 3){
				//保存保单地址
				vo.setInsure_path(strs[2]);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			}).start();
			log.info("----------平安承保接口调用返回更新数据库（HTTP_PAS_TYX_CB）：SUCCESS!!-----------");
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		log.info("----------平安承保接口调用（HTTP_PAS_TYX_CB）：end-----------");
		return flag;
	}

	@Override
	public boolean  PAS_TYX_SAVE_PAY_MSG(PingAnPayVo paVo){
		boolean flag;
		try {
			Map<String,String> map = MyConverUtil.PO2Map(paVo);
			OrderFormVo dto = getPolicyDtoByRcptNo(paVo.getRcptno());
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			String _dts = paVo.getBankTranDate() + " " + paVo.getBankTranTime();
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(paVo.getBankTradeNo());//交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
			pvo.setStart_time(DateUtil.convertString2Date(_dts));
			pvo.setEnd_time(new Date());
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(DictConst.PAY_TYPE_WX);
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_PAS_TYX_CB(Long.parseLong(dto.getOid()), map);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			log.info("支付请求："+paVo.toString());
		}catch (Exception e){
			log.error("平安团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean  PAS_TYX_SAVE_PAY_MSG_TEMPORARY(PingAnPayVo paVo){
		boolean flag;
		try {
			Map<String,String> map = MyConverUtil.PO2Map(paVo);
			OrderFormVo dto = getPolicyDtoByRcptNo(paVo.getRcptno());
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			String _dts = paVo.getBankTranDate() + " " + paVo.getBankTranTime();
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(paVo.getBankTradeNo());//交易流水号
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
			pvo.setStart_time(DateUtil.convertString2Date(_dts));
			pvo.setEnd_time(new Date());
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(DictConst.PAY_TYPE_WX);
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			//以下补充调承保查询接口
			flag = HTTP_PAS_TYX_CB_TEMPORARY(Long.parseLong(dto.getOid()), map);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
			log.info("支付请求："+paVo.toString());
		}catch (Exception e){
			log.error("平安团意险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	/**
	 * TODO 平安承保后，查询电子保单地址设置到数据库
	 */
	@Override
	public void HTTP_PAS_TYX_DZBD(Long oid, Map<String,String> map, OrderFormVo ofVo){
		try {
			String result = pARequestService.requestPA(oid,"6", map);
			log.info("----------PA-TYX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				return;
			}
			if (StringUtils.isEmpty(strs[1])) {
				return;
			}
			log.info("----------PA-TYX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_id(String.valueOf(oid));
			//保存保单地址
			vo.setInsure_path(strs[1]);//保单地址
			insTransactionService.savePolicyOther(vo);
			ofVo.setInsure_path(strs[1]);
			//电子保单地址推送第三方
			new Thread(()->{ //异步
				try {
					savePolicyUrlPush(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------电子保单地址推送SAAS，异常："+e.getMessage());
				}
			}).start();
		}catch (Exception e){
			log.error("平安团意险获取电子保单接口调用过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
	}

	/**
	 * TODO 平安对账承保
	 */
	@Override
	public void pa_reconciliation_underwrite(String rcptno, String p_policy_no){
		try {
			if(StringUtils.isEmpty(rcptno)||StringUtils.isEmpty(p_policy_no)){
				return;
			}
			OrderFormVo dto = getPolicyDtoByRcptNo(rcptno);
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(p_policy_no);//policy.setExternalReference();
			vo.setPolicy_id(dto.getOid());
			insTransactionService.savePolicyExternalReference(vo);
			/*if(strs.length == 3){
				//保存保单地址
				vo.setInsurePath(strs[2]);//保单地址
				insTransactionService.savePolicyOther(vo);
			}*/
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(dto.getOid());
				} catch(Exception e) {
					log.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			}).start();
		}catch (Exception e){
			log.error("平安团意险对账接口订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}

	}

	/**
	 * TODO 泰康承保，查询保单号跟电子保单地址设置到数据库
	 */
	@Override
	public void HTTP_TK_TYX_CB(Long oid) throws Exception{
		try {
			String result = tKRequestService.requestTK(oid,"02");
			log.info("----------TK-TYX-PolicyDto-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])||strs.length != 3) {
				return;
			}
			if (StringUtils.isEmpty(strs[1])) {
				return;
			}
			log.info("----------TK-TYX-PolicyDto-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);//policy.setExternalReference();
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			//保存保单地址
			vo.setInsure_path(strs[2]);//保单地址
			insTransactionService.savePolicyOther(vo);
			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
				} catch(Exception e) {
					log.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			}).start();
		}catch (Exception e){
			log.error("泰康承保接口订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
	}

	@Override
	public boolean HTTP_TPC_XYX_YX(Long oid) throws Exception{
		boolean flag = false;
		try {
			String result = xYX_TBRequestService.requestTB(oid, TransType.EPIC_YX_XW.getValue(), null);
			log.info("----------HTTP_TPC_XYX_YX-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(ConstProp.CODE_SUCCESS.equals(strs[0])) {
				flag = true;
				log.info("----------HTTP_TPC_XYX_YX-request(oid:"+oid+"，SUCCESS!!)-----------");
			}else{
				log.info("----------HTTP_TPC_XYX_YX-request(oid:"+oid+"，FAIL!!)-----------");
			}
		}catch (Exception e){
			log.error("太平财小微信用险影像接口订单更新过程事务发现异常，回滚数据",e);
		}
		return flag;
	}

	/**
	 * <b> 小微信用险太保承保接口，内涵获取电子保单接口调用 </b>
	 * @author ZXF
	 * @create 2018/05/30 0030 10:59
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public boolean HTTP_TPC_XYX_CB(Long oid) throws Exception{
		boolean flag = false;
		try {
			String result = xYX_TBRequestService.requestTB(oid,TransType.EPIC_CB_XW.getValue(), null);
			log.info("----------HTTP_TPC_XYX_CB-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])||strs.length <= 1) {
				return flag;
			}
			if (StringUtils.isEmpty(strs[1])) {
				return true;
			}
			log.info("----------HTTP_TPC_XYX_CB-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);//policy.setExternalReference();
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
//					HTTP_TPC_XYX_DZBD(oid);
			flag = true;
		}catch (Exception e){
			log.error("太平财承保接口订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return flag;
	}

	@Override
	public String HTTP_TPC_XYX_DZBD(Long oid){
		String path = ConstProp.BLANK_CHAR;
		try {
			String result = xYX_TBRequestService.requestTB(oid,TransType.EPIC_DZBD_XW.getValue(), null);
			log.info("----------HTTP_TPC_XYX_DZBD-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])||strs.length <= 1) {
				return path;
			}
			if (StringUtils.isEmpty(strs[1])) {
				return path;
			}
			log.info("----------HTTP_TPC_XYX_DZBD-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			vo.setPolicy_id(String.valueOf(oid));
			//保存保单地址
			vo.setInsure_path(strs[1]);//保单地址
			insTransactionService.savePolicyOther(vo);
			path = strs[1];
		}catch (Exception e){
			log.error("太平财小微信用险电子保单查询接口订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return path;
	}

	/**
	 * <b> 返回订单给指定平台，根据订单id获取用户平台信息从而走不同接口 </b>
	 * @author ZXF
	 * @create 2018/04/03 0003 10:39
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void returnsAnOrderToTheSpecifiedPlatform(String orderId){
		String userResult = getTPUserIDByOrderID(Long.parseLong(orderId));
		if(StringUtils.isEmpty(userResult)){
			return;
		}
		String[] ur = userResult.split(ConstProp.SEMICOLON);
		if(ur.length<=1){
			return;
		}
		if(ur[1].contains(ConstProp.ARS)){
			//如果团意险承保就推给百保盾
			if(!saveOrderInfo(orderId)){
				comTaskResidualAPIService.saveComTaskResidual("saveOrderInfo","团意险承保后推给百保盾","com.bcxin.ins.service.order.PolicyService",1,"String",orderId);
			}
			log.info("----------团意险推送百保盾（HTTP_TYX_CB）：SUCCESS!!-----------");
		}else if(ur[1].contains(ConstProp.SAAS)||ur[1].contains(ConstProp.PASP)){
			//如果团意险/雇主责任险承保就推给SAAS、PASP平台
			if(!saveOrderInfoPush(orderId)){
				comTaskResidualAPIService.saveComTaskResidual("saveOrderInfoPush","团意险/雇主责任险承保后推给SAAS、PASP平台","com.bcxin.ins.service.order.PolicyService",1,"String",orderId);
			}
			log.info("----------团意险/雇主责任险推送SAAS（HTTP_TYX_CB）：SUCCESS!!-----------");
		}else if(ur[1].contains(ConstProp.PSS)){
			//如果公责险承保就推给PSS平台
			if(!pushOrderToPSS(orderId)){
				comTaskResidualAPIService.saveComTaskResidual("pushOrderToPSS","公责险承保后推给PSS平台","com.bcxin.ins.service.order.PolicyService",1,"String",orderId);
			}
			log.info("----------公责险推送PSS（HTTP_GZX_CB）：SUCCESS!!-----------");
		}
	}

	/**
	 * 团意险查询待支付订单列表调泰康02查询保单接口获取保单号并保存（批量处理）
	 */
	@Override
	public void TYX_TK_02(){
		List<OrderFormVo> dtoList = selectInsOrderFormByStatusAndProductCode(ConstProp.DIGIT_FOUR,ConstProp.TYX_TK);
		log.info("----------TK-TYX-PolicyDto-select("+(dtoList != null ? dtoList.size() : "null")+")-----------");
		for(OrderFormVo dto : dtoList){
			if(StringUtils.isNotEmpty(dto.getProduct_code()) ? ConstProp.TYX.equals(dto.getProduct_code().split(ConstProp.MINUS)[0]) :false && StringUtils.isNotEmpty(dto.getPolicy_serial_number())&& StringUtils.isEmpty(dto.getInsure_path())){
				try {
					log.info("----------TK-TYX-PolicyDto-oid("+dto.getOid()+")-star-----------");
					HTTP_TK_TYX_CB(Long.parseLong(dto.getOid()));
					log.info("----------TK-TYX-PolicyDto-oid("+dto.getOid()+")-end-----------");
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 小微信用险查询待承保订单列表调太保承保接口获取保单号并保存（批量处理）
	 */
	@Override
	public void XYX_TB_CB(){
		List<OrderFormVo> dtoList = selectInsOrderFormByStatusAndProductCode(ConstProp.DIGIT_FIVE,ConstProp.XYX_XWCK);
		log.info("----------XYX_TB_CB-OrderFormVo-dtoList("+(dtoList != null ? dtoList.size() : "null")+")-----------");
		for(OrderFormVo dto : dtoList){
			if(ConstProp.DIGIT_ONE.equals(dto.getIs_send_yx())){
				try {
					log.info("----------XYX_TB_CB-PolicyDto-oid("+dto.getOid()+")-star-----------");
					HTTP_TPC_XYX_CB(Long.parseLong(dto.getOid()));
					log.info("----------XYX_TB_CB-PolicyDto-oid("+dto.getOid()+")-end-----------");
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}


	@Override
	public boolean  ZA_ZZX_SAVE_PAY_MSG(Map<String,String> map){
		boolean flag;
		try {
			OrderFormVo dto = insInsuranceSlipService.getOrderFormVoByTradeSerialNumber(map.get(CashierConstant.OUT_TRADE_NO));
			if(StringUtils.isNotEmpty(dto.getExternal_reference())){
				return true;
			}
			PolicyTransactionVo pvo= new PolicyTransactionVo();
			pvo.setTrade_serial_number(map.get(CashierConstant.RETURN_PAY_TRADE_NO));
			pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
			pvo.setOut_of_pocket(new BigDecimal(map.get(CashierConstant.AMT)));
			pvo.setStart_time(DateUtil.convertString2Date(map.get(CashierConstant.RETURN_PAY_TIME)));
			pvo.setEnd_time(new Date());
			pvo.setPayment_method(ConstProp.DIGIT_ONE);
			pvo.setPay_type(getPayType(map.get(CashierConstant.RETURN_PAY_CHANNEL)));
			pvo.setPolicy_id(dto.getOid());
			pvo.setTransaction_status(DictConst.PAY_STATUS_YZF);
			pvo.setPath_sign(ConstProp.DIGIT_ONE);
			pvo.setUser_id(Long.parseLong(dto.getUser_oid()));
			insTransactionService.saveTransaction(pvo);
			log.info("支付接口回调-callbackPay：接收成功-支付信息处理完成");
			// 以下补充调承保查询接口
			flag = HTTP_ZA_ZZX_CB(Long.parseLong(dto.getOid()), map);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理结果--------"+flag);
			log.info("支付接口回调-callbackPay：接收成功-承保信息处理完成");
		}catch (Exception e){
			log.error("众安展责险支付回调过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		return flag;
	}

	private String getPayType(String str){
		if("alipay".equals(str)){
			return ConstProp.DIGIT_ONE;
		}else if("wxpay".equals(str)){
			return ConstProp.DIGIT_TWO;
		}else if("unionpay".equals(str)||"unionpayB2B".equals(str)){
			return ConstProp.DIGIT_THREE;
		}
		return ConstProp.BLANK_CHAR;
	}

	/**
	 * TODO 众安承保，查询保单号跟电子保单地址设置到数据库
	 */
	@Override
	public boolean HTTP_ZA_ZZX_CB(Long oid, Map<String,String> map){
		boolean flag = true;
		try {
			log.info("----------众安承保接口调用（HTTP_ZA_ZZX_CB）：star-----------");
			String result = zARequestService.requestZA(oid,ConstProp.DIGIT_TWO, map);
			log.info("----------ZA-ZZX-request(oid:"+oid+"，"+result+")-----------");
			log.info("------------"+result);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(!ConstProp.CODE_SUCCESS.equals(strs[0])) {
				flag = false;
				log.info("----------众安承保接口调用返回（HTTP_ZA_ZZX_CB）：FAIL!!-----------");
				log.info("----------众安承保接口调用（HTTP_ZA_ZZX_CB）：end-----------");
				return flag;
			}
			log.info("----------众安承保接口调用返回（HTTP_ZA_ZZX_CB）：SUCCESS!!-----------");
			if (StringUtils.isEmpty(strs[1])) {
				flag = false;
				log.info("----------众安承保接口调用返回保单号（HTTP_ZA_ZZX_CB）：FAIL!!-----------");
				log.info("----------众安承保接口调用（HTTP_ZA_ZZX_CB）：end-----------");
				return flag;
			}
			log.info("----------ZA-ZZX-request(oid:"+oid+"，SUCCESS!!)-----------");
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(strs[1]);//policy.setExternalReference();
			vo.setPolicy_id(String.valueOf(oid));
			insTransactionService.savePolicyExternalReference(vo);
			if(strs.length == 3){
				//保存保单地址
				vo.setInsure_path(strs[2]);//保单地址
				insTransactionService.savePolicyOther(vo);
			}
			/*InsInsuranceSlip order = insInsuranceSlipService.selectById(oid);
			SysClientUser user = clientUserService.selectById(order.getRegister_user_id());
			log.info("----------平安承保接口调用返回更新数据库-Web_type（policyZA_underwriting）："+user.getWeb_type()+"-----------");
			if("ARS-NC,ARS-SX,ARS-ZZ,ARS-KF".indexOf(user.getWeb_type())!=-1){
				//如果团意险承保就推给百保盾
				saveOrderInfo(String.valueOf(oid));
				log.info("----------平安承保接口调用返回更新数据库并推送百保盾（HTTP_PAS_TYX_CB）：SUCCESS!!-----------");
			}*/
			//TODO 以下判断是否将信息传给业务支撑
			pushZZXOrderToYWZC(String.valueOf(oid));
			log.info("----------众安承保接口调用返回更新数据库（HTTP_ZA_ZZX_CB）：SUCCESS!!-----------");
		}catch (Exception e){
			log.error("订单承保接口请求过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			flag = false;
		}
		log.info("----------众安承保接口调用（HTTP_ZA_ZZX_CB）：end-----------");
		return flag;
	}

	/**
	 * 华泰公责险保存支付信息并请求接口做核保承保，完成后推送PSS
	 * @param orderNo
	 * @param transactionNo
	 */
	@Override
	public void HTTP_HT_GZX_HBCB(String orderNo,String transactionNo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.getInsOrderForm(orderNo);

		List<InsTransaction> list= insInsuranceSlip.getInsTransaction();
		InsTransaction transaction=null;
		if(list!=null&&list.size()>0){
			transaction=list.get(0);
		}

		log.info("华泰对接订单号orderNo" + orderNo);
		if (!DictConst.PAY_STATUS_WZF.equals(transaction.getTransaction_status())) {
			return;
		}
		try {
			transaction.setPay_order_number(transactionNo);
			transaction.setPay_type(DictConst.PAY_TYPE_ZFB);
			transaction.setTransaction_status(DictConst.PAY_STATUS_YZF);
			transaction.setOut_of_pocket(transaction.getPay_amount());//实际支付
			transaction.setTrade_serial_number(IdWorker.getId() + ConstProp.BLANK_CHAR);//交易单号
			transaction.setPath_sign(ConstProp.DIGIT_ONE);//期数 为1
			//				transaction.setChannel("ht-policy");
			insTransactionService.updateById(transaction);
			log.info("与华泰投保对接开始-----------");

			insInsuranceSlip.setOrder_status(DictConst.ORDER_STATUS_YCB);
			insInsuranceSlip.setUpdate_time(new Date());
			insInsuranceSlip.setEnd_time(new Date());
			SpecialPublicDutyVo policyExtra = accordingToOrderIDToGetSpecialPublicDutyVo(insInsuranceSlip.getIns_insurance_slip_id());
			String result = htPolicyService.insureInvoke(insInsuranceSlip, policyExtra, transaction);
			if (StringUtils.isEmpty(result)) {
				log.info("与华泰投保对接失败：投保失败：返回结果为空");
				return;
			}
			Map<String, String> map = HttpUtil.getMapValue(result);
			PolicyTransactionVo vo = new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(map.get("policyNO"));//policy.setExternalReference();
			vo.setPolicy_id(insInsuranceSlip.getIns_insurance_slip_id() + ConstProp.BLANK_CHAR);
			insTransactionService.savePolicyExternalReference(vo);
			insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
			if (!ConstProp.BLANK_CHAR.equals(map.get("policyURL"))) {
				//保存保单地址
				vo.setInsure_path(map.get("policyURL"));//保单地址
				insTransactionService.savePolicyOther(vo);
			}

			//返回订单给指定平台
			new Thread(()->{ //异步
				try {
					//返回订单给指定平台
					log.info("华泰承保完成，推送PSS---------STAR--------");
					returnsAnOrderToTheSpecifiedPlatform(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
				} catch(Exception e) {
					log.error("------------华泰承保完成，推送PSS，异常："+e.getMessage());
				}
			}).start();
		} catch (Exception e) {
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			e.printStackTrace();
		}
	}

	@Override
	public List<OrderFormVo> selectInsOrderFormByStatusAndProductCode( String status, String productCode){
		return insInsuranceSlipService.selectInsOrderFormByStatusAndProductCode(status,productCode);
	}


	/**
	 *
	 * 保存订单交易表
	 * @param vo
	 */
	@Override
	public void saveTransaction(PolicyTransactionVo vo) {
		try {
			insTransactionService.saveTransaction(vo);
		}catch (Exception e){
			log.error("订单交易记录更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
	}

	/**
	 *
	 * 保存保单  工程
	 * @param vo
	 */
	@Override
	public void saveExternalReference(PolicyTransactionVo vo) {
		try {
			insTransactionService.savePolicyExternalReference(vo);
		}catch (Exception e){
			log.error("订单保单保存过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
	}

	/**
	 *
	 * 保存其他上传凭证
	 * @param vo
	 */
	@Override
	public void savePolicyOther(PolicyTransactionVo vo) {
		try {
			insTransactionService.savePolicyOther(vo);
		}catch (Exception e){
			log.error("订单其它凭证更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
	}

	/**
	 *
	 * 诉讼支付上传凭证时创建或更新交易信息表
	 * @param policyID
	 * @param payOrderUrl
	 */
	@Override
	public boolean saveOrUpdateTransaction_ss(String policyID, String payOrderUrl, String payAmount, String path_sign) {
		try {
			if(StrUtil.isBlank(policyID) || StrUtil.isBlank(payOrderUrl)){
				return false;
			}
			if(StrUtil.isBlank(payAmount)){
				payAmount = ConstProp.DIGIT_ZERO;
			}
			String orderID = uploadPayMentFileToTranction(payOrderUrl, policyID, path_sign, payAmount);
			if(StrUtil.isNotBlank(orderID)){
				OrderFormVo vo = new OrderFormVo();
				vo.setOid(orderID);
				vo.setPolicy_status(ConstProp.DIGIT_FIVE);
				updateOrderFormStatus(vo);
				return true;
			}
		}catch (Exception e){
			log.error("诉讼订单更新交易信息过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return false;
	}

	@Override
	public void downloadAttachment(String path, String name, HttpServletResponse response) {
		try {
			response.reset();
			response.setHeader(ConstProp.CONTENT_DISPOSITION, "attachment; filename="+new String(name.getBytes(ConstProp.ENCODE_GBK),ConstProp.ENCODE_ISO_8859_1) + ".pdf");
			response.setContentType(ConstProp.CT_OCTET_STREAM);
			long fileLength = new File(path).length();
			response.setHeader(ConstProp.CONTENT_LENGTH, String.valueOf(fileLength));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		try(BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path));
			BufferedOutputStream bos = new BufferedOutputStream(response.getOutputStream());) {
			byte[] buff = new byte[2048];
			int bytesRead;
			while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
				bos.write(buff, 0, bytesRead);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@Override
	public String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode,String trade_serial_number){
		Map<String, Object> map = createOrderFormByProductOid(product_id, user_id, recommendCode,trade_serial_number);
		if(map.get(ConstProp.ORDER_ID) != null){
			return (String)map.get(ConstProp.ORDER_ID);
		}
		return ConstProp.BLANK_CHAR;
	}

	/****************************BUILD*******************************/


	/**
	 * <b>投标险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainSpecialBidVoSetUp(SpecialBidVo vo) {
		Map<String,Object> map = new HashMap<String,Object>();
		if(StrUtil.isBlank(vo.getOid())){
			return null;
		}
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getRecommend_code())){
			insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
		}
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date()+ConstProp.DAY_00);
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date() + ConstProp.DAY_23);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		if(StringUtils.isEmpty(vo.getAptitude_level())){
			vo.setAptitude_level(" ");
		}
		insSpecialBidService.accordingToTheSpecialBidVoSetUpInsSpecialBid(vo, insInsuranceSlip.getSpecial_id());
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		if(StrUtil.isNotBlank(vo.getInsured_amount())){
			insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(vo.getInsured_amount()), insInsuranceSlip);
		}
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	@Override
	public ResultDto pendingSpecialBidPolicy(SpecialBidVo vo, String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = null;
			try {
				map = obtainSpecialBidVoSetUp(vo);
			}catch (Exception e){
				e.printStackTrace();
			}
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("投标订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>根据订单id查询投标信息设置到SpecialBidVo   GET METHOD</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialBidVo accordingToOrderIDToGetSpecialBidVo(Long order_id) {
		SpecialBidVo vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new SpecialBidVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),order_id));

		insSpecialBidService.getSpecialBidVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		if(StringUtils.isNotEmpty(vo.getBid_time())){
			vo.setBid_time(vo.getBid_time().replace(ConstProp.DAY_00,ConstProp.BLANK_CHAR));
		}
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date().replace(ConstProp.DAY_23,ConstProp.BLANK_CHAR));
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date().replace(ConstProp.DAY_23,ConstProp.BLANK_CHAR));
		}
		return vo;
	}

	/**
	 * <b>履约特殊字段信息表接收页面传回的值（CommonExportVo_1）   SET METHOD</b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainSpecialPerformanceVo_1SetUp(SpecialPerformanceVo_1 vo) {
		Map<String,Object> map = null;
		if(StrUtil.isBlank(vo.getOid())){
			return map;
		}
		map = new HashMap<String,Object>();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getRecommend_code())){
			insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_1SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	@Override
	public ResultDto pendingSpecialPerformance_1VoPolicy(SpecialPerformanceVo_1 vo,String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = null;
			try {
				map = obtainSpecialPerformanceVo_1SetUp(vo);
			}catch (Exception e){
				e.printStackTrace();
			}
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("履约页一订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	@Override
	public Map<String, Object> obtainSpecialPerformanceVo_2SetUp(SpecialPerformanceVo_2 vo) {
		Map<String,Object> map = null;
		if(StrUtil.isBlank(vo.getOid())){
			return map;
		}
		map = new HashMap<String,Object>();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date()+ConstProp.DAY_00);
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date() + ConstProp.DAY_23);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_2SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
		if(vo.getRoleSubjectList().size()>0){
			if(StrUtil.isNotBlank(vo.getRoleSubjectList().get(0).getTurnover_export())){
				insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(vo.getRoleSubjectList().get(0).getTurnover_export()), insInsuranceSlip);
			}
		}
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	@Override
	public ResultDto pendingSpecialPerformance_2VoPolicy(SpecialPerformanceVo_2 vo){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			Map<String, Object> map = obtainSpecialPerformanceVo_2SetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("履约页二订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>履约特殊字段信息表接收页面传回的值（SpecialPerformanceVo_3）   SET METHOD</b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainSpecialPerformanceVo_3SetUp(SpecialPerformanceVo_3 vo) {
		Map<String,Object> map = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			map = new HashMap<String,Object>();
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_3SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
			map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		}
		return map;
	}

	@Override
	public ResultDto pendingSpecialPerformance_3VoPolicy(SpecialPerformanceVo_3 vo){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			Map<String, Object> map = obtainSpecialPerformanceVo_3SetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("履约页三订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>根据订单id查询履约特殊字段信息设置到SpecialPerformanceVo_1  GET METHOD</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialPerformanceVo_1 accordingToOrderIDToGetSpecialPerformanceVo_1(Long order_id) {
		SpecialPerformanceVo_1 vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new SpecialPerformanceVo_1();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),order_id));

		insSpecialPerformanceService.getSpecialPerformanceVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}

	/**
	 * <b>根据订单id查询履约特殊字段信息设置到SpecialPerformanceVo_2  GET METHOD</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialPerformanceVo_2 accordingToOrderIDToGetSpecialPerformanceVo_2(Long order_id) {
		SpecialPerformanceVo_2 vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new SpecialPerformanceVo_2();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insSpecialPerformanceService.getSpecialPerformanceVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date().replace(ConstProp.DAY_00,ConstProp.BLANK_CHAR));
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date().replace(ConstProp.DAY_23,ConstProp.BLANK_CHAR));
		}
		return vo;
	}

	/**
	 * <b>根据订单id查询履约特殊字段信息设置到SpecialPerformanceVo_3  GET METHOD</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialPerformanceVo_3 accordingToOrderIDToGetSpecialPerformanceVo_3(Long order_id) {
		SpecialPerformanceVo_3 vo = null;
		if(StrUtil.isNotBlank(String.valueOf(order_id))){
			vo = new SpecialPerformanceVo_3();
			MailPolicyVo voMP = new MailPolicyVo();
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
			vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
			insSpecialPerformanceService.getSpecialPerformanceVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		}
		return vo;
	}



	/****************************LAWSUIT*******************************/

	/**
	 * <b>接收SpecialLitigationVo_1进行设置更新数据插入相关表 </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainSpecialLitigationVo_1SetUp(SpecialLitigationVo_1 vo) {
		Map<String,Object> map = null;
		if(StrUtil.isBlank(vo.getOid())){
			return map;
		}
		map = new HashMap<String,Object>();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		specialLitigationService.accordingToTheSpecialLitigationVo_1SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
		if(vo.getRoleSubjectList().size()>0){
			if(StrUtil.isNotBlank(vo.getRoleSubjectList().get(0).getTurnover_export())){
				insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(vo.getRoleSubjectList().get(0).getTurnover_export()), insInsuranceSlip);
			}
		}
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	@Override
	public ResultDto pendingSpecialLitigation_1VoPolicy(SpecialLitigationVo_1 vo, String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = obtainSpecialLitigationVo_1SetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("诉讼页一订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}
	/**
	 * <b>接收SpecialLitigationVo_2进行设置更新数据插入相关表 </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainSpecialLitigationVo_2SetUp(SpecialLitigationVo_2 vo) {
		Map<String,Object> map = null;
		if(StrUtil.isBlank(vo.getOid())){
			return map;
		}
		map = new HashMap<String,Object>();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date()+ConstProp.DAY_00);
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date() + ConstProp.DAY_23);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		specialLitigationService.accordingToTheSpecialLitigationVo_2SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	@Override
	public ResultDto pendingSpecialLitigation_2VoPolicy(SpecialLitigationVo_2 vo){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			Map<String, Object> map = obtainSpecialLitigationVo_2SetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("诉讼页二订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>接收SpecialLitigationVo_3进行设置更新数据插入相关表 </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2037年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainSpecialLitigationVo_3SetUp(SpecialLitigationVo_3 vo) {
		Map<String,Object> map = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			map = new HashMap<String,Object>();
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			specialLitigationService.accordingToTheSpecialLitigationVo_3SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
			map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		}
		return map;
	}

	@Override
	public ResultDto pendingSpecialLitigation_3VoPolicy(SpecialLitigationVo_3 vo){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if ( userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			Map<String, Object> map = obtainSpecialLitigationVo_3SetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("诉讼页三订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>根据订单id获取投保单信息SpecialLitigationVo_1 </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialLitigationVo_1 accordingToOrderIDToGetSpecialLitigationVo_1(Long order_id) {
		SpecialLitigationVo_1 vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new SpecialLitigationVo_1();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),order_id));

		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		specialLitigationService.getSpecialLitigationVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}
	/**
	 * <b>根据订单id获取投保单信息SpecialLitigationVo_2 </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialLitigationVo_2 accordingToOrderIDToGetSpecialLitigationVo_2(Long order_id) {
		SpecialLitigationVo_2 vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new SpecialLitigationVo_2();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		specialLitigationService.getSpecialLitigationVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		MailPolicyVo voMP = new MailPolicyVo();
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date().replace(ConstProp.DAY_00,ConstProp.BLANK_CHAR));
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date().replace(ConstProp.DAY_23,ConstProp.BLANK_CHAR));
		}
		return vo;
	}
	/**
	 * <b>根据订单id获取投保单信息SpecialLitigationVo_3 </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午3:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialLitigationVo_3 accordingToOrderIDToGetSpecialLitigationVo_3(Long order_id) {
		SpecialLitigationVo_3 vo = null;
		if(StrUtil.isNotBlank(String.valueOf(order_id))){
			vo = new SpecialLitigationVo_3();
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
			vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
			specialLitigationService.getSpecialLitigationVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		}
		return vo;
	}

	/**
	 * <b>根据第三方当事人id请求删除对应条目</b>
	 *
	 * @param lna_id 第三方当事人
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean deleteLnAccusedByOid(String lna_id){
		boolean flag = false;
		if(StrUtil.isNotBlank(lna_id)){
			try{
				LnAccused lnAccused = lnAccusedAPIService.selectById(Long.parseLong(lna_id));
				if(lnAccused != null){
					lnAccusedAPIService.deleteById(lnAccused.getLn_accused_id());
					flag = true;
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}
		return flag;
	}


	/****************************GMR*******************************/


	/**
	 * <b>投标险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainGMRPolicyVoSetUp(GMRPolicyVo vo) {
		Map<String,Object> map = new HashMap<String,Object>();
		if(StrUtil.isBlank(vo.getOid())){
			return null;
		}
		try {
			log.info("团意险订单数据处理开始---------------------");
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			if(StringUtils.isNotEmpty(vo.getRecommend_code())){
				insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
			}
			if(StringUtils.isNotEmpty(vo.getInception_date())){
				insInsuranceSlip.setInception_date(DateUtil.convertString2Date(vo.getInception_date()+ConstProp.DAY_00));
			}
			if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
				insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date(vo.getPlanned_end_date()+ConstProp.DAY_23));
			}
			insInsuranceSlip.setIs_contain_repo(vo.getIs_contain_repo());
			insInsuranceSlip.setAccredit_path(vo.getAccredit_path());
			insInsuranceSlipService.updateById(insInsuranceSlip);
			vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
			log.info("团意险订单人员过滤开始---------------------");
			log.info("团意险订单人员初始数据,vo.getRoleSubjectList():"+vo.getRoleSubjectList().size());
			//过滤被保险人中无证件号的条目
			List<RoleSubjectVo> voList = Lists.newArrayList();
			for(RoleSubjectVo rvo : vo.getRoleSubjectList()){
				if(ConstProp.DIGIT_ONE.equals(rvo.getKind())){
					voList.add(rvo);
				}else{
					if(StringUtils.isNotEmpty(rvo.getOrganization_code())||StringUtils.isNotEmpty(rvo.getName_cn())||StringUtils.isNotEmpty(rvo.getMobile())||StringUtils.isNotEmpty(rvo.getBirth_date())){
						voList.add(rvo);
					}
				}
			}
			log.info("团意险订单人员过滤后数据,voList:"+voList);
			log.info("团意险订单人员过滤结束---------------------");
			log.info("团意险订单人员更新数据库开始---------------------");
			if(insInsuranceSlip.getSpecial_id() != null){
				specialExhibitionAPIService.accordingToTheSpecialExhibitionVoSetUpSpecialExhibition(vo.getSpecialExhibitionVo(), insInsuranceSlip.getSpecial_id());
			}
			insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(voList, insInsuranceSlip.getIns_insurance_slip_id());
			log.info("团意险订单人员更新数据库结束---------------------");
			insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
			insInsuranceSlipService.setPremiumAndCoverageByOrderID(insInsuranceSlip);
		}catch (Exception e){
			log.error("团意险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	@Override
	public ResultDto pendingGMRPolicyVoPolicy(GMRPolicyVo vo, String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if (  userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			//过滤重复投保身份证
			ResultDto r = isDuplicateIdCardNoToRoleSubject(vo.getRoleSubjectList().get(0).getName_cn(),vo.getRoleSubjectList());
			if(r != null){
				return r;
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = obtainGMRPolicyVoSetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("团意险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	private ResultDto isDuplicateIdCardNoToRoleSubject(String appName,List<RoleSubjectVo> list){
		String[] idcards  = new String[list.size()];
		int count = 0;
		for(RoleSubjectVo rvo : list){
			if(!ConstProp.DIGIT_ONE.equals(rvo.getKind())){
				if(StringUtils.isNotEmpty(rvo.getOrganization_code())){
					idcards[count] = rvo.getOrganization_code();
					count ++;
				}
			}
		}
		String str = insPreservationResultSetAPIService.findDuplicateIdCardNo(appName,"TYX",idcards);
		if(StringUtils.isNotEmpty(str)){
			return new ResultDto("部分证件号已在保，无法重复投保："+str, ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return null;
	}

	@Override
	public GMRPolicyVo accordingToOrderIDToGetGMRPolicyVo(Long order_id) {
		GMRPolicyVo vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new GMRPolicyVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		if(insInsuranceSlip.getPlanned_end_date() != null){
			vo.setPlanned_end_date(DateUtil.convertDateToString(insInsuranceSlip.getPlanned_end_date(),DateUtil.FORMAT2));
		}
		vo.setAccredit_path(insInsuranceSlip.getAccredit_path());
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setIs_contain_repo(insInsuranceSlip.getIs_contain_repo());
		//查询被保险人条目，如果少于3条补齐
		List<RoleSubjectVo> list = insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id());
		if(list.size()<4){
			int v = 4-list.size();
			RoleSubjectVo rvo = new RoleSubjectVo();
			rvo.setKind(ConstProp.DIGIT_TWO);
			rvo.setMajor_group(ConstProp.DIGIT_ONE);
			for(int i = 0; i<v; i++){
				list.add(rvo);
			}
		}
		vo.setRoleSubjectList(list);
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		if(insInsuranceSlip.getSpecial_id() != null){
			SpecialExhibitionVo seVo = new SpecialExhibitionVo();
			specialExhibitionAPIService.getSpecialExhibitionVoByPolicyID2(seVo, insInsuranceSlip.getSpecial_id());
			vo.setSpecialExhibitionVo(seVo);
		}

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),order_id));

		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}

	/**
	 * <b> 如果有固化保障用固化保障，没有就取产品当前保障 (保单详情查询都得携带固化保障信息) </b>
	 * @author ZXF
	 * @create 2023/12/29 0029 16:13
	 * @version
	 * @注意事项 </b>
	 */
	private List<ResponsibilityVo> findResponsibilityVoList(String product_id,Long order_id) {
		InsAgreement insAgreement = insAgreementAPIService.selectInsAgreementByInsInsuranceSlip(order_id);
		String responsibility_ids = "";
		if(insAgreement != null){
			responsibility_ids = insAgreement.getResponsibility_ids();
		}
		return insProductResponsibilityAPIService.findResponsibilityVoListByResponsibilityIds(product_id,responsibility_ids);

	}

	/****************************GZZRX*******************************/


	/**
	 * <b>雇主责任险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainSpecialHirelingVoSetUp(SpecialHirelingVo vo) {
		Map<String,Object> map = new HashMap<String,Object>();
		if(StrUtil.isBlank(vo.getOid())){
			return null;
		}
		try {
			log.info("雇主责任险订单数据处理开始---------------------");
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			if(StringUtils.isNotEmpty(vo.getRecommend_code())){
				insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
			}
			OrderFormVo order = accordingToOrderIDToGetPolicyDto(insInsuranceSlip.getIns_insurance_slip_id());
			String inception_long = "";
			if(StringUtils.isNotEmpty(vo.getInception_date())){
				if(order.getProduct_code().contains(ConstProp.GZZRX_CA_DQ)){
					//有短期险产品的走这个计算保障区间
					insInsuranceSlip.setInception_date(DateUtil.convertString2Date(vo.getInception_date()+ConstProp.DAY_00));
					insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date(DateUtil.dateAdd(3,DateUtil.dateAdd(2,vo.getInception_date(),1),-1)+ConstProp.DAY_23));
				}else {
					if (StringUtils.isNotEmpty(vo.getInception_type())&&vo.getInception_type().contains(ConstProp.INCEPTION_TYPE_MONTH)) {
						//如果按月类型才需要设置月度数
						inception_long = vo.getInception_long();
						//保障类型 按月
						insInsuranceSlip.setInception_date(DateUtil.convertString2Date(vo.getInception_date() + ConstProp.DAY_00));
						insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date(DateUtil.dateAdd(3, DateUtil.dateAdd(2, vo.getInception_date(), Integer.parseInt(vo.getInception_long())), -1) + ConstProp.DAY_23));
					} else {
						//保障类型 按年
						insInsuranceSlip.setInception_date(DateUtil.convertString2Date(vo.getInception_date() + ConstProp.DAY_00));
						insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date(DateUtil.dateAdd(3, DateUtil.dateAdd(1, vo.getInception_date(), 1), -1) + ConstProp.DAY_23));
					}
				}
			}
			if(StringUtils.isNotEmpty(vo.getInception_type())){
				insInsuranceSlip.setInception_type(vo.getInception_type());
			}
			insInsuranceSlip.setInception_long(inception_long);
			insInsuranceSlip.setDispute(vo.getDispute());
			insInsuranceSlip.setArbitral_institution(vo.getArbitral_institution());
			insInsuranceSlip.setIs_contain_repo(vo.getIs_contain_repo());
			if(StringUtils.isNotEmpty(vo.getPremium())){
				insInsuranceSlip.setPremium(new BigDecimal(vo.getPremium()));
			}
			if(StringUtils.isNotEmpty(vo.getInsured_amount())){
				insInsuranceSlip.setInsured_amount(new BigDecimal(vo.getInsured_amount()));
			}
			insInsuranceSlipService.updateById(insInsuranceSlip);
			insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
			hirelingAPIService.accordingToTheHirelingVoSetUpHireling(vo, insInsuranceSlip.getIns_insurance_slip_id());
			insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		}catch (Exception e){
			log.error("雇主责任险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	@Override
	public ResultDto pendingSpecialHirelingVoPolicy(SpecialHirelingVo vo, String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if (  userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			//过滤重复投保身份证
			ResultDto r = isDuplicateIdCardNoToHireling(vo.getRoleSubjectList().get(0).getName_cn(),vo.getHirelingVoList());
			if(r != null){
				return r;
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = obtainSpecialHirelingVoSetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("雇主责任险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	private ResultDto isDuplicateIdCardNoToHireling(String appName,List<HirelingVo> list){
		String[] idcards  = new String[list.size()];
		int count = 0;
		for(HirelingVo hvo : list){
			if(StringUtils.isNotEmpty(hvo.getId_card())){
				idcards[count] = hvo.getId_card();
				count ++;
			}
		}
		String str = insPreservationResultSetAPIService.findDuplicateIdCardNo(appName,"GZZRX",idcards);
		if(StringUtils.isNotEmpty(str)){
			return new ResultDto("部分证件号已在保，无法重复投保："+str, ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return null;
	}

	@Override
	public SpecialHirelingVo accordingToOrderIDToGetSpecialHirelingVo(Long order_id) {
		SpecialHirelingVo vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new SpecialHirelingVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		vo.setInception_type(insInsuranceSlip.getInception_type());
		vo.setInception_long(insInsuranceSlip.getInception_long());
		vo.setDispute(insInsuranceSlip.getDispute());
		vo.setArbitral_institution(insInsuranceSlip.getArbitral_institution());
		vo.setPremium(String.valueOf(insInsuranceSlip.getPremium()));
		vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
		vo.setIs_contain_repo(insInsuranceSlip.getIs_contain_repo());
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),order_id));

		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		hirelingAPIService.getSpecialHirelingVoByOrderID(vo, insInsuranceSlip.getIns_insurance_slip_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}

	/****************************AFR*******************************/


	/**
	 * <b>公责险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainSpecialPublicDutyVoSetUp(SpecialPublicDutyVo vo) {
		Map<String,Object> map = new HashMap<String,Object>();
		if(StrUtil.isBlank(vo.getOid())){
			return null;
		}
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			if(!vo.getInception_date().contains(ConstProp.DAY_00)){
				vo.setInception_date(vo.getInception_date()+ConstProp.DAY_00);
			}
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			if(!vo.getPlanned_end_date().contains(ConstProp.DAY_23)){
				vo.setPlanned_end_date(vo.getPlanned_end_date()+ConstProp.DAY_23);
			}
		}
		try {
			if(StringUtils.isNotEmpty(vo.getInsured_amount())){
				vo.setInsured_amount(Integer.parseInt(vo.getInsured_amount())*10000+"");
			}
			MyConverUtil.map2PO( MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		specialPublicDutyService.accordingToTheSpecialPublicDutyVoSetUpSpecialPublicDuty(vo, insInsuranceSlip.getSpecial_id());
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	@Override
	public ResultDto pendingSpecialPublicDutyVoPolicy(SpecialPublicDutyVo vo, String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if (  userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = obtainSpecialPublicDutyVoSetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("公责险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	@Override
	public SpecialPublicDutyVo accordingToOrderIDToGetSpecialPublicDutyVo(Long order_id) {
		SpecialPublicDutyVo vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new SpecialPublicDutyVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		if(insInsuranceSlip.getPlanned_end_date() != null){
			vo.setPlanned_end_date(DateUtil.convertDateToString(insInsuranceSlip.getPlanned_end_date(),DateUtil.FORMAT2));
		}
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),order_id));

		specialPublicDutyService.getSpecialPublicDutyVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}

	/****************************ZZX*******************************/

	/**
	 * <b>展责险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainLOTEPolicyVoSetUp(LOTEPolicyVo vo) {
		Map<String,Object> map = new HashMap<String,Object>();
		if(StrUtil.isBlank(vo.getOid())){
			return null;
		}
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		if(StringUtils.isNotEmpty(vo.getRecommend_code())){
			insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
			if(insInsuranceSlip.getInsured_amount() == null || insInsuranceSlip.getInsured_amount().compareTo(BigDecimal.ONE)<0 ){//设置保险金额
				insInsuranceSlip.setInsured_amount(setInsuredAmountByProductId(insInsuranceSlip.getPro_primary().getPro_primary_id()));
			}
			if(vo.getSpecialExhibitionVo() != null){
				if(StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getStar_time())){
					insInsuranceSlip.setInception_date(DateUtil.convertString2Date(vo.getSpecialExhibitionVo().getStar_time()+ConstProp.DAY_00));
				}
				if(StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getEnd_time())){
					insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date(vo.getSpecialExhibitionVo().getEnd_time()+ConstProp.DAY_23));
				}
			}
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		if(insInsuranceSlip.getSpecial_id() != null){
			specialExhibitionAPIService.accordingToTheSpecialExhibitionVoSetUpSpecialExhibition(vo.getSpecialExhibitionVo(), insInsuranceSlip.getSpecial_id());
		}
		if(insInsuranceSlip.getMailPolicy() != null){
			insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		}
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	/**
	 * 通过产品id查询统计保障责任的金额算出保险金额值
	 * @param pId
	 * @return
	 */
	@Override
	public BigDecimal setInsuredAmountByProductId(Long pId){
		BigDecimal result = BigDecimal.ZERO;
		List<ResponsibilityVo> irpVoList = insProductResponsibilityAPIService.findResponsibilityVoList(String.valueOf(pId));
		if(irpVoList.size()<=0){
			return result;
		}
		for(ResponsibilityVo vo : irpVoList){
			if(ConstProp.DIGIT_ONE.equals(vo.getType())){
				//保险金额算法
				if(StringUtils.isEmpty(vo.getFcy())){
					continue;
				}
				if(StringUtils.isNotEmpty(vo.getCompensation_days())){
					result = result.add((BigDecimal.valueOf(Double.parseDouble(vo.getFcy()))).multiply(BigDecimal.valueOf(Double.parseDouble("180"))));
				}else{
					result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())));
				}
			}else{
				//赔偿限额算法
				if(StringUtils.isNotEmpty(vo.getInsurance_amount_max())){
					result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getInsurance_amount_max())));
				}
			}
		}
		return result;
	}

	@Override
	public ResultDto pendingLOTEPolicyVoPolicy(LOTEPolicyVo vo, String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if (  userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = obtainLOTEPolicyVoSetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("雇主责任险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>根据订单id查询展责险信息设置到LOTEPolicyVo   GET METHOD</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public LOTEPolicyVo accordingToOrderIDToGetLOTEPolicyVo(Long order_id) {
		LOTEPolicyVo vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new LOTEPolicyVo();
		MailPolicyVo mpVo = new MailPolicyVo();
		SpecialExhibitionVo seVo = new SpecialExhibitionVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		if(insInsuranceSlip.getPlanned_end_date() != null){
			vo.setPlanned_end_date(DateUtil.convertDateToString(insInsuranceSlip.getPlanned_end_date(),DateUtil.FORMAT2));
		}
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),order_id));

		if(insInsuranceSlip.getSpecial_id() != null){
			specialExhibitionAPIService.getSpecialExhibitionVoByPolicyID(seVo, insInsuranceSlip.getSpecial_id());
		}
		vo.setSpecialExhibitionVo(seVo);
		if(insInsuranceSlip.getMailPolicy() != null){
			InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
			insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(mpVo, insMailPolicy);
		}
		vo.setMailPolicyVo(mpVo);
		return vo;
	}



	/****************************GYX*******************************/


	/**
	 * <b>个意险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public Map<String, Object> obtainGYXPolicyVoSetUp(GYXPolicyVo vo) {
		Map<String,Object> map = new HashMap<String,Object>();
		if(StrUtil.isBlank(vo.getOid())){
			return map;
		}
		try {
			log.info("个意险订单数据处理开始---------------------");
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			if(StringUtils.isNotEmpty(vo.getRecommend_code())){
				insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
			}
			insInsuranceSlip.setDispute(vo.getDispute());
			insInsuranceSlip.setArbitral_institution(vo.getArbitral_institution());
			if(StringUtils.isNotEmpty(vo.getInception_date())){
				insInsuranceSlip.setInception_date(DateUtil.convertString2Date(vo.getInception_date()+ConstProp.DAY_00));
				insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date(vo.getPlanned_end_date()+ConstProp.DAY_23));
			}
			vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
			insInsuranceSlip.setInsured_amount(setInsuredAmountByProductId(insInsuranceSlip.getPro_primary().getPro_primary_id()));
			int days = DateUtil.getDistDates(insInsuranceSlip.getInception_date(),insInsuranceSlip.getPlanned_end_date())+1;
			if(days > 0){
				insInsuranceSlip.setPremium(getPremiumByGYX(days));
			}
			insInsuranceSlipService.updateById(insInsuranceSlip);
			insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
			log.info("个意险订单人员更新数据库结束---------------------");
		}catch (Exception e){
			log.error("个意险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		map.put(ConstProp.ORDER_ID, String.valueOf(vo.getOid()));
		return map;
	}

	private BigDecimal getPremiumByGYX(int day){
		BigDecimal allPr = BigDecimal.ZERO;
		if(day==1){
			allPr = BigDecimal.valueOf(Double.parseDouble("10"));
		}else if(day>1&&day<8){
			allPr = BigDecimal.valueOf(Double.parseDouble("20"));
		}else if(day>7&&day<16){
			allPr = BigDecimal.valueOf(Double.parseDouble("30"));
		}else if(day>15&&day<31){
			allPr = BigDecimal.valueOf(Double.parseDouble("50"));
		}
		return allPr;
	}

	@Override
	public ResultDto pendingGYXPolicyVoPolicy(GYXPolicyVo vo, String recommendCode){
		try {
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if (  userdetail == null ) {
				return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
			}
			if(StringUtils.isEmpty(vo.getOid())){
				String orderId = getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode,vo.getSigId());
				if(StringUtils.isNotEmpty(orderId)){
					vo.setOid(orderId);
					if(StringUtils.isNotEmpty(vo.getSigId())){
						insInsuranceSlipService.updateOrderIdBySigId(orderId,vo.getSigId());
					}
				}else{
					return new ResultDto("订单初始化创建失败，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
			Map<String, Object> map = obtainGYXPolicyVoSetUp(vo);
			if(map != null){
				return new ResultDto("当前填写内容已经暂存，稍后您可在【我的账户-我的订单-投保中】 继续完成填写内容。", ConstProp.CODE_SUCCESS, String.valueOf(map.get(ConstProp.ORDER_ID)), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception e){
			log.error("个意险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new ResultDto("订单更新过程出现异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>根据订单id查询个意险信息设置到GYXPolicyVo   GET METHOD</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public GYXPolicyVo accordingToOrderIDToGetGYXPolicyVo(Long order_id) {
		GYXPolicyVo vo = null;
		if(StrUtil.isBlank(String.valueOf(order_id))){
			return vo;
		}
		vo = new GYXPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
			vo.setPlanned_end_date(DateUtil.convertDateToString(insInsuranceSlip.getPlanned_end_date(),DateUtil.FORMAT2));
		}
		vo.setDispute(insInsuranceSlip.getDispute());
		vo.setArbitral_institution(insInsuranceSlip.getArbitral_institution());
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),order_id));

		return vo;
	}

	@Override
	public String getArsPath(String sign){
		String result = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(sign)){
			result = comDeployConfigService.getValueByKey("PATH-"+sign);
		}
		return result;
	}


	@Override
	public String getArsPathWeb(String sign){
		String result = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(sign)){
			result = comDeployConfigService.getValueByKey("PATH-WEB-"+sign);
		}
		return result;
	}

	/**
	 * 平安寿险
	 * @return
	 */
	@Override
	public String pns_access_token() {
		String url=  GlobalResources.PNS_GET_ACCESS_TOKEN_URL;//环境一(TODO 生产用)
//		String url=  "https://test-api.pingan.com.cn:20443/oauth/oauth2/access_token?client_id=P_YYYYYYQQQQQ&grant_type=client_credentials&client_secret=G18GE5Gt";//环境一(TODO 测试用)
//		String url=  "https://test-api.pingan.com.cn:20443/oauth/oauth2/access_token?client_id=P_YYYYYYQQQQQ2&grant_type=client_credentials&client_secret=9r91THVc";//环境二(TODO 测试用)
		log.info("===========================PNS_GET_ACCESS_TOKEN_URL-START======================");
		String result= ConstProp.BLANK_CHAR;
		try {
			log.info("token获取地址："+url);
			result= RequestUtil.sendGet(url, null);
			log.info("token返回报文："+result);
			if(StringUtils.isEmpty(result)){
				return result;
			}
			JSONObject json= JSON.parseObject(result);
			String status=json.get("ret").toString();
			if("0".equals(status)){
				String data=json.getString("data");
				log.info("平安返回值："+data);
				JSONObject resultJson=JSONObject.parseObject(data);
				result = resultJson.getString("access_token");
				log.info("平安token值："+result);
				log.info("===========================PNS_GET_ACCESS_TOKEN_URL-END======================");
			}
		}catch (Exception ex){
			log.error("ACCESS_TOKEN",ex);
		}
		return result;
	}

	/**
	 * 平安财险
	 * @return
	 */
	@Override
	public String pnc_access_token() {
		String url=  GlobalResources.PNC_GET_ACCESS_TOKEN_URL;
		log.info("===========================PNC_GET_ACCESS_TOKEN_URL-START======================");
		String result= ConstProp.BLANK_CHAR;
		try {
			log.info("token获取地址："+url);
			result= RequestUtil.sendGet(url, null);
			log.info("token返回报文："+result);
			if(StringUtils.isEmpty(result)){
				return result;
			}
			JSONObject json= JSON.parseObject(result);
			String status=json.get("ret").toString();
			if(!"0".equals(status)){
				return result;
			}
			String data=json.getString("data");
			log.info("平安返回值："+data);
			JSONObject resultJson=JSONObject.parseObject(data);
			result = resultJson.getString("access_token");
			log.info("平安token值："+result);
			log.info("===========================PNC_GET_ACCESS_TOKEN_URL-END======================");
		}catch (Exception ex){
			log.error("ACCESS_TOKEN",ex);
		}
		return result;
	}

	/**
	 * <b> 查询已承保但未获取电子保单的订单，定时跑接口查询 </b>
	 * @author ZXF
	 * @create 2018/04/17 0017 16:21
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void gainDZBDByTiming(){
		log.info("查询已承保但未获取电子保单的订单：start");
		//1.查询已承保但是电子保单地址为空的记录
		List<OrderFormVo> list = new ArrayList<OrderFormVo>();
		List<OrderFormVo> o1List = insInsuranceSlipService.listOrderFormVoByDzbdIsNot(ConstProp.TYX_PAS);
		log.info("查询已承保但未获取电子保单的订单：TYX-PAS("+o1List.size()+")");
		for(OrderFormVo vo : o1List){
			HTTP_PAS_TYX_DZBD(Long.parseLong(vo.getOid()), null, vo);
		}
		List<OrderFormVo> o2List = insInsuranceSlipService.listOrderFormVoByDzbdIsNot(ConstProp.ZZX_PAC);
		log.info("查询已承保但未获取电子保单的订单：ZZX-PAC("+o2List.size()+")");
		for(OrderFormVo vo : o2List){
			HTTP_PAC_ZZX_DZBD(Long.parseLong(vo.getOid()));
		}
		List<OrderFormVo> o3List = insInsuranceSlipService.listOrderFormVoByDzbdIsNot(ConstProp.GZX_PAC);
		log.info("查询已承保但未获取电子保单的订单：GZX-PAC("+o3List.size()+")");
		for(OrderFormVo vo : o3List){
			HTTP_PAC_GZX_DZBD(Long.parseLong(vo.getOid()), null, vo);
		}
		List<OrderFormVo> o4List = insInsuranceSlipService.listOrderFormVoByDzbdIsNot(ConstProp.XYX_XWCK);
		log.info("查询已承保但未获取电子保单的订单：XYX-XWCK("+o4List.size()+")");
		for(OrderFormVo vo : o4List){
			HTTP_TPC_XYX_DZBD(Long.parseLong(vo.getOid()));
		}
		List<OrderFormVo> o5List = insInsuranceSlipService.listOrderFormVoByDzbdIsNot(ConstProp.BZX_YG_GCTB);
		log.info("查询已承保但未获取电子保单的订单：BZX-YG-GCTB("+o5List.size()+")");
		for(OrderFormVo vo : o5List){
			HTTP_YG_BUILD_DZBD(vo.getOid());
		}
		log.info("查询已承保但未获取电子保单的订单：end");
	}

	/**
	 * <b> 太保信用险，影像定时传输给保险公司接口调用业务 </b>
	 * @author ZXF
	 * @create 2018/04/28 0028 14:14
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void yxTimer(Long order_id){
		long  thrMM = 180000;   // 秒
		long  allTime = 3600000;   // 秒
		long bgTime = System.currentTimeMillis();
		boolean flag = false;
		int i = 0;
		while(true){
			long endTime = System.currentTimeMillis();
			long syTime = endTime-bgTime;
			if(syTime>=allTime){
				break;
			}
			//循环的时间必须小于1小时
			try {
				// 执行定时任务
				if(HTTP_TPC_XYX_YX(order_id)){
					flag = true;
					insInsuranceSlipService.updateIsSendYX(order_id);
					i = 1;
					break;
				}
				Thread.sleep(thrMM);
			} catch (Exception e) {
				if(flag){
					break;
				}
			}
		}
		if(i != 1){
			return;
		}
		try {
			boolean doF = false;
			for(int x=0;x<3;x++){
				if(!doF){
					Thread.sleep(240000);
					doF = HTTP_TPC_XYX_CB(order_id);
					/*if(doF){
						HTTP_TPC_XYX_DZBD(order_id);
					}*/
				}
			}
		} catch (Exception e) {

		}
	}

	/**
	 * <b> 雇主责任险-调用获取支付地址接口（人保支付链接只能维持2小时内支付，过期需要通过该方法重新获取支付链接） </b>
	 * @param order_id 订单id
	 * @author ZXF
	 * @create 2018/07/25 0025 14:22
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void payUrlChange(Long order_id) throws Exception {
		InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
		List<InsTransaction> tList = insTransactionService.selectInsTransactionByInsOrderForm(order_id);
		if(tList.size()<=0){
			return;
		}
		InsTransaction it = tList.get(0);
		//当前为实时请求，也可以增加下列注释做判断，超过1小时就重新获取下支付地址
		/*((new Date()).getTime()-it.getStart_time().getTime())/(1000*60*60)*/
		String result = gZZRX_RBRequestService.request_rb_gzzrx(order_id, "5", null);
		String[] strs = result.split(ConstProp.POUND_SIGN);
		if(!ConstProp.CODE_SUCCESS.equals(strs[0])||strs.length != 3) {
			return;
		}
		//更新支付地址
		it.setDeal_url(strs[2]);
		it.setStart_time(new Date());
		order.setNotice_no(strs[1]);
		insInsuranceSlipService.updateById(order);
		insTransactionService.updateById(it);
	}

	/**
	 * <b> 初始化交易信息，保存交易id和交易地址 </b>
	 * @author ZXF
	 * @create 2019/03/01 0001 17:06
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void payUrlChangeZHGZ(Long order_id,String payNo,String payUrl) throws Exception {
		if(order_id == null||StringUtils.isEmpty(payNo)||StringUtils.isEmpty(payUrl)){
			return;
		}
		InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
		InsTransaction  insTransaction = null;
		List<InsTransaction> insTransactionList = insTransactionService.selectInsTransactionByInsOrderForm(order_id);
		if(insTransactionList.size()>0){
			insTransaction = insTransactionList.get(0);
		}else{
			insTransaction = insTransactionService.initInsTransaction();
			insTransaction.setInsurance_slip(order);//订单id
		}
		insTransaction.setDeal_url(payUrl);
		insTransaction.setStart_time(new Date());
		order.setNotice_no(payNo);
		insInsuranceSlipService.updateById(order);
		insTransactionService.updateById(insTransaction);
	}

	/**
	 * <b> CA-初始化交易信息，保存支付号和交易地址 </b>
	 * @author ZXF
	 * @create 2019/10/28 0028 17:24
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void payUrlChangeCA(Long order_id,String payNo,String payUrl) throws Exception {
		if(order_id == null||StringUtils.isEmpty(payNo)||StringUtils.isEmpty(payUrl)){
			return;
		}
		InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
		InsTransaction  insTransaction = null;
		List<InsTransaction> insTransactionList = insTransactionService.selectInsTransactionByInsOrderForm(order_id);
		if(insTransactionList.size()>0){
			insTransaction = insTransactionList.get(0);
		}else{
			insTransaction = insTransactionService.initInsTransaction();
			insTransaction.setInsurance_slip(order);//订单id
		}
		insTransaction.setPay_order_number(payNo);
		insTransaction.setDeal_url(payUrl);
		insTransaction.setStart_time(new Date());
		insTransactionService.updateById(insTransaction);
	}

	/**
	 * <b> HT-初始化交易信息，保存支付号和交易地址 </b>
	 * @author ZXF
	 * @create 2019/10/28 0028 17:24
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void payUrlChangeHT(Long order_id,String payNo,String payUrl) throws Exception {
		if(order_id == null||StringUtils.isEmpty(payNo)||StringUtils.isEmpty(payUrl)){
			return;
		}
		InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
		InsTransaction  insTransaction = null;
		List<InsTransaction> insTransactionList = insTransactionService.selectInsTransactionByInsOrderForm(order_id);
		if(insTransactionList.size()>0){
			insTransaction = insTransactionList.get(0);
		}else{
			insTransaction = insTransactionService.initInsTransaction();
			insTransaction.setInsurance_slip(order);//订单id
		}
		insTransaction.setPay_order_number(payNo);
		insTransaction.setDeal_url(payUrl);
		insTransaction.setStart_time(new Date());
		insTransactionService.updateById(insTransaction);
	}

	/**
	 * <b> PAC-初始化交易信息，保存交易id和交易地址 </b>
	 * @author ZXF
	 * @create 2019/10/28 0028 17:24
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void payUrlChangePAC(Long order_id,String tranNo,String payUrl) throws Exception {
		if(order_id == null||StringUtils.isEmpty(tranNo)||StringUtils.isEmpty(payUrl)){
			return;
		}
		InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
		InsTransaction  insTransaction = null;
		List<InsTransaction> insTransactionList = insTransactionService.selectInsTransactionByInsOrderForm(order_id);
		if(insTransactionList.size()>0){
			insTransaction = insTransactionList.get(0);
		}else{
			insTransaction = insTransactionService.initInsTransaction();
			insTransaction.setInsurance_slip(order);//订单id
		}
		insTransaction.setTrade_serial_number(tranNo);
		insTransaction.setDeal_url(payUrl);
		insTransaction.setStart_time(new Date());
		insTransactionService.updateById(insTransaction);
	}

	@Override
	public String zzx_amount_count(String productCode, String exAcreage) {
		String result = "";
		if(StringUtils.isEmpty(productCode)||StringUtils.isEmpty(exAcreage)){
			return "300#必要参数不能为空！";
		}
		Double ead = Double.valueOf(exAcreage);
		if("ZZX-PAC-1".equals(productCode)){
			if(0<ead && ead<37){
				result = "200#180.00";
			}else{
				result = "300#该方案展位总面积在1~36平米之间！";
			}
		}else if("ZZX-PAC-2".equals(productCode)){
			if(0<ead && ead<37){//1-37
				result = "200#240.00";
			}else if(36<ead && ead<101){//38-100
				result = "200#340.00";
			}else{
				result = "300#该方案展位总面积在1~100平米之间！";
			}
		}else if("ZZX-PAC-3".equals(productCode)){
			if(0<ead && ead<37){//<37
				result = "200#300.00";
			}else if(36<ead && ead<101){//37-100
				result = "200#400.00";
			}else if(ead>100){//>100
				result = "200#490.00";
			}else{
				result = "300#展位总面积在1平米以上！";
			}
		}else if("ZZX-YA-1".equals(productCode)){
			if(0<ead && ead<37){//<37
				result = "200#200.00";
			}else if(36<ead && ead<109){//37-100
				result = "200#280.00";
			}else if(108<ead && ead<217){//>100
				result = "200#380.00";
			}else if(ead>216){//>100
				int _y = (Integer.parseInt(exAcreage)-216)%108>0?1:0;
				result = "200#"+String.valueOf(380 + (((Integer.parseInt(exAcreage)-216)/108) + _y)*30)+".00";
			}else{
				result = "300#展位总面积在1平米以上！";
			}
		}else if("ZZX-YA-2".equals(productCode)){
			if(0<ead && ead<37){//<37
				result = "200#260.00";
			}else if(36<ead && ead<109){//37-100
				result = "200#360.00";
			}else if(108<ead && ead<217){//>100
				result = "200#470.00";
			}else if(ead>216){//>100
				int _y = (Integer.parseInt(exAcreage)-216)%108>0?1:0;
				result = "200#"+String.valueOf(470 + (((Integer.parseInt(exAcreage)-216)/108) + _y)*30)+".00";
			}else{
				result = "300#展位总面积在1平米以上！";
			}
		}else if("ZZX-YA-3".equals(productCode)){
			if(0<ead && ead<37){//<37
				result = "200#330.00";
			}else if(36<ead && ead<109){//37-100
				result = "200#430.00";
			}else if(108<ead && ead<217){//>100
				result = "200#520.00";
			}else if(ead>216){//>100
				int _y = (Integer.parseInt(exAcreage)-216)%108>0?1:0;
				result = "200#"+String.valueOf(520 + (((Integer.parseInt(exAcreage)-216)/108) + _y)*30)+".00";
			}else{
				result = "300#展位总面积在1平米以上！";
			}
		}else if("ZZX-HT-1".equals(productCode)){
			if(0<ead && ead<37){//<37
				result = "200#200.00";
			}else if(36<ead && ead<101){//37-100
				result = "200#300.00";
			}else if(ead>100){//>100
				result = "200#400.00";
			}else{
				result = "300#展位总面积在1平米以上！";
			}
		}else if("ZZX-HT-2".equals(productCode)){
			if(0<ead && ead<37){//<37
				result = "200#260.00";
			}else if(36<ead && ead<101){//37-100
				result = "200#360.00";
			}else if(ead>100){//>100
				result = "200#460.00";
			}else{
				result = "300#展位总面积在1平米以上！";
			}
		}else if("ZZX-HT-3".equals(productCode)){
			if(0<ead && ead<37){//<37
				result = "200#330.00";
			}else if(36<ead && ead<101){//37-100
				result = "200#430.00";
			}else if(ead>100){//>100
				result = "200#530.00";
			}else{
				result = "300#展位总面积在1平米以上！";
			}
		}else if("ZZX-CA-1".equals(productCode)){
			if(0<ead && ead<100){//1-37
				result = "200#180.00";
			}else{
				result = "300#该方案展位总面积在1~100平米之间！";
			}
		}else{
			if(!productCode.contains(ConstProp.ZZX_ZA)){
				return "300#未匹配到对应产品！";
			}
			if(0>=ead || ead>=109){
				return "300#展位总面积在1~108平米之间！";
			}
			if(ConstProp.ZZX_ZA_1.equals(productCode)){
				result = "200#450.00";
			}else if(ConstProp.ZZX_ZA_2.equals(productCode)){
				result = "200#500.00";
			}else if(ConstProp.ZZX_ZA_3.equals(productCode)){
				result = "200#600.00";
			}else{
				result = "300#未匹配到对应产品！";
			}
		}
		return result;
	}

	/**
	 * <b> 根据保单号设置发票记录表中的电子发票地址信息 </b>
	 * @author ZXF
	 * @create 2019/09/29 0029 14:42
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void updateUrlByExternalreference(String url, String externalreference){
		insMailPolicyService.updateUrlByExternalreference(url, externalreference);
	}

	/**
	 * <b> 当订单待支付时客户要下载保障人员名单 </b>
	 * @author ZXF
	 * @create 2019/11/07 0007 14:35
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void downSecurityPersonnel(Long oid, HttpServletResponse resp){
		OrderFormVo orderVo = accordingToOrderIDToGetPolicyDto(oid);
		if(orderVo == null||StringUtils.isEmpty(orderVo.getPolicy_serial_number())){
			return;
		}
		String fileName = orderVo.getTrade_serial_number()+"-保障人员.xls";
		try {
			fileName = new String(fileName.getBytes("gb2312"), "ISO8859-1");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		com.bcxin.ins.util.excel.ExcelUtil<ResultSetExcelVo> util = new com.bcxin.ins.util.excel.ExcelUtil(ResultSetExcelVo.class);
		resp.setContentType("application/vnd.ms-excel");
		resp.setHeader("Content-Disposition",
				"attachment;fileName=" + fileName);
		try(OutputStream os = resp.getOutputStream()) {
			List<ResultSetExcelVo> voList = null;
			if(orderVo.getProduct_code().contains(ConstProp.GZZRX)){
				voList = hirelingAPIService.selectHirelingListByOrderID(oid);
			}else if(orderVo.getProduct_code().contains(ConstProp.TYX)){
				voList = insRoleInpolicyService.selectRoleInPolicyListByOrderID(oid);
			}
			if(voList != null&&voList.size() > 0){
				util.exportExcel(voList, orderVo.getTrade_serial_number()+"保障人员", 65535, os);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b> 保险到期发送邮件 </b>
	 * @author ZXF
	 * @create 2020/03/17 0017 14:06
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void policyExpireInform(){
		//保单到期前一个月/15天/3天
		String aDay = DateUtil.formatDate(DateUtils.addMonths(new Date(),1),"yyyy-MM-dd");//一个月
		String bDay = DateUtil.formatDate(DateUtils.addDays(new Date(),15),"yyyy-MM-dd");//15天
		String cDay = DateUtil.formatDate(DateUtils.addDays(new Date(),3),"yyyy-MM-dd");//3天
		List<Map<String, Object>> bList = insInsuranceSlipService.findMaturingPolicy(aDay, bDay, cDay);
		//保单到期之日
		String dDay = DateUtil.formatDate(new Date(),"yyyy-MM-dd");//当天
		List<Map<String, Object>> tList = insInsuranceSlipService.findMaturingPolicy(dDay, "", "");
		EmailModel em;
		for(Map<String,Object> map : bList){
			if(StringUtils.isNotEmpty(String.valueOf(map.get("email")))){
				em = new EmailModel(
						EmailMsgType.BD_JJ_DQ
						,String.valueOf(map.get("productName"))
						,String.valueOf(map.get("perNum"))
						,String.valueOf(map.get("external_reference"))
						,String.valueOf(map.get("planned_end_date")));
				em.addTo(String.valueOf(map.get("email")));
				log.info("保险到期邮件发送，PARAM："+JSON.toJSONString(em));
				SendEmailAndMsgUtil.sendEmail(em);
			}
		}
		for(Map<String,Object> map : tList){
			if(StringUtils.isNotEmpty(String.valueOf(map.get("email")))){
				em = new EmailModel(
						EmailMsgType.BD_DQ
						,String.valueOf(map.get("productName"))
						,String.valueOf(map.get("perNum"))
						,String.valueOf(map.get("external_reference"))
						,String.valueOf(map.get("planned_end_date")));
				em.addTo(String.valueOf(map.get("email")));
				log.info("保险到期邮件发送，PARAM："+JSON.toJSONString(em));
				SendEmailAndMsgUtil.sendEmail(em);
			}
		}
	}

	/**
	 * <b> 通过人员身份证查询保单记录 </b>
	 * @author ZXF
	 * @create 2020/06/24 0024 16:11
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<Map<String,Object>> orderList(String idCardNo){
		return insInsuranceSlipService.orderList(idCardNo);
	}

	/**
	 * <b> 做批单时，检索生效时间是否是到期时间当天 </b>
	 * @author ZXF
	 * @create 2020/09/07 0007 9:50
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public int isDueToByPolicy(Long orderId,String inception_date){
		if(orderId==null || StringUtils.isEmpty(inception_date)){
			return 1;
		}
		return insInsuranceSlipService.isDueToByPolicy(orderId,inception_date);
	}

	/**
	 * <b> 上传缴费凭证发送邮件通知 </b>
	 * @param orderId 订单id
	 * @param payUrl 凭证地址
	 * @author ZXF
	 * @create 2021/10/28 0028 17:24
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void JFPZ_SendEmail(Long orderId, String payUrl) {
		String[] arrs = comDeployConfigService.getValueByKey("JFPZ_EMAIL").split(ConstProp.SEMICOLON);
		OrderFormVo dto = accordingToOrderIDToGetPolicyDto(orderId);
		EmailModel emailModel = new EmailModel(EmailMsgType.BD_JFPZ
				, dto.getProduct_name()
				, dto.getApplicant_name()
				, payUrl, dto.getTrade_serial_number()
				, dto.getPolicy_serial_number(), dto.getInception_date()+"~"+dto.getPlanned_end_date(), dto.getGross_premium());
		List<String> emailList = new ArrayList<String>();
		for(int i=0;i<arrs.length;i++){
			String[] eArr = arrs[i].split(ConstProp.COLON);
			if(StringUtils.isNotEmpty(arrs[i])){
				if(eArr.length==1){
					emailList.add(eArr[0].trim());
				}else if(eArr.length==2){
					if(StringUtils.isNotEmpty(eArr[1])&&StringUtils.isNotEmpty(dto.getProduct_code())&& dto.getProduct_code().contains(eArr[1])){
						emailList.add(eArr[0].trim());
					}
				}
			}
		}
		if(emailList.size()>0){
			emailModel.setTo(emailList);
			SendEmailAndMsgUtil.sendEmail(emailModel);
		}
	}

	/**
	 * <b> 订单复制，只有待支付才有此功能 </b>
	 * @author ZXF
	 * @create 2019/08/14 0014 11:33
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public ResultDto copyPolicy(Long orderID){
		OrderFormVo orderVo = accordingToOrderIDToGetPolicyDto(orderID);
		if(orderVo == null || StringUtils.isEmpty(orderVo.getProduct_code())){
			return new ResultDto("订单不存在！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(ConstProp.XYX_DQCK.equals(orderVo.getProduct_code())){
			return new ResultDto("短期出口险不支持复制功能！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		//订单编号
		Long tNumber = idWorker.nextId();
		//订单id
		Long pId = idWorker.nextId();
		//特殊字段id
		Long sId = idWorker.nextId();
		//发票id
		Long mId = idWorker.nextId();
		//公共
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		Long oldSpecial_id = insInsuranceSlip.getSpecial_id();

		insMailPolicy.setIns_mail_policy_id(mId);
		insInsuranceSlip.setIns_insurance_slip_id(pId);
		insInsuranceSlip.setTrade_serial_number(String.valueOf(tNumber));
		insInsuranceSlip.setMailPolicy(insMailPolicy);
		insInsuranceSlip.setUnderwrite(null);
		insInsuranceSlip.setPolicy_serial_number(ConstProp.BLANK_CHAR);
		insInsuranceSlip.setSigned_date(new Date());
		insInsuranceSlip.setCreate_time(new Date());
		insInsuranceSlip.setStart_time(new Date());
		insInsuranceSlip.setEnd_time(null);
		insInsuranceSlip.setNotice_no(null);
		insInsuranceSlip.setInsure_path(null);
		//投保中
		insInsuranceSlip.setOrder_status(DictConst.ORDER_STATUS_TBZ);

		Map<String,Object> columnMap = Maps.newHashMap();
		columnMap.put("insurance_slip_id", orderID);
		List<InsRoleInpolicy> roleList = insRoleInpolicyService.selectByMap(columnMap);
		for(InsRoleInpolicy role : roleList){
			role.setIns_role_inpolicy_id(idWorker.nextId());
			role.setInsurance_slip(insInsuranceSlip);
		}
		insMailPolicyService.insert(insMailPolicy);
		insRoleInpolicyService.insertBatch(roleList);
		if(orderVo.getProduct_code().contains(ConstProp.GZZRX)){
			//雇主
			columnMap = Maps.newHashMap();
			columnMap.put("ins_insurance_slip_id", orderID);
			List<Hireling> hirelingList = hirelingAPIService.selectByMap(columnMap);
			for(Hireling hireling : hirelingList){
				hireling.setHireling_id(idWorker.nextId());
				hireling.setIns_insurance_slip_id(pId);
			}
			hirelingAPIService.insertBatch(hirelingList);
		}else if(orderVo.getProduct_code().contains(ConstProp.ZZX)){
			insInsuranceSlip.setSpecial_id(sId);
			//展责
			SpecialExhibition specialExhibition = specialExhibitionAPIService.selectById(oldSpecial_id);
			specialExhibition.setSpecial_exhibition_id(sId);
			specialExhibitionAPIService.insert(specialExhibition);
		}else if(orderVo.getProduct_code().contains(ConstProp.GZX)){
			insInsuranceSlip.setSpecial_id(sId);
			//公责
			SpecialPublicDuty specialPublicDuty = specialPublicDutyService.selectById(oldSpecial_id);
			specialPublicDuty.setSpecial_public_duty_id(sId);
			specialPublicDutyService.insert(specialPublicDuty);
		}else if(orderVo.getProduct_code().contains(ConstProp.GCLY)){
			insInsuranceSlip.setSpecial_id(sId);
			//履约
			SpecialPerformance insSpecialPerformance = insSpecialPerformanceService.selectById(oldSpecial_id);
			insSpecialPerformance.setSpecial_performance_id(sId);
			insSpecialPerformanceService.insert(insSpecialPerformance);
		}else if(orderVo.getProduct_code().contains(ConstProp.GCTB)){
			insInsuranceSlip.setSpecial_id(sId);
			//投标
			SpecialBid insSpecialBid = insSpecialBidService.selectById(oldSpecial_id);
			insSpecialBid.setSpecial_bid_id(sId);
			insSpecialBidService.insert(insSpecialBid);
		}else if(orderVo.getProduct_code().contains(ConstProp.XYX_XWCK)){
			insInsuranceSlip.setSpecial_id(sId);
			//小微
			SpecialCreditMicro insMicroExport = insMicroExportService.selectById(oldSpecial_id);
			insMicroExport.setSpecial_credit_micro_id(sId);
			insMicroExportService.insert(insMicroExport);
		}else if(orderVo.getProduct_code().contains(ConstProp.BZX_SSBQ)){
			insInsuranceSlip.setSpecial_id(sId);
			//诉讼
			SpecialLitigation specialLitigation = specialLitigationService.selectById(oldSpecial_id);
			columnMap = Maps.newHashMap();
			columnMap.put("special_litigation_id", specialLitigation.getSpecial_litigation_id());
			List<LnAccused> lnAccusedList = lnAccusedAPIService.selectByMap(columnMap);
			specialLitigation.setSpecial_litigation_id(sId);
			for(LnAccused lnAccused : lnAccusedList){
				lnAccused.setLn_accused_id(idWorker.nextId());
				lnAccused.setSpecial_litigation(specialLitigation);
			}
			specialLitigationService.insert(specialLitigation);
			lnAccusedAPIService.insertBatch(lnAccusedList);
		}
		insInsuranceSlipService.insert(insInsuranceSlip);
		return new ResultDto("订单复制成功!订单编号："+tNumber, ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
	}

	/**
	 * <b> 创建订单推送任务 </b>
	 * 将新增保单、批改、退保拆分成订单推送给商城
	 * @param orderId 订单ID、批单ID
	 * @param type 类型：1.批改 2.新增保单 3.退保
	 * @param inceptionDate 开始时间 退保时必填，其它都能查到
	 * @author ZXF
	 * @create 2023/08/30 0030 11:15
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public boolean createSendOrderTask(Long orderId,int type,String inceptionDate){
		if(type==1){
			//批改业务
			InsPreservationRecordVo iprVo = insPreservationRecordAPIService.findInsPreservationRecordVoById(orderId);
			OrderFormVo vo = accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
			InsRoleInpolicy role = insRoleInpolicyService.getInsRoleInpolicyListByIDAndKind(Long.parseLong(iprVo.getIns_insurance_slip_id()), "1").get(0);
			List<InsPreservationDetailVo> dList = iprVo.getInsPreservationDetailVoList();
			String spercs = vo.getProduct_code()+"-"+(Integer.parseInt(vo.getIs_contain_repo())+1);
			String mrPremium = iprVo.getTotal_premium();
			if(ConstProp.DIGIT_THIRTEEN.equals(iprVo.getRevise_type())){
				mrPremium = "0";//替换业务保费默认0
			}
			createParem(iprVo.getRevise_serial_num_ins(),spercs,mrPremium,String.valueOf(dList.size()),role.getReg_district(),role.getOrganization_code(),"1");
		}else{
			OrderFormVo vo = accordingToOrderIDToGetPolicyDto(orderId);
			InsRoleInpolicy role = insRoleInpolicyService.getInsRoleInpolicyListByIDAndKind(Long.parseLong(vo.getOid()), "1").get(0);
			List<InsPreservationResultSet> list = insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null,orderId,"","0","","");
			String spercs = vo.getProduct_code()+"-"+(Integer.parseInt(vo.getIs_contain_repo())+1);
			//保单业务
			if(type==2){
				createParem(vo.getExternal_reference(),spercs,vo.getGross_premium(),String.valueOf(list.size()),role.getReg_district(),role.getOrganization_code(),"0");
			}else{
				if(StringUtils.isEmpty(inceptionDate)){
					throw new RuntimeException("退保业务需要录入生效日期");
				}
				//退保
				int syDay = DateUtil.getDistDates(DateUtil.convertStringToDate(inceptionDate),DateUtil.convertStringToDate(vo.getPlanned_end_date()))+1;
				int tolDay = DateUtil.getDistDates(DateUtil.convertStringToDate(vo.getInception_date()),DateUtil.convertStringToDate(vo.getPlanned_end_date()))+1;
				BigDecimal liDay = BigDecimal.valueOf(1).subtract(BigDecimal.valueOf(syDay).divide(BigDecimal.valueOf(tolDay),10, BigDecimal.ROUND_HALF_UP).setScale(6, BigDecimal.ROUND_HALF_UP));
				String mrPremium = BigDecimal.valueOf(Double.parseDouble(vo.getPremium())).multiply(BigDecimal.valueOf(list.size())).multiply(liDay).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
				createParem(vo.getExternal_reference()+"T",spercs,"-"+mrPremium,String.valueOf(list.size()),role.getReg_district(),role.getOrganization_code(),"1");
			}
		}
		return true;
	}

	/**
	 * <b>  </b>
	 * @param orderNo 单号
	 * @param spercs 规格
	 * @param premium 保费
	 * @param num 天数
	 * @param district 区编码
	 * @param identityCardNo 企业识别号
	 * @param insuranceType 保费类型
	 * @author ZXF
	 * @create 2023/08/30 0030 14:00
	 * @version
	 * @注意事项 </b>
	 */
	private void createParem(String orderNo,String spercs,String premium,String num,String district,String identityCardNo,String insuranceType){
		ImportInsuranceOrderRequest oRequest = new ImportInsuranceOrderRequest(orderNo,"",district,num,premium,spercs,identityCardNo,insuranceType);
		//加入任务
		comTaskResidualAPIService.saveComTaskResidual("sendOrderToShop","保险订单推送商城","com.bcxin.ins.service.order.PolicyService",1,"com.bcxin.ins.vo.shop.ImportInsuranceOrderRequest", JSON.toJSONString(oRequest));
	}

	/**
	 * <b> 订单人员相关信息推送给商城 </b>
	 * @author ZXF
	 * @create 2023/08/31 0031 9:31
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public boolean sendOrderToShop(ImportInsuranceOrderRequest oRequest){
		String token = "";
		try{
			token = TokenUtils.generateToken("sourceId",oRequest.getSourceId());
		}catch (Exception e){
			e.printStackTrace();
		}
		oRequest.setVerify(token);
		//导入保险订单(无实际支付，只为了分销分佣)
		String url = GlobalResources.map.get("SHOP_URL")+"/api/front/order/import/insurance";
		log.info("=========> sendOrderToShop 订单推送商城 URL："+url);
		String reqStr = JSON.toJSONString(oRequest);
		log.info("=========> sendOrderToShop 订单推送商城 param："+reqStr);
		String ret = com.xiaoleilu.hutool.http.HttpUtil.post(url,reqStr);
		log.info("=========> sendOrderToShop 订单推送商城 ret："+ret);
		ShopResult r = JSON.parseObject(ret, ShopResult.class);
		if("200".equals(r.getCode())){
			if(StringUtils.isNotEmpty(r.getData())){
				return true;
			}
		}
		log.error("=========> sendOrderToShop 订单推送商城异常："+r.getMessage());
		if(r.getMessage().contains("订单已存在")){
			return true;
		}
		return false;
	}

}
