package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsAreaAPIDao;
import com.bcxin.ins.service.order.InsAreaAPIService;
import com.bcxin.ins.dto.CountryDto;
import com.bcxin.ins.entity.tpost.TposArea;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional(readOnly = true)
public class InsAreaAPIServiceImpl extends ServiceImpl<InsAreaAPIDao, TposArea> implements InsAreaAPIService {


	@Autowired
	private InsAreaAPIDao dao;
	/**
	 * <b>根据国家去 InsArea表查询获取到CountryCode</b> 
	 * 
	 * @param country
	 * @return
	 * @author ZXF 
	 * @date 2017年1月19日 上午11:19:10
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String accordingToCountryGainCountryCode(String country){
		return dao.accordingToCountryGainCountryCode(country);
	}


	@Override
	public List<CountryDto> getCountryList() {
		List<String>  list= dao.getCountryList();
		List<CountryDto>  clist= new ArrayList<>();
		for (String str:list){
			CountryDto dto= new CountryDto();
			dto.setValue(str);
			clist.add(dto);
		}
		return clist;
	}
}
