package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.ComTaskUnSeeFeeRecordAPIDao;
import com.bcxin.ins.service.order.ComTaskUnSeeFeeRecordAPIService;
import com.bcxin.ins.entity.common.ComTaskUnSeeFeeRecord;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ComTaskUnSeeFeeRecordAPIServiceImpl extends ServiceImpl<ComTaskUnSeeFeeRecordAPIDao, ComTaskUnSeeFeeRecord> implements ComTaskUnSeeFeeRecordAPIService {

    @Autowired
    private ComTaskUnSeeFeeRecordAPIDao dao;

    private Logger log =  LoggerFactory.getLogger(ComTaskUnSeeFeeRecordAPIServiceImpl.class);


    /**
     * <b> 核保返回报文添加到未见费核保记录表 </b>
     * @param appno 投保单号
     * @param polno 保单号
     * @param eurl 电子保单地址
     * @author ZXF
     * @create 2019/06/17 0003 11:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public void saveComTaskUnSeeFeeRecord(String appno, String polno, String eurl) {
        ComTaskUnSeeFeeRecord ctr = new ComTaskUnSeeFeeRecord(appno,polno,eurl);
        new Thread(()->{
            try {
                dao.insert(ctr);
            }catch (Exception e){
                e.printStackTrace();
            }
        }).start();
    }
}
