package com.bcxin.ins.service.order;


import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.service.IService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


public interface InsInsuranceSlipAPIService extends IService<InsInsuranceSlip> {

	public InsInsuranceSlip selectById(Long oid);

	public InsInsuranceSlip packagingInsInsuranceSlip(Long oid);

	public InsurePolicyVo willInsInsuranceSlipChangeIntoInsurePolicyVo(Long insInsuranceSlip_id);

	public void getInsuredAmountSetToInsInsuranceSlip(BigDecimal insuredAmount, InsInsuranceSlip iis);

	public void accordingToOrderIDCreatePolicySerialNumber(InsInsuranceSlip insInsuranceSlip);




	public InsInsuranceSlip getInsOrderForm(Long oid);

	public InsInsuranceSlip getInsOrderForm(String tradeSerialNumber);

	public InsInsuranceSlip packagingInsOrderForm(Long oid);

	public InsInsuranceSlip initOrderForm(Long poductID,Long user_id,String recommendCode,String trade_serial_number);

	public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatus(Long user_id, String status, DwzPage page);

	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(InsOrderSearchVo search);

	public List<OrderFormVo> listOrderFormVoByDzbdIsNot(String productCode);

	public List<OrderFormVo> selectInsOrderFormByStatusAndProductCode( String status, String productCode);

	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusListSetUpOrderFormVo(Long user_id, List<String> statusList, String productType, String keyword, String starDate, String endDate, DwzPage page);

	public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatusList(Long user_id, List<String> statusList, DwzPage page);

	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, DwzPage page);
//	public List<OrderFormVo> selectInsOrderFormByStatusAndProductCode( String status, String productCode);

	public OrderFormVo willInsOrderFormSetUpOrderFormVo(InsInsuranceSlip order);

	public OrderStatusCountVo selectOrderStatusCountVoByUserID(InsOrderSearchVo searchVo);

	/**
	 * <b> 根据保单号和被保险人姓名查询订单 </b>
	 * @author ZXF
	 * @create 2019/09/05 0005 17:53
	 * @version
	 * @注意事项 </b>
	 */
	Map selectOrderByExAndName(String external_reference, String name);

	public String updateOrderFormStatus(OrderFormVo vo);

	public List<InsInsuranceSlip> findAllInsOrderList(String sql);

	public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id);

	public AdviceNoteVo willInsOrderFormSetUpAdviceNoteVo(InsInsuranceSlip order);

	public void updateOrderUnderwriting(OrderFormVo vo);

	public OrderFormVo findOrderFormVoByID(Long orderId);

	public boolean getInsInsuranceSlipBySpecialId(Long special_id);

	/**
	 * 根据投保单号获取OrderFormVo
	 * @param rcptNo
	 * @return
	 */
	public OrderFormVo getOrderFormVoByRcptNo( String rcptNo);

	public OrderFormVo getOrderFormVoByTradeSerialNumber( String tsNumber);

	public OrderFormVo getOrderFormVoByNoticeNo( String noticeNo);

	public void replenishOrderFormVo(OrderFormVo vo);

	public void setPremiumAndCoverageByOrderID(InsInsuranceSlip insInsuranceSlip);

	public OrderFormVo findPolicyByExternalAndRoleName(String externalRefernce, String roleName);

	public boolean updateIsSendYX(Long order_id);

	/**
	 * <b> 设置是否见费 </b>
	 * @author ZXF
	 * @create 2020/04/10 0010 10:55
	 * @version
	 * @注意事项 </b>
	 */
	boolean updateIsPolicyBeforePayFee(int isPayFee, Long order_id);

	boolean addRemarksByOrder(String remarks, Long order_id);

	public String getProductCode(Long order_id);

	public List<String> selectOrderIdByProductCode(String product_code);

	/**
	 * <b> 查询将到期保单，第一个日期参数必传 </b>
	 * @author ZXF
	 * @create 2019/04/01 0001 13:51
	 * @version
	 * @注意事项 </b>
	 */
	public List<Map<String,Object>> findMaturingPolicy(String aDay, String bDay, String cDay);

	public List<Map<String,String>> findZBNumByPolicyNos(String policyNos);

	/**
	 * <b> 查询平安财雇主的保单号列 </b>
	 * @author ZXF
	 * @create 2020/04/27 0027 11:21
	 * @version
	 * @注意事项 </b>
	 */
	public List<String> findPolicyNosByPACGZZRX(Long userId);

	public List<String> findPolicyNosByCAGZZRX(Long userId);

	public Long getIdByPolicyNo(String policyNo);

	/**
	 * <b> 通过人员身份证查询保单记录 </b>
	 * @author ZXF
	 * @create 2020/06/24 0024 16:11
	 * @version
	 * @注意事项 </b>
	 */
	public List<Map<String,Object>> orderList(String idCardNo);

	/**
	 * <b> 做批单时，检索生效时间是否是到期时间当天 </b>
	 * @author ZXF
	 * @create 2020/09/07 0007 9:50
	 * @version
	 * @注意事项 </b>
	 */
	int isDueToByPolicy(Long orderId,String inception_date);

	/**
	 * <b> 根据保单号获取回溯记录 </b>
	 * @author ZXF
	 * @create 2024/03/04 0004 10:01
	 * @version
	 * @注意事项 </b>
	 */
	List<Map<String,String>> findOperationRecordByExNo(String exNo);

	/**
	 * <b> 投保操作记录保存 </b>
	 * @author ZXF
	 * @create 2021/06/16 0016 17:03
	 * @version
	 * @注意事项 </b>
	 */
	int saveInsOperationRecord(String order_id, String sig_id, String operation_type, String path);

	/**
	 * <b> 操作记录更新订单id </b>
	 * @author ZXF
	 * @create 2021/06/16 0016 17:03
	 * @version
	 * @注意事项 </b>
	 */
	int updateOrderIdBySigId(String order_id, String sig_id);

	/**
	 * <b> 已承保订单设置来源标识（其它第三方平台录入线下保单并标识来源为百联保的才触发这个更新） </b>
	 * @author ZXF
	 * @create 2021/06/16 0016 17:03
	 * @version
	 * @注意事项 </b>
	 */
	int updateWebTypeByEx(String policyNo, String webType);
}
